//! \file sm_config.h

#ifndef SMCONFIG_H
#define SMCONFIG_H

#include "sm3_widgets.h"
#include "sm3_font.h"
#include "sm3_color.h"
#include "sm3_temps.h"
#include "version.h"

#include "sysmon3.h"
//! \brief Provide the top level window for user configuration

/*! \class SM_Config
           This class provides the top level window for user configuration.
           It allows customization of the user's display instance.
           It also provides pushbuttons for access to widgets to configure 
           desired temperature items and the user's font and color preferences.
*/
class SM_Config : public QFrame
{
  Q_OBJECT

public:

   SM_Config( SM_Settings* , QString, QRect );
   ~SM_Config() {};

private:
   SM_Settings* settingsPtr;
   QString      data;
   SM_Widgets*  widgetsPtr;
   QRect        parentGeom;

   QLabel*      version;
   QLabel*      lbl_refresh;
   QLabel*      lbl_font;
   QLabel*      lbl_color;
   QLabel*      lbl_temps;

   QPushButton* pb_font;
   QPushButton* pb_color;
   QPushButton* pb_temps;
   QPushButton* pb_exit;
   
   // Help pushbuttons
   QPushButton* PBrefresh;
   QPushButton* PBtime;
   QPushButton* PBdate;
   QPushButton* PBuptime;
   QPushButton* PBcpu;
   QPushButton* PBmemory;
   QPushButton* pb_apply;

   QCheckBox*   CBtime;
   QCheckBox*   CBdate;
   QCheckBox*   CBuptime;
   QCheckBox*   CBcpu;
   QCheckBox*   CBcpuBar;
   QCheckBox*   CBmemory;

   QSpinBox*    SBrefresh;

   QLineEdit*   LEtime;
   QLineEdit*   LEdate;

   void         update_local( void );
   void         msg_box     ( QString*, int );
   QString      bool2string ( bool );

   QStringList  sensors;  // <Interface,Device>

private slots:

  void update_font  ( void );
  void update_colors( void );
  void update_temps ( void );
  void refresh_help ( void );
  void time_help    ( void );
  void date_help    ( void );
  void uptime_help  ( void );
  void cpu_help     ( void );
  void memory_help  ( void );

public slots:
   void sendFonts();
   void sendColors();
   void sendTemps();
   void apply();

signals:
   void updateFonts   ( void );
   void updateColors  ( void );
   void updateTemps   ( void );
   void updateEntries ( void );
};
#endif
