/* Copyright 2022 - 2024 R. Thomas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_ASM_RISCV_REGISTER_H
#define LIEF_ASM_RISCV_REGISTER_H
namespace LIEF {
namespace assembly {
namespace riscv {
enum class REG;
const char* get_register_name(REG r);

enum class REG {
  NoRegister = 0,
  FFLAGS = 1,
  FRM = 2,
  SSP = 3,
  VCIX_STATE = 4,
  VL = 5,
  VLENB = 6,
  VTYPE = 7,
  VXRM = 8,
  VXSAT = 9,
  DUMMY_REG_PAIR_WITH_X0 = 10,
  V0 = 11,
  V1 = 12,
  V2 = 13,
  V3 = 14,
  V4 = 15,
  V5 = 16,
  V6 = 17,
  V7 = 18,
  V8 = 19,
  V9 = 20,
  V10 = 21,
  V11 = 22,
  V12 = 23,
  V13 = 24,
  V14 = 25,
  V15 = 26,
  V16 = 27,
  V17 = 28,
  V18 = 29,
  V19 = 30,
  V20 = 31,
  V21 = 32,
  V22 = 33,
  V23 = 34,
  V24 = 35,
  V25 = 36,
  V26 = 37,
  V27 = 38,
  V28 = 39,
  V29 = 40,
  V30 = 41,
  V31 = 42,
  X0 = 43,
  X1 = 44,
  X2 = 45,
  X3 = 46,
  X4 = 47,
  X5 = 48,
  X6 = 49,
  X7 = 50,
  X8 = 51,
  X9 = 52,
  X10 = 53,
  X11 = 54,
  X12 = 55,
  X13 = 56,
  X14 = 57,
  X15 = 58,
  X16 = 59,
  X17 = 60,
  X18 = 61,
  X19 = 62,
  X20 = 63,
  X21 = 64,
  X22 = 65,
  X23 = 66,
  X24 = 67,
  X25 = 68,
  X26 = 69,
  X27 = 70,
  X28 = 71,
  X29 = 72,
  X30 = 73,
  X31 = 74,
  F0_D = 75,
  F1_D = 76,
  F2_D = 77,
  F3_D = 78,
  F4_D = 79,
  F5_D = 80,
  F6_D = 81,
  F7_D = 82,
  F8_D = 83,
  F9_D = 84,
  F10_D = 85,
  F11_D = 86,
  F12_D = 87,
  F13_D = 88,
  F14_D = 89,
  F15_D = 90,
  F16_D = 91,
  F17_D = 92,
  F18_D = 93,
  F19_D = 94,
  F20_D = 95,
  F21_D = 96,
  F22_D = 97,
  F23_D = 98,
  F24_D = 99,
  F25_D = 100,
  F26_D = 101,
  F27_D = 102,
  F28_D = 103,
  F29_D = 104,
  F30_D = 105,
  F31_D = 106,
  F0_F = 107,
  F1_F = 108,
  F2_F = 109,
  F3_F = 110,
  F4_F = 111,
  F5_F = 112,
  F6_F = 113,
  F7_F = 114,
  F8_F = 115,
  F9_F = 116,
  F10_F = 117,
  F11_F = 118,
  F12_F = 119,
  F13_F = 120,
  F14_F = 121,
  F15_F = 122,
  F16_F = 123,
  F17_F = 124,
  F18_F = 125,
  F19_F = 126,
  F20_F = 127,
  F21_F = 128,
  F22_F = 129,
  F23_F = 130,
  F24_F = 131,
  F25_F = 132,
  F26_F = 133,
  F27_F = 134,
  F28_F = 135,
  F29_F = 136,
  F30_F = 137,
  F31_F = 138,
  F0_H = 139,
  F1_H = 140,
  F2_H = 141,
  F3_H = 142,
  F4_H = 143,
  F5_H = 144,
  F6_H = 145,
  F7_H = 146,
  F8_H = 147,
  F9_H = 148,
  F10_H = 149,
  F11_H = 150,
  F12_H = 151,
  F13_H = 152,
  F14_H = 153,
  F15_H = 154,
  F16_H = 155,
  F17_H = 156,
  F18_H = 157,
  F19_H = 158,
  F20_H = 159,
  F21_H = 160,
  F22_H = 161,
  F23_H = 162,
  F24_H = 163,
  F25_H = 164,
  F26_H = 165,
  F27_H = 166,
  F28_H = 167,
  F29_H = 168,
  F30_H = 169,
  F31_H = 170,
  X0_Pair = 171,
  V0M2 = 172,
  V0M4 = 173,
  V0M8 = 174,
  V2M2 = 175,
  V4M2 = 176,
  V4M4 = 177,
  V6M2 = 178,
  V8M2 = 179,
  V8M4 = 180,
  V8M8 = 181,
  V10M2 = 182,
  V12M2 = 183,
  V12M4 = 184,
  V14M2 = 185,
  V16M2 = 186,
  V16M4 = 187,
  V16M8 = 188,
  V18M2 = 189,
  V20M2 = 190,
  V20M4 = 191,
  V22M2 = 192,
  V24M2 = 193,
  V24M4 = 194,
  V24M8 = 195,
  V26M2 = 196,
  V28M2 = 197,
  V28M4 = 198,
  V30M2 = 199,
  X2_X3 = 200,
  X4_X5 = 201,
  X6_X7 = 202,
  X8_X9 = 203,
  X10_X11 = 204,
  X12_X13 = 205,
  X14_X15 = 206,
  X16_X17 = 207,
  X18_X19 = 208,
  X20_X21 = 209,
  X22_X23 = 210,
  X24_X25 = 211,
  X26_X27 = 212,
  X28_X29 = 213,
  X30_X31 = 214,
  V1_V2 = 215,
  V2_V3 = 216,
  V3_V4 = 217,
  V4_V5 = 218,
  V5_V6 = 219,
  V6_V7 = 220,
  V7_V8 = 221,
  V8_V9 = 222,
  V9_V10 = 223,
  V10_V11 = 224,
  V11_V12 = 225,
  V12_V13 = 226,
  V13_V14 = 227,
  V14_V15 = 228,
  V15_V16 = 229,
  V16_V17 = 230,
  V17_V18 = 231,
  V18_V19 = 232,
  V19_V20 = 233,
  V20_V21 = 234,
  V21_V22 = 235,
  V22_V23 = 236,
  V23_V24 = 237,
  V24_V25 = 238,
  V25_V26 = 239,
  V26_V27 = 240,
  V27_V28 = 241,
  V28_V29 = 242,
  V29_V30 = 243,
  V30_V31 = 244,
  V0_V1 = 245,
  V2M2_V4M2 = 246,
  V4M2_V6M2 = 247,
  V6M2_V8M2 = 248,
  V8M2_V10M2 = 249,
  V10M2_V12M2 = 250,
  V12M2_V14M2 = 251,
  V14M2_V16M2 = 252,
  V16M2_V18M2 = 253,
  V18M2_V20M2 = 254,
  V20M2_V22M2 = 255,
  V22M2_V24M2 = 256,
  V24M2_V26M2 = 257,
  V26M2_V28M2 = 258,
  V28M2_V30M2 = 259,
  V0M2_V2M2 = 260,
  V4M4_V8M4 = 261,
  V8M4_V12M4 = 262,
  V12M4_V16M4 = 263,
  V16M4_V20M4 = 264,
  V20M4_V24M4 = 265,
  V24M4_V28M4 = 266,
  V0M4_V4M4 = 267,
  V1_V2_V3 = 268,
  V2_V3_V4 = 269,
  V3_V4_V5 = 270,
  V4_V5_V6 = 271,
  V5_V6_V7 = 272,
  V6_V7_V8 = 273,
  V7_V8_V9 = 274,
  V8_V9_V10 = 275,
  V9_V10_V11 = 276,
  V10_V11_V12 = 277,
  V11_V12_V13 = 278,
  V12_V13_V14 = 279,
  V13_V14_V15 = 280,
  V14_V15_V16 = 281,
  V15_V16_V17 = 282,
  V16_V17_V18 = 283,
  V17_V18_V19 = 284,
  V18_V19_V20 = 285,
  V19_V20_V21 = 286,
  V20_V21_V22 = 287,
  V21_V22_V23 = 288,
  V22_V23_V24 = 289,
  V23_V24_V25 = 290,
  V24_V25_V26 = 291,
  V25_V26_V27 = 292,
  V26_V27_V28 = 293,
  V27_V28_V29 = 294,
  V28_V29_V30 = 295,
  V29_V30_V31 = 296,
  V0_V1_V2 = 297,
  V2M2_V4M2_V6M2 = 298,
  V4M2_V6M2_V8M2 = 299,
  V6M2_V8M2_V10M2 = 300,
  V8M2_V10M2_V12M2 = 301,
  V10M2_V12M2_V14M2 = 302,
  V12M2_V14M2_V16M2 = 303,
  V14M2_V16M2_V18M2 = 304,
  V16M2_V18M2_V20M2 = 305,
  V18M2_V20M2_V22M2 = 306,
  V20M2_V22M2_V24M2 = 307,
  V22M2_V24M2_V26M2 = 308,
  V24M2_V26M2_V28M2 = 309,
  V26M2_V28M2_V30M2 = 310,
  V0M2_V2M2_V4M2 = 311,
  V1_V2_V3_V4 = 312,
  V2_V3_V4_V5 = 313,
  V3_V4_V5_V6 = 314,
  V4_V5_V6_V7 = 315,
  V5_V6_V7_V8 = 316,
  V6_V7_V8_V9 = 317,
  V7_V8_V9_V10 = 318,
  V8_V9_V10_V11 = 319,
  V9_V10_V11_V12 = 320,
  V10_V11_V12_V13 = 321,
  V11_V12_V13_V14 = 322,
  V12_V13_V14_V15 = 323,
  V13_V14_V15_V16 = 324,
  V14_V15_V16_V17 = 325,
  V15_V16_V17_V18 = 326,
  V16_V17_V18_V19 = 327,
  V17_V18_V19_V20 = 328,
  V18_V19_V20_V21 = 329,
  V19_V20_V21_V22 = 330,
  V20_V21_V22_V23 = 331,
  V21_V22_V23_V24 = 332,
  V22_V23_V24_V25 = 333,
  V23_V24_V25_V26 = 334,
  V24_V25_V26_V27 = 335,
  V25_V26_V27_V28 = 336,
  V26_V27_V28_V29 = 337,
  V27_V28_V29_V30 = 338,
  V28_V29_V30_V31 = 339,
  V0_V1_V2_V3 = 340,
  V2M2_V4M2_V6M2_V8M2 = 341,
  V4M2_V6M2_V8M2_V10M2 = 342,
  V6M2_V8M2_V10M2_V12M2 = 343,
  V8M2_V10M2_V12M2_V14M2 = 344,
  V10M2_V12M2_V14M2_V16M2 = 345,
  V12M2_V14M2_V16M2_V18M2 = 346,
  V14M2_V16M2_V18M2_V20M2 = 347,
  V16M2_V18M2_V20M2_V22M2 = 348,
  V18M2_V20M2_V22M2_V24M2 = 349,
  V20M2_V22M2_V24M2_V26M2 = 350,
  V22M2_V24M2_V26M2_V28M2 = 351,
  V24M2_V26M2_V28M2_V30M2 = 352,
  V0M2_V2M2_V4M2_V6M2 = 353,
  V1_V2_V3_V4_V5 = 354,
  V2_V3_V4_V5_V6 = 355,
  V3_V4_V5_V6_V7 = 356,
  V4_V5_V6_V7_V8 = 357,
  V5_V6_V7_V8_V9 = 358,
  V6_V7_V8_V9_V10 = 359,
  V7_V8_V9_V10_V11 = 360,
  V8_V9_V10_V11_V12 = 361,
  V9_V10_V11_V12_V13 = 362,
  V10_V11_V12_V13_V14 = 363,
  V11_V12_V13_V14_V15 = 364,
  V12_V13_V14_V15_V16 = 365,
  V13_V14_V15_V16_V17 = 366,
  V14_V15_V16_V17_V18 = 367,
  V15_V16_V17_V18_V19 = 368,
  V16_V17_V18_V19_V20 = 369,
  V17_V18_V19_V20_V21 = 370,
  V18_V19_V20_V21_V22 = 371,
  V19_V20_V21_V22_V23 = 372,
  V20_V21_V22_V23_V24 = 373,
  V21_V22_V23_V24_V25 = 374,
  V22_V23_V24_V25_V26 = 375,
  V23_V24_V25_V26_V27 = 376,
  V24_V25_V26_V27_V28 = 377,
  V25_V26_V27_V28_V29 = 378,
  V26_V27_V28_V29_V30 = 379,
  V27_V28_V29_V30_V31 = 380,
  V0_V1_V2_V3_V4 = 381,
  V1_V2_V3_V4_V5_V6 = 382,
  V2_V3_V4_V5_V6_V7 = 383,
  V3_V4_V5_V6_V7_V8 = 384,
  V4_V5_V6_V7_V8_V9 = 385,
  V5_V6_V7_V8_V9_V10 = 386,
  V6_V7_V8_V9_V10_V11 = 387,
  V7_V8_V9_V10_V11_V12 = 388,
  V8_V9_V10_V11_V12_V13 = 389,
  V9_V10_V11_V12_V13_V14 = 390,
  V10_V11_V12_V13_V14_V15 = 391,
  V11_V12_V13_V14_V15_V16 = 392,
  V12_V13_V14_V15_V16_V17 = 393,
  V13_V14_V15_V16_V17_V18 = 394,
  V14_V15_V16_V17_V18_V19 = 395,
  V15_V16_V17_V18_V19_V20 = 396,
  V16_V17_V18_V19_V20_V21 = 397,
  V17_V18_V19_V20_V21_V22 = 398,
  V18_V19_V20_V21_V22_V23 = 399,
  V19_V20_V21_V22_V23_V24 = 400,
  V20_V21_V22_V23_V24_V25 = 401,
  V21_V22_V23_V24_V25_V26 = 402,
  V22_V23_V24_V25_V26_V27 = 403,
  V23_V24_V25_V26_V27_V28 = 404,
  V24_V25_V26_V27_V28_V29 = 405,
  V25_V26_V27_V28_V29_V30 = 406,
  V26_V27_V28_V29_V30_V31 = 407,
  V0_V1_V2_V3_V4_V5 = 408,
  V1_V2_V3_V4_V5_V6_V7 = 409,
  V2_V3_V4_V5_V6_V7_V8 = 410,
  V3_V4_V5_V6_V7_V8_V9 = 411,
  V4_V5_V6_V7_V8_V9_V10 = 412,
  V5_V6_V7_V8_V9_V10_V11 = 413,
  V6_V7_V8_V9_V10_V11_V12 = 414,
  V7_V8_V9_V10_V11_V12_V13 = 415,
  V8_V9_V10_V11_V12_V13_V14 = 416,
  V9_V10_V11_V12_V13_V14_V15 = 417,
  V10_V11_V12_V13_V14_V15_V16 = 418,
  V11_V12_V13_V14_V15_V16_V17 = 419,
  V12_V13_V14_V15_V16_V17_V18 = 420,
  V13_V14_V15_V16_V17_V18_V19 = 421,
  V14_V15_V16_V17_V18_V19_V20 = 422,
  V15_V16_V17_V18_V19_V20_V21 = 423,
  V16_V17_V18_V19_V20_V21_V22 = 424,
  V17_V18_V19_V20_V21_V22_V23 = 425,
  V18_V19_V20_V21_V22_V23_V24 = 426,
  V19_V20_V21_V22_V23_V24_V25 = 427,
  V20_V21_V22_V23_V24_V25_V26 = 428,
  V21_V22_V23_V24_V25_V26_V27 = 429,
  V22_V23_V24_V25_V26_V27_V28 = 430,
  V23_V24_V25_V26_V27_V28_V29 = 431,
  V24_V25_V26_V27_V28_V29_V30 = 432,
  V25_V26_V27_V28_V29_V30_V31 = 433,
  V0_V1_V2_V3_V4_V5_V6 = 434,
  V1_V2_V3_V4_V5_V6_V7_V8 = 435,
  V2_V3_V4_V5_V6_V7_V8_V9 = 436,
  V3_V4_V5_V6_V7_V8_V9_V10 = 437,
  V4_V5_V6_V7_V8_V9_V10_V11 = 438,
  V5_V6_V7_V8_V9_V10_V11_V12 = 439,
  V6_V7_V8_V9_V10_V11_V12_V13 = 440,
  V7_V8_V9_V10_V11_V12_V13_V14 = 441,
  V8_V9_V10_V11_V12_V13_V14_V15 = 442,
  V9_V10_V11_V12_V13_V14_V15_V16 = 443,
  V10_V11_V12_V13_V14_V15_V16_V17 = 444,
  V11_V12_V13_V14_V15_V16_V17_V18 = 445,
  V12_V13_V14_V15_V16_V17_V18_V19 = 446,
  V13_V14_V15_V16_V17_V18_V19_V20 = 447,
  V14_V15_V16_V17_V18_V19_V20_V21 = 448,
  V15_V16_V17_V18_V19_V20_V21_V22 = 449,
  V16_V17_V18_V19_V20_V21_V22_V23 = 450,
  V17_V18_V19_V20_V21_V22_V23_V24 = 451,
  V18_V19_V20_V21_V22_V23_V24_V25 = 452,
  V19_V20_V21_V22_V23_V24_V25_V26 = 453,
  V20_V21_V22_V23_V24_V25_V26_V27 = 454,
  V21_V22_V23_V24_V25_V26_V27_V28 = 455,
  V22_V23_V24_V25_V26_V27_V28_V29 = 456,
  V23_V24_V25_V26_V27_V28_V29_V30 = 457,
  V24_V25_V26_V27_V28_V29_V30_V31 = 458,
  V0_V1_V2_V3_V4_V5_V6_V7 = 459,
  NUM_TARGET_REGS = 460,
};

}
}
}
#endif
