// Code generated by smithy-go-codegen DO NOT EDIT.

package deadline

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/deadline/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Starts an asynchronous request for getting aggregated statistics about queues
// and farms. Get the statistics using the GetSessionsStatisticsAggregation
// operation. Statistics are available for 1 hour after you call the
// StartSessionsStatisticsAggregation operation.
func (c *Client) StartSessionsStatisticsAggregation(ctx context.Context, params *StartSessionsStatisticsAggregationInput, optFns ...func(*Options)) (*StartSessionsStatisticsAggregationOutput, error) {
	if params == nil {
		params = &StartSessionsStatisticsAggregationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartSessionsStatisticsAggregation", params, optFns, c.addOperationStartSessionsStatisticsAggregationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartSessionsStatisticsAggregationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartSessionsStatisticsAggregationInput struct {

	// The Linux timestamp of the date and time that the statistics end.
	//
	// This member is required.
	EndTime *time.Time

	// The identifier of the farm that contains queues or fleets to return statistics
	// for.
	//
	// This member is required.
	FarmId *string

	// The field to use to group the statistics.
	//
	// This member is required.
	GroupBy []types.UsageGroupByField

	// A list of fleet IDs or queue IDs to gather statistics for.
	//
	// This member is required.
	ResourceIds types.SessionsStatisticsResources

	// The Linux timestamp of the date and time that the statistics start.
	//
	// This member is required.
	StartTime *time.Time

	// One to four statistics to return.
	//
	// This member is required.
	Statistics []types.UsageStatistic

	// The period to aggregate the statistics.
	Period types.Period

	// The timezone to use for the statistics. Use UTC notation such as "UTC+8."
	Timezone *string

	noSmithyDocumentSerde
}

type StartSessionsStatisticsAggregationOutput struct {

	// A unique identifier for the aggregated statistics. Use this identifier with the
	// GetAggregatedStatisticsForSessions operation to return the statistics.
	//
	// This member is required.
	AggregationId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartSessionsStatisticsAggregationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartSessionsStatisticsAggregation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartSessionsStatisticsAggregation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartSessionsStatisticsAggregation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opStartSessionsStatisticsAggregationMiddleware(stack); err != nil {
		return err
	}
	if err = addOpStartSessionsStatisticsAggregationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartSessionsStatisticsAggregation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opStartSessionsStatisticsAggregationMiddleware struct {
}

func (*endpointPrefix_opStartSessionsStatisticsAggregationMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opStartSessionsStatisticsAggregationMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "management." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opStartSessionsStatisticsAggregationMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opStartSessionsStatisticsAggregationMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opStartSessionsStatisticsAggregation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartSessionsStatisticsAggregation",
	}
}
