/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.fs.hfs;

import org.catacombae.jparted.lib.DataLocator;
import org.catacombae.jparted.lib.fs.DefaultFileSystemHandlerInfo;
import org.catacombae.jparted.lib.fs.FileSystemHandler;
import org.catacombae.jparted.lib.fs.FileSystemHandlerFactory;
import org.catacombae.jparted.lib.fs.FileSystemHandlerInfo;
import org.catacombae.jparted.lib.fs.FileSystemRecognizer;
import org.catacombae.jparted.lib.fs.hfs.HFSFileSystemHandler;
import org.catacombae.jparted.lib.fs.hfs.HFSFileSystemRecognizer;

public class HFSFileSystemHandlerFactory
extends FileSystemHandlerFactory {
    private static final FileSystemRecognizer recognizer = new HFSFileSystemRecognizer();
    private static final FileSystemHandlerInfo handlerInfo = new DefaultFileSystemHandlerInfo("HFS file system handler", "1.0", 0L, "Erik Larsson, Catacombae Software");
    private static final FileSystemHandlerFactory.CustomAttribute stringEncodingAttribute = HFSFileSystemHandlerFactory.createCustomAttribute(FileSystemHandlerFactory.AttributeType.STRING, "HFS_STRING_ENCODING", "The string encoding for filenames in the current HFS file system", "MacRoman");

    public FileSystemHandler createHandler(DataLocator data) {
        boolean useCaching = this.createAttributes.getBooleanAttribute(FileSystemHandlerFactory.StandardAttribute.CACHING_ENABLED);
        String encoding = this.createAttributes.getStringAttribute(stringEncodingAttribute);
        return this.createHandlerInternal(data, useCaching, encoding);
    }

    protected FileSystemHandler createHandlerInternal(DataLocator data, boolean useCaching, String encoding) {
        return new HFSFileSystemHandler(data, useCaching, encoding);
    }

    public FileSystemHandlerInfo getHandlerInfo() {
        return handlerInfo;
    }

    public FileSystemHandlerFactory.StandardAttribute[] getSupportedStandardAttributes() {
        this.setStandardAttributeDefaultValue(FileSystemHandlerFactory.StandardAttribute.CACHING_ENABLED, true);
        return new FileSystemHandlerFactory.StandardAttribute[]{FileSystemHandlerFactory.StandardAttribute.CACHING_ENABLED};
    }

    public FileSystemHandlerFactory.CustomAttribute[] getSupportedCustomAttributes() {
        return new FileSystemHandlerFactory.CustomAttribute[]{stringEncodingAttribute};
    }

    public FileSystemHandlerFactory newInstance() {
        return new HFSFileSystemHandlerFactory();
    }

    public FileSystemRecognizer getRecognizer() {
        return recognizer;
    }
}

