/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import rene.util.MyVector;
import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;

public class BreakpointAnimator
extends ObjectConstructor
implements Runnable {
    MyVector Breaks = new MyVector();
    ZirkelCanvas ZC;
    boolean Loop = false;
    boolean Running = false;
    boolean Stopped = false;
    long SleepTime = 1024L;

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        double d2 = zirkelCanvas.x(mouseEvent.getX());
        double d3 = zirkelCanvas.y(mouseEvent.getY());
        this.ZC = zirkelCanvas;
        if (this.Running) {
            if (mouseEvent.isShiftDown()) {
                this.Loop = !this.Loop;
            } else {
                this.Stopped = true;
                zirkelCanvas.paintUntil(null);
            }
        } else {
            this.reset(zirkelCanvas);
        }
    }

    public synchronized void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        this.ZC = zirkelCanvas;
        this.showStatus(zirkelCanvas);
        if (this.Running) {
            this.Stopped = true;
            zirkelCanvas.paintUntil(null);
        } else {
            this.Stopped = false;
            new Thread(this).start();
        }
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.showStatus(Zirkel.name("message.animatebreak"));
    }

    public void save(XmlWriter xmlWriter) {
        xmlWriter.startTagStart("AnimateBreakpoints");
        xmlWriter.printArg("time", "" + this.SleepTime);
        if (this.Loop) {
            xmlWriter.printArg("loop", "true");
        }
        xmlWriter.finishTagNewLine();
    }

    public void run() {
        Object[] objectArray;
        this.ZC.getConstruction().setOriginalOrder(true);
        this.Running = true;
        this.Breaks = new MyVector();
        Enumeration enumeration = this.ZC.getConstruction().elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (!objectArray.isBreak()) continue;
            this.Breaks.addElement(objectArray);
        }
        objectArray = this.Breaks.getArray();
        int n = 0;
        if (this.Breaks.size() == 0) {
            this.Running = false;
            this.ZC.getConstruction().setOriginalOrder(false);
            return;
        }
        ConstructionObject constructionObject = (ConstructionObject)objectArray[0];
        boolean bl = true;
        while (!this.Stopped) {
            if (!this.Stopped) {
                this.ZC.paintUntil(constructionObject);
            }
            try {
                Thread.sleep(this.SleepTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.Stopped) break;
            if (this.Loop) {
                if (bl) {
                    if (n < this.Breaks.size() - 1) {
                        constructionObject = (ConstructionObject)objectArray[++n];
                        continue;
                    }
                    if (n != this.Breaks.size() - 1) continue;
                    ++n;
                    bl = false;
                    constructionObject = null;
                    continue;
                }
                if (n > 0) {
                    constructionObject = (ConstructionObject)objectArray[--n];
                    continue;
                }
                n = 1;
                constructionObject = (ConstructionObject)objectArray[n];
                bl = true;
                continue;
            }
            if (n < this.Breaks.size() - 1) {
                constructionObject = (ConstructionObject)objectArray[++n];
                continue;
            }
            if (n == this.Breaks.size() - 1) {
                ++n;
                constructionObject = null;
                continue;
            }
            n = 0;
            constructionObject = (ConstructionObject)objectArray[n];
        }
        this.Running = false;
        this.ZC.getConstruction().setOriginalOrder(false);
    }

    public synchronized void invalidate(ZirkelCanvas zirkelCanvas) {
        this.Stopped = true;
        this.ZC.paintUntil(null);
    }

    public boolean useSmartBoard() {
        return false;
    }

    public void increaseSpeed() {
        if (this.SleepTime >= 32000L) {
            return;
        }
        this.SleepTime *= 2L;
    }

    public void decreaseSpeed() {
        if (this.SleepTime == 1L) {
            return;
        }
        this.SleepTime /= 2L;
    }

    public void setSpeed(long l) {
        this.SleepTime = l;
    }

    public void setLoop(boolean bl) {
        this.Loop = bl;
    }
}

