
[//000000001]: # (fileutil::paths \- )
[//000000002]: # (Generated from file 'paths\.man' by tcllib/doctools with format 'markdown')
[//000000003]: # (fileutil::paths\(n\) 1\.1 tcllib "")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

fileutil::paths \- Manage search path pools

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [API](#section2)

  - [Bugs, Ideas, Feedback](#section3)

# <a name='synopsis'></a>SYNOPSIS

package require Tcl 8\.5 9  
package require fileutil::paths ?1\.1?  

[__::fileutil::paths__ *poolName*](#1)  
[__poolName__ __method__ ?*arg arg \.\.\.*?](#2)  
[*poolName* __add__ *path*](#3)  
[*poolName* __clear__](#4)  
[*poolName* __paths__](#5)  
[*poolName* __remove__ *path*](#6)  

# <a name='description'></a>DESCRIPTION

Provides a snit class whose instances manage a pool of \(search\) paths\.

# <a name='section2'></a>API

The main command provides construction of search path pools:

  - <a name='1'></a>__::fileutil::paths__ *poolName*

    Creates a new, empty pool of search paths with an associated global Tcl
    command whose name is *poolName*\. It may be used to invoke various
    operations on the pool\. It has the following general form:

      * <a name='2'></a>__poolName__ __method__ ?*arg arg \.\.\.*?

        __method__ and *arg*uments determine the exact behavior of the
        command\.

    If *poolName* is specified as __%AUTO%__ a unique name will be
    generated by the package itself\. The result of the command is the
    fully\-qualified name of the instance command\.

The following commands are possible for pool objects:

  - <a name='3'></a>*poolName* __add__ *path*

    Adds the *path* to the pool\. Nothing is done if the *path* is already
    known to the pool\. The result of the command is the empty string\.

  - <a name='4'></a>*poolName* __clear__

    Clears the entire pool\. In other words, removes all paths from it\. The
    result of the command is the empty string\.

  - <a name='5'></a>*poolName* __paths__

    Returns the list of all paths known to the pool, in the order they were
    added\.

  - <a name='6'></a>*poolName* __remove__ *path*

    Removes the *path* from the pool, if it is known to the pool\. Unknown
    paths are ignored without error\. The result of the command is the empty
    string\.

# <a name='section3'></a>Bugs, Ideas, Feedback

This document, and the package it describes, will undoubtedly contain bugs and
other problems\. Please report such in the category *fileutil* of the [Tcllib
Trackers](http://core\.tcl\.tk/tcllib/reportlist)\. Please also report any ideas
for enhancements you may have for either package and/or documentation\.

When proposing code changes, please provide *unified diffs*, i\.e the output of
__diff \-u__\.

Note further that *attachments* are strongly preferred over inlined patches\.
Attachments can be made by going to the __Edit__ form of the ticket
immediately after its creation, and then using the left\-most button in the
secondary navigation bar\.
