/*
 * Decompiled with CFR 0.152.
 */
package adql.db.exception;

import adql.parser.grammar.ParseException;
import adql.query.TextPosition;
import adql.query.operand.function.ADQLFunction;

public class UnresolvedFunctionException
extends ParseException {
    private static final long serialVersionUID = 1L;
    protected final ADQLFunction functionInError;

    public UnresolvedFunctionException(String message) {
        this(message, (TextPosition)null);
    }

    public UnresolvedFunctionException(String message, TextPosition pos) {
        super(message, pos);
        this.functionInError = null;
    }

    public UnresolvedFunctionException(ADQLFunction fct) {
        super("Unresolved function: \"" + fct.toADQL() + "\"! No UDF has been defined or found with the signature: " + UnresolvedFunctionException.getFctSignature(fct) + ".", fct.getPosition());
        this.functionInError = fct;
    }

    public UnresolvedFunctionException(String message, ADQLFunction fct) {
        super(message, fct == null ? null : fct.getPosition());
        this.functionInError = fct;
    }

    public final ADQLFunction getFunction() {
        return this.functionInError;
    }

    public static String getFctSignature(ADQLFunction fct) {
        if (fct == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(fct.getName().toLowerCase());
        buf.append('(');
        for (int i = 0; i < fct.getNbParameters(); ++i) {
            if (fct.getParameter(i).isNumeric() && fct.getParameter(i).isString() && fct.getParameter(i).isGeometry()) {
                buf.append("param").append(i + 1);
            } else if (fct.getParameter(i).isNumeric()) {
                buf.append("NUMERIC");
            } else if (fct.getParameter(i).isString()) {
                buf.append("STRING");
            } else if (fct.getParameter(i).isGeometry()) {
                buf.append("GEOMETRY");
            } else {
                buf.append("param").append(i + 1);
            }
            if (i + 1 >= fct.getNbParameters()) continue;
            buf.append(", ");
        }
        buf.append(')');
        return buf.toString();
    }
}

