#include "opengltestwidget.h"
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QDoubleSpinBox>
#include <QSpinBox>
#include <QLineEdit>
#include <QComboBox>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QToolButton>
#include <QApplication>
#include <QInputDialog>
#include <QThread>


/*void GLAPIENTRY
MessageCallback( GLenum source,
                 GLenum type,
                 GLuint id,
                 GLenum severity,
                 GLsizei length,
                 const GLchar* message,
                 const void* userParam )
{
  fprintf( stderr, "GL CALLBACK: %s type = 0x%x, severity = 0x%x, message = %s\n",
           ( type == GL_DEBUG_TYPE_ERROR ? "** GL ERROR **" : "" ),
            type, severity, message );
}
*/

OpenGLTestWidget::OpenGLTestWidget(Molecule *externMole, QList<QAction*> &acts, QWidget *parent) : QDialog(parent){
    setObjectName("OpenGLTestWidget\n");
    ogl = new PlayOpenGL(externMole);

    //connect(ogl, SIGNAL(initialized()),ogl, SLOT(orthor()));
    vito = new QToolBar(this);
    QHBoxLayout *hlt = new QHBoxLayout();
    QHBoxLayout *hlt0 = new QHBoxLayout();
    QHBoxLayout *hlt1 = new QHBoxLayout();
    QVBoxLayout *lt = new QVBoxLayout();
    printf("31 \n");
#if defined (Q_OS_MAC)
    container = QWidget::createWindowContainer(ogl);
    container->setMinimumHeight(400);
    hlt0->addWidget(container);
#else
    hlt0->addWidget(ogl);
#endif
    printf("35 \n");

    qpv = new QPeakView(this);
    qpv->setMinimumWidth(50);
    qpv->setMin(externMole->pmin);
    qpv->setMax(externMole->pmax);

    ogl->fVertexes.resize(28);
    ogl->fNormals.resize(28);
    printf("%s, %s\n",
           QStandardPaths::writableLocation(QStandardPaths::GenericCacheLocation).toStdString().c_str(),
           QStandardPaths::writableLocation(QStandardPaths::CacheLocation).toStdString().c_str());

    printf("qpeak %f %f\n",externMole->pmin,externMole->pmax);
    connect(qpv, SIGNAL(cutOffChanged(double)), ogl, SLOT(setQpeakCutoff(double)));
    connect(qpv,SIGNAL(findQP(double)),ogl,SLOT(highliteQPeak(double)));
    connect(ogl,SIGNAL(qpfoci(double)),qpv,SLOT(qpeaksInFocus(double)));
    //setQpeakCutoff
    hlt0->addWidget(qpv);
    qpv->dark=false;
    qpv->update();
    hlt0->setStretch(0,100);
    lt->addLayout(hlt0);
    fpslabel = new QLabel("label");
    messagelabel = new QLabel("label");
    //printf("44! %d\n", acts.size());
    /*{
        QAction *a =vito->addAction("=>");
        connect(a, SIGNAL(triggered(bool)), ogl, SLOT(rotY90()));
        a =vito->addAction("|");
        connect(a, SIGNAL(triggered(bool)), ogl, SLOT(rotX90()));
        a =vito->addAction("O");
        connect(a, SIGNAL(triggered(bool)), ogl, SLOT(along001()));
    }// */
    {
        QAction *a =vito->addAction("F6");
        connect(a, SIGNAL(toggled(bool)), ogl, SLOT(setBGGradient(bool)));
        a->setShortcut(QKeySequence("F6"));
        a->setCheckable(true);
        a->setChecked(true);
    }
    int conectedActions=0;
    for (int i = 0, j = 1; i< acts.size(); i++){
        QAction *a = acts.at(i);
        if (a->text().isEmpty()) continue;
        if (a->icon().isNull()) continue;
        printf("viewActions%d %s\n", j, a->text().toStdString().c_str());
        vito->addAction(a);
        if (0==a->text().compare("Toggle Atoms", Qt::CaseInsensitive)) {
            ogl->setAtoms(a->isChecked());
            connect(a, SIGNAL(toggled(bool)), ogl, SLOT(setAtoms(bool)));
            printf("conectedActions %d\n",++conectedActions);
        }
        else if (0==a->text().compare("Toggle Bonds", Qt::CaseInsensitive)) {
            ogl->setBonds(a->isChecked());
            connect(a, SIGNAL(toggled(bool)), ogl, SLOT(setBonds(bool)));
            printf("conectedActions %d\n",++conectedActions);
        }
        else if (0==a->text().compare("Toggle Labels", Qt::CaseInsensitive)) {
            ogl->setLabels(a->isChecked());
            connect(a, SIGNAL(toggled(bool)), ogl, SLOT(setLabels(bool)));
            printf("conectedActions %d\n",++conectedActions);
        }
        else if (0==a->text().compare("Toggle H-bonds", Qt::CaseInsensitive)) {
            connect(a, SIGNAL(toggled(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
            ogl->h_bonds = a;
        }
        else if (0==a->text().compare("Toggle ADPs", Qt::CaseInsensitive)){
            connect(a, SIGNAL(toggled(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
            ogl->adp = a;
        }
        else if (0==a->text().compare("Toggle Unit Cell", Qt::CaseInsensitive)){
            connect(a, SIGNAL(toggled(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
            ogl->togUnit = a;
        }
        else if (0==a->text().compare("Ball-Stick", Qt::CaseInsensitive)){
            connect(a, SIGNAL(toggled(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
            ogl->ballStick = a;
        }
        else if (0==a->text().compare("Tubes", Qt::CaseInsensitive)){
            connect(a, SIGNAL(toggled(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
            ogl->tubes = a;
        }
        else if (0==a->text().compare("Ortho-projection", Qt::CaseInsensitive)){
            connect(a, SIGNAL(toggled(bool)), ogl,  SLOT(toggleOrtho(bool)));
            connect(a, SIGNAL(toggled(bool)), ogl,  SLOT(update()));

            printf("conectedActions %d\n",++conectedActions);
            if (a->isChecked()) {ogl->isOrtho=true; ogl->viewAngle=0.01;}
            else {ogl->isOrtho=false; ogl->viewAngle=29.0;}
            ogl->toggleOrthoView = a;
        }
        else if (0==a->text().compare("Q-Peak-Bonds", Qt::CaseInsensitive)){
            connect(a, SIGNAL(toggled(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
            ogl->qPeakBonds = a;
        }
        else if (0==a->text().compare("Q-Peak-Legend", Qt::CaseInsensitive)){
            connect(a, SIGNAL(toggled(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
            ogl->QPeakLegend = a;
            connect(a, SIGNAL(toggled(bool)), qpv,  SLOT(setVisible(bool)));
            qpv->setVisible(a->isChecked());
        }
        else if (0==a->text().compare("Toggle BEDE and LONE Objects (IDEAL)", Qt::CaseInsensitive)){
            connect(a, SIGNAL(toggled(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
            ogl->hideBeLo = a;
        }
        else if (0==a->text().compare("Toggle Atom Legend", Qt::CaseInsensitive)){
                connect(a, SIGNAL(toggled(bool)), ogl,  SLOT(update()));
                printf("conectedActions %d\n",++conectedActions);
                ogl->atomLegend = a;
        }
        else if (0==a->text().compare("Hide Hydrogen Atoms", Qt::CaseInsensitive)){
            connect(a, SIGNAL(triggered(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
            ogl->hideHydrogen = a;
            //"Hide Hydrogen atoms",ogl,SLOT(hideHydrogens()));
        }
        else if (0==a->text().compare("Show all hidden", Qt::CaseInsensitive)){
            connect(a, SIGNAL(triggered(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
            ogl->unhide = a;
            //        "Show all hidden",chgl,SLOT(showHidden()));
        }
        else if (0==a->text().compare("Hide PART -N ghost", Qt::CaseInsensitive)){
            connect(a, SIGNAL(triggered(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
            ogl->shpm1 = a;
        }
        else if (0==a->text().compare("Highlight PARTs", Qt::CaseInsensitive)){
            connect(a, SIGNAL(triggered(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
            ogl->highlightParts = a;
        }
        else if (0==a->text().compare("Center Selected Atoms", Qt::CaseInsensitive)){
            connect(a, SIGNAL(triggered(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
            connect(a, SIGNAL(triggered(bool)), ogl,  SLOT(updateSceenAtoms()));
            ogl->centerSelection = a;
            //        "Center selected atoms",chgl,SLOT(homeXY()));
        }
        /////sss
        ///
        else if (0==a->text().compare("Bind Selected Atoms", Qt::CaseInsensitive)){//,editor,SLOT(insertBind()));
            ogl->addBond = a;
            connect(a, SIGNAL(triggered(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
        }
        else if (0==a->text().compare("Free selected atoms", Qt::CaseInsensitive)){//,editor,SLOT(insertFree()));
            ogl->killBond = a;
            connect(a, SIGNAL(triggered(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
        }
        else if (0==a->text().compare("Deselect", Qt::CaseInsensitive)){//,chgl,SLOT(disSelection()));
            ogl->clearSelection = a;
            connect(a, SIGNAL(triggered(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
        }
        else if (0==a->text().compare("Create centroid", Qt::CaseInsensitive)){//, this , SLOT(createCentroid()));
            ogl->centroid = a;
            connect(a, SIGNAL(triggered(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
        }
        else if (0==a->text().compare("Create Contour Plot", Qt::CaseInsensitive)){//,this, SLOT(contourPlot()));
            ogl->cntrPlot = a;
            connect(a, SIGNAL(triggered(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
        }
        else if (0==a->text().compare("Remove Contour Plot", Qt::CaseInsensitive)){//,this, SLOT(nocontourPlot()));
            ogl->nocntrPlot = a;
            connect(a, SIGNAL(triggered(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
        }
        else if (0==a->text().compare("Invert selection", Qt::CaseInsensitive)){//,chgl,SLOT(invertSelection()));
            ogl->invSelection = a;
            connect(a, SIGNAL(triggered(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
        }
        else if (0==a->text().compare("Hide other atoms", Qt::CaseInsensitive)){//,chgl,SLOT(hideNonSelected()));
            ogl->hideNotSelection = a;
            connect(a, SIGNAL(triggered(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
        }
        else if (0==a->text().compare("Toggle visibility ", Qt::CaseInsensitive)){//,chgl,SLOT(invertHidden()));
            ogl->invhide = a;
            connect(a, SIGNAL(triggered(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
        }
        else if (0==a->text().compare("Delete selected atoms", Qt::CaseInsensitive)){
            ogl->delSelAt = a;
            connect(a, SIGNAL(triggered(bool)), ogl,  SLOT(update()));
            printf("conectedActions %d\n",++conectedActions);
        }
        j++;
    }
    if (ogl->QPeakLegend == nullptr) {
        /*if (externMole->mynewnameis.startsWith("shelXle")){
            ogl->theIconPath=QString(":/xle-icons/");
        }else{
            ogl->theIconPath=QString(":/bicons/");
        }*/
        QAction *a = new QAction(QIcon(ogl->theIconPath+"qlegend.svg"),"Q-Peak-Legend");
        a->setCheckable(true);
        a->setChecked(true);
        vito->addAction(a);
        connect(a, SIGNAL(toggled(bool)), ogl,  SLOT(update()));
        ogl->QPeakLegend = a;
        connect(a, SIGNAL(toggled(bool)), qpv,  SLOT(setVisible(bool)));
        qpv->setVisible(a->isChecked());
    }
    QCheckBox *autoupdate =  new QCheckBox("meassure FPS");
    autoupdate->setChecked(false);
    connect(autoupdate, &QCheckBox::stateChanged, ogl, &PlayOpenGL::toggleAutoUpdate);

    QDoubleSpinBox *bsdsp = new QDoubleSpinBox();
    bsdsp->setPrefix("bond strength = ");
    bsdsp->setRange(0.01,0.3);
    bsdsp->setSingleStep(0.01);
    bsdsp->setValue(externMole->bondStrength);
#if (QT_VERSION >= 0x050f10)  
    connect(bsdsp, &QDoubleSpinBox::valueChanged, ogl, &PlayOpenGL::setBondStrength);
#else 
    connect(bsdsp, SIGNAL(valueChanged(double)), ogl, SLOT(setBondStrength(double)));
#endif
    QSpinBox *lodsp = new QSpinBox();
    lodsp->setPrefix("LOD = ");
    lodsp->setRange(2, 8);
    lodsp->setValue(ogl->mol->LOD);
#if (QT_VERSION >= 0x050f10)
    connect(lodsp, &QSpinBox::valueChanged, ogl, &PlayOpenGL::setLOD);
#else 
    connect(lodsp, SIGNAL(valueChanged(int)), ogl, SLOT(setLOD(int)));
#endif
    ogl->rCenter = new QToolButton();
    ogl->rCenter->setText("Reset rotation center");
    connect(ogl->rCenter,SIGNAL(clicked()), ogl,SLOT( rotCenter()));
    ogl->rCenter->hide();
    fov = new QDoubleSpinBox();
    fov->setPrefix("view angle =");
    fov->setRange(0.0,160);
    fov->setValue(ogl->viewAngle);
    fov->setSingleStep(1.0);
    connect(ogl, SIGNAL(viewAngeleChanged(double)),fov,SLOT(setValue(double)));
#if (QT_VERSION >= 0x050f10)
    connect(fov, &QDoubleSpinBox::valueChanged, this, &OpenGLTestWidget::setViewAngle);
#else
    connect(fov, SIGNAL(valueChanged(double)), this, SLOT(setViewAngle(double)));
#endif

    hlt1->addWidget(fpslabel);
    hlt1->addWidget(messagelabel);
    lt->addLayout(hlt1);
    lt->addLayout(hlt);
    lt->addWidget(vito);
    hlt->addWidget(autoupdate);
    hlt->addWidget(fov);
    hlt->addWidget(bsdsp);
    hlt->addWidget(lodsp);
    hlt->addWidget(ogl->rCenter);    
    hlt->addWidget(ogl->enviButt);
    hlt->addWidget(ogl->enviSelect);
    lt->setStretch(0,100);
    setLayout(lt);
    connect(ogl, SIGNAL(message(QString)),this, SLOT(updateMessage(QString)));
    QTimer *tmr = new QTimer();
    connect(tmr, &QTimer::timeout, this, &OpenGLTestWidget::printFPS);
    tmr->start(2000);
}

void OpenGLTestWidget::printFPS(){
    fpslabel->setText(QString("FPS: %1").arg(ogl->frame_cnt / 2.0,0,'f',1));
    ogl->frame_cnt = 0;
}

void OpenGLTestWidget::updateMessage(QString s){
    messagelabel->setText(s);
    update();
}

void OpenGLTestWidget::setViewAngle(double ang){
    if (fov->hasFocus()){
        ogl->setViewAngle(ang);
        fov->clearFocus();
    }
}

QSize OpenGLTestWidget::sizeHint() const {return QSize(800,800);}

QSize OpenGLTestWidget::minimumSizeHint() const {return QSize(60,60);}

///////////////////////////////////////////////////////////////////////
#if defined (Q_OS_MAC)
PlayOpenGL::PlayOpenGL( Molecule *externMole): QOpenGLWindow(){
#else
PlayOpenGL::PlayOpenGL( Molecule *externMole): QOpenGLWidget(){
#endif
    mol = externMole;
    printf("line %d parent pointer = %p \n", __LINE__, parent()) ;
    connect(this,SIGNAL(initialized()),this, SLOT(getReady()));
    //QSurfaceFormat glFormat(QSurfaceFormat::DebugContext);
    //myFont = QFont("Arial", 24);
    //nonAtomFont = myFont;
    if (parent()){
        isMainWindow = (parent()->objectName()=="The Main Window");
    }
    //setMouseTracking(true);
    nonAtomFont.setPointSize(qMax(((myFont.pointSize()*2)/3),7));
    QSurfaceFormat glFormat;
    glFormat.setSwapInterval(0);
    glFormat.setVersion( 3, 3 );
    glFormat.setSamples(4);
    glFormat.setDepthBufferSize(24);
    glFormat.setProfile( QSurfaceFormat::CoreProfile ); // Requires >=Qt-4.8.0
    glFormat.setSwapBehavior(QSurfaceFormat::DoubleBuffer);
    //QSurfaceFormat::setDefaultFormat(glFormat);
    setFormat(glFormat);
    //printf("%d %s\n",__LINE__,(char*)glGetString(GL_VERSION));

    if (externMole->mynewnameis.startsWith("shelXle")){
        theIconPath=QString(":/xle-icons/");
    }else{
        theIconPath=QString(":/bicons/");
    }
    //printf("!! -}%s{-  %d  %s\n",externMole->mynewnameis.toStdString().c_str(), externMole->mynewnameis.startsWith("shelXle") ,theIconPath.toStdString().c_str());

    envirange = 3.2;
    //apair.clear();
    enviNoQ = new QAction("Exclude Q-peaks from environment listing", this);
    enviCova = new QAction("List only covalent bonds.",this);

    enviButt = new QToolButton();
    enviButt->setText("clear ENVI");
    //enviButt->setIcon(QIcon(theIconPath+"cancel.svg"));
    enviSelect = new QToolButton();
    enviSelect->setText("Select ENVI");
    enviButt->hide();
    enviSelect->hide();
    //enviSelect->setIcon(QIcon(theIconPath+"cancel.svg"));
    connect(enviButt,SIGNAL(clicked()),this,SLOT(clearEnvi()));
    connect(enviSelect,SIGNAL(clicked()),this,SLOT(selectEnvi()));
    /*wireButt = new QAction("Wiremodel while rotate",this);
    wireButt->setCheckable(true);
    wireButt->setChecked(false);//defaut changed 13.12.2019*/
    rainbowPlot = new QAction("Contour plot in rainbow colors",this);
    rainbowPlot->setCheckable(true);
    rainbowPlot->setChecked(false);
    rainbowPlot->setVisible(false);
    enviNoQ->setCheckable(true);
    enviNoQ->setChecked(false);
    enviCova->setCheckable(true);
    enviCova->setChecked(false);
    //printf("line %d\n", __LINE__);
}
PlayOpenGL::~PlayOpenGL(){
    makeCurrent();
    //printf("?bye-bye-opengl?\n");

    if (voro_vao.isCreated()) {
        voro_vao.release();
        voro_vao.destroy();
        voro_vertexBuffer.destroy();
    }
    if (uc_vao.isCreated()) {
        uc_vao.release();
        uc_vao.destroy();
        uc_vertexBuffer.destroy();
        uc_program->release();
        uc_program->removeAllShaders();
    }
    if (slct_vao.isCreated()) {
        slct_vao.release();
        slct_vao.destroy();
        satom_vertexBuffer.destroy();
        satom_indexBuffer.destroy();
        satom_program->release();
        satom_program->removeAllShaders();
    }
    if (map_vao.isCreated()) {
        map_vao.release();
        map_vao.destroy();
        map_vertexBuffer.destroy();
        map_program->release();
        map_program->removeAllShaders();
    }
    if (latom_vao.isCreated()) {
        latom_vao.release();
        latom_vao.destroy();
        latom_vertexBuffer.destroy();
        latom_indexBuffer.destroy();
        //latom_program->release();
        //latom_program->removeAllShaders();
    }

    if (envi_vao.isCreated()) {
        envi_vao.release();
        envi_vao.destroy();
        envi_vertexBuffer.destroy();
        envi_program->release();
        envi_program->removeAllShaders();
    }

    if (cont_vao.isCreated()) {
        cont_vao.release();
        cont_vao.destroy();
        cont_vertexBuffer.destroy();
        cont_program->release();
        cont_program->removeAllShaders();
    }
    if (atom_vao.isCreated()) {
        atom_vao.release();
        atom_vao.destroy();
        atom_vertexBuffer.destroy();
        atom_indexBuffer.destroy();
        atom_program->release();
        atom_program->removeAllShaders();
    }

    if (bond_vao.isCreated()) {
        bond_vao.release();
        bond_vao.destroy();
        bond_vertexBuffer.destroy();
        bond_indexBuffer.destroy();
    }

    if (bg_vao.isCreated()) {
        bg_vao.release();
        bg_vao.destroy();
        backGround_vertexBuffer.destroy();
        bg_program->release();
        bg_program->removeAllShaders();
    }
    //printf("bye-bye-opengl!\n");
}



void PlayOpenGL::setMolecule(Molecule *m){
    mol = m;

    //printf("line %d\n", __LINE__);
    if (mol->mynewnameis.startsWith("shelXle")){
        theIconPath=QString(":/xle-icons/");
    }else{
        theIconPath=QString(":/bicons/");
    }
    if (mol!=m) {
      if (mol) delete mol;
      mol=m;
    }
    double dim=mol->dimension();
    L=100.0/dim;
    //printf("line %d\n", __LINE__);
}
//QSize PlayOpenGL::sizeHint() const {return QSize(800,800);}
//QSize PlayOpenGL::minimumSizeHint() const {return QSize(60,60);}

int PlayOpenGL::commonFaces(Vert a,Vert b, int f[2]){
  int matches=0;
  for (int i=0; i<3; i++)
    for (int j=0; j<3; j++)
      if (a.faces[i]==b.faces[j])f[matches++]=a.faces[i];
  return matches;
}

void PlayOpenGL::voronoij(CEnvironment au, int intat){
  double dk,range=5.0;
  QString voroMsg;
  voroMsg.clear();
  voroMsg.append("<b>Voronoi:</b><br>");
  //QTime speedTest;
  //speedTest.start();
  vtriangles.clear();
  VPoly triangle;
  //vorobas=1;
  V3 prime,dp,D,floorD;
  QList<SdmItem> sdm;
  SdmItem sdmItem;
  sdmItem.a1=0;
  sdmItem.a2=1;
  sdmItem.sn=0;
  //sdmItem.p1=sdmItem.p2=V3(0,0,0);
  for (int i=0; i<au.size(); i++){
    for (int j=0; j<au.size(); j++ ){
      if ((au.at(i).sg)||(au.at(j).sg)) continue;
      //  bool hma=false;
      for (int n=0;n<mol->cell.symmops.size();  n++){
        prime=mol->cell.symmops.at(n) * au.at(i).frac + mol->cell.trans.at(n);
        D=prime - au.at(j).frac+ V3(0.5,0.5,0.5) ;
        floorD=V3(floor(D.x),floor(D.y),floor(D.z));
        for (int h=-1; h<2; h++){
          for (int k=-1; k<2; k++){
            for (int l=-1; l<2; l++){
              V3 fD=floorD+V3(h,k,l);
              dp=D - fD - V3(0.5,0.5,0.5);
              dk = mol->fl(dp.x,dp.y,dp.z);
              if ((dk>0.01)&&((range)>=dk)){
                sdmItem.d=dk;
                sdmItem.floorD=fD;
                sdmItem.a1=i;
                sdmItem.a2=j;
                sdmItem.sn=n;
                sdm.append(sdmItem);
              }
            }
          }
        }
      }
    }
  }
#if (QT_VERSION >= 0x050000)
  std::sort(sdm.begin(),sdm.end());
#else
  qSort(sdm.begin(),sdm.end());
#endif
  //SDMprint(sdm,au);
  QList<V3> n,m,doneLine;
  QList<int> intra, altcol;
  QList<Vert> v;
  Vert vert;
  V3 pf,pc,mx,nx,of,oc;
  Matrix mat;
  double vol=0.0,avol,tvol;
  for (int i=(intat>-1)?intat:0; i<au.size(); i++){
    if (au.at(i).an<0) continue;
    //find faces
    n.clear();
    m.clear();
    v.clear();
    doneLine.clear();
    intra.clear();
    avol=0.0;
    int faci=0;
    //int vcnt=0;
    mol->frac2kart(au.at(i).frac,oc);
    int tris=0;
    for (int j=0; j<sdm.size();j++){
      if(sdm.at(j).d<0.1) continue;
      if ((sdm.at(j).a2==i)&&(au[sdm.at(j).a1].an>-1)) {
        pf = mol->cell.symmops.at(sdm.at(j).sn) * au[sdm.at(j).a1].frac + mol->cell.trans.at(sdm.at(j).sn) - sdm.at(j).floorD;
        mol->frac2kart(pf,pc);
        mx =0.5*(oc+pc);
        nx = Normalize(pc-oc);
        bool exists = false;
        double dpl;
        for (int tp=0; tp<m.size(); tp++){
          dpl=n.at(tp)*(mx-m.at(tp));
          if (fabs(dpl)<0.001){exists=true;break;}
        }
        if (!exists){
          m.append(mx);
          n.append(nx);
          intra.append((sdm.at(j).sn==0)&&(Norm(sdm.at(j).floorD)==0.0));
          if (intat>-1)altcol.append(au[sdm.at(j).a1].an);
        }
      }//is neighbour of i
    }// j sdm
    for (int h=0; h<n.size()-2; h++)
      for (int k=h+1; k<n.size()-1; k++)
        for (int l=k+1; l<n.size(); l++){
          mat=Matrix(n.at(h),n.at(k),n.at(l));
          double d=determinant(mat),dpl;
          //printf("%d,%d,%d %9.5f\n",h,k,l,d);
          if (fabs(d)<0.0002) continue;

          //p = (dot(p1,n1)*cross(n2,n3)-dot(p2,n2)*cross(n1,n3)+dot(p3,n3)*cross(n1,n2))/d
          bool out=false;
          vert.pos=(
              (m.at(h)*n.at(h))*(n.at(k)%n.at(l))+
              (m.at(k)*n.at(k))*(n.at(l)%n.at(h))+
              (m.at(l)*n.at(l))*(n.at(h)%n.at(k)))*(1.0/d);
          vert.faces[0]=h;
          vert.faces[1]=k;
          vert.faces[2]=l;
          for (int pli=0; pli<n.size(); pli++){//teste lage zu allen ebenen
            dpl=n.at(pli)*(vert.pos-m.at(pli));
            if (dpl>0.00001) {
              out=true;
              break;
            }
          }
          if (!out) {
            v.append(vert);
            //  printf("[%d,%d,%d] %9.5f%9.5f%9.5f  \n",h,k,l,vert.pos.x,vert.pos.y,vert.pos.z);
          }
        }
    for (int mi=0; mi<m.size();mi++){// this is to get the midpoint of a face in its actual center
      V3 mnew=V3(0,0,0);
      int poli=0;
      for (int vi=0; vi<v.size(); vi++){
        if ((v.at(vi).faces[0]==mi)||(v.at(vi).faces[1]==mi)||(v.at(vi).faces[2]==mi)){
          mnew+=v.at(vi).pos;
          poli++;
        }
      }
      mnew*=1.0/poli;
      //      printf("%dsoll 0=%f\n",poli,n.at(mi)*(mnew-m.at(mi)));
      if (poli) {m[mi]=mnew;faci++;}
    }

    for(int vi=0; vi<v.size()-1; vi++)
      for(int vj=vi+1; vj<v.size(); vj++){
        int fc[2];
        if (commonFaces(v.at(vi),v.at(vj),fc)==2){
          V3 lin=v.at(vi).pos+v.at(vj).pos;
          double dis;
          bool done=false;
          for (int di=0; di<doneLine.size(); di++){
            dis=Distance(lin,doneLine.at(di));
            if (dis<0.000001) {done=true; break;}
          }
          if (done) continue;
          doneLine.append(lin);
          tvol=determinant(Matrix(m.at(fc[0])-oc, v.at(vi).pos-oc,v.at(vj).pos-oc));
          int v1=(tvol<0)?vj:vi,
              v2=(tvol<0)?vi:vj;
          triangle.mid=m.at(fc[0]);
          triangle.nor=n.at(fc[0]);
          triangle.acol=(intat>-1)?altcol.at(fc[0]):au[i].an;
          triangle.intra=(intat>-1)?0:intra.at(fc[0]);
          triangle.verts0=v[v1].pos;
          triangle.verts1=v[v2].pos;

          vtriangles.append(triangle);

          tris++;
          double tv=fabs(tvol)/6.0;
          avol+=tv;
          vol+=tv*au[i].sof;
          tvol=determinant(Matrix(m.at(fc[1])-oc, v.at(vi).pos-oc,v.at(vj).pos-oc));
          v1=(tvol<0)?vj:vi;
          v2=(tvol<0)?vi:vj;
          triangle.mid=m.at(fc[1]);
          triangle.nor=n.at(fc[1]);

          triangle.acol=(intat>-1)?altcol.at(fc[1]):au[i].an;
          triangle.intra=(intat>-1)?0:intra.at(fc[1]);
          //         triangle.col[3]=((intat>-1)&&(intra.at(fc[1])))?0.8:0.4;
          triangle.verts0=v[v1].pos;
          triangle.verts1=v[v2].pos;
          vtriangles.append(triangle);
          tris++;
          tv=fabs(tvol)/6.0;
          avol+=tv;
          vol+=tv*au[i].sof;
        }
      }
    printf("%-12s: Triangles %6d Volume %18.5f\n", au.at(i).Label.toStdString().c_str(), tris, avol);
    voroMsg.append(QString("%1 : EulerTest: %2 Volume %3 &Aring;<sup>3</sup>.<br>").arg(au.at(i).Label).arg(-tris/2+faci+v.size()).arg(avol));

    if (intat>-1) break;
  }//i atoms au
  if (intat==-1) {
    printf("Total Volume= %18.5f Total Volume * z = %18.5f cell volume %18.5f delta =%f%%\n",
           vol,
           vol*mol->cell.symmops.size(),
           mol->cell.V,
           (vol*mol->cell.symmops.size()-mol->cell.V)/mol->cell.V*100.0);
    voroMsg.append(QString("Total Volume= %1 &Aring;<sup>3</sup> cell volume %2 &Aring;<sup>3</sup> &Delta;V %3%<br>")
                   .arg(vol*mol->cell.symmops.size())
                   .arg(mol->cell.V)
                   .arg((vol*mol->cell.symmops.size()-mol->cell.V)/mol->cell.V*100.0));
  }
  emit bigmessage(voroMsg);
  //  printf("drawing %dms\n",speedTest.restart());
 // eye=auge;
  /*
#if (QT_VERSION >= 0x050000)
  std::sort(vtriangles.begin(),vtriangles.end(),vbyeye);
#else
  qSort(vtriangles.begin(),vtriangles.end(),vbyeye);
#endif
*/
  QVector<float> vp;
  for (int ti=0; ti<vtriangles.size(); ti++){
      QColor c=mol->atomColor(vtriangles.at(ti).acol);
      vp.append(vtriangles.at(ti).mid.x);
      vp.append(vtriangles.at(ti).mid.y);
      vp.append(vtriangles.at(ti).mid.z);
      vp.append(static_cast<float>(vtriangles.at(ti).acol)+0.99*c.blueF());

      vp.append(vtriangles.at(ti).nor.x);
      vp.append(vtriangles.at(ti).nor.y);
      vp.append(vtriangles.at(ti).nor.z);
      vp.append(static_cast<float>(vtriangles.at(ti).intra));

      vp.append(vtriangles.at(ti).verts0.x);
      vp.append(vtriangles.at(ti).verts0.y);
      vp.append(vtriangles.at(ti).verts0.z);
      vp.append(c.redF());

      vp.append(vtriangles.at(ti).verts1.x);
      vp.append(vtriangles.at(ti).verts1.y);
      vp.append(vtriangles.at(ti).verts1.z);
      vp.append(c.greenF());

  }

  makeCurrent();
  voro_vao.release();
  if (voro_vao.isCreated()) {
      voro_vao.release();
      voro_vao.destroy();
      voro_vertexBuffer.destroy();
      //voro_indexBuffer.destroy();
  }
  voro_vao.create();
  voro_vao.bind();
  voro_vertexBuffer.create();
  voro_vertexBuffer.setUsagePattern( QOpenGLBuffer::StaticDraw );
  //glDisable(GL_BLEND);
  if (!voro_vertexBuffer.bind()) {printf("voro_vertexBuffer: I was unable to bind!\n");}
  voro_vertexBuffer.allocate(vp.data(), vp.size()*sizeof(float));
  if (!voro_program) voro_program = new QOpenGLShaderProgram(this);
  else voro_program->removeAllShaders();
  //printf("%p %d\n",voro_program, voro_program->programId());

  bool result = voro_program->addCacheableShaderFromSourceFile( QOpenGLShader::Vertex, ":/shaders/voro.vert");
  //printf("%d\n",__LINE__);
  if ( !result ) qWarning() << voro_program->log();
  result = voro_program->addCacheableShaderFromSourceFile( QOpenGLShader::Geometry, ":/shaders/voro.geom");
  //printf("%d\n",__LINE__);
  if ( !result ) qWarning() << voro_program->log();
  result = voro_program->addCacheableShaderFromSourceFile( QOpenGLShader::Fragment, ":/shaders/voro.frag");

  if ( !result ) qWarning() << voro_program->log();
  result = voro_program->link();
 if ( !result ) qWarning() << voro_program->log();
  if ( !voro_program->bind() )    {
      qWarning() << "Could not bind shader program to context";
      return;
  }


  programInfo(voro_program,"voro");

  voro_program->enableAttributeArray(0);//mid
  voro_program->enableAttributeArray(1);//nor
  voro_program->enableAttributeArray(2);//vert0
  voro_program->enableAttributeArray(3);//vert1
  //printf("%d\n",__LINE__);
  int stride = 4 * 4 * sizeof(float);
  voro_program->setAttributeBuffer(0, GL_FLOAT, 0, 4, stride);
  voro_program->setAttributeBuffer(1, GL_FLOAT, sizeof(float)*4  , 4, stride);
  voro_program->setAttributeBuffer(2, GL_FLOAT, sizeof(float)*8  , 4, stride);
  voro_program->setAttributeBuffer(3, GL_FLOAT, sizeof(float)*12  , 4, stride);


  voro_program->release();
  voro_vao.release();
  voro_vertexBuffer.release();
  voro_vertexBuffer.destroy();
  update();

}//voronoij
/*V3 eye;
bool PlayOpenGL::vbyeye(VPoly a,VPoly b){
  //return (Distance((a.mid+a.verts0+a.verts1)*0.33333,eye)>Distance((b.mid+b.verts0+b.verts1)*0.33333,eye));
  return (mol->Distance(a.mid,eye)>Distance(b.mid,eye));
}*/



void PlayOpenGL::connectSelection(){//!creates a bond betwen two selected atoms.
  if (mol->selectedatoms.size()!=2) return;
  MyBond b;
  b.a1=mol->selectedatoms.at(0).style;
  b.a2=mol->selectedatoms.at(1).style;
  b.ato1=&mol->showatoms[mol->selectedatoms.at(0).style];
  b.ato2=&mol->showatoms[mol->selectedatoms.at(1).style];
  b.length=sqrt(Distance(b.ato1->pos,b.ato2->pos));
  mol->showbonds.append(b);
  mol->selectedatoms.clear();
  updateBondActions();
  update();
}

void PlayOpenGL::disConnectSelection(int index){//! destroyes the bond between two selected atoms.
  mol->showbonds.removeAt(index);
  mol->selectedatoms.clear();
  updateBondActions();
  update();
}

void PlayOpenGL::disSelection(){//! Un select everything.
  mol->selectedatoms.clear();
  //apair.clear();
  updateBondActions();
  update();
}

void PlayOpenGL::addANIS(){
  emit insertANIS(mol->selectedatoms);
  mol->selectedatoms.clear();
}

void PlayOpenGL::addCHIV(){
  QDialog *dia = new QDialog();
  dia->setWindowTitle(tr("CHIV: Geometrical restraint"));
  dia->setModal(false);

  QGridLayout *grid = new QGridLayout(dia);
  QLineEdit *volline = new QLineEdit(dia);
  QLineEdit *esd1line = new QLineEdit(dia);
  QLabel *vol = new QLabel("Volume:", dia);
  QLabel *esd1 = new QLabel("ESD:", dia);
  // Set default value for distance and esd
  volline->setText("0.0");
  esd1line->setText("0.1");
  int i(0); // index for position of widgets in the container
  grid->addWidget(vol,i,0);
  grid->addWidget(volline,i++,1);
  grid->addWidget(esd1,i,0);
  grid->addWidget(esd1line,i++,1);
  QStringList rl = resis();
  QComboBox *resiCom = NULL;
  if (!rl.isEmpty()){
    QLabel *resi = new QLabel("Residue specific",dia);
    resiCom = new QComboBox(dia);
    resiCom->addItem("");
    resiCom->addItems(rl);
    grid->addWidget(resi,i,0);
    grid->addWidget(resiCom,i++,1);
  }

  QDialogButtonBox *buttonBox = new QDialogButtonBox();

  QPushButton *OkButton;
  QPushButton *CancelButton;

  OkButton = buttonBox->addButton(QDialogButtonBox::Ok);
  CancelButton = buttonBox->addButton(QDialogButtonBox::Cancel);

  buttonBox->setOrientation(Qt::Horizontal);

  grid->addWidget(buttonBox,i,0);

  dia->setLayout(grid);
  connect(OkButton, SIGNAL(clicked()), dia, SLOT(accept()));
  connect(CancelButton, SIGNAL(clicked()), dia, SLOT(reject()));

  dia->show();
  int a  = dia->exec();

  if(a == QDialog::Accepted)
  {
    // read value from value line
    QString s=(rl.isEmpty())?"":resiCom->currentText();
    emit insertCHIV(volline->text().toDouble(),esd1line->text().toDouble(),mol->selectedatoms,s);
    mol->selectedatoms.clear();
  }
  else
  {
    if(a == QDialog::Rejected)
      dia->close();
  }
}

void PlayOpenGL::addDANG(){
  QDialog *dia = new QDialog();
  dia->setWindowTitle(tr("DANG: Geometrical restraint"));
  dia->setModal(false);

  QGridLayout *grid = new QGridLayout(dia);
  QLineEdit *valueline = new QLineEdit(dia);
  QLineEdit *esdline = new QLineEdit(dia);
  QLabel *value = new QLabel("Value:", dia);
  QLabel *esd = new QLabel("ESD:", dia);
  QStringList rl = resis();
  QComboBox *resiCom = NULL;
  if (!rl.isEmpty()){
    QLabel *resi = new QLabel("Residue specific",dia);
    resiCom = new QComboBox(dia);
    resiCom->addItem("");
    resiCom->addItems(rl);
    grid->addWidget(resi,2,0);
    grid->addWidget(resiCom,2,1);
  }
  // Set default value for distance and esd
  // Get value for DANG. Current bond distance and default esd - 0.04
  valueline->setText(QString::number(sqrt(Distance(mol->selectedatoms.at(0).pos,mol->selectedatoms.at(1).pos)),10,3));
  esdline->setText("0.04");

  grid->addWidget(value,0,0);
  grid->addWidget(valueline,0,1);
  grid->addWidget(esd,1,0);
  grid->addWidget(esdline,1,1);

  QDialogButtonBox *buttonBox = new QDialogButtonBox();

  QPushButton *OkButton;
  QPushButton *CancelButton;

  OkButton = buttonBox->addButton(QDialogButtonBox::Ok);
  CancelButton = buttonBox->addButton(QDialogButtonBox::Cancel);

  buttonBox->setOrientation(Qt::Horizontal);

  grid->addWidget(buttonBox,4,0);

  dia->setLayout(grid);
  connect(OkButton, SIGNAL(clicked()), dia, SLOT(accept()));
  connect(CancelButton, SIGNAL(clicked()), dia, SLOT(reject()));

  dia->show();
  int a  = dia->exec();

  if(a == QDialog::Accepted)
  {
    // read value from value line
    QString s=(rl.isEmpty())?"":resiCom->currentText();
    emit insertDANG(valueline->text().toDouble(),esdline->text().toDouble(),mol->selectedatoms,s);
    mol->selectedatoms.clear();
  }
  else
  {
    if(a == QDialog::Rejected)
      dia->close();
  }

}

void PlayOpenGL::addDELU(){
  QDialog *dia = new QDialog();
  dia->setWindowTitle(tr("DELU: ADP restraint"));
  dia->setModal(false);

  QGridLayout *grid = new QGridLayout(dia);
  QLineEdit *esd1line = new QLineEdit(dia);
  QLineEdit *esd2line = new QLineEdit(dia);
  QLabel *esd1 = new QLabel("ESD1:", dia);
  QLabel *esd2 = new QLabel("ESD2:", dia);
  // Set default value for distance and esd
  esd1line->setText("0.01");
  esd2line->setText("0.01");

  grid->addWidget(esd1,0,0);
  grid->addWidget(esd1line,0,1);
  grid->addWidget(esd2,1,0);
  grid->addWidget(esd2line,1,1);
  QStringList rl = resis();
  QComboBox *resiCom = NULL;
  if (!rl.isEmpty()){
    QLabel *resi = new QLabel("Residue specific",dia);
    resiCom = new QComboBox(dia);
    resiCom->addItem("");
    resiCom->addItems(rl);
    grid->addWidget(resi,3,0);
    grid->addWidget(resiCom,3,1);
  }

  QDialogButtonBox *buttonBox = new QDialogButtonBox();

  QPushButton *OkButton;
  QPushButton *CancelButton;

  OkButton = buttonBox->addButton(QDialogButtonBox::Ok);
  CancelButton = buttonBox->addButton(QDialogButtonBox::Cancel);

  buttonBox->setOrientation(Qt::Horizontal);

  grid->addWidget(buttonBox,4,0);

  dia->setLayout(grid);
  connect(OkButton, SIGNAL(clicked()), dia, SLOT(accept()));
  connect(CancelButton, SIGNAL(clicked()), dia, SLOT(reject()));

  dia->show();
  int a  = dia->exec();

  if(a == QDialog::Accepted)
  {
    // read value from value line
    QString s=(rl.isEmpty())?"":resiCom->currentText();
    emit insertDELU(esd1line->text().toDouble(),esd2line->text().toDouble(),mol->selectedatoms,s);
    mol->selectedatoms.clear();
  }
  else
  {
    if(a == QDialog::Rejected)
      dia->close();
  }
}

void PlayOpenGL::addDFIX(){
    if (mol->selectedatoms.size()!=2)return;
  QDialog *dia = new QDialog();
  dia->setWindowTitle("DFIX: Geometrical restraint");
  dia->setModal(false);

  QGridLayout *grid = new QGridLayout(dia);
  QLineEdit *valueline = new QLineEdit(dia);
  valueline->setObjectName("DFIX_DIST");
  QLineEdit *esdline = new QLineEdit(dia);
  QLabel *value = new QLabel("Value:", dia);
  QLabel *esd = new QLabel("ESD:", dia);
  QLabel *atoms = new QLabel(QString("%1==%2  : %3 A")
                             .arg(mol->selectedatoms.at(0).Label)
                             .arg(mol->selectedatoms.at(1).Label)
                             .arg( sqrt(Distance(mol->selectedatoms.at(0).pos,mol->selectedatoms.at(1).pos)),10,'f',3));
  QCheckBox *bindit = new QCheckBox("Insert BIND instruction",dia);
  QStringList rl = resis();
  QComboBox *resiCom = NULL;
  if (!rl.isEmpty()){
    QLabel *resi = new QLabel("Residue specific",dia);
    resiCom = new QComboBox(dia);
    // Usually you want to define residue restraints with numbers at the atom:
    resiCom->addItem("");
    resiCom->addItems(rl);
    grid->addWidget(resi,3,0);
    grid->addWidget(resiCom,3,1);
  }
  // Set default value for distance and esd
  // Get value for DFIX. Current bond distance and default esd - 0.02
  valueline->setText(QString::number(sqrt(Distance(mol->selectedatoms.at(0).pos,mol->selectedatoms.at(1).pos)),10,3));
  esdline->setText("0.02");
  grid->addWidget(atoms,0,0,1,2);
  grid->addWidget(value,1,0);
  grid->addWidget(valueline,1,1);
  grid->addWidget(esd,2,0);
  grid->addWidget(esdline,2,1);
  grid->addWidget(bindit,4,0);
  QDialogButtonBox *buttonBox = new QDialogButtonBox();

  QPushButton *OkButton;
  QPushButton *CancelButton;
  QPushButton *singleBondButton = new QPushButton(QString("%1 A").arg(0.01*(mol->Kovalenz_Radien[mol->selectedatoms.at(0).an]+mol->Kovalenz_Radien[mol->selectedatoms.at(1).an])));

  OkButton = buttonBox->addButton(QDialogButtonBox::Ok);
  CancelButton = buttonBox->addButton(QDialogButtonBox::Cancel);
  buttonBox->addButton(singleBondButton,QDialogButtonBox::ActionRole);


  buttonBox->setOrientation(Qt::Horizontal);

  grid->addWidget(buttonBox,10,0);

  dia->setLayout(grid);
  connect(OkButton, SIGNAL(clicked()), dia, SLOT(accept()));
  connect(CancelButton, SIGNAL(clicked()), dia, SLOT(reject()));
  connect(singleBondButton, SIGNAL(clicked()), this, SLOT(singleBondDistance()));

  dia->show();
  int a  = dia->exec();

  if(a == QDialog::Accepted)  {
    // read value from value line
    QString s=(rl.isEmpty())?"":resiCom->currentText();
    emit insertDFIX(valueline->text().toDouble(),esdline->text().toDouble(),mol->selectedatoms,s);
    if (bindit->isChecked()) emit bindthem();
    mol->selectedatoms.clear();
  }
  else  {
    if(a == QDialog::Rejected)
      dia->close();
  }
  //    updateBondActions();
}

void PlayOpenGL::addEADP(){
  emit insertEADP(mol->selectedatoms);
  mol->selectedatoms.clear();
}

void PlayOpenGL::addEXYZ(){
  emit insertEXYZ(mol->selectedatoms);
  mol->selectedatoms.clear();
}

void PlayOpenGL::addFLAT(){
  QDialog *dia = new QDialog();
  dia->setWindowTitle(tr("FLAT: Geometrical restraint"));
  dia->setModal(false);

  QGridLayout *grid = new QGridLayout(dia);
  QLineEdit *esdline = new QLineEdit(dia);
  QLabel *esd = new QLabel("ESD:", dia);
  QStringList rl = resis();
  QComboBox *resiCom = NULL;
  if (!rl.isEmpty()){
    QLabel *resi = new QLabel("Residue specific",dia);
    resiCom = new QComboBox(dia);
    resiCom->addItem("");
    resiCom->addItems(rl);
    grid->addWidget(resi,2,0);
    grid->addWidget(resiCom,2,1);
  }
  // Set default value for esd
  esdline->setText("0.1");

  grid->addWidget(esd,0,0);
  grid->addWidget(esdline,0,1);

  QDialogButtonBox *buttonBox = new QDialogButtonBox();

  QPushButton *OkButton;
  QPushButton *CancelButton;

  OkButton = buttonBox->addButton(QDialogButtonBox::Ok);
  CancelButton = buttonBox->addButton(QDialogButtonBox::Cancel);

  buttonBox->setOrientation(Qt::Horizontal);

  grid->addWidget(buttonBox,1,0);

  dia->setLayout(grid);
  connect(OkButton, SIGNAL(clicked()), dia, SLOT(accept()));
  connect(CancelButton, SIGNAL(clicked()), dia, SLOT(reject()));

  dia->show();
  int a  = dia->exec();

  if(a == QDialog::Accepted)
  {
    // read value from value line
    QString s=(rl.isEmpty())?"":resiCom->currentText();
    emit insertFLAT(esdline->text().toDouble(),mol->selectedatoms,s);
    mol->selectedatoms.clear();
  }
  else
  {
    if(a == QDialog::Rejected)
      dia->close();
  }

}

void PlayOpenGL::addISOR(){
  QDialog *dia = new QDialog();
  dia->setWindowTitle(tr("ISOR: ADP restraint"));
  dia->setModal(false);

  QGridLayout *grid = new QGridLayout(dia);
  QLineEdit *esd1line = new QLineEdit(dia);
  QLineEdit *esd2line = new QLineEdit(dia);
  QLabel *esd1 = new QLabel("ESD1:", dia);
  QLabel *esd2 = new QLabel("ESD2:", dia);
  QStringList rl = resis();
  QComboBox *resiCom = NULL;
  if (!rl.isEmpty()){
    QLabel *resi = new QLabel("Residue specific",dia);
    resiCom = new QComboBox(dia);
    resiCom->addItem("");
    resiCom->addItems(rl);
    grid->addWidget(resi,3,0);
    grid->addWidget(resiCom,3,1);
  }
  // Set default values for s and st
  esd1line->setText("0.1");
  esd2line->setText("0.2");

  grid->addWidget(esd1,0,0);
  grid->addWidget(esd1line,0,1);
  grid->addWidget(esd2,1,0);
  grid->addWidget(esd2line,1,1);

  QDialogButtonBox *buttonBox = new QDialogButtonBox();

  QPushButton *OkButton;
  QPushButton *CancelButton;

  OkButton = buttonBox->addButton(QDialogButtonBox::Ok);
  CancelButton = buttonBox->addButton(QDialogButtonBox::Cancel);

  buttonBox->setOrientation(Qt::Horizontal);

  grid->addWidget(buttonBox,4,0);

  dia->setLayout(grid);
  connect(OkButton, SIGNAL(clicked()), dia, SLOT(accept()));
  connect(CancelButton, SIGNAL(clicked()), dia, SLOT(reject()));

  dia->show();
  int a  = dia->exec();

  if(a == QDialog::Accepted)
  {
    // read value from value line
    QString s=(rl.isEmpty())?"":resiCom->currentText();
    emit insertISOR(esd1line->text().toDouble(),esd2line->text().toDouble(),mol->selectedatoms,s);
    mol->selectedatoms.clear();
  }
  else
  {
    if(a == QDialog::Rejected)
      dia->close();
  }
}

void PlayOpenGL::addRIGU(){
  QDialog *dia = new QDialog();
  dia->setWindowTitle(tr("RIGU: ADP restraint"));
  dia->setModal(false);

  QGridLayout *grid = new QGridLayout(dia);
  QLineEdit *esd1line = new QLineEdit(dia);
  QLineEdit *esd2line = new QLineEdit(dia);
  QLabel *esd1 = new QLabel("ESD1:", dia);
  QLabel *esd2 = new QLabel("ESD2:", dia);
  // Set default value for distance and esd
  esd1line->setText("0.004");
  esd2line->setText("0.004");
  int i(0); // index for position of widgets in the container
  grid->addWidget(esd1,i,0);
  grid->addWidget(esd1line,i++,1);
  grid->addWidget(esd2,i,0);
  grid->addWidget(esd2line,i++,1);
  QStringList rl = resis();
  QComboBox *resiCom = NULL;
  if (!rl.isEmpty()){
    QLabel *resi = new QLabel("Residue specific",dia);
    resiCom = new QComboBox(dia);
    resiCom->addItem("");
    resiCom->addItems(rl);
    grid->addWidget(resi,i,0);
    grid->addWidget(resiCom,i++,1);
  }

  QDialogButtonBox *buttonBox = new QDialogButtonBox();

  QPushButton *OkButton;
  QPushButton *CancelButton;

  OkButton = buttonBox->addButton(QDialogButtonBox::Ok);
  CancelButton = buttonBox->addButton(QDialogButtonBox::Cancel);

  buttonBox->setOrientation(Qt::Horizontal);

  grid->addWidget(buttonBox,i,0);

  dia->setLayout(grid);
  connect(OkButton, SIGNAL(clicked()), dia, SLOT(accept()));
  connect(CancelButton, SIGNAL(clicked()), dia, SLOT(reject()));

  dia->show();
  int a  = dia->exec();

  if(a == QDialog::Accepted)
  {
    // read value from value line
    QString s=(rl.isEmpty())?"":resiCom->currentText();
    emit insertRIGU(esd1line->text().toDouble(),esd2line->text().toDouble(),mol->selectedatoms,s);
    mol->selectedatoms.clear();
  }
  else
  {
    if(a == QDialog::Rejected)
      dia->close();
  }
}

void PlayOpenGL::addSADI() {
  //! Adds SADI restraints between the selected atom and all bonded atoms.
  QAction *action = qobject_cast<QAction *>(sender());
  int index=-1;
  if (action)
    index=action->data().toInt();
  else index=-1;
  if (index>mol->asymm.size()) index=-1;
  if (index!=-1) {
    emit insertSADI(index);
  }
}

QList<int> PlayOpenGL::lastClicked(){
  QList<int> pppp;
  //if ((ppp>=0)&&(ppp<mol->showatoms.size())&&(ppp!=pp)&&(ppp!=p)) pppp.append(ppp);
  if ((  p>=0)&&(  p<mol->showatoms.size())) pppp.append(p);
  if (( pp>=0)&&( pp<mol->showatoms.size())&&(pp!=p)) pppp.append(pp);
  return pppp;
}


void PlayOpenGL::addSIMU(){
  QDialog *dia = new QDialog();
  dia->setWindowTitle(tr("SIMU: ADP restraint"));
  dia->setModal(false);

  QGridLayout *grid = new QGridLayout(dia);
  QLineEdit *esd1line = new QLineEdit(dia);
  QLineEdit *esd2line = new QLineEdit(dia);
  QLineEdit *dmaxline = new QLineEdit(dia);
  QLabel *esd1 = new QLabel("ESD1:", dia);
  QLabel *esd2 = new QLabel("ESD2:", dia);
  QLabel *dmax = new QLabel("dmax:", dia);
  // Set default value for distance and esd
  esd1line->setText("0.04");
  esd2line->setText("0.08");
  dmaxline->setText("2.00");

  grid->addWidget(esd1,0,0);
  grid->addWidget(esd1line,0,1);
  grid->addWidget(esd2,1,0);
  grid->addWidget(esd2line,1,1);
  grid->addWidget(dmax,2,0);
  grid->addWidget(dmaxline,2,1);
  QStringList rl = resis();
  QComboBox *resiCom = NULL;
  if (!rl.isEmpty()){
    QLabel *resi = new QLabel("Residue specific", dia);
    resiCom = new QComboBox(dia);
    // Usually you want to define residue restraints with numbers at the atom:
    resiCom->addItem("");
    resiCom->addItems(rl);
    grid->addWidget(resi,3,0);
    grid->addWidget(resiCom,3,1);
  }

  QDialogButtonBox *buttonBox = new QDialogButtonBox();

  QPushButton *OkButton;
  QPushButton *CancelButton;

  OkButton = buttonBox->addButton(QDialogButtonBox::Ok);
  CancelButton = buttonBox->addButton(QDialogButtonBox::Cancel);

  buttonBox->setOrientation(Qt::Horizontal);

  grid->addWidget(buttonBox,4,0);

  dia->setLayout(grid);
  connect(OkButton, SIGNAL(clicked()), dia, SLOT(accept()));
  connect(CancelButton, SIGNAL(clicked()), dia, SLOT(reject()));

  dia->show();
  int a  = dia->exec();

  if(a == QDialog::Accepted)
  {
    // read value from value line
    QString s=(rl.isEmpty())?"":resiCom->currentText();
    emit insertSIMU(esd1line->text().toDouble(),esd2line->text().toDouble(),dmaxline->text().toDouble(),mol->selectedatoms,s);
    mol->selectedatoms.clear();
  }
  else
  {
    if(a == QDialog::Rejected)
      dia->close();
  }

}

QStringList PlayOpenGL::resis(){
  QStringList l;
  for (int i=0; i<mol->asymm.size(); i++){
      if (mol->asymm.at(i).an<0)continue;
    if (mol->asymm.at(i).resiNr>0){
      if (!l.contains(QString::number(mol->asymm.at(i).resiNr),Qt::CaseInsensitive))
        l.append(QString::number(mol->asymm.at(i).resiNr));
      if (!l.contains(mol->asymm.at(i).ResiClass))
        l.append(mol->asymm.at(i).ResiClass);
    }
  }
  if (!l.isEmpty()) l.insert(0,"*");
  return l;
}

void PlayOpenGL::singleBondDistance(){
    if (mol->selectedatoms.size()!=2)return;
    QWidgetList wl = QApplication::allWidgets();
    for (int i=0; i<wl.size(); i++){
        if (wl.at(i)->objectName()=="DFIX_DIST"){
            QLineEdit *valueline = qobject_cast<QLineEdit *>(wl[i]);
            valueline->setText(QString::number(0.01*(mol->Kovalenz_Radien[mol->selectedatoms.at(0).an]+mol->Kovalenz_Radien[mol->selectedatoms.at(1).an]),10,3));
        }
    }
}

void PlayOpenGL::changeEnviRange(){//! a dialog for a new ChGL.envirange.
  bool ok;
  double r=QInputDialog::getDouble (nullptr,"Envi-Range", "change environment range", envirange,0.7,8.0,2,&ok);
  if (ok) envirange=r;
  QAction *action = qobject_cast<QAction *>(sender());
  int index=0;
  if (action)
    index=action->data().toInt();
  else index=rotze;//return;
  if (index<0) return;
  if (ok) envi();
}

void PlayOpenGL::growEnvi(){
    QAction *action = qobject_cast<QAction *>(sender());
    int index=0;
    if (action)
      index=action->data().toInt();
    else index=rotze;//return;
    if (index<0) return;
    if (!isMainWindow) return;
    if (index>=mol->asymm.size())return;
    mol->enviSDM(envirange);

    QString systr;
    QStringList bs;
    for (int i = 0; i < mol->envi_sdm.size(); i++){
      if ((mol->envi_sdm.at(i).a2==index)&&mol->envi_sdm.at(i).d<envirange) {
        if ((!mol->envi_sdm.at(i).covalent)&&(enviCova->isChecked())) continue;
        if ((mol->asymm[mol->envi_sdm.at(i).a1].an==-1)&&(enviNoQ->isChecked())) continue;
        bool symm=((mol->envi_sdm.at(i).sn)||(!(mol->envi_sdm.at(i).floorD==V3(0,0,0))));
        if (symm) {
          QString sss=QString("%1_%2%3%4:%5,").arg(mol->envi_sdm.at(i).sn+1).arg(5-(int)mol->envi_sdm.at(i).floorD.x).arg(5-(int)mol->envi_sdm.at(i).floorD.y).arg(5-(int)mol->envi_sdm.at(i).floorD.z).arg(mol->asymm[mol->envi_sdm.at(i).a1].molindex);
          if (!bs.contains(sss)){
            bs.append(sss);
          }
          systr=QString("%1%2").arg(QString::fromUtf8("»")).arg(bs.indexOf(sss)+1);
        }
      }
    }
    mol->usedSymmetry+=bs;
    mol->complete();

    fuse->setVisible(true);
    grow->setVisible(false);
    emit bigmessage(mol->HumanSymmetry);
    makeAtoms(mol->showatoms);
    makeBonds(mol->showatoms, mol->showbonds, mol->lbonds, mol->theH_Bonds);
    update();
}

void PlayOpenGL::showEnvi(){
    QAction *action = qobject_cast<QAction *>(sender());
    int index=0;
    if (action)
      index=action->data().toInt();
    else index=rotze;//return;
    if (index<0) return;
    if (!isMainWindow) return;
    if (index>=mol->asymm.size())return;
    mol->enviSDM(envirange);

    QString systr;
    QStringList bs;
    for (int i = 0; i < mol->envi_sdm.size(); i++){
      if ((mol->envi_sdm.at(i).a2==index)&&mol->envi_sdm.at(i).d<envirange) {
        if ((!mol->envi_sdm.at(i).covalent)&&(enviCova->isChecked())) continue;
        if ((mol->asymm[mol->envi_sdm.at(i).a1].an==-1)&&(enviNoQ->isChecked())) continue;
        bool symm=((mol->envi_sdm.at(i).sn)||(!(mol->envi_sdm.at(i).floorD==V3(0,0,0))));
        if (symm) {
          QString sss=QString("%1_%2%3%4:%5,").arg(mol->envi_sdm.at(i).sn+1).arg(5-(int)mol->envi_sdm.at(i).floorD.x).arg(5-(int)mol->envi_sdm.at(i).floorD.y).arg(5-(int)mol->envi_sdm.at(i).floorD.z).arg(mol->asymm[mol->envi_sdm.at(i).a1].molindex);
          if (!bs.contains(sss)){
            bs.append(sss);
          }
          systr=QString("%1%2").arg(QString::fromUtf8("»")).arg(bs.indexOf(sss)+1);
        }
      }
    }
    mol->usedSymmetry+=bs;
    mol->complete();
    V3 p0 = mol->asymm.at(index).pos;
    double er2=envirange*envirange;
    for (int i = 0; i < mol->showatoms.size(); i++){
        double d = Distance(p0, mol->showatoms.at(i).pos);
        //printf("s env %f %d %d\n", d, i, mol->showatoms.size());
        if (d > er2) mol->showatoms[i].hidden=1;
    }
    hiddenThings = true;
    fuse->setVisible(true);
    grow->setVisible(false);
    emit bigmessage(mol->HumanSymmetry);
    //printf("show envi\n");
    makeAtoms(mol->showatoms);
    //printf("show envi\n");
    makeBonds(mol->showatoms, mol->showbonds, mol->lbonds, mol->theH_Bonds);

    makeSelectedAtoms();
   // murx=-__LINE__;
    updateBondActions();
    //printf("show envi\n");
    update();
}

void PlayOpenGL::envi(){
  /*! Finds neighboring atoms around a ChGL.envirange the spezified atom and passes a html table via ChGL.bigmessage
   * Feeds ChGL.enviPositions, ChGL.labs  and ChGL.enviKat.
   * sets the rotation center to the spezified atom.
   * */
  printf("->-ENVI-<- %d\n",mol->asymm.size());
  QAction *action = qobject_cast<QAction *>(sender());
  int index=0;
  if (action)
    index=action->data().toInt();
  else index=rotze;//return;
  if (index<0) return;
  if (!isMainWindow){
      enviP0=mol->showatoms.at(index).pos;

      for (int i=0; i<mol->showatoms.size(); i++){
          double d = sqrt(Distance(mol->showatoms.at(index).pos,mol->showatoms.at(i).pos));
          int an1=mol->showatoms.at(i).an;
          int an2=mol->showatoms.at(index).an;
          double dddd=(mol->Kovalenz_Radien[an1]+ mol->Kovalenz_Radien[an2])*0.012;
          bool cov=(d<dddd);
          if (d<envirange) {
            if ((!cov)&&(enviCova->isChecked())) continue;
            if ((an1<0)&&(enviNoQ->isChecked())) continue;
            enviPositions.append(mol->showatoms.at(i).pos);
            enviKat.append((cov)?1:0);
            labs.append(mol->showatoms.at(i).Label);
          }
      }
      enviButt->show();
      enviSelect->show();
      makeEnvi();
      return;
  }
  if (index>=mol->asymm.size())return;
  mol->enviSDM(envirange);
  enviPositions.clear();
  enviKat.clear();
  labs.clear();
  QList<bool> covs;
  //pause=true;

  V3 ppc,ppf,p0;
  // int ssy=0;
  QString systr;
  QStringList bs;
  QString info;
  enviP0=mol->asymm.at(index).pos;
  info.append(QString("<hr><b>Environment of %1 </b><table border=\"0\" cellspacing=\"0\" cellpadding=\"5\">").arg(mol->asymm[index].Label));
  for (int i = 0; i < mol->envi_sdm.size(); i++){
    if ((mol->envi_sdm.at(i).a2==index)&&mol->envi_sdm.at(i).d<envirange) {
      if ((!mol->envi_sdm.at(i).covalent)&&(enviCova->isChecked())) continue;
      if ((mol->asymm[mol->envi_sdm.at(i).a1].an==-1)&&(enviNoQ->isChecked())) continue;
      ppf=mol->cell.symmops.at(mol->envi_sdm.at(i).sn) *
        mol->asymm[mol->envi_sdm.at(i).a1].frac +
        mol->cell.trans.at(mol->envi_sdm.at(i).sn) -//-
        mol->envi_sdm.at(i).floorD;
      mol->frac2kart(ppf,ppc);
      mol->frac2kart(mol->asymm[index].frac,p0);
      /*
         if (fabs(mol->envi_sdm.at(i).d-sqrt(Distance(p0,ppc)))>0.5){
         ppf=mol->cell.symmops.at(mol->envi_sdm.at(i).sn) *
         mol->asymm[mol->envi_sdm.at(i).a2].frac -
         mol->cell.trans.at(mol->envi_sdm.at(i).sn) -
         mol->envi_sdm.at(i).floorD;
         mol->frac2kart(ppf,ppc);

         }// */
      enviPositions.append(ppc);
      covs.append(mol->envi_sdm.at(i).covalent);
      enviKat.append((mol->envi_sdm.at(i).covalent)?1:0);
      if((abs(mol->asymm[mol->envi_sdm.at(i).a1].an-7)<2)
          &&(abs(mol->asymm[mol->envi_sdm.at(i).a2].an-7)<2)
          &&(fabs(mol->envi_sdm.at(i).d-2.725)<0.275)){enviKat.last()=2;}

      if((mol->asymm[mol->envi_sdm.at(i).a1].an==0)&&(abs(mol->asymm[mol->envi_sdm.at(i).a2].an-7)<2)&&(fabs(mol->envi_sdm.at(i).d-1.875)<0.275)){enviKat.last()=2;}
      if((mol->asymm[mol->envi_sdm.at(i).a2].an==0)&&(abs(mol->asymm[mol->envi_sdm.at(i).a1].an-7)<2)&&(fabs(mol->envi_sdm.at(i).d-1.875)<0.275)){enviKat.last()=2;}
      bool symm=((mol->envi_sdm.at(i).sn)||(!(mol->envi_sdm.at(i).floorD==V3(0,0,0))));
      if (symm) {
        QString sss=QString("%1_%2%3%4:%5,").arg(mol->envi_sdm.at(i).sn+1).arg(5-(int)mol->envi_sdm.at(i).floorD.x).arg(5-(int)mol->envi_sdm.at(i).floorD.y).arg(5-(int)mol->envi_sdm.at(i).floorD.z).arg(mol->asymm[mol->envi_sdm.at(i).a1].molindex);
        if (!bs.contains(sss)){
          bs.append(sss);
        }

        systr=QString("%1%2").arg(QString::fromUtf8("»")).arg(bs.indexOf(sss)+1);
        labs.append(mol->asymm[ mol->envi_sdm.at(i).a1].Label+systr);
      }
      else labs.append(mol->asymm[ mol->envi_sdm.at(i).a1].Label);
      info.append(QString("<tr><th style=\"background:%6\" >%1%4</th><td style=\"background:%5\" >%7<font color=%3> %2&nbsp;&Aring;</font></b></td>")
          .arg(mol->asymm[ mol->envi_sdm.at(i).a1].Label)
          .arg(mol->envi_sdm.at(i).d,8,'f',3)
          .arg((mol->envi_sdm.at(i).covalent)?"green":"black")
          .arg(symm?systr:"").arg((labs.size()%2)?"#eeeeee":"white")
          .arg((labs.size()%2)?"#d4d4e4":"#efefff")
          .arg((mol->envi_sdm.at(i).covalent)?"<b>":""));
      for (int j=0; j<enviPositions.size()-1; j++){
        double w=
          mol->winkel(p0-enviPositions.at(j),
              p0-enviPositions.last());
        //		printf("%s-%s-%s %g   %g %g %g\n",labs.at(j).toStdString().c_str(),mol->asymm[index].Label.toStdString().c_str(),labs.last().toStdString().c_str(),w,enviPositions.at(j).x ,enviPositions.at(j).y,enviPositions.at(j).z);
        info.append(QString("<td style=\"background:%3\" align=right>%4<font color=%2> %1&deg;</font></b></td>")
            .arg(w,8,'f',2)
            .arg(((mol->envi_sdm.at(i).covalent)&&(covs.at(j)))?"green":"black")
            .arg(((j+1)%2)?(labs.size()%2)?"#d4d4d4":"#e4e4e4":(labs.size()%2)?"#eeeeee":"#ffffff")
            .arg(((mol->envi_sdm.at(i).covalent)&&(covs.at(j)))?"<b>":""));

      }
      info.append("</tr>\n");
    }
  }
  info.append("<tr><td style=\"background:#efefff\"></td><td style=\"background:#efefff\"></td>");
  for (int j=0; j<enviPositions.size()-1; j++){
    info.append(QString("<th style=\"background:%2\">%1</th>").arg(labs.at(j)).arg(((j+1)%2)?"#d4d4e4":"#efefff"));
  }
  QString symml="";
  for (int j=0; j<bs.size(); j++){
    symml+=mol->symmcode2human(bs.at(j),j+1);
  }
  info.append(QString("</tr>\n</table>%1<hr>\n").arg(symml));
  emit bigmessage(info);
  enviButt->show();
  enviSelect->show();
  //pause=false;
  makeEnvi();
  setRotationCenter(index);
  printf("--ENVI-- %d %d\n",enviButt->isVisible(),enviSelect->isVisible());
  update();

}

//*
void PlayOpenGL::clearEnvi(){
  // *! Clears ChGL.enviPositions, ChGL.enviKat. and ChGL.labs * /
    if (enviPositions.isEmpty()) return;
  enviPositions.clear();
  labs.clear();
  enviKat.clear();
  enviButt->hide();
  enviSelect->hide();
  makeEnvi();
  if (isMainWindow) rotCenter();
}

void PlayOpenGL::selectEnvi(){
  mol->selectedatoms.clear();
  if (rotze>=0) {
    mol->selectedatoms.append(mol->showatoms[rotze]);
    mol->selectedatoms.last().style=rotze;
  }
  for (int i=0; i<mol->showatoms.size(); i++){
    for (int j=0; j< enviPositions.size(); j++){
      if (mol->showatoms.at(i).pos==enviPositions.at(j)) {
        mol->selectedatoms.append(mol->showatoms[i]);
        mol->selectedatoms.last().style=i;
      }
    }
  }
  updateBondActions();
  update();

}
// */



void PlayOpenGL::setRotationCenter(){
  //! Sets the rotation center to the spezified atom
  QAction *action = qobject_cast<QAction *>(sender());
  int index=0;
  if (action)
    index=action->data().toInt();
  else return;
  if (index==(int)((GLuint)-1))return;
  rotze=((int)index<mol->showatoms.size())?index:-1;
  if (rotze>-1){
    rCenter->show();
    homeXY();
    updateSceenAtoms();
  }
  update();
}

void PlayOpenGL::setRotationCenter(V3 center){
 // printf("%f %f %f \n%f %f %f\n", altemitte.x, altemitte.y, altemitte.z, center.x, center.y, center.z);
  //altcenter=center;
  rotze=-76185;//zip code
  rCenter->show();
  update();
}


void PlayOpenGL::setRotationCenter(int rz){
  /*! Sets the rotation center to the spezified atom
   * @param index of the spezified atom.
   */
  rotze=((int)rz<mol->showatoms.size())?rz:-1;
  if (rotze>-1){
      rCenter->show();
      homeXY();
      updateSceenAtoms();
  }
  update();
}


void PlayOpenGL::findPivot(){
    //printf("findpv %d %p\n",altpivot,whyNotSplit);
    if ((altpivot)||(whyNotSplit==nullptr)) return;
   // for(int i=0; i<mol->showatoms.size(); i++) mol->showatoms[i].hidden=0;
    if (mol->selectedatoms.size()<3) {
        whyNotSplit->setText("<h2>Select at least 3 atoms first.</h2>");
        emit splitable(canSplitRotate());
        return;
    }
    //printf("findPivot: ");
    pivot=-1;pivot2=-1;
    emit pivot2Changed(pivot2);
    emit pivot1Changed(pivot);
    int molidx=-1,mi;
    seat.clear();
    for (int i=0; i<mol->selectedatoms.size();i++){//all selectet atoms have to be in the same molecule
        int ii=mol->selectedatoms.at(i).style;
        if ((ii<0)||(ii>=mol->asymm.size()))continue;
        mi=mol->asymm.at(ii).molindex;
        if ((molidx!=-1)&&(molidx!=mi)) {
            whyNotSplit->setText("<h2>Selected atoms have to be in the same molecule.</h2>");
            emit splitable(canSplitRotate());
            return;
        }
        molidx=mi;
        seat.append(ii);
    }
    int atinmol=0;
    for (int i=0; i<mol->asymm.size();i++){
        if (mol->asymm.at(i).molindex==molidx) atinmol++;
    }
    //printf("==%d\n",__LINE__);
    if (mol->selectedatoms.size()>atinmol) {
        whyNotSplit->setText("<h2>Only a part of a molecule may be selected.<br>Or you have to specify atoms definig the rotation axis yourself.</h2>");
        emit splitable(canSplitRotate());
        return;
    } //only a part of the molecule may be selected
    // */
    for (int i=0;i<seat.size();i++){
        //printf("**%d %d\n",mol->knoepfe.size(),seat.at(i));
        int isin=0,ks=mol->knoepfe.at(seat.at(i)).neighbors.size();
        for (int j=0;j<ks; j++){
            int nb=mol->knoepfe.at(seat.at(i)).neighbors.at(j);
            if (seat.contains(nb))isin++;
        }
        if ((pivot==-1)&&(isin<ks)) {pivot=seat.at(i);emit pivot1Changed(pivot);}
        else if (isin<ks) {
            whyNotSplit->setText("<h2>Only one atom is allowed to have bonds to none selected atoms.</h2>");
            emit splitable(canSplitRotate());
            return;
        }
    }
    //printf("==%d\n",__LINE__);
    if (pivot<0) {
        emit splitable(canSplitRotate());
        return;
    }
    int isin=0,ks=mol->knoepfe.at(pivot).neighbors.size();
    for (int j=0;j<ks; j++){
        int nb=mol->knoepfe.at(pivot).neighbors.at(j);
        if (seat.contains(nb)){pivot2=nb;emit pivot2Changed(pivot2);isin++;}
    }
    if (isin>1) {
        whyNotSplit->setText("<h2>pivot atom may be bonded to only one selected atoms.</h2>");
        emit splitable(canSplitRotate());
        return;
    }
    whyNotSplit->setText(QString("<h2>You can rotate around %1=%2</h2>").arg(mol->asymm.at(pivot).Label).arg(mol->asymm.at(pivot2).Label));
    emit splitable(canSplitRotate());
}

void PlayOpenGL::splitRotate(){
    mol->splitLbonds.clear();
    mol->splitRbonds.clear();
    mol->splitLeftAtoms.clear();
    mol->splitRightAtoms.clear();
    if (freeRot->isChecked()){
     //   updateBondActions();
    }
    //printf("?splitRotate\n");
    if (!canSplitRotate()){makeSplitRot();return;}
    //printf("splitRotate!\n");
    if (!freeRot->isChecked()&&((pivot<0)||(pivot2<0))) {makeSplitRot();return;}
    for (int i=0; i<seat.size();i++){
        mol->splitLeftAtoms.append(mol->asymm[seat.at(i)]);
        mol->splitRightAtoms.append(mol->asymm[seat.at(i)]);
       // if (seat.at(i)!=pivot) mol->showatoms[seat.at(i)].hidden=1;
    }
    /*printf("?splitRotate %d %d  %d\n",
           mol->splitLeftAtoms.size(),
           mol->splitRightAtoms.size(),
           seat.size());*/
    //mol->selectedatoms.clear();
    //printf("%p %p\n", angle1, angle2);
    double arr[4];
    arr[0]=angle1->value();
    V3 ax=((manualAx->isChecked())||(freeRot->isChecked()))?
                Normalize(V3(axx->value(),axy->value(),axz->value())):
                Normalize(mol->asymm.at(pivot).pos-mol->asymm.at(pivot2).pos);
    arr[1]=ax.x;
    arr[2]=ax.y;
    arr[3]=ax.z;
    if ((!manualAx->isChecked())&&(!freeRot->isChecked())){
        axx->setValue(ax.x);
        axy->setValue(ax.y);
        axz->setValue(ax.z);
    }
    if (!freeRot->isChecked()){
        screenRotx=ax;
        Matrix M90 = mol->rotarb(90,ax);
        V3 cx = ax % V3(0,1,0);


        V3 cy = Normalize(M90 * cx);
        V3 cz = ax % cy;

        screenRoty = Normalize(cz);
    }
    if ((freeRot->isChecked())&&(pivot1cb->isEnabled())){
        V3 o(0,0,0);
        for (int i=0; i<mol->selectedatoms.size(); i++){
            o+=mol->selectedatoms.at(i).pos;
        }
        o*=1.0/mol->selectedatoms.size();
        orgx->setValue(o.x);
        orgy->setValue(o.y);
        orgz->setValue(o.z);
    }
    if (freeRot->isChecked()){
        V3 o(0,0,0);
        for (int i=0; i<mol->splitLeftAtoms.size(); i++){
            o+=mol->splitLeftAtoms.at(i).pos;
        }
        o*=1.0/mol->splitLeftAtoms.size();
        V3 no(orgx->value(), orgy->value(), orgz->value());
        for (int i=0; i<mol->splitLeftAtoms.size(); i++){
            mol->splitLeftAtoms[i].pos+=no-o;
        }
    }
    pivot1cb->setEnabled(!freeRot->isChecked());
    pivot2cb->setEnabled(!freeRot->isChecked());


    Matrix R =  ((freeRot->isChecked()))?freeRotMat : mol->rotarb(arr);
    /*
    V3 axe = V3((R.m23 - R.m32), (R.m31 - R.m13), (R.m12 - R.m21));
    double _si = sqrt(Norm(axe)) / 2.0;
    double _co = ((R.m11 + R.m22 + R.m33) - 1.0)/ 2.0;
    axe=Normalize(axe);
    double wt = atan2(_si, _co) / M_PI * 180.0;
    printf("%f grad  %f %f %f\n", wt, axe.x, axe.y, axe.z);
    */
    arr[0]=-angle2->value();
    Matrix Rbar=mol->rotarb(arr);
    SRorg=V3(orgx->value(), orgy->value(), orgz->value());
    if (!freeRot->isChecked()){
        SRorg=mol->asymm.at(pivot).pos;
        orgx->setValue(SRorg.x);
        orgy->setValue(SRorg.y);
        orgz->setValue(SRorg.z);
    }
    for (int i=0; i<seat.size();i++){
        mol->splitLeftAtoms[i].pos=R*(mol->splitLeftAtoms.at(i).pos-SRorg)+SRorg;
        mol->splitRightAtoms[i].pos=Rbar*(mol->splitRightAtoms.at(i).pos-SRorg)+SRorg;
    }
    mol->splitRbonds=mol->connecting(mol->splitRightAtoms,true);
    mol->splitLbonds=mol->connecting(mol->splitLeftAtoms,true);
    //rotze=pivot;
    makeSplitRot();
    update();
}

bool PlayOpenGL::canSplitRotate(){
    //printf("canSplitRotate? %d \n",(freeRot!=nullptr)&&(freeRot->isChecked())&&(mol->selectedatoms.size()>2));
    if (freeRot==nullptr) return false;//!!!
    if ((freeRot!=nullptr)&&(freeRot->isChecked())&&(mol->selectedatoms.size()>2)) return true;
    if ((pivot>-1)&&(pivot2>-1)&&(pivot<mol->asymm.size())&&(pivot2<mol->asymm.size())&&(mol->selectedatoms.size()>2)) return true;
    return false;
}


void PlayOpenGL::highliteQPeak(double co){

    inFocus=-1;
    //printf("co %f\n",co)
    for (int i=0;i<mol->showatoms.size();i++){
      if (mol->showatoms[i].an==-66) continue;
      if (mol->showatoms[i].an>=0) continue;
      if (mol->showatoms[i].hidden)continue;
      if (mol->showatoms[i].peakHeight<=co) {
          inFocus=i;
          emit message(QString("%1 %2").arg(mol->showatoms.at(inFocus).Label).arg(mol->showatoms.at(inFocus).peakHeight));
          break;
      }
    }
    update();
}

void PlayOpenGL::renderText(const QVector2D &scpos, const QString &text, int an, int pts){
  QPainter painter(this);

  QFont f = myFont;
  f.setPointSize((an<0)? (pts*2)/3: pts);
  QFontMetrics mtr(f);
  QRect rc=mtr.boundingRect(text+"L");
  QImage image(rc.width(),rc.height(), QImage::Format_ARGB32_Premultiplied);
  image.fill(0);
  QPainter p;
  p.begin(&image);
  p.setPen(labelColor);
  p.setBackground(Qt::NoBrush);
  p.setFont(f);
  p.drawText(image.rect(), Qt::AlignCenter, text);
  p.end();
  painter.drawImage(scpos.x(), scpos.y()-rc.height(), image);
  painter.end();
}

void PlayOpenGL::renderText(const QVector2D &scpos, const QString &text, int an){
  QPainter painter(this);
  QFont f = (an<0)?nonAtomFont:myFont;
  QFontMetrics mtr(f);
  QRect rc=mtr.boundingRect(text+"L");
  QImage image(rc.width(),rc.height(), QImage::Format_ARGB32_Premultiplied);
  image.fill(focusedLabelBGColor.rgba());
  QPainter p;
  p.begin(&image);
  p.setPen(focusedLabelColor);
  p.setBackground(Qt::black);
  p.setFont(f);
  p.drawText(image.rect(), Qt::AlignCenter, text);
  p.end();
  painter.drawImage(scpos.x(), scpos.y()-rc.height(), image);
  painter.end();
}


void PlayOpenGL::renderText(const QVector2D &scpos, int i){
    QPainter painter(this);
    QRect rc = altLabels.at(i).rect();
    painter.drawImage(scpos.x(), scpos.y()-rc.height(), altLabels.at(i));
    painter.end();
}

void PlayOpenGL::renderRect(){
    makeCurrent();
    QPainter painter(this);
    QPen pen(labelColor);
    pen.setStyle(Qt::DotLine);
    painter.setPen(pen);
    painter.drawRect(scrx0,scry0,scrx-scrx0,scry-scry0);
    painter.end();
}

void PlayOpenGL::renderText(const V3 &pos, const QString &text, QColor &color, uint bg){
    QVector3D mapped3d = pmv.map(QVector3D(pos.x, pos.y, pos.z));
    int w=width();
    int h=height();
    QVector2D vec2 = QVector2D((1 + mapped3d.x()) * (w / 2), (1 - mapped3d.y()) * (h / 2));
    QPainter painter(this);
    QFontMetrics mtr(myFont);
    QRect rc=mtr.boundingRect(text+"L");
    QImage image(rc.width(),rc.height(), QImage::Format_ARGB32_Premultiplied);
    image.fill(bg);
    QPainter p;
    p.begin(&image);
    p.setPen(color);
    p.setBackground(Qt::NoBrush);
    p.setFont(myFont);
    p.drawText(image.rect(), Qt::AlignCenter, text);
    p.end();
    painter.drawImage(vec2.x(), vec2.y()-rc.height(), image);
    painter.end();
}


void PlayOpenGL::renderText(QMatrix4x4 mat,int w, int h, const V3 &pos, const QString &text, QColor &color, uint bg){
    QVector3D mapped3d = mat.map(QVector3D(pos.x, pos.y, pos.z));
    QVector2D vec2 = QVector2D((1 + mapped3d.x()) * (w / 2), (1 - mapped3d.y()) * (h / 2));
    QPainter painter(this);
    QFontMetrics mtr(nonAtomFont);
    QRect rc=mtr.boundingRect(text+"L");
    QImage image(rc.width(),rc.height(), QImage::Format_ARGB32_Premultiplied);
    image.fill(bg);
    QPainter p;
    p.begin(&image);
    p.setPen(color);
    p.setBackground(Qt::NoBrush);
    p.setFont(nonAtomFont);
    p.drawText(image.rect(), Qt::AlignCenter, text);
    p.end();
    painter.drawImage(vec2.x(), vec2.y()-rc.height(), image);
    painter.end();
}


void PlayOpenGL::makeLabels(){
    altLabels.clear();    
    nonAtomFont = myFont;    
    QString label;
    nonAtomFont.setPointSize(qMax(((myFont.pointSize()*2)/3),7));
    for (int i = 0; i < mol->showatoms.size(); i++){
        QFont f = (mol->showatoms.at(i).an<0)?nonAtomFont:myFont;
        QFontMetrics mtr(f);
        label = mol->showatoms.at(i).Label;
        if (shortLabels->isChecked()) {
          label=label.section("_",0,0);
          label=label.section(QString::fromUtf8("»"),0,0);
        }
        QRect rc=mtr.boundingRect(label+"L");
        QImage image(rc.width(),rc.height(), QImage::Format_ARGB32_Premultiplied);
        image.fill(labelBGColor.rgba());
        QPainter p;
        p.begin(&image);
        p.setPen(labelColor);
        p.setBackground(Qt::NoBrush);
        p.setFont(f);
        p.drawText(image.rect(), Qt::AlignCenter, label);
        p.end();
        altLabels.append(image);
    }
    update();
    //printf("makeLabels %d %d short?%d\n",altLabels.size(), mol->showatoms.size(),shortLabels->isChecked());
}

void PlayOpenGL::updateBondActions(){//!<changes the visibility state of QActions in the 'Selection Toolbar'.
  //bool p=pause;
  //pause=true;
  //printf("%p %p %p  %p %p %p  %p %p %p \n",clearSelection,invSelection,centroid,centerSelection,delSelAt,delSelAt,hideNotSelection,addBond,killBond);
  clearSelection->setVisible(!mol->selectedatoms.isEmpty());
  //printf("line:%d  hiddenThings %d\n",__LINE__,hiddenThings);
  invSelection->setVisible(!mol->selectedatoms.isEmpty());
  centroid->setVisible(mol->selectedatoms.size()>1);
  centerSelection->setVisible((!mol->selectedatoms.isEmpty())||(centerSelection->isChecked()));
  delSelAt->setVisible(!mol->selectedatoms.isEmpty());
  delSelAt->setEnabled(!mol->selectedatoms.isEmpty());
  hideNotSelection->setVisible(!mol->selectedatoms.isEmpty());
  if (fVertexes.size()>1)cntrPlot->setVisible(((!fVertexes[0].isEmpty()||!fVertexes[1].isEmpty())&&(mol->selectedatoms.size()==3)));
  unhide->setVisible(hiddenThings);
  invhide->setVisible(hiddenThings);
  if (mol->selectedatoms.size()!=2){
    addBond->setVisible(false);
    killBond->setVisible(false);
  }
  else{
    int da=0;
    for (int i=0; i<mol->showbonds.size();i++){
      if (((mol->selectedatoms.at(0).style==mol->showbonds.at(i).a1)||
            (mol->selectedatoms.at(0).style==mol->showbonds.at(i).a2))&&
          ((mol->selectedatoms.at(1).style==mol->showbonds.at(i).a1)||
           (mol->selectedatoms.at(1).style==mol->showbonds.at(i).a2))) da=i;
    }
    if (da){
      addBond->setVisible(false);
      killBond->setVisible(true);
      killBond->setData(da);
    }
    else{
      addBond->setVisible(true);
      killBond->setVisible(false);
    }
  }
  findPivot();
  makeBonds(mol->showatoms, mol->showbonds, mol->lbonds, mol->theH_Bonds);
  //pause=p;
}

void PlayOpenGL::updateSceenAtoms(){
    //QList<QVector2D> screenAtoms;
    //CEnvironment mol->showatoms;
    if (mol->showatoms.isEmpty())return;
    V3 org = sumse;
    if ((rotze>-1)&&(rotze<mol->showatoms.size())) org = mol->showatoms.at(rotze).pos;
    if (centerSelection->isChecked()){
      if (mol->selectedatoms.isEmpty()) {
        org = sumse;
      }
      else {
        V3 sums=V3(0,0,0);
        for (int i = 0; i < mol->selectedatoms.size(); i++) sums += mol->selectedatoms[i].pos;
        sums *= 1.0 / mol->selectedatoms.size();
        org = sums;
      }
    }
    if (mol->showatoms.size()<screenAtoms.size()) screenAtoms.clear();
    for (int i = 0; i < mol->showatoms.size(); i++){
        QVector3D mapped3d = pmv.map(QVector3D(mol->showatoms.at(i).pos.x - org.x, mol->showatoms.at(i).pos.y - org.y, mol->showatoms.at(i).pos.z - org.z));
        int w=width();
        int h=height();
        QVector2D vec2 = QVector2D((1 + mapped3d.x()) * (w / 2), (1 - mapped3d.y()) * (h / 2));
        if (screenAtoms.size() < i + 1) screenAtoms.append(vec2);
        else screenAtoms[i] = vec2;
        /*printf("%s %f %f  %f %f %f %d %d %d %d\n",mol->showatoms.at(i).Label.toStdString().c_str(),vec2.x(),vec2.y(), mapped3d.x(), mapped3d.y(), mapped3d.z()
               ,w,h,w/2,h/2);// */
    }
}


void PlayOpenGL::makeEnvi(){
    //printf("make ENVI\n");
    makeCurrent();
    envi_vao.release();
    if (envi_vao.isCreated()) {
        envi_vao.release();
        envi_vao.destroy();
        envi_vertexBuffer.destroy();
        envi_program->release();
        envi_program->removeAllShaders();
    }
    envi_vao.create();
    envi_vao.bind();
    envi_vertexBuffer.create();
    envi_vertexBuffer.setUsagePattern( QOpenGLBuffer::StaticDraw );
    if (!envi_program) envi_program = new QOpenGLShaderProgram(this);
    else envi_program->removeAllShaders();
    //printf("envi_program %p %d\n",envi_program, envi_program->programId());
    bool result = envi_program->addCacheableShaderFromSourceFile( QOpenGLShader::Vertex, ":/shaders/envi.vert");
    if (!result) qWarning() << envi_program->log();
    result = envi_program->addCacheableShaderFromSourceFile( QOpenGLShader::Geometry, ":/shaders/envi.geom");
    if (!result) qWarning() << envi_program->log();
    result = envi_program->addCacheableShaderFromSourceFile( QOpenGLShader::Fragment, ":/shaders/envi.frag");
    if (!result) qWarning() << envi_program->log();
    result = envi_program->link();
    if (!result) qWarning() << envi_program->log();
    QVector<float> p;
    for (int i=0; i<enviPositions.size(); i++){
        p.append(enviP0.x);
        p.append(enviP0.y);
        p.append(enviP0.z);
        p.append(static_cast<float>(enviKat.at(i)));
        p.append(enviPositions.at(i).x);
        p.append(enviPositions.at(i).y);
        p.append(enviPositions.at(i).z);
        p.append(static_cast<float>(enviKat.at(i)));
    }
     if (!envi_vertexBuffer.bind()) {printf("I was unable to bind envi_vertexBuffer.\n");}
    envi_vertexBuffer.allocate((p.size()) * sizeof(float));
    envi_vertexBuffer.write(0,p.data(),p.size() * sizeof(float));

    envi_program->enableAttributeArray("L0" );
    envi_program->setAttributeBuffer("L0", GL_FLOAT, 0, 4 );
    bool b=shaderInfo;
    shaderInfo=true;
    programInfo(envi_program, "envi");
    shaderInfo=b;
    envi_program->release();
    envi_vertexBuffer.release();
    envi_vao.release();

    update();
}

void PlayOpenGL::makeMaps(
        QVector< QVector< float > > &_fVertexes,
        QVector< QVector< float > > &_fNormals){
    fVertexes = _fVertexes;
    fNormals  = _fNormals;

    makeCurrent();
    map_vao.release();
    if (map_vao.isCreated()) {
        map_vao.release();
        map_vao.destroy();
        map_vertexBuffer.destroy();
        map_program->release();
        map_program->removeAllShaders();
    }
    map_vao.create();
    map_vao.bind();
    map_vertexBuffer.create();
    map_vertexBuffer.setUsagePattern( QOpenGLBuffer::StaticDraw );
    GLenum err = GL_NO_ERROR;
    while((err = glGetError()) != GL_NO_ERROR)
    {
      printf("%s paintGL error %X %d\n", parent()->objectName().toStdString().c_str(), err, __LINE__);
      //printf("%s\n",(char*)gluErrorString(err));
    }
    if (!map_program) map_program = new QOpenGLShaderProgram(this);
    else map_program->removeAllShaders();
    //printf("map_program %p %d\n",map_program, map_program->programId());
    bool result = map_program->addCacheableShaderFromSourceFile( QOpenGLShader::Vertex, ":/shaders/waldwiesen.vert");
    //printf("%d\n",__LINE__);
    if ( !result ) qWarning() << map_program->log();
    result = map_program->addCacheableShaderFromSourceFile( QOpenGLShader::Fragment, ":/shaders/waldwiesen.frag");
    if ( !result ) qWarning() << map_program->log();
    result = map_program->link();
    if ( !result ) qWarning() << map_program->log();
    int siz = fVertexes[0].size() + sizeof(float);
    size_t mapsiz = 0;//fVertexes[0].size()* sizeof(float);
    for (int i=0; i<28; i++) mapsiz+=fVertexes[i].size()* sizeof(float);
    if (!map_vertexBuffer.bind()) {printf("I was unable to bind map_vertexBuffer.\n");}
    map_vertexBuffer.allocate(mapsiz*2);
    int offs=0;
    V3 ctr=V3(0,0,0);
    const float * fv =  fVertexes[0].data();
    for (int i=0; i<fVertexes[0].size()/3; i++){
        ctr+=V3(fv[i*3], fv[i*3+1], fv[i*3+2]);
    }
    ctr*=3.0/fVertexes[0].size();
    //printf(" %f %f %f\n", sumse.x, sumse.y, sumse.z);
    //printf("CENTER of maps %d points: %f %f %f\n", fVertexes[0].size()/3, ctr.x, ctr.y, ctr.z);

    offsets.clear();
    for (int i=0; i<28; i++){
        offsets.append(offs);
        int siz = fVertexes[i].size() * sizeof(float);
        map_vertexBuffer.write(offs, fVertexes[i].data(), siz);
        offs+=siz;
    }//*/
    int normaloffset=offs;
    for (int i=0; i<28; i++){
        //offsets.append(offs);
        int siz = fNormals[i].size() * sizeof(float);
        map_vertexBuffer.write(offs, fNormals[i].data(), siz);
        offs+=siz;
    }//*/
    //qDebug()<<offsets;

    map_program->enableAttributeArray("normal" );// */
    map_program->enableAttributeArray("vertex" );
    map_program->setAttributeBuffer("normal", GL_FLOAT, normaloffset, 3 );
    map_program->setAttributeBuffer("vertex", GL_FLOAT, 0, 3 );
    //printf("map stuff and program %lld  %d %d\n",mapsiz ,siz , normaloffset);

    programInfo(map_program, "waldwiesen");
    err = GL_NO_ERROR;
    while((err = glGetError()) != GL_NO_ERROR)
    {
      printf("%s paintGL error %X %d\n", parent()->objectName().toStdString().c_str(), err, __LINE__);
      //printf("%s\n",(char*)gluErrorString(err));
    }
    map_vertexBuffer.release();
    map_program->release();
    map_vao.release();
    //update();
}

/*void PlayOpenGL::setMapsStuff(
        QVector< QVector< float > > &_fVertexes,
        QVector< QVector< float > > &_fNormals,
        double    *_lintrans,
        double    *_linwidth,
        QColor    *_fopc,
        QColor    *_fomc,
        QColor    *_dipc,
        QColor    *_dimc,
        QCheckBox *_lighting,
        QCheckBox *_niceTrans,
        QCheckBox *_fillMap,
        QAction   *_foact,
        QAction   *_fofcact
        ){
    fVertexes = _fVertexes;
    fNormals  = _fNormals;
    lintrans  = *_lintrans;
    linwidth  = *_linwidth;
    fopc      = *_fopc;
    fomc      = *_fomc;
    dipc      = *_dipc;
    dimc      = *_dimc;
    lighting  = *_lighting;
    niceTrans = *_niceTrans;
    fillMap   = *_fillMap;
    foact     = *_foact;
    fofcact   = *_fofcact;
    connect(foact, SIGNAL(toggled(bool)), this,  SLOT(update()));
    connect(fofcact, SIGNAL(toggled(bool)), this,  SLOT(update()));
    connect(niceTrans, SIGNAL(toggled(bool)), this,  SLOT(update()));
    connect(lighting, SIGNAL(toggled(bool)), this,  SLOT(update()));
    connect(fillMap, SIGNAL(toggled(bool)), this,  SLOT(update()));
    makeMaps(_fVertexes,_fNormals);
}
*/
void PlayOpenGL::setMapsStuff(){
    connect(foact, SIGNAL(toggled(bool)), this,  SLOT(update()));
    connect(fofcact, SIGNAL(toggled(bool)), this,  SLOT(update()));
    connect(niceTrans, SIGNAL(toggled(bool)), this,  SLOT(update()));
    connect(lighting, SIGNAL(toggled(bool)), this,  SLOT(update()));
    connect(fillMap, SIGNAL(toggled(bool)), this,  SLOT(update()));
    makeMaps(fVertexes,fNormals);
}

void PlayOpenGL::makeUnitCell(){
    //printf("makeUnitCell\n");
    makeCurrent();
    uc_vao.release();
    if (uc_vao.isCreated()) {
        uc_vao.release();
        uc_vao.destroy();
        uc_vertexBuffer.destroy();
        uc_program->release();
        uc_program->removeAllShaders();
    }
    uc_vao.create();
    uc_vao.bind();
    uc_vertexBuffer.create();
    uc_vertexBuffer.setUsagePattern( QOpenGLBuffer::StaticDraw );
    if (!uc_vertexBuffer.bind()) {printf("I was unable to bind uc_vertexBuffer.\n");}
    GLfloat vert[] = {0.0, 0.0, 0.0};
    if (!uc_program) uc_program = new QOpenGLShaderProgram(this);
    else uc_program->removeAllShaders();
    bool result = uc_program->addCacheableShaderFromSourceFile( QOpenGLShader::Vertex, ":/shaders/uc.vert");
    //printf("%d\n",__LINE__);
    if ( !result ) qWarning() << uc_program->log();
    result = uc_program->addCacheableShaderFromSourceFile( QOpenGLShader::Geometry, ":/shaders/uc.geom");
    if ( !result ) qWarning() << uc_program->log();
    result = uc_program->addCacheableShaderFromSourceFile( QOpenGLShader::Fragment, ":/shaders/uc.frag");
    if ( !result ) qWarning() << uc_program->log();
    result = uc_program->link();
    if ( !result ) qWarning() << uc_program->log();
    if ( !uc_program->bind() )    {
        qWarning() << "Could not bind shader program to context";
        return;
    }
    uc_vertexBuffer.allocate(vert, 3 * sizeof( float )) ;
    //uc_program->setAttributeBuffer(uc_vertexBuffer.bufferId(), GL_FLOAT, 0, 3 );
    uc_program->setAttributeBuffer("vertex", GL_FLOAT, 0, 3 );
    uc_program->enableAttributeArray("vertex" );
    //uc_program->enableAttributeArray(uc_vertexBuffer.bufferId());
    //printf("uc_vertexBuffer.bufferId() %d\n",uc_vertexBuffer.bufferId());
    programInfo(uc_program,"unit  cell");
    uc_program->release();
    uc_vao.release();
    uc_vertexBuffer.release();
    uc_vertexBuffer.destroy();
    update();
}

void PlayOpenGL::contDestruct(){
   cont_vao.release();
   cont_vao.destroy();
   cont_vertexBuffer.destroy();
   cont_program->release();
   cont_program->removeAllShaders();
}

void PlayOpenGL::voroDestruct(){
   voro_vao.release();
   voro_vao.destroy();
   voro_vertexBuffer.destroy();
   voro_program->release();
   voro_program->removeAllShaders();
}

void PlayOpenGL::makeContours(){
    //printf("makeContours\n");
    makeCurrent();
    cont_vao.release();
    if (cont_vao.isCreated()) {
        cont_vao.release();
        cont_vao.destroy();
        cont_vertexBuffer.destroy();
        cont_program->release();
        cont_program->removeAllShaders();
    }
    cont_vao.create();
    cont_vao.bind();
    //glEnable(GL_PRIMITIVE_RESTART_FIXED_INDEX);
    cont_vertexBuffer.create();
    cont_vertexBuffer.setUsagePattern( QOpenGLBuffer::StaticDraw );
    if (!cont_vertexBuffer.bind()) {printf("I was unable to bind cont_vertexBuffer.\n");}
    /////////////
    QVector<float> p;
    float val=0.0f;
    for (int ci=0;ci<cont.size();ci++){
        if (contval.contains(ci)) val = contval.value(ci);
        p.append(cont.at(ci).x);
        p.append(cont.at(ci).y);
        p.append(cont.at(ci).z);
        p.append(val);
    }
    if (!cont_program) cont_program = new QOpenGLShaderProgram(this);
    else cont_program->removeAllShaders();
    bool result = cont_program->addCacheableShaderFromSourceFile( QOpenGLShader::Vertex, ":/shaders/contour.vert");
    //printf("%d\n",__LINE__);
    if ( !result ) qWarning() << cont_program->log();
    result = cont_program->addCacheableShaderFromSourceFile( QOpenGLShader::Fragment, ":/shaders/contour.frag");

    if ( !result ) qWarning() << cont_program->log();
    result = cont_program->link();
    if ( !result ) qWarning() << cont_program->log();

    if ( !cont_program->bind() )    {
        qWarning() << "Could not bind shader program to context";
        return;
    }
    //printf("%d %d\n",cont.size(), p.size());
    cont_vertexBuffer.allocate(p.data(),p.size()*sizeof(float));
    cont_program->setAttributeBuffer("vertex", GL_FLOAT, 0, 4 );
    cont_program->enableAttributeArray("vertex" );

    programInfo(cont_program,"Contour");

    cont_program->release();
    cont_vao.release();
    cont_vertexBuffer.release();
    cont_vertexBuffer.destroy();
    update();
}

void PlayOpenGL::makeBackGround(){
    //printf("makeBackGround\n");
    makeCurrent();
    GLenum err = GL_NO_ERROR;
    while((err = glGetError()) != GL_NO_ERROR)
    {
      printf("before makeBackGround %s error %X\n", parent()->objectName().toStdString().c_str(),err);
      //printf("%s\n",(char*)gluErrorString(err));
    }

    bg_vao.release();
    if (bg_vao.isCreated()) {
        bg_vao.release();
        bg_vao.destroy();
        backGround_vertexBuffer.destroy();
        bg_program->release();
        bg_program->removeAllShaders();
    }
    bg_vao.create();
    bg_vao.bind();
    //glEnable(GL_PRIMITIVE_RESTART_FIXED_INDEX);
    backGround_vertexBuffer.create();
    backGround_vertexBuffer.setUsagePattern( QOpenGLBuffer::StaticDraw );
    if (!backGround_vertexBuffer.bind()) {printf("I was unable to bind backGround_vertexBuffer.\n");}
    GLfloat vert[] ={-1.0,-1.0,0.0,  -1.0, 1.0,0.0,  1.0,-1.0,0.0,  1.0, 1.0,0.0};
    if (!bg_program) bg_program = new QOpenGLShaderProgram(this);
    else bg_program->removeAllShaders();

    //printf("%p %d\n",bg_program, bg_program->programId());

    bool result = bg_program->addCacheableShaderFromSourceFile( QOpenGLShader::Vertex, ":/shaders/bg.vert");
    //printf("%d\n",__LINE__);
    if ( !result ) qWarning() << bg_program->log();
    result = bg_program->addCacheableShaderFromSourceFile( QOpenGLShader::Fragment, ":/shaders/bg.frag");

    if ( !result ) qWarning() << bg_program->log();
    result = bg_program->link();
    if ( !result ) qWarning() << bg_program->log();

    if ( !bg_program->bind() )    {
        qWarning() << "Could not bind shader program to context";
        return;
    }
    backGround_vertexBuffer.allocate(vert, 4 *3 * sizeof( float )) ;
    bg_program->setAttributeBuffer(backGround_vertexBuffer.bufferId(), GL_FLOAT, 0, 3 );
    bg_program->setAttributeBuffer("vertex", GL_FLOAT, 0, 3 );
    bg_program->enableAttributeArray("vertex" );
    bg_program->enableAttributeArray(backGround_vertexBuffer.bufferId());

    bg_program->setUniformValue("bgcolor", backGroundColor);
    bg_program->setUniformValue("bggradient", bggradient);
    programInfo(bg_program,"bg");

    bg_program->release();
    bg_vao.release();
    backGround_vertexBuffer.release();
    backGround_vertexBuffer.destroy();
    while((err = glGetError()) != GL_NO_ERROR)
    {
      printf("after makeBackGround %s error %X\n", parent()->objectName().toStdString().c_str(),err);
      //printf("%s\n",(char*)gluErrorString(err));
    }


}

void PlayOpenGL::makeSelectedAtoms(){

    //printf("makeSelectedAtoms\n");
    makeCurrent();
    slct_vao.release();
    if (slct_vao.isCreated()) {
        slct_vao.release();
        slct_vao.destroy();
        satom_vertexBuffer.destroy();
        satom_indexBuffer.destroy();
        satom_program->release();
        satom_program->removeAllShaders();
    }
    //if (mol->selectedatoms.isEmpty()) return;
    slct_vao.create();
    slct_vao.bind();
    //glEnable(GL_PRIMITIVE_RESTART_FIXED_INDEX);
    satom_vertexBuffer.create();
    satom_vertexBuffer.setUsagePattern( QOpenGLBuffer::StaticDraw );
    if (!satom_vertexBuffer.bind()) {printf("I was unable to bind atom_vertexBuffer.\n");}
    //glDisable(GL_BLEND);
    //printf("makeAtoms\n");

    int na = mol->selectedatoms.size();

    //printf("makeSelectedAtoms na %d\n",na);
    //*
    if (!satom_program) satom_program = new QOpenGLShaderProgram(this);
    else satom_program->removeAllShaders();

    bool result = satom_program->addCacheableShaderFromSourceFile( QOpenGLShader::Vertex, ":/shaders/std.vert");
    if ( !result ) qWarning() << satom_program->log();
    result = satom_program->addCacheableShaderFromSourceFile( QOpenGLShader::Geometry, ":/shaders/std.geom" );
    if ( !result ) qWarning() << satom_program->log();
    result = satom_program->addCacheableShaderFromSourceFile( QOpenGLShader::Fragment, ":/shaders/std.frag" );
    if ( !result ) qWarning() << satom_program->log();
    // ...and finally we link them to resolve any references.
    result = satom_program->link();
    if ( !result ) qWarning() << "Could not link shader satom_program:" << satom_program->log();

    QVector<float> pos;
    for (int i=0; i<mol->selectedatoms.size(); i++){
        pos.append(mol->selectedatoms.at(i).pos.x);
        pos.append(mol->selectedatoms.at(i).pos.y);
        pos.append(mol->selectedatoms.at(i).pos.z);
        /*printf("select? %f %f %f    %f %f %f \n",
               mol->selectedatoms.at(i).pos.x-sumse.x,
               mol->selectedatoms.at(i).pos.y-sumse.y,
               mol->selectedatoms.at(i).pos.z-sumse.z,
               sumse.x,sumse.y,sumse.z); // */
    }
    for (int i=0; i<mol->duplicateAtoms.size(); i++){
        pos.append (mol->duplicateAtoms.at(i).pos.x);
        pos.append (mol->duplicateAtoms.at(i).pos.y);
        pos.append (mol->duplicateAtoms.at(i).pos.z);
        /*printf("select? %f %f %f    %f %f %f \n",
               mol->selectedatoms.at(i).pos.x-sumse.x,
               mol->selectedatoms.at(i).pos.y-sumse.y,
               mol->selectedatoms.at(i).pos.z-sumse.z,
               sumse.x,sumse.y,sumse.z); // */
    }
    pos.append(0.1);//inFocus dummy atom
    pos.append(0.2);
    pos.append(0.3);

    satom_vertexBuffer.allocate( pos.data(), (na+1+mol->duplicateAtoms.size()) * 3 * sizeof( float ) );//na + dummy
    if ( !satom_program->bind() )    {
        qWarning() << "Could not bind shader satom_program to context";
        return;
    }
    satom_program->setAttributeBuffer(satom_vertexBuffer.bufferId(), GL_FLOAT, 0, 3 );
    satom_program->setAttributeBuffer("vertex", GL_FLOAT, 0, 3 );
    satom_program->enableAttributeArray("vertex" );
    satom_program->enableAttributeArray(satom_vertexBuffer.bufferId());
    satom_program->setUniformValue("pmv", pmv);
    satom_program->setUniformValue("normalMatrix", nm);
    satom_program->setUniformValue("Color", QColor("yellow"));
    satom_program->setUniformValue("lightPos", QVector3D(100,100,100));
    programInfo(satom_program, "std");
    satom_program->release();
    satom_vertexBuffer.release();
    slct_vao.release();
    //printf("!makeSelectedAtoms %d %p\n",mol->selectedatoms.size(),satom_program);
    update();
//    */
}

void PlayOpenGL::makeLegendAtoms(){

    //printf("makeLegendAtoms\n");
    makeCurrent();
    latom_vao.release();
    if (latom_vao.isCreated()) {
        latom_vao.release();
        latom_vao.destroy();
        latom_vertexBuffer.destroy();
        latom_indexBuffer.destroy();
        //latom_program->release();
        //latom_program->removeAllShaders();
    }
    latom_vao.create();
    latom_vao.bind();
    //glEnable(GL_PRIMITIVE_RESTART_FIXED_INDEX);
    latom_vertexBuffer.create();
    latom_vertexBuffer.setUsagePattern( QOpenGLBuffer::StaticDraw );
    if (!latom_vertexBuffer.bind()) {printf("I was unable to bind latom_vertexBuffer.\n");}

    int na = mol->legendAtoms.size();
    const float phi = (1.0f + sqrtf(5.0f)) / 2.0f;
    const float du = 1.0f / sqrtf(phi * phi + 1.0f);
    const float dv = phi * du;
    //printf("phi = %f du = %f dv = %f\n",phi, du, dv);
    const float eckn[] ={   0.0f,  dv,  du,
                            0.0f,  dv, -du,
                            0.0f, -dv,  du,
                            0.0f, -dv, -du,
                            du,  0.0f,  dv,
                            -du, 0.0f,  dv,
                            du,  0.0f, -dv,
                            -du, 0.0f, -dv,
                            dv,    du, 0.0f,
                            dv,   -du, 0.0f,
                            -dv,   du, 0.0f,
                            -dv,  -du, 0.0f};
    const GLuint triangle[] = {
          1, 0, 8,
          4, 0, 5,
          5, 0, 10,
          8, 0, 4,
         10, 0, 1,
          6, 1, 8,
          7, 1, 6,
         10, 1, 7,
          3, 2, 11,
          4, 2, 9,
          5, 2, 4,
          9, 2, 3,
         11, 2, 5,
          6, 3, 7,
          7, 3, 11,
          9, 3, 6,
          8, 4, 9,
         11, 5, 10,
          9, 6, 8,
         10, 7, 11};//*/
    /*const GLuint triangle_strips[] = {
          1,  0, 8,  4, 9, 2, 3, 11, 7, 10, 1, 0, 0xFFFFFFFF,
          3,  9, 6,  8, 1, 0xFFFFFFFF,
          2, 11, 5, 10, 0, 0xFFFFFFFF,
          1,  7, 6,  3, 0xFFFFFFFF, //3, 7, 6, 1, 0xFFFF,
          2,  4, 5,  0, 0xFFFFFFFF//0, 5, 4, 2, 0xFFFF,
    };//, 10, 5, 11, 2}; */
    //0xFFFF
    double yofs=-6.7;
    double xofs=0;
    for (int ali=0; ali<na; ali++){
        xofs=qMax(mol->arad[qMax(mol->legendAtoms[ali].an,0)],xofs);
    }
    xofs-=3.0;
    for (int ali=0; ali<na; ali++){
        mol->legendAtoms[ali].pos.y=yofs;
        if ((adp->isChecked())&&(mol->legendAtoms[ali].an>=0)){
            yofs+=0.5;
        }
        else{
            if (tubes->isChecked()) {
                yofs+=2*mol->bondStrength+0.15;
            }else{
                yofs+=mol->arad[qMax(mol->legendAtoms[ali].an,0)]+0.07;
                if (ali+1<na) yofs+=mol->arad[qMax(mol->legendAtoms[ali+1].an,0)]+0.07;
            }
        }
        mol->legendAtoms[ali].pos.x=xofs;
        //printf("legend %f %f %f %f\n",mol->legendAtoms[ali].pos.x, mol->legendAtoms[ali].pos.y,yofs,mol->arad[qMax(mol->legendAtoms[ali].an,0)]);
        //if (mol->legendAtoms.at(ali).hidden) continue;
    }
    QVector<float> stuff;
    for (int i = 0; i < na; i++){
        bool isd=((mol->legendAtoms.at(i).an==0)&&(mol->legendAtoms.at(i).Label[0]=='D'));
        int style = (mol->legendAtoms.at(i).an<0)?0:
                (0xFF&mol->AtomStyle[mol->legendAtoms.at(i).an])
                |((mol->legendAtoms.at(i).hidden)?512:0)
                |((isd)?1024:0)
                |(((mol->legendAtoms.at(i).isIso))?2048:0);
        //printf("legend %s %d %d\n",mol->legendAtoms.at(i).Label.toStdString().c_str(), mol->legendAtoms.at(i).an,mol->legendAtoms.at(i).hidden);
        V3 ev=V3(0,0,0);
        double *arr = mol->jacobi(mol->legendAtoms.at(i).uc, ev);
        //printf("Legend: %fdeg x%f y%f z%f ev1:%f ev2:%f ev3:%f %X %X\n", arr[0], arr[1], arr[2], arr[3], ev.x, ev.y, ev.z, style, mol->AtomStyle[mol->legendAtoms.at(i).an]);
        for (int j = 0; j < 12; j++){
        stuff.append(mol->legendAtoms.at(i).pos.x);//the center
        stuff.append(mol->legendAtoms.at(i).pos.y);
        stuff.append(mol->legendAtoms.at(i).pos.z);
        //printf("LLL %f %f %f \n", mol->legendAtoms.at(i).pos.x, mol->legendAtoms.at(i).pos.y, mol->legendAtoms.at(i).pos.z);
        stuff.append(static_cast<float>(mol->legendAtoms.at(i).an));

        stuff.append(eckn[3*j]);// an icosahedron corner
        stuff.append(eckn[3*j+1]);
        stuff.append(eckn[3*j+2]);
        stuff.append(static_cast<float>(j));

        stuff.append(static_cast<float>(arr[0]));
        stuff.append(static_cast<float>(arr[1]));
        stuff.append(static_cast<float>(arr[2]));
        stuff.append(static_cast<float>(arr[3]));

        stuff.append(ev.x);
        stuff.append(ev.y);
        stuff.append(ev.z);
        stuff.append(static_cast<float>(style));

        stuff.append(static_cast<float>((mol->legendAtoms.at(i).an==-42)?mol->legendAtoms.at(i).sof:mol->legendAtoms.at(i).peakHeight));
        stuff.append(static_cast<float>(qMax(0, mol->legendAtoms.at(i).symmGroup)));
        stuff.append(static_cast<float>(mol->legendAtoms.at(i).part));
        stuff.append(static_cast<float>(mol->legendAtoms.at(i).molindex));

        stuff.append(static_cast<float>(i));
        stuff.append(static_cast<float>(mol->legendAtoms.at(i).auidx));
        stuff.append(static_cast<float>(mol->legendAtoms.at(i).resiNr));
        stuff.append(0.0f);

        }
        latom_vertexBuffer.allocate(stuff.data(),stuff.size()*sizeof(float));
    }
    QVector<GLuint> indexes;
    uint una = static_cast<uint>(na);
    for (uint i = 0; i < una; i++){
        for (uint j = 0; j < 60; j++){
            indexes.append(triangle[j]+12*i);//_strips
        }
    }

    latom_indexBuffer = QOpenGLBuffer(QOpenGLBuffer::IndexBuffer); // Mind: use 'IndexBuffer' here
    latom_indexBuffer.create();
    latom_indexBuffer.setUsagePattern(QOpenGLBuffer::StaticDraw);
    if (!latom_indexBuffer.bind()) {printf("I was unable to bind atom_indexBuffer!\n");}
    latom_indexBuffer.allocate( indexes.size() * sizeof(GLuint) );
    latom_indexBuffer.write(0, indexes.data(), indexes.size()* sizeof(GLuint));
    latom_index_size = indexes.size();

    //printf("%d\n",__LINE__);
    atom_program->bind();
    atom_program->enableAttributeArray(0);
    atom_program->enableAttributeArray(1);
    atom_program->enableAttributeArray(2);
    atom_program->enableAttributeArray(3);
    atom_program->enableAttributeArray(4);
    atom_program->enableAttributeArray(5);
    //printf("%d\n",__LINE__);
    int stride = 6 * 4 * sizeof(float);
    atom_program->setAttributeBuffer(0, GL_FLOAT, 0, 4, stride);
    atom_program->setAttributeBuffer(1, GL_FLOAT, sizeof(float)*4  , 4, stride);
    atom_program->setAttributeBuffer(2, GL_FLOAT, sizeof(float)*8  , 4, stride);
    atom_program->setAttributeBuffer(3, GL_FLOAT, sizeof(float)*12 , 4, stride);
    atom_program->setAttributeBuffer(4, GL_FLOAT, sizeof(float)*16 , 4, stride);
    atom_program->setAttributeBuffer(5, GL_FLOAT, sizeof(float)*20 , 4, stride);// 20*sizeof(float)

    atom_program->release();

    latom_vao.release();
    latom_indexBuffer.release();
    latom_vertexBuffer.release();
    latom_vertexBuffer.destroy();
    latom_indexBuffer.destroy();
    //printf("thumbup\n");
    update();

}


void PlayOpenGL::makeSplitRot(){
    //printf("makeSplitRot\n");
    makeCurrent();
    splitrot_vao.release();
    if (splitrot_vao.isCreated()) {
        splitrot_vao.release();
        splitrot_vao.destroy();
        splitrot_vertexBuffer.destroy();
        splitrot_indexBuffer.destroy();
    }
    splitrot_vao.create();
    splitrot_vao.bind();
    splitrot_vertexBuffer.create();
    splitrot_vertexBuffer.setUsagePattern( QOpenGLBuffer::StaticDraw );
    //glDisable(GL_BLEND);
    if (!splitrot_vertexBuffer.bind()) {printf("m_vertexBufferObject2 I was unable to bind!\n");}

    QVector<float> pos;
    //QVector<float> col;
    QVector<GLuint> nbonds;
    for (int i=0; i<mol->splitLeftAtoms.size(); i++){
        pos.append(mol->splitLeftAtoms.at(i).pos.x);
        pos.append(mol->splitLeftAtoms.at(i).pos.y);
        pos.append(mol->splitLeftAtoms.at(i).pos.z);
        pos.append(1.0);
        /*printf("%4d %f %f %f %f \n",i,
               mol->splitLeftAtoms.at(i).pos.x,
               mol->splitLeftAtoms.at(i).pos.y,
               mol->splitLeftAtoms.at(i).pos.z,
               1.0
               );// */
    }
    for (int i=0; i<mol->splitRightAtoms.size(); i++){
        pos.append(mol->splitRightAtoms.at(i).pos.x);
        pos.append(mol->splitRightAtoms.at(i).pos.y);
        pos.append(mol->splitRightAtoms.at(i).pos.z);
        pos.append(2.0);

        /*printf("%4d %f %f %f %f \n",i+mol->splitLeftAtoms.size(),
               mol->splitRightAtoms.at(i).pos.x,
               mol->splitRightAtoms.at(i).pos.y,
               mol->splitRightAtoms.at(i).pos.z,
               2.0
               );// */
    }
    for (int i=0; i<mol->splitLbonds.size(); i++){
        nbonds.append(mol->splitLbonds.at(i).a1);
        nbonds.append(mol->splitLbonds.at(i).a2);
        //printf("L %d %d\n",mol->splitLbonds.at(i).a1,mol->splitLbonds.at(i).a2);
    }
    for (int i=0; i<mol->splitRbonds.size(); i++){
        nbonds.append(mol->splitRbonds.at(i).a1+mol->splitLeftAtoms.size());
        nbonds.append(mol->splitRbonds.at(i).a2+mol->splitLeftAtoms.size());

        //printf("R %d %d\n",mol->splitRbonds.at(i).a1+mol->splitLeftAtoms.size(),mol->splitRbonds.at(i).a2+mol->splitLeftAtoms.size());
    }
    splitrot_vertexBuffer.allocate(pos.size() * sizeof(float));
    splitrot_vertexBuffer.write(0, (void*)pos.data(), pos.size() * sizeof(float));

    nbonds.size();
    printf("splitbond = %d %d %d seat=%d\n",  nbonds.size(),mol->splitLbonds.size()+mol->splitRbonds.size(),mol->splitRbonds.size(),seat.size());
    // create a new buffer for the indexes
    splitrot_indexBuffer = QOpenGLBuffer(QOpenGLBuffer::IndexBuffer); // Mind: use 'IndexBuffer' here
    splitrot_indexBuffer.create();
    splitrot_indexBuffer.setUsagePattern(QOpenGLBuffer::StaticDraw);
    if (!splitrot_indexBuffer.bind()) {printf("splitrot_indexBuffer I was unable to bind!\n");}
    splitrot_indexBuffer.allocate(nbonds.data(), nbonds.size() * sizeof(GLuint) );
    if (!splitrot_program) splitrot_program = new QOpenGLShaderProgram(this);
    else splitrot_program->removeAllShaders();

    //printf("splitrot_program: %p id = %d\n",splitrot_program, splitrot_program->programId());
    bool result2 = splitrot_program->addCacheableShaderFromSourceFile( QOpenGLShader::Vertex, ":/shaders/splitrot.vert");
    if ( !result2 ) qWarning() << splitrot_program->log();
    result2 = splitrot_program->addCacheableShaderFromSourceFile( QOpenGLShader::Geometry, ":/shaders/splitrot.geom");
    if ( !result2 ) qWarning() << splitrot_program->log();
    result2 = splitrot_program->addCacheableShaderFromSourceFile( QOpenGLShader::Fragment, ":/shaders/splitrot.frag");
    if ( !result2 ) qWarning() << splitrot_program->log();
    result2 = splitrot_program->link();
    programInfo(splitrot_program,"splitrot");
    if ( !result2 ) qWarning() << splitrot_program->log();
    if ( !splitrot_program->bind() )    {
        qWarning() << "2Could not bind shader program to context";
        return;
    }

    splitrot_program->setUniformValue("radius", static_cast<float>(mol->bondStrength));
    splitrot_program->setUniformValue("lightPos", QVector3D(100.0, 100.0, 100.0));

    splitrot_program->setUniformValue("pmv", pmv);
    int stride = 0;//6*sizeof(float);
    splitrot_program->setAttributeBuffer( "VertexPosition", GL_FLOAT, 0, 4, stride );
    splitrot_program->enableAttributeArray( "VertexPosition" );
    splitrot_program->release();
    splitrot_vao.release();
    splitrot_indexBuffer.release();
    splitrot_vertexBuffer.release();
    splitrot_vertexBuffer.destroy();
    bond_indexBuffer.destroy();
    update();
}

void PlayOpenGL::makeSymmetryElements(){
    //printf("makeLegendAtoms\n");
    makeCurrent();
    symm_vao0.release();
    symm_vao1.release();
    symm_vao2.release();
    if (symm_vao0.isCreated()) {
        symm_vao0.release();
        symm_vao0.destroy();
        symm_vao1.release();
        symm_vao1.destroy();
        symm_vao2.release();
        symm_vao2.destroy();
        symm_vertexBuffer0.destroy();
        symm_vertexBuffer1.destroy();
        symm_vertexBuffer2.destroy();
        symm_program0->release();
        symm_program0->removeAllShaders();
        symm_program1->release();
        symm_program1->removeAllShaders();
        symm_program2->release();
        symm_program2->removeAllShaders();
    }
    symm_vao0.create();
    symm_vao0.bind();
    //glEnable(GL_PRIMITIVE_RESTART_FIXED_INDEX);
    GLfloat scv[18*4];
    for (int i=0;i<18;i++) {
        scv[4*i]=mol->symmColors.at(i).redF();
        scv[4*i+1]=mol->symmColors.at(i).greenF();
        scv[4*i+2]=mol->symmColors.at(i).blueF();
        scv[4*i+3]=mol->symmColors.at(i).alphaF();
        //printf("symcol %d %f %f %f %f\n",i,scv[4*i+0],scv[4*i+1],scv[4*i+2],scv[4*i+3]);
    }
    symm_vertexBuffer0.create();
    symm_vertexBuffer0.setUsagePattern( QOpenGLBuffer::StaticDraw );
    if (!symm_vertexBuffer0.bind()) {printf("I was unable to bind symm_vertexBuffer.\n");}


    QVector<float> p;
    axend = 0;
    invend = 0;
    planend = 0;
    for (int i = 0; i < mol->axvecs.size(); i++){
        p.append(mol->axvecs.at(i).x);
        p.append(mol->axvecs.at(i).y);
        p.append(mol->axvecs.at(i).z);
        p.append(mol->axoprs.at(i));
        p.append(mol->axcols.at(i));
        printf("i=%4d %8.4f %8.4f %8.4f %2d %2d\n",
               i,
        mol->axvecs.at(i).x,
        mol->axvecs.at(i).y,
        mol->axvecs.at(i).z,
        mol->axoprs.at(i),
        mol->axcols.at(i));

    }
    axend = p.size();
    symm_vertexBuffer0.allocate(p.data(),(p.size()*sizeof(float)));

    if (!symm_program0) symm_program0 = new QOpenGLShaderProgram(this);
    else symm_program0->removeAllShaders();
    bool result = symm_program0->addCacheableShaderFromSourceFile( QOpenGLShader::Vertex, ":/shaders/symm.vert");
    if ( !result ) qWarning() << symm_program0->log();
    result = symm_program0->addCacheableShaderFromSourceFile( QOpenGLShader::Geometry, ":/shaders/symmaxe.geom");
    if ( !result ) qWarning() << symm_program0->log();
    result = symm_program0->addCacheableShaderFromSourceFile( QOpenGLShader::Fragment, ":/shaders/symm.frag");
    if ( !result ) qWarning() << symm_program0->log();
    result = symm_program0->link();
    if ( !result ) qWarning() << symm_program0->log();
    if ( !symm_program0->bind() )    {
        qWarning() << "Could not bind shader program to context";
        return;
    }
    bool beforeInfo = shaderInfo;
    shaderInfo=false;//true;

    symm_program0->enableAttributeArray("vertex" );
    symm_program0->enableAttributeArray("oprf" );// */
    symm_program0->enableAttributeArray("colf" );// */
    int stride =  5 * sizeof(float);

    symm_program0->setAttributeBuffer("vertex", GL_FLOAT, 0, 3 , stride);
    symm_program0->setAttributeBuffer("oprf", GL_FLOAT, sizeof(float)*3, 1, stride);
    symm_program0->setAttributeBuffer("colf", GL_FLOAT, sizeof(float)*4, 1, stride);

    symm_program0->setUniformValueArray("Color",scv,18,4);//we have to this for color changes too

    symm_program0->setUniformValue("lightPos", QVector3D(100.0, 100.0, 100.0));
    programInfo(symm_program0, "symm0");
    symm_program0->release();
    symm_vertexBuffer0.release();
    p.clear();

    symm_vao0.release();
    symm_vao1.create();
    symm_vao1.bind();

    for (int i = 0; i < mol->invvecs.size(); i++){
        p.append(mol->invvecs.at(i).x);
        p.append(mol->invvecs.at(i).y);
        p.append(mol->invvecs.at(i).z);
        p.append(mol->invoprs.at(i));
        p.append(5.0f);
    }
    symm_vertexBuffer1.create();
    symm_vertexBuffer1.setUsagePattern( QOpenGLBuffer::StaticDraw );
    if (!symm_vertexBuffer1.bind()) {printf("I was unable to bind symm_vertexBuffer.\n");}
    invend = p.size();
    symm_vertexBuffer1.allocate(p.data(),(p.size()*sizeof(float)));

    if (!symm_program1) symm_program1 = new QOpenGLShaderProgram(this);
    else symm_program1->removeAllShaders();
    result = symm_program1->addCacheableShaderFromSourceFile( QOpenGLShader::Vertex, ":/shaders/symm.vert");
    //printf("%d\n",__LINE__);
    if ( !result ) qWarning() << symm_program1->log();
    result = symm_program1->addCacheableShaderFromSourceFile( QOpenGLShader::Geometry, ":/shaders/symm.geom");
    if ( !result ) qWarning() << symm_program1->log();
    result = symm_program1->addCacheableShaderFromSourceFile( QOpenGLShader::Fragment, ":/shaders/symm.frag");
    if ( !result ) qWarning() << symm_program1->log();
    result = symm_program1->link();
    if ( !result ) qWarning() << symm_program1->log();
    if ( !symm_program1->bind() )    {
        qWarning() << "Could not bind shader program to context";
        return;
    }
    symm_program1->setUniformValueArray("Color",scv,18,4);//we have to this for color changes too
    symm_program1->setUniformValue("lightPos", QVector3D(100.0, 100.0, 100.0));
    //*
    symm_program1->enableAttributeArray("vertex" );
    symm_program1->enableAttributeArray("oprf" );
    symm_program1->enableAttributeArray("colf" );
    symm_program1->setAttributeBuffer("vertex", GL_FLOAT, 0, 3 , stride);
    symm_program1->setAttributeBuffer("oprf", GL_FLOAT, sizeof(float)*3, 1, stride);
    symm_program1->setAttributeBuffer("colf", GL_FLOAT, sizeof(float)*4, 1, stride);
// */
    programInfo(symm_program1, "symm1");
    symm_program1->release();
    symm_vao1.release();
    p.clear();
    symm_vao2.create();
    symm_vao2.bind();

    for (int ti = 0; ti < mol->ptriangles.size(); ti++){
        p.append(mol->ptriangles.at(ti).nor.x);
        p.append(mol->ptriangles.at(ti).nor.y);
        p.append(mol->ptriangles.at(ti).nor.z);

        p.append(mol->ptriangles.at(ti).mid.x);
        p.append(mol->ptriangles.at(ti).mid.y);
        p.append(mol->ptriangles.at(ti).mid.z);

        p.append(mol->ptriangles.at(ti).verts0.x);
        p.append(mol->ptriangles.at(ti).verts0.y);
        p.append(mol->ptriangles.at(ti).verts0.z);

        p.append(mol->ptriangles.at(ti).verts1.x);
        p.append(mol->ptriangles.at(ti).verts1.y);
        p.append(mol->ptriangles.at(ti).verts1.z);

        p.append(mol->ptriangles.at(ti).glide.x);
        p.append(mol->ptriangles.at(ti).glide.y);
        p.append(mol->ptriangles.at(ti).glide.z);

        p.append(mol->ptriangles.at(ti).n);
        p.append(mol->ptriangles.at(ti).colr);
        //printf("ti %d n %d c %d\n",ti, mol->ptriangles.at(ti).n, mol->ptriangles.at(ti).colr);

        //p.append(ti%18);
        /*
       int pp = p.size();
        printf("n%8.4f %8.4f %8.4f m%8.4f %8.4f %8.4f I:%8.4f %8.4f %8.4f II:%8.4f %8.4f %8.4f g %8.4f %3.0f %f n=%3.0f c=%f\n",
               p[pp-17], p[pp-16], p[pp-15],
                p[pp-14], p[pp-13], p[pp-12],
                p[pp-11], p[pp-10], p[pp-9],
                p[pp-8], p[pp-7], p[pp-6],
                p[pp-5], p[pp-4], p[pp-3],
                p[pp-2],
                p[pp-1]);// * /
        {
            V3 start = mol->ptriangles.at(ti).verts0;
            V3 end = mol->ptriangles.at(ti).verts1;
            V3 direction   = Normalize(end - start);
            double l = sqrt(Norm(end - start));
            V3 lot = (direction*V3(1, 0, 0) > 0.8)?
                        (direction*V3(0, 1, 0) > 0.8)?
                        Normalize(direction% V3(0, 0, 1)):
                        Normalize(direction% V3(0, 1, 0)):
                        Normalize(direction% V3(1, 0, 0));
            V3 lot2 = Normalize(direction % lot);
         printf("%f (%f %f %f) lot (%f %f %f)  lot2 (%f %f %f)\n",l,direction.x,direction.y,direction.z,lot.x,lot.y,lot.z,lot2.x,lot2.y,lot2.z);
        }// */
    }



    glend = p.size();
    symm_vertexBuffer2.create();
    symm_vertexBuffer2.setUsagePattern( QOpenGLBuffer::StaticDraw );
    if (!symm_vertexBuffer2.bind()) {printf("I was unable to bind symm_vertexBuffer.\n");}
    symm_vertexBuffer2.allocate(p.data(),(p.size()*sizeof(float)));

    if (!symm_program2) symm_program2 = new QOpenGLShaderProgram(this);
    else symm_program2->removeAllShaders();
    result = symm_program2->addCacheableShaderFromSourceFile( QOpenGLShader::Vertex, ":/shaders/symmplane.vert");
    //printf("%d\n",__LINE__);
    if ( !result ) qWarning() << symm_program2->log();
    result = symm_program2->addCacheableShaderFromSourceFile( QOpenGLShader::Geometry, ":/shaders/symmplane.geom");
    if ( !result ) qWarning() << symm_program2->log();
    result = symm_program2->addCacheableShaderFromSourceFile( QOpenGLShader::Fragment, ":/shaders/symmplane.frag");
    if ( !result ) qWarning() << symm_program2->log();
    result = symm_program2->link();
    if ( !result ) qWarning() << symm_program2->log();
    if ( !symm_program2->bind() )    {
        qWarning() << "Could not bind shader program to context";
        return;
    }
    stride =  17 * sizeof(float);
    symm_program2->setUniformValueArray("Color",scv,18,4);//we have to this for color changes too
    symm_program2->setUniformValue("lightPos", QVector3D(100.0, 100.0, 100.0));
    //*
    symm_program2->enableAttributeArray("nor");
    symm_program2->enableAttributeArray("mid");
    symm_program2->enableAttributeArray("verts0");
    symm_program2->enableAttributeArray("verts1");
    symm_program2->enableAttributeArray("glide");
    symm_program2->enableAttributeArray("oprf");
    symm_program2->enableAttributeArray("colf");
    symm_program2->setAttributeBuffer("nor", GL_FLOAT, 0, 3 , stride);
    symm_program2->setAttributeBuffer("mid", GL_FLOAT, sizeof(float)*3, 3, stride);
    symm_program2->setAttributeBuffer("verts0", GL_FLOAT, sizeof(float)*6, 3, stride);
    symm_program2->setAttributeBuffer("verts1", GL_FLOAT, sizeof(float)*9, 3, stride);
    symm_program2->setAttributeBuffer("glide", GL_FLOAT, sizeof(float)*12, 3, stride);
    symm_program2->setAttributeBuffer("oprf", GL_FLOAT, sizeof(float)*15, 1, stride);
    symm_program2->setAttributeBuffer("colf", GL_FLOAT, sizeof(float)*16, 1, stride);

    programInfo(symm_program2, "symm2");
    symm_program2->release();
    symm_vao2.release();

    printf("%d axend=%d invend=%d planend=%d glend=%d = %d ptriangles=%d \n",__LINE__,axend,invend,planend,glend,p.size(), mol->ptriangles.size());
    shaderInfo=beforeInfo;
}


void PlayOpenGL::programInfo(QOpenGLShaderProgram *p, const QString pname){
    if (!shaderInfo) return;
    GLint count;

    GLint size; // size of the variable
    GLenum type; // type of the variable (float, vec3 or mat4, etc)
    char cnam[100];
    sprintf(cnam, "%s", pname.toStdString().c_str());

    const GLsizei bufSize = 20; // maximum name length
    GLchar name[bufSize]; // variable name in GLSL
    GLsizei length; // name length
    //glGetProgramiv(p->programId(),  GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, &count);

    //printf("GL_ACTIVE_ATTRIBUTE_MAX_LENGTH: %d\n", count);
    glGetProgramiv(p->programId(), GL_ACTIVE_ATTRIBUTES, &count);
    printf("\n#######################################################################################################################\n"
           "%-20s Active Attributes: %d\n#######################################################################################################################\n", cnam, count);


    for (GLint i = 0; i < count; i++){
        glGetActiveAttrib(p->programId(), (GLuint)i, bufSize, &length, &size, &type, name);

        printf("%-20s Attribute #%-2d Type: %-23s Name: %-20s stringlength=%2d size=%d (%d)\n"
               , cnam
               , i
               , glTypeInt2String(type).toStdString().c_str()
               , name, length
               , size, p->attributeLocation(name));
    }
    glGetProgramiv(p->programId(), GL_ACTIVE_UNIFORMS, &count);
    printf("%-20s Active Uniforms: %d\n#######################################################################################################################\n", cnam, count);

    for (GLint i = 0; i < count; i++){
        glGetActiveUniform(p->programId(), (GLuint)i, bufSize, &length, &size, &type, name);

        printf("%-20s Uniform #%-2d   Type: %-23s Name: %-20s stringlength=%2d size=%d\n", cnam, i, glTypeInt2String(type).toStdString().c_str(), name,length, size);
    }
}

void PlayOpenGL::makeClassicAtoms(const CEnvironment &atoms){

    printf("makeClassicAtoms\n");
    rotze = (!isMainWindow)?0:-1;
    printf("makeAtoms rotation center set to: %d\n",rotze);
    makeCurrent();
    GLenum err = GL_NO_ERROR;
    while((err = glGetError()) != GL_NO_ERROR)
    {
      printf("before makeAtoms %s error %X\n", parent()->objectName().toStdString().c_str(),err);
      //printf("%s\n",(char*)gluErrorString(err));
    }
    catom_vao.release();
    if (catom_vao.isCreated()) {
        catom_vao.release();
        catom_vao.destroy();
        catom_vertexBuffer.destroy();
        catom_indexBuffer.destroy();
        catom_program->release();
        catom_program->removeAllShaders();
    }
    catom_vao.create();
    catom_vao.bind();
    //glEnable(GL_PRIMITIVE_RESTART_FIXED_INDEX);
    catom_vertexBuffer.create();
    catom_vertexBuffer.setUsagePattern( QOpenGLBuffer::StaticDraw );
    if (!catom_vertexBuffer.bind()) {printf("I was unable to bind classic atom_vertexBuffer.\n");}
    static const GLuint idx2[960] = {
      1,     42,     44,//  0 0.275904 0.321244 0.275904
      42,     12,     43,//  1 0.275904 0.312869 0.285473
      43,     14,     44,//  2 0.312869 0.275904 0.285473
      42,     43,     44,//  3 0.285473 0.285473 0.321244
      12,     45,     47,//  4 0.275904 0.285473 0.312869
      45,      0,     46,//  5 0.275904 0.275904 0.321244
      46,     13,     47,//  6 0.275904 0.312869 0.285473
      45,     46,     47,//  7 0.321244 0.285473 0.285473
      13,     48,     50,//  8 0.275904 0.285473 0.312869
      48,      5,     49,//  9 0.275904 0.275904 0.321244
      49,     14,     50,// 10 0.275904 0.312869 0.285473
      48,     49,     50,// 11 0.321244 0.285473 0.285473
      12,     47,     43,// 12 0.312869 0.324920 0.312869
      47,     13,     50,// 13 0.312869 0.312869 0.324920
      50,     14,     43,// 14 0.312869 0.312869 0.324920
      47,     50,     43,// 15 0.324920 0.324920 0.324920
      0,     45,     52,// 16 0.275904 0.321244 0.275904
      45,     12,     51,// 17 0.275904 0.312869 0.285473
      51,     16,     52,// 18 0.312869 0.275904 0.285473
      45,     51,     52,// 19 0.285473 0.285473 0.321244
      12,     42,     54,// 20 0.275904 0.285473 0.312869
      42,      1,     53,// 21 0.275904 0.275904 0.321244
      53,     15,     54,// 22 0.275904 0.312869 0.285473
      42,     53,     54,// 23 0.321244 0.285473 0.285473
      15,     55,     57,// 24 0.275904 0.285473 0.312869
      55,      7,     56,// 25 0.275904 0.275904 0.321244
      56,     16,     57,// 26 0.275904 0.312869 0.285473
      55,     56,     57,// 27 0.321244 0.285473 0.285473
      12,     54,     51,// 28 0.312869 0.324920 0.312869
      54,     15,     57,// 29 0.312869 0.312869 0.324920
      57,     16,     51,// 30 0.312869 0.312869 0.324920
      54,     57,     51,// 31 0.324920 0.324920 0.324920
      10,     58,     60,// 32 0.275904 0.321244 0.275904
      58,     17,     59,// 33 0.275904 0.312869 0.285473
      59,     18,     60,// 34 0.312869 0.275904 0.285473
      58,     59,     60,// 35 0.285473 0.285473 0.321244
      17,     61,     62,// 36 0.275904 0.285473 0.312869
      61,      0,     52,// 37 0.275904 0.275904 0.321244
      52,     16,     62,// 38 0.275904 0.312869 0.285473
      61,     52,     62,// 39 0.321244 0.285473 0.285473
      16,     56,     64,// 40 0.275904 0.285473 0.312869
      56,      7,     63,// 41 0.275904 0.275904 0.321244
      63,     18,     64,// 42 0.275904 0.312869 0.285473
      56,     63,     64,// 43 0.321244 0.285473 0.285473
      17,     62,     59,// 44 0.312869 0.324920 0.312869
      62,     16,     64,// 45 0.312869 0.312869 0.324920
      64,     18,     59,// 46 0.312869 0.312869 0.324920
      62,     64,     59,// 47 0.324920 0.324920 0.324920
      0,     61,     66,// 48 0.275904 0.321244 0.275904
      61,     17,     65,// 49 0.275904 0.312869 0.285473
      65,     20,     66,// 50 0.312869 0.275904 0.285473
      61,     65,     66,// 51 0.285473 0.285473 0.321244
      17,     58,     68,// 52 0.275904 0.285473 0.312869
      58,     10,     67,// 53 0.275904 0.275904 0.321244
      67,     19,     68,// 54 0.275904 0.312869 0.285473
      58,     67,     68,// 55 0.321244 0.285473 0.285473
      19,     69,     71,// 56 0.275904 0.285473 0.312869
      69,     11,     70,// 57 0.275904 0.275904 0.321244
      70,     20,     71,// 58 0.275904 0.312869 0.285473
      69,     70,     71,// 59 0.321244 0.285473 0.285473
      17,     68,     65,// 60 0.312869 0.324920 0.312869
      68,     19,     71,// 61 0.312869 0.312869 0.324920
      71,     20,     65,// 62 0.312869 0.312869 0.324920
      68,     71,     65,// 63 0.324920 0.324920 0.324920
      11,     72,     70,// 64 0.275904 0.321244 0.275904
      72,     21,     73,// 65 0.275904 0.312869 0.285473
      73,     20,     70,// 66 0.312869 0.275904 0.285473
      72,     73,     70,// 67 0.285473 0.285473 0.321244
      21,     74,     75,// 68 0.275904 0.285473 0.312869
      74,      5,     48,// 69 0.275904 0.275904 0.321244
      48,     13,     75,// 70 0.275904 0.312869 0.285473
      74,     48,     75,// 71 0.321244 0.285473 0.285473
      13,     46,     76,// 72 0.275904 0.285473 0.312869
      46,      0,     66,// 73 0.275904 0.275904 0.321244
      66,     20,     76,// 74 0.275904 0.312869 0.285473
      46,     66,     76,// 75 0.321244 0.285473 0.285473
      21,     75,     73,// 76 0.312869 0.324920 0.312869
      75,     13,     76,// 77 0.312869 0.312869 0.324920
      76,     20,     73,// 78 0.312869 0.312869 0.324920
      75,     76,     73,// 79 0.324920 0.324920 0.324920
      5,     74,     78,// 80 0.275904 0.321244 0.275904
      74,     21,     77,// 81 0.275904 0.312869 0.285473
      77,     23,     78,// 82 0.312869 0.275904 0.285473
      74,     77,     78,// 83 0.285473 0.285473 0.321244
      21,     72,     80,// 84 0.275904 0.285473 0.312869
      72,     11,     79,// 85 0.275904 0.275904 0.321244
      79,     22,     80,// 86 0.275904 0.312869 0.285473
      72,     79,     80,// 87 0.321244 0.285473 0.285473
      22,     81,     83,// 88 0.275904 0.285473 0.312869
      81,      4,     82,// 89 0.275904 0.275904 0.321244
      82,     23,     83,// 90 0.275904 0.312869 0.285473
      81,     82,     83,// 91 0.321244 0.285473 0.285473
      21,     80,     77,// 92 0.312869 0.324920 0.312869
      80,     22,     83,// 93 0.312869 0.312869 0.324920
      83,     23,     77,// 94 0.312869 0.312869 0.324920
      80,     83,     77,// 95 0.324920 0.324920 0.324920
      2,     84,     86,// 96 0.275904 0.321244 0.275904
      84,     24,     85,// 97 0.275904 0.312869 0.285473
      85,     25,     86,// 98 0.312869 0.275904 0.285473
      84,     85,     86,// 99 0.285473 0.285473 0.321244
      24,     87,     88,//100 0.275904 0.285473 0.312869
      87,     11,     69,//101 0.275904 0.275904 0.321244
      69,     19,     88,//102 0.275904 0.312869 0.285473
      87,     69,     88,//103 0.321244 0.285473 0.285473
      19,     67,     90,//104 0.275904 0.285473 0.312869
      67,     10,     89,//105 0.275904 0.275904 0.321244
      89,     25,     90,//106 0.275904 0.312869 0.285473
      67,     89,     90,//107 0.321244 0.285473 0.285473
      24,     88,     85,//108 0.312869 0.324920 0.312869
      88,     19,     90,//109 0.312869 0.312869 0.324920
      90,     25,     85,//110 0.312869 0.312869 0.324920
      88,     90,     85,//111 0.324920 0.324920 0.324920
      11,     87,     79,//112 0.275904 0.321244 0.275904
      87,     24,     91,//113 0.275904 0.312869 0.285473
      91,     22,     79,//114 0.312869 0.275904 0.285473
      87,     91,     79,//115 0.285473 0.285473 0.321244
      24,     84,     93,//116 0.275904 0.285473 0.312869
      84,      2,     92,//117 0.275904 0.275904 0.321244
      92,     26,     93,//118 0.275904 0.312869 0.285473
      84,     92,     93,//119 0.321244 0.285473 0.285473
      26,     94,     95,//120 0.275904 0.285473 0.312869
      94,      4,     81,//121 0.275904 0.275904 0.321244
      81,     22,     95,//122 0.275904 0.312869 0.285473
      94,     81,     95,//123 0.321244 0.285473 0.285473
      24,     93,     91,//124 0.312869 0.324920 0.312869
      93,     26,     95,//125 0.312869 0.312869 0.324920
      95,     22,     91,//126 0.312869 0.312869 0.324920
      93,     95,     91,//127 0.324920 0.324920 0.324920
      10,     96,     89,//128 0.275904 0.321244 0.275904
      96,     27,     97,//129 0.275904 0.312869 0.285473
      97,     25,     89,//130 0.312869 0.275904 0.285473
      96,     97,     89,//131 0.285473 0.285473 0.321244
      27,     98,    100,//132 0.275904 0.285473 0.312869
      98,      6,     99,//133 0.275904 0.275904 0.321244
      99,     28,    100,//134 0.275904 0.312869 0.285473
      98,     99,    100,//135 0.321244 0.285473 0.285473
      28,    101,    102,//136 0.275904 0.285473 0.312869
      101,      2,     86,//137 0.275904 0.275904 0.321244
      86,     25,    102,//138 0.275904 0.312869 0.285473
      101,     86,    102,//139 0.321244 0.285473 0.285473
      27,    100,     97,//140 0.312869 0.324920 0.312869
      100,     28,    102,//141 0.312869 0.312869 0.324920
      102,     25,     97,//142 0.312869 0.312869 0.324920
      100,    102,     97,//143 0.324920 0.324920 0.324920
      6,     98,    104,//144 0.275904 0.321244 0.275904
      98,     27,    103,//145 0.275904 0.312869 0.285473
      103,     29,    104,//146 0.312869 0.275904 0.285473
      98,    103,    104,//147 0.285473 0.285473 0.321244
      27,     96,    105,//148 0.275904 0.285473 0.312869
      96,     10,     60,//149 0.275904 0.275904 0.321244
      60,     18,    105,//150 0.275904 0.312869 0.285473
      96,     60,    105,//151 0.321244 0.285473 0.285473
      18,     63,    107,//152 0.275904 0.285473 0.312869
      63,      7,    106,//153 0.275904 0.275904 0.321244
      106,     29,    107,//154 0.275904 0.312869 0.285473
      63,    106,    107,//155 0.321244 0.285473 0.285473
      27,    105,    103,//156 0.312869 0.324920 0.312869
      105,     18,    107,//157 0.312869 0.312869 0.324920
      107,     29,    103,//158 0.312869 0.312869 0.324920
      105,    107,    103,//159 0.324920 0.324920 0.324920
      7,    108,    106,//160 0.275904 0.321244 0.275904
      108,     30,    109,//161 0.275904 0.312869 0.285473
      109,     29,    106,//162 0.312869 0.275904 0.285473
      108,    109,    106,//163 0.285473 0.285473 0.321244
      30,    110,    112,//164 0.275904 0.285473 0.312869
      110,      8,    111,//165 0.275904 0.275904 0.321244
      111,     31,    112,//166 0.275904 0.312869 0.285473
      110,    111,    112,//167 0.321244 0.285473 0.285473
      31,    113,    114,//168 0.275904 0.285473 0.312869
      113,      6,    104,//169 0.275904 0.275904 0.321244
      104,     29,    114,//170 0.275904 0.312869 0.285473
      113,    104,    114,//171 0.321244 0.285473 0.285473
      30,    112,    109,//172 0.312869 0.324920 0.312869
      112,     31,    114,//173 0.312869 0.312869 0.324920
      114,     29,    109,//174 0.312869 0.312869 0.324920
      112,    114,    109,//175 0.324920 0.324920 0.324920
      8,    110,    116,//176 0.275904 0.321244 0.275904
      110,     30,    115,//177 0.275904 0.312869 0.285473
      115,     32,    116,//178 0.312869 0.275904 0.285473
      110,    115,    116,//179 0.285473 0.285473 0.321244
      30,    108,    117,//180 0.275904 0.285473 0.312869
      108,      7,     55,//181 0.275904 0.275904 0.321244
      55,     15,    117,//182 0.275904 0.312869 0.285473
      108,     55,    117,//183 0.321244 0.285473 0.285473
      15,     53,    119,//184 0.275904 0.285473 0.312869
      53,      1,    118,//185 0.275904 0.275904 0.321244
      118,     32,    119,//186 0.275904 0.312869 0.285473
      53,    118,    119,//187 0.321244 0.285473 0.285473
      30,    117,    115,//188 0.312869 0.324920 0.312869
      117,     15,    119,//189 0.312869 0.312869 0.324920
      119,     32,    115,//190 0.312869 0.312869 0.324920
      117,    119,    115,//191 0.324920 0.324920 0.324920
      9,    120,    122,//192 0.275904 0.321244 0.275904
      120,     33,    121,//193 0.275904 0.312869 0.285473
      121,     34,    122,//194 0.312869 0.275904 0.285473
      120,    121,    122,//195 0.285473 0.285473 0.321244
      33,    123,    124,//196 0.275904 0.285473 0.312869
      123,      1,     44,//197 0.275904 0.275904 0.321244
      44,     14,    124,//198 0.275904 0.312869 0.285473
      123,     44,    124,//199 0.321244 0.285473 0.285473
      14,     49,    126,//200 0.275904 0.285473 0.312869
      49,      5,    125,//201 0.275904 0.275904 0.321244
      125,     34,    126,//202 0.275904 0.312869 0.285473
      49,    125,    126,//203 0.321244 0.285473 0.285473
      33,    124,    121,//204 0.312869 0.324920 0.312869
      124,     14,    126,//205 0.312869 0.312869 0.324920
      126,     34,    121,//206 0.312869 0.312869 0.324920
      124,    126,    121,//207 0.324920 0.324920 0.324920
      1,    123,    118,//208 0.275904 0.321244 0.275904
      123,     33,    127,//209 0.275904 0.312869 0.285473
      127,     32,    118,//210 0.312869 0.275904 0.285473
      123,    127,    118,//211 0.285473 0.285473 0.321244
      33,    120,    129,//212 0.275904 0.285473 0.312869
      120,      9,    128,//213 0.275904 0.275904 0.321244
      128,     35,    129,//214 0.275904 0.312869 0.285473
      120,    128,    129,//215 0.321244 0.285473 0.285473
      35,    130,    131,//216 0.275904 0.285473 0.312869
      130,      8,    116,//217 0.275904 0.275904 0.321244
      116,     32,    131,//218 0.275904 0.312869 0.285473
      130,    116,    131,//219 0.321244 0.285473 0.285473
      33,    129,    127,//220 0.312869 0.324920 0.312869
      129,     35,    131,//221 0.312869 0.312869 0.324920
      131,     32,    127,//222 0.312869 0.312869 0.324920
      129,    131,    127,//223 0.324920 0.324920 0.324920
      4,    132,     82,//224 0.275904 0.321244 0.275904
      132,     36,    133,//225 0.275904 0.312869 0.285473
      133,     23,     82,//226 0.312869 0.275904 0.285473
      132,    133,     82,//227 0.285473 0.285473 0.321244
      36,    134,    135,//228 0.275904 0.285473 0.312869
      134,      9,    122,//229 0.275904 0.275904 0.321244
      122,     34,    135,//230 0.275904 0.312869 0.285473
      134,    122,    135,//231 0.321244 0.285473 0.285473
      34,    125,    136,//232 0.275904 0.285473 0.312869
      125,      5,     78,//233 0.275904 0.275904 0.321244
      78,     23,    136,//234 0.275904 0.312869 0.285473
      125,     78,    136,//235 0.321244 0.285473 0.285473
      36,    135,    133,//236 0.312869 0.324920 0.312869
      135,     34,    136,//237 0.312869 0.312869 0.324920
      136,     23,    133,//238 0.312869 0.312869 0.324920
      135,    136,    133,//239 0.324920 0.324920 0.324920
      9,    134,    138,//240 0.275904 0.321244 0.275904
      134,     36,    137,//241 0.275904 0.312869 0.285473
      137,     38,    138,//242 0.312869 0.275904 0.285473
      134,    137,    138,//243 0.285473 0.285473 0.321244
      36,    132,    140,//244 0.275904 0.285473 0.312869
      132,      4,    139,//245 0.275904 0.275904 0.321244
      139,     37,    140,//246 0.275904 0.312869 0.285473
      132,    139,    140,//247 0.321244 0.285473 0.285473
      37,    141,    143,//248 0.275904 0.285473 0.312869
      141,      3,    142,//249 0.275904 0.275904 0.321244
      142,     38,    143,//250 0.275904 0.312869 0.285473
      141,    142,    143,//251 0.321244 0.285473 0.285473
      36,    140,    137,//252 0.312869 0.324920 0.312869
      140,     37,    143,//253 0.312869 0.312869 0.324920
      143,     38,    137,//254 0.312869 0.312869 0.324920
      140,    143,    137,//255 0.324920 0.324920 0.324920
      3,    144,    142,//256 0.275904 0.321244 0.275904
      144,     39,    145,//257 0.275904 0.312869 0.285473
      145,     38,    142,//258 0.312869 0.275904 0.285473
      144,    145,    142,//259 0.285473 0.285473 0.321244
      39,    146,    147,//260 0.275904 0.285473 0.312869
      146,      8,    130,//261 0.275904 0.275904 0.321244
      130,     35,    147,//262 0.275904 0.312869 0.285473
      146,    130,    147,//263 0.321244 0.285473 0.285473
      35,    128,    148,//264 0.275904 0.285473 0.312869
      128,      9,    138,//265 0.275904 0.275904 0.321244
      138,     38,    148,//266 0.275904 0.312869 0.285473
      128,    138,    148,//267 0.321244 0.285473 0.285473
      39,    147,    145,//268 0.312869 0.324920 0.312869
      147,     35,    148,//269 0.312869 0.312869 0.324920
      148,     38,    145,//270 0.312869 0.312869 0.324920
      147,    148,    145,//271 0.324920 0.324920 0.324920
      8,    146,    111,//272 0.275904 0.321244 0.275904
      146,     39,    149,//273 0.275904 0.312869 0.285473
      149,     31,    111,//274 0.312869 0.275904 0.285473
      146,    149,    111,//275 0.285473 0.285473 0.321244
      39,    144,    151,//276 0.275904 0.285473 0.312869
      144,      3,    150,//277 0.275904 0.275904 0.321244
      150,     40,    151,//278 0.275904 0.312869 0.285473
      144,    150,    151,//279 0.321244 0.285473 0.285473
      40,    152,    153,//280 0.275904 0.285473 0.312869
      152,      6,    113,//281 0.275904 0.275904 0.321244
      113,     31,    153,//282 0.275904 0.312869 0.285473
      152,    113,    153,//283 0.321244 0.285473 0.285473
      39,    151,    149,//284 0.312869 0.324920 0.312869
      151,     40,    153,//285 0.312869 0.312869 0.324920
      153,     31,    149,//286 0.312869 0.312869 0.324920
      151,    153,    149,//287 0.324920 0.324920 0.324920
      3,    154,    150,//288 0.275904 0.321244 0.275904
      154,     41,    155,//289 0.275904 0.312869 0.285473
      155,     40,    150,//290 0.312869 0.275904 0.285473
      154,    155,    150,//291 0.285473 0.285473 0.321244
      41,    156,    157,//292 0.275904 0.285473 0.312869
      156,      2,    101,//293 0.275904 0.275904 0.321244
      101,     28,    157,//294 0.275904 0.312869 0.285473
      156,    101,    157,//295 0.321244 0.285473 0.285473
      28,     99,    158,//296 0.275904 0.285473 0.312869
      99,      6,    152,//297 0.275904 0.275904 0.321244
      152,     40,    158,//298 0.275904 0.312869 0.285473
      99,    152,    158,//299 0.321244 0.285473 0.285473
      41,    157,    155,//300 0.312869 0.324920 0.312869
      157,     28,    158,//301 0.312869 0.312869 0.324920
      158,     40,    155,//302 0.312869 0.312869 0.324920
      157,    158,    155,//303 0.324920 0.324920 0.324920
      2,    156,     92,//304 0.275904 0.321244 0.275904
      156,     41,    159,//305 0.275904 0.312869 0.285473
      159,     26,     92,//306 0.312869 0.275904 0.285473
      156,    159,     92,//307 0.285473 0.285473 0.321244
      41,    154,    160,//308 0.275904 0.285473 0.312869
      154,      3,    141,//309 0.275904 0.275904 0.321244
      141,     37,    160,//310 0.275904 0.312869 0.285473
      154,    141,    160,//311 0.321244 0.285473 0.285473
      37,    139,    161,//312 0.275904 0.285473 0.312869
      139,      4,     94,//313 0.275904 0.275904 0.321244
      94,     26,    161,//314 0.275904 0.312869 0.285473
      139,     94,    161,//315 0.321244 0.285473 0.285473
      41,    160,    159,//316 0.312869 0.324920 0.312869
      160,     37,    161,//317 0.312869 0.312869 0.324920
      161,     26,    159,//318 0.312869 0.312869 0.324920
      160,    161,    159 //319 0.324920 0.324920 0.324920
    };
    static const GLfloat v[486] = {
      -0.525731f,   0.850651f,   0.000000f,//0
      0.525731f,   0.850651f,   0.000000f,//1
      -0.525731f,  -0.850651f,   0.000000f,//2
      0.525731f,  -0.850651f,   0.000000f,//3
      0.000000f,  -0.525731f,   0.850651f,//4
      0.000000f,   0.525731f,   0.850651f,//5
      0.000000f,  -0.525731f,  -0.850651f,//6
      0.000000f,   0.525731f,  -0.850651f,//7
      0.850651f,   0.000000f,  -0.525731f,//8
      0.850651f,   0.000000f,   0.525731f,//9
      -0.850651f,   0.000000f,  -0.525731f,//10
      -0.850651f,   0.000000f,   0.525731f,//11
      0.000000f,   1.000000f,   0.000000f,//12
      -0.309017f,   0.809017f,   0.500000f,//13
      0.309017f,   0.809017f,   0.500000f,//14
      0.309017f,   0.809017f,  -0.500000f,//15
      -0.309017f,   0.809017f,  -0.500000f,//16
      -0.809017f,   0.500000f,  -0.309017f,//17
      -0.500000f,   0.309017f,  -0.809017f,//18
      -1.000000f,   0.000000f,   0.000000f,//19
      -0.809017f,   0.500000f,   0.309017f,//20
      -0.500000f,   0.309017f,   0.809017f,//21
      -0.500000f,  -0.309017f,   0.809017f,//22
      0.000000f,   0.000000f,   1.000000f,//23
      -0.809017f,  -0.500000f,   0.309017f,//24
      -0.809017f,  -0.500000f,  -0.309017f,//25
      -0.309017f,  -0.809017f,   0.500000f,//26
      -0.500000f,  -0.309017f,  -0.809017f,//27
      -0.309017f,  -0.809017f,  -0.500000f,//28
      0.000000f,   0.000000f,  -1.000000f,//29
      0.500000f,   0.309017f,  -0.809017f,//30
      0.500000f,  -0.309017f,  -0.809017f,//31
      0.809017f,   0.500000f,  -0.309017f,//32
      0.809017f,   0.500000f,   0.309017f,//33
      0.500000f,   0.309017f,   0.809017f,//34
      1.000000f,   0.000000f,   0.000000f,//35
      0.500000f,  -0.309017f,   0.809017f,//36
      0.309017f,  -0.809017f,   0.500000f,//37
      0.809017f,  -0.500000f,   0.309017f,//38
      0.809017f,  -0.500000f,  -0.309017f,//39
      0.309017f,  -0.809017f,  -0.500000f,//40
      0.000000f,  -1.000000f,   0.000000f,//41
      0.273267f,   0.961938f,   0.000000f,//42
      0.162460f,   0.951057f,   0.262866f,//43
      0.433889f,   0.862668f,   0.259892f,//44
      -0.273267f,   0.961938f,   0.000000f,//45
      -0.433889f,   0.862668f,   0.259892f,//46
      -0.162460f,   0.951057f,   0.262866f,//47
      -0.160622f,   0.693780f,   0.702046f,//48
      0.160622f,   0.693780f,   0.702046f,//49
      0.000000f,   0.850651f,   0.525731f,//50
      -0.162460f,   0.951057f,  -0.262866f,//51
      -0.433889f,   0.862668f,  -0.259892f,//52
      0.433889f,   0.862668f,  -0.259892f,//53
      0.162460f,   0.951057f,  -0.262866f,//54
      0.160622f,   0.693780f,  -0.702046f,//55
      -0.160622f,   0.693780f,  -0.702046f,//56
      0.000000f,   0.850651f,  -0.525731f,//57
      -0.862668f,   0.259892f,  -0.433889f,//58
      -0.688191f,   0.425325f,  -0.587785f,//59
      -0.702046f,   0.160622f,  -0.693780f,//60
      -0.693780f,   0.702046f,  -0.160622f,//61
      -0.587785f,   0.688191f,  -0.425325f,//62
      -0.259892f,   0.433889f,  -0.862668f,//63
      -0.425325f,   0.587785f,  -0.688191f,//64
      -0.850651f,   0.525731f,   0.000000f,//65
      -0.693780f,   0.702046f,   0.160622f,//66
      -0.961938f,   0.000000f,  -0.273267f,//67
      -0.951057f,   0.262866f,  -0.162460f,//68
      -0.961938f,   0.000000f,   0.273267f,//69
      -0.862668f,   0.259892f,   0.433889f,//70
      -0.951057f,   0.262866f,   0.162460f,//71
      -0.702046f,   0.160622f,   0.693780f,//72
      -0.688191f,   0.425325f,   0.587785f,//73
      -0.259892f,   0.433889f,   0.862668f,//74
      -0.425325f,   0.587785f,   0.688191f,//75
      -0.587785f,   0.688191f,   0.425325f,//76
      -0.262866f,   0.162460f,   0.951057f,//77
      0.000000f,   0.273267f,   0.961938f,//78
      -0.702046f,  -0.160622f,   0.693780f,//79
      -0.525731f,   0.000000f,   0.850651f,//80
      -0.259892f,  -0.433889f,   0.862668f,//81
      0.000000f,  -0.273267f,   0.961938f,//82
      -0.262866f,  -0.162460f,   0.951057f,//83
      -0.693780f,  -0.702046f,   0.160622f,//84
      -0.850651f,  -0.525731f,   0.000000f,//85
      -0.693780f,  -0.702046f,  -0.160622f,//86
      -0.862668f,  -0.259892f,   0.433889f,//87
      -0.951057f,  -0.262866f,   0.162460f,//88
      -0.862668f,  -0.259892f,  -0.433889f,//89
      -0.951057f,  -0.262866f,  -0.162460f,//90
      -0.688191f,  -0.425325f,   0.587785f,//91
      -0.433889f,  -0.862668f,   0.259892f,//92
      -0.587785f,  -0.688191f,   0.425325f,//93
      -0.160622f,  -0.693780f,   0.702046f,//94
      -0.425325f,  -0.587785f,   0.688191f,//95
      -0.702046f,  -0.160622f,  -0.693780f,//96
      -0.688191f,  -0.425325f,  -0.587785f,//97
      -0.259892f,  -0.433889f,  -0.862668f,//98
      -0.160622f,  -0.693780f,  -0.702046f,//99
      -0.425325f,  -0.587785f,  -0.688191f,//100
      -0.433889f,  -0.862668f,  -0.259892f,//101
      -0.587785f,  -0.688191f,  -0.425325f,//102
      -0.262866f,  -0.162460f,  -0.951057f,//103
      0.000000f,  -0.273267f,  -0.961938f,//104
      -0.525731f,   0.000000f,  -0.850651f,//105
      0.000000f,   0.273267f,  -0.961938f,//106
      -0.262866f,   0.162460f,  -0.951057f,//107
      0.259892f,   0.433889f,  -0.862668f,//108
      0.262866f,   0.162460f,  -0.951057f,//109
      0.702046f,   0.160622f,  -0.693780f,//110
      0.702046f,  -0.160622f,  -0.693780f,//111
      0.525731f,   0.000000f,  -0.850651f,//112
      0.259892f,  -0.433889f,  -0.862668f,//113
      0.262866f,  -0.162460f,  -0.951057f,//114
      0.688191f,   0.425325f,  -0.587785f,//115
      0.862668f,   0.259892f,  -0.433889f,//116
      0.425325f,   0.587785f,  -0.688191f,//117
      0.693780f,   0.702046f,  -0.160622f,//118
      0.587785f,   0.688191f,  -0.425325f,//119
      0.862668f,   0.259892f,   0.433889f,//120
      0.688191f,   0.425325f,   0.587785f,//121
      0.702046f,   0.160622f,   0.693780f,//122
      0.693780f,   0.702046f,   0.160622f,//123
      0.587785f,   0.688191f,   0.425325f,//124
      0.259892f,   0.433889f,   0.862668f,//125
      0.425325f,   0.587785f,   0.688191f,//126
      0.850651f,   0.525731f,   0.000000f,//127
      0.961938f,   0.000000f,   0.273267f,//128
      0.951057f,   0.262866f,   0.162460f,//129
      0.961938f,   0.000000f,  -0.273267f,//130
      0.951057f,   0.262866f,  -0.162460f,//131
      0.259892f,  -0.433889f,   0.862668f,//132
      0.262866f,  -0.162460f,   0.951057f,//133
      0.702046f,  -0.160622f,   0.693780f,//134
      0.525731f,   0.000000f,   0.850651f,//135
      0.262866f,   0.162460f,   0.951057f,//136
      0.688191f,  -0.425325f,   0.587785f,//137
      0.862668f,  -0.259892f,   0.433889f,//138
      0.160622f,  -0.693780f,   0.702046f,//139
      0.425325f,  -0.587785f,   0.688191f,//140
      0.433889f,  -0.862668f,   0.259892f,//141
      0.693780f,  -0.702046f,   0.160622f,//142
      0.587785f,  -0.688191f,   0.425325f,//143
      0.693780f,  -0.702046f,  -0.160622f,//144
      0.850651f,  -0.525731f,   0.000000f,//145
      0.862668f,  -0.259892f,  -0.433889f,//146
      0.951057f,  -0.262866f,  -0.162460f,//147
      0.951057f,  -0.262866f,   0.162460f,//148
      0.688191f,  -0.425325f,  -0.587785f,//149
      0.433889f,  -0.862668f,  -0.259892f,//150
      0.587785f,  -0.688191f,  -0.425325f,//151
      0.160622f,  -0.693780f,  -0.702046f,//152
      0.425325f,  -0.587785f,  -0.688191f,//153
      0.273267f,  -0.961938f,   0.000000f,//154
      0.162460f,  -0.951057f,  -0.262866f,//155
      -0.273267f,  -0.961938f,   0.000000f,//156
      -0.162460f,  -0.951057f,  -0.262866f,//157
      0.000000f,  -0.850651f,  -0.525731f,//158
      -0.162460f,  -0.951057f,   0.262866f,//159
      0.162460f,  -0.951057f,   0.262866f,//160
      0.000000f,  -0.850651f,   0.525731f//161
    };

    catom_vertexBuffer.allocate(v, 486 * sizeof(float));

    catom_indexBuffer = QOpenGLBuffer(QOpenGLBuffer::IndexBuffer); // Mind: use 'IndexBuffer' here
    catom_indexBuffer.create();
    catom_indexBuffer.setUsagePattern(QOpenGLBuffer::StaticDraw);
    if (!catom_indexBuffer.bind()) {printf("I was unable to bind atom_indexBuffer!\n");}
    catom_indexBuffer.allocate( 960 * sizeof(GLuint) );
    catom_indexBuffer.write(0, idx2, 960* sizeof(GLuint));
    catom_index_size = 960;


    if (!catom_program) catom_program = new QOpenGLShaderProgram(this);
    else catom_program->removeAllShaders();

    //printf("%p %d\n",atom_program, atom_program->programId());

    bool result = catom_program->addCacheableShaderFromSourceFile( QOpenGLShader::Vertex, ":/shaders/catom.vert");
    //printf("%d\n",__LINE__);
    if ( !result ) qWarning() << catom_program->log();
    result = catom_program->addCacheableShaderFromSourceFile( QOpenGLShader::Fragment, ":/shaders/catom.frag");

    if ( !result ) qWarning() << catom_program->log();
    result = catom_program->link();
    if ( !result ) qWarning() << catom_program->log();

    if ( !catom_program->bind() )    {
        qWarning() << "Could not bind shader program to context";
        return;
    }
    //printf("!!! %d !!!\n",shaderInfo);
    programInfo(catom_program,"atom");
    GLfloat acv[109*3];
    for (int i=0;i<109;i++) {
        acv[3*i]=mol->atomColor(i,false).redF();
        acv[3*i+1]=mol->atomColor(i,false).greenF();
        acv[3*i+2]=mol->atomColor(i,false).blueF();
    }
    GLfloat arv[109];
    for (int i=0;i<109;i++) {
        arv[i]=static_cast<GLfloat>(mol->arad[i]);
    }

    atom_program->setUniformValueArray("atomColors",acv, 109,3);
    atom_program->setUniformValueArray("arad",arv, 109,1);

    atom_program->setUniformValue("pmv", pmv);
    /*for (int i = 0; i < atoms.size(); i++){
        qDebug()<<pmv.map(QVector3D(atoms.at(i).pos.x-sumse.x,atoms.at(i).pos.y-sumse.y,atoms.at(i).pos.z-sumse.z));
    }// */

    //printf("%d\n",__LINE__);
    atom_program->enableAttributeArray(0);
    atom_program->enableAttributeArray(1);
    atom_program->enableAttributeArray(2);
    atom_program->enableAttributeArray(3);
    atom_program->enableAttributeArray(4);
    atom_program->enableAttributeArray(5);
    //printf("%d\n",__LINE__);
    int stride = 6 * 4 * sizeof(float);
    atom_program->setAttributeBuffer(0, GL_FLOAT, 0, 4, stride);
    atom_program->setAttributeBuffer(1, GL_FLOAT, sizeof(float)*4  , 4, stride);
    atom_program->setAttributeBuffer(2, GL_FLOAT, sizeof(float)*8  , 4, stride);
    atom_program->setAttributeBuffer(3, GL_FLOAT, sizeof(float)*12 , 4, stride);
    atom_program->setAttributeBuffer(4, GL_FLOAT, sizeof(float)*16 , 4, stride);
    atom_program->setAttributeBuffer(5, GL_FLOAT, sizeof(float)*20 , 4, stride);// 20*sizeof(float)

    atom_program->release();
    atom_vao.release();
    atom_indexBuffer.release();
    atom_vertexBuffer.release();
    atom_vertexBuffer.destroy();
    atom_indexBuffer.destroy();
}
void PlayOpenGL::makeAtoms(const CEnvironment &atoms){
    /**
     * @brief this the initializer of a (crazy) idea of shader program.
     * @param atoms is a QList of MyAtoms
     * the idea is to construct atoms based on an icosahedron geometry and pass atom properties via 6 vec4 attributes.
     * from an icosahedron it creates
     * - an icosahedron
     * - a ball
     * - an ellipsoid
     * - a dodecahedron
     * - a cube
     * - a triacontahedron
     * - intersecting planes for adp
     **/
    //printf("makeAtoms\n");
    rotze = (!isMainWindow)?0:(rotze>=atoms.size())?-1:rotze;
    //printf("makeAtoms rotation center set to: %d\n",rotze);
    makeCurrent();
    GLenum err = GL_NO_ERROR;
    while((err = glGetError()) != GL_NO_ERROR)
    {
      printf("before makeAtoms %s error %X\n", parent()->objectName().toStdString().c_str(),err);
      //printf("%s\n",(char*)gluErrorString(err));
    }
    atom_vao.release();
    if (atom_vao.isCreated()) {
        atom_vao.release();
        atom_vao.destroy();
        atom_vertexBuffer.destroy();
        atom_indexBuffer.destroy();
        atom_program->release();
        atom_program->removeAllShaders();
    }
    atom_vao.create();
    atom_vao.bind();
    //glEnable(GL_PRIMITIVE_RESTART_FIXED_INDEX);
    atom_vertexBuffer.create();
    atom_vertexBuffer.setUsagePattern( QOpenGLBuffer::StaticDraw );
    if (!atom_vertexBuffer.bind()) {printf("I was unable to bind atom_vertexBuffer.\n");}
    //glDisable(GL_BLEND);
    //printf("makeAtoms\n");

    int na = atoms.size();
  //  the Atoms = atoms;

    makeLabels();
    int zz=0;
    sumse=V3(0,0,0);
    for (int i = 0; i < atoms.size(); i++){
      if ((!atoms.at(i).hidden)) {//(mol->showatoms.at(i).an>-1)&&
        sumse += atoms[i].pos;
        zz++;
      }
    }
    if (zz) sumse*=1.0/zz;
    const float phi = (1.0f + sqrtf(5.0f)) / 2.0f;
    const float du = 1.0f / sqrtf(phi * phi + 1.0f);
    const float dv = phi * du;
    //printf("phi = %f du = %f dv = %f\n",phi, du, dv);
    const float eckn[] ={   0.0f,  dv,  du,
                            0.0f,  dv, -du,
                            0.0f, -dv,  du,
                            0.0f, -dv, -du,
                            du,  0.0f,  dv,
                            -du, 0.0f,  dv,
                            du,  0.0f, -dv,
                            -du, 0.0f, -dv,
                            dv,    du, 0.0f,
                            dv,   -du, 0.0f,
                            -dv,   du, 0.0f,
                            -dv,  -du, 0.0f};
    const GLuint triangle[] = {
          1, 0, 8,
          4, 0, 5,
          5, 0, 10,
          8, 0, 4,
         10, 0, 1,
          6, 1, 8,
          7, 1, 6,
         10, 1, 7,
          3, 2, 11,
          4, 2, 9,
          5, 2, 4,
          9, 2, 3,
         11, 2, 5,
          6, 3, 7,
          7, 3, 11,
          9, 3, 6,
          8, 4, 9,
         11, 5, 10,
          9, 6, 8,
         10, 7, 11};//*/
    /*const GLuint triangle_strips[] = {
          1,  0, 8,  4, 9, 2, 3, 11, 7, 10, 1, 0, 0xFFFFFFFF,
          3,  9, 6,  8, 1, 0xFFFFFFFF,
          2, 11, 5, 10, 0, 0xFFFFFFFF,
          1,  7, 6,  3, 0xFFFFFFFF, //3, 7, 6, 1, 0xFFFF,
          2,  4, 5,  0, 0xFFFFFFFF//0, 5, 4, 2, 0xFFFF,
    };//, 10, 5, 11, 2}; */
    //0xFFFF
    QVector<float> stuff;
    bool wehaveh=false;
    stuff.reserve(na*12*24);
    for (int i = 0; i < na; i++){
        bool isd=((atoms.at(i).an==0)&&(atoms.at(i).Label[0]=='D'));
        int style = (atoms.at(i).an<0)? (atoms.at(i).hidden)?512:0:
                mol->AtomStyle[atoms.at(i).an]
                |((atoms.at(i).hidden)?512:0)
                |((isd)?1024:0)
                |(((atoms.at(i).isIso))?2048:0);
        if (atoms.at(i).Label.contains("noADP"))style |=ATOM_STYLE_NOADP;
        if ((atoms.at(i).an==0)&&((style&512)!=512)) {
            //printf("%d %d ein h in der suppe %d %X %d %d\n",atoms.at(i).an, i, style, style, style&512, style&2048);
            wehaveh=true;
        }
        V3 ev=V3(0,0,0);
        double *arr = mol->jacobi(atoms.at(i).uc, ev);
        for (int j = 0; j < 12; j++){
        stuff.append(atoms.at(i).pos.x);//the center
        stuff.append(atoms.at(i).pos.y);
        stuff.append(atoms.at(i).pos.z);
        stuff.append(static_cast<float>(atoms.at(i).an));

        stuff.append(eckn[3*j]);// an icosahedron corner
        stuff.append(eckn[3*j+1]);
        stuff.append(eckn[3*j+2]);
        stuff.append(static_cast<float>(j));

        stuff.append(static_cast<float>(arr[0]));
        stuff.append(static_cast<float>(arr[1]));
        stuff.append(static_cast<float>(arr[2]));
        stuff.append(static_cast<float>(arr[3]));

        stuff.append(ev.x);
        stuff.append(ev.y);
        stuff.append(ev.z);
        stuff.append(static_cast<float>(style));

        stuff.append(static_cast<float>((atoms.at(i).an==-42)?atoms.at(i).sof:atoms.at(i).peakHeight));
        stuff.append(static_cast<float>(qMax(0, atoms.at(i).symmGroup)));
        stuff.append(static_cast<float>(atoms.at(i).part));
        stuff.append(static_cast<float>(atoms.at(i).molindex));

        stuff.append(static_cast<float>(i));
        stuff.append(static_cast<float>(atoms.at(i).auidx));
        stuff.append(static_cast<float>(atoms.at(i).resiNr));
        stuff.append(0.0f);

        }
    }
    hideHydrogen->setVisible(wehaveh);
    atom_vertexBuffer.allocate(stuff.data(),stuff.size()*sizeof(float));
    QVector<GLuint> indexes;
    uint una = static_cast<uint>(na);
    for (uint i = 0; i < una; i++){
        for (uint j = 0; j < 60; j++){
            indexes.append(triangle[j]+12*i);//_strips
        }
    }

    atom_indexBuffer = QOpenGLBuffer(QOpenGLBuffer::IndexBuffer); // Mind: use 'IndexBuffer' here
    atom_indexBuffer.create();
    atom_indexBuffer.setUsagePattern(QOpenGLBuffer::StaticDraw);
    if (!atom_indexBuffer.bind()) {printf("I was unable to bind atom_indexBuffer!\n");}
    atom_indexBuffer.allocate( indexes.size() * sizeof(GLuint) );
    atom_indexBuffer.write(0, indexes.data(), indexes.size()* sizeof(GLuint));
    atom_index_size = indexes.size();
    //printf("%d %d ?=? %d na=%d\n",__LINE__, indexes.size() * sizeof(GLuint) , atom_index_size, na);
    if (!atom_program) atom_program = new QOpenGLShaderProgram(this);
    else atom_program->removeAllShaders();

    //printf("%p %d\n",atom_program, atom_program->programId());

    bool result = atom_program->addCacheableShaderFromSourceFile( QOpenGLShader::Vertex, ":/shaders/atom.vert");
    //printf("%d\n",__LINE__);
    if ( !result ) qWarning() << atom_program->log();
    result = atom_program->addCacheableShaderFromSourceFile( QOpenGLShader::Geometry, ":/shaders/atom.geom");
    //printf("%d\n",__LINE__);
    if ( !result ) qWarning() << atom_program->log();
    result = atom_program->addCacheableShaderFromSourceFile( QOpenGLShader::Fragment, ":/shaders/atom.frag");

    if ( !result ) qWarning() << atom_program->log();
    result = atom_program->link();
    if ( !result ) qWarning() << atom_program->log();
    \
    if ( !atom_program->bind() )    {
        qWarning() << "Could not bind shader program to context";
        return;
    }
    //printf("!!! %d !!!\n",shaderInfo);
    programInfo(atom_program,"atom");
    GLfloat acv[109*3];
    for (int i=0;i<109;i++) {
        acv[3*i]=mol->atomColor(i,false).redF();
        acv[3*i+1]=mol->atomColor(i,false).greenF();
        acv[3*i+2]=mol->atomColor(i,false).blueF();
    }
    GLfloat arv[109];
    for (int i=0;i<109;i++) {
        arv[i]=static_cast<GLfloat>(mol->arad[i]);
    }

    atom_program->setUniformValueArray("atomColors",acv, 109,3);
    atom_program->setUniformValueArray("arad",arv, 109,1);

    atom_program->setUniformValue("pmv", pmv);
    /*for (int i = 0; i < atoms.size(); i++){
        qDebug()<<pmv.map(QVector3D(atoms.at(i).pos.x-sumse.x,atoms.at(i).pos.y-sumse.y,atoms.at(i).pos.z-sumse.z));
    }// */

    //printf("%d\n",__LINE__);
    atom_program->enableAttributeArray(0);
    atom_program->enableAttributeArray(1);
    atom_program->enableAttributeArray(2);
    atom_program->enableAttributeArray(3);
    atom_program->enableAttributeArray(4);
    atom_program->enableAttributeArray(5);
    //printf("%d\n",__LINE__);
    int stride = 6 * 4 * sizeof(float);
    atom_program->setAttributeBuffer(0, GL_FLOAT, 0, 4, stride);
    atom_program->setAttributeBuffer(1, GL_FLOAT, sizeof(float)*4  , 4, stride);
    atom_program->setAttributeBuffer(2, GL_FLOAT, sizeof(float)*8  , 4, stride);
    atom_program->setAttributeBuffer(3, GL_FLOAT, sizeof(float)*12 , 4, stride);
    atom_program->setAttributeBuffer(4, GL_FLOAT, sizeof(float)*16 , 4, stride);
    atom_program->setAttributeBuffer(5, GL_FLOAT, sizeof(float)*20 , 4, stride);// 20*sizeof(float)

    atom_program->release();
    atom_vao.release();
    atom_indexBuffer.release();
    atom_vertexBuffer.release();
    atom_vertexBuffer.destroy();
    atom_indexBuffer.destroy();
    while((err = glGetError()) != GL_NO_ERROR)
    {
      printf("after1 makeAtoms %s error %X\n", parent()->objectName().toStdString().c_str(),err);
      //printf("%s\n",(char*)gluErrorString(err));
    }
    //double va = viewAngle;
    //setViewAngle(29.0);

    pushRotStat();
    popRotStat();
    makeSelectedAtoms();
    updateSceenAtoms();
    makeLegendAtoms();
    //setViewAngle(va);
    update();
    while((err = glGetError()) != GL_NO_ERROR)
    {
      printf("after2 makeAtoms %s error %X\n", parent()->objectName().toStdString().c_str(),err);
      //printf("%s\n",(char*)gluErrorString(err));
    }
}


void PlayOpenGL::pushRotStat(){
    double ll=L;
    double dim=mol->dimension(mol->showatoms);        
    L = (isOrtho)?2/dim: viewAngle * 100.0 / (dim *29.0);
    Matrix m = Matrix(
                mvmat(0,0),
                mvmat(0,1),
                mvmat(0,2),
                mvmat(1,0),
                mvmat(1,1),
                mvmat(1,2),
                mvmat(2,0),
                mvmat(2,1),
                mvmat(2,2));
    double det = determinant(m);
    //printf("Adie Determinante der Drehmatrix ist: %g %g L = %g ll = %g  %f\n", det, pow(det,1.0/3.0), L, ll, L/ll);
    ll=L/pow(det,1.0/3.0);
    if (!inRenameMode) mvmat.scale(ll, ll, ll);
    pmv = pmat*mvmat;
    nm = mvmat.normalMatrix();
    eye = mvmat.inverted()*QVector4D(0,0,0,1);
}

void PlayOpenGL::popRotStat(){
    return;
}

void PlayOpenGL::makeBonds(const CEnvironment &atoms, const Connection &bonds, const Connection &lbonds, Connection &hbonds){
    //printf("makeBonds\n");
    makeCurrent();
    bond_vao.release();
    if (bond_vao.isCreated()) {
        bond_vao.release();
        bond_vao.destroy();
        bond_vertexBuffer.destroy();
        bond_indexBuffer.destroy();
    }
    bond_vao.create();
    bond_vao.bind();
    bond_vertexBuffer.create();
    bond_vertexBuffer.setUsagePattern( QOpenGLBuffer::StaticDraw );
    //glDisable(GL_BLEND);
    if (!bond_vertexBuffer.bind()) {printf("m_vertexBufferObject2 I was unable to bind!\n");}
    GLenum err = GL_NO_ERROR;
        while((err = glGetError()) != GL_NO_ERROR)
        {
          printf("%s paintGL error %X %d\n", parent()->objectName().toStdString().c_str(), err, __LINE__);
          //printf("%s\n",(char*)gluErrorString(err));
        }
    int zz=0;
    sumse=V3(0,0,0);
    for (int i=0;i<atoms.size();i++){
      if ((!atoms.at(i).hidden)) {//(mol->showatoms.at(i).an>-1)&&
        sumse+=atoms[i].pos;
        zz++;
      }
    }
    if (zz) sumse*=1.0/zz;
    QVector<float> pos;
    //QVector<float> col;
    QVector<float> an;
    QVector<float> styles;
    QVector<float> peakHeights;
    QVector<float> symmGroups;
    mol->h_bonds3(bonds,atoms);
    hbonds=mol->theH_Bonds;
    QVector<GLuint> nbonds;
    for (int i=0; i<atoms.size(); i++){
        pos.append(atoms.at(i).pos.x);
        pos.append(atoms.at(i).pos.y);
        pos.append(atoms.at(i).pos.z);
        bool isd=((atoms.at(i).an==0)&&(atoms.at(i).Label[0]=='D'));
        //col.append(chgl->mol->atomColor(chgl->mol->showatoms.at(i).an,isd).redF());
        //col.append(chgl->mol->atomColor(chgl->mol->showatoms.at(i).an,isd).greenF());
        //col.append(chgl->mol->atomColor(chgl->mol->showatoms.at(i).an,isd).blueF());
        an.append(static_cast<float>(atoms.at(i).an));
        //styles.append(7);
        peakHeights.append((atoms.at(i).an<0)?atoms.at(i).peakHeight:atoms.at(i).part);
        symmGroups.append(qMax(0, atoms.at(i).symmGroup));
        if (atoms.at(i).an<0) styles.append((atoms.at(i).hidden)?512:0);
        else styles.append(static_cast<float>(mol->AtomStyle[atoms.at(i).an]
                |((atoms.at(i).hidden)?512:0)
                |((isd)?1024:0)
                |(((atoms.at(i).symmGroup)&&(atoms.at(i).part<0))?2048:0)));
    }
    for (int i=0; i<bonds.size(); i++){
        nbonds.append(bonds.at(i).a1);
        nbonds.append(bonds.at(i).a2);
    }
    for (int i=0; i<lbonds.size(); i++){
        nbonds.append(lbonds.at(i).a1);
        nbonds.append(lbonds.at(i).a2);
    }
    for (int i=0; i<hbonds.size(); i++){
        nbonds.append(hbonds.at(i).a1);
        nbonds.append(hbonds.at(i).a2);
    }
    printf("h_bonds %d q-peak-bonds %d\n", hbonds.size(),lbonds.size());
    bond_vertexBuffer.allocate(atoms.size() * 7 * sizeof(float));
    bond_vertexBuffer.write(0, (void*)pos.data(), atoms.size() * 3 * sizeof(float));
    bond_vertexBuffer.write(atoms.size() * 3 * sizeof(float), (void*)an.data(), atoms.size() * sizeof(float));
    bond_vertexBuffer.write(atoms.size() * 4 * sizeof(float), (void*)styles.data(), atoms.size() * sizeof(float));
    bond_vertexBuffer.write(atoms.size() * 5 * sizeof(float), (void*)peakHeights.data(), atoms.size() * sizeof(float));
    bond_vertexBuffer.write(atoms.size() * 6 * sizeof(float), (void*)symmGroups.data(), atoms.size() * sizeof(float));

    nbondx2 = nbonds.size();
    //printf("nbondx2 = %d\n", nbondx2);
    // create a new buffer for the indexes
    bond_indexBuffer = QOpenGLBuffer(QOpenGLBuffer::IndexBuffer); // Mind: use 'IndexBuffer' here
    bond_indexBuffer.create();
    bond_indexBuffer.setUsagePattern(QOpenGLBuffer::StaticDraw);
    if (!bond_indexBuffer.bind()) {printf("bond_indexBuffer I was unable to bind!\n");}
    bond_indexBuffer.allocate(nbonds.data(), nbonds.size() * sizeof(GLuint) );
    if (!bond_program) bond_program = new QOpenGLShaderProgram(this);
    else bond_program->removeAllShaders();

    //printf("bond_program: %p id = %d\n",bond_program, bond_program->programId());
    bool result2 = bond_program->addCacheableShaderFromSourceFile( QOpenGLShader::Vertex, ":/shaders/bond.vert");
    if ( !result2 ) qWarning() << bond_program->log();
    result2 = bond_program->addCacheableShaderFromSourceFile( QOpenGLShader::Geometry, ":/shaders/bond.geom");
    if ( !result2 ) qWarning() << bond_program->log();
    result2 = bond_program->addCacheableShaderFromSourceFile( QOpenGLShader::Fragment, ":/shaders/bond.frag");
    if ( !result2 ) qWarning() << bond_program->log();
    result2 = bond_program->link();

    programInfo(bond_program,"bond");
    if ( !result2 ) qWarning() << bond_program->log();
    if ( !bond_program->bind() )    {
        qWarning() << "2Could not bind shader program to context";
        return;
    }
    GLfloat acv[109*3];
    for (int i=0;i<109;i++) {
        acv[3*i]=mol->atomColor(i,false).redF();
        acv[3*i+1]=mol->atomColor(i,false).greenF();
        acv[3*i+2]=mol->atomColor(i,false).blueF();
    }
    bond_program->setUniformValue("radius", static_cast<float>(mol->bondStrength));
    bond_program->setUniformValue("segments", mol->LOD);
    bond_program->setUniformValue("lightPos", QVector3D(100.0, 100.0, 100.0));
    bond_program->setUniformValueArray("atomColors",acv, 109,3);

    bond_program->setUniformValue("pmv", pmv);
    int stride = 0;//6*sizeof(float);
    bond_program->setAttributeBuffer( "VertexPosition", GL_FLOAT, 0, 3, stride );
    bond_program->enableAttributeArray( "VertexPosition" );
    //bond_program->setAttributeBuffer( "VertexColor", GL_FLOAT, sizeof(float)*atoms.size()*3, 3, stride );
    bond_program->setAttributeBuffer( "atomicnumbers", GL_FLOAT, sizeof(float)*atoms.size()*3, 1, stride );
    bond_program->enableAttributeArray( "atomicnumbers" );
    bond_program->setAttributeBuffer( "Styles", GL_FLOAT, sizeof(float)*atoms.size()*4, 1, stride );
    bond_program->enableAttributeArray( "Styles" );
    bond_program->setAttributeBuffer( "peakHeights", GL_FLOAT, sizeof(float)*atoms.size()*5, 1, stride );
    bond_program->enableAttributeArray( "peakHeights" );
    bond_program->setAttributeBuffer( "symmGroup", GL_FLOAT, sizeof(float)*atoms.size()*6, 1, stride );
    bond_program->enableAttributeArray( "symmGroup" );

    bond_program->release();
    bond_vao.release();
    bond_indexBuffer.release();
    bond_vertexBuffer.release();
    bond_vertexBuffer.destroy();
    bond_indexBuffer.destroy();
}

QString PlayOpenGL::glTypeInt2String(int ityp){
    QString s;
    /*

#define GL_FLOAT_VEC2                     0x8B50
#define GL_FLOAT_VEC3                     0x8B51
#define GL_FLOAT_VEC4                     0x8B52
#define GL_INT_VEC2                       0x8B53
#define GL_INT_VEC3                       0x8B54
#define GL_INT_VEC4                       0x8B55
#define GL_BOOL                           0x8B56
#define GL_BOOL_VEC2                      0x8B57
#define GL_BOOL_VEC3                      0x8B58
#define GL_BOOL_VEC4                      0x8B59
#define GL_FLOAT_MAT2                     0x8B5A
#define GL_FLOAT_MAT3                     0x8B5B
#define GL_FLOAT_MAT4                     0x8B5C

#define GL_BYTE           0x1400
#define GL_UNSIGNED_BYTE  0x1401
#define GL_SHORT          0x1402
#define GL_UNSIGNED_SHORT 0x1403
#define GL_INT            0x1404
#define GL_UNSIGNED_INT   0x1405
#define GL_FLOAT          0x1406
#define GL_2_BYTES        0x1407
#define GL_3_BYTES        0x1408
#define GL_4_BYTES        0x1409
#define GL_DOUBLE         0x140A

*/
    switch (ityp){
    case 0x8B50: s = "GL_FLOAT_VEC2"; break;
    case 0x8B51: s = "GL_FLOAT_VEC3"; break;
    case 0x8B52: s = "GL_FLOAT_VEC4"; break;
    case 0x8B53: s = "GL_INT_VEC2"; break;
    case 0x8B54: s = "GL_INT_VEC3"; break;
    case 0x8B55: s = "GL_INT_VEC4"; break;
    case 0x8B56: s = "GL_BOOL"; break;
    case 0x8B57: s = "GL_BOOL_VEC2"; break;
    case 0x8B58: s = "GL_BOOL_VEC3"; break;
    case 0x8B59: s = "GL_BOOL_VEC4"; break;
    case 0x8B5A: s = "GL_FLOAT_MAT2"; break;
    case 0x8B5B: s = "GL_FLOAT_MAT3"; break;
    case 0x8B5C: s = "GL_FLOAT_MAT4"; break;
    case 0x1400: s = "GL_BYTE"; break;
    case 0x1401: s = "GL_UNSIGNED_BYTE"; break;
    case 0x1402: s = "GL_SHORT"; break;
    case 0x1403: s = "GL_UNSIGNED_SHORT"; break;
    case 0x1404: s = "GL_INT"; break;
    case 0x1405: s = "GL_UNSIGNED_INT"; break;
    case 0x1406: s = "GL_FLOAT"; break;
    case 0x1407: s = "GL_2_BYTES"; break;
    case 0x1408: s = "GL_3_BYTES"; break;
    case 0x1409: s = "GL_4_BYTES"; break;
    case 0x140A: s = "GL_DOUBLE"; break;
    //case : s = ""; break;
    //case : s = ""; break;
    default: s = "no clue?";
    }
    return s;
}

void PlayOpenGL::initializeGL(){
    if (parent()){
    isMainWindow = (parent()->objectName().startsWith("The Main Window"));
    printf("parent not null\n");
    }
    printf("%d initializeGL parent: %s\n", isMainWindow, parent()->objectName().toStdString().c_str());
    makeCurrent();
    initializeOpenGLFunctions();
    // During init, enable debug output
    //glEnable              ( GL_DEBUG_OUTPUT );
    //glDebugMessageCallback( MessageCallback, 0 );

    const QOpenGLContext *context = this->context();
    QSurface *surf = this->context()->surface();
    printf("Widget OpenGl: %d.%d\n",format().majorVersion(),format().minorVersion());
    printf("Context valid: %d\n",context->isValid());
    printf("Really used OpenGl: %d.%d\n",context->format().majorVersion(),context->format().minorVersion());
    GLenum err = GL_NO_ERROR;
    while((err = glGetError()) != GL_NO_ERROR)
    {
      printf("test3525 %s error %X\n", parent()->objectName().toStdString().c_str(),err);
      //printf("%s\n",(char*)gluErrorString(err));
    }
    GLint nrAttributes;
    glGetIntegerv(GL_MAX_VERTEX_ATTRIBS, &nrAttributes);
    printf("GL_MAX_VERTEX_ATTRIBS =%d\n",nrAttributes);
    glGetIntegerv(GL_MAX_VERTEX_UNIFORM_COMPONENTS, &nrAttributes);
    printf("GL_MAX_VERTEX_UNIFORM_COMPONENTS=%d\n",nrAttributes);
    glGetIntegerv(GL_MAX_FRAGMENT_UNIFORM_COMPONENTS,  &nrAttributes);
    printf("GL_MAX_FRAGMENT_UNIFORM_COMPONENTS=%d\n",nrAttributes);
    //glGetIntegerv(GL_MAX_VARYING_FLOATS, &nrAttributes);
    //printf("GL_MAX_VARYING_FLOATS=%d\n",nrAttributes);
    //glGetIntegerv(GL_MAX_VARYING_COMPONENTS, &nrAttributes);
    //printf("GL_MAX_VARYING_COMPONENTS=%d\n",nrAttributes);
    err = GL_NO_ERROR;
    while((err = glGetError()) != GL_NO_ERROR)
    {
      printf("before gl_blend %s error %X\n", parent()->objectName().toStdString().c_str(),err);
      //printf("%s\n",(char*)gluErrorString(err));
    }
    //glEnable(GL_PRIMITIVE_RESTART_FIXED_INDEX);
    glEnable(GL_BLEND);
    //glDisable(GL_BLEND);
    glBlendFunc ( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA ) ;
    //glClearColor(0.4f,0.4f,0.4f,1.0f);
    //glClearColor(0.f,0.f,0.f,1.0f);
    glClearColor(1.f,1.f,1.f,1.0f);
    glEnable(GL_DEPTH_TEST );
    glEnable(GL_LINE_SMOOTH);
    glHint(GL_LINE_SMOOTH_HINT,GL_NICEST);
    //glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
    //GLenum err = GL_NO_ERROR;
    err=GL_NO_ERROR;
    while((err = glGetError()) != GL_NO_ERROR)
    {
      printf("after GL_PERSPECTIVE_CORRECTION_HINT %s error %X\n", parent()->objectName().toStdString().c_str(),err);
      //printf("%s\n",(char*)gluErrorString(err));
    }
#if not defined (Q_OS_MAC)
    setMouseTracking(true);
#endif
    float ratio = width() / static_cast<float>(height());
    pmat.setToIdentity();
    printf("%pmol viewAngle = %f\n",mol,viewAngle);
    if (viewAngle<0.1) {
        //printf("ident %d\n",__LINE__);
        L=(mol->showatoms.isEmpty())?2.0:2.0/mol->dimension(mol->showatoms);
        //printf("ident %d\n",__LINE__);
        mvmat.setToIdentity();
        mvmat.lookAt(QVector3D(0.0, 200, 50) , QVector3D(  0.0, 0.0, 0.0), QVector3D(0.0, -100, 400 ));
        mvmat.scale(L,L,L);
        pmat.ortho(-ratio, ratio, -1.0f, 1.0f, -5.0f, 8000.0f);
        previousViewAngle = qMax(viewAngle, 29.0);
        viewAngle=0.01;
        isOrtho=true;
        if (toggleOrthoView!=nullptr)toggleOrthoView->setChecked(true);
        printf("ORTHO\n");
    }else{
        printf("PERSPECTIVE %f\n", viewAngle);
        pmat.perspective(viewAngle, ratio, -5.0f, 8000.0f );
        isOrtho=false;
        if (toggleOrthoView!=nullptr) toggleOrthoView->setChecked(false);
        L=100.0;
        //printf("ident %d\n",__LINE__);
        mvmat.setToIdentity();
        mvmat.lookAt(QVector3D(0.0, 200, 50) , QVector3D(  0.0, 0.0, 0.0), QVector3D(0.0, -100, 400 ));
        mvmat.scale(L,L,L);
    }
    pmv = pmat*mvmat;
    nm = mvmat.normalMatrix();
    eye = mvmat.inverted()*QVector4D(0,0,0,1);
    makeBackGround();
    bool cu= this->context()->makeCurrent(surf);

    printf("Context valid: %d v %d widget %d window %d  current %d\n",context->isValid(), this->context()->isValid(), context->isWidgetType(), context->isWindowType(),cu);
    printf("initialized \n");
    emit initialized();
    update();
    // */
}

void PlayOpenGL::resizeGL(int width, int height){
  //printf("rezi %d %d\n",width,height);
  retinafktr=devicePixelRatio();
  glViewport(0, 0, width*retinafktr, qMax(height*retinafktr, 1.0));
  pmat.setToIdentity();
  float ratio = width / static_cast<float>(height);
  if (isOrtho) pmat.ortho(-ratio, ratio, -1.0f, 1.0f, -5.0f, 8000.0f);
  else pmat.perspective(viewAngle, ratio, 5.0f, 8000.0f );

  pmv = pmat*mvmat;
  nm = mvmat.normalMatrix();
  eye = mvmat.inverted()*QVector4D(0,0,0,1);
  updateSceenAtoms();
  update();
}

inline void PlayOpenGL::__RotateCS( float c, float s, float& X, float& Y ) {
  float T = X;
  X = c*X - s*Y;
  Y = s*T + c*Y;
}

inline void PlayOpenGL::__RotateCS( double c, double s, double& X, double& Y ) {
  double T = X;
  X = c*X - s*Y;
  Y = s*T + c*Y;
}

void PlayOpenGL::glRotateMat( QMatrix4x4 &mat, const float dang, const float x , const float y, const float z ) {
  float s = z;
  s = sinf(dang*M_PIf/180);
  const float c = cosf(dang*M_PIf/180);
  if( x!=0.0f ){
    __RotateCS( c, s, mat(1,0), mat(2,0) );
    __RotateCS( c, s, mat(1,1), mat(2,1) );
    __RotateCS( c, s, mat(1,2), mat(2,2) );
    //    printf("x\n");
  }else if( y!=0.0f ){
    __RotateCS( c, s, mat(2,0), mat(0,0) );
    __RotateCS( c, s, mat(2,1), mat(0,1) );
    __RotateCS( c, s, mat(2,2), mat(0,2) );
    //    printf("y\n");
  }else{
    __RotateCS( c, s, mat(0,0), mat(1,0) );
    __RotateCS( c, s, mat(0,1), mat(1,1) );
    __RotateCS( c, s, mat(0,2), mat(1,2) );
    //    printf("z\n");
  }
}

void PlayOpenGL::glRotateMat( Matrix &mat, const float dang, const double x , const double y, const double z ) {
  double s = z;
  s = sin(dang*M_PI/180);
  const double c = cos(dang*M_PI/180);
  if( x!=0.0f ){
    __RotateCS( c, s, mat.m21, mat.m31 );
    __RotateCS( c, s, mat.m22, mat.m32 );
    __RotateCS( c, s, mat.m23, mat.m33 );
    //    printf("x\n");
  }else if( y!=0.0f ){
    __RotateCS( c, s, mat.m31, mat.m11 );
    __RotateCS( c, s, mat.m32, mat.m12 );
    __RotateCS( c, s, mat.m33, mat.m13 );
    //    printf("y\n");
  }else{
    __RotateCS( c, s, mat.m11, mat.m21 );
    __RotateCS( c, s, mat.m12, mat.m22 );
    __RotateCS( c, s, mat.m13, mat.m23 );
    //    printf("z\n");
  }
}

void PlayOpenGL::setLabelSize(int s){
myFont.setPointSize(s);
makeLabels();
update();
}

void PlayOpenGL::wheelEvent(QWheelEvent *event){

#if (QT_VERSION>0x050000)
  int numDegrees = (event->angleDelta().y()==0)?event->angleDelta().x():event->angleDelta().y();
#else
  int numDegrees = event->delta();
#endif
  int numSteps = numDegrees / 120;
  if (event->modifiers()==Qt::NoModifier){
    int d = myFont.pointSize();
    d = (d+numSteps>4)?d+numSteps:d;
    d = qMax(d,7);
    myFont.setPointSize(d);
    makeLabels();
    update();
  }
  else
  if (event->modifiers()==Qt::ControlModifier){
    emit diffscroll(numSteps,1);
  }
  else
  if (event->modifiers()==Qt::ShiftModifier){
    emit diffscroll(numSteps,0);
  }
  else
  if (event->modifiers()==(Qt::AltModifier|Qt::ShiftModifier)){
    double va=qMax(viewAngle+0.1*numSteps,0.01);
    printf("va %f %f %d event->angleDelta().y() %d\n",va,0.1*numSteps,numSteps,event->angleDelta().x());
    setViewAngle(va);
  }

}

void PlayOpenGL::mouseMoveEvent(QMouseEvent *event){
    //printf("mouseMoveEvent %d %d %p %p %p\n",mol->showatoms.size(),screenAtoms.size(),sfacMenu,selSfacMenu,menu);
  double x = event->pos().x();
  double y = event->pos().y();
  double nahda=pickradius,da=0;
  rectangle=false;
  int nahdai=-1;
  bool changed=false;
  scrx=event->x();
  scry=event->y();
  for (int j=0; j<mol->showatoms.size();j++){
    if (mol->showatoms.at(j).hidden) continue;
    if ((mol->showatoms.at(j).an==-1)&&(mol->showatoms.at(j).peakHeight<qcutoff)) continue;
    da=(((screenAtoms.at(j).x()-event->x())*( screenAtoms.at(j).x()-event->x()))+
        ((screenAtoms.at(j).y()-event->y())*( screenAtoms.at(j).y()-event->y())));
    nahdai=(da<nahda)?j:nahdai;
    nahda=qMin(nahda,da);
  }
  if ((!event->buttons())) {//(mouseOverInteraction)&&
      if (inFocus!=nahdai) changed=true;
      inFocus=nahdai;
      if (inFocus==-1) {
        emit qpfoci(-1.0);
        emit message("");
      } else {
        emit message(mol->showatoms.at(inFocus).Label);
        if ((mol->showatoms.at(inFocus).an<0)) emit qpfoci(mol->showatoms.at(inFocus).peakHeight);
        else emit qpfoci(-1.0);
    }

    if (changed) {
      // printf("MouseMoveEvent changed %d %d %d\n",nahdai,mol->showatoms.size(),imFokus);fflush(stdout);
      update();
    }
  }
  GLfloat dx = GLfloat( event->pos().x() - moux) / width();
  GLfloat dy = GLfloat( event->pos().y() - mouy) / height();
  if((event->buttons() & Qt::RightButton)) if (event->modifiers()==Qt::ShiftModifier){
      double ddy = ((invertMouseZoom!=nullptr)&&(invertMouseZoom->isChecked()))?(-dy):(dy);
      double ll = 1.0 - ddy;
      legend_sc *= ll;
  }else{
      double ddy = ((invertMouseZoom!=nullptr)&&(invertMouseZoom->isChecked()))?(-dy):(dy);
      double ll=1.0 - ddy;
      L*=ll;
      mvmat.scale(ll,ll,ll);
      pmv = pmat*mvmat;
      nm = mvmat.normalMatrix();
      eye = mvmat.inverted()*QVector4D(0,0,0,1);
      updateSceenAtoms();
  }else if ((event->buttons() & Qt::LeftButton && (event->modifiers()==(Qt::ShiftModifier|Qt::ControlModifier)))) {
      rectangle=true;
      int minxp=qMin(scrx0,scrx);
      int minyp=qMin(scry0,scry);
      int maxxp=qMax(scrx0,scrx);
      int maxyp=qMax(scry0,scry);
      mol->selectedatoms.clear();
      printf("show%d screen%d\n",mol->showatoms.size(),screenAtoms.size());
      for (int j=0; j<screenAtoms.size();j++){
        if (mol->showatoms.at(j).hidden) continue;
        if ((screenAtoms.at(j).x()>minxp)&&
            (screenAtoms.at(j).x()<maxxp)&&
            (screenAtoms.at(j).y()>minyp)&&
            (screenAtoms.at(j).y()<maxyp)){
            /*printf("%d < %f < %d  | %d < %f < %d  j = %d %s\n",
                   minxp, screenAtoms.at(j).x(), maxxp,
                   minyp, screenAtoms.at(j).y(), maxyp,
                   j, mol->showatoms[j].Label.toStdString().c_str() );// */
            mol->selectedatoms.append(mol->showatoms[j]);
            mol->selectedatoms.last().style = j;
        }
      }
      updateBondActions();
      makeSelectedAtoms();
      update();
    } else if((event->buttons() & Qt::LeftButton)){
      if (event->modifiers()==Qt::ShiftModifier) {
          pmat.translate(3*dx*viewAngle,-3*dy*viewAngle,0);
          pmv = pmat*mvmat;
          nm = mvmat.normalMatrix();
          eye = mvmat.inverted()*QVector4D(0,0,0,1);
          updateSceenAtoms();
      }else if ((manualAx!=nullptr)&&(manualAx->isChecked())&&(event->modifiers()==Qt::AltModifier)){
              //printf("X\n");
              makeCurrent();
              GLdouble mm[16];
              glGetDoublev(GL_MODELVIEW_MATRIX,mm);
              double det=
                mm[0]*mm[5]*mm[10] - mm[8]*mm[5]*mm[2]+
                mm[1]*mm[6]*mm[8]  - mm[9]*mm[6]*mm[0]+
                mm[2]*mm[4]*mm[9]  - mm[10]*mm[4]*mm[1];
              Matrix mat=Matrix(mm[0],mm[1],mm[2],mm[4],mm[5],mm[6],mm[8],mm[9],mm[10]);
              //printf("A%g %g\n",determinant(mat),det);
              mat=mat*pow(det,-1.0/3.0);
              //printf("B%g %g\n",determinant(mat),det);

              V3 axe=Normalize(V3(axx->value(),axy->value(),axz->value()));
              axe=transponse(mat)*axe;
              double arr[4];
              arr[0]=dx*360.0;
              arr[1]=0.0;
              arr[2]=1.0;
              arr[3]=0.0;
              axe=mol->rotarb(arr)*axe;
              V3 XX = mol->rotarb(arr)*V3(1, 0, 0);
              arr[0]=dy*360.0;
              arr[1]=XX.x;
              arr[2]=XX.y;
              arr[3]=XX.z;
              axe=mol->rotarb(arr)*axe;
              axe=mat*axe;
              axx->setValue(axe.x);
              axy->setValue(axe.y);
              axz->setValue(axe.z);
              splitRotate();
          }else if ((freeRot!=nullptr)&&(freeRot->isChecked())&&(event->modifiers()==(Qt::AltModifier|Qt::ControlModifier))){
              //printf("Y\n");
              makeCurrent();
              double arr[4];
              /*
              QVector4D v4xy = QVector4D(dx*360, -dy*360, 0, 1);
              v4xy.normalize();
              QMatrix4x4 ii= mvmat;
              ii=ii.inverted().transposed();
              QVector4D v4xys = ii* v4xy;
              v4xys.normalize();
              V3 xx(v4xys.x(), v4xys.y(), v4xys.z());
              xx=Normalize(xx);// */
              fdx+=dx;
              fdy+=dy;
              Matrix worldtoscreen=transponse(Matrix(mvmat));
              double det=1.0/pow(determinant(worldtoscreen), 1.0/3.0);
              worldtoscreen *= det;
              /*
              freeRotMat = freeRotMat * worldtoscreen;
              glRotateMat(freeRotMat,dy*360.0f,1,0,0);
              glRotateMat(freeRotMat,-dx*360.0f,0,1,0);
              freeRotMat =   freeRotMat * transponse(worldtoscreen);
              */
              V3 wox(1,0,0);
              V3 woy(0,1,0);
              screenRotx = worldtoscreen * wox;
              screenRoty = worldtoscreen * woy;
              /*
              QQuaternion p(fdx * 36.0,screenRoty.x,screenRoty.y,screenRoty.z);
              QQuaternion q(fdy * 36.0,screenRotx.x,screenRotx.y,screenRotx.z);
              QQuaternion pq = QQuaternion::fromEulerAngles(0, fdx * 360.0, fdy * 360.0);
              freeRotMat = Matrix(pq.toRotationMatrix());
              //V3 qax=Normalize(V3(pq.x(),pq.y(),pq.z()));
              //printf("fdx%g,fdy%g %f (%f %f %f)\n",fdx,fdy,pq.scalar(),qax.x,qax.y,qax.z);
              //freeRotMat = mol->rotarb(pq.scalar(),qax);
              //mol->rotarb(freeRotMat, fdy*360, screenRotx);
              // */
///*
              arr[0] = dx * 360.0;
              arr[1] = screenRoty.x;
              arr[2] = screenRoty.y;
              arr[3] = screenRoty.z;
              freeRotMat = freeRotMat * mol->rotarb(arr);

              arr[0] = dy * 360.0;
              arr[1] = screenRotx.x;
              arr[2] = screenRotx.y;
              arr[3] = screenRotx.z;
              freeRotMat = freeRotMat * mol->rotarb(arr);
//*/
              det=1.0/pow(determinant(freeRotMat), 1.0/3.0);
              freeRotMat *= det;
              QMatrix3x3 frm;

              frm(0,0)=freeRotMat.m11;
              frm(0,1)=freeRotMat.m12;
              frm(0,2)=freeRotMat.m13;

              frm(1,0)=freeRotMat.m21;
              frm(1,1)=freeRotMat.m22;
              frm(1,2)=freeRotMat.m23;

              frm(2,0)=freeRotMat.m31;
              frm(2,1)=freeRotMat.m32;
              frm(2,2)=freeRotMat.m33;
              QQuaternion p=QQuaternion::fromRotationMatrix(frm);
              qDebug()<<p;
              qDebug()<<qRadiansToDegrees(p.scalar())<<p.vector().length();
              splitRotate();
          }else{
          double slow=1.0;
          if (event->modifiers()==Qt::ShiftModifier) slow=0.25;
          if (event->modifiers()==Qt::ControlModifier) slow=0.06;
          glRotateMat(mvmat,slow*dy*360.0f,1,0,0);
          glRotateMat(mvmat,slow*dx*360.0f,0,1,0);
          pmv = pmat*mvmat;
          nm = mvmat.normalMatrix();
          eye = mvmat.inverted()*QVector4D(0,0,0,1);
          if ((freeRot!=nullptr)&&(freeRot->isChecked())){
              Matrix worldtoscreen=transponse(Matrix(mvmat));
              double det=1.0/pow(determinant(worldtoscreen), 1.0/3.0);
              worldtoscreen *= det;
              V3 wox(1,0,0);
              V3 woy(0,1,0);
              screenRotx = worldtoscreen * wox;
              screenRoty = worldtoscreen * woy;
          }
          updateSceenAtoms();
      }
  }else if (event->buttons() & Qt::MiddleButton){
      if ((freeRot!=nullptr)&&(freeRot->isChecked())&&(event->modifiers()==(Qt::AltModifier|Qt::ControlModifier))){
        V3 mv(dx, -dy, 0);
        makeCurrent();
        Matrix worldtoscreen=transponse(Matrix(mvmat));
        double det=1.0/pow(determinant(worldtoscreen), 1.0/3.0);
        worldtoscreen *= det;
        mv = worldtoscreen * mv;
        V3 o(orgx->value(), orgy->value(), orgz->value());
        o+=mv;
        orgx->setValue(o.x);
        orgy->setValue(o.y);
        orgz->setValue(o.z);
        //printf("%f%f %f\n",mv.x,mv.x,mv.z);
        splitRotate();
      }else{
      pmat.translate(3*dx*viewAngle,-3*dy*viewAngle,0);
      pmv = pmat*mvmat;
      nm = mvmat.normalMatrix();
      eye = mvmat.inverted()*QVector4D(0,0,0,1);
      updateSceenAtoms();
      }
  }
  moux=x;
  mouy=y;  
  update();
}

void PlayOpenGL::toggleOrtho(bool b){
    if (b) setViewAngle(0.05);
    else setViewAngle(previousViewAngle);
}

void PlayOpenGL::setViewAngle(double ang){
    if ((ang>=0.00)&&(ang<160.0)){
      //printf("before L %f %f %f ang%f va%f\n",lold,L, mvmat.determinant(),ang,viewAngle);
      double ll = ang / viewAngle;
      float ratio = static_cast<float>(width()) / static_cast<float>(height());
      pmat.setToIdentity();
      if (ang<0.1) {
          L=2.0/mol->dimension(mol->showatoms);
          printf("ident %d\n",__LINE__);
          mvmat.setToIdentity();
          mvmat.lookAt(QVector3D(0.0, 200, 50) , QVector3D(  0.0, 0.0, 0.0), QVector3D(0.0, -100, 400 ));
          mvmat.scale(L,L,L);
          pmat.ortho(-ratio,ratio,-1.0f,1.0f,-5.0f,8000.0f);
          //printf("to ortho L %f %f %f\n",lold,L, mvmat.determinant());
          previousViewAngle = qMax(viewAngle, 29.0);
          viewAngle=0.01;
          isOrtho=true;
          toggleOrthoView->setChecked(true);
      }
      else {
          viewAngle=ang;
          if (isOrtho){
              double dim=mol->dimension(mol->showatoms);
              L=ang * 100.0 / (dim * 29.0);
              printf("ident %d\n",__LINE__);
              mvmat.setToIdentity();
              mvmat.lookAt(QVector3D(0.0, 200, 50) , QVector3D(  0.0, 0.0, 0.0), QVector3D(0.0, -100, 400 ));
              mvmat.scale(L,L,L);
              //printf("L=> %f %f %f dim %f\n",lold,L, mvmat.determinant(),dim);
          }else {
              L*=ll;
              mvmat.scale(ll,ll,ll);
              //printf("<<==Lold = %f L = %f ll = %f\n",lold,L,ll);
          }
          isOrtho = false;
          pmat.perspective(static_cast<float>(viewAngle), ratio, 5.0f, 8000.0f );
          toggleOrthoView->setChecked(false);
      }
      emit viewAngeleChanged(viewAngle);
      homeXY();
    }
}

void PlayOpenGL::homeXY(){//! Resets the molecule to rotate in the middle of the viewport.
  QVector4D t = pmat.column(3);
  t.setX(0);
  t.setY(0);
  pmat.setColumn(3,t);
  pmv = pmat*mvmat;
  nm = mvmat.normalMatrix();
  eye = mvmat.inverted()*QVector4D(0,0,0,1);
  updateSceenAtoms();
  update();
}

void PlayOpenGL::rotCenter(){//! reset the rotation center to the center of gravity.
  rotze=-1;
  update();
  rCenter->hide();
  updateSceenAtoms();
}

void PlayOpenGL::toogleWithSymmetry(bool b){
  withsymm=(b)?0:1;
}

void PlayOpenGL::expand(){//! Lets Molecule.expandAt(int index) serach for neighboring molecules around the specified atom.
  QAction *action = qobject_cast<QAction *>(sender());
  int index=0;
  if (action)
    index=action->data().toInt();
  else return;
  if (index==(int)((GLuint)-1))return;
  mol->expandAt(index);
  fuse->setVisible(true);
  grow->setVisible(false);
  emit bigmessage(mol->HumanSymmetry);
  makeAtoms(mol->showatoms);
  makeBonds(mol->showatoms, mol->showbonds, mol->lbonds, mol->theH_Bonds);
  update();
}


void PlayOpenGL::hideThisFragment(){//! Hides the specified molecular fragment.
  //sdm();
  QAction *action = qobject_cast<QAction *>(sender());
  int index=0;
  if (action)
    index=action->data().toInt();
  else return;
  if (index>mol->showatoms.size()) return;
  int gute=mol->showatoms.at(index).molindex+9999*mol->showatoms.at(index).symmGroup;
  //int gute=mol->showatoms.at(index).molindex;
  for (int i=0;i<mol->showatoms.size();i++)
    if (mol->showatoms.at(i).an>=0)
      mol->showatoms[i].hidden=
        (mol->showatoms.at(i).molindex+9999*mol->showatoms.at(i).symmGroup!=gute)?mol->showatoms.at(i).hidden:1;
  //(mol->showatoms.at(i).molindex!=gute)?mol->showatoms.at(i).hidden:1;
  //
  //frid=gute;
  hiddenThings=true;
  //hideReason|=HIDE_REASON_THIS_FRAGMENT;
  mol->selectedatoms.clear();

  makeAtoms(mol->showatoms);
  makeBonds(mol->showatoms, mol->showbonds, mol->lbonds, mol->theH_Bonds);
  makeSelectedAtoms();
 // murx=-__LINE__;
  updateBondActions();
  update();
}

void PlayOpenGL::selectThisFragment(){//! Selects the specified molecular fragment
  //sdm();
  QAction *action = qobject_cast<QAction *>(sender());
  int index=0;
  if (action)
    index=action->data().toInt();
  else return;
  if (index>mol->showatoms.size()) return;
  mol->selectedatoms.clear();
  int gute=mol->showatoms.at(index).molindex+9999*mol->showatoms.at(index).symmGroup;
  //int gute=mol->showatoms.at(index).molindex;
  for (int i=0;i<mol->showatoms.size();i++)
    if (mol->showatoms.at(i).an>=0)
      if(mol->showatoms.at(i).molindex+9999*mol->showatoms.at(i).symmGroup==gute){
        mol->selectedatoms.append(mol->showatoms[i]);
        mol->selectedatoms.last().style=i;
      }
  //(mol->showatoms.at(i).molindex!=gute)?mol->showatoms.at(i).hidden:1;
  //
  updateBondActions();
  makeSelectedAtoms();
  update();
}

void PlayOpenGL::hideSelected(){//! Hides the selected atoms
  for(int i=0;i<mol->selectedatoms.size();i++){
    if (mol->selectedatoms.at(i).style < mol->showatoms.size())
      mol->showatoms[mol->selectedatoms.at(i).style].hidden=1;
    //   std::cout<<mol->showatoms.at(mol->selectedatoms.at(i).style).Label.toStdString()<<std::endl;
  }
  hiddenThings=true;
  mol->selectedatoms.clear();
  //murx=-__LINE__;

  makeAtoms(mol->showatoms);
  makeBonds(mol->showatoms, mol->showbonds, mol->lbonds, mol->theH_Bonds);

  updateBondActions();
  update();
}

void PlayOpenGL::hideOtherFragments(){//! Hides all molecular fragments except from the specified one
  //sdm();
  QAction *action = qobject_cast<QAction *>(sender());
  int index=0;
  if (action)
    index=action->data().toInt();
  else return;
  if (index==(int)((GLuint)-1))return;
  if (index>mol->showatoms.size()) return;
  int gute=mol->showatoms.at(index).molindex+withsymm*9999*mol->showatoms.at(index).symmGroup;
  //int gute=mol->showatoms.at(index).molindex;
  //  printf("hide %d %d %d \n",withsymm,gute,mol->showatoms.at(index).molindex+9999*mol->showatoms.at(index).symmGroup);
  for (int i=0;i<mol->showatoms.size();i++)
    if (mol->showatoms.at(i).an>=0){
      mol->showatoms[i].hidden=
        //		(mol->showatoms.at(i).molindex!=gute)?1:mol->showatoms.at(i).hidden;
        (mol->showatoms.at(i).molindex+withsymm*9999*mol->showatoms.at(i).symmGroup!=gute)?1:mol->showatoms.at(i).hidden;
      //   printf("%d %d \n",mol->showatoms[i].hidden,mol->showatoms.at(i).molindex+withsymm*9999*mol->showatoms.at(i).symmGroup);
    }
  hiddenThings=true;
  //frid=gute;
  //hideReason|=HIDE_REASON_OTHER_FRAGMENT;
  mol->selectedatoms.clear();
  //murx=-__LINE__;
  makeAtoms(mol->showatoms);
  makeBonds(mol->showatoms, mol->showbonds, mol->lbonds, mol->theH_Bonds);
  updateBondActions();
  update();
}

QColor PlayOpenGL::farbverlaufQC(double wrt, double min, double max){
    if (min>=max) max=min+0.001;
    double rot,gruen,blau,alpha;
    int lauf=0;
    double farbe[6][4]={{1.0,0.0,0.0,1.0},
                       {1.0,1.0,0.0,1.0},
                          {0.0,1.0,0.0,1.0},
                          {0.0,1.0,1.0,1.0},
                          {0.0,0.0,1.0,1.0},
                          {1.0,0.0,1.0,1.0}};
    double nwrt=(wrt-min)/(max-min);
    nwrt=(nwrt>=1.0)?0.99999:nwrt;
    nwrt=(nwrt<=0.0)?0.00001:nwrt;
    lauf=(int (nwrt/0.2));
    nwrt-=(0.2*lauf);
    nwrt/=(0.2);

    rot=(((1.0-nwrt)*farbe[lauf][0]+farbe[lauf+1][0]*nwrt));
    gruen=(((1.0-nwrt)*farbe[lauf][1]+farbe[lauf+1][1]*nwrt));
    blau=(((1.0-nwrt)*farbe[lauf][2]+farbe[lauf+1][2]*nwrt));
    alpha=1.0;
    return QColor(static_cast<int>(255*rot),
           static_cast<int>(255*gruen),
           static_cast<int>(255*blau),
           static_cast<int>(255*alpha));
}


void PlayOpenGL::contextMenuEvent(QMouseEvent *event){    
    //printf("contextMenuEvent %d %d %p %p %p\n",mol->showatoms.size(),screenAtoms.size(),sfacMenu,selSfacMenu,menu);
    QPoint menupoint = event->globalPos();
  double nahda=pickradius,da=0;
  int nahdai=-1;
  for (int j=0; j<mol->showatoms.size();j++){
    if (mol->showatoms.at(j).hidden) continue;
    da=(((screenAtoms.at(j).x()-event->x())*( screenAtoms.at(j).x()-event->x()))+
        ((screenAtoms.at(j).y()-event->y())*( screenAtoms.at(j).y()-event->y())));
    nahdai=(da<nahda)?j:nahdai;
    nahda=qMin(nahda,da);
  }
  //printf("da %d %f %d\n",da,nahda,nahdai);
  if ((nahdai < 0)||(mol->showatoms.size()<nahdai)) {
    return;
  }
  else {
    //printf("still here? %p %p %p\n",menu,restrMenu,constrMenu,enviMenu);
    int idx=nahdai;
    ImeanThisAtom=idx;
    if (idx>mol->showatoms.size()) return;
    if ((mol->showatoms.at(idx).an==-1)&&(mol->showatoms.at(idx).peakHeight<qcutoff)) return;
    if (menu == nullptr) menu = new QMenu(mol->showatoms.at(idx).Label);
    else {
        menu->setTitle(mol->showatoms.at(idx).Label);
        menu->clear();
    }
    if (!isMainWindow) {
        if (enviMenu == nullptr) enviMenu = new QMenu("ENVI-Settings");
        else enviMenu->clear();
        enviMenu->addAction("Change envi range", this, SLOT(changeEnviRange()));
        enviMenu->addAction(enviNoQ);
        enviMenu->addAction(enviCova);
        menu->addMenu(enviMenu);
        if ((int) idx < mol->showatoms.size()){
            QAction *a=nullptr;
          a=menu->addAction(QString("List ENVIronment of %1").arg(mol->showatoms.at(idx).Label),this,SLOT(envi()));
          a->setData(idx);
        }
        menu->exec(menupoint);
        return;
    }
    if (restrMenu == nullptr) restrMenu = new QMenu("Add restraints");
    else restrMenu->clear();
    if (constrMenu == nullptr) constrMenu = new QMenu("Add constraints");
    else constrMenu->clear();
    if (enviMenu == nullptr) enviMenu = new QMenu("ENVI-Settings");
    else enviMenu->clear();
    //printf("still here? %p %p %p %p %p\n",menu,restrMenu,constrMenu,enviMenu,selSfacMenu,sfacMenu);
    if ((selSfacMenu)&&(!mol->selectedatoms.isEmpty())) {
        menu->addMenu(selSfacMenu);
        //printf("selSfacMenu\n");
    }
    if (sfacMenu){
    QList<QAction *> sfas = sfacMenu->actions();
    for (int k=0;k<sfas.size();k++){
      sfas[k]->setEnabled(sfas[k]->text()!=mol->pse(mol->showatoms.at(idx).an));
    }
    if (mol->showatoms.at(idx).symmGroup==0) menu->addMenu(sfacMenu);
    }
    //*/
    //printf("still here? %p %p\n",chparent,parent());
    //printf("still here? %s\n",parent()->objectName().toStdString().c_str());

    QAction *a=nullptr;
    if (isMainWindow) {
    if ((mol->selectedatoms.isEmpty())&&(mol->showatoms.at(idx).symmGroup==0)) {
          a=menu->addAction(QIcon(theIconPath+"killselected.svg"),QString("Delete %1 ").arg(mol->showatoms.at(idx).Label),
          chparent,SLOT(deleteSelectedAtoms()));           
          a->setData(idx);
    }else if ((mol->showatoms.at(idx).symmGroup==0)) {
      a=menu->addAction(QIcon(theIconPath+"killselected.svg"),QString("Delete selected atoms"),
          chparent,SLOT(deleteSelectedAtoms()));
      a->setData(-1);
    }
    if ((!mol->selectedatoms.isEmpty())) a=menu->addAction("Change RESI or PART of selected atoms",chparent,SLOT(changeResiPart()));
    }
    menu->addSeparator();
    a=menu->addAction(QString("Set rotation center to %1").arg(mol->showatoms.at(idx).Label),this,SLOT(setRotationCenter()));
    a->setData(idx);
    a=menu->addAction(QString("Expand contacts around %1").arg(mol->showatoms.at(idx).Label),this,SLOT(expand()));
    a->setData(idx);
    a=menu->addAction(QString("Hide this fragment"),this,SLOT(hideThisFragment()));
    a->setData(idx);
    a=menu->addAction(QString("Select this fragment"),this,SLOT(selectThisFragment()));
    a->setData(idx);
    a=menu->addAction(QString("Hide other fragments"),this,SLOT(hideOtherFragments()));
    a->setData(idx);
    a=menu->addAction(QString("Fragment includes symmetry generated"), this ,SLOT(toogleWithSymmetry(bool)));
    a->setCheckable(true);
    a->setChecked(!(withsymm));
    if (!mol->selectedatoms.isEmpty()) a=menu->addAction("Hide selected Atoms",this,SLOT(hideSelected()));
    bool hasSameBonds=false;//for sadi two neighbor) atoms need to be same atomic number and no hydrogen
    //it warks if they are not the same but gives a warning and does not make much sense
    if (idx<mol->asymm.size()) for (int nb=1; nb<mol->knoepfe.at(idx).neighbors.size(); nb++){
      if ((mol->knoepfe.at(idx).neighbors.at(nb-1)>=mol->asymm.size())||(mol->knoepfe.at(idx).neighbors.at(nb)>=mol->asymm.size())) continue;
      if ((mol->asymm.at(mol->knoepfe.at(idx).neighbors.at(nb-1)).an>0)&&
          (mol->asymm.at(mol->knoepfe.at(idx).neighbors.at(nb-1)).an==mol->asymm.at(mol->knoepfe.at(idx).neighbors.at(nb)).an))hasSameBonds=true;
    }
    if(!mol->selectedatoms.isEmpty()){
      restrMenu->addAction("ISOR", this, SLOT(addISOR()));
      if (hasSameBonds){
        QAction *restr;
        restr=restrMenu->addAction("SADI", this, SLOT(addSADI()));
        restr->setData(idx);
      }
      if(mol->selectedatoms.size() == 2){
        restrMenu->addAction("DFIX", this, SLOT(addDFIX()));
        restrMenu->addAction("DANG", this, SLOT(addDANG()));
      }
      if(mol->selectedatoms.size() >= 4){
        restrMenu->addAction("FLAT", this, SLOT(addFLAT()));
      }
      if(mol->selectedatoms.size() > 1){
        constrMenu->addAction("EXYZ", this, SLOT(addEXYZ()));
        constrMenu->addAction("EADP", this, SLOT(addEADP()));
        restrMenu->addAction("RIGU", this, SLOT(addRIGU()));
        restrMenu->addAction("DELU", this, SLOT(addDELU()));
        restrMenu->addAction("SIMU", this, SLOT(addSIMU()));
        restrMenu->addAction("CHIV", this, SLOT(addCHIV()));
      }
      menu->addMenu(restrMenu);
      menu->addMenu(constrMenu);
    }else if (hasSameBonds) {
      restrMenu = new QMenu("Add restraints");
      QAction *restr;
      restr=restrMenu->addAction("SADI", this, SLOT(addSADI()));
      restr->setData(idx);
      menu->addMenu(restrMenu);
    }
    menu->addSeparator();
    {
        QAction *a = nullptr;
        a = enviMenu->addAction("Change ENVI Range", this, SLOT(changeEnviRange()));
        a->setData(idx);
        enviMenu->addAction(enviNoQ);
        enviNoQ->setData(idx);
        connect(enviNoQ,SIGNAL(triggered(bool)),this,SLOT(envi()));
        enviMenu->addAction(enviCova);
        enviCova->setData(idx);
        connect(enviCova,SIGNAL(triggered(bool)),this,SLOT(envi()));
    }
    /*
    enviMenu->addAction(QString("Change ENVI Range (%1A)").arg(envirange), this, SLOT(changeEnviRange()));
    enviMenu->addAction(enviNoQ);
    enviMenu->addAction(enviCova);
    */
    menu->addMenu(enviMenu);

    if ((int) idx < mol->asymm.size()){
      a=menu->addAction(QString("List ENVIronment of %1").arg(mol->showatoms.at(idx).Label),this,SLOT(envi()));
      a->setData(idx);      
      a=menu->addAction(QString("Grow ENVIronment of %1").arg(mol->showatoms.at(idx).Label),this,SLOT(growEnvi()));
      a->setData(idx);
      a=menu->addAction(QString("Show only ENVIronment of %1").arg(mol->showatoms.at(idx).Label),this,SLOT(showEnvi()));
      a->setData(idx);
    }
    menu->addSeparator();
    int ssgr=0;
    int adpat=0;
    for (int seli=0; seli<mol->selectedatoms.size(); seli++){
      if ((mol->showatoms.at(seli).symmGroup==0)&&(!mol->selectedatoms.at(seli).isIso))adpat++;
    }
    for (int seli=0; seli<mol->selectedatoms.size(); seli++){
      if (mol->selectedatoms.at(seli).symmGroup>0) ssgr+=mol->selectedatoms.at(seli).symmGroup;
      else {
        ssgr=0;
        break;
      }
    }
    if (ssgr) adpat=0;
    if (ssgr){
      a=menu->addAction(QString("Move selected atoms to selected sites"),
          chparent,SLOT(moveSymmMateSel()));
      //////// 28.03.12
      if ((mol->showatoms.at(idx).part<0)){
        a=menu->addAction(QString("Copy %1 here").arg(mol->showatoms.at(idx).Label.section("_",0,0)),
            chparent,SLOT(copySymmMate()));
        a->setData(idx);
      }
      //////// -
    }else{      
        if ((mol->showatoms.at(idx).symmGroup>0)){
        a=menu->addAction(QString("Move %1 here").arg(mol->showatoms.at(idx).Label.section("_",0,0)),
            chparent,SLOT(moveSymmMate()));
        a->setData(idx);
        if ((mol->showatoms.at(idx).part<0)){
          a=menu->addAction(QString("Copy %1 here").arg(mol->showatoms.at(idx).Label.section("_",0,0)),
              chparent,SLOT(copySymmMate()));
          a->setData(idx);
        }
      }
    }
    menu->addSeparator();
    if ((nahdai<mol->asymm.size())&&(mol->knoepfe.at(idx).neighbors.size()==1)&&((mol->showatoms.at(idx).an==6)||(mol->showatoms.at(idx).an==5))) {
      a=menu->addAction(QString("Add dissordered %1 Hydrogen atoms").arg(((mol->showatoms.at(idx).an==5))?"methyl":"-NH3"),chparent,SLOT(addDissorderedMethyl()));
      a->setData(idx);
      a=menu->addAction(QString("Add ordered %1 Hydrogen atoms").arg(((mol->showatoms.at(idx).an==5))?"methyl":"-NH3+"),chparent,SLOT(addMethyl()));
      a->setData(idx);
      a=menu->addAction(QString("Add terminal %1 Hydrogen atoms").arg(((mol->showatoms.at(idx).an==5))?"=CH2 ":"=NH2+"),chparent,SLOT(addH93()));
      a->setData(idx);
      if (mol->showatoms.at(idx).an==5){
        a=menu->addAction(QString("Add acetylenic C-H Hydrogen atom"),chparent,SLOT(addH163()));
        a->setData(idx);
      }
      if (mol->showatoms.at(idx).an==6){
        a=menu->addAction(QString("Add %1 Hydrogen atoms").arg("-NH2 (non planar)"),chparent,SLOT(addHnonplanarAminR1()));
        a->setData(idx);
      }
    }
    if ((nahdai<mol->asymm.size())&&(mol->knoepfe.at(idx).neighbors.size()==1)&&(mol->showatoms.at(idx).an==7)){
        a->setData(idx);
        a=menu->addAction(QString("Add hydroxyl Hydrogen atom to %1").arg(mol->showatoms.at(idx).Label.section("_",0,0)),chparent,SLOT(addHydroxyl()));
        a->setData(idx);
    }
    if ((nahdai<mol->asymm.size())&&(mol->knoepfe.at(idx).neighbors.size()==2)&&((mol->showatoms.at(idx).an==6)||(mol->showatoms.at(idx).an==5))) {
      a=menu->addAction(QString("Add %1 Hydrogen atoms").arg(((mol->showatoms.at(idx).an==5))?">CH2":">NH2+"),chparent,SLOT(addH23()));
      a->setData(idx);
      a=menu->addAction(QString("Add %1 Hydrogen atom").arg(((mol->showatoms.at(idx).an==5))?">CH":">NH (planar)"),chparent,SLOT(addH43()));
      a->setData(idx);
      //addHnonplanarAminR2();
      if ((mol->showatoms.at(idx).an==6)){
        a=menu->addAction(QString("Add %1 Hydrogen atom").arg(">NH (non planar)"),chparent,SLOT(addHnonplanarAminR2()));
        a->setData(idx);
      }
    }
    if ((idx < mol->asymm.size()) && (mol->asymm.at(idx).an>-1)) {
      a=menu->addAction(QString("Use %1 as new label for rename mode").arg(mol->showatoms.at(idx).Label.section("_",0,0)),chparent,SLOT(renameThisAtom()));
      a->setData(idx);
    }

    if(!mol->selectedatoms.isEmpty()){
      menu->addAction(QString("Make selected atoms ANIS"),this,SLOT(addANIS()));
    }
    if ((adpat)) {
      if (mol->selectedatoms.isEmpty()){
        a=menu->addAction(QIcon(theIconPath+"sina.svg"),QString("make %1 isotropic (ISOT)")
            .arg(mol->showatoms.at(idx).Label),chparent,SLOT(sina()));
        a->setData(idx);
      }else{
        a=menu->addAction(QIcon(theIconPath+"sina.svg"),QString("make selected atoms isotropic (ISOT)"),chparent,SLOT(sina()));
        a->setData(-1);
      }
    }
    if ((idx<mol->asymm.size())&&(mol->asymm.at(idx).an>-1)){
        QAction *a = menu->addAction("Draw voronoi polyeder of this atom",chparent,SLOT(makeVoro()));
        a->setData(idx);
      }
    if ((mol->showatoms.at(p).molindex!=mol->showatoms.at(idx).molindex)){
      menu->addSeparator();
      menu->addAction(QString("Inherit Labels from molecule around %1 to atoms around %2")
          .arg(mol->showatoms.at(p).Label)
          .arg(mol->showatoms.at(idx).Label)
          ,chparent,SLOT(inheritLabels()));
      ppp = pp;
      pp = p;
      p = idx;
    }
    menu->exec(menupoint);
    //delete enviMenu;
    //delete menu;
  }
}


void PlayOpenGL::mousePressEvent(QMouseEvent *event){
    //printf("mousePressEvent mouxy %d %d \n",moux,mouy);
    if ((event->buttons() & Qt::RightButton)){
        contextMenuEvent(event);
        return;
    }
    if (menu) menu->close();
    if (rectangle){
      rectangle=false;
      update();
    }
  moux=event->pos().x();
  mouy=event->pos().y();

  p = qMin(p,mol->showatoms.size()-1);
  pp = qMin(pp,mol->showatoms.size()-1);
  ppp = qMin(ppp,mol->showatoms.size()-1);

  p = qMax(p,0);
  pp = qMax(pp,0);
  ppp = qMax(ppp,0);
  double nahda=pickradius,da=0;
  int nahdai=-1;
  for (int j=0; j<mol->showatoms.size();j++){
    if (mol->showatoms.at(j).hidden) continue;
    if ((mol->showatoms.at(j).an==-1)&&(mol->showatoms.at(j).peakHeight<qcutoff)) continue;

    da=(((screenAtoms.at(j).x()-event->x())*( screenAtoms.at(j).x()-event->x()))+
        ((screenAtoms.at(j).y()-event->y())*( screenAtoms.at(j).y()-event->y())));
    nahdai=(da<nahda)?j:nahdai;
    nahda=qMin(nahda,da);
  }
  if (event->buttons() & Qt::LeftButton){
    scrx0=moux;
    scry0=mouy;
    if ((event->buttons() & Qt::LeftButton) && (nahdai >= 0) && (nahdai < mol->showatoms.size())){
        int index=nahdai;
        if (event->modifiers()==Qt::NoModifier) {
        double w=0,dw=0;
        if ((pp!=p)&&(pp!=index)&&(p!=index)) {
          V3 aa1=mol->showatoms.at(p).pos-mol->showatoms.at(pp).pos;
          V3 aa2=mol->showatoms.at(p).pos-mol->showatoms.at(index).pos;
          w=mol->winkel(aa1,aa2);
          if ((ppp!=p)&&(ppp!=pp)&&(ppp!=index))
            dw=mol->dieder(mol->showatoms.at(pp).pos-mol->showatoms.at(ppp).pos,
                mol->showatoms.at(pp).pos-mol->showatoms.at(p).pos,
                mol->showatoms.at(p).pos-mol->showatoms.at(index).pos);
        }
        if (atomsClickable){
          emit jumpit(index);
         /* printf("%s %d %d\n",
              mol->showatoms.at(index).Label.toStdString().c_str(),
              mol->showatoms.at(index).scod,
              mol->showatoms.at(index).an);*/
          if (inRenameMode) return;
          if (!inRenameMode){
            apair.clear();
            if (event->modifiers()==Qt::NoModifier) {
              int isschon=-1;
              for (int i=0; i< mol->selectedatoms.size();i++){
                isschon=(mol->selectedatoms.at(i).style==index)?index:isschon;
              }
              mol->selectedatoms.clear();
              if (isschon==-1){
                mol->selectedatoms.append(mol->showatoms[index]);
                mol->selectedatoms.last().style=index;
              }
            }
            if ((manualAx!=nullptr)&&(!manualAx->isChecked())&&(event->modifiers()==Qt::AltModifier)) {
              int pv1=pivot1cb->findText(mol->showatoms.at(p).Label);
              int pv2=pivot2cb->findText(mol->showatoms.at(index).Label);
              if ((pv1>-1)&&(pv2)){
                  emit pivot1Changed(pv1);
                  emit pivot2Changed(pv2);
                  altpivot=true;
                  //printf("new axe %d %d\n",pv1,pv2);
              }

            }
            if (event->modifiers()==Qt::ShiftModifier) {
              int min=mol->showatoms.size(), max=-1;
              for (int i=0; i< mol->selectedatoms.size();i++){
                min=qMin(mol->selectedatoms.at(i).style,min);
                max=qMax(mol->selectedatoms.at(i).style,max);
              }
              min=qMin((int)index,min);
              max=qMax((int)index,max);
              mol->selectedatoms.clear();
              for (int i=min; i<=max; i++){
                mol->selectedatoms.append(mol->showatoms[i]);
                mol->selectedatoms.last().style=i;
              }
            }
            if (event->modifiers()==Qt::ControlModifier) {
              if (mol->selectedatoms.contains(mol->showatoms[index])){
                mol->selectedatoms.removeOne(mol->showatoms[index]);
              } else {
                mol->selectedatoms.append(mol->showatoms[index]);
                mol->selectedatoms.last().style=index;
                //                for (int oo=0; oo<mol->selectedatoms.size(); oo++) qDebug()<<mol->selectedatoms.at(oo).Label<<mol->selectedatoms.at(oo).symmGroup<< mol->selectedatoms.at(oo).style<<mol->selectedatoms.size();
              }
            }
            //	  std::cout<<mol->selectedatoms.size()<<mol->selectedatoms.last().Label.toStdString()<<std::endl;
            emit selectionChanged();
            updateBondActions();
            update();
          }
          //

          V3 hin;
          double dmsda=0;
          hin = Normalize(mol->showatoms.at(index).pos-mol->showatoms.at(p).pos);
          if ((mol->showatoms.at(index).an>-1) && (mol->showatoms.at(p).an))
            dmsda = fabs(((hin*mol->showatoms.at(index).uc)*hin)- ((hin*mol->showatoms.at(p).uc)*hin));
          //
          bool syok;
          QString symml;
          int syid=mol->showatoms.at(index).Label.section(QString::fromUtf8("»"),1).toInt(&syok);
          if (mol->usedSymmetry.size()&&syok) symml=mol->symmcode2human(mol->usedSymmetry.at(syid-1),syid);
          syid=mol->showatoms.at(p).Label.section(QString::fromUtf8("»"),1).toInt(&syok);
          if ((mol->usedSymmetry.size())&&(syok)&&(!symml.contains(mol->symmcode2human(mol->usedSymmetry.at(syid-1),syid))))
            symml+=mol->symmcode2human(mol->usedSymmetry.at(syid-1),syid);

          syid=mol->showatoms.at(pp).Label.section(QString::fromUtf8("»"),1).toInt(&syok);
          if ((mol->usedSymmetry.size())&&(syok)&&(!symml.contains(mol->symmcode2human(mol->usedSymmetry.at(syid-1),syid))))
            symml+=mol->symmcode2human(mol->usedSymmetry.at(syid-1),syid);

          syid=mol->showatoms.at(ppp).Label.section(QString::fromUtf8("»"),1).toInt(&syok);
          if ((mol->usedSymmetry.size())&&(syok)&&(!symml.contains(mol->symmcode2human(mol->usedSymmetry.at(syid-1),syid))))
            symml+=mol->symmcode2human(mol->usedSymmetry.at(syid-1),syid);
          /*printf("%s org=%s iso=%d\n a%9.6f b%9.6f c%9.6f  %9.6f %9.6f %9.6f\n d%9.6f e%9.6f f%9.6f  %9.6f %9.6f %9.6f\n g%9.6f h%9.6f i%9.6f  %9.6f %9.6f %9.6f\n\n",
            mol->showatoms.at(index).Label.toStdString().c_str(),
            mol->showatoms.at(index).ufiso_org.toStdString().c_str(),
            mol->showatoms.at(index).isIso,
            mol->showatoms.at(index).uf.m11,mol->showatoms.at(index).uf.m12,mol->showatoms.at(index).uf.m13,  mol->showatoms.at(index).uc.m11,mol->showatoms.at(index).uc.m12,mol->showatoms.at(index).uc.m13,
            mol->showatoms.at(index).uf.m21,mol->showatoms.at(index).uf.m22,mol->showatoms.at(index).uf.m23,  mol->showatoms.at(index).uc.m21,mol->showatoms.at(index).uc.m22,mol->showatoms.at(index).uc.m23,
            mol->showatoms.at(index).uf.m31,mol->showatoms.at(index).uf.m32,mol->showatoms.at(index).uf.m33,  mol->showatoms.at(index).uc.m31,mol->showatoms.at(index).uc.m32,mol->showatoms.at(index).uc.m33
            );// */

          if ((index!=p)&&(index!=pp)&&(mol->showatoms.at(index).Label[0]=='Q')){
            /*printf("scod %d %f %f %f \n",mol->showatoms.at(index).scod,
              mol->showatoms.at(index).frac.x,
              mol->showatoms.at(index).frac.y,
              mol->showatoms.at(index).frac.z);//  **/
            emit bigmessage(QString("<hr><table><tr><td><b>%1</b></td><td align=\"right\"></td></tr><tr><td><b>%1--%2</b>"
                  "</td><td align=\"right\">%5 &Aring;</td></tr><tr><td><b>%1--%2--%3</b></td><td "
                  "align=\"right\">%6&deg;</td></tr><tr><td><b>%1--%2--%3--%4 </b></td><td "
                  "align=\"right\">%7&deg;</td></tr><tr><td><b>%1</b> Peak Height: </td><td "
                  "align=\"right\">%8 e&Aring;<sup>-3</sup></td><td>[%9&hellip;%10]"
                  "</td></tr></table>%11")
                .arg((mol->showatoms.at(index).Label))                     //1
                .arg((mol->showatoms.at(p).Label))				//3
                .arg((mol->showatoms.at(pp).Label))			                //5			                                                //8
                .arg((mol->showatoms.at(ppp).Label))			                        //9
                .arg(sqrt(Distance(mol->showatoms.at(index).pos,mol->showatoms.at(p).pos)),8,'f',3) //4
                .arg(w,8,'f',2)
                .arg(dw,8,'f',2)
                .arg(mol->showatoms.at(index).peakHeight,8,'f',2)
                .arg(mol->pmin,3,'f',2)
                .arg(mol->pmax,3,'f',2)
                .arg(symml)

                );
          }
          else if ((index!=p)&&(index!=pp)&&(mol->showatoms.at(index).Label[0]=='L')&&(mol->showatoms.at(index).an==-42)){
            emit bigmessage(QString("<hr><table><tr><td><b>%1</b></td><td align=\"right\"></td></tr><tr><td><b>%1--%2</b>"
                  "</td><td align=\"right\">%5 &Aring;</td></tr><tr><td><b>%1--%2--%3</b></td><td "
                  "align=\"right\">%6&deg;</td></tr><tr><td><b>%1--%2--%3--%4 </b></td><td "
                  "align=\"right\">%7&deg;</td></tr><tr><td><b>%1</b> a exp(-b x<sup>2</sup>)</td><td "
                  "align=\"right\">a = %8 </td><td> b = %9 "
                  "</td></tr></table>%11")
                .arg((mol->showatoms.at(index).Label))                     //1
                .arg((mol->showatoms.at(p).Label))				//3
                .arg((mol->showatoms.at(pp).Label))			                //5			                                                //8
                .arg((mol->showatoms.at(ppp).Label))			                        //9
                .arg(sqrt(Distance(mol->showatoms.at(index).pos,mol->showatoms.at(p).pos)),8,'f',3) //4
                .arg(w,8,'f',2)
                .arg(dw,8,'f',2)
                .arg(mol->showatoms.at(index).sof,8,'f',2)
                .arg(mol->showatoms.at(index).peakHeight,8,'f',2)
                .arg(symml)

                );
          }
          else if ((index!=p)&&(index!=pp)){
            emit bigmessage(QString("<br><hr><table><tr><td><b>%1</b> part: %8 residue: %9 %10 (fragment: %12)</td><td align=\"right\">"
                  "</td></tr><tr><td><b>%1--%2</b></td><td align=\"right\">%5 &Aring;</td><td>&nbsp;&nbsp;&nbsp;DMSDA: %13 &Aring;<sup>2</sup></td></tr>"
                  "<tr><td><b>%1--%2--%3</b></td><td align=\"right\">%6&deg;</td><td>&nbsp;&nbsp;&nbsp;1,3 Distance( DANG) %14 &Aring;</td></tr><tr><td>"
                  "<b>%1--%2--%3--%4 </b></td><td align=\"right\">%7&deg;</td></tr></table>%11")
                .arg((mol->showatoms.at(index).Label))			       //1
                .arg((mol->showatoms.at(p).Label))			               //2
                .arg((mol->showatoms.at(pp).Label))			       //3
                .arg((mol->showatoms.at(ppp).Label))			       //4
                .arg(sqrt(Distance(mol->showatoms.at(index).pos,mol->showatoms.at(p).pos)),8,'f',3) //5
                .arg(w,8,'f',2)			                            //6
                .arg(dw,8,'f',2)                                               //7
                .arg(mol->showatoms.at(index).part)
                .arg(mol->showatoms.at(index).resiNr)
                .arg(mol->showatoms.at(index).ResiClass)
                .arg(symml)
                .arg(mol->showatoms.at(index).molindex)
                .arg(dmsda,5,'e',2)
                .arg(sqrt(Distance(mol->showatoms.at(index).pos,mol->showatoms.at(pp).pos)),8,'f',3)
                );
          }
          //				   ,QMessageBox::Ok);
          ppp = pp;
          pp = p;
          p = index;
        }

        }else if (event->modifiers()==Qt::ShiftModifier) {
          int min=mol->showatoms.size(), max=-1;
          for (int i=0; i< mol->selectedatoms.size();i++){
            min=qMin(mol->selectedatoms.at(i).style,min);
            max=qMax(mol->selectedatoms.at(i).style,max);
          }
          min=qMin((int)index,min);
          max=qMax((int)index,max);
          mol->selectedatoms.clear();
          for (int i=min; i<=max; i++){
            mol->selectedatoms.append(mol->showatoms[i]);
            mol->selectedatoms.last().style=i;
          }
        }
        if (event->modifiers()==Qt::ControlModifier) {
          if (mol->selectedatoms.contains(mol->showatoms[index])){
            mol->selectedatoms.removeOne(mol->showatoms[index]);
          } else {
            mol->selectedatoms.append(mol->showatoms[index]);
            mol->selectedatoms.last().style=index;
          }
        }
        updateBondActions();
        makeSelectedAtoms();
        updateSceenAtoms();
        update();
    }
  }
  if ((event->buttons() & Qt::MiddleButton) && (nahdai >= 0) && (nahdai < mol->showatoms.size()) && (parent()->objectName()=="The Main Window")){
        int index=nahdai;
        rotze=((int)index<mol->showatoms.size())?index:-1;
        printf("rot center %d %d %d\n",rotze, mol->showatoms.size(),index);
        if (rotze>-1){
            if (parent()->objectName()=="The Main Window") rCenter->show();
            homeXY();
            updateSceenAtoms();
            //glGetDoublev(GL_MODELVIEW_MATRIX, MM); MM[12] = MM[13] = 0; glLoadMatrixd(MM);
        }
        update();
      }
  update();
}

void PlayOpenGL::along001(){
    makeCurrent();
  double va=viewAngle;
  setViewAngle(29.0);
  mvmat(0,0)=1.f;
  mvmat(0,1)=0.f;
  mvmat(0,2)=0.f;
  mvmat(1,0)=0.f;
  mvmat(1,1)=1.f;
  mvmat(1,2)=0.f;
  mvmat(2,0)=0.f;
  mvmat(2,1)=0.f;
  mvmat(2,2)=1.f;
  pmv = pmat*mvmat;
  nm = mvmat.normalMatrix();
  eye = mvmat.inverted()*QVector4D(0,0,0,1);
  updateSceenAtoms();
  update();
  setViewAngle(va);
}

void PlayOpenGL::zoom(double speed){//!scale about speed @param speed scale factor
  double ll=1.0+speed*0.1;
  L*=ll;
  mvmat.scale(ll,ll,ll);
  pmv = pmat*mvmat;
  nm = mvmat.normalMatrix();
  eye = mvmat.inverted()*QVector4D(0,0,0,1);
  updateSceenAtoms();
  update();
}

void PlayOpenGL::rotY(double speed){//!rotate around Y axis @param speed in degrees
  //glRotateL(-20.0*speed,0.0f,1.0f,0.0f);
  glRotateMat(mvmat,-20.0*speed,0,1,0);
  pmv = pmat*mvmat;
  nm = mvmat.normalMatrix();
  eye = mvmat.inverted()*QVector4D(0,0,0,1);
  updateSceenAtoms();
  update();
}

void PlayOpenGL::gZoom(double speed){//!scale about speed @param speed scale factor
  //glScaled(1.0+speed*0.02,1.0+speed*0.02,1.0+speed*0.02);
  double ll=1.0+speed*0.02;
  L*=ll;
  mvmat.scale(ll,ll,ll);
  pmv = pmat*mvmat;
  nm = mvmat.normalMatrix();
  eye = mvmat.inverted()*QVector4D(0,0,0,1);
  updateSceenAtoms();
  update();
}

void PlayOpenGL::rotZ(double speed){//!rotate around Z axis @param speed in degrees
  glRotateMat(mvmat,-20*speed,0,0,1);
  pmv = pmat*mvmat;
  nm = mvmat.normalMatrix();
  eye = mvmat.inverted()*QVector4D(0,0,0,1);
  updateSceenAtoms();
  update();
}

void PlayOpenGL::moveY(double speed){//!translate the molecule in Y direction
  //glTranslateL(0.0,speed,0.0);
  pmat.translate(0,speed*viewAngle,0);
  pmv = pmat*mvmat;
  nm = mvmat.normalMatrix();
  eye = mvmat.inverted()*QVector4D(0,0,0,1);
  updateSceenAtoms();

  update();
}

void PlayOpenGL::moveX(double speed){//!translate the molecule in X direction
  //glTranslateL(speed,0.0,0.0);
  pmat.translate(speed*viewAngle,0,0);
  pmv = pmat*mvmat;
  nm = mvmat.normalMatrix();
  eye = mvmat.inverted()*QVector4D(0,0,0,1);
  updateSceenAtoms();
  //  QMessageBox::information(this,"Px move","xmoved",QMessageBox::Ok);
  update();
}

void PlayOpenGL::rotX(double speed){//!rotate around X axis @param speed in degrees
  //glRotateL(-20.0*speed,1.0f,0.0f,0.0f);
  glRotateMat(mvmat,-20*speed,1,0,0);
  pmv = pmat*mvmat;
  nm = mvmat.normalMatrix();
  eye = mvmat.inverted()*QVector4D(0,0,0,1);
  updateSceenAtoms();
  update();
}


void PlayOpenGL::paintGL(){
    //if (parent()->objectName()!="The Main Window") printf("paintGL -> %d\n",context()->isValid());
    GLenum err = GL_NO_ERROR;
    while((err = glGetError()) != GL_NO_ERROR){
      printf("%s paintGL error %X %d\n", parent()->objectName().toStdString().c_str(), err, __LINE__);
      //printf("%s\n",(char*)gluErrorString(err));
    }

    glClearColor(backGroundColor.redF(),backGroundColor.greenF(),backGroundColor.blueF(),backGroundColor.alphaF());
    frame_cnt++;
    QVector3D org = QVector3D(sumse.x, sumse.y, sumse.z);
    if ((rotze>-1)&&(rotze<mol->showatoms.size())) org = QVector3D(mol->showatoms.at(rotze).pos.x, mol->showatoms.at(rotze).pos.y, mol->showatoms.at(rotze).pos.z);
    if ((centerSelection)&&(centerSelection->isChecked())){
      if (mol->selectedatoms.isEmpty()) {
        org = QVector3D(sumse.x, sumse.y, sumse.z);
      }
      else {
        V3 sums=V3(0,0,0);
        for (int i = 0; i < mol->selectedatoms.size(); i++) sums += mol->selectedatoms[i].pos;
        sums *= 1.0 / mol->selectedatoms.size();
        org = QVector3D(sums.x, sums.y, sums.z);
      }
    }
    V3 org3=V3(org.x(), org.y(), org.z());
    altemitte=org3;
    glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
    if (bg_program){

        //if (parent()->objectName()!="The Main Window") printf("paintGL -> %d\n",__LINE__);
        if ( !bg_program->bind() ){ qWarning() << "Could not bind shader program to context"; return;}
        bg_vao.bind();
        bg_program->setUniformValue("bgcolor", backGroundColor);
        bg_program->setUniformValue("bggradient", bggradient);
        glDisable(GL_DEPTH_TEST);
        glEnable(GL_BLEND);
        glBlendFunc ( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA ) ;
        glDisable(GL_CULL_FACE);
        glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
        glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);
        glEnable(GL_DEPTH_TEST);
        bg_vao.release();
        bg_program->release();
    }//*
    if (rectangle) renderRect();
    if ((drawAtoms)&&(atom_program)){
        GLenum err = GL_NO_ERROR;
        while((err = glGetError()) != GL_NO_ERROR)
        {
          printf("atom_program %s error %X\n", parent()->objectName().toStdString().c_str(),err);
          //printf("%s\n",(char*)gluErrorString(err));
        }

        //if (parent()->objectName()!="The Main Window") printf("paintGL -> %d atom_index_size %d\n",__LINE__,atom_index_size);
        if ( !atom_program->bind() ){ qWarning() << "Could not bind shader program to context"; return;}
        float fiftypct =1.54;
        switch (mol->proba ) {
          case 10 :{ fiftypct = 0.76; break;}   //Hauptachsen der Eliipsoide 10% Wahrscheinlichkeit
          case 30 :{ fiftypct = 1.19; break;}   //Hauptachsen der Eliipsoide 30% Wahrscheinlichkeit
          case 50 :{ fiftypct = 1.54; break;}   //Hauptachsen der Eliipsoide 50% Wahrscheinlichkeit
          case 70 :{ fiftypct = 1.91; break;}   //Hauptachsen der Eliipsoide 70% Wahrscheinlichkeit
          case 90 :{ fiftypct = 2.50; break;}   //Hauptachsen der Eliipsoide 90% Wahrscheinlichkeit
          default: ;
        }
        atom_vao.bind();
        glEnable(GL_DEPTH_TEST);
        glEnable(GL_BLEND);
        glBlendFunc ( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA ) ;
        atom_program->setUniformValue("pmv", pmv);
        atom_program->setUniformValue("origin", org);
        atom_program->setUniformValue("normalMatrix", nm);
        atom_program->setUniformValue("lightPos", QVector3D(-100.0, 100.0, 800.0));
        atom_program->setUniformValue("pmax", static_cast<GLfloat>(mol->pmax));
        atom_program->setUniformValue("pmin", static_cast<GLfloat>(mol->pmin));
        atom_program->setUniformValue("lmax", static_cast<GLfloat>(mol->lmax));
        atom_program->setUniformValue("lmin", static_cast<GLfloat>(mol->lmin));
        atom_program->setUniformValue("qcutoff", qcutoff);
        atom_program->setUniformValue("fiftypct", fiftypct);
        atom_program->setUniformValue("LOD", mol->LOD);
        atom_program->setUniformValue("eye", eye);
        atom_program->setUniformValue("adp", adp->isChecked());
        atom_program->setUniformValue("bede", hideBeLo->isChecked());
        atom_program->setUniformValue("hidePM1", shpm1->isChecked());
        atom_program->setUniformValue("QPeakLegend", QPeakLegend->isChecked());
        atom_program->setUniformValue("Qolor", mol->mQolor);
        atom_program->setUniformValue("highlightParts", highlightParts->isChecked());
        atom_program->setUniformValue("highlightEquivalents", mol->highlightEquivalents);
        atom_program->setUniformValue("hideHydrogen", !hideHydrogen->isVisible());
        atom_program->setUniformValue("bondradius", static_cast<float>(mol->bondStrength));
        atom_program->setUniformValue("tubes", tubes->isChecked());
        atom_program->setUniformValue("ballStick", ballStick->isChecked());
        atom_program->setUniformValue("qpeakrad", static_cast<GLfloat>(mol->qPeakRad*2));
        glDrawElements(GL_TRIANGLES, atom_index_size, GL_UNSIGNED_INT, nullptr);
        atom_program->release();
        atom_vao.release();

        err = GL_NO_ERROR;
        while((err = glGetError()) != GL_NO_ERROR)
        {
          printf("atom_program_released %s error %X %d\n", parent()->objectName().toStdString().c_str(),err, __LINE__);
          //printf("%s\n",(char*)gluErrorString(err));
        }
    }
    if ((drawBonds)&&(bond_program)){

        //if (parent()->objectName()!="The Main Window") printf("paintGL -> %d\n",__LINE__);
        if ( !bond_program->bind() ){ qWarning() << "2Could not bind shader program to context"; return;}        
        bond_vao.bind();
        glEnable(GL_DEPTH_TEST );
        glEnable(GL_BLEND);
        glBlendFunc ( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA ) ;
        bond_program->setUniformValue("pmv", pmv);
        bond_program->setUniformValue("origin", org);
        bond_program->setUniformValue("normalMatrix",nm);
        bond_program->setUniformValue("radius", static_cast<float>(mol->bondStrength));
        bond_program->setUniformValue("qradius", 0.1f*static_cast<float>(mol->q_bondWidth));
        bond_program->setUniformValue("segments", qMin(mol->LOD,8));
        bond_program->setUniformValue("hideHydrogen", !hideHydrogen->isVisible());
        bond_program->setUniformValue("qPeakBonds",qPeakBonds->isChecked());
        bond_program->setUniformValue("qcutoff", qcutoff);
        bond_program->setUniformValue("h_bonds", (h_bonds->isChecked()));       
        bond_program->setUniformValue("highlightEquivalents", mol->highlightEquivalents);
        //printf("h_bonds %d\n",h_bonds->isChecked());
        bond_program->setUniformValue("highlightParts", highlightParts->isChecked());
        bond_program->setUniformValue("tubes", tubes->isChecked());
        bond_program->setUniformValue("hidePM1", shpm1->isChecked());
        bond_program->setUniformValue("ballStick", ballStick->isChecked());
        bond_program->setUniformValue("uniColorBonds",(mol->bondColorStyle!=0));
        bond_program->setUniformValue("uniColor",mol->bondColor);
        glDrawElements(GL_LINES, nbondx2, GL_UNSIGNED_INT, nullptr);
        bond_program->release();
        bond_vao.release();
    }
    //if (parent()->objectName()!="The Main Window") printf("paintGL -> %d\n",__LINE__);
    if (((mol->splitLbonds.size()+mol->splitRbonds.size())>0)&&(splitrot_program)){
        if ( !splitrot_program->bind() ){ qWarning() << "2Could not bind shader program to context"; return;}
        splitrot_vao.bind();
        glEnable(GL_DEPTH_TEST );
        //glEnable(GL_BLEND);
        //printf("splitrot_program %d\n",mol->splitLbonds.size()+mol->splitRbonds.size());
        //glBlendFunc ( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA ) ;
        splitrot_program->setUniformValue("pmv", pmv);
        splitrot_program->setUniformValue("origin", org);
        splitrot_program->setUniformValue("normalMatrix",nm);
        splitrot_program->setUniformValue("radius", static_cast<float>(mol->bondStrength*1.5f));
        splitrot_program->setUniformValue("dirx", QVector3D(screenRotx.x,screenRotx.y,screenRotx.z));
        splitrot_program->setUniformValue("diry", QVector3D(screenRoty.x,screenRoty.y,screenRoty.z));
        splitrot_program->setUniformValue("SRorg", QVector3D(SRorg.x,SRorg.y,SRorg.z));
        //printf("X>%f %f %f  Y>%f %f %f\n", screenRotx.x, screenRotx.y, screenRotx.z, screenRoty.x, screenRoty.y, screenRoty.z);
        glDrawElements(GL_LINES, (mol->splitLbonds.size() +  mol->splitRbonds.size())*2, GL_UNSIGNED_INT, nullptr);
        splitrot_program->release();
        splitrot_vao.release();
    }
    //if (parent()->objectName()!="The Main Window")
    //printf("paintGL -> %d %d %d %d\n",__LINE__,drawLabels,mol->showatoms.size(),screenAtoms.size());
    if ((drawLabels)&&(mol->showatoms.size()<=screenAtoms.size())){
        for (int i = 0; i < mol->showatoms.size(); i++){
            if (mol->showatoms.at(i).hidden) continue;
            if ((mol->showatoms.at(i).an>=0)&&((mol->AtomStyle[mol->showatoms.at(i).an]&ATOM_STYLE_NOLABEL)!=0)) continue;
            if ((mol->showatoms.at(i).an==0)&&(!hideHydrogen->isVisible())) continue;
            if ((mol->showatoms.at(i).an==-42)&&(!hideBeLo->isChecked())) continue;
            if ((mol->showatoms.at(i).an==-1)&&(mol->showatoms.at(i).peakHeight<qcutoff)) continue;
            if (i<altLabels.size()){
                renderText(screenAtoms.at(i),i);
            }
        }
    }
    if ((cont_program)&&(cont_vao.isCreated())&&(!cont.isEmpty())){
        cont_vao.bind();
        cont_program->bind();
        glDisable( GL_DEPTH_TEST );
        glEnable(GL_BLEND);
        glLineWidth(1.0);
        glEnable(GL_LINE_SMOOTH);
        //glDisable(GL_LIGHTING);
        cont_program->setUniformValue("pmv", pmv);
        cont_program->setUniformValue("origin", org);
        cont_program->setUniformValue("rainbow", rainbowPlot->isChecked());
        cont_program->setUniformValue("contMax", static_cast<float>(contMax));
        cont_program->setUniformValue("contMin", static_cast<float>(contMin));
        glDrawArrays(GL_LINES,0,cont.size());
        cont_program->release();
        cont_vao.release();
    }
    //if (parent()->objectName()!="The Main Window") printf("paintGL -> %d\n",__LINE__);
    ///maps?
    ///
    if ((map_program)&&((!fVertexes[0].isEmpty()||!fVertexes[1].isEmpty()))) {//(!habzutun)&&
      double max;
      int Pers=0;
      bool neutrons=false;
      map_vao.bind();
      map_program->bind();
      glEnable(GL_DEPTH_TEST );
      glEnable(GL_BLEND);
      glBlendFunc ( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA ) ;
      glDisable(GL_CULL_FACE);
      err = GL_NO_ERROR;
          while((err = glGetError()) != GL_NO_ERROR)
          {
            printf("%s paintGL error %X %d\n", parent()->objectName().toStdString().c_str(), err, __LINE__);
            //printf("%s\n",(char*)gluErrorString(err));
          }
      glLineWidth(linwidth);
      if (niceTrans->isChecked()){
        QMatrix4x4 mm(mvmat);
        max= (fabs(mm(2,0))>fabs(mm(2,1)))?mm(2,0):mm(2,1);
        max=(fabs(max)<fabs(mm(2,2)))?mm(2,2):max;
        if ((max==mm(2,0))&&(max>0.0)) Pers=0; else
          if ((max==mm(2,0))&&(max<0.0)) Pers=1; else
            if ((max==mm(2,1))&&(max>0.0)) Pers=2; else
              if ((max==mm(2,1))&&(max<0.0)) Pers=3; else
                if ((max==mm(2,2))&&(max>0.0)) Pers=4; else
                  if ((max==mm(2,2))&&(max<0.0)) Pers=5;
      }else Pers=0;
      if (fillMap->isChecked()) glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
      else glPolygonMode(GL_FRONT_AND_BACK,GL_LINE);
      map_program->setUniformValue("lightPos", QVector3D(100.0, 100.0, 100.0));
      map_program->setUniformValue("pmv", pmv);
      map_program->setUniformValue("origin", org);
      err = GL_NO_ERROR;
          while((err = glGetError()) != GL_NO_ERROR)
          {
            printf("%s paintGL error %X %d\n", parent()->objectName().toStdString().c_str(), err, __LINE__);
            //printf("%s\n",(char*)gluErrorString(err));
          }
      map_program->setUniformValue("normalMatrix",nm);
      map_program->setUniformValue("lintrans",static_cast<GLfloat>(lintrans));
      map_program->setUniformValue("lighting",lighting->isChecked());
      if (fofcact->isChecked()) {
        map_program->setUniformValue("Color", dipc);
        glDrawArrays(GL_TRIANGLES, offsets.at(0+4*Pers)/12, fVertexes[0+4*Pers].size()/3);
        map_program->setUniformValue("Color", dimc);
        glDrawArrays(GL_TRIANGLES, offsets.at(1+4*Pers)/12 , fVertexes[1+4*Pers].size()/3);
      }
      if (foact->isChecked()) {
        map_program->setUniformValue("Color", fopc);
        glDrawArrays(GL_TRIANGLES, offsets.at(2+4*Pers)/12, fVertexes[2+4*Pers].size()/3);
        if (neutrons){
          map_program->setUniformValue("Color", fomc);
          glDrawArrays(GL_TRIANGLES, offsets.at(3+4*Pers)/12, fVertexes[3+4*Pers].size()/3);
        }
      }
      //glEnable(GL_LIGHTING);
      glDisable(GL_BLEND);
      glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
      map_program->release();
      map_vao.release();
    }
    ///maps!
    err = GL_NO_ERROR;
        while((err = glGetError()) != GL_NO_ERROR)
        {
          printf("%s paintGL error %X %d\n", parent()->objectName().toStdString().c_str(), err, __LINE__);
          //printf("%s\n",(char*)gluErrorString(err));
        }
    if (((!mol->selectedatoms.isEmpty())||(!mol->duplicateAtoms.isEmpty())||(inFocus!=-1))&&(satom_program)){
    if (!satom_program->bind() ){qWarning() << "Could not bind shader program to context"; return;}
        slct_vao.bind();
        glDisable(GL_DEPTH_TEST);
        glDisable(GL_BLEND);
        //printf("org %f %f %f \n",org.x(),org.y(),org.z());
        satom_program->setUniformValue("pmv", pmv);
        satom_program->setUniformValue("origin", org);
        satom_program->setUniformValue("fcoord", org);
        satom_program->setUniformValue("normalMatrix",nm);
        satom_program->setUniformValue("selrad",
                                       ((mol->splitLbonds.size()+mol->splitRbonds.size())>0)?0.2f:0.35f);
        if (!mol->selectedatoms.isEmpty()) {
            satom_program->setUniformValue("Color", QColor(Qt::yellow));
            satom_program->setUniformValue("inFocus", -1);
            glDrawArrays( GL_POINTS, 0,  mol->selectedatoms.size());
        }
        if (!mol->duplicateAtoms.isEmpty()) {
            satom_program->setUniformValue("Color", QColor("#cd33ff"));
            satom_program->setUniformValue("inFocus", -2);
            glDrawArrays( GL_POINTS, mol->selectedatoms.size(),  mol->duplicateAtoms.size());
        }
        if ((inFocus!=-1)&&(inFocus<mol->showatoms.size())) {
            satom_program->setUniformValue("fcoord", QVector3D(mol->showatoms.at(inFocus).pos.x, mol->showatoms.at(inFocus).pos.y, mol->showatoms.at(inFocus).pos.z));
            satom_program->setUniformValue("origin", org);
            satom_program->setUniformValue("Color", QColor("#66cdff"));
            satom_program->setUniformValue("inFocus", inFocus);
            glDrawArrays( GL_POINTS, 0,  1);
        }
        satom_program->release();
        slct_vao.release();
    }
    err = GL_NO_ERROR;
        while((err = glGetError()) != GL_NO_ERROR)
        {
          printf("%s paintGL error %X %d\n", parent()->objectName().toStdString().c_str(), err, __LINE__);
          //printf("%s\n",(char*)gluErrorString(err));
        }

    if ((!enviPositions.isEmpty())&&(envi_program)&&(envi_vao.isCreated())){//printf("-ronment\n");
        glDisable( GL_DEPTH_TEST );
        glEnable(GL_BLEND);
        glLineWidth(1.0);
        glEnable(GL_LINE_SMOOTH);
        //glDisable(GL_LIGHTING);
        envi_vao.bind();
        envi_program->bind();
        envi_program->setUniformValue("pmv", pmv);
        envi_program->setUniformValue("origin", org);
        envi_program->setUniformValue("enviBondColor", mol->enviBondColor);
        envi_program->setUniformValue("enviHBColor", mol->enviHBColor);
        envi_program->setUniformValue("enviDefaultColor", mol->enviDefaultColor);
        glDrawArrays(GL_LINES, 0, enviPositions.size()*2);
        //glEnable(GL_LIGHTING);
        glEnable( GL_DEPTH_TEST );
        envi_program->release();
        envi_vao.release();
        for (int j=0; j < enviPositions.size(); j++ ){
            QColor c = mol->enviDefaultColor;
            switch(enviKat.at(j)){
              case 1: c = mol->enviBondColor; break;
              case 2: c = mol->enviHBColor; break;
              default:
                      c = mol->enviDefaultColor;
            }
            renderText(enviPositions.at(j)-org3, labs.at(j), c, 0xffd3d3d3);
            V3 p=(enviPositions.at(j)+enviP0)*0.5-org3;
            renderText(p, QString::number(sqrt(Distance(enviP0,enviPositions.at(j))),'f',3), c, 0);
        }
    }
//if (parent()->objectName()!="The Main Window") printf("paintGL -> %d\n",__LINE__);
    if ((uc_program)&&(togUnit->isChecked())&&(uc_vao.isCreated())){//printf("leg end\n");
        if ( !uc_program->bind() ){ qWarning() << "Could not bind shader program to context"; return;}
        uc_vao.bind();        
        glDisable(GL_DEPTH_TEST );
        glEnable(GL_BLEND);
        glLineWidth(1.0);
        glEnable(GL_LINE_SMOOTH);
        //glDisable(GL_LIGHTING);
        uc_program->setUniformValue("pmv", pmv);
        uc_program->setUniformValue("origin", org);
        uc_program->setUniformValue("cholesky", mol->cell.Cholesky);
        glDrawArrays(GL_POINTS, 0,  1);
        uc_program->release();
        uc_vao.release();
        if (drawLabels){
            V3 aa(1,0,0);
            V3 bb(0,1,0);
            V3 cc(0,0,1);
            QColor c=Qt::red;
            mol->frac2kart(aa,aa);
            mol->frac2kart(bb,bb);
            mol->frac2kart(cc,cc);
            renderText(aa-org3, "a", c, 0u);
            c=Qt::green;
            renderText(bb-org3, "b", c, 0u);
            c=Qt::blue;
            renderText(cc-org3, "c", c, 0u);
            c=Qt::black;
            renderText(V3(0,0,0)-org3, "0", c, 0u);
        }
    }
//if (parent()->objectName()!="The Main Window") printf("paintGL -> %d\n",__LINE__);
    err = GL_NO_ERROR;
        while((err = glGetError()) != GL_NO_ERROR)
        {
          printf("%s paintGL error %X %d\n", parent()->objectName().toStdString().c_str(), err, __LINE__);
          //printf("%s\n",(char*)gluErrorString(err));
        }

    if ((atom_program)&&(atomLegend->isChecked())&&(latom_vao.isCreated())){//printf("leg end\n");
        if ( !atom_program->bind() ){ qWarning() << "Could not bind shader program to context"; return;}
        latom_vao.bind();
        double fktr = retinafktr * legend_sc;
        glViewport(0, 0, 415 * fktr, qMax(950 * fktr, 1.0));
        QMatrix4x4 tm,tn;
        tm.setToIdentity();        
        tn.setToIdentity();
        //tm.ortho(-3.075, 1.075, -7.1, 2.4 ,-10,10);
        tm.ortho(-3.075, 1.075, -7.1, 2.4 ,-10,10);
        glEnable(GL_DEPTH_TEST );
        glEnable(GL_BLEND);
        glBlendFunc ( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA ) ;
        float fiftypct =1.54;
        switch (mol->proba ) {
        case 10 :{ fiftypct = 0.76; break;}   //Hauptachsen der Eliipsoide 10% Wahrscheinlichkeit
        case 30 :{ fiftypct = 1.19; break;}   //Hauptachsen der Eliipsoide 30% Wahrscheinlichkeit
        case 50 :{ fiftypct = 1.54; break;}   //Hauptachsen der Eliipsoide 50% Wahrscheinlichkeit
        case 70 :{ fiftypct = 1.91; break;}   //Hauptachsen der Eliipsoide 70% Wahrscheinlichkeit
        case 90 :{ fiftypct = 2.50; break;}   //Hauptachsen der Eliipsoide 90% Wahrscheinlichkeit
        default: ;
        }        
        atom_program->setUniformValue("normalMatrix", tn.normalMatrix());
        atom_program->setUniformValue("pmv", tm);
        atom_program->setUniformValue("origin", QVector3D(0.000000, 0.000000, 0.00000));//QVector3D(-2.750000, -6.800000, 0.00000)
        atom_program->setUniformValue("pmax", static_cast<GLfloat>(mol->pmax));
        atom_program->setUniformValue("pmin", static_cast<GLfloat>(mol->pmin));
        atom_program->setUniformValue("lightPos", QVector3D(-100,100,800));
        atom_program->setUniformValue("lmax", static_cast<GLfloat>(mol->lmax));
        atom_program->setUniformValue("lmin", static_cast<GLfloat>(mol->lmin));
        atom_program->setUniformValue("qcutoff", qcutoff);
        atom_program->setUniformValue("fiftypct", fiftypct);
        atom_program->setUniformValue("LOD", mol->LOD);
        atom_program->setUniformValue("eye", QVector4D(0.000000, 31.475019, 7.868755, 1.000000));
        atom_program->setUniformValue("adp", adp->isChecked());
        atom_program->setUniformValue("bede", hideBeLo->isChecked());
        atom_program->setUniformValue("shpm1", shpm1->isChecked());
        atom_program->setUniformValue("QPeakLegend", QPeakLegend->isChecked());
        atom_program->setUniformValue("Qolor", mol->mQolor);
        atom_program->setUniformValue("highlightParts", highlightParts->isChecked());
        atom_program->setUniformValue("hideHydrogen", !hideHydrogen->isVisible());
        atom_program->setUniformValue("bondradius", static_cast<float>(mol->bondStrength));
        atom_program->setUniformValue("tubes", tubes->isChecked());
        atom_program->setUniformValue("ballStick", ballStick->isChecked());
        atom_program->setUniformValue("qpeakrad", static_cast<GLfloat>(mol->qPeakRad*2));
        glDrawElements(GL_TRIANGLES, latom_index_size, GL_UNSIGNED_INT, nullptr);
        atom_program->release();
        latom_vao.release();
        //tm.scale(1.1);
        for (int i=0; i<mol->legendAtoms.size(); i++){
            //renderText(tm, 415, height()-10 ,mol->legendAtoms.at(i).pos, mol->legendAtoms.at(i).Label, labelColor,0xffff0000);
            if (mol->legendAtoms.at(i).hidden) continue;
            if ((mol->legendAtoms.at(i).an==0)&&!hideHydrogen->isVisible()) continue;
            renderText(QVector2D(
                           330*legend_sc + mol->legendAtoms.at(i).pos.x * 100 * legend_sc,
                           -15*legend_sc + height() - (mol->legendAtoms.at(i).pos.y + 6.7) * 104 * legend_sc),
                       mol->legendAtoms.at(i).Label, mol->legendAtoms.at(i).an, 24 * legend_sc);
        }
        glViewport(0, 0, width()*retinafktr, qMax(height()*retinafktr, 1.0));
    }
//if (parent()->objectName()!="The Main Window") printf("paintGL -> %d\n",__LINE__);

    if ((symm_program0)&&(symm_program1)&&(symm_program2)&&((axend>0)||(invend>0)||(planend>0)||(glend>0))){
        //printf("symm ->%d \n",axend);
        glEnable(GL_BLEND);
        glBlendFunc ( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA ) ;
        glEnable(GL_DEPTH_TEST );
        glDisable(GL_CULL_FACE);

        //glDisable(GL_DEPTH_TEST );
        glEnable(GL_BLEND);
        glLineWidth(1.0);
        glEnable(GL_LINE_SMOOTH);
        //glEnable(GL_LIGHTING);
        GLfloat scv[18*4];
        for (int i=0;i<18;i++) {
            scv[4*i]=mol->symmColors.at(i).redF();
            scv[4*i+1]=mol->symmColors.at(i).greenF();
            scv[4*i+2]=mol->symmColors.at(i).blueF();
            scv[4*i+3]=mol->symmColors.at(i).alphaF();
        }
        if ((symm_vao0.isCreated())&&axend){
            symm_vao0.bind();
            if ( !symm_program0->bind() ){ qWarning() << "Could not bind shader program to context"; return;}
            symm_program0->setUniformValueArray("Color",scv,18,4);//we have to this for color changes too
            symm_program0->setUniformValue("pmv", pmv);
            symm_program0->setUniformValue("origin", org);
            symm_program0->setUniformValue("normalMatrix", nm);
            symm_program0->setUniformValueArray("dontshowSymElement",mol->dontshowSel.toVector().data(),mol->dontshowSel.count());
            symm_program0->setUniformValueArray("dontshowSymOperation",mol->dontshowSop.toVector().data(),mol->dontshowSop.count());
            symm_program0->setUniformValue("dssesize", static_cast<int>(mol->dontshowSel.count()));
            symm_program0->setUniformValue("dssosize", static_cast<int>(mol->dontshowSop.count()));
            symm_program0->setUniformValue("axisThickness",axisThickness);
            glDrawArrays( GL_LINES, 0,  axend/3);
            symm_program0->release();
            symm_vao0.release();
        }
        if ((symm_vao1.isCreated())&&invend){
            symm_vao1.bind();
            //printf("inv %d centers %d\n",invend,invend/5);
            if ( !symm_program1->bind() ){ qWarning() << "Could not bind shader program to context"; return;}
            symm_program1->setUniformValueArray("Color",scv,18,4);
            symm_program1->setUniformValue("pmv", pmv);
            symm_program1->setUniformValue("origin", org);
            symm_program1->setUniformValue("normalMatrix", nm);
            symm_program1->setUniformValueArray("dontshowSymElement",mol->dontshowSel.toVector().data(),mol->dontshowSel.count());
            symm_program1->setUniformValueArray("dontshowSymOperation",mol->dontshowSop.toVector().data(),mol->dontshowSop.count());
            symm_program1->setUniformValue("dssesize", static_cast<int>(mol->dontshowSel.count()));
            symm_program1->setUniformValue("dssosize", static_cast<int>(mol->dontshowSop.count()));;
            symm_program1->setUniformValue("InversionCenterRadius", InversionCenterRadius);
            glDrawArrays( GL_POINTS, 0,  invend/5);
            symm_program1->release();
            symm_vao1.release();
        }
        if ((symm_vao2.isCreated())&&glend){
            symm_vao2.bind();
            glDisable(GL_DEPTH_TEST );
            //printf("gl %d centers %d\n",glend,planend);
            if ( !symm_program2->bind() ){ qWarning() << "Could not bind shader program to context"; return;}
            symm_program2->setUniformValueArray("Color",scv,18,4);
            symm_program2->setUniformValue("pmv", pmv);
            symm_program2->setUniformValue("origin", org);
            symm_program2->setUniformValue("normalMatrix", nm);
            symm_program2->setUniformValueArray("dontshowSymElement",mol->dontshowSel.toVector().data(),mol->dontshowSel.count());
            symm_program2->setUniformValueArray("dontshowSymOperation",mol->dontshowSop.toVector().data(),mol->dontshowSop.count());
            symm_program2->setUniformValue("dssesize", static_cast<int>(mol->dontshowSel.count()));
            symm_program2->setUniformValue("dssosize", static_cast<int>(mol->dontshowSop.count()));;
            symm_program2->setUniformValue("planeTransparence", planeTransparence);
            symm_program2->setUniformValue("glideVectorThickness", glideVectorThickness);
            symm_program2->setUniformValue("planeFrameThinkness", planeFrameThinkness);

            glDrawArrays( GL_POINTS, 0,  glend/17);
            symm_program2->release();
            symm_vao2.release();
        }
    }
//    if (parent()->objectName()!="The Main Window") printf("paintGL -> %d valid %d widget %d\n",__LINE__,context()->isValid(),context()->isWidgetType());

    if ((voro_vao.isCreated())&&(voro_program)){
        if ( !voro_program->bind() ){ qWarning() << "Could not bind shader program to context"; return;}
        voro_vao.bind();
        glEnable(GL_BLEND);
        glBlendFunc ( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA ) ;
        glEnable(GL_DEPTH_TEST );
        glDisable(GL_CULL_FACE);
        glPolygonMode(GL_FRONT_AND_BACK,GL_FILL);
        voro_program->setUniformValue("pmv", pmv);
        voro_program->setUniformValue("origin", org);
        voro_program->setUniformValue("normalMatrix", nm);
        glDrawArrays( GL_POINTS, 0,  vtriangles.size());
        voro_program->release();
        voro_vao.release();
    }    

    if ((!mol->selectedatoms.isEmpty())&&(mol->splitLbonds.isEmpty())){
        for (int i=0; i<mol->selectedatoms.size(); i++){
            if (mol->selectedatoms.at(i).hidden) continue;
            QColor c = selectedLabelColor ;
            QString label = mol->selectedatoms.at(i).Label;
            if (shortLabels->isChecked()) {
              label=label.section("_",0,0);
              label=label.section(QString::fromUtf8("»"),0,0);
            }
            renderText(mol->selectedatoms.at(i).pos-org3, label, c, selectedLabelBGColor.rgba());
        }
    }
    err = GL_NO_ERROR;
        while((err = glGetError()) != GL_NO_ERROR)
        {
          printf("%s paintGL error %X %d\n", parent()->objectName().toStdString().c_str(), err, __LINE__);
          //printf("%s\n",(char*)gluErrorString(err));
        }
    if ((inFocus!=-1)&&(inFocus<mol->showatoms.size())){
        QString label = mol->showatoms.at(inFocus).Label;
        if (shortLabels->isChecked()) {
          label=label.section("_",0,0);
          label=label.section(QString::fromUtf8("»"),0,0);
        }
        renderText(screenAtoms.at(inFocus), label, mol->showatoms.at(inFocus).an);
    }
    err = GL_NO_ERROR;
        while((err = glGetError()) != GL_NO_ERROR)
        {
          printf("%s paintGL error %X %d\n", parent()->objectName().toStdString().c_str(), err, __LINE__);
          //printf("%s\n",(char*)gluErrorString(err));
        }
    if (parent()->objectName()=="Edit Atom Parameters Dialog"){
        QString label = mol->showatoms.at(0).Label;
        if (shortLabels->isChecked()) {
          label=label.section("_",0,0);
          label=label.section(QString::fromUtf8("»"),0,0);
        }
        renderText(screenAtoms.at(0), label, mol->showatoms.at(0).an);
        label = mol->showatoms.at(1).Label;
        if (shortLabels->isChecked()) {
          label=label.section("_",0,0);
          label=label.section(QString::fromUtf8("»"),0,0);
        }
        renderText(screenAtoms.at(1), label, mol->showatoms.at(1).an);
    }
    err = GL_NO_ERROR;
        while((err = glGetError()) != GL_NO_ERROR)
        {
          printf("%s paintGL error %X %d\n", parent()->objectName().toStdString().c_str(), err, __LINE__);
          //printf("%s\n",(char*)gluErrorString(err));
        }

    if (burnGPU) update();

    //printf("paintGL <-\n");
}
