#ifndef GLUREPLACE_H
#define GLUREPLACE_H
#include <QGLWidget>
#include <math.h>
///////////////replaceing glu.h
///
inline void gluLookAt_(GLfloat eyex, GLfloat eyey, GLfloat eyez, GLfloat centerx,
      GLfloat centery, GLfloat centerz, GLfloat upx, GLfloat upy,
      GLfloat upz){
    float forward[3], side[3], up[3];
    GLfloat m[4][4];
    forward[0] = centerx - eyex;
    forward[1] = centery - eyey;
    forward[2] = centerz - eyez;
    up[0] = upx;
    up[1] = upy;
    up[2] = upz;
    float nrm=sqrt(forward[0]*forward[0]+forward[1]*forward[1]+forward[2]*forward[2]);
    forward[0]/=nrm;
    forward[1]/=nrm;
    forward[2]/=nrm;
    //normalize(forward);
    /* Side = forward x up */

    side[0] = forward[1]*up[2] - up[1]*forward[2];
    side[1] = forward[2]*up[0] - up[2]*forward[0];
    side[2] = forward[0]*up[1] - up[0]*forward[1];
    //cross(forward, up, side);
    nrm=sqrt(side[0]*side[0]+side[1]*side[1]+side[2]*side[2]);
        side[0]/=nrm;
        side[1]/=nrm;
        side[2]/=nrm;
    //normalize(side);
    /* Recompute up as: up = side x forward */
        up[1] = side[2]*forward[0] - forward[2]*side[0];
        up[2] = side[0]*forward[1] - forward[0]*side[1];
        up[0] = side[1]*forward[2] - forward[1]*side[2];
    //cross(side, forward, up);
    //__gluMakeIdentityf(&m[0][0]);
    m[0][0] = side[0];
    m[1][0] = side[1];
    m[2][0] = side[2];
    m[3][0] = 0;
    m[0][1] = up[0];
    m[1][1] = up[1];
    m[2][1] = up[2];
    m[3][1] = 0;
    m[0][2] = -forward[0];
    m[1][2] = -forward[1];
    m[2][2] = -forward[2];
    m[3][2] = 0;
    m[0][3] = 0;
    m[1][3] = 0;
    m[2][3] = 0;
    m[3][3] = 1;
    glMultMatrixf(&m[0][0]);
    glTranslatef(-eyex, -eyey, -eyez);
}
inline void gluPerspective_(GLdouble fovyInDegrees, GLdouble aspectRatio,
                   GLdouble znear, GLdouble zfar){
    GLdouble ymax, xmax;
    ymax = znear * tan(fovyInDegrees * M_PI / 360.0);
        // ymin = -ymax;
        // xmin = -ymax * aspectRatio;
    xmax = ymax * aspectRatio;
    glFrustum(-xmax, xmax, -ymax, ymax, znear, zfar);
}
///
////////////////////////////////
#endif // GLUREPLACE_H
