// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Interface_ShareFlags_HeaderFile
#define _Interface_ShareFlags_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Handle_Interface_InterfaceModel.hxx>
#include <Interface_BitMap.hxx>
#include <Handle_TColStd_HSequenceOfTransient.hxx>
#include <Handle_Interface_GTool.hxx>
#include <Handle_Interface_Protocol.hxx>
#include <Standard_Boolean.hxx>
#include <Handle_Standard_Transient.hxx>
#include <Standard_Integer.hxx>
class Interface_InterfaceModel;
class TColStd_HSequenceOfTransient;
class Standard_DomainError;
class Standard_OutOfRange;
class Interface_GeneralLib;
class Interface_GTool;
class Interface_Protocol;
class Interface_Graph;
class Standard_Transient;
class Interface_EntityIterator;


//! This class only says for each Entity of a Model, if it is
//! Shared or not by one or more other(s) of this Model
//! It uses the General Service "Shared".
class Interface_ShareFlags 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Creates a ShareFlags from a Model and builds required data
  //! (flags) by calling the General Service Library given as
  //! argument <lib>
  Standard_EXPORT Interface_ShareFlags(const Handle(Interface_InterfaceModel)& amodel, const Interface_GeneralLib& lib);
  
  //! Same as above, but GeneralLib is detained by a GTool
  Standard_EXPORT Interface_ShareFlags(const Handle(Interface_InterfaceModel)& amodel, const Handle(Interface_GTool)& gtool);
  
  //! Same as above, but GeneralLib is defined through a Protocol
  Standard_EXPORT Interface_ShareFlags(const Handle(Interface_InterfaceModel)& amodel, const Handle(Interface_Protocol)& protocol);
  
  //! Same as above, but works with the GTool of the Model
  Standard_EXPORT Interface_ShareFlags(const Handle(Interface_InterfaceModel)& amodel);
  
  //! Creates a ShareFlags by querying informations from a Graph
  //! (remark that Graph also has a method IsShared)
  Standard_EXPORT Interface_ShareFlags(const Interface_Graph& agraph);
  
  //! Returns the Model used for the evaluation
  Standard_EXPORT   Handle(Interface_InterfaceModel) Model()  const;
  
  //! Returns True if <ent> is Shared by one or more other
  //! Entity(ies) of the Model
  Standard_EXPORT   Standard_Boolean IsShared (const Handle(Standard_Transient)& ent)  const;
  
  //! Returns the Entities which are not Shared (see their flags)
  Standard_EXPORT   Interface_EntityIterator RootEntities()  const;
  
  //! Returns the count of root entities
  Standard_EXPORT   Standard_Integer NbRoots()  const;
  
  //! Returns a root entity according its rank in the list of roots
  //! By default, it returns the first one
  Standard_EXPORT   Handle(Standard_Transient) Root (const Standard_Integer num = 1)  const;




protected:





private:

  
  //! Computes flags at Creation time
  //!
  //! Normally, gtool suffices. But if a Graph is created from a
  //! GeneralLib directly, it cannot be used
  //! If <gtool> is defined, it has priority
  Standard_EXPORT   void Evaluate (const Interface_GeneralLib& lib, const Handle(Interface_GTool)& gtool) ;


  Handle(Interface_InterfaceModel) themodel;
  Interface_BitMap theflags;
  Handle(TColStd_HSequenceOfTransient) theroots;


};







#endif // _Interface_ShareFlags_HeaderFile
