/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.qa.form;

import javax.swing.JDialog;
import org.netbeans.jemmy.operators.*;

/**
 * Class implementing all necessary methods for handling "Select Palette Category" NbDialog.
 * Most parts of code are generated by jelly tools.* 
 *
 * @author Jiri Vagner
 */
public class SelectPaletteCategoryOperator extends JDialogOperator {

    private JLabelOperator _lblPaletteCategories;
    private JListOperator _lstPaletteCategories;
    public static final String ITEM_SWINGCONTAINERS = "Swing Containers"; // NOI18N
    public static final String ITEM_SWINGCONTROLS = "Swing Controls"; // NOI18N
    public static final String ITEM_SWINGMENUS = "Swing Menus"; // NOI18N
    public static final String ITEM_SWINGWINDOWS = "Swing Windows"; // NOI18N
    public static final String ITEM_AWT = "AWT"; // NOI18N
    public static final String ITEM_BORDERS = "Borders"; // NOI18N
    public static final String ITEM_BEANS = "Beans"; // NOI18N
    public static final String ITEM_LOOKANDFEELS = "Look and Feels"; // NOI18N
    private JButtonOperator _btOK;
    private JButtonOperator _btCancel;

    /** Creates new SelectPaletteCategory that can handle it.
     */
    public SelectPaletteCategoryOperator() {
        super("Select Palette Category"); // NOI18N
    }
    
    /**
     * Creates new SelectPaletteCategory using title name
     * @param title
     */
    public SelectPaletteCategoryOperator(String title) {
        super(title);
    }
    
    /**
     * Creates new instance using existing JDialog operator
     * @param wrapper 
     */
    public SelectPaletteCategoryOperator(JDialogOperator wrapper) {
        super((JDialog)wrapper.getSource());
    }

    //******************************
    // Subcomponents definition part
    //******************************

    /** Tries to find "Palette Categories:" JLabel in this dialog.
     * @return JLabelOperator
     */
    public JLabelOperator lblPaletteCategories() {
        if (_lblPaletteCategories==null) {
            _lblPaletteCategories = new JLabelOperator(this, "Palette Categories:");  // NOI18N
        }
        return _lblPaletteCategories;
    }

    /** Tries to find null ListView$NbList in this dialog.
     * @return JListOperator
     */
    public JListOperator lstPaletteCategories() {
        if (_lstPaletteCategories==null) {
            _lstPaletteCategories = new JListOperator(this);
        }
        return _lstPaletteCategories;
    }

    /** Tries to find "OK" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btOK() {
        if (_btOK==null) {
            _btOK = new JButtonOperator(this, "OK"); // NOI18N
        }
        return _btOK;
    }

    /** Tries to find "Cancel" JButton in this dialog.
     * @return JButtonOperator
     */
    public JButtonOperator btCancel() {
        if (_btCancel==null) {
            _btCancel = new JButtonOperator(this, "Cancel"); // NOI18N
        }
        return _btCancel;
    }


    //****************************************
    // Low-level functionality definition part
    //****************************************

    /** clicks on "OK" JButton
     */
    public void ok() {
        btOK().push();
    }

    /** clicks on "Cancel" JButton
     */
    public void cancel() {
        btCancel().push();
    }


    //*****************************************
    // High-level functionality definition part
    //*****************************************

    /** Performs verification of SelectPaletteCategory by accessing all its components.
     */
    public void verify() {
        lblPaletteCategories();
        lstPaletteCategories();
        btOK();
        btCancel();
    }
}

