// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The resource hierarchy is changing.
type ConcurrentModificationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConcurrentModificationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConcurrentModificationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConcurrentModificationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConcurrentModificationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Another operation is in progress on the resource that conflicts with the
// current operation.
type ConflictingOperationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConflictingOperationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConflictingOperationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConflictingOperationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConflictingOperationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConflictingOperationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The limit has been reached on the number of custom properties for the specified
// resource.
type CustomMetadataLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CustomMetadataLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CustomMetadataLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CustomMetadataLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CustomMetadataLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *CustomMetadataLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The last user in the organization is being deactivated.
type DeactivatingLastSystemUserException struct {
	Message *string

	ErrorCodeOverride *string

	Code *string

	noSmithyDocumentSerde
}

func (e *DeactivatingLastSystemUserException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DeactivatingLastSystemUserException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DeactivatingLastSystemUserException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DeactivatingLastSystemUserException"
	}
	return *e.ErrorCodeOverride
}
func (e *DeactivatingLastSystemUserException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This exception is thrown when the document is locked for comments and user
// tries to create or delete a comment on that document.
type DocumentLockedForCommentsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DocumentLockedForCommentsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DocumentLockedForCommentsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DocumentLockedForCommentsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DocumentLockedForCommentsException"
	}
	return *e.ErrorCodeOverride
}
func (e *DocumentLockedForCommentsException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// This exception is thrown when a valid checkout ID is not presented on document
// version upload calls for a document that has been checked out from Web client.
type DraftUploadOutOfSyncException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DraftUploadOutOfSyncException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DraftUploadOutOfSyncException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DraftUploadOutOfSyncException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "DraftUploadOutOfSyncException"
	}
	return *e.ErrorCodeOverride
}
func (e *DraftUploadOutOfSyncException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource already exists.
type EntityAlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *EntityAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EntityAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EntityAlreadyExistsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EntityAlreadyExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *EntityAlreadyExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource does not exist.
type EntityNotExistsException struct {
	Message *string

	ErrorCodeOverride *string

	EntityIds []string

	noSmithyDocumentSerde
}

func (e *EntityNotExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EntityNotExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EntityNotExistsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EntityNotExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *EntityNotExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The Directory Service cannot reach an on-premises instance. Or a dependency
// under the control of the organization is failing, such as a connected Active
// Directory.
type FailedDependencyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FailedDependencyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FailedDependencyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FailedDependencyException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "FailedDependencyException"
	}
	return *e.ErrorCodeOverride
}
func (e *FailedDependencyException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The user is undergoing transfer of ownership.
type IllegalUserStateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IllegalUserStateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IllegalUserStateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IllegalUserStateException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IllegalUserStateException"
	}
	return *e.ErrorCodeOverride
}
func (e *IllegalUserStateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The pagination marker or limit fields are not valid.
type InvalidArgumentException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidArgumentException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidArgumentException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidArgumentException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidArgumentException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested operation is not allowed on the specified comment object.
type InvalidCommentOperationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidCommentOperationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidCommentOperationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidCommentOperationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidCommentOperationException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidCommentOperationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation is invalid.
type InvalidOperationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidOperationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidOperationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidOperationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidOperationException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidOperationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The password is invalid.
type InvalidPasswordException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidPasswordException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidPasswordException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidPasswordException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidPasswordException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidPasswordException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The maximum of 100,000 files and folders under the parent folder has been
// exceeded.
type LimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *LimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *LimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "LimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *LimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified document version is not in the INITIALIZED state.
type ProhibitedStateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ProhibitedStateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ProhibitedStateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ProhibitedStateException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ProhibitedStateException"
	}
	return *e.ErrorCodeOverride
}
func (e *ProhibitedStateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The response is too large to return. The request must include a filter to
// reduce the size of the response.
type RequestedEntityTooLargeException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *RequestedEntityTooLargeException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *RequestedEntityTooLargeException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *RequestedEntityTooLargeException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "RequestedEntityTooLargeException"
	}
	return *e.ErrorCodeOverride
}
func (e *RequestedEntityTooLargeException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource is already checked out.
type ResourceAlreadyCheckedOutException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceAlreadyCheckedOutException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceAlreadyCheckedOutException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceAlreadyCheckedOutException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceAlreadyCheckedOutException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceAlreadyCheckedOutException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// One or more of the dependencies is unavailable.
type ServiceUnavailableException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ServiceUnavailableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ServiceUnavailableException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ServiceUnavailableException"
	}
	return *e.ErrorCodeOverride
}
func (e *ServiceUnavailableException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The storage limit has been exceeded.
type StorageLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *StorageLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *StorageLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *StorageLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "StorageLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *StorageLimitExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The storage limit will be exceeded.
type StorageLimitWillExceedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *StorageLimitWillExceedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *StorageLimitWillExceedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *StorageLimitWillExceedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "StorageLimitWillExceedException"
	}
	return *e.ErrorCodeOverride
}
func (e *StorageLimitWillExceedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The limit has been reached on the number of labels for the specified resource.
type TooManyLabelsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManyLabelsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyLabelsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyLabelsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyLabelsException"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyLabelsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// You've reached the limit on the number of subscriptions for the WorkDocs
// instance.
type TooManySubscriptionsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TooManySubscriptionsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManySubscriptionsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManySubscriptionsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManySubscriptionsException"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManySubscriptionsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation is not permitted.
type UnauthorizedOperationException struct {
	Message *string

	ErrorCodeOverride *string

	Code *string

	noSmithyDocumentSerde
}

func (e *UnauthorizedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnauthorizedOperationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnauthorizedOperationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnauthorizedOperationException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnauthorizedOperationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The caller does not have access to perform the action on the resource.
type UnauthorizedResourceAccessException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnauthorizedResourceAccessException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnauthorizedResourceAccessException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnauthorizedResourceAccessException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "UnauthorizedResourceAccessException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnauthorizedResourceAccessException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}
