//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armservicelinker

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AzureKeyVaultProperties.
func (a AzureKeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "connectAsKubernetesCsiDriver", a.ConnectAsKubernetesCsiDriver)
	objectMap["type"] = AzureResourceTypeKeyVault
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureKeyVaultProperties.
func (a *AzureKeyVaultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "connectAsKubernetesCsiDriver":
			err = unpopulate(val, "ConnectAsKubernetesCsiDriver", &a.ConnectAsKubernetesCsiDriver)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureResource.
func (a AzureResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", a.ID)
	populate(objectMap, "resourceProperties", a.ResourceProperties)
	objectMap["type"] = TargetServiceTypeAzureResource
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureResource.
func (a *AzureResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "resourceProperties":
			a.ResourceProperties, err = unmarshalAzureResourcePropertiesBaseClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfluentBootstrapServer.
func (c ConfluentBootstrapServer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "endpoint", c.Endpoint)
	objectMap["type"] = TargetServiceTypeConfluentBootstrapServer
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfluentBootstrapServer.
func (c *ConfluentBootstrapServer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpoint":
			err = unpopulate(val, "Endpoint", &c.Endpoint)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ConfluentSchemaRegistry.
func (c ConfluentSchemaRegistry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "endpoint", c.Endpoint)
	objectMap["type"] = TargetServiceTypeConfluentSchemaRegistry
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ConfluentSchemaRegistry.
func (c *ConfluentSchemaRegistry) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpoint":
			err = unpopulate(val, "Endpoint", &c.Endpoint)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultSecretReferenceSecretInfo.
func (k KeyVaultSecretReferenceSecretInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "name", k.Name)
	objectMap["secretType"] = SecretTypeKeyVaultSecretReference
	populate(objectMap, "version", k.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultSecretReferenceSecretInfo.
func (k *KeyVaultSecretReferenceSecretInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "secretType":
			err = unpopulate(val, "SecretType", &k.SecretType)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &k.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KeyVaultSecretURISecretInfo.
func (k KeyVaultSecretURISecretInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["secretType"] = SecretTypeKeyVaultSecretURI
	populate(objectMap, "value", k.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KeyVaultSecretURISecretInfo.
func (k *KeyVaultSecretURISecretInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secretType":
			err = unpopulate(val, "SecretType", &k.SecretType)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &k.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinkerPatch.
func (l LinkerPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "properties", l.Properties)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type LinkerProperties.
func (l LinkerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "authInfo", l.AuthInfo)
	populate(objectMap, "clientType", l.ClientType)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "scope", l.Scope)
	populate(objectMap, "secretStore", l.SecretStore)
	populate(objectMap, "targetService", l.TargetService)
	populate(objectMap, "vNetSolution", l.VNetSolution)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinkerProperties.
func (l *LinkerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authInfo":
			l.AuthInfo, err = unmarshalAuthInfoBaseClassification(val)
			delete(rawMsg, key)
		case "clientType":
			err = unpopulate(val, "ClientType", &l.ClientType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &l.Scope)
			delete(rawMsg, key)
		case "secretStore":
			err = unpopulate(val, "SecretStore", &l.SecretStore)
			delete(rawMsg, key)
		case "targetService":
			l.TargetService, err = unmarshalTargetServiceBaseClassification(val)
			delete(rawMsg, key)
		case "vNetSolution":
			err = unpopulate(val, "VNetSolution", &l.VNetSolution)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretAuthInfo.
func (s SecretAuthInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["authType"] = AuthTypeSecret
	populate(objectMap, "name", s.Name)
	populate(objectMap, "secretInfo", s.SecretInfo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretAuthInfo.
func (s *SecretAuthInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authType":
			err = unpopulate(val, "AuthType", &s.AuthType)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "secretInfo":
			s.SecretInfo, err = unmarshalSecretInfoBaseClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServicePrincipalCertificateAuthInfo.
func (s ServicePrincipalCertificateAuthInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["authType"] = AuthTypeServicePrincipalCertificate
	populate(objectMap, "certificate", s.Certificate)
	populate(objectMap, "clientId", s.ClientID)
	populate(objectMap, "principalId", s.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServicePrincipalCertificateAuthInfo.
func (s *ServicePrincipalCertificateAuthInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authType":
			err = unpopulate(val, "AuthType", &s.AuthType)
			delete(rawMsg, key)
		case "certificate":
			err = unpopulate(val, "Certificate", &s.Certificate)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &s.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &s.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServicePrincipalSecretAuthInfo.
func (s ServicePrincipalSecretAuthInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["authType"] = AuthTypeServicePrincipalSecret
	populate(objectMap, "clientId", s.ClientID)
	populate(objectMap, "principalId", s.PrincipalID)
	populate(objectMap, "secret", s.Secret)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServicePrincipalSecretAuthInfo.
func (s *ServicePrincipalSecretAuthInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authType":
			err = unpopulate(val, "AuthType", &s.AuthType)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &s.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &s.PrincipalID)
			delete(rawMsg, key)
		case "secret":
			err = unpopulate(val, "Secret", &s.Secret)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemAssignedIdentityAuthInfo.
func (s SystemAssignedIdentityAuthInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["authType"] = AuthTypeSystemAssignedIdentity
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemAssignedIdentityAuthInfo.
func (s *SystemAssignedIdentityAuthInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authType":
			err = unpopulate(val, "AuthType", &s.AuthType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentityAuthInfo.
func (u UserAssignedIdentityAuthInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["authType"] = AuthTypeUserAssignedIdentity
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "subscriptionId", u.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentityAuthInfo.
func (u *UserAssignedIdentityAuthInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authType":
			err = unpopulate(val, "AuthType", &u.AuthType)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &u.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValidateResult.
func (v *ValidateResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authType":
			err = unpopulate(val, "AuthType", &v.AuthType)
			delete(rawMsg, key)
		case "isConnectionAvailable":
			err = unpopulate(val, "IsConnectionAvailable", &v.IsConnectionAvailable)
			delete(rawMsg, key)
		case "linkerName":
			err = unpopulate(val, "LinkerName", &v.LinkerName)
			delete(rawMsg, key)
		case "reportEndTimeUtc":
			err = unpopulateTimeRFC3339(val, "ReportEndTimeUTC", &v.ReportEndTimeUTC)
			delete(rawMsg, key)
		case "reportStartTimeUtc":
			err = unpopulateTimeRFC3339(val, "ReportStartTimeUTC", &v.ReportStartTimeUTC)
			delete(rawMsg, key)
		case "sourceId":
			err = unpopulate(val, "SourceID", &v.SourceID)
			delete(rawMsg, key)
		case "targetId":
			err = unpopulate(val, "TargetID", &v.TargetID)
			delete(rawMsg, key)
		case "validationDetail":
			err = unpopulate(val, "ValidationDetail", &v.ValidationDetail)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ValueSecretInfo.
func (v ValueSecretInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["secretType"] = SecretTypeRawValue
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ValueSecretInfo.
func (v *ValueSecretInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secretType":
			err = unpopulate(val, "SecretType", &v.SecretType)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
