//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurityinsights

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// EntitiesGetTimelineClient contains the methods for the EntitiesGetTimeline group.
// Don't use this type directly, use NewEntitiesGetTimelineClient() instead.
type EntitiesGetTimelineClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewEntitiesGetTimelineClient creates a new instance of EntitiesGetTimelineClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewEntitiesGetTimelineClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*EntitiesGetTimelineClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &EntitiesGetTimelineClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// List - Timeline for an entity.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2022-09-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// workspaceName - The name of the workspace.
// entityID - entity ID
// parameters - The parameters required to execute an timeline operation on the given entity.
// options - EntitiesGetTimelineClientListOptions contains the optional parameters for the EntitiesGetTimelineClient.List
// method.
func (client *EntitiesGetTimelineClient) List(ctx context.Context, resourceGroupName string, workspaceName string, entityID string, parameters EntityTimelineParameters, options *EntitiesGetTimelineClientListOptions) (EntitiesGetTimelineClientListResponse, error) {
	req, err := client.listCreateRequest(ctx, resourceGroupName, workspaceName, entityID, parameters, options)
	if err != nil {
		return EntitiesGetTimelineClientListResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return EntitiesGetTimelineClientListResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return EntitiesGetTimelineClientListResponse{}, runtime.NewResponseError(resp)
	}
	return client.listHandleResponse(resp)
}

// listCreateRequest creates the List request.
func (client *EntitiesGetTimelineClient) listCreateRequest(ctx context.Context, resourceGroupName string, workspaceName string, entityID string, parameters EntityTimelineParameters, options *EntitiesGetTimelineClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}/getTimeline"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if workspaceName == "" {
		return nil, errors.New("parameter workspaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workspaceName}", url.PathEscape(workspaceName))
	if entityID == "" {
		return nil, errors.New("parameter entityID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{entityId}", url.PathEscape(entityID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// listHandleResponse handles the List response.
func (client *EntitiesGetTimelineClient) listHandleResponse(resp *http.Response) (EntitiesGetTimelineClientListResponse, error) {
	result := EntitiesGetTimelineClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.EntityTimelineResponse); err != nil {
		return EntitiesGetTimelineClientListResponse{}, err
	}
	return result, nil
}
