//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpolicyinsights

import "time"

// Attestation - An attestation resource.
type Attestation struct {
	// REQUIRED; Properties for the attestation.
	Properties *AttestationProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AttestationEvidence - A piece of evidence supporting the compliance state set in the attestation.
type AttestationEvidence struct {
	// The description for this piece of evidence.
	Description *string `json:"description,omitempty"`

	// The URI location of the evidence.
	SourceURI *string `json:"sourceUri,omitempty"`
}

// AttestationListResult - List of attestations.
type AttestationListResult struct {
	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of attestation definitions.
	Value []*Attestation `json:"value,omitempty" azure:"ro"`
}

// AttestationProperties - The properties of an attestation resource.
type AttestationProperties struct {
	// REQUIRED; The resource ID of the policy assignment that the attestation is setting the state for.
	PolicyAssignmentID *string `json:"policyAssignmentId,omitempty"`

	// The time the evidence was assessed
	AssessmentDate *time.Time `json:"assessmentDate,omitempty"`

	// Comments describing why this attestation was created.
	Comments *string `json:"comments,omitempty"`

	// The compliance state that should be set on the resource.
	ComplianceState *ComplianceState `json:"complianceState,omitempty"`

	// The evidence supporting the compliance state set in this attestation.
	Evidence []*AttestationEvidence `json:"evidence,omitempty"`

	// The time the compliance state should expire.
	ExpiresOn *time.Time `json:"expiresOn,omitempty"`

	// Additional metadata for this attestation
	Metadata interface{} `json:"metadata,omitempty"`

	// The person responsible for setting the state of the resource. This value is typically an Azure Active Directory object
	// ID.
	Owner *string `json:"owner,omitempty"`

	// The policy definition reference ID from a policy set definition that the attestation is setting the state for. If the policy
	// assignment assigns a policy set definition the attestation can choose a
	// definition within the set definition with this property or omit this and set the state for the entire set definition.
	PolicyDefinitionReferenceID *string `json:"policyDefinitionReferenceId,omitempty"`

	// READ-ONLY; The time the compliance state was last changed in this attestation.
	LastComplianceStateChangeAt *time.Time `json:"lastComplianceStateChangeAt,omitempty" azure:"ro"`

	// READ-ONLY; The status of the attestation.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// AttestationsClientBeginCreateOrUpdateAtResourceGroupOptions contains the optional parameters for the AttestationsClient.BeginCreateOrUpdateAtResourceGroup
// method.
type AttestationsClientBeginCreateOrUpdateAtResourceGroupOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AttestationsClientBeginCreateOrUpdateAtResourceOptions contains the optional parameters for the AttestationsClient.BeginCreateOrUpdateAtResource
// method.
type AttestationsClientBeginCreateOrUpdateAtResourceOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AttestationsClientBeginCreateOrUpdateAtSubscriptionOptions contains the optional parameters for the AttestationsClient.BeginCreateOrUpdateAtSubscription
// method.
type AttestationsClientBeginCreateOrUpdateAtSubscriptionOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AttestationsClientDeleteAtResourceGroupOptions contains the optional parameters for the AttestationsClient.DeleteAtResourceGroup
// method.
type AttestationsClientDeleteAtResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AttestationsClientDeleteAtResourceOptions contains the optional parameters for the AttestationsClient.DeleteAtResource
// method.
type AttestationsClientDeleteAtResourceOptions struct {
	// placeholder for future optional parameters
}

// AttestationsClientDeleteAtSubscriptionOptions contains the optional parameters for the AttestationsClient.DeleteAtSubscription
// method.
type AttestationsClientDeleteAtSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// AttestationsClientGetAtResourceGroupOptions contains the optional parameters for the AttestationsClient.GetAtResourceGroup
// method.
type AttestationsClientGetAtResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AttestationsClientGetAtResourceOptions contains the optional parameters for the AttestationsClient.GetAtResource method.
type AttestationsClientGetAtResourceOptions struct {
	// placeholder for future optional parameters
}

// AttestationsClientGetAtSubscriptionOptions contains the optional parameters for the AttestationsClient.GetAtSubscription
// method.
type AttestationsClientGetAtSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// AttestationsClientListForResourceGroupOptions contains the optional parameters for the AttestationsClient.ListForResourceGroup
// method.
type AttestationsClientListForResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// AttestationsClientListForResourceOptions contains the optional parameters for the AttestationsClient.ListForResource method.
type AttestationsClientListForResourceOptions struct {
	// placeholder for future optional parameters
}

// AttestationsClientListForSubscriptionOptions contains the optional parameters for the AttestationsClient.ListForSubscription
// method.
type AttestationsClientListForSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// CheckManagementGroupRestrictionsRequest - The check policy restrictions parameters describing the resource that is being
// evaluated.
type CheckManagementGroupRestrictionsRequest struct {
	// The list of fields and values that should be evaluated for potential restrictions.
	PendingFields []*PendingField `json:"pendingFields,omitempty"`

	// The information about the resource that will be evaluated.
	ResourceDetails *CheckRestrictionsResourceDetails `json:"resourceDetails,omitempty"`
}

// CheckRestrictionsRequest - The check policy restrictions parameters describing the resource that is being evaluated.
type CheckRestrictionsRequest struct {
	// REQUIRED; The information about the resource that will be evaluated.
	ResourceDetails *CheckRestrictionsResourceDetails `json:"resourceDetails,omitempty"`

	// The list of fields and values that should be evaluated for potential restrictions.
	PendingFields []*PendingField `json:"pendingFields,omitempty"`
}

// CheckRestrictionsResourceDetails - The information about the resource that will be evaluated.
type CheckRestrictionsResourceDetails struct {
	// REQUIRED; The resource content. This should include whatever properties are already known and can be a partial set of all
	// resource properties.
	ResourceContent interface{} `json:"resourceContent,omitempty"`

	// The api-version of the resource content.
	APIVersion *string `json:"apiVersion,omitempty"`

	// The scope where the resource is being created. For example, if the resource is a child resource this would be the parent
	// resource's resource ID.
	Scope *string `json:"scope,omitempty"`
}

// CheckRestrictionsResult - The result of a check policy restrictions evaluation on a resource.
type CheckRestrictionsResult struct {
	// READ-ONLY; Evaluation results for the provided partial resource content.
	ContentEvaluationResult *CheckRestrictionsResultContentEvaluationResult `json:"contentEvaluationResult,omitempty" azure:"ro"`

	// READ-ONLY; The restrictions that will be placed on various fields in the resource by policy.
	FieldRestrictions []*FieldRestrictions `json:"fieldRestrictions,omitempty" azure:"ro"`
}

// CheckRestrictionsResultContentEvaluationResult - Evaluation results for the provided partial resource content.
type CheckRestrictionsResultContentEvaluationResult struct {
	// Policy evaluation results against the given resource content. This will indicate if the partial content that was provided
	// will be denied as-is.
	PolicyEvaluations []*PolicyEvaluationResult `json:"policyEvaluations,omitempty"`
}

// ComplianceDetail - The compliance state rollup.
type ComplianceDetail struct {
	// The compliance state.
	ComplianceState *string `json:"complianceState,omitempty"`

	// Summarized count value for this compliance state.
	Count *int32 `json:"count,omitempty"`
}

// ComponentEventDetails - Component event details.
type ComponentEventDetails struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Component Id.
	ID *string `json:"id,omitempty"`

	// Component name.
	Name *string `json:"name,omitempty"`

	// Policy definition action, i.e. effect.
	PolicyDefinitionAction *string `json:"policyDefinitionAction,omitempty"`

	// Principal object ID for the user who initiated the resource component operation that triggered the policy event.
	PrincipalOid *string `json:"principalOid,omitempty"`

	// Tenant ID for the policy event record.
	TenantID *string `json:"tenantId,omitempty"`

	// Timestamp for component policy event record.
	Timestamp *time.Time `json:"timestamp,omitempty"`

	// Component type.
	Type *string `json:"type,omitempty"`
}

// ComponentStateDetails - Component state details.
type ComponentStateDetails struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Component compliance state.
	ComplianceState *string `json:"complianceState,omitempty"`

	// Component Id.
	ID *string `json:"id,omitempty"`

	// Component name.
	Name *string `json:"name,omitempty"`

	// Component compliance evaluation timestamp.
	Timestamp *time.Time `json:"timestamp,omitempty"`

	// Component type.
	Type *string `json:"type,omitempty"`
}

// ErrorDefinition - Error definition.
type ErrorDefinition struct {
	// READ-ONLY; Additional scenario specific error details.
	AdditionalInfo []*TypedErrorInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Internal error details.
	Details []*ErrorDefinition `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; Description of the error.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The target of the error.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorDefinitionAutoGenerated - Error definition.
type ErrorDefinitionAutoGenerated struct {
	// READ-ONLY; Additional scenario specific error details.
	AdditionalInfo []*TypedErrorInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Internal error details.
	Details []*ErrorDefinitionAutoGenerated `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; Description of the error.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The target of the error.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorDefinitionAutoGenerated2 - Error definition.
type ErrorDefinitionAutoGenerated2 struct {
	// READ-ONLY; Additional scenario specific error details.
	AdditionalInfo []*TypedErrorInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Internal error details.
	Details []*ErrorDefinitionAutoGenerated2 `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; Description of the error.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The target of the error.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Error response.
type ErrorResponse struct {
	// The error details.
	Error *ErrorDefinition `json:"error,omitempty"`
}

// ErrorResponseAutoGenerated - Error response.
type ErrorResponseAutoGenerated struct {
	// The error details.
	Error *ErrorDefinitionAutoGenerated `json:"error,omitempty"`
}

// ErrorResponseAutoGenerated2 - Error response.
type ErrorResponseAutoGenerated2 struct {
	// The error details.
	Error *ErrorDefinitionAutoGenerated2 `json:"error,omitempty"`
}

// ExpressionEvaluationDetails - Evaluation details of policy language expressions.
type ExpressionEvaluationDetails struct {
	// Expression evaluated.
	Expression *string `json:"expression,omitempty"`

	// Value of the expression.
	ExpressionValue interface{} `json:"expressionValue,omitempty"`

	// Operator to compare the expression value and the target value.
	Operator *string `json:"operator,omitempty"`

	// Property path if the expression is a field or an alias.
	Path *string `json:"path,omitempty"`

	// Evaluation result.
	Result *string `json:"result,omitempty"`

	// Target value to be compared with the expression value.
	TargetValue interface{} `json:"targetValue,omitempty"`

	// READ-ONLY; The kind of expression that was evaluated.
	ExpressionKind *string `json:"expressionKind,omitempty" azure:"ro"`
}

// FieldRestriction - The restrictions on a field imposed by a specific policy.
type FieldRestriction struct {
	// READ-ONLY; The value that policy will set for the field if the user does not provide a value.
	DefaultValue *string `json:"defaultValue,omitempty" azure:"ro"`

	// READ-ONLY; The details of the policy that is causing the field restriction.
	Policy *PolicyReference `json:"policy,omitempty" azure:"ro"`

	// READ-ONLY; The type of restriction that is imposed on the field.
	Result *FieldRestrictionResult `json:"result,omitempty" azure:"ro"`

	// READ-ONLY; The values that policy either requires or denies for the field.
	Values []*string `json:"values,omitempty" azure:"ro"`
}

// FieldRestrictions - The restrictions that will be placed on a field in the resource by policy.
type FieldRestrictions struct {
	// The restrictions placed on that field by policy.
	Restrictions []*FieldRestriction `json:"restrictions,omitempty"`

	// READ-ONLY; The name of the field. This can be a top-level property like 'name' or 'type' or an Azure Policy field alias.
	Field *string `json:"field,omitempty" azure:"ro"`
}

// IfNotExistsEvaluationDetails - Evaluation details of IfNotExists effect.
type IfNotExistsEvaluationDetails struct {
	// ID of the last evaluated resource for IfNotExists effect.
	ResourceID *string `json:"resourceId,omitempty"`

	// Total number of resources to which the existence condition is applicable.
	TotalResources *int32 `json:"totalResources,omitempty"`
}

// Operation definition.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name.
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Operation description.
	Description *string `json:"description,omitempty"`

	// Operation name.
	Operation *string `json:"operation,omitempty"`

	// Resource provider name.
	Provider *string `json:"provider,omitempty"`

	// Resource name on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// OperationsListResults - List of available operations.
type OperationsListResults struct {
	// OData entity count; represents the number of operations returned.
	ODataCount *int32 `json:"@odata.count,omitempty"`

	// List of available operations.
	Value []*Operation `json:"value,omitempty"`
}

// PendingField - A field that should be evaluated against Azure Policy to determine restrictions.
type PendingField struct {
	// REQUIRED; The name of the field. This can be a top-level property like 'name' or 'type' or an Azure Policy field alias.
	Field *string `json:"field,omitempty"`

	// The list of potential values for the field that should be evaluated against Azure Policy.
	Values []*string `json:"values,omitempty"`
}

// PolicyAssignmentSummary - Policy assignment summary.
type PolicyAssignmentSummary struct {
	// Policy assignment ID.
	PolicyAssignmentID *string `json:"policyAssignmentId,omitempty"`

	// Policy definitions summary.
	PolicyDefinitions []*PolicyDefinitionSummary `json:"policyDefinitions,omitempty"`

	// Policy definition group summary.
	PolicyGroups []*PolicyGroupSummary `json:"policyGroups,omitempty"`

	// Policy set definition ID, if the policy assignment is for a policy set.
	PolicySetDefinitionID *string `json:"policySetDefinitionId,omitempty"`

	// Compliance summary for the policy assignment.
	Results *SummaryResults `json:"results,omitempty"`
}

// PolicyDefinitionSummary - Policy definition summary.
type PolicyDefinitionSummary struct {
	// Policy effect, i.e. policy definition action.
	Effect *string `json:"effect,omitempty"`

	// Policy definition group names.
	PolicyDefinitionGroupNames []*string `json:"policyDefinitionGroupNames,omitempty"`

	// Policy definition ID.
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty"`

	// Policy definition reference ID.
	PolicyDefinitionReferenceID *string `json:"policyDefinitionReferenceId,omitempty"`

	// Compliance summary for the policy definition.
	Results *SummaryResults `json:"results,omitempty"`
}

// PolicyDetails - The policy details.
type PolicyDetails struct {
	// READ-ONLY; The display name of the policy assignment.
	PolicyAssignmentDisplayName *string `json:"policyAssignmentDisplayName,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the policy assignment.
	PolicyAssignmentID *string `json:"policyAssignmentId,omitempty" azure:"ro"`

	// READ-ONLY; The scope of the policy assignment.
	PolicyAssignmentScope *string `json:"policyAssignmentScope,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the policy definition.
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty" azure:"ro"`

	// READ-ONLY; The policy definition reference ID within the policy set definition.
	PolicyDefinitionReferenceID *string `json:"policyDefinitionReferenceId,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the policy set definition.
	PolicySetDefinitionID *string `json:"policySetDefinitionId,omitempty" azure:"ro"`
}

// PolicyEvaluationDetails - Policy evaluation details.
type PolicyEvaluationDetails struct {
	// Details of the evaluated expressions.
	EvaluatedExpressions []*ExpressionEvaluationDetails `json:"evaluatedExpressions,omitempty"`

	// Evaluation details of IfNotExists effect.
	IfNotExistsDetails *IfNotExistsEvaluationDetails `json:"ifNotExistsDetails,omitempty"`
}

// PolicyEvaluationResult - The result of a non-compliant policy evaluation against the given resource content.
type PolicyEvaluationResult struct {
	// READ-ONLY; The detailed results of the policy expressions and values that were evaluated.
	EvaluationDetails *PolicyEvaluationDetails `json:"evaluationDetails,omitempty" azure:"ro"`

	// READ-ONLY; The result of the policy evaluation against the resource. This will typically be 'NonCompliant' but may contain
	// other values if errors were encountered.
	EvaluationResult *string `json:"evaluationResult,omitempty" azure:"ro"`

	// READ-ONLY; The details of the policy that was evaluated.
	PolicyInfo *PolicyReference `json:"policyInfo,omitempty" azure:"ro"`
}

// PolicyEvent - Policy event record.
type PolicyEvent struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Compliance state of the resource.
	ComplianceState *string `json:"complianceState,omitempty"`

	// Components events records populated only when URL contains $expand=components clause.
	Components []*ComponentEventDetails `json:"components,omitempty"`

	// Effective parameters for the policy assignment.
	EffectiveParameters *string `json:"effectiveParameters,omitempty"`

	// Flag which states whether the resource is compliant against the policy assignment it was evaluated against.
	IsCompliant *bool `json:"isCompliant,omitempty"`

	// Comma separated list of management group IDs, which represent the hierarchy of the management groups the resource is under.
	ManagementGroupIDs *string `json:"managementGroupIds,omitempty"`

	// OData context string; used by OData clients to resolve type information based on metadata.
	ODataContext *string `json:"@odata.context,omitempty"`

	// OData entity ID; always set to null since policy event records do not have an entity ID.
	ODataID *string `json:"@odata.id,omitempty"`

	// Policy assignment ID.
	PolicyAssignmentID *string `json:"policyAssignmentId,omitempty"`

	// Policy assignment name.
	PolicyAssignmentName *string `json:"policyAssignmentName,omitempty"`

	// Policy assignment owner.
	PolicyAssignmentOwner *string `json:"policyAssignmentOwner,omitempty"`

	// Policy assignment parameters.
	PolicyAssignmentParameters *string `json:"policyAssignmentParameters,omitempty"`

	// Policy assignment scope.
	PolicyAssignmentScope *string `json:"policyAssignmentScope,omitempty"`

	// Policy definition action, i.e. effect.
	PolicyDefinitionAction *string `json:"policyDefinitionAction,omitempty"`

	// Policy definition category.
	PolicyDefinitionCategory *string `json:"policyDefinitionCategory,omitempty"`

	// Policy definition ID.
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty"`

	// Policy definition name.
	PolicyDefinitionName *string `json:"policyDefinitionName,omitempty"`

	// Reference ID for the policy definition inside the policy set, if the policy assignment is for a policy set.
	PolicyDefinitionReferenceID *string `json:"policyDefinitionReferenceId,omitempty"`

	// Policy set definition category, if the policy assignment is for a policy set.
	PolicySetDefinitionCategory *string `json:"policySetDefinitionCategory,omitempty"`

	// Policy set definition ID, if the policy assignment is for a policy set.
	PolicySetDefinitionID *string `json:"policySetDefinitionId,omitempty"`

	// Policy set definition name, if the policy assignment is for a policy set.
	PolicySetDefinitionName *string `json:"policySetDefinitionName,omitempty"`

	// Policy set definition owner, if the policy assignment is for a policy set.
	PolicySetDefinitionOwner *string `json:"policySetDefinitionOwner,omitempty"`

	// Policy set definition parameters, if the policy assignment is for a policy set.
	PolicySetDefinitionParameters *string `json:"policySetDefinitionParameters,omitempty"`

	// Principal object ID for the user who initiated the resource operation that triggered the policy event.
	PrincipalOid *string `json:"principalOid,omitempty"`

	// Resource group name.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// Resource ID.
	ResourceID *string `json:"resourceId,omitempty"`

	// Resource location.
	ResourceLocation *string `json:"resourceLocation,omitempty"`

	// List of resource tags.
	ResourceTags *string `json:"resourceTags,omitempty"`

	// Resource type.
	ResourceType *string `json:"resourceType,omitempty"`

	// Subscription ID.
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// Tenant ID for the policy event record.
	TenantID *string `json:"tenantId,omitempty"`

	// Timestamp for the policy event record.
	Timestamp *time.Time `json:"timestamp,omitempty"`
}

// PolicyEventsClientListQueryResultsForManagementGroupOptions contains the optional parameters for the PolicyEventsClient.ListQueryResultsForManagementGroup
// method.
type PolicyEventsClientListQueryResultsForManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// PolicyEventsClientListQueryResultsForPolicyDefinitionOptions contains the optional parameters for the PolicyEventsClient.ListQueryResultsForPolicyDefinition
// method.
type PolicyEventsClientListQueryResultsForPolicyDefinitionOptions struct {
	// placeholder for future optional parameters
}

// PolicyEventsClientListQueryResultsForPolicySetDefinitionOptions contains the optional parameters for the PolicyEventsClient.ListQueryResultsForPolicySetDefinition
// method.
type PolicyEventsClientListQueryResultsForPolicySetDefinitionOptions struct {
	// placeholder for future optional parameters
}

// PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentOptions contains the optional parameters for the
// PolicyEventsClient.ListQueryResultsForResourceGroupLevelPolicyAssignment method.
type PolicyEventsClientListQueryResultsForResourceGroupLevelPolicyAssignmentOptions struct {
	// placeholder for future optional parameters
}

// PolicyEventsClientListQueryResultsForResourceGroupOptions contains the optional parameters for the PolicyEventsClient.ListQueryResultsForResourceGroup
// method.
type PolicyEventsClientListQueryResultsForResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PolicyEventsClientListQueryResultsForResourceOptions contains the optional parameters for the PolicyEventsClient.ListQueryResultsForResource
// method.
type PolicyEventsClientListQueryResultsForResourceOptions struct {
	// placeholder for future optional parameters
}

// PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentOptions contains the optional parameters for the
// PolicyEventsClient.ListQueryResultsForSubscriptionLevelPolicyAssignment method.
type PolicyEventsClientListQueryResultsForSubscriptionLevelPolicyAssignmentOptions struct {
	// placeholder for future optional parameters
}

// PolicyEventsClientListQueryResultsForSubscriptionOptions contains the optional parameters for the PolicyEventsClient.ListQueryResultsForSubscription
// method.
type PolicyEventsClientListQueryResultsForSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// PolicyEventsQueryResults - Query results.
type PolicyEventsQueryResults struct {
	// OData context string; used by OData clients to resolve type information based on metadata.
	ODataContext *string `json:"@odata.context,omitempty"`

	// OData entity count; represents the number of policy event records returned.
	ODataCount *int32 `json:"@odata.count,omitempty"`

	// Odata next link; URL to get the next set of results.
	ODataNextLink *string `json:"@odata.nextLink,omitempty"`

	// Query results.
	Value []*PolicyEvent `json:"value,omitempty"`
}

// PolicyGroupSummary - Policy definition group summary.
type PolicyGroupSummary struct {
	// Policy group name.
	PolicyGroupName *string `json:"policyGroupName,omitempty"`

	// Compliance summary for the policy definition group.
	Results *SummaryResults `json:"results,omitempty"`
}

// PolicyMetadata - Policy metadata resource definition.
type PolicyMetadata struct {
	// Properties of the policy metadata.
	Properties *PolicyMetadataProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the policy metadata.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the policy metadata.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the policy metadata.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PolicyMetadataClientGetResourceOptions contains the optional parameters for the PolicyMetadataClient.GetResource method.
type PolicyMetadataClientGetResourceOptions struct {
	// placeholder for future optional parameters
}

// PolicyMetadataClientListOptions contains the optional parameters for the PolicyMetadataClient.List method.
type PolicyMetadataClientListOptions struct {
	// placeholder for future optional parameters
}

// PolicyMetadataCollection - Collection of policy metadata resources.
type PolicyMetadataCollection struct {
	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of policy metadata definitions.
	Value []*SlimPolicyMetadata `json:"value,omitempty" azure:"ro"`
}

// PolicyMetadataProperties - The properties of the policy metadata.
type PolicyMetadataProperties struct {
	// READ-ONLY; Url for getting additional content about the resource metadata.
	AdditionalContentURL *string `json:"additionalContentUrl,omitempty" azure:"ro"`

	// READ-ONLY; The category of the policy metadata.
	Category *string `json:"category,omitempty" azure:"ro"`

	// READ-ONLY; The description of the policy metadata.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; Additional metadata.
	Metadata interface{} `json:"metadata,omitempty" azure:"ro"`

	// READ-ONLY; The policy metadata identifier.
	MetadataID *string `json:"metadataId,omitempty" azure:"ro"`

	// READ-ONLY; The owner of the policy metadata.
	Owner *string `json:"owner,omitempty" azure:"ro"`

	// READ-ONLY; The requirements of the policy metadata.
	Requirements *string `json:"requirements,omitempty" azure:"ro"`

	// READ-ONLY; The title of the policy metadata.
	Title *string `json:"title,omitempty" azure:"ro"`
}

// PolicyMetadataSlimProperties - The properties of the policy metadata, excluding properties containing large strings
type PolicyMetadataSlimProperties struct {
	// READ-ONLY; Url for getting additional content about the resource metadata.
	AdditionalContentURL *string `json:"additionalContentUrl,omitempty" azure:"ro"`

	// READ-ONLY; The category of the policy metadata.
	Category *string `json:"category,omitempty" azure:"ro"`

	// READ-ONLY; Additional metadata.
	Metadata interface{} `json:"metadata,omitempty" azure:"ro"`

	// READ-ONLY; The policy metadata identifier.
	MetadataID *string `json:"metadataId,omitempty" azure:"ro"`

	// READ-ONLY; The owner of the policy metadata.
	Owner *string `json:"owner,omitempty" azure:"ro"`

	// READ-ONLY; The title of the policy metadata.
	Title *string `json:"title,omitempty" azure:"ro"`
}

// PolicyReference - Resource identifiers for a policy.
type PolicyReference struct {
	// READ-ONLY; The resource identifier of the policy assignment.
	PolicyAssignmentID *string `json:"policyAssignmentId,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier of the policy definition.
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty" azure:"ro"`

	// READ-ONLY; The reference identifier of a specific policy definition within a policy set definition.
	PolicyDefinitionReferenceID *string `json:"policyDefinitionReferenceId,omitempty" azure:"ro"`

	// READ-ONLY; The resource identifier of the policy set definition.
	PolicySetDefinitionID *string `json:"policySetDefinitionId,omitempty" azure:"ro"`
}

// PolicyRestrictionsClientCheckAtManagementGroupScopeOptions contains the optional parameters for the PolicyRestrictionsClient.CheckAtManagementGroupScope
// method.
type PolicyRestrictionsClientCheckAtManagementGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// PolicyRestrictionsClientCheckAtResourceGroupScopeOptions contains the optional parameters for the PolicyRestrictionsClient.CheckAtResourceGroupScope
// method.
type PolicyRestrictionsClientCheckAtResourceGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// PolicyRestrictionsClientCheckAtSubscriptionScopeOptions contains the optional parameters for the PolicyRestrictionsClient.CheckAtSubscriptionScope
// method.
type PolicyRestrictionsClientCheckAtSubscriptionScopeOptions struct {
	// placeholder for future optional parameters
}

// PolicyState - Policy state record.
type PolicyState struct {
	// OPTIONAL; Contains additional key/value pairs not defined in the schema.
	AdditionalProperties map[string]interface{}

	// Compliance state of the resource.
	ComplianceState *string `json:"complianceState,omitempty"`

	// Components state compliance records populated only when URL contains $expand=components clause.
	Components []*ComponentStateDetails `json:"components,omitempty"`

	// Effective parameters for the policy assignment.
	EffectiveParameters *string `json:"effectiveParameters,omitempty"`

	// Flag which states whether the resource is compliant against the policy assignment it was evaluated against. This property
	// is deprecated; please use ComplianceState instead.
	IsCompliant *bool `json:"isCompliant,omitempty"`

	// Comma separated list of management group IDs, which represent the hierarchy of the management groups the resource is under.
	ManagementGroupIDs *string `json:"managementGroupIds,omitempty"`

	// OData context string; used by OData clients to resolve type information based on metadata.
	ODataContext *string `json:"@odata.context,omitempty"`

	// OData entity ID; always set to null since policy state records do not have an entity ID.
	ODataID *string `json:"@odata.id,omitempty"`

	// Policy assignment ID.
	PolicyAssignmentID *string `json:"policyAssignmentId,omitempty"`

	// Policy assignment name.
	PolicyAssignmentName *string `json:"policyAssignmentName,omitempty"`

	// Policy assignment owner.
	PolicyAssignmentOwner *string `json:"policyAssignmentOwner,omitempty"`

	// Policy assignment parameters.
	PolicyAssignmentParameters *string `json:"policyAssignmentParameters,omitempty"`

	// Policy assignment scope.
	PolicyAssignmentScope *string `json:"policyAssignmentScope,omitempty"`

	// Policy definition action, i.e. effect.
	PolicyDefinitionAction *string `json:"policyDefinitionAction,omitempty"`

	// Policy definition category.
	PolicyDefinitionCategory *string `json:"policyDefinitionCategory,omitempty"`

	// Policy definition group names.
	PolicyDefinitionGroupNames []*string `json:"policyDefinitionGroupNames,omitempty"`

	// Policy definition ID.
	PolicyDefinitionID *string `json:"policyDefinitionId,omitempty"`

	// Policy definition name.
	PolicyDefinitionName *string `json:"policyDefinitionName,omitempty"`

	// Reference ID for the policy definition inside the policy set, if the policy assignment is for a policy set.
	PolicyDefinitionReferenceID *string `json:"policyDefinitionReferenceId,omitempty"`

	// Policy evaluation details.
	PolicyEvaluationDetails *PolicyEvaluationDetails `json:"policyEvaluationDetails,omitempty"`

	// Policy set definition category, if the policy assignment is for a policy set.
	PolicySetDefinitionCategory *string `json:"policySetDefinitionCategory,omitempty"`

	// Policy set definition ID, if the policy assignment is for a policy set.
	PolicySetDefinitionID *string `json:"policySetDefinitionId,omitempty"`

	// Policy set definition name, if the policy assignment is for a policy set.
	PolicySetDefinitionName *string `json:"policySetDefinitionName,omitempty"`

	// Policy set definition owner, if the policy assignment is for a policy set.
	PolicySetDefinitionOwner *string `json:"policySetDefinitionOwner,omitempty"`

	// Policy set definition parameters, if the policy assignment is for a policy set.
	PolicySetDefinitionParameters *string `json:"policySetDefinitionParameters,omitempty"`

	// Resource group name.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// Resource ID.
	ResourceID *string `json:"resourceId,omitempty"`

	// Resource location.
	ResourceLocation *string `json:"resourceLocation,omitempty"`

	// List of resource tags.
	ResourceTags *string `json:"resourceTags,omitempty"`

	// Resource type.
	ResourceType *string `json:"resourceType,omitempty"`

	// Subscription ID.
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// Timestamp for the policy state record.
	Timestamp *time.Time `json:"timestamp,omitempty"`

	// READ-ONLY; Evaluated policy assignment version.
	PolicyAssignmentVersion *string `json:"policyAssignmentVersion,omitempty" azure:"ro"`

	// READ-ONLY; Evaluated policy definition version.
	PolicyDefinitionVersion *string `json:"policyDefinitionVersion,omitempty" azure:"ro"`

	// READ-ONLY; Evaluated policy set definition version.
	PolicySetDefinitionVersion *string `json:"policySetDefinitionVersion,omitempty" azure:"ro"`
}

// PolicyStatesClientBeginTriggerResourceGroupEvaluationOptions contains the optional parameters for the PolicyStatesClient.BeginTriggerResourceGroupEvaluation
// method.
type PolicyStatesClientBeginTriggerResourceGroupEvaluationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PolicyStatesClientBeginTriggerSubscriptionEvaluationOptions contains the optional parameters for the PolicyStatesClient.BeginTriggerSubscriptionEvaluation
// method.
type PolicyStatesClientBeginTriggerSubscriptionEvaluationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PolicyStatesClientListQueryResultsForManagementGroupOptions contains the optional parameters for the PolicyStatesClient.ListQueryResultsForManagementGroup
// method.
type PolicyStatesClientListQueryResultsForManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// PolicyStatesClientListQueryResultsForPolicyDefinitionOptions contains the optional parameters for the PolicyStatesClient.ListQueryResultsForPolicyDefinition
// method.
type PolicyStatesClientListQueryResultsForPolicyDefinitionOptions struct {
	// placeholder for future optional parameters
}

// PolicyStatesClientListQueryResultsForPolicySetDefinitionOptions contains the optional parameters for the PolicyStatesClient.ListQueryResultsForPolicySetDefinition
// method.
type PolicyStatesClientListQueryResultsForPolicySetDefinitionOptions struct {
	// placeholder for future optional parameters
}

// PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentOptions contains the optional parameters for the
// PolicyStatesClient.ListQueryResultsForResourceGroupLevelPolicyAssignment method.
type PolicyStatesClientListQueryResultsForResourceGroupLevelPolicyAssignmentOptions struct {
	// placeholder for future optional parameters
}

// PolicyStatesClientListQueryResultsForResourceGroupOptions contains the optional parameters for the PolicyStatesClient.ListQueryResultsForResourceGroup
// method.
type PolicyStatesClientListQueryResultsForResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PolicyStatesClientListQueryResultsForResourceOptions contains the optional parameters for the PolicyStatesClient.ListQueryResultsForResource
// method.
type PolicyStatesClientListQueryResultsForResourceOptions struct {
	// placeholder for future optional parameters
}

// PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentOptions contains the optional parameters for the
// PolicyStatesClient.ListQueryResultsForSubscriptionLevelPolicyAssignment method.
type PolicyStatesClientListQueryResultsForSubscriptionLevelPolicyAssignmentOptions struct {
	// placeholder for future optional parameters
}

// PolicyStatesClientListQueryResultsForSubscriptionOptions contains the optional parameters for the PolicyStatesClient.ListQueryResultsForSubscription
// method.
type PolicyStatesClientListQueryResultsForSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// PolicyStatesClientSummarizeForManagementGroupOptions contains the optional parameters for the PolicyStatesClient.SummarizeForManagementGroup
// method.
type PolicyStatesClientSummarizeForManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// PolicyStatesClientSummarizeForPolicyDefinitionOptions contains the optional parameters for the PolicyStatesClient.SummarizeForPolicyDefinition
// method.
type PolicyStatesClientSummarizeForPolicyDefinitionOptions struct {
	// placeholder for future optional parameters
}

// PolicyStatesClientSummarizeForPolicySetDefinitionOptions contains the optional parameters for the PolicyStatesClient.SummarizeForPolicySetDefinition
// method.
type PolicyStatesClientSummarizeForPolicySetDefinitionOptions struct {
	// placeholder for future optional parameters
}

// PolicyStatesClientSummarizeForResourceGroupLevelPolicyAssignmentOptions contains the optional parameters for the PolicyStatesClient.SummarizeForResourceGroupLevelPolicyAssignment
// method.
type PolicyStatesClientSummarizeForResourceGroupLevelPolicyAssignmentOptions struct {
	// placeholder for future optional parameters
}

// PolicyStatesClientSummarizeForResourceGroupOptions contains the optional parameters for the PolicyStatesClient.SummarizeForResourceGroup
// method.
type PolicyStatesClientSummarizeForResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PolicyStatesClientSummarizeForResourceOptions contains the optional parameters for the PolicyStatesClient.SummarizeForResource
// method.
type PolicyStatesClientSummarizeForResourceOptions struct {
	// placeholder for future optional parameters
}

// PolicyStatesClientSummarizeForSubscriptionLevelPolicyAssignmentOptions contains the optional parameters for the PolicyStatesClient.SummarizeForSubscriptionLevelPolicyAssignment
// method.
type PolicyStatesClientSummarizeForSubscriptionLevelPolicyAssignmentOptions struct {
	// placeholder for future optional parameters
}

// PolicyStatesClientSummarizeForSubscriptionOptions contains the optional parameters for the PolicyStatesClient.SummarizeForSubscription
// method.
type PolicyStatesClientSummarizeForSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// PolicyStatesQueryResults - Query results.
type PolicyStatesQueryResults struct {
	// OData context string; used by OData clients to resolve type information based on metadata.
	ODataContext *string `json:"@odata.context,omitempty"`

	// OData entity count; represents the number of policy state records returned.
	ODataCount *int32 `json:"@odata.count,omitempty"`

	// Odata next link; URL to get the next set of results.
	ODataNextLink *string `json:"@odata.nextLink,omitempty"`

	// Query results.
	Value []*PolicyState `json:"value,omitempty"`
}

// PolicyTrackedResource - Policy tracked resource record.
type PolicyTrackedResource struct {
	// READ-ONLY; The details of the policy triggered deployment that created the tracked resource.
	CreatedBy *TrackedResourceModificationDetails `json:"createdBy,omitempty" azure:"ro"`

	// READ-ONLY; The details of the policy triggered deployment that modified the tracked resource.
	LastModifiedBy *TrackedResourceModificationDetails `json:"lastModifiedBy,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp of the last update to the tracked resource.
	LastUpdateUTC *time.Time `json:"lastUpdateUtc,omitempty" azure:"ro"`

	// READ-ONLY; The details of the policy that require the tracked resource.
	PolicyDetails *PolicyDetails `json:"policyDetails,omitempty" azure:"ro"`

	// READ-ONLY; The ID of the policy tracked resource.
	TrackedResourceID *string `json:"trackedResourceId,omitempty" azure:"ro"`
}

// PolicyTrackedResourcesClientListQueryResultsForManagementGroupOptions contains the optional parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup
// method.
type PolicyTrackedResourcesClientListQueryResultsForManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// PolicyTrackedResourcesClientListQueryResultsForResourceGroupOptions contains the optional parameters for the PolicyTrackedResourcesClient.ListQueryResultsForResourceGroup
// method.
type PolicyTrackedResourcesClientListQueryResultsForResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// PolicyTrackedResourcesClientListQueryResultsForResourceOptions contains the optional parameters for the PolicyTrackedResourcesClient.ListQueryResultsForResource
// method.
type PolicyTrackedResourcesClientListQueryResultsForResourceOptions struct {
	// placeholder for future optional parameters
}

// PolicyTrackedResourcesClientListQueryResultsForSubscriptionOptions contains the optional parameters for the PolicyTrackedResourcesClient.ListQueryResultsForSubscription
// method.
type PolicyTrackedResourcesClientListQueryResultsForSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// PolicyTrackedResourcesQueryResults - Query results.
type PolicyTrackedResourcesQueryResults struct {
	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Query results.
	Value []*PolicyTrackedResource `json:"value,omitempty" azure:"ro"`
}

// QueryFailure - Error response.
type QueryFailure struct {
	// Error definition.
	Error *QueryFailureError `json:"error,omitempty"`
}

// QueryFailureError - Error definition.
type QueryFailureError struct {
	// READ-ONLY; Service specific error code which serves as the substatus for the HTTP error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; Description of the error.
	Message *string `json:"message,omitempty" azure:"ro"`
}

// QueryOptions contains a group of parameters for the PolicyTrackedResourcesClient.ListQueryResultsForManagementGroup method.
type QueryOptions struct {
	// OData apply expression for aggregations.
	Apply *string
	// The $expand query parameter. For example, to expand components use $expand=components
	Expand *string
	// OData filter expression.
	Filter *string
	// ISO 8601 formatted timestamp specifying the start time of the interval to query. When not specified, the service uses ($to
	// - 1-day).
	From *time.Time
	// Ordering expression using OData notation. One or more comma-separated column names with an optional "desc" (the default)
	// or "asc", e.g. "$orderby=PolicyAssignmentId, ResourceId asc".
	OrderBy *string
	// Select expression using OData notation. Limits the columns on each record to just those requested, e.g. "$select=PolicyAssignmentId,
	// ResourceId".
	Select *string
	// Skiptoken is only provided if a previous response returned a partial result as a part of nextLink element.
	SkipToken *string
	// ISO 8601 formatted timestamp specifying the end time of the interval to query. When not specified, the service uses request
	// time.
	To *time.Time
	// Maximum number of records to return.
	Top *int32
}

// Remediation - The remediation definition.
type Remediation struct {
	// Properties for the remediation.
	Properties *RemediationProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the remediation.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the remediation.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the remediation.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RemediationDeployment - Details of a single deployment created by the remediation.
type RemediationDeployment struct {
	// READ-ONLY; The time at which the remediation was created.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID of the template deployment that will remediate the resource.
	DeploymentID *string `json:"deploymentId,omitempty" azure:"ro"`

	// READ-ONLY; Error encountered while remediated the resource.
	Error *ErrorDefinition `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the remediation deployment was last updated.
	LastUpdatedOn *time.Time `json:"lastUpdatedOn,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID of the resource that is being remediated by the deployment.
	RemediatedResourceID *string `json:"remediatedResourceId,omitempty" azure:"ro"`

	// READ-ONLY; Location of the resource that is being remediated.
	ResourceLocation *string `json:"resourceLocation,omitempty" azure:"ro"`

	// READ-ONLY; Status of the remediation deployment.
	Status *string `json:"status,omitempty" azure:"ro"`
}

// RemediationDeploymentSummary - The deployment status summary for all deployments created by the remediation.
type RemediationDeploymentSummary struct {
	// READ-ONLY; The number of deployments required by the remediation that have failed.
	FailedDeployments *int32 `json:"failedDeployments,omitempty" azure:"ro"`

	// READ-ONLY; The number of deployments required by the remediation that have succeeded.
	SuccessfulDeployments *int32 `json:"successfulDeployments,omitempty" azure:"ro"`

	// READ-ONLY; The number of deployments required by the remediation.
	TotalDeployments *int32 `json:"totalDeployments,omitempty" azure:"ro"`
}

// RemediationDeploymentsListResult - List of deployments for a remediation.
type RemediationDeploymentsListResult struct {
	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of deployments for the remediation.
	Value []*RemediationDeployment `json:"value,omitempty" azure:"ro"`
}

// RemediationFilters - The filters that will be applied to determine which resources to remediate.
type RemediationFilters struct {
	// The resource locations that will be remediated.
	Locations []*string `json:"locations,omitempty"`
}

// RemediationListResult - List of remediations.
type RemediationListResult struct {
	// READ-ONLY; The URL to get the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of remediation definitions.
	Value []*Remediation `json:"value,omitempty" azure:"ro"`
}

// RemediationProperties - The remediation properties.
type RemediationProperties struct {
	// The remediation failure threshold settings
	FailureThreshold *RemediationPropertiesFailureThreshold `json:"failureThreshold,omitempty"`

	// The filters that will be applied to determine which resources to remediate.
	Filters *RemediationFilters `json:"filters,omitempty"`

	// Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation.
	// If not provided, the default parallel deployments value is used.
	ParallelDeployments *int32 `json:"parallelDeployments,omitempty"`

	// The resource ID of the policy assignment that should be remediated.
	PolicyAssignmentID *string `json:"policyAssignmentId,omitempty"`

	// The policy definition reference ID of the individual definition that should be remediated. Required when the policy assignment
	// being remediated assigns a policy set definition.
	PolicyDefinitionReferenceID *string `json:"policyDefinitionReferenceId,omitempty"`

	// Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource
	// count is used.
	ResourceCount *int32 `json:"resourceCount,omitempty"`

	// The way resources to remediate are discovered. Defaults to ExistingNonCompliant if not specified.
	ResourceDiscoveryMode *ResourceDiscoveryMode `json:"resourceDiscoveryMode,omitempty"`

	// READ-ONLY; The remediation correlation Id. Can be used to find events related to the remediation in the activity log.
	CorrelationID *string `json:"correlationId,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the remediation was created.
	CreatedOn *time.Time `json:"createdOn,omitempty" azure:"ro"`

	// READ-ONLY; The deployment status summary for all deployments created by the remediation.
	DeploymentStatus *RemediationDeploymentSummary `json:"deploymentStatus,omitempty" azure:"ro"`

	// READ-ONLY; The time at which the remediation was last updated.
	LastUpdatedOn *time.Time `json:"lastUpdatedOn,omitempty" azure:"ro"`

	// READ-ONLY; The status of the remediation.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The remediation status message. Provides additional details regarding the state of the remediation.
	StatusMessage *string `json:"statusMessage,omitempty" azure:"ro"`
}

// RemediationPropertiesFailureThreshold - The remediation failure threshold settings
type RemediationPropertiesFailureThreshold struct {
	// A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage
	// of failed remediation operations (i.e. failed deployments) exceeds this
	// threshold.
	Percentage *float32 `json:"percentage,omitempty"`
}

// RemediationsClientCancelAtManagementGroupOptions contains the optional parameters for the RemediationsClient.CancelAtManagementGroup
// method.
type RemediationsClientCancelAtManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientCancelAtResourceGroupOptions contains the optional parameters for the RemediationsClient.CancelAtResourceGroup
// method.
type RemediationsClientCancelAtResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientCancelAtResourceOptions contains the optional parameters for the RemediationsClient.CancelAtResource
// method.
type RemediationsClientCancelAtResourceOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientCancelAtSubscriptionOptions contains the optional parameters for the RemediationsClient.CancelAtSubscription
// method.
type RemediationsClientCancelAtSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientCreateOrUpdateAtManagementGroupOptions contains the optional parameters for the RemediationsClient.CreateOrUpdateAtManagementGroup
// method.
type RemediationsClientCreateOrUpdateAtManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientCreateOrUpdateAtResourceGroupOptions contains the optional parameters for the RemediationsClient.CreateOrUpdateAtResourceGroup
// method.
type RemediationsClientCreateOrUpdateAtResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientCreateOrUpdateAtResourceOptions contains the optional parameters for the RemediationsClient.CreateOrUpdateAtResource
// method.
type RemediationsClientCreateOrUpdateAtResourceOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientCreateOrUpdateAtSubscriptionOptions contains the optional parameters for the RemediationsClient.CreateOrUpdateAtSubscription
// method.
type RemediationsClientCreateOrUpdateAtSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientDeleteAtManagementGroupOptions contains the optional parameters for the RemediationsClient.DeleteAtManagementGroup
// method.
type RemediationsClientDeleteAtManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientDeleteAtResourceGroupOptions contains the optional parameters for the RemediationsClient.DeleteAtResourceGroup
// method.
type RemediationsClientDeleteAtResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientDeleteAtResourceOptions contains the optional parameters for the RemediationsClient.DeleteAtResource
// method.
type RemediationsClientDeleteAtResourceOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientDeleteAtSubscriptionOptions contains the optional parameters for the RemediationsClient.DeleteAtSubscription
// method.
type RemediationsClientDeleteAtSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientGetAtManagementGroupOptions contains the optional parameters for the RemediationsClient.GetAtManagementGroup
// method.
type RemediationsClientGetAtManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientGetAtResourceGroupOptions contains the optional parameters for the RemediationsClient.GetAtResourceGroup
// method.
type RemediationsClientGetAtResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientGetAtResourceOptions contains the optional parameters for the RemediationsClient.GetAtResource method.
type RemediationsClientGetAtResourceOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientGetAtSubscriptionOptions contains the optional parameters for the RemediationsClient.GetAtSubscription
// method.
type RemediationsClientGetAtSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientListDeploymentsAtManagementGroupOptions contains the optional parameters for the RemediationsClient.ListDeploymentsAtManagementGroup
// method.
type RemediationsClientListDeploymentsAtManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientListDeploymentsAtResourceGroupOptions contains the optional parameters for the RemediationsClient.ListDeploymentsAtResourceGroup
// method.
type RemediationsClientListDeploymentsAtResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientListDeploymentsAtResourceOptions contains the optional parameters for the RemediationsClient.ListDeploymentsAtResource
// method.
type RemediationsClientListDeploymentsAtResourceOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientListDeploymentsAtSubscriptionOptions contains the optional parameters for the RemediationsClient.ListDeploymentsAtSubscription
// method.
type RemediationsClientListDeploymentsAtSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientListForManagementGroupOptions contains the optional parameters for the RemediationsClient.ListForManagementGroup
// method.
type RemediationsClientListForManagementGroupOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientListForResourceGroupOptions contains the optional parameters for the RemediationsClient.ListForResourceGroup
// method.
type RemediationsClientListForResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientListForResourceOptions contains the optional parameters for the RemediationsClient.ListForResource method.
type RemediationsClientListForResourceOptions struct {
	// placeholder for future optional parameters
}

// RemediationsClientListForSubscriptionOptions contains the optional parameters for the RemediationsClient.ListForSubscription
// method.
type RemediationsClientListForSubscriptionOptions struct {
	// placeholder for future optional parameters
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SlimPolicyMetadata - Slim version of policy metadata resource definition, excluding properties with large strings
type SlimPolicyMetadata struct {
	// Properties of the policy metadata.
	Properties *PolicyMetadataSlimProperties `json:"properties,omitempty"`

	// READ-ONLY; The ID of the policy metadata.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the policy metadata.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the policy metadata.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SummarizeResults - Summarize action results.
type SummarizeResults struct {
	// OData context string; used by OData clients to resolve type information based on metadata.
	ODataContext *string `json:"@odata.context,omitempty"`

	// OData entity count; represents the number of summaries returned; always set to 1.
	ODataCount *int32 `json:"@odata.count,omitempty"`

	// Summarize action results.
	Value []*Summary `json:"value,omitempty"`
}

// Summary results.
type Summary struct {
	// OData context string; used by OData clients to resolve type information based on metadata.
	ODataContext *string `json:"@odata.context,omitempty"`

	// OData entity ID; always set to null since summaries do not have an entity ID.
	ODataID *string `json:"@odata.id,omitempty"`

	// Policy assignments summary.
	PolicyAssignments []*PolicyAssignmentSummary `json:"policyAssignments,omitempty"`

	// Compliance summary for all policy assignments.
	Results *SummaryResults `json:"results,omitempty"`
}

// SummaryResults - Compliance summary on a particular summary level.
type SummaryResults struct {
	// Number of non-compliant policies.
	NonCompliantPolicies *int32 `json:"nonCompliantPolicies,omitempty"`

	// Number of non-compliant resources.
	NonCompliantResources *int32 `json:"nonCompliantResources,omitempty"`

	// The policy artifact summary at this level. For query scope level, it represents policy assignment summary. For policy assignment
	// level, it represents policy definitions summary.
	PolicyDetails []*ComplianceDetail `json:"policyDetails,omitempty"`

	// The policy definition group summary at this level.
	PolicyGroupDetails []*ComplianceDetail `json:"policyGroupDetails,omitempty"`

	// HTTP POST URI for queryResults action on Microsoft.PolicyInsights to retrieve raw results for the compliance summary. This
	// property will not be available by default in future API versions, but could
	// be queried explicitly.
	QueryResultsURI *string `json:"queryResultsUri,omitempty"`

	// The resources summary at this level.
	ResourceDetails []*ComplianceDetail `json:"resourceDetails,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TrackedResourceModificationDetails - The details of the policy triggered deployment that created or modified the tracked
// resource.
type TrackedResourceModificationDetails struct {
	// READ-ONLY; The ID of the deployment that created or modified the tracked resource.
	DeploymentID *string `json:"deploymentId,omitempty" azure:"ro"`

	// READ-ONLY; Timestamp of the deployment that created or modified the tracked resource.
	DeploymentTime *time.Time `json:"deploymentTime,omitempty" azure:"ro"`

	// READ-ONLY; The details of the policy that created or modified the tracked resource.
	PolicyDetails *PolicyDetails `json:"policyDetails,omitempty" azure:"ro"`
}

// TypedErrorInfo - Scenario specific error details.
type TypedErrorInfo struct {
	// READ-ONLY; The scenario specific error details.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The type of included error details.
	Type *string `json:"type,omitempty" azure:"ro"`
}
