//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armkeyvault_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/keyvault/armkeyvault"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/keyvault/resource-manager/Microsoft.KeyVault/preview/2021-11-01-preview/examples/createVault.json
func ExampleVaultsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armkeyvault.NewVaultsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := client.BeginCreateOrUpdate(ctx,
		"sample-resource-group",
		"sample-vault",
		armkeyvault.VaultCreateOrUpdateParameters{
			Location: to.Ptr("westus"),
			Properties: &armkeyvault.VaultProperties{
				AccessPolicies: []*armkeyvault.AccessPolicyEntry{
					{
						ObjectID: to.Ptr("00000000-0000-0000-0000-000000000000"),
						Permissions: &armkeyvault.Permissions{
							Certificates: []*armkeyvault.CertificatePermissions{
								to.Ptr(armkeyvault.CertificatePermissionsGet),
								to.Ptr(armkeyvault.CertificatePermissionsList),
								to.Ptr(armkeyvault.CertificatePermissionsDelete),
								to.Ptr(armkeyvault.CertificatePermissionsCreate),
								to.Ptr(armkeyvault.CertificatePermissionsImport),
								to.Ptr(armkeyvault.CertificatePermissionsUpdate),
								to.Ptr(armkeyvault.CertificatePermissionsManagecontacts),
								to.Ptr(armkeyvault.CertificatePermissionsGetissuers),
								to.Ptr(armkeyvault.CertificatePermissionsListissuers),
								to.Ptr(armkeyvault.CertificatePermissionsSetissuers),
								to.Ptr(armkeyvault.CertificatePermissionsDeleteissuers),
								to.Ptr(armkeyvault.CertificatePermissionsManageissuers),
								to.Ptr(armkeyvault.CertificatePermissionsRecover),
								to.Ptr(armkeyvault.CertificatePermissionsPurge)},
							Keys: []*armkeyvault.KeyPermissions{
								to.Ptr(armkeyvault.KeyPermissionsEncrypt),
								to.Ptr(armkeyvault.KeyPermissionsDecrypt),
								to.Ptr(armkeyvault.KeyPermissionsWrapKey),
								to.Ptr(armkeyvault.KeyPermissionsUnwrapKey),
								to.Ptr(armkeyvault.KeyPermissionsSign),
								to.Ptr(armkeyvault.KeyPermissionsVerify),
								to.Ptr(armkeyvault.KeyPermissionsGet),
								to.Ptr(armkeyvault.KeyPermissionsList),
								to.Ptr(armkeyvault.KeyPermissionsCreate),
								to.Ptr(armkeyvault.KeyPermissionsUpdate),
								to.Ptr(armkeyvault.KeyPermissionsImport),
								to.Ptr(armkeyvault.KeyPermissionsDelete),
								to.Ptr(armkeyvault.KeyPermissionsBackup),
								to.Ptr(armkeyvault.KeyPermissionsRestore),
								to.Ptr(armkeyvault.KeyPermissionsRecover),
								to.Ptr(armkeyvault.KeyPermissionsPurge)},
							Secrets: []*armkeyvault.SecretPermissions{
								to.Ptr(armkeyvault.SecretPermissionsGet),
								to.Ptr(armkeyvault.SecretPermissionsList),
								to.Ptr(armkeyvault.SecretPermissionsSet),
								to.Ptr(armkeyvault.SecretPermissionsDelete),
								to.Ptr(armkeyvault.SecretPermissionsBackup),
								to.Ptr(armkeyvault.SecretPermissionsRestore),
								to.Ptr(armkeyvault.SecretPermissionsRecover),
								to.Ptr(armkeyvault.SecretPermissionsPurge)},
						},
						TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
					}},
				EnabledForDeployment:         to.Ptr(true),
				EnabledForDiskEncryption:     to.Ptr(true),
				EnabledForTemplateDeployment: to.Ptr(true),
				PublicNetworkAccess:          to.Ptr("Enabled"),
				SKU: &armkeyvault.SKU{
					Name:   to.Ptr(armkeyvault.SKUNameStandard),
					Family: to.Ptr(armkeyvault.SKUFamilyA),
				},
				TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/keyvault/resource-manager/Microsoft.KeyVault/preview/2021-11-01-preview/examples/updateVault.json
func ExampleVaultsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armkeyvault.NewVaultsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.Update(ctx,
		"sample-resource-group",
		"sample-vault",
		armkeyvault.VaultPatchParameters{
			Properties: &armkeyvault.VaultPatchProperties{
				AccessPolicies: []*armkeyvault.AccessPolicyEntry{
					{
						ObjectID: to.Ptr("00000000-0000-0000-0000-000000000000"),
						Permissions: &armkeyvault.Permissions{
							Certificates: []*armkeyvault.CertificatePermissions{
								to.Ptr(armkeyvault.CertificatePermissionsGet),
								to.Ptr(armkeyvault.CertificatePermissionsList),
								to.Ptr(armkeyvault.CertificatePermissionsDelete),
								to.Ptr(armkeyvault.CertificatePermissionsCreate),
								to.Ptr(armkeyvault.CertificatePermissionsImport),
								to.Ptr(armkeyvault.CertificatePermissionsUpdate),
								to.Ptr(armkeyvault.CertificatePermissionsManagecontacts),
								to.Ptr(armkeyvault.CertificatePermissionsGetissuers),
								to.Ptr(armkeyvault.CertificatePermissionsListissuers),
								to.Ptr(armkeyvault.CertificatePermissionsSetissuers),
								to.Ptr(armkeyvault.CertificatePermissionsDeleteissuers),
								to.Ptr(armkeyvault.CertificatePermissionsManageissuers),
								to.Ptr(armkeyvault.CertificatePermissionsRecover),
								to.Ptr(armkeyvault.CertificatePermissionsPurge)},
							Keys: []*armkeyvault.KeyPermissions{
								to.Ptr(armkeyvault.KeyPermissionsEncrypt),
								to.Ptr(armkeyvault.KeyPermissionsDecrypt),
								to.Ptr(armkeyvault.KeyPermissionsWrapKey),
								to.Ptr(armkeyvault.KeyPermissionsUnwrapKey),
								to.Ptr(armkeyvault.KeyPermissionsSign),
								to.Ptr(armkeyvault.KeyPermissionsVerify),
								to.Ptr(armkeyvault.KeyPermissionsGet),
								to.Ptr(armkeyvault.KeyPermissionsList),
								to.Ptr(armkeyvault.KeyPermissionsCreate),
								to.Ptr(armkeyvault.KeyPermissionsUpdate),
								to.Ptr(armkeyvault.KeyPermissionsImport),
								to.Ptr(armkeyvault.KeyPermissionsDelete),
								to.Ptr(armkeyvault.KeyPermissionsBackup),
								to.Ptr(armkeyvault.KeyPermissionsRestore),
								to.Ptr(armkeyvault.KeyPermissionsRecover),
								to.Ptr(armkeyvault.KeyPermissionsPurge)},
							Secrets: []*armkeyvault.SecretPermissions{
								to.Ptr(armkeyvault.SecretPermissionsGet),
								to.Ptr(armkeyvault.SecretPermissionsList),
								to.Ptr(armkeyvault.SecretPermissionsSet),
								to.Ptr(armkeyvault.SecretPermissionsDelete),
								to.Ptr(armkeyvault.SecretPermissionsBackup),
								to.Ptr(armkeyvault.SecretPermissionsRestore),
								to.Ptr(armkeyvault.SecretPermissionsRecover),
								to.Ptr(armkeyvault.SecretPermissionsPurge)},
						},
						TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
					}},
				EnabledForDeployment:         to.Ptr(true),
				EnabledForDiskEncryption:     to.Ptr(true),
				EnabledForTemplateDeployment: to.Ptr(true),
				PublicNetworkAccess:          to.Ptr("Enabled"),
				SKU: &armkeyvault.SKU{
					Name:   to.Ptr(armkeyvault.SKUNameStandard),
					Family: to.Ptr(armkeyvault.SKUFamilyA),
				},
				TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/keyvault/resource-manager/Microsoft.KeyVault/preview/2021-11-01-preview/examples/deleteVault.json
func ExampleVaultsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armkeyvault.NewVaultsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = client.Delete(ctx,
		"sample-resource-group",
		"sample-vault",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/keyvault/resource-manager/Microsoft.KeyVault/preview/2021-11-01-preview/examples/getVault.json
func ExampleVaultsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armkeyvault.NewVaultsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.Get(ctx,
		"sample-resource-group",
		"sample-vault",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/keyvault/resource-manager/Microsoft.KeyVault/preview/2021-11-01-preview/examples/updateAccessPoliciesAdd.json
func ExampleVaultsClient_UpdateAccessPolicy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armkeyvault.NewVaultsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.UpdateAccessPolicy(ctx,
		"sample-group",
		"sample-vault",
		armkeyvault.AccessPolicyUpdateKindAdd,
		armkeyvault.VaultAccessPolicyParameters{
			Properties: &armkeyvault.VaultAccessPolicyProperties{
				AccessPolicies: []*armkeyvault.AccessPolicyEntry{
					{
						ObjectID: to.Ptr("00000000-0000-0000-0000-000000000000"),
						Permissions: &armkeyvault.Permissions{
							Certificates: []*armkeyvault.CertificatePermissions{
								to.Ptr(armkeyvault.CertificatePermissionsGet)},
							Keys: []*armkeyvault.KeyPermissions{
								to.Ptr(armkeyvault.KeyPermissionsEncrypt)},
							Secrets: []*armkeyvault.SecretPermissions{
								to.Ptr(armkeyvault.SecretPermissionsGet)},
						},
						TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
					}},
			},
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/keyvault/resource-manager/Microsoft.KeyVault/preview/2021-11-01-preview/examples/listVaultByResourceGroup.json
func ExampleVaultsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armkeyvault.NewVaultsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListByResourceGroupPager("sample-group",
		&armkeyvault.VaultsClientListByResourceGroupOptions{Top: to.Ptr[int32](1)})
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/keyvault/resource-manager/Microsoft.KeyVault/preview/2021-11-01-preview/examples/listVaultBySubscription.json
func ExampleVaultsClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armkeyvault.NewVaultsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListBySubscriptionPager(&armkeyvault.VaultsClientListBySubscriptionOptions{Top: to.Ptr[int32](1)})
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/keyvault/resource-manager/Microsoft.KeyVault/preview/2021-11-01-preview/examples/listDeletedVaults.json
func ExampleVaultsClient_NewListDeletedPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armkeyvault.NewVaultsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListDeletedPager(nil)
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/keyvault/resource-manager/Microsoft.KeyVault/preview/2021-11-01-preview/examples/getDeletedVault.json
func ExampleVaultsClient_GetDeleted() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armkeyvault.NewVaultsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.GetDeleted(ctx,
		"sample-vault",
		"westus",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/keyvault/resource-manager/Microsoft.KeyVault/preview/2021-11-01-preview/examples/purgeDeletedVault.json
func ExampleVaultsClient_BeginPurgeDeleted() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armkeyvault.NewVaultsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := client.BeginPurgeDeleted(ctx,
		"sample-vault",
		"westus",
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/keyvault/resource-manager/Microsoft.KeyVault/preview/2021-11-01-preview/examples/listVault.json
func ExampleVaultsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armkeyvault.NewVaultsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := client.NewListPager(&armkeyvault.VaultsClientListOptions{Top: to.Ptr[int32](1)})
	for pager.More() {
		nextResult, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range nextResult.Value {
			// TODO: use page item
			_ = v
		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/tree/main/specification/keyvault/resource-manager/Microsoft.KeyVault/preview/2021-11-01-preview/examples/checkVaultNameAvailability.json
func ExampleVaultsClient_CheckNameAvailability() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client, err := armkeyvault.NewVaultsClient("00000000-0000-0000-0000-000000000000", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := client.CheckNameAvailability(ctx,
		armkeyvault.VaultCheckNameAvailabilityParameters{
			Name: to.Ptr("sample-vault"),
			Type: to.Ptr("Microsoft.KeyVault/vaults"),
		},
		nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// TODO: use response item
	_ = res
}
