/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.logging.Handler;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.core.startup.logging.DispatchingHandler;
import org.netbeans.core.startup.logging.MessagesHandler;

public final class NbLogging {
    public static final PrintStream DEBUG;
    static final Pattern unwantedMessages;

    public static boolean wantsMessage(String string) {
        return unwantedMessages == null || !unwantedMessages.matcher(string).find();
    }

    public static Handler createDispatchHandler(Handler handler, int n) {
        return new DispatchingHandler(handler, n);
    }

    public static Handler createMessagesHandler(File file) {
        return new MessagesHandler(file);
    }

    public static void close(Handler handler) {
        if (handler == null) {
            return;
        }
        if (handler instanceof DispatchingHandler) {
            ((DispatchingHandler)handler).doClose();
        } else {
            handler.close();
        }
    }

    static {
        Serializable serializable;
        PrintStream printStream = null;
        String string = System.getProperty("TopLogging.unwantedMessages");
        if (string != null || Boolean.getBoolean("TopLogging.DEBUG")) {
            try {
                serializable = new File(System.getProperty("java.io.tmpdir"), "TopLogging.log");
                System.err.println("Logging sent to: " + serializable);
                printStream = new PrintStream(new FileOutputStream((File)serializable), true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        DEBUG = printStream;
        serializable = null;
        if (string != null) {
            try {
                serializable = Pattern.compile(string);
                DEBUG.println("On the lookout for log messages matching: " + string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                patternSyntaxException.printStackTrace();
            }
        }
        unwantedMessages = serializable;
    }
}

