/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.PipelineAggregationBase;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class BucketScriptAggregation
extends PipelineAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, BucketScriptAggregation> {
    @Nullable
    private final Script script;
    public static final JsonpDeserializer<BucketScriptAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BucketScriptAggregation::setupBucketScriptAggregationDeserializer);

    private BucketScriptAggregation(Builder builder) {
        super(builder);
        this.script = builder.script;
    }

    public static BucketScriptAggregation of(Function<Builder, ObjectBuilder<BucketScriptAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.BucketScript;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupBucketScriptAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BucketScriptAggregation.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::script, Script._DESERIALIZER, "script");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.script);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketScriptAggregation other = (BucketScriptAggregation)o;
        return Objects.equals(this.script, other.script);
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, BucketScriptAggregation> {
        @Nullable
        private Script script;

        public Builder() {
        }

        private Builder(BucketScriptAggregation o) {
            super(o);
            this.script = o.script;
        }

        private Builder(Builder o) {
            super(o);
            this.script = o.script;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        @Nonnull
        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Override
        @Nonnull
        public BucketScriptAggregation build() {
            this._checkSingleUse();
            return new BucketScriptAggregation(this);
        }
    }
}

