/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Objects;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;

public class BlockGivenCallInstr
extends OneOperandResultBaseInstr
implements FixedArityInstr {
    private final FunctionalCachingCallSite blockGivenSite;

    public BlockGivenCallInstr(Variable result2, Operand block, String methodName) {
        super(Operation.BLOCK_GIVEN_CALL, Objects.requireNonNull(result2, "BlockGivenCallInstr result is null"), block);
        this.blockGivenSite = new FunctionalCachingCallSite(Objects.requireNonNull(methodName, "BlockGivenCallInstr methodName is null"));
    }

    public Operand getBlockArg() {
        return this.getOperand1();
    }

    public String getMethodName() {
        return this.blockGivenSite.getMethodName();
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BlockGivenCallInstr(ii.getRenamedVariable(this.result), this.getBlockArg().cloneForInlining(ii), this.blockGivenSite.getMethodName());
    }

    public static BlockGivenCallInstr decode(IRReaderDecoder d) {
        return new BlockGivenCallInstr(d.decodeVariable(), d.decodeOperand(), d.decodeString());
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.blockGivenSite.getMethodName());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Object blk = this.getBlockArg().retrieve(context, self2, currScope, currDynScope, temp);
        return IRRuntimeHelpers.blockGivenOrCall(context, self2, this.blockGivenSite, blk);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BlockGivenCallInstr(this);
    }
}

