/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.data.gpx.GpxImageDirectionPositionSettings;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ImageDirectionPositionPanel
extends JPanel {
    private final JCheckBox cChangeImageDirection = new JCheckBox();
    private final JSpinner sOffsetDegrees = new JSpinner(new SpinnerNumberModel(0, -360, 360, 1));
    private final JSpinner sX = new JSpinner(new SpinnerNumberModel(0.0, -50.0, 50.0, 0.1));
    private final JSpinner sY = new JSpinner(new SpinnerNumberModel(0.0, -50.0, 50.0, 0.1));
    private final JSpinner sZ = new JSpinner(new SpinnerNumberModel(0.0, -20.0, 20.0, 0.1));

    protected ImageDirectionPositionPanel(String changeDirectionText) {
        super(new GridBagLayout());
        this.cChangeImageDirection.setText(changeDirectionText);
        this.add((Component)this.cChangeImageDirection, GBC.eol().insets(0, 0, 0, 5));
        this.cChangeImageDirection.addActionListener(e -> this.sOffsetDegrees.setEnabled(!this.sOffsetDegrees.isEnabled()));
        this.addSetting(I18n.tr("Offset angle in degrees:", new Object[0]), this.sOffsetDegrees);
        this.sOffsetDegrees.setEnabled(false);
        this.add((Component)new JSeparator(0), GBC.eol().fill(2).insets(0, 12, 0, 12));
        this.add((Component)new JLabel(I18n.tr("Shift image relative to the direction (in meters)", new Object[0])), GBC.eol().insets(0, 0, 0, 5));
        this.addSetting(I18n.tr("X:", new Object[0]), this.sX);
        this.addSetting(I18n.tr("Y:", new Object[0]), this.sY);
        this.addSetting(I18n.tr("Elevation:", new Object[0]), this.sZ);
    }

    public static ImageDirectionPositionPanel forGpxTrace() {
        return new ImageDirectionPositionPanel(I18n.tr("Set image direction towards the next GPX waypoint", new Object[0]));
    }

    public static ImageDirectionPositionPanel forImageSequence() {
        return new ImageDirectionPositionPanel(I18n.tr("Set image direction towards the next one", new Object[0]));
    }

    protected void addSetting(String text, JComponent component) {
        this.add((Component)new JLabel(text, 4), GBC.std().insets(15, 0, 5, 5).fill(2).weight(0.0, 0.0));
        this.add((Component)component, GBC.std().fill(2));
        this.add(GBC.glue(1, 0), GBC.eol().fill(2).weight(1.0, 0.0));
    }

    public GpxImageDirectionPositionSettings getSettings() {
        return new GpxImageDirectionPositionSettings(this.cChangeImageDirection.isSelected(), ((Integer)this.sOffsetDegrees.getValue()).intValue(), (Double)this.sX.getValue(), (Double)this.sY.getValue(), (Double)this.sZ.getValue());
    }

    public void addFocusListenerOnComponent(FocusListener focusListener) {
        this.sOffsetDegrees.addFocusListener(focusListener);
        this.sX.addFocusListener(focusListener);
        this.sY.addFocusListener(focusListener);
        this.sZ.addFocusListener(focusListener);
    }

    public void addItemListenerOnComponents(ItemListener listener) {
        this.cChangeImageDirection.addItemListener(listener);
    }

    public void addChangeListenerOnComponents(ChangeListener listener) {
        this.sOffsetDegrees.addChangeListener(listener);
        this.sX.addChangeListener(listener);
        this.sY.addChangeListener(listener);
        this.sZ.addChangeListener(listener);
    }
}

