/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Alter an image with additive Gaussian white noise.


Additive Gaussian white noise can be modeled as:


$ I = I_0 + N $

where $ I $ is the observed image, $ I_0 $ is the noise-free image and $ N $ is a normally distributed random variable of mean $ \\mu $ and variance $ \\sigma^2 $ :

$ N \\sim \\mathcal{N}(\\mu, \\sigma^2) $
 The noise is independent of the pixel intensities.


Gaetan Lehmann
 This code was contributed in the Insight Journal paper "Noise
Simulation". https://doi.org/10.54294/vh6vbw
See:
 itk::simple::AdditiveGaussianNoise for the procedural interface

 itk::AdditiveGaussianNoiseImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkAdditiveGaussianNoiseImageFilter.h
*/
public class AdditiveGaussianNoiseImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected AdditiveGaussianNoiseImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.AdditiveGaussianNoiseImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(AdditiveGaussianNoiseImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(AdditiveGaussianNoiseImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::AdditiveGaussianNoiseImageFilter::~AdditiveGaussianNoiseImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_AdditiveGaussianNoiseImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::AdditiveGaussianNoiseImageFilter::AdditiveGaussianNoiseImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  AdditiveGaussianNoiseImageFilter() {
    this(SimpleITKJNI.new_AdditiveGaussianNoiseImageFilter(), true);
  }

  /**
Self&amp; itk::simple::AdditiveGaussianNoiseImageFilter::SetStandardDeviation(double StandardDeviation)

Set/Get the standard deviation of the Gaussian distribution. Defaults
to 1.0.

*/
public  void setStandardDeviation(double StandardDeviation) {
    SimpleITKJNI.AdditiveGaussianNoiseImageFilter_setStandardDeviation(swigCPtr, this, StandardDeviation);
  }

  /**
double itk::simple::AdditiveGaussianNoiseImageFilter::GetStandardDeviation() const

Set/Get the standard deviation of the Gaussian distribution. Defaults
to 1.0.

*/
public  double getStandardDeviation() {
    return SimpleITKJNI.AdditiveGaussianNoiseImageFilter_getStandardDeviation(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::AdditiveGaussianNoiseImageFilter::SetMean(double Mean)

Set/Get the mean of the Gaussian distribution. Defaults to 0.0.

*/
public  void setMean(double Mean) {
    SimpleITKJNI.AdditiveGaussianNoiseImageFilter_setMean(swigCPtr, this, Mean);
  }

  /**
double itk::simple::AdditiveGaussianNoiseImageFilter::GetMean() const

Set/Get the mean of the Gaussian distribution. Defaults to 0.0.

*/
public  double getMean() {
    return SimpleITKJNI.AdditiveGaussianNoiseImageFilter_getMean(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::AdditiveGaussianNoiseImageFilter::SetSeed(uint32_t Seed)
*/
public  void setSeed(long Seed) {
    SimpleITKJNI.AdditiveGaussianNoiseImageFilter_setSeed(swigCPtr, this, Seed);
  }

  /**
uint32_t itk::simple::AdditiveGaussianNoiseImageFilter::GetSeed() const
*/
public  long getSeed() {
    return SimpleITKJNI.AdditiveGaussianNoiseImageFilter_getSeed(swigCPtr, this);
  }

  /**
std::string itk::simple::AdditiveGaussianNoiseImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.AdditiveGaussianNoiseImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::AdditiveGaussianNoiseImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.AdditiveGaussianNoiseImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::AdditiveGaussianNoiseImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.AdditiveGaussianNoiseImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
