/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.Param;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import java.io.IOException;

public abstract class Macro
extends AbstractTeXObject {
    protected boolean isShort = true;
    protected boolean allowsPrefix = false;
    public static final byte PREFIX_NONE = 0;
    public static final byte PREFIX_LONG = 1;
    public static final byte PREFIX_GLOBAL = 2;
    protected byte prefix = 0;
    protected TeXObjectList syntax = null;
    protected int numArgs = 0;
    protected boolean isDelimited = false;

    public boolean getAllowsPrefix() {
        return this.allowsPrefix;
    }

    protected void setAllowsPrefix(boolean bl) {
        this.allowsPrefix = bl;
    }

    public boolean isShort() {
        return (this.prefix & 1) == 1 ? false : this.isShort;
    }

    protected void setShort(boolean bl) {
        this.isShort = bl;
    }

    public void setPrefix(byte by) {
        if (this.allowsPrefix) {
            this.prefix = by;
        }
    }

    public byte getPrefix() {
        return this.allowsPrefix ? this.prefix : (byte)0;
    }

    public void clearPrefix() {
        this.prefix = 0;
    }

    public TeXObjectList getSyntax() {
        return this.syntax;
    }

    protected void setSyntax(TeXObjectList teXObjectList) {
        this.syntax = teXObjectList;
        this.isDelimited = false;
        if (teXObjectList != null) {
            this.numArgs = 0;
            for (TeXObject teXObject : teXObjectList) {
                if (!(teXObject instanceof Param)) continue;
                if (((Param)teXObject).getDigit() == -1) {
                    this.isDelimited = true;
                    continue;
                }
                ++this.numArgs;
            }
        }
    }

    protected void setSyntax(TeXParserListener teXParserListener, int n) {
        this.isDelimited = false;
        this.numArgs = n;
        if (this.numArgs == 0) {
            this.syntax = null;
        } else {
            this.syntax = new TeXObjectList(this.numArgs);
            for (int i = 1; i <= this.numArgs; ++i) {
                this.syntax.add(teXParserListener.getParam(i));
            }
        }
    }

    protected void setSyntax(TeXObject[] teXObjectArray) {
        this.isDelimited = false;
        this.numArgs = 0;
        if (teXObjectArray == null || teXObjectArray.length == 0) {
            this.syntax = null;
        } else {
            this.syntax = new TeXObjectList(teXObjectArray.length);
            for (int i = 0; i < teXObjectArray.length; ++i) {
                if (teXObjectArray[i] instanceof Param) {
                    if (((Param)teXObjectArray[i]).getDigit() == -1) {
                        this.isDelimited = true;
                    } else {
                        ++this.numArgs;
                    }
                }
                this.syntax.add(teXObjectArray[i]);
            }
        }
    }

    public boolean hasSyntax(Macro macro) {
        if (this.numArgs != macro.numArgs) {
            return false;
        }
        TeXObjectList teXObjectList = macro.syntax;
        if (this.syntax == null && teXObjectList == null) {
            return true;
        }
        if (this.syntax == null || teXObjectList == null) {
            return false;
        }
        return this.syntax.equals(teXObjectList);
    }

    public boolean hasNoSyntax() {
        return this.numArgs == 0 && (this.syntax == null || this.syntax.isEmpty());
    }

    protected int popModifier(TeXParser teXParser, TeXObjectList teXObjectList, int ... nArray) throws IOException {
        return TeXParserUtils.popModifier(teXParser, teXObjectList, nArray);
    }

    protected String popLabelString(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return TeXParserUtils.popLabelString(teXParser, teXObjectList);
    }

    protected String popOptLabelString(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return TeXParserUtils.popOptLabelString(teXParser, teXObjectList);
    }

    protected TeXObject popArg(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        byte by = TeXObjectList.getArgPopStyle(this.isShort());
        return TeXParserUtils.popArg(teXParser, teXObjectList, by);
    }

    protected TeXObject popOptArg(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        byte by = TeXObjectList.getArgPopStyle(this.isShort());
        return TeXParserUtils.popOptArg(by, teXParser, teXObjectList);
    }

    protected TeXObject popOptArg(byte by, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return TeXParserUtils.popOptArg(by, teXParser, teXObjectList);
    }

    protected TeXObject popArgExpandFully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return TeXParserUtils.popArgExpandFully(teXParser, teXObjectList);
    }

    protected TeXObject popArgExpandOnce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return TeXParserUtils.popArgExpandOnce(teXParser, teXObjectList);
    }

    protected TeXObject popOptArgExpandFully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return TeXParserUtils.popOptArgExpandFully(teXParser, teXObjectList);
    }

    protected int popInt(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return TeXParserUtils.popInt(teXParser, teXObjectList);
    }

    protected Numerical popNumericalArg(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return TeXParserUtils.popNumericalArg(teXParser, teXObjectList);
    }

    protected NumericRegister popNumericRegister(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return TeXParserUtils.popNumericRegister(teXParser, teXObjectList);
    }

    protected TeXDimension popDimensionArg(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return TeXParserUtils.popDimensionArg(teXParser, teXObjectList);
    }

    protected TeXDimension popOptDimensionArg(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return TeXParserUtils.popOptDimensionArg(teXParser, teXObjectList);
    }

    protected ControlSequence popControlSequence(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return TeXParserUtils.popControlSequence(teXParser, teXObjectList);
    }

    @Override
    public abstract Object clone();

    public String toString() {
        return String.format("%s[prefix=%d,syntax=%s]", this.getClass().getSimpleName(), this.getPrefix(), this.syntax);
    }
}

