/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ShareFetchResponse;

public class ErroneousAndValidPartitionData {
    private final Map<TopicIdPartition, ShareFetchResponseData.PartitionData> erroneous;
    private final List<TopicIdPartition> validTopicIdPartitions;

    public ErroneousAndValidPartitionData(Map<TopicIdPartition, ShareFetchResponseData.PartitionData> erroneous, List<TopicIdPartition> validTopicIdPartitions) {
        this.erroneous = erroneous;
        this.validTopicIdPartitions = validTopicIdPartitions;
    }

    public ErroneousAndValidPartitionData(List<TopicIdPartition> shareFetchData) {
        this.erroneous = new HashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>();
        this.validTopicIdPartitions = new ArrayList<TopicIdPartition>();
        shareFetchData.forEach(topicIdPartition -> {
            if (topicIdPartition.topic() == null) {
                this.erroneous.put((TopicIdPartition)topicIdPartition, ShareFetchResponse.partitionResponse((TopicIdPartition)topicIdPartition, (Errors)Errors.UNKNOWN_TOPIC_ID));
            } else {
                this.validTopicIdPartitions.add((TopicIdPartition)topicIdPartition);
            }
        });
    }

    public ErroneousAndValidPartitionData() {
        this.erroneous = Map.of();
        this.validTopicIdPartitions = List.of();
    }

    public Map<TopicIdPartition, ShareFetchResponseData.PartitionData> erroneous() {
        return this.erroneous;
    }

    public List<TopicIdPartition> validTopicIdPartitions() {
        return this.validTopicIdPartitions;
    }
}

