/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json.base;

import com.github.wnameless.json.base.GsonJsonArray;
import com.github.wnameless.json.base.GsonJsonValue;
import com.github.wnameless.json.base.JsonObjectCore;
import com.github.wnameless.json.base.JsonSource;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class GsonJsonObject
implements JsonObjectCore<GsonJsonValue> {
    private final JsonObject jsonObject;

    public GsonJsonObject(JsonObject jsonObject) {
        if (jsonObject == null) {
            throw new NullPointerException();
        }
        this.jsonObject = jsonObject;
    }

    @Override
    public GsonJsonValue get(String name) {
        JsonElement element = this.jsonObject.get(name);
        return element == null ? null : new GsonJsonValue(element);
    }

    public int hashCode() {
        return this.jsonObject.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GsonJsonObject)) {
            return false;
        }
        return Objects.equals(this.jsonObject, ((GsonJsonObject)o).jsonObject);
    }

    public String toString() {
        return this.jsonObject.toString();
    }

    @Override
    public Iterator<Map.Entry<String, GsonJsonValue>> iterator() {
        return new GsonJsonEntryIterator(this.jsonObject.entrySet().iterator());
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    @Override
    public int size() {
        return this.jsonObject.size();
    }

    @Override
    public void set(String name, JsonSource jsonValue) {
        this.jsonObject.add(name, (JsonElement)jsonValue.getSource());
    }

    @Override
    public boolean remove(String name) {
        return this.jsonObject.remove(name) != null;
    }

    @Override
    public boolean contains(String name) {
        return this.jsonObject.has(name);
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public GsonJsonObject asObject() {
        return this;
    }

    @Override
    public GsonJsonArray asArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GsonJsonValue asValue() {
        return new GsonJsonValue((JsonElement)this.jsonObject);
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int asInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger asBigInteger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double asDouble() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getSource() {
        return this.jsonObject;
    }

    @Override
    public Iterator<String> names() {
        return this.jsonObject.keySet().iterator();
    }

    private final class GsonJsonEntryIterator
    implements Iterator<Map.Entry<String, GsonJsonValue>> {
        private final Iterator<Map.Entry<String, JsonElement>> jsonElementIterator;

        private GsonJsonEntryIterator(Iterator<Map.Entry<String, JsonElement>> jsonElementIterator) {
            this.jsonElementIterator = jsonElementIterator;
        }

        @Override
        public boolean hasNext() {
            return this.jsonElementIterator.hasNext();
        }

        @Override
        public Map.Entry<String, GsonJsonValue> next() {
            Map.Entry<String, JsonElement> member = this.jsonElementIterator.next();
            return new AbstractMap.SimpleImmutableEntry<String, GsonJsonValue>(member.getKey(), new GsonJsonValue(member.getValue()));
        }
    }
}

