/* tracker-bus.c generated by valac 0.56.3, the Vala compiler
 * generated from tracker-bus.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include "tracker-bus.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "libtracker-sparql/tracker-generated-no-checks.h"
#include "libtracker-common/tracker-common.h"
#include <gio/gunixinputstream.h>
#include <gio/gunixoutputstream.h>
#include <unistd.h>
#include <gio/gunixfdlist.h>
#include <glib-object.h>

enum  {
	TRACKER_BUS_CONNECTION_0_PROPERTY,
	TRACKER_BUS_CONNECTION_NUM_PROPERTIES
};
static GParamSpec* tracker_bus_connection_properties[TRACKER_BUS_CONNECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
typedef struct _Block2Data Block2Data;

#define TRACKER_BUS_TYPE_FD_CURSOR (tracker_bus_fd_cursor_get_type ())
#define TRACKER_BUS_FD_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BUS_TYPE_FD_CURSOR, TrackerBusFDCursor))
#define TRACKER_BUS_FD_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_BUS_TYPE_FD_CURSOR, TrackerBusFDCursorClass))
#define TRACKER_BUS_IS_FD_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BUS_TYPE_FD_CURSOR))
#define TRACKER_BUS_IS_FD_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_BUS_TYPE_FD_CURSOR))
#define TRACKER_BUS_FD_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_BUS_TYPE_FD_CURSOR, TrackerBusFDCursorClass))

typedef struct _TrackerBusFDCursor TrackerBusFDCursor;
typedef struct _TrackerBusFDCursorClass TrackerBusFDCursorClass;
typedef struct _TrackerBusConnectionQueryAsyncData TrackerBusConnectionQueryAsyncData;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _TrackerBusConnectionUpdateAsyncData TrackerBusConnectionUpdateAsyncData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
typedef struct _TrackerBusConnectionUpdateArrayAsyncData TrackerBusConnectionUpdateArrayAsyncData;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _TrackerBusConnectionUpdateBlankAsyncData TrackerBusConnectionUpdateBlankAsyncData;
typedef struct _TrackerBusConnectionLoadAsyncData TrackerBusConnectionLoadAsyncData;

#define TRACKER_BUS_TYPE_ARRAY_CURSOR (tracker_bus_array_cursor_get_type ())
#define TRACKER_BUS_ARRAY_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursor))
#define TRACKER_BUS_ARRAY_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursorClass))
#define TRACKER_BUS_IS_ARRAY_CURSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_BUS_TYPE_ARRAY_CURSOR))
#define TRACKER_BUS_IS_ARRAY_CURSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_BUS_TYPE_ARRAY_CURSOR))
#define TRACKER_BUS_ARRAY_CURSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_BUS_TYPE_ARRAY_CURSOR, TrackerBusArrayCursorClass))

typedef struct _TrackerBusArrayCursor TrackerBusArrayCursor;
typedef struct _TrackerBusArrayCursorClass TrackerBusArrayCursorClass;
typedef struct _TrackerBusConnectionStatisticsAsyncData TrackerBusConnectionStatisticsAsyncData;

struct _TrackerBusConnectionPrivate {
	GDBusConnection* bus;
	gchar* dbus_name;
};

struct _Block1Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GMainLoop* loop;
	GAsyncResult* async_res;
};

struct _Block2Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GAsyncResult* dbus_res;
	gboolean received_result;
	gpointer _async_data_;
};

struct _TrackerBusConnectionQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	Block2Data* _data2_;
	GUnixInputStream* input;
	GUnixOutputStream* output;
	GUnixInputStream* _tmp0_;
	GUnixOutputStream* _tmp1_;
	GUnixOutputStream* _tmp2_;
	GMemoryOutputStream* mem_stream;
	GMemoryOutputStream* _tmp3_;
	GMemoryOutputStream* _tmp4_;
	GUnixInputStream* _tmp5_;
	GError* _inner_error1_;
	GAsyncResult* _tmp6_;
	GDBusMessage* reply;
	GDBusConnection* _tmp7_;
	GAsyncResult* _tmp8_;
	GDBusMessage* _tmp9_;
	GDBusMessage* _tmp10_;
	gchar** variable_names;
	GDBusMessage* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gint variable_names_length1;
	gint _variable_names_size_;
	GMemoryOutputStream* _tmp17_;
	GMemoryOutputStream* _tmp18_;
	guint8* _tmp19_;
	GMemoryOutputStream* _tmp20_;
	gulong _tmp21_;
	gulong _tmp22_;
	gchar** _tmp23_;
	gint _tmp23__length1;
	TrackerBusFDCursor* _tmp24_;
	GError* _inner_error0_;
};

struct _Block3Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GMainLoop* loop;
	GAsyncResult* async_res;
};

struct _Block4Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GAsyncResult* dbus_res;
	gboolean sent_update;
	gpointer _async_data_;
};

struct _TrackerBusConnectionUpdateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	Block4Data* _data4_;
	GUnixInputStream* input;
	GUnixOutputStream* output;
	GUnixInputStream* _tmp0_;
	GUnixOutputStream* _tmp1_;
	const gchar* _tmp2_;
	GUnixInputStream* _tmp3_;
	GDataOutputStream* data_stream;
	GUnixOutputStream* _tmp4_;
	GDataOutputStream* _tmp5_;
	GDataOutputStream* _tmp6_;
	GDataOutputStream* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GDataOutputStream* _tmp10_;
	GAsyncResult* _tmp11_;
	GDBusMessage* reply;
	GDBusConnection* _tmp12_;
	GAsyncResult* _tmp13_;
	GDBusMessage* _tmp14_;
	GDBusMessage* _tmp15_;
	GError* _inner_error0_;
};

struct _Block5Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GAsyncResult* dbus_res;
	gboolean sent_update;
	gpointer _async_data_;
};

struct _TrackerBusConnectionUpdateArrayAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	gchar** sparql;
	gint sparql_length1;
	gint priority;
	GCancellable* cancellable;
	GPtrArray* result;
	Block5Data* _data5_;
	GUnixInputStream* input;
	GUnixOutputStream* output;
	GUnixInputStream* _tmp0_;
	GUnixOutputStream* _tmp1_;
	GUnixInputStream* _tmp2_;
	GDataOutputStream* data_stream;
	GUnixOutputStream* _tmp3_;
	GDataOutputStream* _tmp4_;
	GDataOutputStream* _tmp5_;
	GDataOutputStream* _tmp6_;
	gint i;
	gboolean _tmp7_;
	gint _tmp8_;
	GDataOutputStream* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GDataOutputStream* _tmp13_;
	const gchar* _tmp14_;
	GAsyncResult* _tmp15_;
	GDBusMessage* reply;
	GDBusConnection* _tmp16_;
	GAsyncResult* _tmp17_;
	GDBusMessage* _tmp18_;
	GDBusMessage* _tmp19_;
	GPtrArray* _result_;
	GPtrArray* _tmp20_;
	GVariant* resultv;
	GDBusMessage* _tmp21_;
	GVariant* _tmp22_;
	GVariant* _tmp23_;
	GVariantIter* iter;
	GVariant* _tmp24_;
	GVariantIter* _tmp25_;
	gchar* code;
	gchar* message;
	GVariantIter* _tmp26_;
	gchar* _tmp27_;
	gboolean _tmp28_;
	GVariantIter* _tmp29_;
	gchar* _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	GPtrArray* _tmp35_;
	const gchar* _tmp36_;
	GError* _tmp37_;
	GPtrArray* _tmp38_;
	GError* _inner_error0_;
};

struct _Block6Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GMainLoop* loop;
	GAsyncResult* async_res;
};

struct _Block7Data {
	int _ref_count_;
	TrackerBusConnection* self;
	GAsyncResult* dbus_res;
	gboolean sent_update;
	gpointer _async_data_;
};

struct _TrackerBusConnectionUpdateBlankAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
	Block7Data* _data7_;
	GUnixInputStream* input;
	GUnixOutputStream* output;
	GUnixInputStream* _tmp0_;
	GUnixOutputStream* _tmp1_;
	GUnixInputStream* _tmp2_;
	GDataOutputStream* data_stream;
	GUnixOutputStream* _tmp3_;
	GDataOutputStream* _tmp4_;
	GDataOutputStream* _tmp5_;
	GDataOutputStream* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GDataOutputStream* _tmp9_;
	GAsyncResult* _tmp10_;
	GDBusMessage* reply;
	GDBusConnection* _tmp11_;
	GAsyncResult* _tmp12_;
	GDBusMessage* _tmp13_;
	GDBusMessage* _tmp14_;
	GDBusMessage* _tmp15_;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	GError* _inner_error0_;
};

struct _TrackerBusConnectionLoadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	GFile* file;
	GCancellable* cancellable;
	GDBusMessage* message;
	const gchar* _tmp0_;
	GDBusMessage* _tmp1_;
	GDBusMessage* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GDBusMessage* reply;
	GDBusConnection* _tmp7_;
	GDBusMessage* _tmp8_;
	GDBusMessage* _tmp9_;
	GDBusMessage* _tmp10_;
	GError* _inner_error0_;
};

struct _TrackerBusConnectionStatisticsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerBusConnection* self;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	GDBusMessage* message;
	const gchar* _tmp0_;
	GDBusMessage* _tmp1_;
	GDBusMessage* reply;
	GDBusConnection* _tmp2_;
	GDBusMessage* _tmp3_;
	GDBusMessage* _tmp4_;
	GDBusMessage* _tmp5_;
	gchar** results;
	GDBusMessage* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gint _tmp11__length2;
	gint results_length1;
	gint results_length2;
	TrackerSparqlValueType* types;
	TrackerSparqlValueType* _tmp12_;
	gint types_length1;
	gint _types_size_;
	gchar** var_names;
	gchar** _tmp13_;
	gint var_names_length1;
	gint _var_names_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar* _tmp17_;
	TrackerSparqlValueType* _tmp18_;
	gint _tmp18__length1;
	TrackerSparqlValueType* _tmp19_;
	gint _tmp19__length1;
	gint rows;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gint _tmp20__length2;
	gint _tmp21_;
	gint cols;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gint _tmp22__length2;
	gint _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gint _tmp24__length2;
	gchar** _tmp25_;
	gint _tmp25__length1;
	TrackerSparqlValueType* _tmp26_;
	gint _tmp26__length1;
	TrackerBusArrayCursor* _tmp27_;
	GError* _inner_error0_;
};

static gint TrackerBusConnection_private_offset;
static gpointer tracker_bus_connection_parent_class = NULL;

static void tracker_bus_connection_pipe (TrackerBusConnection* self,
                                  GUnixInputStream** input,
                                  GUnixOutputStream** output,
                                  GError** error);
static void tracker_bus_connection_handle_error_reply (TrackerBusConnection* self,
                                                GDBusMessage* message,
                                                GError** error);
static void tracker_bus_connection_send_query (TrackerBusConnection* self,
                                        const gchar* sparql,
                                        GUnixOutputStream* output,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback callback,
                                        gpointer callback_target,
                                        GError** error);
static TrackerSparqlCursor* tracker_bus_connection_real_query (TrackerSparqlConnection* base,
                                                        const gchar* sparql,
                                                        GCancellable* cancellable,
                                                        GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda5_ (Block1Data* _data1_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void tracker_bus_connection_real_query_async_data_free (gpointer _data);
static void tracker_bus_connection_real_query_async (TrackerSparqlConnection* base,
                                              const gchar* sparql,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean tracker_bus_connection_real_query_async_co (TrackerBusConnectionQueryAsyncData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda4_ (Block2Data* _data2_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void* _g_realloc_grealloc_func (void* data,
                                gsize size);
static void _g_free_gdestroy_notify (void* data);
static void tracker_bus_connection_query_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static gchar** _variant_get1 (GVariant* value,
                       gint* result_length1);
VALA_EXTERN TrackerBusFDCursor* tracker_bus_fd_cursor_new (gchar* buffer,
                                               gulong buffer_size,
                                               gchar** variable_names,
                                               gint variable_names_length1);
VALA_EXTERN TrackerBusFDCursor* tracker_bus_fd_cursor_construct (GType object_type,
                                                     gchar* buffer,
                                                     gulong buffer_size,
                                                     gchar** variable_names,
                                                     gint variable_names_length1);
VALA_EXTERN GType tracker_bus_fd_cursor_get_type (void) G_GNUC_CONST ;
static void tracker_bus_connection_send_update (TrackerBusConnection* self,
                                         const gchar* method,
                                         GUnixInputStream* input,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback callback,
                                         gpointer callback_target,
                                         GError** error);
static void tracker_bus_connection_real_update (TrackerSparqlConnection* base,
                                         const gchar* sparql,
                                         gint priority,
                                         GCancellable* cancellable,
                                         GError** error);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda7_ (Block3Data* _data3_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda7__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void tracker_bus_connection_real_update_async_data_free (gpointer _data);
static void tracker_bus_connection_real_update_async (TrackerSparqlConnection* base,
                                               const gchar* sparql,
                                               gint priority,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean tracker_bus_connection_real_update_async_co (TrackerBusConnectionUpdateAsyncData* _data_);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda6_ (Block4Data* _data4_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda6__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void tracker_bus_connection_real_update_array_async_data_free (gpointer _data);
static void tracker_bus_connection_real_update_array_async (TrackerSparqlConnection* base,
                                                     gchar** sparql,
                                                     gint sparql_length1,
                                                     gint priority,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean tracker_bus_connection_real_update_array_async_co (TrackerBusConnectionUpdateArrayAsyncData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda8_ (Block5Data* _data5_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda8__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void _g_error_free0_ (gpointer var);
static GVariant* tracker_bus_connection_real_update_blank (TrackerSparqlConnection* base,
                                                    const gchar* sparql,
                                                    gint priority,
                                                    GCancellable* cancellable,
                                                    GError** error);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda10_ (Block6Data* _data6_,
                  GObject* o,
                  GAsyncResult* res);
static void ___lambda10__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void tracker_bus_connection_real_update_blank_async_data_free (gpointer _data);
static void tracker_bus_connection_real_update_blank_async (TrackerSparqlConnection* base,
                                                     const gchar* sparql,
                                                     gint priority,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static gboolean tracker_bus_connection_real_update_blank_async_co (TrackerBusConnectionUpdateBlankAsyncData* _data_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda9_ (Block7Data* _data7_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda9__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void tracker_bus_connection_real_load (TrackerSparqlConnection* base,
                                       GFile* file,
                                       GCancellable* cancellable,
                                       GError** error);
static void tracker_bus_connection_real_load_async_data_free (gpointer _data);
static void tracker_bus_connection_real_load_async (TrackerSparqlConnection* base,
                                             GFile* file,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static gboolean tracker_bus_connection_real_load_async_co (TrackerBusConnectionLoadAsyncData* _data_);
static void tracker_bus_connection_load_async_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static TrackerSparqlCursor* tracker_bus_connection_real_statistics (TrackerSparqlConnection* base,
                                                             GCancellable* cancellable,
                                                             GError** error);
static gchar** _variant_get2 (GVariant* value,
                       gint* result_length1,
                       gint* result_length2);
VALA_EXTERN TrackerBusArrayCursor* tracker_bus_array_cursor_new (gchar** results,
                                                     gint results_length1,
                                                     gint results_length2,
                                                     gint rows,
                                                     gint cols,
                                                     gchar** var_names,
                                                     gint var_names_length1,
                                                     TrackerSparqlValueType* types,
                                                     gint types_length1);
VALA_EXTERN TrackerBusArrayCursor* tracker_bus_array_cursor_construct (GType object_type,
                                                           gchar** results,
                                                           gint results_length1,
                                                           gint results_length2,
                                                           gint rows,
                                                           gint cols,
                                                           gchar** var_names,
                                                           gint var_names_length1,
                                                           TrackerSparqlValueType* types,
                                                           gint types_length1);
VALA_EXTERN GType tracker_bus_array_cursor_get_type (void) G_GNUC_CONST ;
static void tracker_bus_connection_real_statistics_async_data_free (gpointer _data);
static void tracker_bus_connection_real_statistics_async (TrackerSparqlConnection* base,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean tracker_bus_connection_real_statistics_async_co (TrackerBusConnectionStatisticsAsyncData* _data_);
static void tracker_bus_connection_statistics_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static gchar** _variant_get3 (GVariant* value,
                       gint* result_length1,
                       gint* result_length2);
static void tracker_bus_connection_finalize (GObject * obj);
static GType tracker_bus_connection_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
tracker_bus_connection_get_instance_private (TrackerBusConnection* self)
{
	return G_STRUCT_MEMBER_P (self, TrackerBusConnection_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 30 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return self ? g_object_ref (self) : NULL;
#line 633 "tracker-bus.c"
}

TrackerBusConnection*
tracker_bus_connection_construct (GType object_type,
                                  const gchar* dbus_name,
                                  GDBusConnection* dbus_connection,
                                  gboolean start,
                                  GError** error)
{
	TrackerBusConnection * self = NULL;
	gchar* _tmp0_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _inner_error0_ = NULL;
#line 24 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_val_if_fail (dbus_name != NULL, NULL);
#line 24 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = (TrackerBusConnection*) tracker_sparql_connection_construct (object_type);
#line 25 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = g_strdup (dbus_name);
#line 25 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_free0 (self->priv->dbus_name);
#line 25 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self->priv->dbus_name = _tmp0_;
#line 27 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (dbus_connection == NULL) {
#line 660 "tracker-bus.c"
		GDBusConnection* _tmp1_ = NULL;
		GDBusConnection* _tmp2_;
		GDBusConnection* _tmp3_;
#line 28 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp2_ = g_bus_get_sync (tracker_ipc_bus (), NULL, &_inner_error0_);
#line 28 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp1_ = _tmp2_;
#line 28 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 28 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_propagate_error (error, _inner_error0_);
#line 28 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (self);
#line 28 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return NULL;
#line 676 "tracker-bus.c"
		}
#line 28 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp3_ = _tmp1_;
#line 28 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp1_ = NULL;
#line 28 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (self->priv->bus);
#line 28 "../tracker/src/libtracker-bus/tracker-bus.vala"
		self->priv->bus = _tmp3_;
#line 27 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_tmp1_);
#line 688 "tracker-bus.c"
	} else {
		GDBusConnection* _tmp4_;
#line 30 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp4_ = _g_object_ref0 (dbus_connection);
#line 30 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (self->priv->bus);
#line 30 "../tracker/src/libtracker-bus/tracker-bus.vala"
		self->priv->bus = _tmp4_;
#line 697 "tracker-bus.c"
	}
#line 32 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (start) {
#line 701 "tracker-bus.c"
		GDBusMessage* msg = NULL;
		GDBusMessage* _tmp5_;
		GDBusMessage* _tmp6_ = NULL;
		GDBusConnection* _tmp7_;
		GDBusMessage* _tmp8_;
		GDBusMessage* _tmp9_;
#line 33 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_debug ("Waiting for service to become available...");
#line 37 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp5_ = g_dbus_message_new_method_call (dbus_name, TRACKER_DBUS_OBJECT_STATUS, TRACKER_DBUS_INTERFACE_STATUS, "Wait");
#line 37 "../tracker/src/libtracker-bus/tracker-bus.vala"
		msg = _tmp5_;
#line 38 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp7_ = self->priv->bus;
#line 38 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp8_ = msg;
#line 38 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp9_ = g_dbus_connection_send_message_with_reply_sync (_tmp7_, _tmp8_, 0, G_MAXINT, NULL, NULL, &_inner_error0_);
#line 38 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp6_ = _tmp9_;
#line 38 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 38 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_propagate_error (error, _inner_error0_);
#line 38 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (msg);
#line 38 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (self);
#line 38 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return NULL;
#line 732 "tracker-bus.c"
		}
#line 38 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_dbus_message_to_gerror (_tmp6_, &_inner_error0_);
#line 38 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 38 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_propagate_error (error, _inner_error0_);
#line 38 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_tmp6_);
#line 38 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (msg);
#line 38 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (self);
#line 38 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return NULL;
#line 748 "tracker-bus.c"
		}
#line 40 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_debug ("Service is ready");
#line 32 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_tmp6_);
#line 32 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (msg);
#line 756 "tracker-bus.c"
	}
#line 44 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp10_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, "");
#line 44 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp11_ = _tmp10_;
#line 44 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_error_free0 (_tmp11_);
#line 24 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return self;
#line 766 "tracker-bus.c"
}

TrackerBusConnection*
tracker_bus_connection_new (const gchar* dbus_name,
                            GDBusConnection* dbus_connection,
                            gboolean start,
                            GError** error)
{
#line 24 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return tracker_bus_connection_construct (TRACKER_BUS_TYPE_CONNECTION, dbus_name, dbus_connection, start, error);
#line 777 "tracker-bus.c"
}

static void
tracker_bus_connection_pipe (TrackerBusConnection* self,
                             GUnixInputStream** input,
                             GUnixOutputStream** output,
                             GError** error)
{
	GUnixInputStream* _vala_input = NULL;
	GUnixOutputStream* _vala_output = NULL;
	gint pipefd[2] = {0};
	gint _tmp1_;
	GUnixInputStream* _tmp2_;
	gint _tmp3_;
	GUnixOutputStream* _tmp4_;
	GError* _inner_error0_ = NULL;
#line 47 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (self != NULL);
#line 49 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (pipe (pipefd) < 0) {
#line 798 "tracker-bus.c"
		GError* _tmp0_;
#line 50 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, "Pipe creation failed");
#line 50 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_inner_error0_ = _tmp0_;
#line 50 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (_inner_error0_->domain == G_IO_ERROR) {
#line 50 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_propagate_error (error, _inner_error0_);
#line 50 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_vala_input);
#line 50 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_vala_output);
#line 50 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return;
#line 814 "tracker-bus.c"
		} else {
#line 50 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_vala_input);
#line 50 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_vala_output);
#line 50 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 50 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_clear_error (&_inner_error0_);
#line 50 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return;
#line 826 "tracker-bus.c"
		}
	}
#line 52 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp1_ = pipefd[0];
#line 52 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp2_ = (GUnixInputStream*) g_unix_input_stream_new (_tmp1_, TRUE);
#line 52 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_vala_input);
#line 52 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_vala_input = _tmp2_;
#line 53 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp3_ = pipefd[1];
#line 53 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp4_ = (GUnixOutputStream*) g_unix_output_stream_new (_tmp3_, TRUE);
#line 53 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_vala_output);
#line 53 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_vala_output = _tmp4_;
#line 47 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (input) {
#line 47 "../tracker/src/libtracker-bus/tracker-bus.vala"
		*input = _vala_input;
#line 849 "tracker-bus.c"
	} else {
#line 47 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_vala_input);
#line 853 "tracker-bus.c"
	}
#line 47 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (output) {
#line 47 "../tracker/src/libtracker-bus/tracker-bus.vala"
		*output = _vala_output;
#line 859 "tracker-bus.c"
	} else {
#line 47 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_vala_output);
#line 863 "tracker-bus.c"
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
#line 60 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return self ? g_error_copy (self) : NULL;
#line 872 "tracker-bus.c"
}

static void
tracker_bus_connection_handle_error_reply (TrackerBusConnection* self,
                                           GDBusMessage* message,
                                           GError** error)
{
	GError* _inner_error0_ = NULL;
#line 56 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (self != NULL);
#line 56 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (message != NULL);
#line 885 "tracker-bus.c"
	{
#line 58 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_dbus_message_to_gerror (message, &_inner_error0_);
#line 58 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 58 "../tracker/src/libtracker-bus/tracker-bus.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 893 "tracker-bus.c"
				goto __catch0_g_io_error;
			}
#line 58 "../tracker/src/libtracker-bus/tracker-bus.vala"
			if (_inner_error0_->domain == TRACKER_SPARQL_ERROR) {
#line 898 "tracker-bus.c"
				goto __catch0_tracker_sparql_error;
			}
#line 58 "../tracker/src/libtracker-bus/tracker-bus.vala"
			if (_inner_error0_->domain == G_DBUS_ERROR) {
#line 903 "tracker-bus.c"
				goto __catch0_g_dbus_error;
			}
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e_io = NULL;
		GError* _tmp0_;
		GError* _tmp1_;
#line 57 "../tracker/src/libtracker-bus/tracker-bus.vala"
		e_io = _inner_error0_;
#line 57 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_inner_error0_ = NULL;
#line 60 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp0_ = e_io;
#line 60 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp1_ = _g_error_copy0 (_tmp0_);
#line 60 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_inner_error0_ = _tmp1_;
#line 60 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_error_free0 (e_io);
#line 927 "tracker-bus.c"
		goto __finally0;
	}
	goto __finally0;
	__catch0_tracker_sparql_error:
	{
		GError* e_sparql = NULL;
		GError* _tmp2_;
		GError* _tmp3_;
#line 57 "../tracker/src/libtracker-bus/tracker-bus.vala"
		e_sparql = _inner_error0_;
#line 57 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_inner_error0_ = NULL;
#line 62 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp2_ = e_sparql;
#line 62 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp3_ = _g_error_copy0 (_tmp2_);
#line 62 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_inner_error0_ = _tmp3_;
#line 62 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_error_free0 (e_sparql);
#line 948 "tracker-bus.c"
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_dbus_error:
	{
		GError* e_dbus = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
#line 57 "../tracker/src/libtracker-bus/tracker-bus.vala"
		e_dbus = _inner_error0_;
#line 57 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_inner_error0_ = NULL;
#line 64 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp4_ = e_dbus;
#line 64 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 64 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_inner_error0_ = _tmp5_;
#line 64 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_error_free0 (e_dbus);
#line 969 "tracker-bus.c"
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
#line 57 "../tracker/src/libtracker-bus/tracker-bus.vala"
		e = _inner_error0_;
#line 57 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_inner_error0_ = NULL;
#line 66 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp6_ = e;
#line 66 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp7_ = _tmp6_->message;
#line 66 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp8_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp7_);
#line 66 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_inner_error0_ = _tmp8_;
#line 66 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_error_free0 (e);
#line 993 "tracker-bus.c"
		goto __finally0;
	}
	__finally0:
#line 57 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 57 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (((_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) || (_inner_error0_->domain == G_DBUS_ERROR)) {
#line 57 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_propagate_error (error, _inner_error0_);
#line 57 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return;
#line 1005 "tracker-bus.c"
		} else {
#line 57 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 57 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_clear_error (&_inner_error0_);
#line 57 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return;
#line 1013 "tracker-bus.c"
		}
	}
}

static void
tracker_bus_connection_send_query (TrackerBusConnection* self,
                                   const gchar* sparql,
                                   GUnixOutputStream* output,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback callback,
                                   gpointer callback_target,
                                   GError** error)
{
	GDBusMessage* message = NULL;
	const gchar* _tmp0_;
	GDBusMessage* _tmp1_;
	GUnixFDList* fd_list = NULL;
	GUnixFDList* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GDBusConnection* _tmp8_;
	GError* _inner_error0_ = NULL;
#line 70 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (self != NULL);
#line 70 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (sparql != NULL);
#line 70 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (output != NULL);
#line 71 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = self->priv->dbus_name;
#line 71 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp1_ = g_dbus_message_new_method_call (_tmp0_, TRACKER_DBUS_OBJECT_STEROIDS, TRACKER_DBUS_INTERFACE_STEROIDS, "Query");
#line 71 "../tracker/src/libtracker-bus/tracker-bus.vala"
	message = _tmp1_;
#line 72 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp2_ = g_unix_fd_list_new ();
#line 72 "../tracker/src/libtracker-bus/tracker-bus.vala"
	fd_list = _tmp2_;
#line 73 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp4_ = g_unix_output_stream_get_fd (output);
#line 73 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp5_ = _tmp4_;
#line 73 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp3_ = g_unix_fd_list_append (fd_list, _tmp5_, &_inner_error0_);
#line 73 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 73 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_propagate_error (error, _inner_error0_);
#line 73 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (fd_list);
#line 73 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (message);
#line 73 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return;
#line 1071 "tracker-bus.c"
	}
#line 73 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp6_ = g_variant_new ("(sh)", sparql, _tmp3_, NULL);
#line 73 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_variant_ref_sink (_tmp6_);
#line 73 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp7_ = _tmp6_;
#line 73 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_dbus_message_set_body (message, _tmp7_);
#line 73 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_variant_unref0 (_tmp7_);
#line 74 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_dbus_message_set_unix_fd_list (message, fd_list);
#line 76 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp8_ = self->priv->bus;
#line 76 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_dbus_connection_send_message_with_reply (_tmp8_, message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, G_MAXINT, NULL, cancellable, callback, callback_target);
#line 70 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (fd_list);
#line 70 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (message);
#line 1093 "tracker-bus.c"
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
#line 79 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 79 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return _data1_;
#line 1103 "tracker-bus.c"
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 79 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1113 "tracker-bus.c"
		TrackerBusConnection* self;
#line 79 "../tracker/src/libtracker-bus/tracker-bus.vala"
		self = _data1_->self;
#line 79 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data1_->async_res);
#line 79 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_main_loop_unref0 (_data1_->loop);
#line 79 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (self);
#line 79 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_slice_free (Block1Data, _data1_);
#line 1125 "tracker-bus.c"
	}
}

static void
__lambda5_ (Block1Data* _data1_,
            GObject* o,
            GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
#line 85 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = _data1_->self;
#line 85 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 86 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 86 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data1_->async_res);
#line 86 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data1_->async_res = _tmp0_;
#line 87 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_main_loop_quit (_data1_->loop);
#line 1148 "tracker-bus.c"
}

static void
___lambda5__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 85 "../tracker/src/libtracker-bus/tracker-bus.vala"
	__lambda5_ (self, source_object, res);
#line 85 "../tracker/src/libtracker-bus/tracker-bus.vala"
	block1_data_unref (self);
#line 1160 "tracker-bus.c"
}

static TrackerSparqlCursor*
tracker_bus_connection_real_query (TrackerSparqlConnection* base,
                                   const gchar* sparql,
                                   GCancellable* cancellable,
                                   GError** error)
{
	TrackerBusConnection * self;
	Block1Data* _data1_;
	GMainContext* context = NULL;
	GMainContext* _tmp0_;
	GMainLoop* _tmp1_;
	TrackerSparqlCursor* _tmp2_ = NULL;
	TrackerSparqlCursor* _tmp3_;
	TrackerSparqlCursor* _tmp4_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlCursor* result;
#line 79 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 79 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 79 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 79 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data1_->_ref_count_ = 1;
#line 79 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data1_->self = g_object_ref (self);
#line 81 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = g_main_context_new ();
#line 81 "../tracker/src/libtracker-bus/tracker-bus.vala"
	context = _tmp0_;
#line 82 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp1_ = g_main_loop_new (context, FALSE);
#line 82 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data1_->loop = _tmp1_;
#line 83 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_main_context_push_thread_default (context);
#line 84 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data1_->async_res = NULL;
#line 85 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_sparql_connection_query_async ((TrackerSparqlConnection*) self, sparql, cancellable, ___lambda5__gasync_ready_callback, block1_data_ref (_data1_));
#line 89 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_main_loop_run (_data1_->loop);
#line 90 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_main_context_pop_thread_default (context);
#line 91 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp3_ = tracker_sparql_connection_query_finish ((TrackerSparqlConnection*) self, _data1_->async_res, &_inner_error0_);
#line 91 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp2_ = _tmp3_;
#line 91 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 91 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_propagate_error (error, _inner_error0_);
#line 91 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_main_context_unref0 (context);
#line 91 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block1_data_unref (_data1_);
#line 91 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data1_ = NULL;
#line 91 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return NULL;
#line 1223 "tracker-bus.c"
	}
#line 91 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp4_ = _tmp2_;
#line 91 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp2_ = NULL;
#line 91 "../tracker/src/libtracker-bus/tracker-bus.vala"
	result = _tmp4_;
#line 91 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_tmp2_);
#line 91 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_main_context_unref0 (context);
#line 91 "../tracker/src/libtracker-bus/tracker-bus.vala"
	block1_data_unref (_data1_);
#line 91 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data1_ = NULL;
#line 91 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return result;
#line 1241 "tracker-bus.c"
}

static void
tracker_bus_connection_real_query_async_data_free (gpointer _data)
{
	TrackerBusConnectionQueryAsyncData* _data_;
	_data_ = _data;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->result);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionQueryAsyncData, _data_);
#line 1259 "tracker-bus.c"
}

static void
tracker_bus_connection_real_query_async (TrackerSparqlConnection* base,
                                         const gchar* sparql,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionQueryAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (sparql != NULL);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionQueryAsyncData);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_query_async_data_free);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp1_ = g_strdup (sparql);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->sparql = _tmp1_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->cancellable = _tmp2_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_real_query_async_co (_data_);
#line 1302 "tracker-bus.c"
}

static TrackerSparqlCursor*
tracker_bus_connection_query_finish (TrackerSparqlConnection* base,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	TrackerSparqlCursor* result;
	TrackerBusConnectionQueryAsyncData* _data_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return NULL;
#line 1318 "tracker-bus.c"
	}
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	result = _data_->result;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->result = NULL;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return result;
#line 1326 "tracker-bus.c"
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
#line 94 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 94 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return _data2_;
#line 1336 "tracker-bus.c"
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 94 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1346 "tracker-bus.c"
		TrackerBusConnection* self;
#line 94 "../tracker/src/libtracker-bus/tracker-bus.vala"
		self = _data2_->self;
#line 94 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data2_->dbus_res);
#line 94 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (self);
#line 94 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_slice_free (Block2Data, _data2_);
#line 1356 "tracker-bus.c"
	}
}

static void
__lambda4_ (Block2Data* _data2_,
            GObject* o,
            GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
#line 102 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = _data2_->self;
#line 102 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 103 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 103 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data2_->dbus_res);
#line 103 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data2_->dbus_res = _tmp0_;
#line 104 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (_data2_->received_result) {
#line 105 "../tracker/src/libtracker-bus/tracker-bus.vala"
		tracker_bus_connection_real_query_async_co (_data2_->_async_data_);
#line 1381 "tracker-bus.c"
	}
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 102 "../tracker/src/libtracker-bus/tracker-bus.vala"
	__lambda4_ (self, source_object, res);
#line 1392 "tracker-bus.c"
}

static void*
_g_realloc_grealloc_func (void* data,
                          gsize size)
{
	void* result;
	result = g_realloc (data, size);
#line 112 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return result;
#line 1403 "tracker-bus.c"
}

static void
_g_free_gdestroy_notify (void* data)
{
#line 112 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_free (data);
#line 1411 "tracker-bus.c"
}

static void
tracker_bus_connection_query_async_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	TrackerBusConnectionQueryAsyncData* _data_;
#line 115 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_ = _user_data_;
#line 115 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_source_object_ = source_object;
#line 115 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_res_ = _res_;
#line 115 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_real_query_async_co (_data_);
#line 1428 "tracker-bus.c"
}

static gchar**
_variant_get1 (GVariant* value,
               gint* result_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length;
	gint _tmp0__size;
	gint _tmp0__length1;
	GVariantIter _tmp1_;
	GVariant* _tmp2_;
	_tmp0_ = g_new (gchar*, 5);
	_tmp0__length = 0;
	_tmp0__size = 4;
	_tmp0__length1 = 0;
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_variant_iter_init (&_tmp1_, value);
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	for (; (_tmp2_ = g_variant_iter_next_value (&_tmp1_)) != NULL; _tmp0__length1++) {
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (_tmp0__size == _tmp0__length) {
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_tmp0__size = 2 * _tmp0__size;
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_tmp0_ = g_renew (gchar*, _tmp0_, _tmp0__size + 1);
#line 1455 "tracker-bus.c"
		}
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_tmp0_[_tmp0__length++] = g_variant_dup_string (_tmp2_, NULL);
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_variant_unref (_tmp2_);
#line 1461 "tracker-bus.c"
	}
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	*result_length1 = _tmp0__length1;
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_[_tmp0__length] = NULL;
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return _tmp0_;
#line 1469 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_real_query_async_co (TrackerBusConnectionQueryAsyncData* _data_)
{
#line 94 "../tracker/src/libtracker-bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 94 "../tracker/src/libtracker-bus/tracker-bus.vala"
		case 0:
#line 1479 "tracker-bus.c"
		goto _state_0;
#line 94 "../tracker/src/libtracker-bus/tracker-bus.vala"
		case 1:
#line 1483 "tracker-bus.c"
		goto _state_1;
#line 94 "../tracker/src/libtracker-bus/tracker-bus.vala"
		case 2:
#line 1487 "tracker-bus.c"
		goto _state_2;
		default:
#line 94 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 1492 "tracker-bus.c"
	}
	_state_0:
#line 94 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 94 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 94 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data2_->self = g_object_ref (_data_->self);
#line 94 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 97 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp0_ = NULL;
#line 97 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp1_ = NULL;
#line 97 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_pipe (_data_->self, &_data_->_tmp0_, &_data_->_tmp1_, &_data_->_inner_error0_);
#line 97 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 97 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->input = _data_->_tmp0_;
#line 97 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 97 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->output = _data_->_tmp1_;
#line 97 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 97 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 97 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 97 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 97 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block2_data_unref (_data_->_data2_);
#line 97 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data2_ = NULL;
#line 97 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 97 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 1533 "tracker-bus.c"
	}
#line 100 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data2_->dbus_res = NULL;
#line 101 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data2_->received_result = FALSE;
#line 102 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp2_ = _data_->output;
#line 102 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_send_query (_data_->self, _data_->sparql, _data_->_tmp2_, _data_->cancellable, ___lambda4__gasync_ready_callback, _data_->_data2_, &_data_->_inner_error0_);
#line 102 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 102 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 102 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 102 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 102 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block2_data_unref (_data_->_data2_);
#line 102 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data2_ = NULL;
#line 102 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 102 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 1559 "tracker-bus.c"
	}
#line 109 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 109 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->output = NULL;
#line 112 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp3_ = (GMemoryOutputStream*) g_memory_output_stream_new (NULL, 0, _g_realloc_grealloc_func, _g_free_gdestroy_notify);
#line 112 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->mem_stream = _data_->_tmp3_;
#line 1569 "tracker-bus.c"
	{
#line 115 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_tmp4_ = _data_->mem_stream;
#line 115 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_tmp5_ = _data_->input;
#line 115 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_state_ = 1;
#line 115 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_output_stream_splice_async ((GOutputStream*) _data_->_tmp4_, (GInputStream*) _data_->_tmp5_, G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE | G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET, G_PRIORITY_DEFAULT, _data_->cancellable, tracker_bus_connection_query_async_ready, _data_);
#line 115 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 1581 "tracker-bus.c"
		_state_1:
#line 115 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_output_stream_splice_finish ((GOutputStream*) _data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
#line 115 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 1587 "tracker-bus.c"
			goto __finally0;
		}
	}
	__finally0:
	{
#line 118 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data2_->received_result = TRUE;
#line 119 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_tmp6_ = _data_->_data2_->dbus_res;
#line 119 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (_data_->_tmp6_ == NULL) {
#line 120 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_data_->_state_ = 2;
#line 120 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return FALSE;
#line 1603 "tracker-bus.c"
			_state_2:
			;
		}
	}
#line 114 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 114 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 114 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->mem_stream);
#line 114 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 114 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 114 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block2_data_unref (_data_->_data2_);
#line 114 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data2_ = NULL;
#line 114 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 114 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 1626 "tracker-bus.c"
	}
#line 124 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp7_ = _data_->self->priv->bus;
#line 124 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp8_ = _data_->_data2_->dbus_res;
#line 124 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp9_ = g_dbus_connection_send_message_with_reply_finish (_data_->_tmp7_, _data_->_tmp8_, &_data_->_inner_error0_);
#line 124 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->reply = _data_->_tmp9_;
#line 124 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 124 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 124 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->mem_stream);
#line 124 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 124 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 124 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block2_data_unref (_data_->_data2_);
#line 124 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data2_ = NULL;
#line 124 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 124 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 1654 "tracker-bus.c"
	}
#line 125 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp10_ = _data_->reply;
#line 125 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->self, _data_->_tmp10_, &_data_->_inner_error0_);
#line 125 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 125 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 125 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->reply);
#line 125 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->mem_stream);
#line 125 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 125 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 125 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block2_data_unref (_data_->_data2_);
#line 125 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data2_ = NULL;
#line 125 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 125 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 1680 "tracker-bus.c"
	}
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp11_ = _data_->reply;
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp12_ = g_dbus_message_get_body (_data_->_tmp11_);
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp13_ = g_variant_get_child_value (_data_->_tmp12_, (gsize) 0);
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp14_ = _data_->_tmp13_;
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp15_ = NULL;
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp15__length1 = 0;
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp15_ = _variant_get1 (_data_->_tmp14_, &_data_->_tmp15__length1);
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp16_ = _data_->_tmp15_;
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp16__length1 = _data_->_tmp15__length1;
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_variant_unref0 (_data_->_tmp14_);
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->variable_names = _data_->_tmp16_;
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->variable_names_length1 = _data_->_tmp16__length1;
#line 127 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_variable_names_size_ = _data_->variable_names_length1;
#line 128 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp17_ = _data_->mem_stream;
#line 128 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_output_stream_close ((GOutputStream*) _data_->_tmp17_, NULL, &_data_->_inner_error0_);
#line 128 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 128 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 128 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->variable_names = (_vala_array_free (_data_->variable_names, _data_->variable_names_length1, (GDestroyNotify) g_free), NULL);
#line 128 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->reply);
#line 128 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->mem_stream);
#line 128 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 128 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 128 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block2_data_unref (_data_->_data2_);
#line 128 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data2_ = NULL;
#line 128 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 128 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 1734 "tracker-bus.c"
	}
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp18_ = _data_->mem_stream;
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp19_ = g_memory_output_stream_steal_data (_data_->_tmp18_);
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp20_ = _data_->mem_stream;
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp21_ = g_memory_output_stream_get_data_size (_data_->_tmp20_);
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp22_ = _data_->_tmp21_;
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp23_ = _data_->variable_names;
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp23__length1 = _data_->variable_names_length1;
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp24_ = tracker_bus_fd_cursor_new (_data_->_tmp19_, _data_->_tmp22_, _data_->_tmp23_, _data_->_tmp23__length1);
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->result = (TrackerSparqlCursor*) _data_->_tmp24_;
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->variable_names = (_vala_array_free (_data_->variable_names, _data_->variable_names_length1, (GDestroyNotify) g_free), NULL);
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->mem_stream);
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	block2_data_unref (_data_->_data2_);
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data2_ = NULL;
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1776 "tracker-bus.c"
		}
	}
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 129 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return FALSE;
#line 1783 "tracker-bus.c"
}

static void
tracker_bus_connection_send_update (TrackerBusConnection* self,
                                    const gchar* method,
                                    GUnixInputStream* input,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback callback,
                                    gpointer callback_target,
                                    GError** error)
{
	GDBusMessage* message = NULL;
	const gchar* _tmp0_;
	GDBusMessage* _tmp1_;
	GUnixFDList* fd_list = NULL;
	GUnixFDList* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GDBusConnection* _tmp8_;
	GError* _inner_error0_ = NULL;
#line 132 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (self != NULL);
#line 132 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (method != NULL);
#line 132 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (input != NULL);
#line 133 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = self->priv->dbus_name;
#line 133 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp1_ = g_dbus_message_new_method_call (_tmp0_, TRACKER_DBUS_OBJECT_STEROIDS, TRACKER_DBUS_INTERFACE_STEROIDS, method);
#line 133 "../tracker/src/libtracker-bus/tracker-bus.vala"
	message = _tmp1_;
#line 134 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp2_ = g_unix_fd_list_new ();
#line 134 "../tracker/src/libtracker-bus/tracker-bus.vala"
	fd_list = _tmp2_;
#line 135 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp4_ = g_unix_input_stream_get_fd (input);
#line 135 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp5_ = _tmp4_;
#line 135 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp3_ = g_unix_fd_list_append (fd_list, _tmp5_, &_inner_error0_);
#line 135 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 135 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_propagate_error (error, _inner_error0_);
#line 135 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (fd_list);
#line 135 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (message);
#line 135 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return;
#line 1839 "tracker-bus.c"
	}
#line 135 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp6_ = g_variant_new ("(h)", _tmp3_, NULL);
#line 135 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_variant_ref_sink (_tmp6_);
#line 135 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp7_ = _tmp6_;
#line 135 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_dbus_message_set_body (message, _tmp7_);
#line 135 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_variant_unref0 (_tmp7_);
#line 136 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_dbus_message_set_unix_fd_list (message, fd_list);
#line 138 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp8_ = self->priv->bus;
#line 138 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_dbus_connection_send_message_with_reply (_tmp8_, message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, G_MAXINT, NULL, cancellable, callback, callback_target);
#line 132 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (fd_list);
#line 132 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (message);
#line 1861 "tracker-bus.c"
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
#line 141 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 141 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return _data3_;
#line 1871 "tracker-bus.c"
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 141 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 1881 "tracker-bus.c"
		TrackerBusConnection* self;
#line 141 "../tracker/src/libtracker-bus/tracker-bus.vala"
		self = _data3_->self;
#line 141 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data3_->async_res);
#line 141 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_main_loop_unref0 (_data3_->loop);
#line 141 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (self);
#line 141 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_slice_free (Block3Data, _data3_);
#line 1893 "tracker-bus.c"
	}
}

static void
__lambda7_ (Block3Data* _data3_,
            GObject* o,
            GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
#line 147 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = _data3_->self;
#line 147 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 148 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 148 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data3_->async_res);
#line 148 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data3_->async_res = _tmp0_;
#line 149 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_main_loop_quit (_data3_->loop);
#line 1916 "tracker-bus.c"
}

static void
___lambda7__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 147 "../tracker/src/libtracker-bus/tracker-bus.vala"
	__lambda7_ (self, source_object, res);
#line 147 "../tracker/src/libtracker-bus/tracker-bus.vala"
	block3_data_unref (self);
#line 1928 "tracker-bus.c"
}

static void
tracker_bus_connection_real_update (TrackerSparqlConnection* base,
                                    const gchar* sparql,
                                    gint priority,
                                    GCancellable* cancellable,
                                    GError** error)
{
	TrackerBusConnection * self;
	Block3Data* _data3_;
	GMainContext* context = NULL;
	GMainContext* _tmp0_;
	GMainLoop* _tmp1_;
	GError* _inner_error0_ = NULL;
#line 141 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 141 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (sparql != NULL);
#line 141 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 141 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data3_->_ref_count_ = 1;
#line 141 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data3_->self = g_object_ref (self);
#line 143 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = g_main_context_new ();
#line 143 "../tracker/src/libtracker-bus/tracker-bus.vala"
	context = _tmp0_;
#line 144 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp1_ = g_main_loop_new (context, FALSE);
#line 144 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data3_->loop = _tmp1_;
#line 145 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_main_context_push_thread_default (context);
#line 146 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data3_->async_res = NULL;
#line 147 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_sparql_connection_update_async ((TrackerSparqlConnection*) self, sparql, priority, cancellable, ___lambda7__gasync_ready_callback, block3_data_ref (_data3_));
#line 151 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_main_loop_run (_data3_->loop);
#line 152 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_main_context_pop_thread_default (context);
#line 153 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_sparql_connection_update_finish ((TrackerSparqlConnection*) self, _data3_->async_res, &_inner_error0_);
#line 153 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 153 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_propagate_error (error, _inner_error0_);
#line 153 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_main_context_unref0 (context);
#line 153 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block3_data_unref (_data3_);
#line 153 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data3_ = NULL;
#line 153 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return;
#line 1986 "tracker-bus.c"
	}
#line 141 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_main_context_unref0 (context);
#line 141 "../tracker/src/libtracker-bus/tracker-bus.vala"
	block3_data_unref (_data3_);
#line 141 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data3_ = NULL;
#line 1994 "tracker-bus.c"
}

static void
tracker_bus_connection_real_update_async_data_free (gpointer _data)
{
	TrackerBusConnectionUpdateAsyncData* _data_;
	_data_ = _data;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionUpdateAsyncData, _data_);
#line 2010 "tracker-bus.c"
}

static void
tracker_bus_connection_real_update_async (TrackerSparqlConnection* base,
                                          const gchar* sparql,
                                          gint priority,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionUpdateAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (sparql != NULL);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionUpdateAsyncData);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_update_async_data_free);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp1_ = g_strdup (sparql);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->sparql = _tmp1_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->priority = priority;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->cancellable = _tmp2_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_real_update_async_co (_data_);
#line 2056 "tracker-bus.c"
}

static void
tracker_bus_connection_update_finish (TrackerSparqlConnection* base,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	TrackerBusConnectionUpdateAsyncData* _data_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return;
#line 2071 "tracker-bus.c"
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return _data4_;
#line 2082 "tracker-bus.c"
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 2092 "tracker-bus.c"
		TrackerBusConnection* self;
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
		self = _data4_->self;
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data4_->dbus_res);
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (self);
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_slice_free (Block4Data, _data4_);
#line 2102 "tracker-bus.c"
	}
}

static void
__lambda6_ (Block4Data* _data4_,
            GObject* o,
            GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
#line 164 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = _data4_->self;
#line 164 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 165 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 165 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data4_->dbus_res);
#line 165 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data4_->dbus_res = _tmp0_;
#line 166 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (_data4_->sent_update) {
#line 167 "../tracker/src/libtracker-bus/tracker-bus.vala"
		tracker_bus_connection_real_update_async_co (_data4_->_async_data_);
#line 2127 "tracker-bus.c"
	}
}

static void
___lambda6__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 164 "../tracker/src/libtracker-bus/tracker-bus.vala"
	__lambda6_ (self, source_object, res);
#line 2138 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_real_update_async_co (TrackerBusConnectionUpdateAsyncData* _data_)
{
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
		case 0:
#line 2148 "tracker-bus.c"
		goto _state_0;
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
		case 1:
#line 2152 "tracker-bus.c"
		goto _state_1;
		default:
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 2157 "tracker-bus.c"
	}
	_state_0:
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data4_ = g_slice_new0 (Block4Data);
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data4_->_ref_count_ = 1;
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data4_->self = g_object_ref (_data_->self);
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data4_->_async_data_ = _data_;
#line 159 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp0_ = NULL;
#line 159 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp1_ = NULL;
#line 159 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_pipe (_data_->self, &_data_->_tmp0_, &_data_->_tmp1_, &_data_->_inner_error0_);
#line 159 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 159 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->input = _data_->_tmp0_;
#line 159 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 159 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->output = _data_->_tmp1_;
#line 159 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 159 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 159 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 159 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 159 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 159 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 159 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 159 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 2198 "tracker-bus.c"
	}
#line 162 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data4_->dbus_res = NULL;
#line 163 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data4_->sent_update = FALSE;
#line 164 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (_data_->priority <= G_PRIORITY_DEFAULT) {
#line 164 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_tmp2_ = "Update";
#line 2208 "tracker-bus.c"
	} else {
#line 164 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_tmp2_ = "BatchUpdate";
#line 2212 "tracker-bus.c"
	}
#line 164 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp3_ = _data_->input;
#line 164 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_send_update (_data_->self, _data_->_tmp2_, _data_->_tmp3_, _data_->cancellable, ___lambda6__gasync_ready_callback, _data_->_data4_, &_data_->_inner_error0_);
#line 164 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 164 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 164 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 164 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 164 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 164 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 164 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 164 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 2234 "tracker-bus.c"
	}
#line 172 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp4_ = _data_->output;
#line 172 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp5_ = g_data_output_stream_new ((GOutputStream*) _data_->_tmp4_);
#line 172 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->data_stream = _data_->_tmp5_;
#line 173 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp6_ = _data_->data_stream;
#line 173 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_data_output_stream_set_byte_order (_data_->_tmp6_, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
#line 174 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp7_ = _data_->data_stream;
#line 174 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp8_ = strlen (_data_->sparql);
#line 174 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 174 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_data_output_stream_put_int32 (_data_->_tmp7_, (gint32) _data_->_tmp9_, NULL, &_data_->_inner_error0_);
#line 174 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 174 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 174 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 174 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 174 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 174 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 174 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 174 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 174 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 2272 "tracker-bus.c"
	}
#line 175 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp10_ = _data_->data_stream;
#line 175 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_data_output_stream_put_string (_data_->_tmp10_, _data_->sparql, NULL, &_data_->_inner_error0_);
#line 175 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 175 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 175 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 175 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 175 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 175 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 175 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 175 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 175 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 2296 "tracker-bus.c"
	}
#line 176 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 176 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->data_stream = NULL;
#line 179 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data4_->sent_update = TRUE;
#line 180 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp11_ = _data_->_data4_->dbus_res;
#line 180 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (_data_->_tmp11_ == NULL) {
#line 181 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_state_ = 1;
#line 181 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 2312 "tracker-bus.c"
		_state_1:
		;
	}
#line 184 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp12_ = _data_->self->priv->bus;
#line 184 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp13_ = _data_->_data4_->dbus_res;
#line 184 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp14_ = g_dbus_connection_send_message_with_reply_finish (_data_->_tmp12_, _data_->_tmp13_, &_data_->_inner_error0_);
#line 184 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->reply = _data_->_tmp14_;
#line 184 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 184 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 184 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 184 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 184 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 184 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 184 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 184 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 184 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 2342 "tracker-bus.c"
	}
#line 185 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp15_ = _data_->reply;
#line 185 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->self, _data_->_tmp15_, &_data_->_inner_error0_);
#line 185 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 185 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 185 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->reply);
#line 185 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 185 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 185 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 185 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block4_data_unref (_data_->_data4_);
#line 185 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data4_ = NULL;
#line 185 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 185 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 2368 "tracker-bus.c"
	}
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	block4_data_unref (_data_->_data4_);
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data4_ = NULL;
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2390 "tracker-bus.c"
		}
	}
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 156 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return FALSE;
#line 2397 "tracker-bus.c"
}

static void
tracker_bus_connection_real_update_array_async_data_free (gpointer _data)
{
	TrackerBusConnectionUpdateArrayAsyncData* _data_;
	_data_ = _data;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_ptr_array_unref0 (_data_->result);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionUpdateArrayAsyncData, _data_);
#line 2413 "tracker-bus.c"
}

static void
tracker_bus_connection_real_update_array_async (TrackerSparqlConnection* base,
                                                gchar** sparql,
                                                gint sparql_length1,
                                                gint priority,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionUpdateArrayAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	GCancellable* _tmp1_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionUpdateArrayAsyncData);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_update_array_async_data_free);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->sparql = sparql;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->sparql_length1 = sparql_length1;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->priority = priority;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->cancellable = _tmp1_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_real_update_array_async_co (_data_);
#line 2455 "tracker-bus.c"
}

static GPtrArray*
tracker_bus_connection_update_array_finish (TrackerSparqlConnection* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GPtrArray* result;
	TrackerBusConnectionUpdateArrayAsyncData* _data_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return NULL;
#line 2471 "tracker-bus.c"
	}
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	result = _data_->result;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->result = NULL;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return result;
#line 2479 "tracker-bus.c"
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
#line 188 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 188 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return _data5_;
#line 2489 "tracker-bus.c"
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 188 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 2499 "tracker-bus.c"
		TrackerBusConnection* self;
#line 188 "../tracker/src/libtracker-bus/tracker-bus.vala"
		self = _data5_->self;
#line 188 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data5_->dbus_res);
#line 188 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (self);
#line 188 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_slice_free (Block5Data, _data5_);
#line 2509 "tracker-bus.c"
	}
}

static void
__lambda8_ (Block5Data* _data5_,
            GObject* o,
            GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
#line 196 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = _data5_->self;
#line 196 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 197 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 197 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data5_->dbus_res);
#line 197 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data5_->dbus_res = _tmp0_;
#line 198 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (_data5_->sent_update) {
#line 199 "../tracker/src/libtracker-bus/tracker-bus.vala"
		tracker_bus_connection_real_update_array_async_co (_data5_->_async_data_);
#line 2534 "tracker-bus.c"
	}
}

static void
___lambda8__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 196 "../tracker/src/libtracker-bus/tracker-bus.vala"
	__lambda8_ (self, source_object, res);
#line 2545 "tracker-bus.c"
}

static void
_g_error_free0_ (gpointer var)
{
#line 223 "../tracker/src/libtracker-bus/tracker-bus.vala"
	(var == NULL) ? NULL : (var = (g_error_free (var), NULL));
#line 2553 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_real_update_array_async_co (TrackerBusConnectionUpdateArrayAsyncData* _data_)
{
#line 188 "../tracker/src/libtracker-bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 188 "../tracker/src/libtracker-bus/tracker-bus.vala"
		case 0:
#line 2563 "tracker-bus.c"
		goto _state_0;
#line 188 "../tracker/src/libtracker-bus/tracker-bus.vala"
		case 1:
#line 2567 "tracker-bus.c"
		goto _state_1;
		default:
#line 188 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 2572 "tracker-bus.c"
	}
	_state_0:
#line 188 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data5_ = g_slice_new0 (Block5Data);
#line 188 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data5_->_ref_count_ = 1;
#line 188 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data5_->self = g_object_ref (_data_->self);
#line 188 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data5_->_async_data_ = _data_;
#line 191 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp0_ = NULL;
#line 191 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp1_ = NULL;
#line 191 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_pipe (_data_->self, &_data_->_tmp0_, &_data_->_tmp1_, &_data_->_inner_error0_);
#line 191 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 191 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->input = _data_->_tmp0_;
#line 191 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 191 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->output = _data_->_tmp1_;
#line 191 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 191 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 191 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 191 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 191 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block5_data_unref (_data_->_data5_);
#line 191 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data5_ = NULL;
#line 191 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 191 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 2613 "tracker-bus.c"
	}
#line 194 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data5_->dbus_res = NULL;
#line 195 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data5_->sent_update = FALSE;
#line 196 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp2_ = _data_->input;
#line 196 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_send_update (_data_->self, "UpdateArray", _data_->_tmp2_, _data_->cancellable, ___lambda8__gasync_ready_callback, _data_->_data5_, &_data_->_inner_error0_);
#line 196 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 196 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 196 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 196 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 196 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block5_data_unref (_data_->_data5_);
#line 196 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data5_ = NULL;
#line 196 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 196 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 2639 "tracker-bus.c"
	}
#line 204 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp3_ = _data_->output;
#line 204 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp4_ = g_data_output_stream_new ((GOutputStream*) _data_->_tmp3_);
#line 204 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->data_stream = _data_->_tmp4_;
#line 205 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp5_ = _data_->data_stream;
#line 205 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_data_output_stream_set_byte_order (_data_->_tmp5_, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
#line 206 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp6_ = _data_->data_stream;
#line 206 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_data_output_stream_put_int32 (_data_->_tmp6_, (gint32) _data_->sparql_length1, NULL, &_data_->_inner_error0_);
#line 206 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 206 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 206 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 206 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 206 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 206 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block5_data_unref (_data_->_data5_);
#line 206 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data5_ = NULL;
#line 206 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 206 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 2673 "tracker-bus.c"
	}
	{
#line 207 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->i = 0;
#line 2678 "tracker-bus.c"
		{
#line 207 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_data_->_tmp7_ = TRUE;
#line 207 "../tracker/src/libtracker-bus/tracker-bus.vala"
			while (TRUE) {
#line 207 "../tracker/src/libtracker-bus/tracker-bus.vala"
				if (!_data_->_tmp7_) {
#line 207 "../tracker/src/libtracker-bus/tracker-bus.vala"
					_data_->_tmp8_ = _data_->i;
#line 207 "../tracker/src/libtracker-bus/tracker-bus.vala"
					_data_->i = _data_->_tmp8_ + 1;
#line 2690 "tracker-bus.c"
				}
#line 207 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_data_->_tmp7_ = FALSE;
#line 207 "../tracker/src/libtracker-bus/tracker-bus.vala"
				if (!(_data_->i < _data_->sparql_length1)) {
#line 207 "../tracker/src/libtracker-bus/tracker-bus.vala"
					break;
#line 2698 "tracker-bus.c"
				}
#line 208 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_data_->_tmp9_ = _data_->data_stream;
#line 208 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_data_->_tmp10_ = _data_->sparql[_data_->i];
#line 208 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_data_->_tmp11_ = strlen (_data_->_tmp10_);
#line 208 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_data_->_tmp12_ = _data_->_tmp11_;
#line 208 "../tracker/src/libtracker-bus/tracker-bus.vala"
				g_data_output_stream_put_int32 (_data_->_tmp9_, (gint32) _data_->_tmp12_, NULL, &_data_->_inner_error0_);
#line 208 "../tracker/src/libtracker-bus/tracker-bus.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 208 "../tracker/src/libtracker-bus/tracker-bus.vala"
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 208 "../tracker/src/libtracker-bus/tracker-bus.vala"
					_g_object_unref0 (_data_->data_stream);
#line 208 "../tracker/src/libtracker-bus/tracker-bus.vala"
					_g_object_unref0 (_data_->output);
#line 208 "../tracker/src/libtracker-bus/tracker-bus.vala"
					_g_object_unref0 (_data_->input);
#line 208 "../tracker/src/libtracker-bus/tracker-bus.vala"
					block5_data_unref (_data_->_data5_);
#line 208 "../tracker/src/libtracker-bus/tracker-bus.vala"
					_data_->_data5_ = NULL;
#line 208 "../tracker/src/libtracker-bus/tracker-bus.vala"
					g_object_unref (_data_->_async_result);
#line 208 "../tracker/src/libtracker-bus/tracker-bus.vala"
					return FALSE;
#line 2728 "tracker-bus.c"
				}
#line 209 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_data_->_tmp13_ = _data_->data_stream;
#line 209 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_data_->_tmp14_ = _data_->sparql[_data_->i];
#line 209 "../tracker/src/libtracker-bus/tracker-bus.vala"
				g_data_output_stream_put_string (_data_->_tmp13_, _data_->_tmp14_, NULL, &_data_->_inner_error0_);
#line 209 "../tracker/src/libtracker-bus/tracker-bus.vala"
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 209 "../tracker/src/libtracker-bus/tracker-bus.vala"
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 209 "../tracker/src/libtracker-bus/tracker-bus.vala"
					_g_object_unref0 (_data_->data_stream);
#line 209 "../tracker/src/libtracker-bus/tracker-bus.vala"
					_g_object_unref0 (_data_->output);
#line 209 "../tracker/src/libtracker-bus/tracker-bus.vala"
					_g_object_unref0 (_data_->input);
#line 209 "../tracker/src/libtracker-bus/tracker-bus.vala"
					block5_data_unref (_data_->_data5_);
#line 209 "../tracker/src/libtracker-bus/tracker-bus.vala"
					_data_->_data5_ = NULL;
#line 209 "../tracker/src/libtracker-bus/tracker-bus.vala"
					g_object_unref (_data_->_async_result);
#line 209 "../tracker/src/libtracker-bus/tracker-bus.vala"
					return FALSE;
#line 2754 "tracker-bus.c"
				}
			}
		}
	}
#line 211 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 211 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->data_stream = NULL;
#line 214 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data5_->sent_update = TRUE;
#line 215 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp15_ = _data_->_data5_->dbus_res;
#line 215 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (_data_->_tmp15_ == NULL) {
#line 216 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_state_ = 1;
#line 216 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 2773 "tracker-bus.c"
		_state_1:
		;
	}
#line 219 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp16_ = _data_->self->priv->bus;
#line 219 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp17_ = _data_->_data5_->dbus_res;
#line 219 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp18_ = g_dbus_connection_send_message_with_reply_finish (_data_->_tmp16_, _data_->_tmp17_, &_data_->_inner_error0_);
#line 219 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->reply = _data_->_tmp18_;
#line 219 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 219 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 219 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 219 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 219 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 219 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block5_data_unref (_data_->_data5_);
#line 219 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data5_ = NULL;
#line 219 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 219 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 2803 "tracker-bus.c"
	}
#line 220 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp19_ = _data_->reply;
#line 220 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->self, _data_->_tmp19_, &_data_->_inner_error0_);
#line 220 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 220 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 220 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->reply);
#line 220 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 220 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 220 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 220 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block5_data_unref (_data_->_data5_);
#line 220 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data5_ = NULL;
#line 220 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 220 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 2829 "tracker-bus.c"
	}
#line 223 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp20_ = g_ptr_array_new_full ((guint) 0, _g_error_free0_);
#line 223 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_result_ = _data_->_tmp20_;
#line 225 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp21_ = _data_->reply;
#line 225 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp22_ = g_dbus_message_get_body (_data_->_tmp21_);
#line 225 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp23_ = g_variant_get_child_value (_data_->_tmp22_, (gsize) 0);
#line 225 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_variant_unref0 (_data_->resultv);
#line 225 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->resultv = _data_->_tmp23_;
#line 226 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp24_ = _data_->resultv;
#line 226 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp25_ = g_variant_iter_new (_data_->_tmp24_);
#line 226 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->iter = _data_->_tmp25_;
#line 228 "../tracker/src/libtracker-bus/tracker-bus.vala"
	while (TRUE) {
#line 228 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_tmp26_ = _data_->iter;
#line 228 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_tmp27_ = NULL;
#line 228 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_tmp28_ = g_variant_iter_next (_data_->_tmp26_, "s", &_data_->_tmp27_, NULL);
#line 228 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_free0 (_data_->code);
#line 228 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->code = _data_->_tmp27_;
#line 228 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (!_data_->_tmp28_) {
#line 228 "../tracker/src/libtracker-bus/tracker-bus.vala"
			break;
#line 2867 "tracker-bus.c"
		}
#line 229 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_tmp29_ = _data_->iter;
#line 229 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_tmp30_ = NULL;
#line 229 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_tmp31_ = g_variant_iter_next (_data_->_tmp29_, "s", &_data_->_tmp30_, NULL);
#line 229 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_free0 (_data_->message);
#line 229 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->message = _data_->_tmp30_;
#line 229 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (_data_->_tmp31_) {
#line 230 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_data_->_tmp33_ = _data_->code;
#line 230 "../tracker/src/libtracker-bus/tracker-bus.vala"
			if (g_strcmp0 (_data_->_tmp33_, "") != 0) {
#line 230 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_data_->_tmp34_ = _data_->message;
#line 230 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_data_->_tmp32_ = g_strcmp0 (_data_->_tmp34_, "") != 0;
#line 2889 "tracker-bus.c"
			} else {
#line 230 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_data_->_tmp32_ = FALSE;
#line 2893 "tracker-bus.c"
			}
#line 230 "../tracker/src/libtracker-bus/tracker-bus.vala"
			if (_data_->_tmp32_) {
#line 231 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_data_->_tmp35_ = _data_->_result_;
#line 231 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_data_->_tmp36_ = _data_->message;
#line 231 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_data_->_tmp37_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp36_);
#line 231 "../tracker/src/libtracker-bus/tracker-bus.vala"
				g_ptr_array_add (_data_->_tmp35_, _data_->_tmp37_);
#line 2905 "tracker-bus.c"
			} else {
#line 233 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_data_->_tmp38_ = _data_->_result_;
#line 233 "../tracker/src/libtracker-bus/tracker-bus.vala"
				g_ptr_array_add (_data_->_tmp38_, NULL);
#line 2911 "tracker-bus.c"
			}
#line 236 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_free0 (_data_->message);
#line 236 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_data_->message = NULL;
#line 2917 "tracker-bus.c"
		}
#line 239 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_free0 (_data_->code);
#line 239 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->code = NULL;
#line 2923 "tracker-bus.c"
	}
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->result = _data_->_result_;
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_free0 (_data_->message);
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_free0 (_data_->code);
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_variant_iter_free0 (_data_->iter);
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_variant_unref0 (_data_->resultv);
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
	block5_data_unref (_data_->_data5_);
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data5_ = NULL;
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2955 "tracker-bus.c"
		}
	}
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 241 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return FALSE;
#line 2962 "tracker-bus.c"
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
#line 244 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 244 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return _data6_;
#line 2972 "tracker-bus.c"
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 244 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 2982 "tracker-bus.c"
		TrackerBusConnection* self;
#line 244 "../tracker/src/libtracker-bus/tracker-bus.vala"
		self = _data6_->self;
#line 244 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data6_->async_res);
#line 244 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_main_loop_unref0 (_data6_->loop);
#line 244 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (self);
#line 244 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_slice_free (Block6Data, _data6_);
#line 2994 "tracker-bus.c"
	}
}

static void
__lambda10_ (Block6Data* _data6_,
             GObject* o,
             GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
#line 250 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = _data6_->self;
#line 250 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 251 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 251 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data6_->async_res);
#line 251 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data6_->async_res = _tmp0_;
#line 252 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_main_loop_quit (_data6_->loop);
#line 3017 "tracker-bus.c"
}

static void
___lambda10__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
#line 250 "../tracker/src/libtracker-bus/tracker-bus.vala"
	__lambda10_ (self, source_object, res);
#line 250 "../tracker/src/libtracker-bus/tracker-bus.vala"
	block6_data_unref (self);
#line 3029 "tracker-bus.c"
}

static GVariant*
tracker_bus_connection_real_update_blank (TrackerSparqlConnection* base,
                                          const gchar* sparql,
                                          gint priority,
                                          GCancellable* cancellable,
                                          GError** error)
{
	TrackerBusConnection * self;
	Block6Data* _data6_;
	GMainContext* context = NULL;
	GMainContext* _tmp0_;
	GMainLoop* _tmp1_;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GError* _inner_error0_ = NULL;
	GVariant* result;
#line 244 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 244 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 244 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 244 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data6_->_ref_count_ = 1;
#line 244 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data6_->self = g_object_ref (self);
#line 246 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = g_main_context_new ();
#line 246 "../tracker/src/libtracker-bus/tracker-bus.vala"
	context = _tmp0_;
#line 247 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp1_ = g_main_loop_new (context, FALSE);
#line 247 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data6_->loop = _tmp1_;
#line 248 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_main_context_push_thread_default (context);
#line 249 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data6_->async_res = NULL;
#line 250 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_sparql_connection_update_blank_async ((TrackerSparqlConnection*) self, sparql, priority, cancellable, ___lambda10__gasync_ready_callback, block6_data_ref (_data6_));
#line 254 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_main_loop_run (_data6_->loop);
#line 255 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_main_context_pop_thread_default (context);
#line 256 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp3_ = tracker_sparql_connection_update_blank_finish ((TrackerSparqlConnection*) self, _data6_->async_res, &_inner_error0_);
#line 256 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp2_ = _tmp3_;
#line 256 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 256 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_propagate_error (error, _inner_error0_);
#line 256 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_main_context_unref0 (context);
#line 256 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block6_data_unref (_data6_);
#line 256 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data6_ = NULL;
#line 256 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return NULL;
#line 3093 "tracker-bus.c"
	}
#line 256 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp4_ = _tmp2_;
#line 256 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp2_ = NULL;
#line 256 "../tracker/src/libtracker-bus/tracker-bus.vala"
	result = _tmp4_;
#line 256 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_variant_unref0 (_tmp2_);
#line 256 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_main_context_unref0 (context);
#line 256 "../tracker/src/libtracker-bus/tracker-bus.vala"
	block6_data_unref (_data6_);
#line 256 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data6_ = NULL;
#line 256 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return result;
#line 3111 "tracker-bus.c"
}

static void
tracker_bus_connection_real_update_blank_async_data_free (gpointer _data)
{
	TrackerBusConnectionUpdateBlankAsyncData* _data_;
	_data_ = _data;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_variant_unref0 (_data_->result);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionUpdateBlankAsyncData, _data_);
#line 3129 "tracker-bus.c"
}

static void
tracker_bus_connection_real_update_blank_async (TrackerSparqlConnection* base,
                                                const gchar* sparql,
                                                gint priority,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionUpdateBlankAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (sparql != NULL);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionUpdateBlankAsyncData);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_update_blank_async_data_free);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp1_ = g_strdup (sparql);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_free0 (_data_->sparql);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->sparql = _tmp1_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->priority = priority;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->cancellable = _tmp2_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_real_update_blank_async_co (_data_);
#line 3175 "tracker-bus.c"
}

static GVariant*
tracker_bus_connection_update_blank_finish (TrackerSparqlConnection* base,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	GVariant* result;
	TrackerBusConnectionUpdateBlankAsyncData* _data_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return NULL;
#line 3191 "tracker-bus.c"
	}
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	result = _data_->result;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->result = NULL;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return result;
#line 3199 "tracker-bus.c"
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
#line 259 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 259 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return _data7_;
#line 3209 "tracker-bus.c"
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 259 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 3219 "tracker-bus.c"
		TrackerBusConnection* self;
#line 259 "../tracker/src/libtracker-bus/tracker-bus.vala"
		self = _data7_->self;
#line 259 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data7_->dbus_res);
#line 259 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (self);
#line 259 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_slice_free (Block7Data, _data7_);
#line 3229 "tracker-bus.c"
	}
}

static void
__lambda9_ (Block7Data* _data7_,
            GObject* o,
            GAsyncResult* res)
{
	TrackerBusConnection* self;
	GAsyncResult* _tmp0_;
#line 267 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = _data7_->self;
#line 267 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (res != NULL);
#line 268 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (res);
#line 268 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data7_->dbus_res);
#line 268 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data7_->dbus_res = _tmp0_;
#line 269 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (_data7_->sent_update) {
#line 270 "../tracker/src/libtracker-bus/tracker-bus.vala"
		tracker_bus_connection_real_update_blank_async_co (_data7_->_async_data_);
#line 3254 "tracker-bus.c"
	}
}

static void
___lambda9__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
#line 267 "../tracker/src/libtracker-bus/tracker-bus.vala"
	__lambda9_ (self, source_object, res);
#line 3265 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_real_update_blank_async_co (TrackerBusConnectionUpdateBlankAsyncData* _data_)
{
#line 259 "../tracker/src/libtracker-bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 259 "../tracker/src/libtracker-bus/tracker-bus.vala"
		case 0:
#line 3275 "tracker-bus.c"
		goto _state_0;
#line 259 "../tracker/src/libtracker-bus/tracker-bus.vala"
		case 1:
#line 3279 "tracker-bus.c"
		goto _state_1;
		default:
#line 259 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 3284 "tracker-bus.c"
	}
	_state_0:
#line 259 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data7_ = g_slice_new0 (Block7Data);
#line 259 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data7_->_ref_count_ = 1;
#line 259 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data7_->self = g_object_ref (_data_->self);
#line 259 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data7_->_async_data_ = _data_;
#line 262 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp0_ = NULL;
#line 262 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp1_ = NULL;
#line 262 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_pipe (_data_->self, &_data_->_tmp0_, &_data_->_tmp1_, &_data_->_inner_error0_);
#line 262 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 262 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->input = _data_->_tmp0_;
#line 262 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 262 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->output = _data_->_tmp1_;
#line 262 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 262 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 262 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 262 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 262 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 262 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 262 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 262 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 3325 "tracker-bus.c"
	}
#line 265 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data7_->dbus_res = NULL;
#line 266 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data7_->sent_update = FALSE;
#line 267 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp2_ = _data_->input;
#line 267 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_send_update (_data_->self, "UpdateBlank", _data_->_tmp2_, _data_->cancellable, ___lambda9__gasync_ready_callback, _data_->_data7_, &_data_->_inner_error0_);
#line 267 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 267 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 267 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 267 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 267 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 267 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 267 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 267 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 3351 "tracker-bus.c"
	}
#line 275 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp3_ = _data_->output;
#line 275 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp4_ = g_data_output_stream_new ((GOutputStream*) _data_->_tmp3_);
#line 275 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->data_stream = _data_->_tmp4_;
#line 276 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp5_ = _data_->data_stream;
#line 276 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_data_output_stream_set_byte_order (_data_->_tmp5_, G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN);
#line 277 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp6_ = _data_->data_stream;
#line 277 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp7_ = strlen (_data_->sparql);
#line 277 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp8_ = _data_->_tmp7_;
#line 277 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_data_output_stream_put_int32 (_data_->_tmp6_, (gint32) _data_->_tmp8_, NULL, &_data_->_inner_error0_);
#line 277 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 277 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 277 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 277 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 277 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 277 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 277 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 277 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 277 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 3389 "tracker-bus.c"
	}
#line 278 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp9_ = _data_->data_stream;
#line 278 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_data_output_stream_put_string (_data_->_tmp9_, _data_->sparql, NULL, &_data_->_inner_error0_);
#line 278 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 278 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 278 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 278 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 278 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 278 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 278 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 278 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 278 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 3413 "tracker-bus.c"
	}
#line 279 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 279 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->data_stream = NULL;
#line 282 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data7_->sent_update = TRUE;
#line 283 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp10_ = _data_->_data7_->dbus_res;
#line 283 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (_data_->_tmp10_ == NULL) {
#line 284 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_state_ = 1;
#line 284 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 3429 "tracker-bus.c"
		_state_1:
		;
	}
#line 287 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp11_ = _data_->self->priv->bus;
#line 287 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp12_ = _data_->_data7_->dbus_res;
#line 287 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp13_ = g_dbus_connection_send_message_with_reply_finish (_data_->_tmp11_, _data_->_tmp12_, &_data_->_inner_error0_);
#line 287 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->reply = _data_->_tmp13_;
#line 287 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 287 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 287 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 287 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 287 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 287 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 287 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 287 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 287 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 3459 "tracker-bus.c"
	}
#line 288 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp14_ = _data_->reply;
#line 288 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->self, _data_->_tmp14_, &_data_->_inner_error0_);
#line 288 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 288 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 288 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->reply);
#line 288 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->data_stream);
#line 288 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->output);
#line 288 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_g_object_unref0 (_data_->input);
#line 288 "../tracker/src/libtracker-bus/tracker-bus.vala"
		block7_data_unref (_data_->_data7_);
#line 288 "../tracker/src/libtracker-bus/tracker-bus.vala"
		_data_->_data7_ = NULL;
#line 288 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_object_unref (_data_->_async_result);
#line 288 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return FALSE;
#line 3485 "tracker-bus.c"
	}
#line 289 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp15_ = _data_->reply;
#line 289 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp16_ = g_dbus_message_get_body (_data_->_tmp15_);
#line 289 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp17_ = g_variant_get_child_value (_data_->_tmp16_, (gsize) 0);
#line 289 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->result = _data_->_tmp17_;
#line 289 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 289 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->data_stream);
#line 289 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->output);
#line 289 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->input);
#line 289 "../tracker/src/libtracker-bus/tracker-bus.vala"
	block7_data_unref (_data_->_data7_);
#line 289 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_data7_ = NULL;
#line 289 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 289 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 289 "../tracker/src/libtracker-bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 289 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3515 "tracker-bus.c"
		}
	}
#line 289 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 289 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return FALSE;
#line 3522 "tracker-bus.c"
}

static void
tracker_bus_connection_real_load (TrackerSparqlConnection* base,
                                  GFile* file,
                                  GCancellable* cancellable,
                                  GError** error)
{
	TrackerBusConnection * self;
	GDBusMessage* message = NULL;
	const gchar* _tmp0_;
	GDBusMessage* _tmp1_;
	GDBusMessage* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GDBusMessage* reply = NULL;
	GDBusConnection* _tmp7_;
	GDBusMessage* _tmp8_;
	GDBusMessage* _tmp9_;
	GDBusMessage* _tmp10_;
	GError* _inner_error0_ = NULL;
#line 292 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 292 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (file != NULL);
#line 293 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = self->priv->dbus_name;
#line 293 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp1_ = g_dbus_message_new_method_call (_tmp0_, TRACKER_DBUS_OBJECT_RESOURCES, TRACKER_DBUS_INTERFACE_RESOURCES, "Load");
#line 293 "../tracker/src/libtracker-bus/tracker-bus.vala"
	message = _tmp1_;
#line 294 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp2_ = message;
#line 294 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp3_ = g_file_get_uri (file);
#line 294 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp4_ = _tmp3_;
#line 294 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp5_ = g_variant_new ("(s)", _tmp4_, NULL);
#line 294 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_variant_ref_sink (_tmp5_);
#line 294 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp6_ = _tmp5_;
#line 294 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_dbus_message_set_body (_tmp2_, _tmp6_);
#line 294 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_variant_unref0 (_tmp6_);
#line 294 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_free0 (_tmp4_);
#line 296 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp7_ = self->priv->bus;
#line 296 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp8_ = message;
#line 296 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp9_ = g_dbus_connection_send_message_with_reply_sync (_tmp7_, _tmp8_, G_DBUS_SEND_MESSAGE_FLAGS_NONE, G_MAXINT, NULL, cancellable, &_inner_error0_);
#line 296 "../tracker/src/libtracker-bus/tracker-bus.vala"
	reply = _tmp9_;
#line 296 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 296 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (((_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) || (_inner_error0_->domain == G_DBUS_ERROR)) {
#line 296 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_propagate_error (error, _inner_error0_);
#line 296 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (message);
#line 296 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return;
#line 3592 "tracker-bus.c"
		} else {
#line 296 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (message);
#line 296 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 296 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_clear_error (&_inner_error0_);
#line 296 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return;
#line 3602 "tracker-bus.c"
		}
	}
#line 297 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp10_ = reply;
#line 297 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (self, _tmp10_, &_inner_error0_);
#line 297 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 297 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (((_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) || (_inner_error0_->domain == G_DBUS_ERROR)) {
#line 297 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_propagate_error (error, _inner_error0_);
#line 297 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (reply);
#line 297 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (message);
#line 297 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return;
#line 3621 "tracker-bus.c"
		} else {
#line 297 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (reply);
#line 297 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (message);
#line 297 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 297 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_clear_error (&_inner_error0_);
#line 297 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return;
#line 3633 "tracker-bus.c"
		}
	}
#line 292 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (reply);
#line 292 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (message);
#line 3640 "tracker-bus.c"
}

static void
tracker_bus_connection_real_load_async_data_free (gpointer _data)
{
	TrackerBusConnectionLoadAsyncData* _data_;
	_data_ = _data;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->file);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionLoadAsyncData, _data_);
#line 3656 "tracker-bus.c"
}

static void
tracker_bus_connection_real_load_async (TrackerSparqlConnection* base,
                                        GFile* file,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionLoadAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_return_if_fail (file != NULL);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionLoadAsyncData);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_load_async_data_free);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp1_ = _g_object_ref0 (file);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->file);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->file = _tmp1_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->cancellable = _tmp2_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_real_load_async_co (_data_);
#line 3699 "tracker-bus.c"
}

static void
tracker_bus_connection_load_finish (TrackerSparqlConnection* base,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	TrackerBusConnectionLoadAsyncData* _data_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return;
#line 3714 "tracker-bus.c"
	}
}

static void
tracker_bus_connection_load_async_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	TrackerBusConnectionLoadAsyncData* _data_;
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_ = _user_data_;
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_source_object_ = source_object;
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_res_ = _res_;
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_real_load_async_co (_data_);
#line 3732 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_real_load_async_co (TrackerBusConnectionLoadAsyncData* _data_)
{
#line 300 "../tracker/src/libtracker-bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 300 "../tracker/src/libtracker-bus/tracker-bus.vala"
		case 0:
#line 3742 "tracker-bus.c"
		goto _state_0;
#line 300 "../tracker/src/libtracker-bus/tracker-bus.vala"
		case 1:
#line 3746 "tracker-bus.c"
		goto _state_1;
		default:
#line 300 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 3751 "tracker-bus.c"
	}
	_state_0:
#line 301 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp0_ = _data_->self->priv->dbus_name;
#line 301 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp1_ = g_dbus_message_new_method_call (_data_->_tmp0_, TRACKER_DBUS_OBJECT_RESOURCES, TRACKER_DBUS_INTERFACE_RESOURCES, "Load");
#line 301 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->message = _data_->_tmp1_;
#line 302 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp2_ = _data_->message;
#line 302 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp3_ = g_file_get_uri (_data_->file);
#line 302 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp4_ = _data_->_tmp3_;
#line 302 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp5_ = g_variant_new ("(s)", _data_->_tmp4_, NULL);
#line 302 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_variant_ref_sink (_data_->_tmp5_);
#line 302 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp6_ = _data_->_tmp5_;
#line 302 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_dbus_message_set_body (_data_->_tmp2_, _data_->_tmp6_);
#line 302 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_variant_unref0 (_data_->_tmp6_);
#line 302 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_free0 (_data_->_tmp4_);
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp7_ = _data_->self->priv->bus;
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp8_ = _data_->message;
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_state_ = 1;
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_dbus_connection_send_message_with_reply (_data_->_tmp7_, _data_->_tmp8_, G_DBUS_SEND_MESSAGE_FLAGS_NONE, G_MAXINT, NULL, _data_->cancellable, tracker_bus_connection_load_async_ready, _data_);
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return FALSE;
#line 3788 "tracker-bus.c"
	_state_1:
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp9_ = g_dbus_connection_send_message_with_reply_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->reply = _data_->_tmp9_;
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (((_data_->_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) {
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return FALSE;
#line 3806 "tracker-bus.c"
		} else {
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 304 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return FALSE;
#line 3818 "tracker-bus.c"
		}
	}
#line 305 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp10_ = _data_->reply;
#line 305 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->self, _data_->_tmp10_, &_data_->_inner_error0_);
#line 305 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 305 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (((_data_->_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) {
#line 305 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 305 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_data_->reply);
#line 305 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 305 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 305 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return FALSE;
#line 3839 "tracker-bus.c"
		} else {
#line 305 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_data_->reply);
#line 305 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 305 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 305 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 305 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 305 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return FALSE;
#line 3853 "tracker-bus.c"
		}
	}
#line 300 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 300 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->message);
#line 300 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 300 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 300 "../tracker/src/libtracker-bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 300 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3868 "tracker-bus.c"
		}
	}
#line 300 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 300 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return FALSE;
#line 3875 "tracker-bus.c"
}

static gchar**
_variant_get2 (GVariant* value,
               gint* result_length1,
               gint* result_length2)
{
	gchar** _tmp0_;
	gint _tmp0__length;
	gint _tmp0__size;
	gint _tmp0__length1;
	GVariantIter _tmp1_;
	GVariant* _tmp2_;
	_tmp0_ = g_new (gchar*, 5);
	_tmp0__length = 0;
	_tmp0__size = 4;
	_tmp0__length1 = 0;
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_variant_iter_init (&_tmp1_, value);
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	for (; (_tmp2_ = g_variant_iter_next_value (&_tmp1_)) != NULL; _tmp0__length1++) {
#line 3897 "tracker-bus.c"
		gint _tmp0__length2;
		GVariantIter _tmp3_;
		GVariant* _tmp4_;
		_tmp0__length2 = 0;
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_variant_iter_init (&_tmp3_, _tmp2_);
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
		for (; (_tmp4_ = g_variant_iter_next_value (&_tmp3_)) != NULL; _tmp0__length2++) {
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
			if (_tmp0__size == _tmp0__length) {
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_tmp0__size = 2 * _tmp0__size;
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_tmp0_ = g_renew (gchar*, _tmp0_, _tmp0__size + 1);
#line 3912 "tracker-bus.c"
			}
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_tmp0_[_tmp0__length++] = g_variant_dup_string (_tmp4_, NULL);
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_variant_unref (_tmp4_);
#line 3918 "tracker-bus.c"
		}
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
		*result_length2 = _tmp0__length2;
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_variant_unref (_tmp2_);
#line 3924 "tracker-bus.c"
	}
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	*result_length1 = _tmp0__length1;
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_[_tmp0__length] = NULL;
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return _tmp0_;
#line 3932 "tracker-bus.c"
}

static TrackerSparqlCursor*
tracker_bus_connection_real_statistics (TrackerSparqlConnection* base,
                                        GCancellable* cancellable,
                                        GError** error)
{
	TrackerBusConnection * self;
	GDBusMessage* message = NULL;
	const gchar* _tmp0_;
	GDBusMessage* _tmp1_;
	GDBusMessage* reply = NULL;
	GDBusConnection* _tmp2_;
	GDBusMessage* _tmp3_;
	GDBusMessage* _tmp4_;
	GDBusMessage* _tmp5_;
	gchar** results = NULL;
	GDBusMessage* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp10__length2 = 0;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gint _tmp11__length2;
	gint results_length1;
	gint results_length2;
	TrackerSparqlValueType* types = NULL;
	TrackerSparqlValueType* _tmp12_;
	gint types_length1;
	gint _types_size_;
	gchar** var_names = NULL;
	gchar** _tmp13_;
	gint var_names_length1;
	gint _var_names_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar* _tmp17_;
	TrackerSparqlValueType* _tmp18_;
	gint _tmp18__length1;
	TrackerSparqlValueType* _tmp19_;
	gint _tmp19__length1;
	gint rows = 0;
	gchar** _tmp20_;
	gint _tmp20__length1;
	gint _tmp20__length2;
	gint _tmp21_;
	gint cols = 0;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gint _tmp22__length2;
	gint _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gint _tmp24__length2;
	gchar** _tmp25_;
	gint _tmp25__length1;
	TrackerSparqlValueType* _tmp26_;
	gint _tmp26__length1;
	TrackerBusArrayCursor* _tmp27_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlCursor* result;
#line 308 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 309 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = self->priv->dbus_name;
#line 309 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp1_ = g_dbus_message_new_method_call (_tmp0_, TRACKER_DBUS_OBJECT_STATISTICS, TRACKER_DBUS_INTERFACE_STATISTICS, "Get");
#line 309 "../tracker/src/libtracker-bus/tracker-bus.vala"
	message = _tmp1_;
#line 311 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp2_ = self->priv->bus;
#line 311 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp3_ = message;
#line 311 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp4_ = g_dbus_connection_send_message_with_reply_sync (_tmp2_, _tmp3_, G_DBUS_SEND_MESSAGE_FLAGS_NONE, G_MAXINT, NULL, cancellable, &_inner_error0_);
#line 311 "../tracker/src/libtracker-bus/tracker-bus.vala"
	reply = _tmp4_;
#line 311 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 311 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (((_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) || (_inner_error0_->domain == G_DBUS_ERROR)) {
#line 311 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_propagate_error (error, _inner_error0_);
#line 311 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (message);
#line 311 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return NULL;
#line 4026 "tracker-bus.c"
		} else {
#line 311 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (message);
#line 311 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 311 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_clear_error (&_inner_error0_);
#line 311 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return NULL;
#line 4036 "tracker-bus.c"
		}
	}
#line 312 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp5_ = reply;
#line 312 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (self, _tmp5_, &_inner_error0_);
#line 312 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 312 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (((_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_inner_error0_->domain == G_IO_ERROR)) || (_inner_error0_->domain == G_DBUS_ERROR)) {
#line 312 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_propagate_error (error, _inner_error0_);
#line 312 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (reply);
#line 312 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (message);
#line 312 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return NULL;
#line 4055 "tracker-bus.c"
		} else {
#line 312 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (reply);
#line 312 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (message);
#line 312 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 312 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_clear_error (&_inner_error0_);
#line 312 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return NULL;
#line 4067 "tracker-bus.c"
		}
	}
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp6_ = reply;
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp7_ = g_dbus_message_get_body (_tmp6_);
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp8_ = g_variant_get_child_value (_tmp7_, (gsize) 0);
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp9_ = _tmp8_;
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp10_ = _variant_get2 (_tmp9_, &_tmp10__length1, &_tmp10__length2);
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp11_ = _tmp10_;
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp11__length1 = _tmp10__length1;
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp11__length2 = _tmp10__length2;
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_variant_unref0 (_tmp9_);
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	results = _tmp11_;
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	results_length1 = _tmp11__length1;
#line 314 "../tracker/src/libtracker-bus/tracker-bus.vala"
	results_length2 = _tmp11__length2;
#line 315 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp12_ = g_new0 (TrackerSparqlValueType, 2);
#line 315 "../tracker/src/libtracker-bus/tracker-bus.vala"
	types = _tmp12_;
#line 315 "../tracker/src/libtracker-bus/tracker-bus.vala"
	types_length1 = 2;
#line 315 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_types_size_ = types_length1;
#line 316 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp13_ = g_new0 (gchar*, 2 + 1);
#line 316 "../tracker/src/libtracker-bus/tracker-bus.vala"
	var_names = _tmp13_;
#line 316 "../tracker/src/libtracker-bus/tracker-bus.vala"
	var_names_length1 = 2;
#line 316 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_var_names_size_ = var_names_length1;
#line 318 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp14_ = var_names;
#line 318 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp14__length1 = var_names_length1;
#line 318 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp15_ = g_strdup ("class");
#line 318 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_free0 (_tmp14_[0]);
#line 318 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp14_[0] = _tmp15_;
#line 319 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp16_ = var_names;
#line 319 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp16__length1 = var_names_length1;
#line 319 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp17_ = g_strdup ("count");
#line 319 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_free0 (_tmp16_[1]);
#line 319 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp16_[1] = _tmp17_;
#line 320 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp18_ = types;
#line 320 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp18__length1 = types_length1;
#line 320 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp18_[0] = TRACKER_SPARQL_VALUE_TYPE_STRING;
#line 321 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp19_ = types;
#line 321 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp19__length1 = types_length1;
#line 321 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp19_[1] = TRACKER_SPARQL_VALUE_TYPE_INTEGER;
#line 323 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp20_ = results;
#line 323 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp20__length1 = results_length1;
#line 323 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp20__length2 = results_length2;
#line 323 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp21_ = _tmp20__length1;
#line 323 "../tracker/src/libtracker-bus/tracker-bus.vala"
	rows = _tmp21_;
#line 324 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp22_ = results;
#line 324 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp22__length1 = results_length1;
#line 324 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp22__length2 = results_length2;
#line 324 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp23_ = _tmp22__length2;
#line 324 "../tracker/src/libtracker-bus/tracker-bus.vala"
	cols = _tmp23_;
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp24_ = results;
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp24__length1 = results_length1;
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp24__length2 = results_length2;
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	results = NULL;
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	results_length1 = 0;
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	results_length2 = 0;
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp25_ = var_names;
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp25__length1 = var_names_length1;
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp26_ = types;
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp26__length1 = types_length1;
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp27_ = tracker_bus_array_cursor_new (_tmp24_, _tmp24__length1, _tmp24__length2, rows, cols, _tmp25_, _tmp25__length1, _tmp26_, _tmp26__length1);
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	result = (TrackerSparqlCursor*) _tmp27_;
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	var_names = (_vala_array_free (var_names, var_names_length1, (GDestroyNotify) g_free), NULL);
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	types = (g_free (types), NULL);
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	results = (_vala_array_free (results, results_length1 * results_length2, (GDestroyNotify) g_free), NULL);
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (reply);
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (message);
#line 325 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return result;
#line 4198 "tracker-bus.c"
}

static void
tracker_bus_connection_real_statistics_async_data_free (gpointer _data)
{
	TrackerBusConnectionStatisticsAsyncData* _data_;
	_data_ = _data;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->result);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->self);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_slice_free (TrackerBusConnectionStatisticsAsyncData, _data_);
#line 4214 "tracker-bus.c"
}

static void
tracker_bus_connection_real_statistics_async (TrackerSparqlConnection* base,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	TrackerBusConnection * self;
	TrackerBusConnectionStatisticsAsyncData* _data_;
	TrackerBusConnection* _tmp0_;
	GCancellable* _tmp1_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = (TrackerBusConnection*) base;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_ = g_slice_new0 (TrackerBusConnectionStatisticsAsyncData);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_bus_connection_real_statistics_async_data_free);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->self = _tmp0_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp1_ = _g_object_ref0 (cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->cancellable = _tmp1_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_real_statistics_async_co (_data_);
#line 4247 "tracker-bus.c"
}

static TrackerSparqlCursor*
tracker_bus_connection_statistics_finish (TrackerSparqlConnection* base,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	TrackerSparqlCursor* result;
	TrackerBusConnectionStatisticsAsyncData* _data_;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (NULL == _data_) {
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
		return NULL;
#line 4263 "tracker-bus.c"
	}
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	result = _data_->result;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->result = NULL;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return result;
#line 4271 "tracker-bus.c"
}

static void
tracker_bus_connection_statistics_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	TrackerBusConnectionStatisticsAsyncData* _data_;
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_ = _user_data_;
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_source_object_ = source_object;
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_res_ = _res_;
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_real_statistics_async_co (_data_);
#line 4288 "tracker-bus.c"
}

static gchar**
_variant_get3 (GVariant* value,
               gint* result_length1,
               gint* result_length2)
{
	gchar** _tmp0_;
	gint _tmp0__length;
	gint _tmp0__size;
	gint _tmp0__length1;
	GVariantIter _tmp1_;
	GVariant* _tmp2_;
	_tmp0_ = g_new (gchar*, 5);
	_tmp0__length = 0;
	_tmp0__size = 4;
	_tmp0__length1 = 0;
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_variant_iter_init (&_tmp1_, value);
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	for (; (_tmp2_ = g_variant_iter_next_value (&_tmp1_)) != NULL; _tmp0__length1++) {
#line 4310 "tracker-bus.c"
		gint _tmp0__length2;
		GVariantIter _tmp3_;
		GVariant* _tmp4_;
		_tmp0__length2 = 0;
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_variant_iter_init (&_tmp3_, _tmp2_);
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
		for (; (_tmp4_ = g_variant_iter_next_value (&_tmp3_)) != NULL; _tmp0__length2++) {
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
			if (_tmp0__size == _tmp0__length) {
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_tmp0__size = 2 * _tmp0__size;
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
				_tmp0_ = g_renew (gchar*, _tmp0_, _tmp0__size + 1);
#line 4325 "tracker-bus.c"
			}
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_tmp0_[_tmp0__length++] = g_variant_dup_string (_tmp4_, NULL);
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_variant_unref (_tmp4_);
#line 4331 "tracker-bus.c"
		}
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
		*result_length2 = _tmp0__length2;
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_variant_unref (_tmp2_);
#line 4337 "tracker-bus.c"
	}
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	*result_length1 = _tmp0__length1;
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_tmp0_[_tmp0__length] = NULL;
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return _tmp0_;
#line 4345 "tracker-bus.c"
}

static gboolean
tracker_bus_connection_real_statistics_async_co (TrackerBusConnectionStatisticsAsyncData* _data_)
{
#line 332 "../tracker/src/libtracker-bus/tracker-bus.vala"
	switch (_data_->_state_) {
#line 332 "../tracker/src/libtracker-bus/tracker-bus.vala"
		case 0:
#line 4355 "tracker-bus.c"
		goto _state_0;
#line 332 "../tracker/src/libtracker-bus/tracker-bus.vala"
		case 1:
#line 4359 "tracker-bus.c"
		goto _state_1;
		default:
#line 332 "../tracker/src/libtracker-bus/tracker-bus.vala"
		g_assert_not_reached ();
#line 4364 "tracker-bus.c"
	}
	_state_0:
#line 333 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp0_ = _data_->self->priv->dbus_name;
#line 333 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp1_ = g_dbus_message_new_method_call (_data_->_tmp0_, TRACKER_DBUS_OBJECT_STATISTICS, TRACKER_DBUS_INTERFACE_STATISTICS, "Get");
#line 333 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->message = _data_->_tmp1_;
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp2_ = _data_->self->priv->bus;
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp3_ = _data_->message;
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_state_ = 1;
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_dbus_connection_send_message_with_reply (_data_->_tmp2_, _data_->_tmp3_, G_DBUS_SEND_MESSAGE_FLAGS_NONE, G_MAXINT, NULL, _data_->cancellable, tracker_bus_connection_statistics_async_ready, _data_);
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return FALSE;
#line 4383 "tracker-bus.c"
	_state_1:
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp4_ = g_dbus_connection_send_message_with_reply_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->reply = _data_->_tmp4_;
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (((_data_->_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) {
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return FALSE;
#line 4401 "tracker-bus.c"
		} else {
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 335 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return FALSE;
#line 4413 "tracker-bus.c"
		}
	}
#line 336 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp5_ = _data_->reply;
#line 336 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_handle_error_reply (_data_->self, _data_->_tmp5_, &_data_->_inner_error0_);
#line 336 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 336 "../tracker/src/libtracker-bus/tracker-bus.vala"
		if (((_data_->_inner_error0_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) || (_data_->_inner_error0_->domain == G_DBUS_ERROR)) {
#line 336 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 336 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_data_->reply);
#line 336 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 336 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 336 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return FALSE;
#line 4434 "tracker-bus.c"
		} else {
#line 336 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_data_->reply);
#line 336 "../tracker/src/libtracker-bus/tracker-bus.vala"
			_g_object_unref0 (_data_->message);
#line 336 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
#line 336 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_clear_error (&_data_->_inner_error0_);
#line 336 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_object_unref (_data_->_async_result);
#line 336 "../tracker/src/libtracker-bus/tracker-bus.vala"
			return FALSE;
#line 4448 "tracker-bus.c"
		}
	}
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp6_ = _data_->reply;
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp7_ = g_dbus_message_get_body (_data_->_tmp6_);
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp8_ = g_variant_get_child_value (_data_->_tmp7_, (gsize) 0);
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp10_ = NULL;
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp10__length1 = 0;
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp10__length2 = 0;
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp10_ = _variant_get3 (_data_->_tmp9_, &_data_->_tmp10__length1, &_data_->_tmp10__length2);
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp11__length1 = _data_->_tmp10__length1;
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp11__length2 = _data_->_tmp10__length2;
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_variant_unref0 (_data_->_tmp9_);
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->results = _data_->_tmp11_;
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->results_length1 = _data_->_tmp11__length1;
#line 338 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->results_length2 = _data_->_tmp11__length2;
#line 339 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp12_ = g_new0 (TrackerSparqlValueType, 2);
#line 339 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->types = _data_->_tmp12_;
#line 339 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->types_length1 = 2;
#line 339 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_types_size_ = _data_->types_length1;
#line 340 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp13_ = g_new0 (gchar*, 2 + 1);
#line 340 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->var_names = _data_->_tmp13_;
#line 340 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->var_names_length1 = 2;
#line 340 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_var_names_size_ = _data_->var_names_length1;
#line 342 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp14_ = _data_->var_names;
#line 342 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp14__length1 = _data_->var_names_length1;
#line 342 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp15_ = g_strdup ("class");
#line 342 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_free0 (_data_->_tmp14_[0]);
#line 342 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp14_[0] = _data_->_tmp15_;
#line 343 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp16_ = _data_->var_names;
#line 343 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp16__length1 = _data_->var_names_length1;
#line 343 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp17_ = g_strdup ("count");
#line 343 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_free0 (_data_->_tmp16_[1]);
#line 343 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp16_[1] = _data_->_tmp17_;
#line 344 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp18_ = _data_->types;
#line 344 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp18__length1 = _data_->types_length1;
#line 344 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp18_[0] = TRACKER_SPARQL_VALUE_TYPE_STRING;
#line 345 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp19_ = _data_->types;
#line 345 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp19__length1 = _data_->types_length1;
#line 345 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp19_[1] = TRACKER_SPARQL_VALUE_TYPE_INTEGER;
#line 347 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp20_ = _data_->results;
#line 347 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp20__length1 = _data_->results_length1;
#line 347 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp20__length2 = _data_->results_length2;
#line 347 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp21_ = _data_->_tmp20__length1;
#line 347 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->rows = _data_->_tmp21_;
#line 348 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp22_ = _data_->results;
#line 348 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp22__length1 = _data_->results_length1;
#line 348 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp22__length2 = _data_->results_length2;
#line 348 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp23_ = _data_->_tmp22__length2;
#line 348 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->cols = _data_->_tmp23_;
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp24_ = _data_->results;
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp24__length1 = _data_->results_length1;
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp24__length2 = _data_->results_length2;
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->results = NULL;
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->results_length1 = 0;
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->results_length2 = 0;
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp25_ = _data_->var_names;
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp25__length1 = _data_->var_names_length1;
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp26_ = _data_->types;
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp26__length1 = _data_->types_length1;
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->_tmp27_ = tracker_bus_array_cursor_new (_data_->_tmp24_, _data_->_tmp24__length1, _data_->_tmp24__length2, _data_->rows, _data_->cols, _data_->_tmp25_, _data_->_tmp25__length1, _data_->_tmp26_, _data_->_tmp26__length1);
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->result = (TrackerSparqlCursor*) _data_->_tmp27_;
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->var_names = (_vala_array_free (_data_->var_names, _data_->var_names_length1, (GDestroyNotify) g_free), NULL);
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->types = (g_free (_data_->types), NULL);
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_data_->results = (_vala_array_free (_data_->results, _data_->results_length1 * _data_->results_length2, (GDestroyNotify) g_free), NULL);
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->reply);
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (_data_->message);
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	if (_data_->_state_ != 0) {
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 4591 "tracker-bus.c"
		}
	}
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_object_unref (_data_->_async_result);
#line 349 "../tracker/src/libtracker-bus/tracker-bus.vala"
	return FALSE;
#line 4598 "tracker-bus.c"
}

static void
tracker_bus_connection_class_init (TrackerBusConnectionClass * klass,
                                   gpointer klass_data)
{
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	tracker_bus_connection_parent_class = g_type_class_peek_parent (klass);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	g_type_class_adjust_private_offset (klass, &TrackerBusConnection_private_offset);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->query = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GError**)) tracker_bus_connection_real_query;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->query_async = (void (*) (TrackerSparqlConnection*, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_query_async;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->query_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_bus_connection_query_finish;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update = (void (*) (TrackerSparqlConnection*, const gchar*, gint, GCancellable*, GError**)) tracker_bus_connection_real_update;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_async = (void (*) (TrackerSparqlConnection*, const gchar*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_update_async;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_finish = (void (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_bus_connection_update_finish;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_array_async = (void (*) (TrackerSparqlConnection*, gchar**, gint, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_update_array_async;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_array_finish = (GPtrArray* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_bus_connection_update_array_finish;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank = (GVariant* (*) (TrackerSparqlConnection*, const gchar*, gint, GCancellable*, GError**)) tracker_bus_connection_real_update_blank;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_async = (void (*) (TrackerSparqlConnection*, const gchar*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_update_blank_async;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_finish = (GVariant* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_bus_connection_update_blank_finish;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->load = (void (*) (TrackerSparqlConnection*, GFile*, GCancellable*, GError**)) tracker_bus_connection_real_load;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->load_async = (void (*) (TrackerSparqlConnection*, GFile*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_load_async;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->load_finish = (void (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_bus_connection_load_finish;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, GCancellable*, GError**)) tracker_bus_connection_real_statistics;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics_async = (void (*) (TrackerSparqlConnection*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_bus_connection_real_statistics_async;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	((TrackerSparqlConnectionClass *) klass)->statistics_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection*, GAsyncResult*, GError**)) tracker_bus_connection_statistics_finish;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_bus_connection_finalize;
#line 4645 "tracker-bus.c"
}

static void
tracker_bus_connection_instance_init (TrackerBusConnection * self,
                                      gpointer klass)
{
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self->priv = tracker_bus_connection_get_instance_private (self);
#line 4654 "tracker-bus.c"
}

static void
tracker_bus_connection_finalize (GObject * obj)
{
	TrackerBusConnection * self;
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_BUS_TYPE_CONNECTION, TrackerBusConnection);
#line 21 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_object_unref0 (self->priv->bus);
#line 22 "../tracker/src/libtracker-bus/tracker-bus.vala"
	_g_free0 (self->priv->dbus_name);
#line 20 "../tracker/src/libtracker-bus/tracker-bus.vala"
	G_OBJECT_CLASS (tracker_bus_connection_parent_class)->finalize (obj);
#line 4669 "tracker-bus.c"
}

static GType
tracker_bus_connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrackerBusConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_bus_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerBusConnection), 0, (GInstanceInitFunc) tracker_bus_connection_instance_init, NULL };
	GType tracker_bus_connection_type_id;
	tracker_bus_connection_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerBusConnection", &g_define_type_info, 0);
	TrackerBusConnection_private_offset = g_type_add_instance_private (tracker_bus_connection_type_id, sizeof (TrackerBusConnectionPrivate));
	return tracker_bus_connection_type_id;
}

GType
tracker_bus_connection_get_type (void)
{
	static volatile gsize tracker_bus_connection_type_id__once = 0;
	if (g_once_init_enter (&tracker_bus_connection_type_id__once)) {
		GType tracker_bus_connection_type_id;
		tracker_bus_connection_type_id = tracker_bus_connection_get_type_once ();
		g_once_init_leave (&tracker_bus_connection_type_id__once, tracker_bus_connection_type_id);
	}
	return tracker_bus_connection_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

