/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.tomcat.util.security.Escape;

public class XMLWriter {
    public static final int OPENING = 0;
    public static final int CLOSING = 1;
    public static final int NO_CONTENT = 2;
    protected StringBuilder buffer = new StringBuilder();
    protected final Writer writer;
    protected boolean lastWriteWasOpen;

    public XMLWriter() {
        this(null);
    }

    public XMLWriter(Writer writer) {
        this.writer = writer;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void writeProperty(String string, String string2, String string3) {
        this.writeElement(string, string2, 0);
        this.buffer.append(string3);
        this.writeElement(string, string2, 1);
    }

    public void writeElement(String string, String string2, int n) {
        this.writeElement(string, null, string2, n);
    }

    public void writeElement(String string, String string2, String string3, int n) {
        if (string != null && !string.isEmpty()) {
            switch (n) {
                case 0: {
                    if (this.lastWriteWasOpen) {
                        this.buffer.append('\n');
                    }
                    if (string2 != null) {
                        this.buffer.append("<").append(string).append(":").append(string3).append(" xmlns:").append(string).append("=\"").append(string2).append("\">");
                    } else {
                        this.buffer.append("<").append(string).append(":").append(string3).append(">");
                    }
                    this.lastWriteWasOpen = true;
                    break;
                }
                case 1: {
                    this.buffer.append("</").append(string).append(":").append(string3).append(">\n");
                    this.lastWriteWasOpen = false;
                    break;
                }
                default: {
                    if (this.lastWriteWasOpen) {
                        this.buffer.append('\n');
                    }
                    if (string2 != null) {
                        this.buffer.append("<").append(string).append(":").append(string3).append(" xmlns:").append(string).append("=\"").append(string2).append("\"/>\n");
                    } else {
                        this.buffer.append("<").append(string).append(":").append(string3).append("/>\n");
                    }
                    this.lastWriteWasOpen = false;
                    break;
                }
            }
        } else if (string2 != null && !string2.isEmpty()) {
            switch (n) {
                case 0: {
                    if (this.lastWriteWasOpen) {
                        this.buffer.append('\n');
                    }
                    this.buffer.append("<").append(string3).append(" xmlns=\"").append(string2).append("\">");
                    this.lastWriteWasOpen = true;
                    break;
                }
                case 1: {
                    this.buffer.append("</").append(string3).append(">\n");
                    this.lastWriteWasOpen = false;
                    break;
                }
                default: {
                    if (this.lastWriteWasOpen) {
                        this.buffer.append('\n');
                    }
                    this.buffer.append("<").append(string3).append(" xmlns=\"").append(string2).append("\"/>\n");
                    this.lastWriteWasOpen = false;
                    break;
                }
            }
        } else {
            switch (n) {
                case 0: {
                    if (this.lastWriteWasOpen) {
                        this.buffer.append('\n');
                    }
                    this.buffer.append("<").append(string3).append(">");
                    this.lastWriteWasOpen = true;
                    break;
                }
                case 1: {
                    this.buffer.append("</").append(string3).append(">\n");
                    this.lastWriteWasOpen = false;
                    break;
                }
                default: {
                    if (this.lastWriteWasOpen) {
                        this.buffer.append('\n');
                    }
                    this.buffer.append("<").append(string3).append("/>\n");
                    this.lastWriteWasOpen = false;
                }
            }
        }
    }

    public void writeText(String string) {
        this.buffer.append(Escape.xml((String)string));
    }

    public void writeRaw(String string) {
        this.buffer.append(string);
    }

    public void writeData(String string) {
        this.buffer.append("<![CDATA[").append(string).append("]]>");
    }

    public void writeXMLHeader() {
        this.buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
    }

    public void sendData() throws IOException {
        if (this.writer != null) {
            this.writer.write(this.buffer.toString());
            this.buffer = new StringBuilder();
        }
    }
}

