/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.SceneGraphIO;
import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeState;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.SceneGraphObjectState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.SceneGraphObject;

public class GroupState
extends NodeState {
    protected SceneGraphObjectState[] groupChildren;

    public GroupState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        this.control.writeBounds(dataOutput, ((Group)this.node).getCollisionBounds());
        int n = this.checkProcessChildren() ? ((Group)this.node).numChildren() : 0;
        dataOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.control.writeObject(dataOutput, this.control.createState((SceneGraphObject)((Group)this.node).getChild(i)));
        }
        dataOutput.writeBoolean(((Group)this.node).getAlternateCollisionTarget());
    }

    @Override
    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        ((Group)this.node).setCollisionBounds(this.control.readBounds(dataInput));
        int n = dataInput.readInt();
        this.groupChildren = new SceneGraphObjectState[n];
        for (int i = 0; i < n; ++i) {
            this.groupChildren[i] = this.control.readObject(dataInput);
            ((Group)this.node).addChild((Node)this.groupChildren[i].getNode());
        }
        ((Group)this.node).setAlternateCollisionTarget(dataInput.readBoolean());
    }

    private boolean checkProcessChildren() {
        if (this.node instanceof SceneGraphIO) {
            return ((SceneGraphIO)this.node).saveChildren();
        }
        return this.processChildren();
    }

    protected boolean processChildren() {
        return true;
    }

    @Override
    public void buildGraph() {
        for (int i = 0; i < this.groupChildren.length; ++i) {
            if (this.groupChildren[i].getSymbol().graphBuilt) continue;
            this.groupChildren[i].getSymbol().graphBuilt = true;
            this.groupChildren[i].buildGraph();
        }
        super.buildGraph();
    }

    @Override
    public void cleanup() {
        for (int i = 0; i < this.groupChildren.length; ++i) {
            this.groupChildren[i].cleanup();
            this.groupChildren[i] = null;
        }
        this.groupChildren = null;
        super.cleanup();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Group();
    }
}

