/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.interpolators;

import com.sun.j3d.utils.behaviors.interpolators.TCBKeyFrame;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class CubicSplineSegment {
    static final double[] modRoot = new double[]{0.046910077, 0.230765345, 0.5, 0.769234655, 0.953089922};
    static final double[] modCoeff = new double[]{0.118463442, 0.239314335, 0.284444444, 0.239314335, 0.118463442};
    TCBKeyFrame[] keyFrame = new TCBKeyFrame[4];
    Point3f c0;
    Point3f c1;
    Point3f c2;
    Point3f c3;
    Point3f e0;
    Point3f e1;
    Point3f e2;
    Point3f e3;
    float one_minus_t_in;
    float one_minus_c_in;
    float one_minus_b_in;
    float one_plus_c_in;
    float one_plus_b_in;
    float ddb;
    float dda;
    float one_minus_t_out;
    float one_minus_c_out;
    float one_minus_b_out;
    float one_plus_c_out;
    float one_plus_b_out;
    float dsb;
    float dsa;
    float length;
    int linear;

    CubicSplineSegment() {
        this.length = 0.0f;
    }

    CubicSplineSegment(TCBKeyFrame tCBKeyFrame, TCBKeyFrame tCBKeyFrame2, TCBKeyFrame tCBKeyFrame3, TCBKeyFrame tCBKeyFrame4) {
        this.keyFrame[0] = new TCBKeyFrame(tCBKeyFrame);
        this.keyFrame[1] = new TCBKeyFrame(tCBKeyFrame2);
        this.keyFrame[2] = new TCBKeyFrame(tCBKeyFrame3);
        this.keyFrame[3] = new TCBKeyFrame(tCBKeyFrame4);
        if (tCBKeyFrame3.linear == 1) {
            this.linear = 1;
        } else {
            this.linear = 0;
            this.computeCommonCoefficients(tCBKeyFrame, tCBKeyFrame2, tCBKeyFrame3, tCBKeyFrame4);
            this.computeHermiteCoefficients(tCBKeyFrame, tCBKeyFrame2, tCBKeyFrame3, tCBKeyFrame4);
        }
        this.length = this.computeLength(1.0f);
    }

    private void computeCommonCoefficients(TCBKeyFrame tCBKeyFrame, TCBKeyFrame tCBKeyFrame2, TCBKeyFrame tCBKeyFrame3, TCBKeyFrame tCBKeyFrame4) {
        float f = 1.0f - tCBKeyFrame2.tension;
        float f2 = 1.0f - tCBKeyFrame2.continuity;
        float f3 = 1.0f - tCBKeyFrame2.bias;
        float f4 = 1.0f + tCBKeyFrame2.continuity;
        float f5 = 1.0f + tCBKeyFrame2.bias;
        this.ddb = f * f2 * f3;
        this.dda = f * f4 * f5;
        float f6 = 1.0f - tCBKeyFrame3.tension;
        float f7 = 1.0f - tCBKeyFrame3.continuity;
        float f8 = 1.0f - tCBKeyFrame3.bias;
        float f9 = 1.0f + tCBKeyFrame3.continuity;
        float f10 = 1.0f + tCBKeyFrame3.bias;
        this.dsb = f * f4 * f3;
        this.dsa = f * f2 * f5;
    }

    private void computeHermiteCoefficients(TCBKeyFrame tCBKeyFrame, TCBKeyFrame tCBKeyFrame2, TCBKeyFrame tCBKeyFrame3, TCBKeyFrame tCBKeyFrame4) {
        float f;
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        point3f.x = tCBKeyFrame3.position.x - tCBKeyFrame2.position.x;
        point3f.y = tCBKeyFrame3.position.y - tCBKeyFrame2.position.y;
        point3f.z = tCBKeyFrame3.position.z - tCBKeyFrame2.position.z;
        point3f2.x = tCBKeyFrame3.scale.x - tCBKeyFrame2.scale.x;
        point3f2.y = tCBKeyFrame3.scale.y - tCBKeyFrame2.scale.y;
        point3f2.z = tCBKeyFrame3.scale.z - tCBKeyFrame2.scale.z;
        Point3f point3f3 = new Point3f();
        Point3f point3f4 = new Point3f();
        if (tCBKeyFrame.knot == tCBKeyFrame2.knot) {
            f = 0.5f * (this.dda + this.ddb);
            point3f3.x = f * point3f.x;
            point3f3.y = f * point3f.y;
            point3f3.z = f * point3f.z;
            point3f4.x = f * point3f2.x;
            point3f4.y = f * point3f2.y;
            point3f4.z = f * point3f2.z;
        } else {
            f = (tCBKeyFrame2.knot - tCBKeyFrame.knot) / (tCBKeyFrame3.knot - tCBKeyFrame.knot);
            point3f3.x = f * (this.ddb * point3f.x + this.dda * (tCBKeyFrame2.position.x - tCBKeyFrame.position.x));
            point3f3.y = f * (this.ddb * point3f.y + this.dda * (tCBKeyFrame2.position.y - tCBKeyFrame.position.y));
            point3f3.z = f * (this.ddb * point3f.z + this.dda * (tCBKeyFrame2.position.z - tCBKeyFrame.position.z));
            point3f4.x = f * (this.ddb * point3f2.x + this.dda * (tCBKeyFrame2.scale.x - tCBKeyFrame.scale.x));
            point3f4.y = f * (this.ddb * point3f2.y + this.dda * (tCBKeyFrame2.scale.y - tCBKeyFrame.scale.y));
            point3f4.z = f * (this.ddb * point3f2.z + this.dda * (tCBKeyFrame2.scale.z - tCBKeyFrame.scale.z));
        }
        Point3f point3f5 = new Point3f();
        Point3f point3f6 = new Point3f();
        if (tCBKeyFrame3.knot == tCBKeyFrame4.knot) {
            float f2 = 0.5f * (this.dsa + this.dsb);
            point3f5.x = f2 * point3f.x;
            point3f5.y = f2 * point3f.y;
            point3f5.z = f2 * point3f.z;
            point3f6.x = f2 * point3f2.x;
            point3f6.y = f2 * point3f2.y;
            point3f6.z = f2 * point3f2.z;
        } else {
            float f3 = (tCBKeyFrame3.knot - tCBKeyFrame2.knot) / (tCBKeyFrame4.knot - tCBKeyFrame2.knot);
            point3f5.x = f3 * (this.dsb * (tCBKeyFrame4.position.x - tCBKeyFrame3.position.x) + this.dsa * point3f.x);
            point3f5.y = f3 * (this.dsb * (tCBKeyFrame4.position.y - tCBKeyFrame3.position.y) + this.dsa * point3f.y);
            point3f5.z = f3 * (this.dsb * (tCBKeyFrame4.position.z - tCBKeyFrame3.position.z) + this.dsa * point3f.z);
            point3f6.x = f3 * (this.dsb * (tCBKeyFrame4.scale.x - tCBKeyFrame3.scale.x) + this.dsa * point3f2.x);
            point3f6.y = f3 * (this.dsb * (tCBKeyFrame4.scale.y - tCBKeyFrame3.scale.y) + this.dsa * point3f2.y);
            point3f6.z = f3 * (this.dsb * (tCBKeyFrame4.scale.z - tCBKeyFrame3.scale.z) + this.dsa * point3f2.z);
        }
        this.c0 = new Point3f();
        this.c0.x = tCBKeyFrame2.position.x;
        this.c0.y = tCBKeyFrame2.position.y;
        this.c0.z = tCBKeyFrame2.position.z;
        this.c1 = new Point3f();
        this.c1.x = point3f3.x;
        this.c1.y = point3f3.y;
        this.c1.z = point3f3.z;
        this.c2 = new Point3f();
        this.c2.x = 3.0f * point3f.x - 2.0f * point3f3.x - point3f5.x;
        this.c2.y = 3.0f * point3f.y - 2.0f * point3f3.y - point3f5.y;
        this.c2.z = 3.0f * point3f.z - 2.0f * point3f3.z - point3f5.z;
        this.c3 = new Point3f();
        this.c3.x = -2.0f * point3f.x + point3f3.x + point3f5.x;
        this.c3.y = -2.0f * point3f.y + point3f3.y + point3f5.y;
        this.c3.z = -2.0f * point3f.z + point3f3.z + point3f5.z;
        this.e0 = new Point3f();
        this.e0.x = tCBKeyFrame2.scale.x;
        this.e0.y = tCBKeyFrame2.scale.y;
        this.e0.z = tCBKeyFrame2.scale.z;
        this.e1 = new Point3f();
        this.e1.x = point3f4.x;
        this.e1.y = point3f4.y;
        this.e1.z = point3f4.z;
        this.e2 = new Point3f();
        this.e2.x = 3.0f * point3f2.x - 2.0f * point3f4.x - point3f6.x;
        this.e2.y = 3.0f * point3f2.y - 2.0f * point3f4.y - point3f6.y;
        this.e2.z = 3.0f * point3f2.z - 2.0f * point3f4.z - point3f6.z;
        this.e3 = new Point3f();
        this.e3.x = -2.0f * point3f2.x + point3f4.x + point3f6.x;
        this.e3.y = -2.0f * point3f2.y + point3f4.y + point3f6.y;
        this.e3.z = -2.0f * point3f2.z + point3f4.z + point3f6.z;
    }

    public float computeLength(float f) {
        float f2 = 0.0f;
        if (this.linear == 1) {
            f2 = f * this.keyFrame[2].position.distance(this.keyFrame[1].position);
        } else {
            int n = 5;
            for (int i = 0; i < n; ++i) {
                f2 += (float)modCoeff[i] * this.computeSpeed(f * (float)modRoot[i]);
            }
            f2 *= f;
        }
        return f2;
    }

    private float computeSpeed(float f) {
        Point3f point3f = new Point3f();
        point3f.x = this.c1.x + f * (2.0f * this.c2.x + 3.0f * f * this.c3.x);
        point3f.y = this.c1.y + f * (2.0f * this.c2.y + 3.0f * f * this.c3.y);
        point3f.z = this.c1.z + f * (2.0f * this.c2.z + 3.0f * f * this.c3.z);
        return (float)Math.sqrt(point3f.x * point3f.x + point3f.y * point3f.y + point3f.z * point3f.z);
    }

    public void getInterpolatedQuaternion(float f, Quat4f quat4f) {
        if (this.linear == 1) {
            double d = this.keyFrame[1].quat.x * this.keyFrame[2].quat.x + this.keyFrame[1].quat.y * this.keyFrame[2].quat.y + this.keyFrame[1].quat.z * this.keyFrame[2].quat.z + this.keyFrame[1].quat.w * this.keyFrame[2].quat.w;
            if (d < 0.0) {
                quat4f.x = this.keyFrame[1].quat.x + (-this.keyFrame[2].quat.x - this.keyFrame[1].quat.x) * f;
                quat4f.y = this.keyFrame[1].quat.y + (-this.keyFrame[2].quat.y - this.keyFrame[1].quat.y) * f;
                quat4f.z = this.keyFrame[1].quat.z + (-this.keyFrame[2].quat.z - this.keyFrame[1].quat.z) * f;
                quat4f.w = this.keyFrame[1].quat.w + (-this.keyFrame[2].quat.w - this.keyFrame[1].quat.w) * f;
            } else {
                quat4f.x = this.keyFrame[1].quat.x + (this.keyFrame[2].quat.x - this.keyFrame[1].quat.x) * f;
                quat4f.y = this.keyFrame[1].quat.y + (this.keyFrame[2].quat.y - this.keyFrame[1].quat.y) * f;
                quat4f.z = this.keyFrame[1].quat.z + (this.keyFrame[2].quat.z - this.keyFrame[1].quat.z) * f;
                quat4f.w = this.keyFrame[1].quat.w + (this.keyFrame[2].quat.w - this.keyFrame[1].quat.w) * f;
            }
        } else {
            quat4f.interpolate(this.keyFrame[1].quat, this.keyFrame[2].quat, f);
        }
    }

    public void getInterpolatedScale(float f, Point3f point3f) {
        if (this.linear == 1) {
            point3f.x = this.keyFrame[1].scale.x + (this.keyFrame[2].scale.x - this.keyFrame[1].scale.x) * f;
            point3f.y = this.keyFrame[1].scale.y + (this.keyFrame[2].scale.y - this.keyFrame[1].scale.y) * f;
            point3f.z = this.keyFrame[1].scale.z + (this.keyFrame[2].scale.z - this.keyFrame[1].scale.z) * f;
        } else {
            point3f.x = this.e0.x + f * (this.e1.x + f * (this.e2.x + f * this.e3.x));
            point3f.y = this.e0.y + f * (this.e1.y + f * (this.e2.y + f * this.e3.y));
            point3f.z = this.e0.z + f * (this.e1.z + f * (this.e2.z + f * this.e3.z));
        }
    }

    public void getInterpolatedPosition(float f, Point3f point3f) {
        if (this.linear == 1) {
            point3f.x = this.keyFrame[1].position.x + (this.keyFrame[2].position.x - this.keyFrame[1].position.x) * f;
            point3f.y = this.keyFrame[1].position.y + (this.keyFrame[2].position.y - this.keyFrame[1].position.y) * f;
            point3f.z = this.keyFrame[1].position.z + (this.keyFrame[2].position.z - this.keyFrame[1].position.z) * f;
        } else {
            point3f.x = this.c0.x + f * (this.c1.x + f * (this.c2.x + f * this.c3.x));
            point3f.y = this.c0.y + f * (this.c1.y + f * (this.c2.y + f * this.c3.y));
            point3f.z = this.c0.z + f * (this.c1.z + f * (this.c2.z + f * this.c3.z));
        }
    }

    public void getInterpolatedPositionVector(float f, Vector3f vector3f) {
        if (this.linear == 1) {
            vector3f.x = this.keyFrame[1].position.x + (this.keyFrame[2].position.x - this.keyFrame[1].position.x) * f;
            vector3f.y = this.keyFrame[1].position.y + (this.keyFrame[2].position.y - this.keyFrame[1].position.y) * f;
            vector3f.z = this.keyFrame[1].position.z + (this.keyFrame[2].position.z - this.keyFrame[1].position.z) * f;
        } else {
            vector3f.x = this.c0.x + f * (this.c1.x + f * (this.c2.x + f * this.c3.x));
            vector3f.y = this.c0.y + f * (this.c1.y + f * (this.c2.y + f * this.c3.y));
            vector3f.z = this.c0.z + f * (this.c1.z + f * (this.c2.z + f * this.c3.z));
        }
    }

    public float getInterpolatedValue(float f) {
        return this.computeLength(f) / this.length;
    }
}

