import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import {
  DescribeStackResourceDriftsInput,
  DescribeStackResourceDriftsOutput,
} from "../models/models_0";
export { __MetadataBearer, $Command };
export interface DescribeStackResourceDriftsCommandInput
  extends DescribeStackResourceDriftsInput {}
export interface DescribeStackResourceDriftsCommandOutput
  extends DescribeStackResourceDriftsOutput,
    __MetadataBearer {}
export declare class DescribeStackResourceDriftsCommand extends $Command<
  DescribeStackResourceDriftsCommandInput,
  DescribeStackResourceDriftsCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: DescribeStackResourceDriftsCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeStackResourceDriftsCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeStackResourceDriftsCommandInput,
    DescribeStackResourceDriftsCommandOutput
  >;
  private serialize;
  private deserialize;
}
