complete -c sq -n "__fish_use_subcommand" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_use_subcommand" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_use_subcommand" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_use_subcommand" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_use_subcommand" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_use_subcommand" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_use_subcommand" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_use_subcommand" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_use_subcommand" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_use_subcommand" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_use_subcommand" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_use_subcommand" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_use_subcommand" -f -a "encrypt" -d 'Encrypts a message'
complete -c sq -n "__fish_use_subcommand" -f -a "decrypt" -d 'Decrypts a message'
complete -c sq -n "__fish_use_subcommand" -f -a "sign" -d 'Signs messages or data files'
complete -c sq -n "__fish_use_subcommand" -f -a "verify" -d 'Verifies signed messages or detached signatures'
complete -c sq -n "__fish_use_subcommand" -f -a "inspect" -d 'Inspects data, like file(1)'
complete -c sq -n "__fish_use_subcommand" -f -a "cert" -d 'Manages certificates'
complete -c sq -n "__fish_use_subcommand" -f -a "key" -d 'Manages keys'
complete -c sq -n "__fish_use_subcommand" -f -a "keyring" -d 'Manages collections of keys or certs'
complete -c sq -n "__fish_use_subcommand" -f -a "pki" -d 'Authenticate certs using the Web of Trust'
complete -c sq -n "__fish_use_subcommand" -f -a "autocrypt" -d 'Communicates certificates using Autocrypt'
complete -c sq -n "__fish_use_subcommand" -f -a "network" -d 'Retrieves and publishes certificates over the network'
complete -c sq -n "__fish_use_subcommand" -f -a "toolbox" -d 'Tools for developers, maintainers, and forensic specialists'
complete -c sq -n "__fish_use_subcommand" -f -a "version" -d 'Detailed version and output version information'
complete -c sq -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l recipient-email -d 'Encrypts to all certificates that can be authenticated for the specified email address' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l recipient-userid -d 'Encrypts to all certificates that can be authenticated for the specified User ID' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l recipient-cert -d 'Encrypts to the named certificates' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l recipient-file -d 'Encrypts to all certificates in CERT_RING_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l set-metadata-time -d 'Sets time for encrypted file as metadata' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l signer-file -d 'Signs the message using the key in KEY_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l private-key-store -d 'Provides parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l encrypt-for -d 'Selects what kind of keys are considered for encryption.' -r -f -a "{transport	'Protects data in transport',storage	'Protects data at rest',universal	'Protects data in transport and at rest'}"
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l compression -d 'Selects compression scheme to use' -r -f -a "{none	'',zip	'',zlib	'',bzip2	''}"
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l set-metadata-filename -d 'Sets the filename of the encrypted file as metadata'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s s -l symmetric -d 'Prompts to add a password to encrypt with'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l use-expired-subkey -d 'Falls back to expired encryption subkeys'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from encrypt" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s n -l signatures -d 'Sets the threshold of valid signatures to N' -r
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l signer-file -d 'Verifies signatures using the certificates in CERT_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l recipient-file -d 'Decrypts the message using the key in KEY_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l private-key-store -d 'Provides parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l session-key -d 'Decrypts an encrypted message using SESSION-KEY' -r
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l dump-session-key -d 'Prints the session key to stderr'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l dump -d 'Prints a packet dump to stderr'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s x -l hex -d 'Prints a hexdump (implies `--dump`)'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from decrypt" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from sign" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from sign" -l private-key-store -d 'Provides parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from sign" -l merge -d 'Merges signatures from the input and SIGNED-MESSAGE' -r -F
complete -c sq -n "__fish_seen_subcommand_from sign" -l signer-file -d 'Signs the message using the key in KEY_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from sign" -l notation -d 'Adds a notation to the certification.' -r
complete -c sq -n "__fish_seen_subcommand_from sign" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from sign" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from sign" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from sign" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from sign" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from sign" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from sign" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from sign" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from sign" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from sign" -l detached -d 'Creates a detached signature'
complete -c sq -n "__fish_seen_subcommand_from sign" -l cleartext-signature -d 'Creates a cleartext signature'
complete -c sq -n "__fish_seen_subcommand_from sign" -s a -l append -d 'Appends a signature to existing signature'
complete -c sq -n "__fish_seen_subcommand_from sign" -s n -l notarize -d 'Signs a message and all existing signatures'
complete -c sq -n "__fish_seen_subcommand_from sign" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from sign" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from sign" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from sign" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from verify" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from verify" -l detached -d 'Verifies a detached signature' -r -F
complete -c sq -n "__fish_seen_subcommand_from verify" -s n -l signatures -d 'Sets the threshold of valid signatures to N' -r
complete -c sq -n "__fish_seen_subcommand_from verify" -l signer-file -d 'Verifies signatures using the certificate in CERT_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from verify" -l signer-cert -d 'Verifies signatures using the specified certificate' -r
complete -c sq -n "__fish_seen_subcommand_from verify" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from verify" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from verify" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from verify" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from verify" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from verify" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from verify" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from verify" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from verify" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from verify" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from verify" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from verify" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from inspect" -l cert -d 'Reads the specified certificate from the certificate store' -r
complete -c sq -n "__fish_seen_subcommand_from inspect" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from inspect" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from inspect" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from inspect" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from inspect" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from inspect" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from inspect" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from inspect" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from inspect" -l certifications -d 'Prints third-party certifications'
complete -c sq -n "__fish_seen_subcommand_from inspect" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from inspect" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from inspect" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from inspect" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -f -a "import" -d 'Imports certificates into the local certificate store'
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -f -a "export" -d 'Exports certificates from the local certificate store'
complete -c sq -n "__fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from import" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l cert -d 'Returns certificates that have the specified fingerprint or key ID' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l key -d 'Returns certificates where the primary key or a subkey has the specified fingerprint or key ID' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l userid -d 'Returns certificates that have a User ID that matches exactly, including case' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l grep -d 'Returns certificates that have a User ID that contains the string, case insensitively' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l email -d 'Returns certificates that have a User ID with the specified email address, case insensitively' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l domain -d 'Returns certificates that have a User ID with an email address from the specified domain' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from export" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -f -a "import" -d 'Imports certificates into the local certificate store'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -f -a "export" -d 'Exports certificates from the local certificate store'
complete -c sq -n "__fish_seen_subcommand_from cert; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generates a new key'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "password" -d 'Changes password protecting secrets'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "revoke" -d 'Revoke a certificate'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "userid" -d 'Manages User IDs'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "subkey" -d 'Manages Subkeys'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "extract-cert" -d 'Converts a key to a cert'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "attest-certifications" -d 'Attests to third-party certifications'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "adopt" -d 'Binds keys from one certificate to another'
complete -c sq -n "__fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -s u -l userid -d 'Adds a userid to the key' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -s c -l cipher-suite -d 'Selects the cryptographic algorithms for the key' -r -f -a "{rsa3k	'',rsa4k	'',cv25519	''}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l expiry -d 'Defines EXPIRY for the key as ISO 8601 formatted string or custom duration.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l can-encrypt -d 'Adds an encryption-capable subkey [default: universal]' -r -f -a "{transport	'Protects data in transport',storage	'Protects data at rest',universal	'Protects data in transport and at rest'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l rev-cert -d 'Writes the revocation certificate to FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l with-password -d 'Protects the key with a password'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l can-sign -d 'Adds a signing-capable subkey (default)'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l cannot-sign -d 'Adds no signing-capable subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l can-authenticate -d 'Adds an authentication-capable subkey (default)'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l cannot-authenticate -d 'Adds no authentication-capable subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l cannot-encrypt -d 'Adds no encryption-capable subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from generate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l old-password-file -d 'File containing password to decrypt key' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l new-password-file -d 'File containing password to encrypt key' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l clear -d 'Emit a key with unencrypted secrets'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from password" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l certificate-file -d 'The certificate to revoke' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l revocation-file -d 'Signs the revocation certificate using the key in KEY_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l private-key-store -d 'Provides parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l notation -d 'Adds a notation to the certification.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from revoke" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Adds a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -f -a "revoke" -d 'Revoke a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -f -a "strip" -d 'Strips a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l private-key-store -d 'Provides parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l certificate-file -d 'The certificate containing the User ID to revoke' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l revocation-file -d 'Signs the revocation certificate using the key in KEY_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l private-key-store -d 'Provides parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l notation -d 'Adds a notation to the certification.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from revoke" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -s u -l userid -d 'User IDs to strip' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from strip" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Adds a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -f -a "revoke" -d 'Revoke a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -f -a "strip" -d 'Strips a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Adds a newly generated Subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -f -a "revoke" -d 'Revoke a subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l private-key-store -d 'Provides parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -s c -l cipher-suite -d 'Selects the cryptographic algorithms for the subkey' -r -f -a "{rsa3k	'',rsa4k	'',cv25519	''}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l expiry -d 'Defines EXPIRY for the subkey as ISO 8601 formatted string or custom duration.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l can-encrypt -d 'Adds an encryption capability to subkey [default: universal]' -r -f -a "{transport	'Protects data in transport',storage	'Protects data at rest',universal	'Protects data in transport and at rest'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l can-sign -d 'Adds signing capability to subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l can-authenticate -d 'Adds authentication capability to subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l with-password -d 'Protects the subkey with a password'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l certificate-file -d 'The certificate containing the subkey to revoke' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l revocation-file -d 'Signs the revocation certificate using the key in KEY_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l private-key-store -d 'Provides parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l notation -d 'Adds a notation to the certification.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from revoke" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Adds a newly generated Subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -f -a "revoke" -d 'Revoke a subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from extract-cert" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from extract-cert" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from extract-cert" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from extract-cert" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from extract-cert" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from extract-cert" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from extract-cert" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from extract-cert" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from extract-cert" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from extract-cert" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from extract-cert" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from extract-cert" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from extract-cert" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from extract-cert" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l none -d 'Removes all prior attestations'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l all -d 'Attests to all certifications [default]'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from attest-certifications" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -s k -l key -d 'Adds the key or subkey KEY to the TARGET-KEY' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l expire -d 'Makes adopted subkeys expire at the given time' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l allow-broken-crypto -d 'Allows adopting keys from certificates using broken cryptography'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from adopt" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generates a new key'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "password" -d 'Changes password protecting secrets'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "revoke" -d 'Revoke a certificate'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "userid" -d 'Manages User IDs'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "subkey" -d 'Manages Subkeys'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "extract-cert" -d 'Converts a key to a cert'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "attest-certifications" -d 'Attests to third-party certifications'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "adopt" -d 'Binds keys from one certificate to another'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip" -f -a "add" -d 'Adds a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip" -f -a "revoke" -d 'Revoke a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip" -f -a "strip" -d 'Strips a User ID'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke" -f -a "add" -d 'Adds a newly generated Subkey'
complete -c sq -n "__fish_seen_subcommand_from key; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke" -f -a "revoke" -d 'Revoke a subkey'
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "list" -d 'Lists keys in a keyring'
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "split" -d 'Splits a keyring into individual keys'
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "merge" -d 'Merges keys or keyrings into a single keyring'
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "filter" -d 'Joins keys into a keyring applying a filter'
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "lint" -d 'Checks certificates for issues'
complete -c sq -n "__fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l all-userids -d 'Lists all user ids'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -s p -l prefix -d 'Writes to files with PREFIX [defaults: `FILE-` if FILE is set, or `output-` if read from stdin]' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from split" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from merge" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l userid -d 'Matches on USERID' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l name -d 'Matches on NAME' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l email -d 'Matches on email ADDRESS' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l domain -d 'Matches on email domain FQDN' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l handle -d 'Matches on (sub)key fingerprints and key ids' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -s P -l prune-certs -d 'Removes certificate components not matching the filter'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l to-cert -d 'Converts any keys in the input to certificates.  Converting a key to a certificate removes secret key material from the key thereby turning it into a certificate.'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from filter" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -s p -l password -d 'A key\'s password.  Normally this is not needed: if stdin is connected to a tty, the linter will ask for a password when needed' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -s q -l quiet -d 'Quiet; does not output any diagnostics'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -s F -l fix -d 'Attempts to fix certificates, when possible'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -s e -l export-secret-keys -d 'When fixing a certificate, the fixed certificate is exported without any secret key material.  Using this switch causes any secret key material to also be exported'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -s k -l list-keys -d 'If set, outputs a list of fingerprints, one per line, of certificates that have issues.  This output is intended for use by scripts'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from lint" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "list" -d 'Lists keys in a keyring'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "split" -d 'Splits a keyring into individual keys'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "merge" -d 'Merges keys or keyrings into a single keyring'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "filter" -d 'Joins keys into a keyring applying a filter'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "lint" -d 'Checks certificates for issues'
complete -c sq -n "__fish_seen_subcommand_from keyring; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "authenticate" -d 'Authenticate a binding'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "lookup" -d 'Lookup the certificates associated with a User ID'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "identify" -d 'Identify a certificate'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "certify" -d 'Certifies a User ID for a Certificate'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "link" -d 'Manages authenticated certificate and User ID links'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all authenticated bindings (User ID and certificate pairs)'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "path" -d 'Verify the specified path'
complete -c sq -n "__fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -s a -l amount -d 'The required amount of trust' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l email -d 'Changes the USERID parameter to match User IDs with the specified email address'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l gossip -d 'Treats all certificates as unreliable trust roots'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l certification-network -d 'Treats the network as a certification network'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from authenticate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -s a -l amount -d 'The required amount of trust' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l email -d 'Changes the USERID parameter to match User IDs with the specified email address'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l gossip -d 'Treats all certificates as unreliable trust roots'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l certification-network -d 'Treats the network as a certification network'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from lookup" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -s a -l amount -d 'The required amount of trust' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l gossip -d 'Treats all certificates as unreliable trust roots'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l certification-network -d 'Treats the network as a certification network'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from identify" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s d -l depth -d 'Sets the trust depth' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s a -l amount -d 'Sets the amount of trust' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s r -l regex -d 'Adds a regular expression to constrain what a trusted introducer can certify' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l notation -d 'Adds a notation to the certification.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l expiry -d 'Defines EXPIRY for the certification as ISO 8601 formatted string or custom duration.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l private-key-store -d 'Provides parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s l -l local -d 'Makes the certification a local certification'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l non-revocable -d 'Marks the certification as being non-revocable'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l email -d 'Treat the given user ID as an email address.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l add-userid -d 'Add the given user ID if it doesn\'t exist.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l allow-not-alive-certifier -d 'Don\'t fail if the certificate making the certification is not alive.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l allow-revoked-certifier -d 'Don\'t fail if the certificate making the certification is revoked.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from certify" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Link a certificate and a User ID'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "retract" -d 'Retracts links'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "list" -d 'Lists links'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -s d -l depth -d 'Sets the trust depth' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l ca -d 'Marks the certificate as a certification authority for a domain' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -s a -l amount -d 'Sets the amount of trust' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -s r -l regex -d 'Adds a regular expression to constrain what a trusted introducer can certify' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l notation -d 'Adds a notation to the certification.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l expiry -d 'Defines EXPIRY for the acceptance as ISO 8601 formatted string or custom duration.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l userid -d 'A User ID to link to the certificate.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l email -d 'An email address to link to the certificate.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l petname -d 'A User ID to link to the certificate.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l temporary -d 'Temporarily accepts the binding'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l all -d 'Links all valid self-signed User ID to the certificate.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l notation -d 'Adds a notation to the certification.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l userid -d 'A User ID to unlink from the certificate.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l email -d 'An email address to unlink from the certificate.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from retract" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l ca -d 'Only lists bindings linked as CAs.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "add" -d 'Link a certificate and a User ID'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "retract" -d 'Retracts links'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "list" -d 'Lists links'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -s a -l amount -d 'The required amount of trust' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l email -d 'Changes the USERID parameter to match User IDs with the specified email address'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l gossip -d 'Treats all certificates as unreliable trust roots'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l certification-network -d 'Treats the network as a certification network'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -s a -l amount -d 'The required amount of trust' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l gossip -d 'Treats all certificates as unreliable trust roots'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l certification-network -d 'Treats the network as a certification network'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from path" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "authenticate" -d 'Authenticate a binding'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "lookup" -d 'Lookup the certificates associated with a User ID'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "identify" -d 'Identify a certificate'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "certify" -d 'Certifies a User ID for a Certificate'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "link" -d 'Manages authenticated certificate and User ID links'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all authenticated bindings (User ID and certificate pairs)'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "path" -d 'Verify the specified path'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list" -f -a "add" -d 'Link a certificate and a User ID'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list" -f -a "retract" -d 'Retracts links'
complete -c sq -n "__fish_seen_subcommand_from pki; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list" -f -a "list" -d 'Lists links'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -f -a "import" -d 'Imports Autocrypt-encoded certificates'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -f -a "decode" -d 'Reads Autocrypt-encoded certificates'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -f -a "encode-sender" -d 'Encodes a certificate into an Autocrypt header'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from import" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from decode" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l email -d 'Sets the address [default: primary userid]' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l prefer-encrypt -d 'Sets the prefer-encrypt attribute' -r -f -a "{nopreference	'',mutual	''}"
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from encode-sender" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -f -a "import" -d 'Imports Autocrypt-encoded certificates'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -f -a "decode" -d 'Reads Autocrypt-encoded certificates'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -f -a "encode-sender" -d 'Encodes a certificate into an Autocrypt header'
complete -c sq -n "__fish_seen_subcommand_from autocrypt; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Retrieves certificates using all supported network services'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "keyserver" -d 'Retrieves and publishes certificates via key servers'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "wkd" -d 'Retrieves and publishes certificates via Web Key Directories'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "dane" -d 'Retrieves and publishes certificates via DANE'
complete -c sq -n "__fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -s s -l server -d 'Sets the key server to use.  Can be given multiple times.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -s o -l output -d 'Writes to FILE (or stdout when omitted) instead of importing into the certificate store' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from fetch" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -s s -l server -d 'Sets the key server to use.  Can be given multiple times.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Retrieves certificates from key servers'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -f -a "publish" -d 'Publishes certificates on key servers'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -s o -l output -d 'Writes to FILE (or stdout when omitted) instead of importing into the certificate store' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -s s -l server -d 'Sets the key server to use.  Can be given multiple times.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from fetch" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -s s -l server -d 'Sets the key server to use.  Can be given multiple times.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l require-all -d 'Requires that all publish operations succeed and return an error otherwise.  By default we only require that one publish operation succeeds.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from publish" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Retrieves certificates from key servers'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -f -a "publish" -d 'Publishes certificates on key servers'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generates a Web Key Directory for the given domain and certs'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Retrieves certificates from a Web Key Directory'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "direct-url" -d 'Prints the direct Web Key Directory URL of an email address'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "url" -d 'Prints the advanced Web Key Directory URL of an email address'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -s d -l direct-method -d 'Uses the direct method [default: advanced method]'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -s s -l skip -d 'Skips certificates that do not have User IDs for given domain.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from generate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -s o -l output -d 'Writes to FILE (or stdout when omitted) instead of importing into the certificate store' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from fetch" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from direct-url" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from url" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generates a Web Key Directory for the given domain and certs'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Retrieves certificates from a Web Key Directory'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "direct-url" -d 'Prints the direct Web Key Directory URL of an email address'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "url" -d 'Prints the advanced Web Key Directory URL of an email address'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generates DANE records for the given domain and certs'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Retrieves certificates using DANE'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l ttl -d 'Sets the TTL (maximum cache duration) of the resource records' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l size-limit -d 'Try to shrink the certificates to this size' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l generic -d 'Emits generic resource records [default: OPENPGPKEY records]'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -s s -l skip -d 'Skips expired certificates and those that do not have User IDs for given domain.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from generate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -s o -l output -d 'Writes to FILE (or stdout when omitted) instead of importing into the certificate store' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from fetch" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -f -a "generate" -d 'Generates DANE records for the given domain and certs'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Retrieves certificates using DANE'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Retrieves certificates using all supported network services'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "keyserver" -d 'Retrieves and publishes certificates via key servers'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "wkd" -d 'Retrieves and publishes certificates via Web Key Directories'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "dane" -d 'Retrieves and publishes certificates via DANE'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish" -f -a "fetch" -d 'Retrieves certificates from key servers'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish" -f -a "publish" -d 'Publishes certificates on key servers'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url" -f -a "generate" -d 'Generates a Web Key Directory for the given domain and certs'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url" -f -a "fetch" -d 'Retrieves certificates from a Web Key Directory'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url" -f -a "direct-url" -d 'Prints the direct Web Key Directory URL of an email address'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url" -f -a "url" -d 'Prints the advanced Web Key Directory URL of an email address'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch" -f -a "generate" -d 'Generates DANE records for the given domain and certs'
complete -c sq -n "__fish_seen_subcommand_from network; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch" -f -a "fetch" -d 'Retrieves certificates using DANE'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "packet" -d 'Low-level packet manipulation'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "armor" -d 'Converts binary to ASCII'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "dearmor" -d 'Converts ASCII to binary'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "dump" -d 'Lists packets'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "decrypt" -d 'Unwraps an encryption container'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "split" -d 'Splits a message into packets'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "join" -d 'Joins packets split across files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l session-key -d 'Decrypts an encrypted message using SESSION-KEY' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l mpis -d 'Prints cryptographic artifacts'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -s x -l hex -d 'Prints a hexdump'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from dump" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l recipient-file -d 'Decrypts the message using the key in KEY_FILE' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l private-key-store -d 'Provides parameters for private key store' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l session-key -d 'Decrypts an encrypted message using SESSION-KEY' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l dump-session-key -d 'Prints the session key to stderr'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from decrypt" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -s p -l prefix -d 'Writes to files with PREFIX [defaults: `FILE-` if FILE is set, or `output-` if read from stdin]' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from split" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l label -d 'Selects the kind of armor header' -r -f -a "{auto	'',message	'',cert	'',key	'',sig	'',file	''}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -s B -l binary -d 'Emits binary data'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from join" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "dump" -d 'Lists packets'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "decrypt" -d 'Unwraps an encryption container'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "split" -d 'Splits a message into packets'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "join" -d 'Joins packets split across files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l label -d 'Selects the kind of armor header' -r -f -a "{auto	'',message	'',cert	'',key	'',sig	'',file	''}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from armor" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -s o -l output -d 'Writes to FILE or stdout if omitted' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from dearmor" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "packet" -d 'Low-level packet manipulation'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "armor" -d 'Converts binary to ASCII'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "dearmor" -d 'Converts ASCII to binary'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join" -f -a "dump" -d 'Lists packets'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join" -f -a "decrypt" -d 'Unwraps an encryption container'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join" -f -a "split" -d 'Splits a message into packets'
complete -c sq -n "__fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join" -f -a "join" -d 'Joins packets split across files'
complete -c sq -n "__fish_seen_subcommand_from version" -l cert-store -d 'Specifies the location of the certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from version" -l pep-cert-store -d 'Specifies the location of a pEp certificate store' -r -F
complete -c sq -n "__fish_seen_subcommand_from version" -l keyring -d 'Specifies the location of a keyring to use' -r -F
complete -c sq -n "__fish_seen_subcommand_from version" -l output-format -d 'Produces output in FORMAT, if possible' -r -f -a "{human-readable	'Output that is meant to be read by humans, instead of programs',json	'Output as JSON',dot	'Output as DOT'}"
complete -c sq -n "__fish_seen_subcommand_from version" -l output-version -d 'Produces output variant VERSION.' -r
complete -c sq -n "__fish_seen_subcommand_from version" -l known-notation -d 'Adds NOTATION to the list of known notations' -r
complete -c sq -n "__fish_seen_subcommand_from version" -l time -d 'Sets the reference time as ISO 8601 formatted timestamp' -r
complete -c sq -n "__fish_seen_subcommand_from version" -l trust-root -d 'Considers the specified certificate to be a trust root' -r
complete -c sq -n "__fish_seen_subcommand_from version" -l default-output-version -d 'List the default output version'
complete -c sq -n "__fish_seen_subcommand_from version" -l output-versions -d 'List all the supported output versions'
complete -c sq -n "__fish_seen_subcommand_from version" -s f -l force -d 'Overwrites existing files'
complete -c sq -n "__fish_seen_subcommand_from version" -l no-cert-store -d 'Disables the use of a certificate store'
complete -c sq -n "__fish_seen_subcommand_from version" -s v -l verbose -d 'Be more verbose.'
complete -c sq -n "__fish_seen_subcommand_from version" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "encrypt" -d 'Encrypts a message'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "decrypt" -d 'Decrypts a message'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "sign" -d 'Signs messages or data files'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Verifies signed messages or detached signatures'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "inspect" -d 'Inspects data, like file(1)'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "cert" -d 'Manages certificates'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "key" -d 'Manages keys'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "keyring" -d 'Manages collections of keys or certs'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "pki" -d 'Authenticate certs using the Web of Trust'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "autocrypt" -d 'Communicates certificates using Autocrypt'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "network" -d 'Retrieves and publishes certificates over the network'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "toolbox" -d 'Tools for developers, maintainers, and forensic specialists'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "version" -d 'Detailed version and output version information'
complete -c sq -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from encrypt; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from sign; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from inspect; and not __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from version; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export" -f -a "import" -d 'Imports certificates into the local certificate store'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from cert; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from export" -f -a "export" -d 'Exports certificates from the local certificate store'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "generate" -d 'Generates a new key'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "password" -d 'Changes password protecting secrets'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "revoke" -d 'Revoke a certificate'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "userid" -d 'Manages User IDs'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "subkey" -d 'Manages Subkeys'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "extract-cert" -d 'Converts a key to a cert'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "attest-certifications" -d 'Attests to third-party certifications'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from password; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from extract-cert; and not __fish_seen_subcommand_from attest-certifications; and not __fish_seen_subcommand_from adopt" -f -a "adopt" -d 'Binds keys from one certificate to another'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip" -f -a "add" -d 'Adds a User ID'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip" -f -a "revoke" -d 'Revoke a User ID'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and __fish_seen_subcommand_from userid; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke; and not __fish_seen_subcommand_from strip" -f -a "strip" -d 'Strips a User ID'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke" -f -a "add" -d 'Adds a newly generated Subkey'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from key; and __fish_seen_subcommand_from subkey; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from revoke" -f -a "revoke" -d 'Revoke a subkey'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint" -f -a "list" -d 'Lists keys in a keyring'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint" -f -a "split" -d 'Splits a keyring into individual keys'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint" -f -a "merge" -d 'Merges keys or keyrings into a single keyring'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint" -f -a "filter" -d 'Joins keys into a keyring applying a filter'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from keyring; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from merge; and not __fish_seen_subcommand_from filter; and not __fish_seen_subcommand_from lint" -f -a "lint" -d 'Checks certificates for issues'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path" -f -a "authenticate" -d 'Authenticate a binding'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path" -f -a "lookup" -d 'Lookup the certificates associated with a User ID'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path" -f -a "identify" -d 'Identify a certificate'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path" -f -a "certify" -d 'Certifies a User ID for a Certificate'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path" -f -a "link" -d 'Manages authenticated certificate and User ID links'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path" -f -a "list" -d 'List all authenticated bindings (User ID and certificate pairs)'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and not __fish_seen_subcommand_from authenticate; and not __fish_seen_subcommand_from lookup; and not __fish_seen_subcommand_from identify; and not __fish_seen_subcommand_from certify; and not __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from path" -f -a "path" -d 'Verify the specified path'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list" -f -a "add" -d 'Link a certificate and a User ID'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list" -f -a "retract" -d 'Retracts links'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from pki; and __fish_seen_subcommand_from link; and not __fish_seen_subcommand_from add; and not __fish_seen_subcommand_from retract; and not __fish_seen_subcommand_from list" -f -a "list" -d 'Lists links'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender" -f -a "import" -d 'Imports Autocrypt-encoded certificates'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender" -f -a "decode" -d 'Reads Autocrypt-encoded certificates'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from autocrypt; and not __fish_seen_subcommand_from import; and not __fish_seen_subcommand_from decode; and not __fish_seen_subcommand_from encode-sender" -f -a "encode-sender" -d 'Encodes a certificate into an Autocrypt header'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane" -f -a "fetch" -d 'Retrieves certificates using all supported network services'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane" -f -a "keyserver" -d 'Retrieves and publishes certificates via key servers'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane" -f -a "wkd" -d 'Retrieves and publishes certificates via Web Key Directories'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from dane" -f -a "dane" -d 'Retrieves and publishes certificates via DANE'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish" -f -a "fetch" -d 'Retrieves certificates from key servers'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and __fish_seen_subcommand_from keyserver; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from publish" -f -a "publish" -d 'Publishes certificates on key servers'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url" -f -a "generate" -d 'Generates a Web Key Directory for the given domain and certs'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url" -f -a "fetch" -d 'Retrieves certificates from a Web Key Directory'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url" -f -a "direct-url" -d 'Prints the direct Web Key Directory URL of an email address'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and __fish_seen_subcommand_from wkd; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from direct-url; and not __fish_seen_subcommand_from url" -f -a "url" -d 'Prints the advanced Web Key Directory URL of an email address'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch" -f -a "generate" -d 'Generates DANE records for the given domain and certs'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from network; and __fish_seen_subcommand_from dane; and not __fish_seen_subcommand_from generate; and not __fish_seen_subcommand_from fetch" -f -a "fetch" -d 'Retrieves certificates using DANE'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor" -f -a "packet" -d 'Low-level packet manipulation'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor" -f -a "armor" -d 'Converts binary to ASCII'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and not __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from armor; and not __fish_seen_subcommand_from dearmor" -f -a "dearmor" -d 'Converts ASCII to binary'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join" -f -a "dump" -d 'Lists packets'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join" -f -a "decrypt" -d 'Unwraps an encryption container'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join" -f -a "split" -d 'Splits a message into packets'
complete -c sq -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from toolbox; and __fish_seen_subcommand_from packet; and not __fish_seen_subcommand_from dump; and not __fish_seen_subcommand_from decrypt; and not __fish_seen_subcommand_from split; and not __fish_seen_subcommand_from join" -f -a "join" -d 'Joins packets split across files'
