# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
TopExp module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_topexp.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _TopExp
else:
    import _TopExp

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _TopExp.delete_SwigPyIterator

    def value(self):
        return _TopExp.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _TopExp.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _TopExp.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _TopExp.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _TopExp.SwigPyIterator_equal(self, x)

    def copy(self):
        return _TopExp.SwigPyIterator_copy(self)

    def next(self):
        return _TopExp.SwigPyIterator_next(self)

    def __next__(self):
        return _TopExp.SwigPyIterator___next__(self)

    def previous(self):
        return _TopExp.SwigPyIterator_previous(self)

    def advance(self, n):
        return _TopExp.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _TopExp.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _TopExp.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _TopExp.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _TopExp.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _TopExp.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _TopExp.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _TopExp:
_TopExp.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _TopExp.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.TopoDS
import OCC.Core.Message
import OCC.Core.TCollection
import OCC.Core.OSD
import OCC.Core.TColStd
import OCC.Core.TopAbs
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.TopTools

from enum import IntEnum
from OCC.Core.Exception import *



class topexp(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def CommonVertex(*args):
        r"""

        Parameters
        ----------
        E1: TopoDS_Edge
        E2: TopoDS_Edge
        V: TopoDS_Vertex

        Return
        -------
        bool

        Description
        -----------
        Finds the vertex <v> common to the two edges <e1,e2>, returns true if this vertex exists. //! warning: <v> has sense only if the value <true> is returned.

        """
        return _TopExp.topexp_CommonVertex(*args)

    @staticmethod
    def FirstVertex(*args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge
        CumOri: bool (optional, default to Standard_False)

        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        Returns the vertex of orientation forward in e. if there is none returns a null shape. cumori = true: taking account the edge orientation.

        """
        return _TopExp.topexp_FirstVertex(*args)

    @staticmethod
    def LastVertex(*args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge
        CumOri: bool (optional, default to Standard_False)

        Return
        -------
        TopoDS_Vertex

        Description
        -----------
        Returns the vertex of orientation reversed in e. if there is none returns a null shape. cumori = true: taking account the edge orientation.

        """
        return _TopExp.topexp_LastVertex(*args)

    @staticmethod
    def MapShapes(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        T: TopAbs_ShapeEnum
        M: TopTools_IndexedMapOfShape

        Return
        -------
        None

        Description
        -----------
        Tool to explore a topological data structure. stores in the map <m> all the sub-shapes of <s> of type <t>. //! warning: the map is not cleared at first.

        Parameters
        ----------
        S: TopoDS_Shape
        M: TopTools_IndexedMapOfShape
        cumOri: bool (optional, default to Standard_True)
        cumLoc: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Stores in the map <m> all the sub-shapes of <s>. - if cumori is true, the function composes all sub-shapes with the orientation of s. - if cumloc is true, the function multiplies all sub-shapes by the location of s, i.e. it applies to each sub-shape the transformation that is associated with s.

        Parameters
        ----------
        S: TopoDS_Shape
        M: TopTools_MapOfShape
        cumOri: bool (optional, default to Standard_True)
        cumLoc: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Stores in the map <m> all the sub-shapes of <s>. - if cumori is true, the function composes all sub-shapes with the orientation of s. - if cumloc is true, the function multiplies all sub-shapes by the location of s, i.e. it applies to each sub-shape the transformation that is associated with s.

        """
        return _TopExp.topexp_MapShapes(*args)

    @staticmethod
    def MapShapesAndAncestors(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        TS: TopAbs_ShapeEnum
        TA: TopAbs_ShapeEnum
        M: TopTools_IndexedDataMapOfShapeListOfShape

        Return
        -------
        None

        Description
        -----------
        Stores in the map <m> all the subshape of <s> of type <ts> for each one append to the list all the ancestors of type <ta>. for example map all the edges and bind the list of faces. warning: the map is not cleared at first.

        """
        return _TopExp.topexp_MapShapesAndAncestors(*args)

    @staticmethod
    def MapShapesAndUniqueAncestors(*args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        TS: TopAbs_ShapeEnum
        TA: TopAbs_ShapeEnum
        M: TopTools_IndexedDataMapOfShapeListOfShape
        useOrientation: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Stores in the map <m> all the subshape of <s> of type <ts> for each one append to the list all unique ancestors of type <ta>. for example map all the edges and bind the list of faces. useorientation = true: taking account the ancestor orientation warning: the map is not cleared at first.

        """
        return _TopExp.topexp_MapShapesAndUniqueAncestors(*args)

    @staticmethod
    def Vertices(*args):
        r"""

        Parameters
        ----------
        E: TopoDS_Edge
        Vfirst: TopoDS_Vertex
        Vlast: TopoDS_Vertex
        CumOri: bool (optional, default to Standard_False)

        Return
        -------
        None

        Description
        -----------
        Returns in vfirst, vlast the forward and reversed vertices of the edge <e>. may be null shapes. cumori = true: taking account the edge orientation.

        Parameters
        ----------
        W: TopoDS_Wire
        Vfirst: TopoDS_Vertex
        Vlast: TopoDS_Vertex

        Return
        -------
        None

        Description
        -----------
        Returns in vfirst, vlast the first and last vertices of the open wire <w>. may be null shapes. if <w> is closed vfirst and vlast are a same vertex on <w>. if <w> is no manifold. vfirst and vlast are null shapes.

        """
        return _TopExp.topexp_Vertices(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _TopExp.topexp_swiginit(self, _TopExp.new_topexp())
    __swig_destroy__ = _TopExp.delete_topexp

# Register topexp in _TopExp:
_TopExp.topexp_swigregister(topexp)
class TopExp_Explorer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Creates an empty explorer, becomes useful after init.

        Parameters
        ----------
        S: TopoDS_Shape
        ToFind: TopAbs_ShapeEnum
        ToAvoid: TopAbs_ShapeEnum (optional, default to TopAbs_SHAPE)

        Return
        -------
        None

        Description
        -----------
        Creates an explorer on the shape <s>. //! <tofind> is the type of shapes to search. topabs_vertex, topabs_edge, ... //! <toavoid> is the type of shape to skip in the exploration. if <toavoid> is equal or less complex than <tofind> or if <toavoid> is shape it has no effect on the exploration.

        """
        _TopExp.TopExp_Explorer_swiginit(self, _TopExp.new_TopExp_Explorer(*args))

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears the content of the explorer. it will return false on more().

        """
        return _TopExp.TopExp_Explorer_Clear(self, *args)

    def Current(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the current shape in the exploration. exceptions standard_nosuchobject if this explorer has no more shapes to explore.

        """
        return _TopExp.TopExp_Explorer_Current(self, *args)

    def Depth(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the current depth of the exploration. 0 is the shape to explore itself.

        """
        return _TopExp.TopExp_Explorer_Depth(self, *args)

    def ExploredShape(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Return explored shape.

        """
        return _TopExp.TopExp_Explorer_ExploredShape(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        S: TopoDS_Shape
        ToFind: TopAbs_ShapeEnum
        ToAvoid: TopAbs_ShapeEnum (optional, default to TopAbs_SHAPE)

        Return
        -------
        None

        Description
        -----------
        Resets this explorer on the shape s. it is initialized to search the shape s, for shapes of type tofind, that are not part of a shape toavoid. if the shape toavoid is equal to topabs_shape, or if it is the same as, or less complex than, the shape tofind it has no effect on the search.

        """
        return _TopExp.TopExp_Explorer_Init(self, *args)

    def More(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if there are more shapes in the exploration.

        """
        return _TopExp.TopExp_Explorer_More(self, *args)

    def Next(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Moves to the next shape in the exploration. exceptions standard_nomoreobject if there are no more shapes to explore.

        """
        return _TopExp.TopExp_Explorer_Next(self, *args)

    def ReInit(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Reinitialize the exploration with the original arguments.

        """
        return _TopExp.TopExp_Explorer_ReInit(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        TopoDS_Shape

        Description
        -----------
        Returns the current shape in the exploration. exceptions standard_nosuchobject if this explorer has no more shapes to explore.

        """
        return _TopExp.TopExp_Explorer_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _TopExp.delete_TopExp_Explorer

# Register TopExp_Explorer in _TopExp:
_TopExp.TopExp_Explorer_swigregister(TopExp_Explorer)



@deprecated
def topexp_CommonVertex(*args):
	return topexp.CommonVertex(*args)

@deprecated
def topexp_FirstVertex(*args):
	return topexp.FirstVertex(*args)

@deprecated
def topexp_LastVertex(*args):
	return topexp.LastVertex(*args)

@deprecated
def topexp_MapShapes(*args):
	return topexp.MapShapes(*args)

@deprecated
def topexp_MapShapes(*args):
	return topexp.MapShapes(*args)

@deprecated
def topexp_MapShapes(*args):
	return topexp.MapShapes(*args)

@deprecated
def topexp_MapShapesAndAncestors(*args):
	return topexp.MapShapesAndAncestors(*args)

@deprecated
def topexp_MapShapesAndUniqueAncestors(*args):
	return topexp.MapShapesAndUniqueAncestors(*args)

@deprecated
def topexp_Vertices(*args):
	return topexp.Vertices(*args)

@deprecated
def topexp_Vertices(*args):
	return topexp.Vertices(*args)



