from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.TDF import *
from OCC.Core.Quantity import *
from OCC.Core.AIS import *
from OCC.Core.Graphic3d import *
from OCC.Core.V3d import *
from OCC.Core.TDataXtd import *
from OCC.Core.TCollection import *


class TPrsStd_AISPresentation(TDF_Attribute):
    def __init__(self) -> None: ...
    def AddSelectionMode(self, theSelectionMode: int, theTransaction: Optional[bool] = True) -> None: ...
    def AfterAddition(self) -> None: ...
    def AfterResume(self) -> None: ...
    def AfterUndo(self, anAttDelta: TDF_AttributeDelta, forceIt: Optional[bool] = False) -> bool: ...
    def BackupCopy(self) -> TDF_Attribute: ...
    def BeforeForget(self) -> None: ...
    def BeforeRemoval(self) -> None: ...
    def BeforeUndo(self, anAttDelta: TDF_AttributeDelta, forceIt: Optional[bool] = False) -> bool: ...
    def Color(self) -> Quantity_NameOfColor: ...
    def Display(self, update: Optional[bool] = False) -> None: ...
    def Erase(self, remove: Optional[bool] = False) -> None: ...
    def GetAIS(self) -> AIS_InteractiveObject: ...
    def GetDriverGUID(self) -> Standard_GUID: ...
    @staticmethod
    def GetID() -> Standard_GUID: ...
    def GetNbSelectionModes(self) -> int: ...
    def HasOwnColor(self) -> bool: ...
    def HasOwnMaterial(self) -> bool: ...
    def HasOwnMode(self) -> bool: ...
    def HasOwnSelectionMode(self) -> bool: ...
    def HasOwnTransparency(self) -> bool: ...
    def HasOwnWidth(self) -> bool: ...
    def ID(self) -> Standard_GUID: ...
    def IsDisplayed(self) -> bool: ...
    def Material(self) -> Graphic3d_NameOfMaterial: ...
    def Mode(self) -> int: ...
    def NewEmpty(self) -> TDF_Attribute: ...
    def Paste(self, into: TDF_Attribute, RT: TDF_RelocationTable) -> None: ...
    def Restore(self, with_: TDF_Attribute) -> None: ...
    def SelectionMode(self, index: Optional[int] = 1) -> int: ...
    @overload
    @staticmethod
    def Set(L: TDF_Label, driver: Standard_GUID) -> TPrsStd_AISPresentation: ...
    @overload
    @staticmethod
    def Set(master: TDF_Attribute) -> TPrsStd_AISPresentation: ...
    def SetColor(self, aColor: Quantity_NameOfColor) -> None: ...
    def SetDisplayed(self, B: bool) -> None: ...
    def SetDriverGUID(self, guid: Standard_GUID) -> None: ...
    def SetMaterial(self, aName: Graphic3d_NameOfMaterial) -> None: ...
    def SetMode(self, theMode: int) -> None: ...
    def SetSelectionMode(self, theSelectionMode: int, theTransaction: Optional[bool] = True) -> None: ...
    def SetTransparency(self, aValue: Optional[float] = 0.6) -> None: ...
    def SetWidth(self, aWidth: float) -> None: ...
    def Transparency(self) -> float: ...
    @staticmethod
    def Unset(L: TDF_Label) -> None: ...
    def UnsetColor(self) -> None: ...
    def UnsetMaterial(self) -> None: ...
    def UnsetMode(self) -> None: ...
    def UnsetSelectionMode(self) -> None: ...
    def UnsetTransparency(self) -> None: ...
    def UnsetWidth(self) -> None: ...
    def Update(self) -> None: ...
    def Width(self) -> float: ...

class TPrsStd_AISViewer(TDF_Attribute):
    def __init__(self) -> None: ...
    @overload
    @staticmethod
    def Find(acces: TDF_Label, A: TPrsStd_AISViewer) -> bool: ...
    @overload
    @staticmethod
    def Find(acces: TDF_Label, IC: AIS_InteractiveContext) -> bool: ...
    @overload
    @staticmethod
    def Find(acces: TDF_Label, V: V3d_Viewer) -> bool: ...
    @staticmethod
    def GetID() -> Standard_GUID: ...
    def GetInteractiveContext(self) -> AIS_InteractiveContext: ...
    @staticmethod
    def Has(acces: TDF_Label) -> bool: ...
    def ID(self) -> Standard_GUID: ...
    @overload
    @staticmethod
    def New(access: TDF_Label, selector: AIS_InteractiveContext) -> TPrsStd_AISViewer: ...
    @overload
    @staticmethod
    def New(acces: TDF_Label, viewer: V3d_Viewer) -> TPrsStd_AISViewer: ...
    def NewEmpty(self) -> TDF_Attribute: ...
    def Paste(self, into: TDF_Attribute, RT: TDF_RelocationTable) -> None: ...
    def Restore(self, with_: TDF_Attribute) -> None: ...
    def SetInteractiveContext(self, ctx: AIS_InteractiveContext) -> None: ...
    @overload
    @staticmethod
    def Update(acces: TDF_Label) -> None: ...
    @overload
    def Update(self) -> None: ...

class TPrsStd_ConstraintTools:
    @staticmethod
    def ComputeAngle(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeAngleForOneFace(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeCoincident(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeConcentric(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeDiameter(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeDistance(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeEqualDistance(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeEqualRadius(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeFix(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeMaxRadius(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeMidPoint(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeMinRadius(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeOffset(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeOthers(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeParallel(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputePerpendicular(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputePlacement(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeRadius(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeRound(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeSymmetry(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeTangent(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...
    @staticmethod
    def ComputeTextAndValue(aConst: TDataXtd_Constraint, aText: str, anIsAngle: bool) -> float: ...
    @staticmethod
    def UpdateOnlyValue(aConst: TDataXtd_Constraint, anAIS: AIS_InteractiveObject) -> None: ...

class TPrsStd_Driver(Standard_Transient):
    def Update(self, L: TDF_Label, ais: AIS_InteractiveObject) -> bool: ...

class TPrsStd_DriverTable(Standard_Transient):
    def __init__(self) -> None: ...
    def AddDriver(self, guid: Standard_GUID, driver: TPrsStd_Driver) -> bool: ...
    def Clear(self) -> None: ...
    def FindDriver(self, guid: Standard_GUID, driver: TPrsStd_Driver) -> bool: ...
    @staticmethod
    def Get() -> TPrsStd_DriverTable: ...
    def InitStandardDrivers(self) -> None: ...
    def RemoveDriver(self, guid: Standard_GUID) -> bool: ...

class TPrsStd_AxisDriver(TPrsStd_Driver):
    def __init__(self) -> None: ...
    def Update(self, aLabel: TDF_Label, anAISObject: AIS_InteractiveObject) -> bool: ...

class TPrsStd_ConstraintDriver(TPrsStd_Driver):
    def __init__(self) -> None: ...
    def Update(self, aLabel: TDF_Label, anAISObject: AIS_InteractiveObject) -> bool: ...

class TPrsStd_GeometryDriver(TPrsStd_Driver):
    def __init__(self) -> None: ...
    def Update(self, aLabel: TDF_Label, anAISObject: AIS_InteractiveObject) -> bool: ...

class TPrsStd_NamedShapeDriver(TPrsStd_Driver):
    def __init__(self) -> None: ...
    def Update(self, aLabel: TDF_Label, anAISObject: AIS_InteractiveObject) -> bool: ...

class TPrsStd_PlaneDriver(TPrsStd_Driver):
    def __init__(self) -> None: ...
    def Update(self, aLabel: TDF_Label, anAISObject: AIS_InteractiveObject) -> bool: ...

class TPrsStd_PointDriver(TPrsStd_Driver):
    def __init__(self) -> None: ...
    def Update(self, aLabel: TDF_Label, anAISObject: AIS_InteractiveObject) -> bool: ...

# harray1 classes
# harray2 classes
# hsequence classes

