# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
Poly module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_poly.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _Poly
else:
    import _Poly

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Poly.delete_SwigPyIterator

    def value(self):
        return _Poly.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _Poly.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _Poly.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _Poly.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _Poly.SwigPyIterator_equal(self, x)

    def copy(self):
        return _Poly.SwigPyIterator_copy(self)

    def next(self):
        return _Poly.SwigPyIterator_next(self)

    def __next__(self):
        return _Poly.SwigPyIterator___next__(self)

    def previous(self):
        return _Poly.SwigPyIterator_previous(self)

    def advance(self, n):
        return _Poly.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _Poly.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _Poly.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _Poly.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _Poly.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _Poly.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _Poly.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _Poly:
_Poly.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _Poly.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.TColgp
import OCC.Core.Bnd
import OCC.Core.BVH
import OCC.Core.OSD
import OCC.Core.TShort

from enum import IntEnum
from OCC.Core.Exception import *

Poly_MeshPurpose_NONE = _Poly.Poly_MeshPurpose_NONE
Poly_MeshPurpose_Calculation = _Poly.Poly_MeshPurpose_Calculation
Poly_MeshPurpose_Presentation = _Poly.Poly_MeshPurpose_Presentation
Poly_MeshPurpose_Active = _Poly.Poly_MeshPurpose_Active
Poly_MeshPurpose_Loaded = _Poly.Poly_MeshPurpose_Loaded
Poly_MeshPurpose_AnyFallback = _Poly.Poly_MeshPurpose_AnyFallback
Poly_MeshPurpose_USER = _Poly.Poly_MeshPurpose_USER



def Handle_Poly_CoherentTriangulation_Create():
    return _Poly.Handle_Poly_CoherentTriangulation_Create()

def Handle_Poly_CoherentTriangulation_DownCast(t):
    return _Poly.Handle_Poly_CoherentTriangulation_DownCast(t)

def Handle_Poly_CoherentTriangulation_IsNull(t):
    return _Poly.Handle_Poly_CoherentTriangulation_IsNull(t)

def Handle_Poly_MergeNodesTool_Create():
    return _Poly.Handle_Poly_MergeNodesTool_Create()

def Handle_Poly_MergeNodesTool_DownCast(t):
    return _Poly.Handle_Poly_MergeNodesTool_DownCast(t)

def Handle_Poly_MergeNodesTool_IsNull(t):
    return _Poly.Handle_Poly_MergeNodesTool_IsNull(t)

def Handle_Poly_Polygon2D_Create():
    return _Poly.Handle_Poly_Polygon2D_Create()

def Handle_Poly_Polygon2D_DownCast(t):
    return _Poly.Handle_Poly_Polygon2D_DownCast(t)

def Handle_Poly_Polygon2D_IsNull(t):
    return _Poly.Handle_Poly_Polygon2D_IsNull(t)

def Handle_Poly_Polygon3D_Create():
    return _Poly.Handle_Poly_Polygon3D_Create()

def Handle_Poly_Polygon3D_DownCast(t):
    return _Poly.Handle_Poly_Polygon3D_DownCast(t)

def Handle_Poly_Polygon3D_IsNull(t):
    return _Poly.Handle_Poly_Polygon3D_IsNull(t)

def Handle_Poly_PolygonOnTriangulation_Create():
    return _Poly.Handle_Poly_PolygonOnTriangulation_Create()

def Handle_Poly_PolygonOnTriangulation_DownCast(t):
    return _Poly.Handle_Poly_PolygonOnTriangulation_DownCast(t)

def Handle_Poly_PolygonOnTriangulation_IsNull(t):
    return _Poly.Handle_Poly_PolygonOnTriangulation_IsNull(t)

def Handle_Poly_Triangulation_Create():
    return _Poly.Handle_Poly_Triangulation_Create()

def Handle_Poly_Triangulation_DownCast(t):
    return _Poly.Handle_Poly_Triangulation_DownCast(t)

def Handle_Poly_Triangulation_IsNull(t):
    return _Poly.Handle_Poly_Triangulation_IsNull(t)

def Handle_Poly_TriangulationParameters_Create():
    return _Poly.Handle_Poly_TriangulationParameters_Create()

def Handle_Poly_TriangulationParameters_DownCast(t):
    return _Poly.Handle_Poly_TriangulationParameters_DownCast(t)

def Handle_Poly_TriangulationParameters_IsNull(t):
    return _Poly.Handle_Poly_TriangulationParameters_IsNull(t)

def Handle_Poly_HArray1OfTriangle_Create():
    return _Poly.Handle_Poly_HArray1OfTriangle_Create()

def Handle_Poly_HArray1OfTriangle_DownCast(t):
    return _Poly.Handle_Poly_HArray1OfTriangle_DownCast(t)

def Handle_Poly_HArray1OfTriangle_IsNull(t):
    return _Poly.Handle_Poly_HArray1OfTriangle_IsNull(t)
class Poly_Array1OfTriangle(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _Poly.Poly_Array1OfTriangle_begin(self)

    def end(self):
        return _Poly.Poly_Array1OfTriangle_end(self)

    def cbegin(self):
        return _Poly.Poly_Array1OfTriangle_cbegin(self)

    def cend(self):
        return _Poly.Poly_Array1OfTriangle_cend(self)

    def __init__(self, *args):
        _Poly.Poly_Array1OfTriangle_swiginit(self, _Poly.new_Poly_Array1OfTriangle(*args))

    def Init(self, theValue):
        return _Poly.Poly_Array1OfTriangle_Init(self, theValue)

    def Size(self):
        return _Poly.Poly_Array1OfTriangle_Size(self)

    def Length(self):
        return _Poly.Poly_Array1OfTriangle_Length(self)

    def IsEmpty(self):
        return _Poly.Poly_Array1OfTriangle_IsEmpty(self)

    def Lower(self):
        return _Poly.Poly_Array1OfTriangle_Lower(self)

    def Upper(self):
        return _Poly.Poly_Array1OfTriangle_Upper(self)

    def IsDeletable(self):
        return _Poly.Poly_Array1OfTriangle_IsDeletable(self)

    def IsAllocated(self):
        return _Poly.Poly_Array1OfTriangle_IsAllocated(self)

    def Assign(self, theOther):
        return _Poly.Poly_Array1OfTriangle_Assign(self, theOther)

    def Move(self, theOther):
        return _Poly.Poly_Array1OfTriangle_Move(self, theOther)

    def Set(self, *args):
        return _Poly.Poly_Array1OfTriangle_Set(self, *args)

    def First(self):
        return _Poly.Poly_Array1OfTriangle_First(self)

    def ChangeFirst(self):
        return _Poly.Poly_Array1OfTriangle_ChangeFirst(self)

    def Last(self):
        return _Poly.Poly_Array1OfTriangle_Last(self)

    def ChangeLast(self):
        return _Poly.Poly_Array1OfTriangle_ChangeLast(self)

    def Value(self, theIndex):
        return _Poly.Poly_Array1OfTriangle_Value(self, theIndex)

    def ChangeValue(self, theIndex):
        return _Poly.Poly_Array1OfTriangle_ChangeValue(self, theIndex)

    def __call__(self, *args):
        return _Poly.Poly_Array1OfTriangle___call__(self, *args)

    def SetValue(self, theIndex, theItem):
        return _Poly.Poly_Array1OfTriangle_SetValue(self, theIndex, theItem)

    def Resize(self, theLower, theUpper, theToCopyData):
        return _Poly.Poly_Array1OfTriangle_Resize(self, theLower, theUpper, theToCopyData)
    __swig_destroy__ = _Poly.delete_Poly_Array1OfTriangle

    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current += 1
        return self.Value(self.current)

    __next__ = next


# Register Poly_Array1OfTriangle in _Poly:
_Poly.Poly_Array1OfTriangle_swigregister(Poly_Array1OfTriangle)
class Poly_ListOfTriangulation(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def begin(self):
        return _Poly.Poly_ListOfTriangulation_begin(self)

    def end(self):
        return _Poly.Poly_ListOfTriangulation_end(self)

    def cbegin(self):
        return _Poly.Poly_ListOfTriangulation_cbegin(self)

    def cend(self):
        return _Poly.Poly_ListOfTriangulation_cend(self)

    def __init__(self, *args):
        _Poly.Poly_ListOfTriangulation_swiginit(self, _Poly.new_Poly_ListOfTriangulation(*args))

    def Size(self):
        return _Poly.Poly_ListOfTriangulation_Size(self)

    def Assign(self, theOther):
        return _Poly.Poly_ListOfTriangulation_Assign(self, theOther)

    def Set(self, theOther):
        return _Poly.Poly_ListOfTriangulation_Set(self, theOther)

    def Clear(self, theAllocator=0):
        return _Poly.Poly_ListOfTriangulation_Clear(self, theAllocator)

    def First(self):
        return _Poly.Poly_ListOfTriangulation_First(self)

    def Last(self):
        return _Poly.Poly_ListOfTriangulation_Last(self)

    def Append(self, *args):
        return _Poly.Poly_ListOfTriangulation_Append(self, *args)

    def Prepend(self, *args):
        return _Poly.Poly_ListOfTriangulation_Prepend(self, *args)

    def RemoveFirst(self):
        return _Poly.Poly_ListOfTriangulation_RemoveFirst(self)

    def Remove(self, theIter):
        return _Poly.Poly_ListOfTriangulation_Remove(self, theIter)

    def InsertBefore(self, *args):
        return _Poly.Poly_ListOfTriangulation_InsertBefore(self, *args)

    def InsertAfter(self, *args):
        return _Poly.Poly_ListOfTriangulation_InsertAfter(self, *args)

    def Reverse(self):
        return _Poly.Poly_ListOfTriangulation_Reverse(self)
    __swig_destroy__ = _Poly.delete_Poly_ListOfTriangulation

    def __len__(self):
        return self.Size()


# Register Poly_ListOfTriangulation in _Poly:
_Poly.Poly_ListOfTriangulation_swigregister(Poly_ListOfTriangulation)
class poly(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def Catenate(*args):
        r"""

        Parameters
        ----------
        lstTri: Poly_ListOfTriangulation

        Return
        -------
        opencascade::handle<Poly_Triangulation>

        Description
        -----------
        Computes and stores the link from nodes to triangles and from triangles to neighbouring triangles. this tool is obsolete, replaced by poly_coherenttriangulation algorithm to make minimal loops in a graph join several triangulations to one new triangulation object. the new triangulation is just a mechanical sum of input triangulations, without node sharing. uv coordinates are dropped in the result.

        """
        return _Poly.poly_Catenate(*args)

    @staticmethod
    def ComputeNormals(*args):
        r"""

        Parameters
        ----------
        Tri: Poly_Triangulation

        Return
        -------
        None

        Description
        -----------
        Compute node normals for face triangulation as mean normal of surrounding triangles.

        """
        return _Poly.poly_ComputeNormals(*args)

    @staticmethod
    def Intersect(*args):
        r"""

        Parameters
        ----------
        theTri: Poly_Triangulation
        theAxis: gp_Ax1
        theIsClosest: bool
        theTriangle: Poly_Triangle

        Return
        -------
        theDistance: float

        Description
        -----------
        Computes the intersection between axis and triangulation. @param thetri [in] input triangulation @param theaxis [in] intersecting ray @param theisclosest [in] finds the closest intersection when true, finds the farthest otherwise @param thetriangle [out] intersected triangle @param thedistance [out] distance along ray to intersection point return true if intersection takes place, false otherwise.

        """
        return _Poly.poly_Intersect(*args)

    @staticmethod
    def IntersectTriLine(*args):
        r"""

        Parameters
        ----------
        theStart: gp_XYZ
        theDir: gp_Dir
        theV0: gp_XYZ
        theV1: gp_XYZ
        theV2: gp_XYZ

        Return
        -------
        theParam: float

        Description
        -----------
        Computes the intersection between a triangle defined by three vertexes and a line. @param thestart [in] picking ray origin @param thedir [in] picking ray direction @param thev0 [in] first triangle node @param thev1 [in] second triangle node @param thev2 [in] third triangle node @param theparam [out] param on line of the intersection point return 1 if intersection was found, 0 otherwise.

        """
        return _Poly.poly_IntersectTriLine(*args)

    @staticmethod
    def PointOnTriangle(*args):
        r"""

        Parameters
        ----------
        P1: gp_XY
        P2: gp_XY
        P3: gp_XY
        P: gp_XY
        UV: gp_XY

        Return
        -------
        float

        Description
        -----------
        Computes parameters of the point p on triangle defined by points p1, p2, and p3, in 2d. the parameters u and v are defined so that p = p1 + u * (p2 - p1) + v * (p3 - p1), with u >= 0, v >= 0, u + v <= 1. if p is located outside of triangle, or triangle is degenerated, the returned parameters correspond to closest point, and returned value is square of the distance from original point to triangle (0 if point is inside).

        """
        return _Poly.poly_PointOnTriangle(*args)

    def ReadPolygon2DFromString(self, src):
        r"""ReadPolygon2DFromString(poly self, std::string src)"""
        return _Poly.poly_ReadPolygon2DFromString(self, src)

    def ReadPolygon3DFromString(self, src):
        r"""ReadPolygon3DFromString(poly self, std::string src)"""
        return _Poly.poly_ReadPolygon3DFromString(self, src)

    def ReadTriangulationFromString(self, src):
        r"""ReadTriangulationFromString(poly self, std::string src)"""
        return _Poly.poly_ReadTriangulationFromString(self, src)

    __repr__ = _dumps_object


    def __init__(self):
        r"""__init__(poly self) -> poly"""
        _Poly.poly_swiginit(self, _Poly.new_poly())
    __swig_destroy__ = _Poly.delete_poly

# Register poly in _Poly:
_Poly.poly_swigregister(poly)
class Poly_ArrayOfNodes(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor of double-precision array.

        Parameters
        ----------
        theLength: int

        Return
        -------
        None

        Description
        -----------
        Constructor of double-precision array.

        Parameters
        ----------
        theOther: Poly_ArrayOfNodes

        Return
        -------
        None

        Description
        -----------
        Copy constructor .

        Parameters
        ----------
        theBegin: gp_Pnt
        theLength: int

        Return
        -------
        None

        Description
        -----------
        Constructor wrapping pre-allocated c-array of values without copying them.

        Parameters
        ----------
        theBegin: gp_Vec3f
        theLength: int

        Return
        -------
        None

        Description
        -----------
        Constructor wrapping pre-allocated c-array of values without copying them.

        Parameters
        ----------
        theOther: Poly_ArrayOfNodes

        Return
        -------
        None

        Description
        -----------
        Move constructor.

        """
        _Poly.Poly_ArrayOfNodes_swiginit(self, _Poly.new_Poly_ArrayOfNodes(*args))

    def Assign(self, *args):
        r"""

        Parameters
        ----------
        theOther: Poly_ArrayOfNodes

        Return
        -------
        Poly_ArrayOfNodes

        Description
        -----------
        Copies data of theother array to this. the arrays should have the same length, but may have different precision / number of components (data conversion will be applied in the latter case).

        """
        return _Poly.Poly_ArrayOfNodes_Assign(self, *args)

    def IsDoublePrecision(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if array defines nodes with double precision.

        """
        return _Poly.Poly_ArrayOfNodes_IsDoublePrecision(self, *args)

    def Move(self, *args):
        r"""

        Parameters
        ----------
        theOther: Poly_ArrayOfNodes

        Return
        -------
        Poly_ArrayOfNodes

        Description
        -----------
        Move assignment.

        """
        return _Poly.Poly_ArrayOfNodes_Move(self, *args)

    def SetDoublePrecision(self, *args):
        r"""

        Parameters
        ----------
        theIsDouble: bool

        Return
        -------
        None

        Description
        -----------
        Sets if array should define nodes with double or single precision. raises exception if array was already allocated.

        """
        return _Poly.Poly_ArrayOfNodes_SetDoublePrecision(self, *args)

    def SetValue(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int
        theValue: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        A generalized setter for point.

        """
        return _Poly.Poly_ArrayOfNodes_SetValue(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        A generalized accessor to point.

        """
        return _Poly.Poly_ArrayOfNodes_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_ArrayOfNodes

# Register Poly_ArrayOfNodes in _Poly:
_Poly.Poly_ArrayOfNodes_swigregister(Poly_ArrayOfNodes)
class Poly_ArrayOfUVNodes(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Empty constructor of double-precision array.

        Parameters
        ----------
        theLength: int

        Return
        -------
        None

        Description
        -----------
        Constructor of double-precision array.

        Parameters
        ----------
        theOther: Poly_ArrayOfUVNodes

        Return
        -------
        None

        Description
        -----------
        Copy constructor .

        Parameters
        ----------
        theBegin: gp_Pnt2d
        theLength: int

        Return
        -------
        None

        Description
        -----------
        Constructor wrapping pre-allocated c-array of values without copying them.

        Parameters
        ----------
        theBegin: gp_Vec2f
        theLength: int

        Return
        -------
        None

        Description
        -----------
        Constructor wrapping pre-allocated c-array of values without copying them.

        Parameters
        ----------
        theOther: Poly_ArrayOfUVNodes

        Return
        -------
        None

        Description
        -----------
        Move constructor.

        """
        _Poly.Poly_ArrayOfUVNodes_swiginit(self, _Poly.new_Poly_ArrayOfUVNodes(*args))

    def Assign(self, *args):
        r"""

        Parameters
        ----------
        theOther: Poly_ArrayOfUVNodes

        Return
        -------
        Poly_ArrayOfUVNodes

        Description
        -----------
        Copies data of theother array to this. the arrays should have the same length, but may have different precision / number of components (data conversion will be applied in the latter case).

        """
        return _Poly.Poly_ArrayOfUVNodes_Assign(self, *args)

    def IsDoublePrecision(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if array defines nodes with double precision.

        """
        return _Poly.Poly_ArrayOfUVNodes_IsDoublePrecision(self, *args)

    def Move(self, *args):
        r"""

        Parameters
        ----------
        theOther: Poly_ArrayOfUVNodes

        Return
        -------
        Poly_ArrayOfUVNodes

        Description
        -----------
        Move assignment.

        """
        return _Poly.Poly_ArrayOfUVNodes_Move(self, *args)

    def SetDoublePrecision(self, *args):
        r"""

        Parameters
        ----------
        theIsDouble: bool

        Return
        -------
        None

        Description
        -----------
        Sets if array should define nodes with double or single precision. raises exception if array was already allocated.

        """
        return _Poly.Poly_ArrayOfUVNodes_SetDoublePrecision(self, *args)

    def SetValue(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int
        theValue: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        A generalized setter for point.

        """
        return _Poly.Poly_ArrayOfUVNodes_SetValue(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        A generalized accessor to point.

        """
        return _Poly.Poly_ArrayOfUVNodes_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_ArrayOfUVNodes

# Register Poly_ArrayOfUVNodes in _Poly:
_Poly.Poly_ArrayOfUVNodes_swigregister(Poly_ArrayOfUVNodes)
class Poly_CoherentLink(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        /** * empty constructor. */.

        Parameters
        ----------
        iNode0: int
        iNode1: int

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        theTri: Poly_CoherentTriangle
        iSide: int

        Return
        -------
        None

        Description
        -----------
        /** * constructor, takes a triangle and a side. a link is created always such * that mynode[0] < mynode[1]. unlike the previous constructor, this one * assigns the 'opposite node' fields. this constructor is used when a * link is inserted into a poly_coherenttriangulation structure. * @param thetri * triangle containing the link that is created * @param iside * can be 0, 1 or 2. index of the node */.

        """
        _Poly.Poly_CoherentLink_swiginit(self, _Poly.new_Poly_CoherentLink(*args))

    def GetAttribute(self, *args):
        r"""
        Return
        -------
        Standard_Address

        Description
        -----------
        /** * query the attribute of the link. */.

        """
        return _Poly.Poly_CoherentLink_GetAttribute(self, *args)

    def IsEmpty(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        /** * query the status of the link - if it is an invalid one. * an invalid link has node members equal to -1. */.

        """
        return _Poly.Poly_CoherentLink_IsEmpty(self, *args)

    def Node(self, *args):
        r"""

        Parameters
        ----------
        ind: int

        Return
        -------
        int

        Description
        -----------
        /** * return the node index in the current triangulation. * @param ind * 0 or 1 making distinction of the two nodes that constitute the link. * node(0) always returns a smaller number than node(1). */.

        """
        return _Poly.Poly_CoherentLink_Node(self, *args)

    def Nullify(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        /** * invalidate this link. */.

        """
        return _Poly.Poly_CoherentLink_Nullify(self, *args)

    def OppositeNode(self, *args):
        r"""

        Parameters
        ----------
        ind: int

        Return
        -------
        int

        Description
        -----------
        /** * return the opposite node (belonging to the left or right incident triangle) * index in the current triangulation. * @param ind * 0 or 1 making distinction of the two involved triangles: 0 on the left, * 1 on the right side of the link. */.

        """
        return _Poly.Poly_CoherentLink_OppositeNode(self, *args)

    def SetAttribute(self, *args):
        r"""

        Parameters
        ----------
        theAtt: Standard_Address

        Return
        -------
        None

        Description
        -----------
        /** * set the attribute of the link. */.

        """
        return _Poly.Poly_CoherentLink_SetAttribute(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_CoherentLink

# Register Poly_CoherentLink in _Poly:
_Poly.Poly_CoherentLink_swigregister(Poly_CoherentLink)
class Poly_CoherentNode(OCC.Core.gp.gp_XYZ):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        /** * empty constructor. */.

        Parameters
        ----------
        thePnt: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        /** * constructor. */.

        """
        _Poly.Poly_CoherentNode_swiginit(self, _Poly.new_Poly_CoherentNode(*args))

    def AddTriangle(self, *args):
        r"""

        Parameters
        ----------
        theTri: Poly_CoherentTriangle
        theA: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        /** * connect a triangle to this node. */.

        """
        return _Poly.Poly_CoherentNode_AddTriangle(self, *args)

    def Clear(self, *args):
        r"""

        Parameters
        ----------
        &: NCollection_BaseAllocator

        Return
        -------
        None

        Description
        -----------
        /** * reset the node to void. */.

        """
        return _Poly.Poly_CoherentNode_Clear(self, *args)

    def DumpToString(self):
        r"""DumpToString(Poly_CoherentNode self) -> std::string"""
        return _Poly.Poly_CoherentNode_DumpToString(self)

    def GetIndex(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        /** * get the value of node index. */.

        """
        return _Poly.Poly_CoherentNode_GetIndex(self, *args)

    def GetNormal(self, *args):
        r"""
        Return
        -------
        gp_XYZ

        Description
        -----------
        /** * get the stored normal in the node. */.

        """
        return _Poly.Poly_CoherentNode_GetNormal(self, *args)

    def GetU(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        /** * get u coordinate of the node. */.

        """
        return _Poly.Poly_CoherentNode_GetU(self, *args)

    def GetV(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        /** * get v coordinate of the node. */.

        """
        return _Poly.Poly_CoherentNode_GetV(self, *args)

    def HasNormal(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        /** * query if the node contains a normal vector. */.

        """
        return _Poly.Poly_CoherentNode_HasNormal(self, *args)

    def IsFreeNode(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        /** * check if this is a free node, i.e., a node without a single * incident triangle. */.

        """
        return _Poly.Poly_CoherentNode_IsFreeNode(self, *args)

    def RemoveTriangle(self, *args):
        r"""

        Parameters
        ----------
        theTri: Poly_CoherentTriangle
        theA: NCollection_BaseAllocator

        Return
        -------
        bool

        Description
        -----------
        /** * disconnect a triangle from this node. */.

        """
        return _Poly.Poly_CoherentNode_RemoveTriangle(self, *args)

    def SetIndex(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        None

        Description
        -----------
        /** * set the value of node index. */.

        """
        return _Poly.Poly_CoherentNode_SetIndex(self, *args)

    def SetNormal(self, *args):
        r"""

        Parameters
        ----------
        theVector: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        /** * define the normal vector in the node. */.

        """
        return _Poly.Poly_CoherentNode_SetNormal(self, *args)

    def SetUV(self, *args):
        r"""

        Parameters
        ----------
        theU: float
        theV: float

        Return
        -------
        None

        Description
        -----------
        /** * set the uv coordinates of the node. */.

        """
        return _Poly.Poly_CoherentNode_SetUV(self, *args)

    def TriangleIterator(self, *args):
        r"""
        Return
        -------
        Poly_CoherentTriPtr::Iterator

        Description
        -----------
        /** * create an iterator of incident triangles. */.

        """
        return _Poly.Poly_CoherentNode_TriangleIterator(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_CoherentNode

# Register Poly_CoherentNode in _Poly:
_Poly.Poly_CoherentNode_swigregister(Poly_CoherentNode)
class Poly_CoherentTriangle(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        /** * empty constructor. */.

        Parameters
        ----------
        iNode0: int
        iNode1: int
        iNode2: int

        Return
        -------
        None

        Description
        -----------
        /** * constructor. */.

        """
        _Poly.Poly_CoherentTriangle_swiginit(self, _Poly.new_Poly_CoherentTriangle(*args))

    def FindConnection(self, *args):
        r"""

        Parameters
        ----------
        &: Poly_CoherentTriangle

        Return
        -------
        int

        Description
        -----------
        /** * returns the index of the connection with the given triangle, or -1 if not found. */.

        """
        return _Poly.Poly_CoherentTriangle_FindConnection(self, *args)

    def GetConnectedNode(self, *args):
        r"""

        Parameters
        ----------
        iConn: int

        Return
        -------
        int

        Description
        -----------
        /** * query the connected node on the given side. * returns -1 if there is no connection on the specified side. */.

        """
        return _Poly.Poly_CoherentTriangle_GetConnectedNode(self, *args)

    def GetConnectedTri(self, *args):
        r"""

        Parameters
        ----------
        iConn: int

        Return
        -------
        Poly_CoherentTriangle *

        Description
        -----------
        /** * query the connected triangle on the given side. * returns null if there is no connection on the specified side. */.

        """
        return _Poly.Poly_CoherentTriangle_GetConnectedTri(self, *args)

    def GetLink(self, *args):
        r"""

        Parameters
        ----------
        iLink: int

        Return
        -------
        Poly_CoherentLink *

        Description
        -----------
        /** * query the link associate with the given side of the triangle. * may return null if there are no links in the triangulation. */.

        """
        return _Poly.Poly_CoherentTriangle_GetLink(self, *args)

    def IsEmpty(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        /** * query if this is a valid triangle. */.

        """
        return _Poly.Poly_CoherentTriangle_IsEmpty(self, *args)

    def NConnections(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        /** * query the number of connected triangles. */.

        """
        return _Poly.Poly_CoherentTriangle_NConnections(self, *args)

    def Node(self, *args):
        r"""

        Parameters
        ----------
        ind: int

        Return
        -------
        int

        Description
        -----------
        /** * query the node index in the position given by the parameter 'ind' */.

        """
        return _Poly.Poly_CoherentTriangle_Node(self, *args)

    def RemoveConnection(self, *args):
        r"""

        Parameters
        ----------
        iConn: int

        Return
        -------
        None

        Description
        -----------
        /** * remove the connection with the given index. * @param iconn * can be 0, 1 or 2 - index of the node that is opposite to the connection * (shared link). */.

        Parameters
        ----------
        theTri: Poly_CoherentTriangle

        Return
        -------
        bool

        Description
        -----------
        /** * remove the connection with the given triangle. * return * true if successfuol or false if the connection has not been found. */.

        """
        return _Poly.Poly_CoherentTriangle_RemoveConnection(self, *args)

    def SetConnection(self, *args):
        r"""

        Parameters
        ----------
        iConn: int
        theTr: Poly_CoherentTriangle

        Return
        -------
        bool

        Description
        -----------
        /** * create connection with another triangle thetri. * this method creates both connections: in this triangle and in thetri. you * do not need to call the same method on triangle thetr. * @param iconn * can be 0, 1 or 2 - index of the node that is opposite to the connection * (shared link). * @param thetr * triangle that is connected on the given link. * return * true if successful, false if the connection is rejected * due to improper topology. */.

        Parameters
        ----------
        theTri: Poly_CoherentTriangle

        Return
        -------
        bool

        Description
        -----------
        /** * create connection with another triangle thetri. * this method creates both connections: in this triangle and in thetri. * this method is slower than the previous one, because it makes analysis * what sides of both triangles are connected. * @param thetri * triangle that is connected. * return * true if successful, false if the connection is rejected * due to improper topology. */.

        """
        return _Poly.Poly_CoherentTriangle_SetConnection(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_CoherentTriangle

# Register Poly_CoherentTriangle in _Poly:
_Poly.Poly_CoherentTriangle_swigregister(Poly_CoherentTriangle)
class Poly_CoherentTriangulation(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theAlloc: NCollection_BaseAllocator (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        /** * empty constructor. */.

        Parameters
        ----------
        theTriangulation: Poly_Triangulation
        theAlloc: NCollection_BaseAllocator (optional, default to 0)

        Return
        -------
        None

        Description
        -----------
        /** * constructor. it does not create links, you should call computelinks * following this constructor if you need these links. */.

        """
        _Poly.Poly_CoherentTriangulation_swiginit(self, _Poly.new_Poly_CoherentTriangulation(*args))

    def AddLink(self, *args):
        r"""

        Parameters
        ----------
        theTri: Poly_CoherentTriangle
        theConn: int

        Return
        -------
        Poly_CoherentLink *

        Description
        -----------
        /** * add a single link to triangulation, based on a triangle and its side index. * this method does not check for coincidence with already present links. * @param thetri * triangle that contains the link to be added. * @param theconn * index of the side (i.e., 0, 1 0r 2) defining the added link. */.

        """
        return _Poly.Poly_CoherentTriangulation_AddLink(self, *args)

    def AddTriangle(self, *args):
        r"""

        Parameters
        ----------
        iNode0: int
        iNode1: int
        iNode2: int

        Return
        -------
        Poly_CoherentTriangle *

        Description
        -----------
        /** * add a triangle to the triangulation. * return * pointer to the added triangle instance or null if an error occurred. */.

        """
        return _Poly.Poly_CoherentTriangulation_AddTriangle(self, *args)

    def Allocator(self, *args):
        r"""
        Return
        -------
        opencascade::handle<NCollection_BaseAllocator>

        Description
        -----------
        /** * query the allocator of elements, this allocator can be used for other * objects */.

        """
        return _Poly.Poly_CoherentTriangulation_Allocator(self, *args)

    def ChangeNode(self, *args):
        r"""

        Parameters
        ----------
        i: int

        Return
        -------
        Poly_CoherentNode

        Description
        -----------
        /** * get the node at the given index 'i'. */.

        """
        return _Poly.Poly_CoherentTriangulation_ChangeNode(self, *args)

    def ClearLinks(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        /** * clear all links data from the triangulation data. */.

        """
        return _Poly.Poly_CoherentTriangulation_ClearLinks(self, *args)

    def Clone(self, *args):
        r"""

        Parameters
        ----------
        theAlloc: NCollection_BaseAllocator

        Return
        -------
        opencascade::handle<Poly_CoherentTriangulation>

        Description
        -----------
        /** * create a copy of this triangulation, using the given allocator. */.

        """
        return _Poly.Poly_CoherentTriangulation_Clone(self, *args)

    def ComputeLinks(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        /** * (re)calculate all links in this triangulation. */.

        """
        return _Poly.Poly_CoherentTriangulation_ComputeLinks(self, *args)

    def Deflection(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        /** * query the deflection parameter (default value 0. -- if never initialized) */.

        """
        return _Poly.Poly_CoherentTriangulation_Deflection(self, *args)

    def DumpToString(self):
        r"""DumpToString(Poly_CoherentTriangulation self) -> std::string"""
        return _Poly.Poly_CoherentTriangulation_DumpToString(self)

    def FindTriangle(self, *args):
        r"""

        Parameters
        ----------
        theLink: Poly_CoherentLink
        pTri: Poly_CoherentTriangle *

        Return
        -------
        bool

        Description
        -----------
        No available documentation.

        """
        return _Poly.Poly_CoherentTriangulation_FindTriangle(self, *args)

    def GetFreeNodes(self, *args):
        r"""

        Parameters
        ----------
        lstNodes: NCollection_List<int>

        Return
        -------
        bool

        Description
        -----------
        /** * create a list of free nodes. these nodes may appear as a result of any * custom mesh decimation or removedegenerated() call. this analysis is * necessary if you support additional data structures based on the * triangulation (e.g., edges on the surface boundary). * @param lstnodes * <tt>[out]</tt> list that receives the indices of free nodes. */.

        """
        return _Poly.Poly_CoherentTriangulation_GetFreeNodes(self, *args)

    def GetTriangulation(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Poly_Triangulation>

        Description
        -----------
        /** * create an instance of poly_triangulation from this object. */.

        """
        return _Poly.Poly_CoherentTriangulation_GetTriangulation(self, *args)

    def MaxNode(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        /** * query the index of the last node in the triangulation */.

        """
        return _Poly.Poly_CoherentTriangulation_MaxNode(self, *args)

    def MaxTriangle(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        /** * query the index of the last triangle in the triangulation */.

        """
        return _Poly.Poly_CoherentTriangulation_MaxTriangle(self, *args)

    def NLinks(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        /** * query the total number of active links. */.

        """
        return _Poly.Poly_CoherentTriangulation_NLinks(self, *args)

    def NNodes(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        /** * query the total number of active nodes (i.e. nodes used by 1 or more * triangles) */.

        """
        return _Poly.Poly_CoherentTriangulation_NNodes(self, *args)

    def NTriangles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        /** * query the total number of active triangles (i.e. triangles that refer * nodes, non-empty ones) */.

        """
        return _Poly.Poly_CoherentTriangulation_NTriangles(self, *args)

    def Node(self, *args):
        r"""

        Parameters
        ----------
        i: int

        Return
        -------
        Poly_CoherentNode

        Description
        -----------
        /** * get the node at the given index 'i'. */.

        """
        return _Poly.Poly_CoherentTriangulation_Node(self, *args)

    def RemoveDegenerated(self, *args):
        r"""

        Parameters
        ----------
        theTol: float
        pLstRemovedNode: NCollection_List<TwoIntegers> * (optional, default to 0)

        Return
        -------
        bool

        Description
        -----------
        /** * find and remove degenerated triangles in triangulation. * @param thetol * tolerance for the degeneration case. if any two nodes of a triangle have * the distance less than this tolerance, this triangle is considered * degenerated and therefore removed by this method. * @param plstremovednode * optional parameter. if defined, then it will receive the list of arrays * where the first number is the index of removed node and the second - * the index of remaining node to which the mesh was reconnected. */.

        """
        return _Poly.Poly_CoherentTriangulation_RemoveDegenerated(self, *args)

    def RemoveLink(self, *args):
        r"""

        Parameters
        ----------
        theLink: Poly_CoherentLink

        Return
        -------
        None

        Description
        -----------
        /** * removal of a single link from the triangulation. */.

        """
        return _Poly.Poly_CoherentTriangulation_RemoveLink(self, *args)

    def RemoveTriangle(self, *args):
        r"""

        Parameters
        ----------
        theTr: Poly_CoherentTriangle

        Return
        -------
        bool

        Description
        -----------
        /** * removal of a single triangle from the triangulation. */.

        """
        return _Poly.Poly_CoherentTriangulation_RemoveTriangle(self, *args)

    def ReplaceNodes(self, *args):
        r"""

        Parameters
        ----------
        theTriangle: Poly_CoherentTriangle
        iNode0: int
        iNode1: int
        iNode2: int

        Return
        -------
        bool

        Description
        -----------
        /** * replace nodes in the given triangle. * return * true if operation succeeded. */.

        """
        return _Poly.Poly_CoherentTriangulation_ReplaceNodes(self, *args)

    def SetDeflection(self, *args):
        r"""

        Parameters
        ----------
        theDefl: float

        Return
        -------
        None

        Description
        -----------
        /** * set the deflection value as the parameter of the given triangulation. */.

        """
        return _Poly.Poly_CoherentTriangulation_SetDeflection(self, *args)

    def SetNode(self, *args):
        r"""

        Parameters
        ----------
        thePnt: gp_XYZ
        iN: int (optional, default to -1)

        Return
        -------
        int

        Description
        -----------
        /** * initialize a node * @param thepoint * 3d coordinates of the node. * @param in * index of the node. if negative (default), the node is added to the * end of the current array of nodes. * return * index of the added node. */.

        """
        return _Poly.Poly_CoherentTriangulation_SetNode(self, *args)

    def Triangle(self, *args):
        r"""

        Parameters
        ----------
        i: int

        Return
        -------
        Poly_CoherentTriangle

        Description
        -----------
        /** * get the triangle at the given index 'i'. */.

        """
        return _Poly.Poly_CoherentTriangulation_Triangle(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Poly_CoherentTriangulation_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_CoherentTriangulation

# Register Poly_CoherentTriangulation in _Poly:
_Poly.Poly_CoherentTriangulation_swigregister(Poly_CoherentTriangulation)
class Poly_Connect(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an uninitialized algorithm.

        Parameters
        ----------
        theTriangulation: Poly_Triangulation

        Return
        -------
        None

        Description
        -----------
        Constructs an algorithm to explore the adjacency data of nodes or triangles for the triangulation t.

        """
        _Poly.Poly_Connect_swiginit(self, _Poly.new_Poly_Connect(*args))

    def Initialize(self, *args):
        r"""

        Parameters
        ----------
        N: int

        Return
        -------
        None

        Description
        -----------
        Initializes an iterator to search for all the triangles containing the node referenced at index n in the nodes table, for the triangulation analyzed by this tool. the iterator is managed by the following functions: - more, which checks if there are still elements in the iterator - next, which positions the iterator on the next element - value, which returns the current element. the use of such an iterator provides direct access to the triangles around a particular node, i.e. it avoids iterating on all the component triangles of a triangulation. example poly_connect c(tr); for (c.initialize(n1);c.more();c.next()) { t = c.value(); }.

        """
        return _Poly.Poly_Connect_Initialize(self, *args)

    def Load(self, *args):
        r"""

        Parameters
        ----------
        theTriangulation: Poly_Triangulation

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithm to explore the adjacency data of nodes or triangles for the triangulation thetriangulation.

        """
        return _Poly.Poly_Connect_Load(self, *args)

    def More(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if there is another element in the iterator defined with the function initialize (i.e. if there is another triangle containing the given node).

        """
        return _Poly.Poly_Connect_More(self, *args)

    def Next(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Advances the iterator defined with the function initialize to access the next triangle. note: there is no action if the iterator is empty (i.e. if the function more returns false).-.

        """
        return _Poly.Poly_Connect_Next(self, *args)

    def Nodes(self, *args):
        r"""

        Parameters
        ----------
        T: int

        Return
        -------
        n1: int
        n2: int
        n3: int

        Description
        -----------
        Returns, in n1, n2 and n3, the indices of the 3 nodes adjacent to the triangle referenced at index t in the triangles table specific to the triangulation analyzed by this tool. warning null indices are returned when there are fewer than 3 adjacent nodes.

        """
        return _Poly.Poly_Connect_Nodes(self, *args)

    def Triangle(self, *args):
        r"""

        Parameters
        ----------
        N: int

        Return
        -------
        int

        Description
        -----------
        Returns the index of a triangle containing the node at index n in the nodes table specific to the triangulation analyzed by this tool.

        """
        return _Poly.Poly_Connect_Triangle(self, *args)

    def Triangles(self, *args):
        r"""

        Parameters
        ----------
        T: int

        Return
        -------
        t1: int
        t2: int
        t3: int

        Description
        -----------
        Returns in t1, t2 and t3, the indices of the 3 triangles adjacent to the triangle at index t in the triangles table specific to the triangulation analyzed by this tool. warning null indices are returned when there are fewer than 3 adjacent triangles.

        """
        return _Poly.Poly_Connect_Triangles(self, *args)

    def Triangulation(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Poly_Triangulation>

        Description
        -----------
        Returns the triangulation analyzed by this tool.

        """
        return _Poly.Poly_Connect_Triangulation(self, *args)

    def Value(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the index of the current triangle to which the iterator, defined with the function initialize, points. this is an index in the triangles table specific to the triangulation analyzed by this tool.

        """
        return _Poly.Poly_Connect_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_Connect

# Register Poly_Connect in _Poly:
_Poly.Poly_Connect_swigregister(Poly_Connect)
class Poly_MergeNodesTool(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theSmoothAngle: double
        theMergeTolerance: double (optional, default to 0.0)
        theNbFacets: int (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Constructor @param[in] thesmoothangle smooth angle in radians or 0.0 to disable merging by angle @param[in] themergetolerance node merging maximum distance @param[in] thenbfacets estimated number of facets for map preallocation.

        """
        _Poly.Poly_MergeNodesTool_swiginit(self, _Poly.new_Poly_MergeNodesTool(*args))

    def AddElement(self, *args):
        r"""

        Parameters
        ----------
        theElemNodes: gp_XYZ *
        theNbNodes: int

        Return
        -------
        None

        Description
        -----------
        Add new triangle or quad. @param[in] theelemnodes element nodes @param[in] thenbnodes number of element nodes, should be 3 or 4.

        """
        return _Poly.Poly_MergeNodesTool_AddElement(self, *args)

    def AddQuad(self, *args):
        r"""

        Parameters
        ----------
        theElemNodes: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Add new quad. @param[in] theelemnodes 4 element nodes.

        """
        return _Poly.Poly_MergeNodesTool_AddQuad(self, *args)

    def AddTriangle(self, *args):
        r"""

        Parameters
        ----------
        theElemNodes: gp_XYZ

        Return
        -------
        None

        Description
        -----------
        Add new triangle. @param[in] theelemnodes 3 element nodes.

        """
        return _Poly.Poly_MergeNodesTool_AddTriangle(self, *args)

    def AddTriangulation(self, *args):
        r"""

        Parameters
        ----------
        theTris: Poly_Triangulation
        theTrsf: gp_Trsf (optional, default to gp_Trsf())
        theToReverse: bool (optional, default to false)

        Return
        -------
        None

        Description
        -----------
        Add another triangulation to created one. @param[in] thetris triangulation to add @param[in] thetrsf transformation to apply @param[in] thetoreverse reverse triangle nodes order.

        """
        return _Poly.Poly_MergeNodesTool_AddTriangulation(self, *args)

    def ChangeElementNode(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        gp_XYZ

        Description
        -----------
        Change node coordinates of element to be pushed. @param[in] theindex node index within current element, in 0..3 range.

        """
        return _Poly.Poly_MergeNodesTool_ChangeElementNode(self, *args)

    def ChangeOutput(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Poly_Triangulation>

        Description
        -----------
        Setup output triangulation for modifications. when set to null, the tool could be used as a merge map for filling in external mesh structure.

        """
        return _Poly.Poly_MergeNodesTool_ChangeOutput(self, *args)

    def ElementNodeIndex(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        int

        Description
        -----------
        Return current element node index defined by pushlastelement().

        """
        return _Poly.Poly_MergeNodesTool_ElementNodeIndex(self, *args)

    def MergeAngle(self, *args):
        r"""
        Return
        -------
        double

        Description
        -----------
        Return merge angle in radians; 0.0 by default (normals with non-exact directions are not merged).

        """
        return _Poly.Poly_MergeNodesTool_MergeAngle(self, *args)

    @staticmethod
    def MergeNodes(*args):
        r"""

        Parameters
        ----------
        theTris: Poly_Triangulation
        theTrsf: gp_Trsf
        theToReverse: bool
        theSmoothAngle: double
        theMergeTolerance: double (optional, default to 0.0)
        theToForce: bool (optional, default to true)

        Return
        -------
        opencascade::handle<Poly_Triangulation>

        Description
        -----------
        Merge nodes of existing mesh and return the new mesh. @param[in] thetris triangulation to add @param[in] thetrsf transformation to apply @param[in] thetoreverse reverse triangle nodes order @param[in] thesmoothangle merge angle in radians @param[in] themergetolerance linear merge tolerance @param[in] thetoforce return merged triangulation even if it's statistics is equal to input one return merged triangulation or null on no result.

        """
        return _Poly.Poly_MergeNodesTool_MergeNodes(*args)

    def MergeTolerance(self, *args):
        r"""
        Return
        -------
        double

        Description
        -----------
        Return merge tolerance; 0.0 by default (only 3d points with exactly matching coordinates are merged).

        """
        return _Poly.Poly_MergeNodesTool_MergeTolerance(self, *args)

    def NbDegenerativeElems(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return number of discarded degenerate elements.

        """
        return _Poly.Poly_MergeNodesTool_NbDegenerativeElems(self, *args)

    def NbElements(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return number of elements.

        """
        return _Poly.Poly_MergeNodesTool_NbElements(self, *args)

    def NbMergedElems(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return number of merged equal elements.

        """
        return _Poly.Poly_MergeNodesTool_NbMergedElems(self, *args)

    def NbNodes(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Return number of nodes.

        """
        return _Poly.Poly_MergeNodesTool_NbNodes(self, *args)

    def PushLastElement(self, *args):
        r"""

        Parameters
        ----------
        theNbNodes: int

        Return
        -------
        None

        Description
        -----------
        Add new triangle or quad with nodes specified by changeelementnode().

        """
        return _Poly.Poly_MergeNodesTool_PushLastElement(self, *args)

    def PushLastQuad(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Add new quad with nodes specified by changeelementnode().

        """
        return _Poly.Poly_MergeNodesTool_PushLastQuad(self, *args)

    def PushLastTriangle(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Add new triangle with nodes specified by changeelementnode().

        """
        return _Poly.Poly_MergeNodesTool_PushLastTriangle(self, *args)

    def Result(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Poly_Triangulation>

        Description
        -----------
        Prepare and return result triangulation (temporary data will be truncated to result size).

        """
        return _Poly.Poly_MergeNodesTool_Result(self, *args)

    def SetDropDegenerative(self, *args):
        r"""

        Parameters
        ----------
        theToDrop: bool

        Return
        -------
        None

        Description
        -----------
        Set if degenerate elements should be discarded.

        """
        return _Poly.Poly_MergeNodesTool_SetDropDegenerative(self, *args)

    def SetMergeAngle(self, *args):
        r"""

        Parameters
        ----------
        theAngleRad: double

        Return
        -------
        None

        Description
        -----------
        Set merge angle.

        """
        return _Poly.Poly_MergeNodesTool_SetMergeAngle(self, *args)

    def SetMergeElems(self, *args):
        r"""

        Parameters
        ----------
        theToMerge: bool

        Return
        -------
        None

        Description
        -----------
        Set if equal elements should be filtered.

        """
        return _Poly.Poly_MergeNodesTool_SetMergeElems(self, *args)

    def SetMergeOpposite(self, *args):
        r"""

        Parameters
        ----------
        theToMerge: bool

        Return
        -------
        None

        Description
        -----------
        Set if nodes with opposite normals should be merged.

        """
        return _Poly.Poly_MergeNodesTool_SetMergeOpposite(self, *args)

    def SetMergeTolerance(self, *args):
        r"""

        Parameters
        ----------
        theTolerance: double

        Return
        -------
        None

        Description
        -----------
        Set merge tolerance.

        """
        return _Poly.Poly_MergeNodesTool_SetMergeTolerance(self, *args)

    def SetUnitFactor(self, *args):
        r"""

        Parameters
        ----------
        theUnitFactor: double

        Return
        -------
        None

        Description
        -----------
        Setup unit factor.

        """
        return _Poly.Poly_MergeNodesTool_SetUnitFactor(self, *args)

    def ToDropDegenerative(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if degenerate elements should be discarded; true by default.

        """
        return _Poly.Poly_MergeNodesTool_ToDropDegenerative(self, *args)

    def ToMergeElems(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if equal elements should be filtered; false by default.

        """
        return _Poly.Poly_MergeNodesTool_ToMergeElems(self, *args)

    def ToMergeOpposite(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Return true if nodes with opposite normals should be merged; false by default.

        """
        return _Poly.Poly_MergeNodesTool_ToMergeOpposite(self, *args)

    def computeTriNormal(self, *args):
        r"""
        Return
        -------
        NCollection_Vec3<float >

        Description
        -----------
        Compute normal for the mesh element.

        """
        return _Poly.Poly_MergeNodesTool_computeTriNormal(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Poly_MergeNodesTool_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_MergeNodesTool

# Register Poly_MergeNodesTool in _Poly:
_Poly.Poly_MergeNodesTool_swigregister(Poly_MergeNodesTool)
class Poly_Polygon2D(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theNbNodes: int

        Return
        -------
        None

        Description
        -----------
        Constructs a 2d polygon with specified number of nodes.

        Parameters
        ----------
        Nodes: TColgp_Array1OfPnt2d

        Return
        -------
        None

        Description
        -----------
        Constructs a 2d polygon defined by the table of points, <nodes>.

        """
        _Poly.Poly_Polygon2D_swiginit(self, _Poly.new_Poly_Polygon2D(*args))

    def ChangeNodes(self, *args):
        r"""
        Return
        -------
        TColgp_Array1OfPnt2d

        Description
        -----------
        Returns the table of nodes for this polygon.

        """
        return _Poly.Poly_Polygon2D_ChangeNodes(self, *args)

    def Deflection(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the deflection of this polygon. deflection is used in cases where the polygon is an approximate representation of a curve. deflection represents the maximum distance permitted between any point on the curve and the corresponding point on the polygon. by default the deflection value is equal to 0. an algorithm using this 2d polygon with a deflection value equal to 0 considers that it is working with a true polygon and not with an approximate representation of a curve. the deflection function is used to modify the deflection value of this polygon. the deflection value can be used by any algorithm working with 2d polygons. for example: - an algorithm may use a unique deflection value for all its polygons. in this case it is not necessary to use the deflection function. - or an algorithm may want to attach a different deflection to each polygon. in this case, the deflection function is used to set a value on each polygon, and later to fetch the value.

        Parameters
        ----------
        theDefl: float

        Return
        -------
        None

        Description
        -----------
        Sets the deflection of this polygon.

        """
        return _Poly.Poly_Polygon2D_Deflection(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _Poly.Poly_Polygon2D_DumpJsonToString(self, depth)

    def NbNodes(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of nodes in this polygon. note: if the polygon is closed, the point of closure is repeated at the end of its table of nodes. thus, on a closed triangle, the function nbnodes returns 4.

        """
        return _Poly.Poly_Polygon2D_NbNodes(self, *args)

    def Nodes(self, *args):
        r"""
        Return
        -------
        TColgp_Array1OfPnt2d

        Description
        -----------
        Returns the table of nodes for this polygon.

        """
        return _Poly.Poly_Polygon2D_Nodes(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Poly_Polygon2D_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_Polygon2D

# Register Poly_Polygon2D in _Poly:
_Poly.Poly_Polygon2D_swigregister(Poly_Polygon2D)
class Poly_Polygon3D(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theNbNodes: int
        theHasParams: bool

        Return
        -------
        None

        Description
        -----------
        Constructs a 3d polygon with specific number of nodes.

        Parameters
        ----------
        Nodes: TColgp_Array1OfPnt

        Return
        -------
        None

        Description
        -----------
        Constructs a 3d polygon defined by the table of points, nodes.

        Parameters
        ----------
        Nodes: TColgp_Array1OfPnt
        Parameters: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Constructs a 3d polygon defined by the table of points, nodes, and the parallel table of parameters, parameters, where each value of the table parameters is the parameter of the corresponding point on the curve approximated by the constructed polygon. warning both the nodes and parameters tables must have the same bounds. this property is not checked at construction time.

        """
        _Poly.Poly_Polygon3D_swiginit(self, _Poly.new_Poly_Polygon3D(*args))

    def ChangeNodes(self, *args):
        r"""
        Return
        -------
        TColgp_Array1OfPnt

        Description
        -----------
        Returns the table of nodes for this polygon.

        """
        return _Poly.Poly_Polygon3D_ChangeNodes(self, *args)

    def ChangeParameters(self, *args):
        r"""
        Return
        -------
        TColStd_Array1OfReal

        Description
        -----------
        Returns the table of the parameters associated with each node in this polygon. changeparameters function returns the array as shared. therefore if the table is selected by reference you can, by simply modifying it, directly modify the data structure of this polygon.

        """
        return _Poly.Poly_Polygon3D_ChangeParameters(self, *args)

    def Copy(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Poly_Polygon3D>

        Description
        -----------
        Creates a copy of current polygon.

        """
        return _Poly.Poly_Polygon3D_Copy(self, *args)

    def Deflection(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the deflection of this polygon.

        Parameters
        ----------
        theDefl: float

        Return
        -------
        None

        Description
        -----------
        Sets the deflection of this polygon. see more on deflection in poly_polygon2d.

        """
        return _Poly.Poly_Polygon3D_Deflection(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _Poly.Poly_Polygon3D_DumpJsonToString(self, depth)

    def HasParameters(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns the table of the parameters associated with each node in this polygon. hasparameters function checks if parameters are associated with the nodes of this polygon.

        """
        return _Poly.Poly_Polygon3D_HasParameters(self, *args)

    def NbNodes(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of nodes in this polygon. note: if the polygon is closed, the point of closure is repeated at the end of its table of nodes. thus, on a closed triangle the function nbnodes returns 4.

        """
        return _Poly.Poly_Polygon3D_NbNodes(self, *args)

    def Nodes(self, *args):
        r"""
        Return
        -------
        TColgp_Array1OfPnt

        Description
        -----------
        Returns the table of nodes for this polygon.

        """
        return _Poly.Poly_Polygon3D_Nodes(self, *args)

    def Parameters(self, *args):
        r"""
        Return
        -------
        TColStd_Array1OfReal

        Description
        -----------
        Returns true if parameters are associated with the nodes in this polygon.

        """
        return _Poly.Poly_Polygon3D_Parameters(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Poly_Polygon3D_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_Polygon3D

# Register Poly_Polygon3D in _Poly:
_Poly.Poly_Polygon3D_swigregister(Poly_Polygon3D)
class Poly_PolygonOnTriangulation(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theNbNodes: int
        theHasParams: bool

        Return
        -------
        None

        Description
        -----------
        Constructs a 3d polygon on the triangulation of a shape with specified size of nodes.

        Parameters
        ----------
        Nodes: TColStd_Array1OfInteger

        Return
        -------
        None

        Description
        -----------
        Constructs a 3d polygon on the triangulation of a shape, defined by the table of nodes, <nodes>.

        Parameters
        ----------
        Nodes: TColStd_Array1OfInteger
        Parameters: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        Constructs a 3d polygon on the triangulation of a shape, defined by: - the table of nodes, nodes, and the table of parameters, <parameters>. where: - a node value is an index in the table of nodes specific to an existing triangulation of a shape - and a parameter value is the value of the parameter of the corresponding point on the curve approximated by the constructed polygon. warning the tables nodes and parameters must be the same size. this property is not checked at construction time.

        """
        _Poly.Poly_PolygonOnTriangulation_swiginit(self, _Poly.new_Poly_PolygonOnTriangulation(*args))

    def ChangeNodes(self, *args):
        r"""
        Return
        -------
        TColStd_Array1OfInteger

        Description
        -----------
        No available documentation.

        """
        return _Poly.Poly_PolygonOnTriangulation_ChangeNodes(self, *args)

    def ChangeParameters(self, *args):
        r"""
        Return
        -------
        TColStd_Array1OfReal

        Description
        -----------
        No available documentation.

        """
        return _Poly.Poly_PolygonOnTriangulation_ChangeParameters(self, *args)

    def Copy(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Poly_PolygonOnTriangulation>

        Description
        -----------
        Creates a copy of current polygon.

        """
        return _Poly.Poly_PolygonOnTriangulation_Copy(self, *args)

    def Deflection(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the deflection of this polygon.

        Parameters
        ----------
        theDefl: float

        Return
        -------
        None

        Description
        -----------
        Sets the deflection of this polygon. see more on deflection in poly_polygones2d.

        """
        return _Poly.Poly_PolygonOnTriangulation_Deflection(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _Poly.Poly_PolygonOnTriangulation_DumpJsonToString(self, depth)

    def HasParameters(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if parameters are associated with the nodes in this polygon.

        """
        return _Poly.Poly_PolygonOnTriangulation_HasParameters(self, *args)

    def NbNodes(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of nodes for this polygon. note: if the polygon is closed, the point of closure is repeated at the end of its table of nodes. thus, on a closed triangle, the function nbnodes returns 4.

        """
        return _Poly.Poly_PolygonOnTriangulation_NbNodes(self, *args)

    def Node(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        int

        Description
        -----------
        Returns node at the given index.

        """
        return _Poly.Poly_PolygonOnTriangulation_Node(self, *args)

    def Nodes(self, *args):
        r"""
        Return
        -------
        TColStd_Array1OfInteger

        Description
        -----------
        Returns the table of nodes for this polygon. a node value is an index in the table of nodes specific to an existing triangulation of a shape.

        """
        return _Poly.Poly_PolygonOnTriangulation_Nodes(self, *args)

    def Parameter(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        float

        Description
        -----------
        Returns parameter at the given index.

        """
        return _Poly.Poly_PolygonOnTriangulation_Parameter(self, *args)

    def Parameters(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HArray1OfReal>

        Description
        -----------
        Returns the table of the parameters associated with each node in this polygon. warning! use the function hasparameters to check if parameters are associated with the nodes in this polygon.

        """
        return _Poly.Poly_PolygonOnTriangulation_Parameters(self, *args)

    def SetNode(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int
        theNode: int

        Return
        -------
        None

        Description
        -----------
        Sets node at the given index.

        """
        return _Poly.Poly_PolygonOnTriangulation_SetNode(self, *args)

    def SetParameter(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int
        theValue: float

        Return
        -------
        None

        Description
        -----------
        Sets parameter at the given index.

        """
        return _Poly.Poly_PolygonOnTriangulation_SetParameter(self, *args)

    def SetParameters(self, *args):
        r"""

        Parameters
        ----------
        theParameters: TColStd_HArray1OfReal

        Return
        -------
        None

        Description
        -----------
        Sets the table of the parameters associated with each node in this polygon. raises exception if array size doesn't much number of polygon nodes.

        """
        return _Poly.Poly_PolygonOnTriangulation_SetParameters(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Poly_PolygonOnTriangulation_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_PolygonOnTriangulation

# Register Poly_PolygonOnTriangulation in _Poly:
_Poly.Poly_PolygonOnTriangulation_swigregister(Poly_PolygonOnTriangulation)
class Poly_Triangle(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs a triangle and sets all indices to zero.

        Parameters
        ----------
        theN1: int
        theN2: int
        theN3: int

        Return
        -------
        None

        Description
        -----------
        Constructs a triangle and sets its three indices, where these node values are indices in the table of nodes specific to an existing triangulation of a shape.

        """
        _Poly.Poly_Triangle_swiginit(self, _Poly.new_Poly_Triangle(*args))

    def GetChangeValue(self, theIndex):
        r"""GetChangeValue(Poly_Triangle self, Standard_Integer const theIndex) -> Standard_Integer"""
        return _Poly.Poly_Triangle_GetChangeValue(self, theIndex)

    def SetChangeValue(self, theIndex, value):
        r"""SetChangeValue(Poly_Triangle self, Standard_Integer const theIndex, Standard_Integer value)"""
        return _Poly.Poly_Triangle_SetChangeValue(self, theIndex, value)

    def Get(self, *args):
        r"""

        Parameters
        ----------

        Return
        -------
        theN1: int
        theN2: int
        theN3: int

        Description
        -----------
        Returns the node indices of this triangle.

        """
        return _Poly.Poly_Triangle_Get(self, *args)

    def Set(self, *args):
        r"""

        Parameters
        ----------
        theN1: int
        theN2: int
        theN3: int

        Return
        -------
        None

        Description
        -----------
        Sets the value of the three nodes of this triangle.

        Parameters
        ----------
        theIndex: int
        theNode: int

        Return
        -------
        None

        Description
        -----------
        Sets the value of node with specified index of this triangle. raises standard_outofrange if index is not in 1,2,3.

        """
        return _Poly.Poly_Triangle_Set(self, *args)

    def Value(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        int

        Description
        -----------
        Get the node of given index. raises outofrange from standard if index is not in 1,2,3.

        """
        return _Poly.Poly_Triangle_Value(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_Triangle

# Register Poly_Triangle in _Poly:
_Poly.Poly_Triangle_swigregister(Poly_Triangle)
class Poly_Triangulation(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructs an empty triangulation.

        Parameters
        ----------
        theNbNodes: int
        theNbTriangles: int
        theHasUVNodes: bool
        theHasNormals: bool (optional, default to false)

        Return
        -------
        None

        Description
        -----------
        Constructs a triangulation from a set of triangles. the triangulation is initialized without a triangle or a node, but capable of containing specified number of nodes and triangles. @param thenbnodes [in] number of nodes to allocate @param thenbtriangles [in] number of triangles to allocate @param thehasuvnodes [in] indicates whether 2d nodes will be associated with 3d ones,  (i.e. to enable a 2d representation) @param thehasnormals [in] indicates whether normals will be given and associated with nodes.

        Parameters
        ----------
        Nodes: TColgp_Array1OfPnt
        Triangles: Poly_Array1OfTriangle

        Return
        -------
        None

        Description
        -----------
        Constructs a triangulation from a set of triangles. the triangulation is initialized with 3d points from nodes and triangles from triangles.

        Parameters
        ----------
        Nodes: TColgp_Array1OfPnt
        UVNodes: TColgp_Array1OfPnt2d
        Triangles: Poly_Array1OfTriangle

        Return
        -------
        None

        Description
        -----------
        Constructs a triangulation from a set of triangles. the triangulation is initialized with 3d points from nodes, 2d points from uvnodes and triangles from triangles, where coordinates of a 2d point from uvnodes are the (u, v) parameters of the corresponding 3d point from nodes on the surface approximated by the constructed triangulation.

        Parameters
        ----------
        theTriangulation: Poly_Triangulation

        Return
        -------
        None

        Description
        -----------
        Copy constructor for triangulation.

        """
        _Poly.Poly_Triangulation_swiginit(self, _Poly.new_Poly_Triangulation(*args))

    def AddNormals(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        If an array for normals is not allocated yet, do it now.

        """
        return _Poly.Poly_Triangulation_AddNormals(self, *args)

    def AddUVNodes(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        If an array for uv coordinates is not allocated yet, do it now.

        """
        return _Poly.Poly_Triangulation_AddUVNodes(self, *args)

    def CachedMinMax(self, *args):
        r"""
        Return
        -------
        Bnd_Box

        Description
        -----------
        Returns cached min - max range of triangulation data, which is void by default (e.g, no cached information).

        """
        return _Poly.Poly_Triangulation_CachedMinMax(self, *args)

    def ChangeTriangle(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        Poly_Triangle

        Description
        -----------
        No available documentation.

        """
        return _Poly.Poly_Triangulation_ChangeTriangle(self, *args)

    def ChangeTriangles(self, *args):
        r"""
        Return
        -------
        Poly_Array1OfTriangle

        Description
        -----------
        No available documentation.

        """
        return _Poly.Poly_Triangulation_ChangeTriangles(self, *args)

    def Clear(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Clears internal arrays of nodes and all attributes.

        """
        return _Poly.Poly_Triangulation_Clear(self, *args)

    def ComputeNormals(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Compute smooth normals by averaging triangle normals.

        """
        return _Poly.Poly_Triangulation_ComputeNormals(self, *args)

    def Copy(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Poly_Triangulation>

        Description
        -----------
        Creates full copy of current triangulation.

        """
        return _Poly.Poly_Triangulation_Copy(self, *args)

    def Deflection(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the deflection of this triangulation.

        Parameters
        ----------
        theDeflection: float

        Return
        -------
        None

        Description
        -----------
        Sets the deflection of this triangulation to thedeflection. see more on deflection in polygon2d.

        """
        return _Poly.Poly_Triangulation_Deflection(self, *args)

    def DetachedLoadDeferredData(self, *args):
        r"""

        Parameters
        ----------
        theFileSystem: OSD_FileSystem (optional, default to opencascade::handle<OSD_FileSystem>())

        Return
        -------
        opencascade::handle<Poly_Triangulation>

        Description
        -----------
        Loads triangulation data into new poly_triangulation object from some deferred storage using specified shared input file system.

        """
        return _Poly.Poly_Triangulation_DetachedLoadDeferredData(self, *args)

    def DumpJsonToString(self, depth=-1):
        r"""Json string serializer.Json string serializer."""
        return _Poly.Poly_Triangulation_DumpJsonToString(self, depth)

    def HasCachedMinMax(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if there is some cached min - max range of this triangulation.

        """
        return _Poly.Poly_Triangulation_HasCachedMinMax(self, *args)

    def HasDeferredData(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if there is some triangulation data that can be loaded using loaddeferreddata().

        """
        return _Poly.Poly_Triangulation_HasDeferredData(self, *args)

    def HasGeometry(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if triangulation has some geometry.

        """
        return _Poly.Poly_Triangulation_HasGeometry(self, *args)

    def HasNormals(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns standard_true if nodal normals are defined.

        """
        return _Poly.Poly_Triangulation_HasNormals(self, *args)

    def HasUVNodes(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns standard_true if 2d nodes are associated with 3d nodes for this triangulation.

        """
        return _Poly.Poly_Triangulation_HasUVNodes(self, *args)

    def InternalNodes(self, *args):
        r"""
        Return
        -------
        Poly_ArrayOfNodes

        Description
        -----------
        Returns an internal array of nodes. node()/setnode() should be used instead in portable code.

        """
        return _Poly.Poly_Triangulation_InternalNodes(self, *args)

    def InternalNormals(self, *args):
        r"""
        Return
        -------
        NCollection_Array1<gp_Vec3f>

        Description
        -----------
        Return an internal array of normals. normal()/setnormal() should be used instead in portable code.

        """
        return _Poly.Poly_Triangulation_InternalNormals(self, *args)

    def InternalTriangles(self, *args):
        r"""
        Return
        -------
        Poly_Array1OfTriangle

        Description
        -----------
        Returns an internal array of triangles. triangle()/settriangle() should be used instead in portable code.

        """
        return _Poly.Poly_Triangulation_InternalTriangles(self, *args)

    def InternalUVNodes(self, *args):
        r"""
        Return
        -------
        Poly_ArrayOfUVNodes

        Description
        -----------
        Returns an internal array of uv nodes. ubnode()/setuvnode() should be used instead in portable code.

        """
        return _Poly.Poly_Triangulation_InternalUVNodes(self, *args)

    def IsDoublePrecision(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if node positions are defined with double precision; true by default.

        """
        return _Poly.Poly_Triangulation_IsDoublePrecision(self, *args)

    def LoadDeferredData(self, *args):
        r"""

        Parameters
        ----------
        theFileSystem: OSD_FileSystem (optional, default to opencascade::handle<OSD_FileSystem>())

        Return
        -------
        bool

        Description
        -----------
        Loads triangulation data into itself from some deferred storage using specified shared input file system.

        """
        return _Poly.Poly_Triangulation_LoadDeferredData(self, *args)

    def MapNodeArray(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColgp_HArray1OfPnt>

        Description
        -----------
        Returns the table of 3d points for read-only access or null if nodes array is undefined. poly_triangulation::node() should be used instead when possible. returned object should not be used after poly_triangulation destruction.

        """
        return _Poly.Poly_Triangulation_MapNodeArray(self, *args)

    def MapNormalArray(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TShort_HArray1OfShortReal>

        Description
        -----------
        Returns the table of per-vertex normals for read-only access or null if normals array is undefined. poly_triangulation::normal() should be used instead when possible. returned object should not be used after poly_triangulation destruction.

        """
        return _Poly.Poly_Triangulation_MapNormalArray(self, *args)

    def MapTriangleArray(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Poly_HArray1OfTriangle>

        Description
        -----------
        Returns the triangle array for read-only access or null if triangle array is undefined. poly_triangulation::triangle() should be used instead when possible. returned object should not be used after poly_triangulation destruction.

        """
        return _Poly.Poly_Triangulation_MapTriangleArray(self, *args)

    def MapUVNodeArray(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColgp_HArray1OfPnt2d>

        Description
        -----------
        Returns the table of 2d nodes for read-only access or null if uv nodes array is undefined. poly_triangulation::uvnode() should be used instead when possible. returned object should not be used after poly_triangulation destruction.

        """
        return _Poly.Poly_Triangulation_MapUVNodeArray(self, *args)

    def MeshPurpose(self, *args):
        r"""
        Return
        -------
        Poly_MeshPurpose

        Description
        -----------
        Returns mesh purpose bits.

        """
        return _Poly.Poly_Triangulation_MeshPurpose(self, *args)

    def MinMax(self, *args):
        r"""

        Parameters
        ----------
        theBox: Bnd_Box
        theTrsf: gp_Trsf
        theIsAccurate: bool (optional, default to false)

        Return
        -------
        bool

        Description
        -----------
        Extends the passed box with bounding box of this triangulation. uses cached min - max range when available and: - input transformation thetrsf has no rotation part; - theisaccurate is set to false; - no triangulation data available (e.g. it is deferred and not loaded). @param thebox [in] [out] bounding box to extend by this triangulation @param thetrsf [in] optional transformation @param theisaccurate [in] when false, allows using a cached min - max range of this triangulation  even for non-identity transformation. return false if there is no any data to extend the passed box (no both triangulation and cached min - max range).

        """
        return _Poly.Poly_Triangulation_MinMax(self, *args)

    def NbDeferredNodes(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns number of deferred nodes that can be loaded using loaddeferreddata(). note: this is estimated values, which might be different from actually loaded values. always check triangulation size of actually loaded data in code to avoid out-of-range issues.

        """
        return _Poly.Poly_Triangulation_NbDeferredNodes(self, *args)

    def NbDeferredTriangles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns number of deferred triangles that can be loaded using loaddeferreddata(). note: this is estimated values, which might be different from actually loaded values always check triangulation size of actually loaded data in code to avoid out-of-range issues.

        """
        return _Poly.Poly_Triangulation_NbDeferredTriangles(self, *args)

    def NbNodes(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of nodes for this triangulation.

        """
        return _Poly.Poly_Triangulation_NbNodes(self, *args)

    def NbTriangles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of triangles for this triangulation.

        """
        return _Poly.Poly_Triangulation_NbTriangles(self, *args)

    def Node(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        gp_Pnt

        Description
        -----------
        Returns a node at the given index. @param[in] theindex node index within [1, nbnodes()] range return 3d point coordinates.

        """
        return _Poly.Poly_Triangulation_Node(self, *args)

    def Normal(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        gp_Dir

        Description
        -----------
        Returns normal at the given index. @param[in] theindex node index within [1, nbnodes()] range return normalized 3d vector defining a surface normal.

        Parameters
        ----------
        theIndex: int
        theVec3: gp_Vec3f

        Return
        -------
        None

        Description
        -----------
        Returns normal at the given index. @param[in] theindex node index within [1, nbnodes()] range @param[out] thevec3 3d vector defining a surface normal.

        """
        return _Poly.Poly_Triangulation_Normal(self, *args)

    def Parameters(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Poly_TriangulationParameters>

        Description
        -----------
        Returns initial set of parameters used to generate this triangulation.

        Parameters
        ----------
        theParams: Poly_TriangulationParameters

        Return
        -------
        None

        Description
        -----------
        Updates initial set of parameters used to generate this triangulation.

        """
        return _Poly.Poly_Triangulation_Parameters(self, *args)

    def RemoveNormals(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Deallocates the normals array.

        """
        return _Poly.Poly_Triangulation_RemoveNormals(self, *args)

    def RemoveUVNodes(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Deallocates the uv nodes array.

        """
        return _Poly.Poly_Triangulation_RemoveUVNodes(self, *args)

    def ResizeNodes(self, *args):
        r"""

        Parameters
        ----------
        theNbNodes: int
        theToCopyOld: bool

        Return
        -------
        None

        Description
        -----------
        Method resizing internal arrays of nodes (synchronously for all attributes). @param thenbnodes [in] new number of nodes @param thetocopyold [in] copy old nodes into the new array.

        """
        return _Poly.Poly_Triangulation_ResizeNodes(self, *args)

    def ResizeTriangles(self, *args):
        r"""

        Parameters
        ----------
        theNbTriangles: int
        theToCopyOld: bool

        Return
        -------
        None

        Description
        -----------
        Method resizing an internal array of triangles. @param thenbtriangles [in] new number of triangles @param thetocopyold [in] copy old triangles into the new array.

        """
        return _Poly.Poly_Triangulation_ResizeTriangles(self, *args)

    def SetCachedMinMax(self, *args):
        r"""

        Parameters
        ----------
        theBox: Bnd_Box

        Return
        -------
        None

        Description
        -----------
        Sets a cached min - max range of this triangulation. the bounding box should exactly match actual range of triangulation data without a gap or transformation, or otherwise undefined behavior will be observed. passing a void range invalidates the cache.

        """
        return _Poly.Poly_Triangulation_SetCachedMinMax(self, *args)

    def SetDoublePrecision(self, *args):
        r"""

        Parameters
        ----------
        theIsDouble: bool

        Return
        -------
        None

        Description
        -----------
        Set if node positions should be defined with double or single precision for 3d and uv nodes. raises exception if data was already allocated.

        """
        return _Poly.Poly_Triangulation_SetDoublePrecision(self, *args)

    def SetMeshPurpose(self, *args):
        r"""

        Parameters
        ----------
        thePurpose: Poly_MeshPurpose

        Return
        -------
        None

        Description
        -----------
        Sets mesh purpose bits.

        """
        return _Poly.Poly_Triangulation_SetMeshPurpose(self, *args)

    def SetNode(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int
        thePnt: gp_Pnt

        Return
        -------
        None

        Description
        -----------
        Sets a node coordinates. @param[in] theindex node index within [1, nbnodes()] range @param[in] thepnt 3d point coordinates.

        """
        return _Poly.Poly_Triangulation_SetNode(self, *args)

    def SetNormal(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int
        theNormal: gp_Vec3f

        Return
        -------
        None

        Description
        -----------
        Changes normal at the given index. @param[in] theindex node index within [1, nbnodes()] range @param[in] thevec3 normalized 3d vector defining a surface normal.

        Parameters
        ----------
        theIndex: int
        theNormal: gp_Dir

        Return
        -------
        None

        Description
        -----------
        Changes normal at the given index. @param[in] theindex node index within [1, nbnodes()] range @param[in] thenormal normalized 3d vector defining a surface normal.

        """
        return _Poly.Poly_Triangulation_SetNormal(self, *args)

    def SetNormals(self, *args):
        r"""

        Parameters
        ----------
        theNormals: TShort_HArray1OfShortReal

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _Poly.Poly_Triangulation_SetNormals(self, *args)

    def SetTriangle(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int
        theTriangle: Poly_Triangle

        Return
        -------
        None

        Description
        -----------
        Sets a triangle. @param[in] theindex triangle index within [1, nbtriangles()] range @param[in] thetriangle triangle node indices, with each node defined within [1, nbnodes()] range.

        """
        return _Poly.Poly_Triangulation_SetTriangle(self, *args)

    def SetUVNode(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int
        thePnt: gp_Pnt2d

        Return
        -------
        None

        Description
        -----------
        Sets an uv-node coordinates. @param[in] theindex node index within [1, nbnodes()] range @param[in] thepnt uv coordinates.

        """
        return _Poly.Poly_Triangulation_SetUVNode(self, *args)

    def Triangle(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        Poly_Triangle

        Description
        -----------
        Returns triangle at the given index. @param[in] theindex triangle index within [1, nbtriangles()] range return triangle node indices, with each node defined within [1, nbnodes()] range.

        """
        return _Poly.Poly_Triangulation_Triangle(self, *args)

    def Triangles(self, *args):
        r"""
        Return
        -------
        Poly_Array1OfTriangle

        Description
        -----------
        No available documentation.

        """
        return _Poly.Poly_Triangulation_Triangles(self, *args)

    def UVNode(self, *args):
        r"""

        Parameters
        ----------
        theIndex: int

        Return
        -------
        gp_Pnt2d

        Description
        -----------
        Returns uv-node at the given index. @param[in] theindex node index within [1, nbnodes()] range return 2d point defining uv coordinates.

        """
        return _Poly.Poly_Triangulation_UVNode(self, *args)

    def UnloadDeferredData(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Releases triangulation data if it has connected deferred storage.

        """
        return _Poly.Poly_Triangulation_UnloadDeferredData(self, *args)

    def UpdateCachedMinMax(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Updates cached min - max range of this triangulation with bounding box of nodal data.

        """
        return _Poly.Poly_Triangulation_UpdateCachedMinMax(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Poly_Triangulation_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_Triangulation

# Register Poly_Triangulation in _Poly:
_Poly.Poly_Triangulation_swigregister(Poly_Triangulation)
class Poly_TriangulationParameters(OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        theDeflection: float (optional, default to -1)
        theAngle: float (optional, default to -1)
        theMinSize: float (optional, default to -1)

        Return
        -------
        None

        Description
        -----------
        Constructor. initializes object with the given parameters. @param thedeflection linear deflection @param theangle angular deflection @param theminsize minimum size.

        """
        _Poly.Poly_TriangulationParameters_swiginit(self, _Poly.new_Poly_TriangulationParameters(*args))

    def Angle(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns angular deflection or -1 if undefined.

        """
        return _Poly.Poly_TriangulationParameters_Angle(self, *args)

    def Deflection(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns linear deflection or -1 if undefined.

        """
        return _Poly.Poly_TriangulationParameters_Deflection(self, *args)

    def HasAngle(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if angular deflection is defined.

        """
        return _Poly.Poly_TriangulationParameters_HasAngle(self, *args)

    def HasDeflection(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if linear deflection is defined.

        """
        return _Poly.Poly_TriangulationParameters_HasDeflection(self, *args)

    def HasMinSize(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if minimum size is defined.

        """
        return _Poly.Poly_TriangulationParameters_HasMinSize(self, *args)

    def MinSize(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns minimum size or -1 if undefined.

        """
        return _Poly.Poly_TriangulationParameters_MinSize(self, *args)


    @staticmethod
    def DownCast(t):
      return Handle_Poly_TriangulationParameters_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_TriangulationParameters

# Register Poly_TriangulationParameters in _Poly:
_Poly.Poly_TriangulationParameters_swigregister(Poly_TriangulationParameters)

@classnotwrapped
class Poly_CoherentTriPtr:
	pass

@classnotwrapped
class Poly_MakeLoops:
	pass

@classnotwrapped
class Poly_MakeLoops3D:
	pass

@classnotwrapped
class Poly_MakeLoops2D:
	pass


class Poly_HArray1OfTriangle(Poly_Array1OfTriangle, OCC.Core.Standard.Standard_Transient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _Poly.Poly_HArray1OfTriangle_swiginit(self, _Poly.new_Poly_HArray1OfTriangle(*args))

    def Array1(self):
        return _Poly.Poly_HArray1OfTriangle_Array1(self)

    def ChangeArray1(self):
        return _Poly.Poly_HArray1OfTriangle_ChangeArray1(self)


    @staticmethod
    def DownCast(t):
      return Handle_Poly_HArray1OfTriangle_DownCast(t)

    __swig_destroy__ = _Poly.delete_Poly_HArray1OfTriangle

# Register Poly_HArray1OfTriangle in _Poly:
_Poly.Poly_HArray1OfTriangle_swigregister(Poly_HArray1OfTriangle)



@deprecated
def poly_Catenate(*args):
	return poly.Catenate(*args)

@deprecated
def poly_ComputeNormals(*args):
	return poly.ComputeNormals(*args)

@deprecated
def poly_Intersect(*args):
	return poly.Intersect(*args)

@deprecated
def poly_IntersectTriLine(*args):
	return poly.IntersectTriLine(*args)

@deprecated
def poly_PointOnTriangle(*args):
	return poly.PointOnTriangle(*args)

@deprecated
def Poly_MergeNodesTool_MergeNodes(*args):
	return Poly_MergeNodesTool.MergeNodes(*args)



