# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
GeomConvert module, see official documentation at
https://www.opencascade.com/doc/occt-7.7.0/refman/html/package_geomconvert.html
"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _GeomConvert
else:
    import _GeomConvert

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _GeomConvert.delete_SwigPyIterator

    def value(self):
        return _GeomConvert.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _GeomConvert.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _GeomConvert.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _GeomConvert.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _GeomConvert.SwigPyIterator_equal(self, x)

    def copy(self):
        return _GeomConvert.SwigPyIterator_copy(self)

    def next(self):
        return _GeomConvert.SwigPyIterator_next(self)

    def __next__(self):
        return _GeomConvert.SwigPyIterator___next__(self)

    def previous(self):
        return _GeomConvert.SwigPyIterator_previous(self)

    def advance(self, n):
        return _GeomConvert.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _GeomConvert.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _GeomConvert.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _GeomConvert.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _GeomConvert.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _GeomConvert.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _GeomConvert.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _GeomConvert:
_GeomConvert.SwigPyIterator_swigregister(SwigPyIterator)

def _dumps_object(klass):
    """ Overwrite default string output for any wrapped object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    <class 'gp_Pnt'>
    or
    <class 'TopoDS_Shape'>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "<class '" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += ": Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
    elif hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string


def process_exception(error, method_name, class_name):
    return _GeomConvert.process_exception(error, method_name, class_name)

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.NCollection
import OCC.Core.Geom
import OCC.Core.gp
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.TColGeom
import OCC.Core.Convert
import OCC.Core.Adaptor3d
import OCC.Core.TopAbs
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math
import OCC.Core.Message
import OCC.Core.OSD

from enum import IntEnum
from OCC.Core.Exception import *

GeomConvert_Target = _GeomConvert.GeomConvert_Target
GeomConvert_Simplest = _GeomConvert.GeomConvert_Simplest
GeomConvert_MinGap = _GeomConvert.GeomConvert_MinGap


class GeomConvert_ConvType(IntEnum):
	GeomConvert_Target = 0
	GeomConvert_Simplest = 1
	GeomConvert_MinGap = 2
GeomConvert_Target = GeomConvert_ConvType.GeomConvert_Target
GeomConvert_Simplest = GeomConvert_ConvType.GeomConvert_Simplest
GeomConvert_MinGap = GeomConvert_ConvType.GeomConvert_MinGap

class geomconvert(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def C0BSplineToArrayOfC1BSplineCurve(*args):
        r"""

        Parameters
        ----------
        BS: Geom_BSplineCurve
        tabBS: TColGeom_HArray1OfBSplineCurve
        tolerance: float

        Return
        -------
        None

        Description
        -----------
        This method reduces as far as it is possible the multiplicities of the knots of the bspline bs.(keeping the geometry). it returns an array of bspline c1. tolerance is a geometrical tolerance.

        Parameters
        ----------
        BS: Geom_BSplineCurve
        tabBS: TColGeom_HArray1OfBSplineCurve
        AngularTolerance: float
        tolerance: float

        Return
        -------
        None

        Description
        -----------
        This method reduces as far as it is possible the multiplicities of the knots of the bspline bs.(keeping the geometry). it returns an array of bspline c1. tolerance is a geometrical tolerance: it allows for the maximum deformation the angular tolerance is in radians and measures the angle of the tangents on the left and on the right to decide if the curve is c1 or not at a given point.

        """
        return _GeomConvert.geomconvert_C0BSplineToArrayOfC1BSplineCurve(*args)

    @staticmethod
    def C0BSplineToC1BSplineCurve(*args):
        r"""

        Parameters
        ----------
        BS: Geom_BSplineCurve
        tolerance: float
        AngularTolerance: float (optional, default to 1.0e-7)

        Return
        -------
        None

        Description
        -----------
        This method reduces as far as it is possible the multiplicities of the knots of the bspline bs.(keeping the geometry). it returns a new bspline which could still be c0. tolerance is a geometrical tolerance. the angular toleranceis in radians and measures the angle of the tangents on the left and on the right to decide if the curve is g1 or not at a given point.

        """
        return _GeomConvert.geomconvert_C0BSplineToC1BSplineCurve(*args)

    @staticmethod
    def ConcatC1(*args):
        r"""

        Parameters
        ----------
        ArrayOfCurves: TColGeom_Array1OfBSplineCurve
        ArrayOfToler: TColStd_Array1OfReal
        ArrayOfIndices: TColStd_HArray1OfInteger
        ArrayOfConcatenated: TColGeom_HArray1OfBSplineCurve
        ClosedTolerance: float

        Return
        -------
        ClosedFlag: bool

        Description
        -----------
        This method concatenates c1 the arrayofcurves as far as it is possible. arrayofcurves[0..n-1] arrayoftoler contains the biggest tolerance of the two points shared by two consecutives curves. its dimension: [0..n-2] closedflag indicates if the arrayofcurves is closed. in this case closedtolerance contains the biggest tolerance of the two points which are at the closure. otherwise its value is 0.0 closedflag becomes false on the output if it is impossible to build closed curve.

        Parameters
        ----------
        ArrayOfCurves: TColGeom_Array1OfBSplineCurve
        ArrayOfToler: TColStd_Array1OfReal
        ArrayOfIndices: TColStd_HArray1OfInteger
        ArrayOfConcatenated: TColGeom_HArray1OfBSplineCurve
        ClosedTolerance: float
        AngularTolerance: float

        Return
        -------
        ClosedFlag: bool

        Description
        -----------
        This method concatenates c1 the arrayofcurves as far as it is possible. arrayofcurves[0..n-1] arrayoftoler contains the biggest tolerance of the two points shared by two consecutives curves. its dimension: [0..n-2] closedflag indicates if the arrayofcurves is closed. in this case closedtolerance contains the biggest tolerance of the two points which are at the closure. otherwise its value is 0.0 closedflag becomes false on the output if it is impossible to build closed curve.

        """
        return _GeomConvert.geomconvert_ConcatC1(*args)

    @staticmethod
    def ConcatG1(*args):
        r"""

        Parameters
        ----------
        ArrayOfCurves: TColGeom_Array1OfBSplineCurve
        ArrayOfToler: TColStd_Array1OfReal
        ArrayOfConcatenated: TColGeom_HArray1OfBSplineCurve
        ClosedTolerance: float

        Return
        -------
        ClosedFlag: bool

        Description
        -----------
        This method concatenates g1 the arrayofcurves as far as it is possible. arrayofcurves[0..n-1] arrayoftoler contains the biggest tolerance of the two points shared by two consecutives curves. its dimension: [0..n-2] closedflag indicates if the arrayofcurves is closed. in this case closedtolerance contains the biggest tolerance of the two points which are at the closure. otherwise its value is 0.0 closedflag becomes false on the output if it is impossible to build closed curve.

        """
        return _GeomConvert.geomconvert_ConcatG1(*args)

    @staticmethod
    def CurveToBSplineCurve(*args):
        r"""

        Parameters
        ----------
        C: Geom_Curve
        Parameterisation: Convert_ParameterisationType (optional, default to Convert_TgtThetaOver2)

        Return
        -------
        opencascade::handle<Geom_BSplineCurve>

        Description
        -----------
        This function converts a non infinite curve from geom into a b-spline curve. c must be an ellipse or a circle or a trimmed conic or a trimmed line or a bezier curve or a trimmed bezier curve or a bspline curve or a trimmed bspline curve or an offsetcurve. the returned b-spline is not periodic except if c is a circle or an ellipse. if the parameterisation is quasiangular than the returned curve is not periodic in case a periodic geom_circle or geom_ellipse. for tgtthetaover2_1 and tgtthetaover2_2 the method raises an exception in case of a periodic geom_circle or a geom_ellipse parameterisationtype applies only if the curve is a circle or an ellipse: tgtthetaover2, -- tgtthetaover2_1, -- tgtthetaover2_2, -- tgtthetaover2_3, -- tgtthetaover2_4, //! purpose: this is the classical rational parameterisation 2 1 - t cos(theta) = ------ 2 1 + t //! 2t sin(theta) = ------ 2 1 + t //! t = tan (theta/2) //! with tgtthetaover2 the routine will compute the number of spans using the rule num_spans = [ (ulast - ufirst) / 1.2 ] + 1 with tgtthetaover2_n, n spans will be forced: an error will be raized if (ulast - ufirst) >= pi and n = 1, ulast - ufirst >= 2 pi and n = 2 //! quasiangular, here t is a rational function that approximates theta ----> tan(theta/2). nevetheless the composing with above function yields exact functions whose square sum up to 1 rationalc1 ; t is replaced by a polynomial function of u so as to grant c1 contiuity across knots. exceptions standard_domainerror: - if the curve c is infinite, or - if c is a (complete) circle or ellipse, and parameterisation is equal to convert_tgtthetaover2_1 or convert_tgtthetaover2_2. standard_constructionerror: - if c is a (complete) circle or ellipse, and if parameterisation is not equal to convert_tgtthetaover2, convert_rationalc1, convert_quasiangular (the curve is converted in these three cases) or to convert_tgtthetaover2_1 or convert_tgtthetaover2_2 (another exception is raised in these two cases). - if c is a trimmed circle or ellipse, if parameterisation is equal to convert_tgtthetaover2_1 and if u2 - u1 > 0.9999 * pi, where u1 and u2 are respectively the first and the last parameters of the trimmed curve (this method of parameterization cannot be used to convert a half-circle or a half-ellipse, for example), or - if c is a trimmed circle or ellipse, if parameterisation is equal to convert_tgtthetaover2_2 and u2 - u1 > 1.9999 * pi where u1 and u2 are respectively the first and the last parameters of the trimmed curve (this method of parameterization cannot be used to convert a quasi-complete circle or ellipse).

        """
        return _GeomConvert.geomconvert_CurveToBSplineCurve(*args)

    @staticmethod
    def SplitBSplineCurve(*args):
        r"""

        Parameters
        ----------
        C: Geom_BSplineCurve
        FromK1: int
        ToK2: int
        SameOrientation: bool (optional, default to Standard_True)

        Return
        -------
        opencascade::handle<Geom_BSplineCurve>

        Description
        -----------
        Convert a curve from geom by an approximation method //! this method computes the arc of b-spline curve between the two knots fromk1 and tok2. if c is periodic the arc has the same orientation as c if sameorientation = standard_true. if c is not periodic sameorientation is not used for the computation and c is oriented from the knot fromk1 to the knot tok2. we just keep the local definition of c between the knots fromk1 and tok2. the returned b-spline curve has its first and last knots with a multiplicity equal to degree + 1, where degree is the polynomial degree of c. the indexes of the knots fromk1 and tok2 doesn't include the repetition of multiple knots in their definition. raised if fromk1 = tok2 raised if fromk1 or tok2 are out of the bounds [firstuknotindex, lastuknotindex].

        Parameters
        ----------
        C: Geom_BSplineCurve
        FromU1: float
        ToU2: float
        ParametricTolerance: float
        SameOrientation: bool (optional, default to Standard_True)

        Return
        -------
        opencascade::handle<Geom_BSplineCurve>

        Description
        -----------
        This function computes the segment of b-spline curve between the parametric values fromu1, tou2. if c is periodic the arc has the same orientation as c if sameorientation = true. if c is not periodic sameorientation is not used for the computation and c is oriented fromu1 tou2. if u1 and u2 and two parametric values we consider that u1 = u2 if abs (u1 - u2) <= parametrictolerance and parametrictolerance must be greater or equal to resolution from package gp. //! raised if fromu1 or tou2 are out of the parametric bounds of the curve (the tolerance criterion is parametrictolerance). raised if abs (fromu1 - tou2) <= parametrictolerance raised if parametrictolerance < resolution from gp.

        """
        return _GeomConvert.geomconvert_SplitBSplineCurve(*args)

    @staticmethod
    def SplitBSplineSurface(*args):
        r"""

        Parameters
        ----------
        S: Geom_BSplineSurface
        FromUK1: int
        ToUK2: int
        FromVK1: int
        ToVK2: int
        SameUOrientation: bool (optional, default to Standard_True)
        SameVOrientation: bool (optional, default to Standard_True)

        Return
        -------
        opencascade::handle<Geom_BSplineSurface>

        Description
        -----------
        Computes the b-spline surface patche between the knots values fromuk1, touk2, fromvk1, tovk2. if s is periodic in one direction the patche has the same orientation as s in this direction if the flag is true in this direction (sameuorientation, samevorientation). if s is not periodic sameuorientation and samevorientation are not used for the computation and s is oriented fromuk1 touk2 and fromvk1 tovk2. raised if fromuk1 = touk2 or fromvk1 = tovk2 fromuk1 or touk2 are out of the bounds [firstuknotindex, lastuknotindex] fromvk1 or tovk2 are out of the bounds [firstvknotindex, lastvknotindex].

        Parameters
        ----------
        S: Geom_BSplineSurface
        FromK1: int
        ToK2: int
        USplit: bool
        SameOrientation: bool (optional, default to Standard_True)

        Return
        -------
        opencascade::handle<Geom_BSplineSurface>

        Description
        -----------
        This method splits a b-spline surface patche between the knots values fromk1, tok2 in one direction. if usplit = true then the splitting direction is the u parametric direction else it is the v parametric direction. if s is periodic in the considered direction the patche has the same orientation as s in this direction if sameorientation is true if s is not periodic in this direction sameorientation is not used for the computation and s is oriented fromk1 tok2. raised if fromk1 = tok2 or if fromk1 or tok2 are out of the bounds [firstuknotindex, lastuknotindex] in the considered parametric direction.

        Parameters
        ----------
        S: Geom_BSplineSurface
        FromU1: float
        ToU2: float
        FromV1: float
        ToV2: float
        ParametricTolerance: float
        SameUOrientation: bool (optional, default to Standard_True)
        SameVOrientation: bool (optional, default to Standard_True)

        Return
        -------
        opencascade::handle<Geom_BSplineSurface>

        Description
        -----------
        This method computes the b-spline surface patche between the parametric values fromu1, tou2, fromv1, tov2. if s is periodic in one direction the patche has the same orientation as s in this direction if the flag is true in this direction (sameuorientation, samevorientation). if s is not periodic sameuorientation and samevorientation are not used for the computation and s is oriented fromu1 tou2 and fromv1 tov2. if u1 and u2 and two parametric values we consider that u1 = u2 if abs (u1 - u2) <= parametrictolerance and parametrictolerance must be greater or equal to resolution from package gp. //! raised if fromu1 or tou2 or fromv1 or tou2 are out of the parametric bounds of the surface (the tolerance criterion is parametrictolerance). raised if abs (fromu1 - tou2) <= parametrictolerance or abs (fromv1 - tov2) <= parametrictolerance. raised if parametrictolerance < resolution.

        Parameters
        ----------
        S: Geom_BSplineSurface
        FromParam1: float
        ToParam2: float
        USplit: bool
        ParametricTolerance: float
        SameOrientation: bool (optional, default to Standard_True)

        Return
        -------
        opencascade::handle<Geom_BSplineSurface>

        Description
        -----------
        This method splits the b-spline surface s in one direction between the parametric values fromparam1, toparam2. if usplit = true then the splitting direction is the u parametric direction else it is the v parametric direction. if s is periodic in the considered direction the patche has the same orientation as s in this direction if sameorientation is true. if s is not periodic in the considered direction sameorientation is not used for the computation and s is oriented fromparam1 toparam2. if u1 and u2 and two parametric values we consider that u1 = u2 if abs (u1 - u2) <= parametrictolerance and parametrictolerance must be greater or equal to resolution from package gp. //! raises if fromparam1 or toparam2 are out of the parametric bounds of the surface in the considered direction. raises if abs (fromparam1 - toparam2) <= parametrictolerance.

        """
        return _GeomConvert.geomconvert_SplitBSplineSurface(*args)

    @staticmethod
    def SurfaceToBSplineSurface(*args):
        r"""

        Parameters
        ----------
        S: Geom_Surface

        Return
        -------
        opencascade::handle<Geom_BSplineSurface>

        Description
        -----------
        This algorithm converts a non infinite surface from geom into a b-spline surface. s must be a trimmed plane or a trimmed cylinder or a trimmed cone or a trimmed sphere or a trimmed torus or a sphere or a torus or a bezier surface of a trimmed bezier surface or a trimmed swept surface with a corresponding basis curve which can be turned into a b-spline curve (see the method curvetobsplinecurve). raises domainerror if the type of the surface is not previously defined.

        """
        return _GeomConvert.geomconvert_SurfaceToBSplineSurface(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _GeomConvert.geomconvert_swiginit(self, _GeomConvert.new_geomconvert())
    __swig_destroy__ = _GeomConvert.delete_geomconvert

# Register geomconvert in _GeomConvert:
_GeomConvert.geomconvert_swigregister(geomconvert)
class GeomConvert_ApproxCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Curve: Geom_Curve
        Tol3d: float
        Order: GeomAbs_Shape
        MaxSegments: int
        MaxDegree: int

        Return
        -------
        None

        Description
        -----------
        Constructs a curve approximation framework defined by - - the conic curve, - the tolerance value tol3d, - the degree of continuity order, - the maximum number of segments maxsegments allowed in the resulting bspline curve, and - the highest degree maxdeg which the polynomial defining the bspline curve may have.

        Parameters
        ----------
        Curve: Adaptor3d_Curve
        Tol3d: float
        Order: GeomAbs_Shape
        MaxSegments: int
        MaxDegree: int

        Return
        -------
        None

        Description
        -----------
        Constructs a curve approximation framework defined by - - the curve, - the tolerance value tol3d, - the degree of continuity order, - the maximum number of segments maxsegments allowed in the resulting bspline curve, and - the highest degree maxdeg which the polynomial defining the bspline curve may have.

        """
        _GeomConvert.GeomConvert_ApproxCurve_swiginit(self, _GeomConvert.new_GeomConvert_ApproxCurve(*args))

    def Curve(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_BSplineCurve>

        Description
        -----------
        Returns the bspline curve resulting from the approximation algorithm.

        """
        return _GeomConvert.GeomConvert_ApproxCurve_Curve(self, *args)

    def DumpToString(self):
        r"""DumpToString(GeomConvert_ApproxCurve self) -> std::string"""
        return _GeomConvert.GeomConvert_ApproxCurve_DumpToString(self)

    def HasResult(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns standard_true if the approximation did come out with a result that is not necessarely within the required tolerance.

        """
        return _GeomConvert.GeomConvert_ApproxCurve_HasResult(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns standard_true if the approximation has been done within required tolerance.

        """
        return _GeomConvert.GeomConvert_ApproxCurve_IsDone(self, *args)

    def MaxError(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the greatest distance between a point on the source conic and the bspline curve resulting from the approximation. (>0 when an approximation has been done, 0 if no approximation).

        """
        return _GeomConvert.GeomConvert_ApproxCurve_MaxError(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomConvert.delete_GeomConvert_ApproxCurve

# Register GeomConvert_ApproxCurve in _GeomConvert:
_GeomConvert.GeomConvert_ApproxCurve_swigregister(GeomConvert_ApproxCurve)
class GeomConvert_ApproxSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Surf: Geom_Surface
        Tol3d: float
        UContinuity: GeomAbs_Shape
        VContinuity: GeomAbs_Shape
        MaxDegU: int
        MaxDegV: int
        MaxSegments: int
        PrecisCode: int

        Return
        -------
        None

        Description
        -----------
        Constructs a surface approximation framework defined by - the conic surf - the tolerance value tol3d - the degree of continuity ucontinuity, vcontinuity in the directions of the u and v parameters - the highest degree maxdegu, maxdegv which the polynomial defining the bspline curve may have in the directions of the u and v parameters - the maximum number of segments maxsegments allowed in the resulting bspline curve - the index of precision preciscode.

        Parameters
        ----------
        Surf: Adaptor3d_Surface
        Tol3d: float
        UContinuity: GeomAbs_Shape
        VContinuity: GeomAbs_Shape
        MaxDegU: int
        MaxDegV: int
        MaxSegments: int
        PrecisCode: int

        Return
        -------
        None

        Description
        -----------
        Constructs a surface approximation framework defined by - the surf - the tolerance value tol3d - the degree of continuity ucontinuity, vcontinuity in the directions of the u and v parameters - the highest degree maxdegu, maxdegv which the polynomial defining the bspline curve may have in the directions of the u and v parameters - the maximum number of segments maxsegments allowed in the resulting bspline curve - the index of precision preciscode.

        """
        _GeomConvert.GeomConvert_ApproxSurface_swiginit(self, _GeomConvert.new_GeomConvert_ApproxSurface(*args))

    def DumpToString(self):
        r"""DumpToString(GeomConvert_ApproxSurface self) -> std::string"""
        return _GeomConvert.GeomConvert_ApproxSurface_DumpToString(self)

    def HasResult(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the approximation did come out with a result that is not necessarily within the required tolerance or a result that is not recognized with the wished continuities.

        """
        return _GeomConvert.GeomConvert_ApproxSurface_HasResult(self, *args)

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns standard_true if the approximation has be done.

        """
        return _GeomConvert.GeomConvert_ApproxSurface_IsDone(self, *args)

    def MaxError(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns the greatest distance between a point on the source conic surface and the bspline surface resulting from the approximation (>0 when an approximation has been done, 0 if no approximation ).

        """
        return _GeomConvert.GeomConvert_ApproxSurface_MaxError(self, *args)

    def Surface(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_BSplineSurface>

        Description
        -----------
        Returns the bspline surface resulting from the approximation algorithm.

        """
        return _GeomConvert.GeomConvert_ApproxSurface_Surface(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomConvert.delete_GeomConvert_ApproxSurface

# Register GeomConvert_ApproxSurface in _GeomConvert:
_GeomConvert.GeomConvert_ApproxSurface_swigregister(GeomConvert_ApproxSurface)
class GeomConvert_BSplineCurveKnotSplitting(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        BasisCurve: Geom_BSplineCurve
        ContinuityRange: int

        Return
        -------
        None

        Description
        -----------
        Determines points at which the bspline curve basiscurve should be split in order to obtain arcs with a degree of continuity equal to continuityrange. these points are knot values of basiscurve. they are identified by indices in the knots table of basiscurve. use the available interrogation functions to access computed values, followed by the global function splitbsplinecurve (provided by the package geomconvert) to split the curve. exceptions standard_rangeerror if continuityrange is less than zero.

        """
        _GeomConvert.GeomConvert_BSplineCurveKnotSplitting_swiginit(self, _GeomConvert.new_GeomConvert_BSplineCurveKnotSplitting(*args))

    def NbSplits(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of points at which the analyzed bspline curve should be split, in order to obtain arcs with the continuity required by this framework. all these points correspond to knot values. note that the first and last points of the curve, which bound the first and last arcs, are counted among these splitting points.

        """
        return _GeomConvert.GeomConvert_BSplineCurveKnotSplitting_NbSplits(self, *args)

    def SplitValue(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        int

        Description
        -----------
        Returns the split knot of index index to the split knots table computed in this framework. the returned value is an index in the knots table of the bspline curve analyzed by this algorithm. notes: - if index is equal to 1, the corresponding knot gives the first point of the curve. - if index is equal to the number of split knots computed in this framework, the corresponding point is the last point of the curve. exceptions standard_rangeerror if index is less than 1 or greater than the number of split knots computed in this framework.

        """
        return _GeomConvert.GeomConvert_BSplineCurveKnotSplitting_SplitValue(self, *args)

    def Splitting(self, *args):
        r"""

        Parameters
        ----------
        SplitValues: TColStd_Array1OfInteger

        Return
        -------
        None

        Description
        -----------
        Loads the splitvalues table with the split knots values computed in this framework. each value in the table is an index in the knots table of the bspline curve analyzed by this algorithm. the values in splitvalues are given in ascending order and comprise the indices of the knots which give the first and last points of the curve. use two consecutive values from the table as arguments of the global function splitbsplinecurve (provided by the package geomconvert) to split the curve. exceptions standard_dimensionerror if the array splitvalues was not created with the following bounds: - 1, and - the number of split points computed in this framework (as given by the function nbsplits).

        """
        return _GeomConvert.GeomConvert_BSplineCurveKnotSplitting_Splitting(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomConvert.delete_GeomConvert_BSplineCurveKnotSplitting

# Register GeomConvert_BSplineCurveKnotSplitting in _GeomConvert:
_GeomConvert.GeomConvert_BSplineCurveKnotSplitting_swigregister(GeomConvert_BSplineCurveKnotSplitting)
class GeomConvert_BSplineCurveToBezierCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        BasisCurve: Geom_BSplineCurve

        Return
        -------
        None

        Description
        -----------
        Computes all the data needed to convert the bspline curve basiscurve into a series of adjacent bezier arcs.

        Parameters
        ----------
        BasisCurve: Geom_BSplineCurve
        U1: float
        U2: float
        ParametricTolerance: float

        Return
        -------
        None

        Description
        -----------
        Computes all the data needed to convert the portion of the bspline curve basiscurve limited by the two parameter values u1 and u2 into a series of adjacent bezier arcs. the result consists of a series of basiscurve arcs limited by points corresponding to knot values of the curve. use the available interrogation functions to ascertain the number of computed bezier arcs, and then to construct each individual bezier curve (or all bezier curves). note: parametrictolerance is not used. raises domainerror if u1 or u2 are out of the parametric bounds of the basis curve [firstparameter, lastparameter]. the tolerance criterion is parametrictolerance. raised if abs (u2 - u1) <= parametrictolerance.

        """
        _GeomConvert.GeomConvert_BSplineCurveToBezierCurve_swiginit(self, _GeomConvert.new_GeomConvert_BSplineCurveToBezierCurve(*args))

    def Arc(self, *args):
        r"""

        Parameters
        ----------
        Index: int

        Return
        -------
        opencascade::handle<Geom_BezierCurve>

        Description
        -----------
        Constructs and returns the bezier curve of index index to the table of adjacent bezier arcs computed by this algorithm. this bezier curve has the same orientation as the bspline curve analyzed in this framework. exceptions standard_outofrange if index is less than 1 or greater than the number of adjacent bezier arcs computed by this algorithm.

        """
        return _GeomConvert.GeomConvert_BSplineCurveToBezierCurve_Arc(self, *args)

    def Arcs(self, *args):
        r"""

        Parameters
        ----------
        Curves: TColGeom_Array1OfBezierCurve

        Return
        -------
        None

        Description
        -----------
        Constructs all the bezier curves whose data is computed by this algorithm and loads these curves into the curves table. the bezier curves have the same orientation as the bspline curve analyzed in this framework. exceptions standard_dimensionerror if the curves array was not created with the following bounds: - 1 , and - the number of adjacent bezier arcs computed by this algorithm (as given by the function nbarcs).

        """
        return _GeomConvert.GeomConvert_BSplineCurveToBezierCurve_Arcs(self, *args)

    def Knots(self, *args):
        r"""

        Parameters
        ----------
        TKnots: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        This methode returns the bspline's knots associated to the converted arcs raised if the length of curves is not equal to nbarcs + 1.

        """
        return _GeomConvert.GeomConvert_BSplineCurveToBezierCurve_Knots(self, *args)

    def NbArcs(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of beziercurve arcs. if at the creation time you have decomposed the basis curve between the parametric values ufirst, ulast the number of beziercurve arcs depends on the number of knots included inside the interval [ufirst, ulast]. if you have decomposed the whole basis b-spline curve the number of beziercurve arcs nbarcs is equal to the number of knots less one.

        """
        return _GeomConvert.GeomConvert_BSplineCurveToBezierCurve_NbArcs(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomConvert.delete_GeomConvert_BSplineCurveToBezierCurve

# Register GeomConvert_BSplineCurveToBezierCurve in _GeomConvert:
_GeomConvert.GeomConvert_BSplineCurveToBezierCurve_swigregister(GeomConvert_BSplineCurveToBezierCurve)
class GeomConvert_BSplineSurfaceKnotSplitting(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        BasisSurface: Geom_BSplineSurface
        UContinuityRange: int
        VContinuityRange: int

        Return
        -------
        None

        Description
        -----------
        Determines the u- and v-isoparametric curves along which the bspline surface basissurface should be split in order to obtain patches with a degree of continuity equal to ucontinuityrange in the u parametric direction, and to vcontinuityrange in the v parametric direction. these isoparametric curves are defined by parameters, which are basissurface knot values in the u or v parametric direction. they are identified by indices in the basissurface knots table in the corresponding parametric direction. use the available interrogation functions to access computed values, followed by the global function splitbsplinesurface (provided by the package geomconvert) to split the surface. exceptions standard_rangeerror if ucontinuityrange or vcontinuityrange is less than zero.

        """
        _GeomConvert.GeomConvert_BSplineSurfaceKnotSplitting_swiginit(self, _GeomConvert.new_GeomConvert_BSplineSurfaceKnotSplitting(*args))

    def NbUSplits(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of u-isoparametric curves along which the analysed bspline surface should be split in order to obtain patches with the continuity required by this framework. the parameters which define these curves are knot values in the corresponding parametric direction. note that the four curves which bound the surface are counted among these splitting curves.

        """
        return _GeomConvert.GeomConvert_BSplineSurfaceKnotSplitting_NbUSplits(self, *args)

    def NbVSplits(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of v-isoparametric curves along which the analysed bspline surface should be split in order to obtain patches with the continuity required by this framework. the parameters which define these curves are knot values in the corresponding parametric direction. note that the four curves which bound the surface are counted among these splitting curves.

        """
        return _GeomConvert.GeomConvert_BSplineSurfaceKnotSplitting_NbVSplits(self, *args)

    def Splitting(self, *args):
        r"""

        Parameters
        ----------
        USplit: TColStd_Array1OfInteger
        VSplit: TColStd_Array1OfInteger

        Return
        -------
        None

        Description
        -----------
        Loads the usplit and vsplit tables with the split knots values computed in this framework. each value in these tables is an index in the knots table corresponding to the u or v parametric direction of the bspline surface analysed by this algorithm. the usplit and vsplit values are given in ascending order and comprise the indices of the knots which give the first and last isoparametric curves of the surface in the corresponding parametric direction. use two consecutive values from the usplit table and two consecutive values from the vsplit table as arguments of the global function splitbsplinesurface (provided by the package geomconvert) to split the surface. exceptions standard_dimensionerror if: - the array usplit was not created with the following bounds: - 1 , and - the number of split knots in the u parametric direction computed in this framework (as given by the function nbusplits); or - the array vsplit was not created with the following bounds: - 1 , and - the number of split knots in the v parametric direction computed in this framework (as given by the function nbvsplits).

        """
        return _GeomConvert.GeomConvert_BSplineSurfaceKnotSplitting_Splitting(self, *args)

    def USplitValue(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int

        Return
        -------
        int

        Description
        -----------
        Returns the split knot of index uindex to the split knots table for the u parametric direction computed in this framework. the returned value is an index in the knots table relative to the u parametric direction of the bspline surface analysed by this algorithm. note: if uindex is equal to 1, or to the number of split knots for the u parametric direction computed in this framework, the corresponding knot gives the parameter of one of the bounding curves of the surface. exceptions standard_rangeerror if uindex is less than 1 or greater than the number of split knots for the u parametric direction computed in this framework.

        """
        return _GeomConvert.GeomConvert_BSplineSurfaceKnotSplitting_USplitValue(self, *args)

    def VSplitValue(self, *args):
        r"""

        Parameters
        ----------
        VIndex: int

        Return
        -------
        int

        Description
        -----------
        Returns the split knot of index vindex to the split knots table for the v parametric direction computed in this framework. the returned value is an index in the knots table relative to the v parametric direction of the bspline surface analysed by this algorithm. note: if uindex is equal to 1, or to the number of split knots for the v parametric direction computed in this framework, the corresponding knot gives the parameter of one of the bounding curves of the surface. exceptions standard_rangeerror if vindex is less than 1 or greater than the number of split knots for the v parametric direction computed in this framework.

        """
        return _GeomConvert.GeomConvert_BSplineSurfaceKnotSplitting_VSplitValue(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomConvert.delete_GeomConvert_BSplineSurfaceKnotSplitting

# Register GeomConvert_BSplineSurfaceKnotSplitting in _GeomConvert:
_GeomConvert.GeomConvert_BSplineSurfaceKnotSplitting_swigregister(GeomConvert_BSplineSurfaceKnotSplitting)
class GeomConvert_BSplineSurfaceToBezierSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        BasisSurface: Geom_BSplineSurface

        Return
        -------
        None

        Description
        -----------
        Computes all the data needed to convert - the bspline surface basissurface into a series of adjacent bezier surfaces. the result consists of a grid of basissurface patches limited by isoparametric curves corresponding to knot values, both in the u and v parametric directions of the surface. a row in the grid corresponds to a series of adjacent patches, all limited by the same two u-isoparametric curves. a column in the grid corresponds to a series of adjacent patches, all limited by the same two v-isoparametric curves. use the available interrogation functions to ascertain the number of computed bezier patches, and then to construct each individual bezier surface (or all bezier surfaces). note: parametrictolerance is not used.

        Parameters
        ----------
        BasisSurface: Geom_BSplineSurface
        U1: float
        U2: float
        V1: float
        V2: float
        ParametricTolerance: float

        Return
        -------
        None

        Description
        -----------
        Computes all the data needed to convert the patch of the bspline surface basissurface limited by the two parameter values u1 and u2 in the u parametric direction, and by the two parameter values v1 and v2 in the v parametric direction, into a series of adjacent bezier surfaces. the result consists of a grid of basissurface patches limited by isoparametric curves corresponding to knot values, both in the u and v parametric directions of the surface. a row in the grid corresponds to a series of adjacent patches, all limited by the same two u-isoparametric curves. a column in the grid corresponds to a series of adjacent patches, all limited by the same two v-isoparametric curves. use the available interrogation functions to ascertain the number of computed bezier patches, and then to construct each individual bezier surface (or all bezier surfaces). note: parametrictolerance is not used. raises domainerror if u1 or u2 or v1 or v2 are out of the parametric bounds of the basis surface [firstuknotindex, lastuknotindex] , [firstvknotindex, lastvknotindex] the tolerance criterion is parametrictolerance. raised if u2 - u1 <= parametrictolerance or v2 - v1 <= parametrictolerance.

        """
        _GeomConvert.GeomConvert_BSplineSurfaceToBezierSurface_swiginit(self, _GeomConvert.new_GeomConvert_BSplineSurfaceToBezierSurface(*args))

    def NbUPatches(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of bezier surfaces in the u direction. if at the creation time you have decomposed the basis surface between the parametric values ufirst, ulast the number of bezier surfaces in the u direction depends on the number of knots included inside the interval [ufirst, ulast]. if you have decomposed the whole basis b-spline surface the number of bezier surfaces nbupatches is equal to the number of uknots less one.

        """
        return _GeomConvert.GeomConvert_BSplineSurfaceToBezierSurface_NbUPatches(self, *args)

    def NbVPatches(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of bezier surfaces in the v direction. if at the creation time you have decomposed the basis surface between the parametric values vfirst, vlast the number of bezier surfaces in the v direction depends on the number of knots included inside the interval [vfirst, vlast]. if you have decomposed the whole basis b-spline surface the number of bezier surfaces nbvpatches is equal to the number of vknots less one.

        """
        return _GeomConvert.GeomConvert_BSplineSurfaceToBezierSurface_NbVPatches(self, *args)

    def Patch(self, *args):
        r"""

        Parameters
        ----------
        UIndex: int
        VIndex: int

        Return
        -------
        opencascade::handle<Geom_BezierSurface>

        Description
        -----------
        Constructs and returns the bezier surface of indices (uindex, vindex) to the patch grid computed on the bspline surface analyzed by this algorithm. this bezier surface has the same orientation as the bspline surface analyzed in this framework. uindex is an index common to a row in the patch grid. a row in the grid corresponds to a series of adjacent patches, all limited by the same two u-isoparametric curves of the surface. vindex is an index common to a column in the patch grid. a column in the grid corresponds to a series of adjacent patches, all limited by the same two v-isoparametric curves of the surface. exceptions standard_outofrange if: - uindex is less than 1 or greater than the number of rows in the patch grid computed on the bspline surface analyzed by this algorithm (as returned by the function nbupatches); or if - vindex is less than 1 or greater than the number of columns in the patch grid computed on the bspline surface analyzed by this algorithm (as returned by the function nbvpatches).

        """
        return _GeomConvert.GeomConvert_BSplineSurfaceToBezierSurface_Patch(self, *args)

    def Patches(self, *args):
        r"""

        Parameters
        ----------
        Surfaces: TColGeom_Array2OfBezierSurface

        Return
        -------
        None

        Description
        -----------
        Constructs all the bezier surfaces whose data is computed by this algorithm, and loads them into the surfaces table. these bezier surfaces have the same orientation as the bspline surface analyzed in this framework. the surfaces array is organised in the same way as the patch grid computed on the bspline surface analyzed by this algorithm. a row in the array corresponds to a series of adjacent patches, all limited by the same two u-isoparametric curves of the surface. a column in the array corresponds to a series of adjacent patches, all limited by the same two v-isoparametric curves of the surface. exceptions standard_dimensionerror if the surfaces array was not created with the following bounds: - 1, and the number of adjacent patch series in the u parametric direction of the patch grid computed on the bspline surface, analyzed by this algorithm (as given by the function nbupatches) as row bounds, - 1, and the number of adjacent patch series in the v parametric direction of the patch grid computed on the bspline surface, analyzed by this algorithm (as given by the function nbvpatches) as column bounds.

        """
        return _GeomConvert.GeomConvert_BSplineSurfaceToBezierSurface_Patches(self, *args)

    def UKnots(self, *args):
        r"""

        Parameters
        ----------
        TKnots: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        This methode returns the bspline's u-knots associated to the converted patches raised if the length of curves is not equal to nbupatches + 1.

        """
        return _GeomConvert.GeomConvert_BSplineSurfaceToBezierSurface_UKnots(self, *args)

    def VKnots(self, *args):
        r"""

        Parameters
        ----------
        TKnots: TColStd_Array1OfReal

        Return
        -------
        None

        Description
        -----------
        This methode returns the bspline's v-knots associated to the converted patches raised if the length of curves is not equal to nbvpatches + 1.

        """
        return _GeomConvert.GeomConvert_BSplineSurfaceToBezierSurface_VKnots(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomConvert.delete_GeomConvert_BSplineSurfaceToBezierSurface

# Register GeomConvert_BSplineSurfaceToBezierSurface in _GeomConvert:
_GeomConvert.GeomConvert_BSplineSurfaceToBezierSurface_swigregister(GeomConvert_BSplineSurfaceToBezierSurface)
class GeomConvert_CompBezierSurfacesToBSplineSurface(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Beziers: TColGeom_Array2OfBezierSurface

        Return
        -------
        None

        Description
        -----------
        Computes all the data needed to build a 'c0' continuous bspline surface equivalent to the grid of adjacent non-rational bezier surfaces beziers. each surface in the beziers grid becomes a natural patch, limited by knots values, on the bspline surface whose data is computed. surfaces in the grid must satisfy the following conditions: - coincident bounding curves between two consecutive surfaces in a row of the beziers grid must be u-isoparametric bounding curves of these two surfaces. - coincident bounding curves between two consecutive surfaces in a column of the beziers grid must be v-isoparametric bounding curves of these two surfaces. the bspline surface whose data is computed has the following characteristics: - its degree in the u (respectively v) parametric direction is equal to that of the bezier surface which has the highest degree in the u (respectively v) parametric direction in the beziers grid. - it is a 'piecewise bezier' in both u and v parametric directions, i.e.: - the knots are regularly spaced in each parametric direction (i.e. the difference between two consecutive knots is a constant), and - all the multiplicities of the surface knots in a given parametric direction are equal to degree, which is the degree of the bspline surface in this parametric direction, except for the first and last knots for which the multiplicity is equal to degree + 1. - coincident bounding curves between two consecutive columns of bezier surfaces in the beziers grid become u-isoparametric curves, corresponding to knots values of the bspline surface. - coincident bounding curves between two consecutive rows of bezier surfaces in the beziers grid become v-isoparametric curves corresponding to knots values of the bspline surface. use the available consultation functions to access the computed data. this data may be used to construct the bspline surface. warning the surfaces in the beziers grid must be adjacent, i.e. two consecutive bezier surfaces in the grid (in a row or column) must have a coincident bounding curve. in addition, the location of the parameterization on each of these surfaces (i.e. the relative location of u and v isoparametric curves on the surface) is of importance with regard to the positioning of the surfaces in the beziers grid. care must be taken with respect to the above, as these properties are not checked and an error may occur if they are not satisfied. exceptions standard_notimplemented if one of the bezier surfaces of the beziers grid is rational.

        Parameters
        ----------
        Beziers: TColGeom_Array2OfBezierSurface
        Tolerance: float
        RemoveKnots: bool (optional, default to Standard_True)

        Return
        -------
        None

        Description
        -----------
        Build an ci uniform (rational) bspline surface the highest continuity ci is imposed, like the maximal deformation is lower than <tolerance>. warning: the continuity c0 is imposed without any check.

        Parameters
        ----------
        Beziers: TColGeom_Array2OfBezierSurface
        UKnots: TColStd_Array1OfReal
        VKnots: TColStd_Array1OfReal
        UContinuity: GeomAbs_Shape (optional, default to GeomAbs_C0)
        VContinuity: GeomAbs_Shape (optional, default to GeomAbs_C0)
        Tolerance: float (optional, default to 1.0e-4)

        Return
        -------
        None

        Description
        -----------
        Computes all the data needed to construct a bspline surface equivalent to the adjacent non-rational bezier surfaces beziers grid. each surface in the beziers grid becomes a natural patch, limited by knots values, on the bspline surface whose data is computed. surfaces in the grid must satisfy the following conditions: - coincident bounding curves between two consecutive surfaces in a row of the beziers grid must be u-isoparametric bounding curves of these two surfaces. - coincident bounding curves between two consecutive surfaces in a column of the beziers grid must be v-isoparametric bounding curves of these two surfaces. the bspline surface whose data is computed has the following characteristics: - its degree in the u (respectively v) parametric direction is equal to that of the bezier surface which has the highest degree in the u (respectively v) parametric direction in the beziers grid. - coincident bounding curves between two consecutive columns of bezier surfaces in the beziers grid become u-isoparametric curves corresponding to knots values of the bspline surface. - coincident bounding curves between two consecutive rows of bezier surfaces in the beziers grid become v-isoparametric curves corresponding to knots values of the bspline surface. knots values of the bspline surface are given in the two tables: - uknots for the u parametric direction (which corresponds to the order of bezier surface columns in the beziers grid), and - vknots for the v parametric direction (which corresponds to the order of bezier surface rows in the beziers grid). the dimensions of uknots (respectively vknots) must be equal to the number of columns (respectively, rows) of the beziers grid, plus 1 . ucontinuity and vcontinuity, which are both defaulted to geomabs_c0, specify the required continuity on the bspline surface. if the required degree of continuity is greater than 0 in a given parametric direction, a deformation is applied locally on the initial surface (as defined by the beziers grid) to satisfy this condition. this local deformation is not applied however, if it is greater than tolerance (defaulted to 1.0 e-7). in such cases, the continuity condition is not satisfied, and the function isdone will return false. a small tolerance value prevents any modification of the surface and a large tolerance value 'smoothes' the surface. use the available consultation functions to access the computed data. this data may be used to construct the bspline surface. warning the surfaces in the beziers grid must be adjacent, i.e. two consecutive bezier surfaces in the grid (in a row or column) must have a coincident bounding curve. in addition, the location of the parameterization on each of these surfaces (i.e. the relative location of u and v isoparametric curves on the surface) is of importance with regard to the positioning of the surfaces in the beziers grid. care must be taken with respect to the above, as these properties are not checked and an error may occur if they are not satisfied. exceptions standard_dimensionmismatch: - if the number of knots in the uknots table (i.e. the length of the uknots array) is not equal to the number of columns of bezier surfaces in the beziers grid plus 1, or - if the number of knots in the vknots table (i.e. the length of the vknots array) is not equal to the number of rows of bezier surfaces in the beziers grid, plus 1. standard_constructionerror: - if ucontinuity and vcontinuity are not equal to one of the following values: geomabs_c0, geomabs_c1, geomabs_c2 and geomabs_c3; or - if the number of columns in the beziers grid is greater than 1, and the required degree of continuity in the u parametric direction is greater than that of the bezier surface with the highest degree in the u parametric direction (in the beziers grid), minus 1; or - if the number of rows in the beziers grid is greater than 1, and the required degree of continuity in the v parametric direction is greater than that of the bezier surface with the highest degree in the v parametric direction (in the beziers grid), minus 1 . standard_notimplemented if one of the bezier surfaces in the beziers grid is rational.

        """
        _GeomConvert.GeomConvert_CompBezierSurfacesToBSplineSurface_swiginit(self, _GeomConvert.new_GeomConvert_CompBezierSurfacesToBSplineSurface(*args))

    def IsDone(self, *args):
        r"""
        Return
        -------
        bool

        Description
        -----------
        Returns true if the conversion was successful. unless an exception was raised at the time of construction, the conversion of the bezier surface grid assigned to this algorithm is always carried out. isdone returns false if the constraints defined at the time of construction cannot be respected. this occurs when there is an incompatibility between a required degree of continuity on the bspline surface, and the maximum tolerance accepted for local deformations of the surface. in such a case the computed data does not satisfy all the initial constraints.

        """
        return _GeomConvert.GeomConvert_CompBezierSurfacesToBSplineSurface_IsDone(self, *args)

    def NbUKnots(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of knots in the u direction of the bspline surface whose data is computed in this framework.

        """
        return _GeomConvert.GeomConvert_CompBezierSurfacesToBSplineSurface_NbUKnots(self, *args)

    def NbUPoles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns number of poles in the u direction of the bspline surface whose data is computed in this framework.

        """
        return _GeomConvert.GeomConvert_CompBezierSurfacesToBSplineSurface_NbUPoles(self, *args)

    def NbVKnots(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of knots in the v direction of the bspline surface whose data is computed in this framework.

        """
        return _GeomConvert.GeomConvert_CompBezierSurfacesToBSplineSurface_NbVKnots(self, *args)

    def NbVPoles(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the number of poles in the v direction of the bspline surface whose data is computed in this framework.

        """
        return _GeomConvert.GeomConvert_CompBezierSurfacesToBSplineSurface_NbVPoles(self, *args)

    def Poles(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColgp_HArray2OfPnt>

        Description
        -----------
        Returns the table of poles of the bspline surface whose data is computed in this framework.

        """
        return _GeomConvert.GeomConvert_CompBezierSurfacesToBSplineSurface_Poles(self, *args)

    def UDegree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the degree for the u parametric direction of the bspline surface whose data is computed in this framework.

        """
        return _GeomConvert.GeomConvert_CompBezierSurfacesToBSplineSurface_UDegree(self, *args)

    def UKnots(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HArray1OfReal>

        Description
        -----------
        Returns the knots table for the u parametric direction of the bspline surface whose data is computed in this framework.

        """
        return _GeomConvert.GeomConvert_CompBezierSurfacesToBSplineSurface_UKnots(self, *args)

    def UMultiplicities(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HArray1OfInteger>

        Description
        -----------
        Returns the multiplicities table for the u parametric direction of the knots of the bspline surface whose data is computed in this framework.

        """
        return _GeomConvert.GeomConvert_CompBezierSurfacesToBSplineSurface_UMultiplicities(self, *args)

    def VDegree(self, *args):
        r"""
        Return
        -------
        int

        Description
        -----------
        Returns the degree for the v parametric direction of the bspline surface whose data is computed in this framework.

        """
        return _GeomConvert.GeomConvert_CompBezierSurfacesToBSplineSurface_VDegree(self, *args)

    def VKnots(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HArray1OfReal>

        Description
        -----------
        Returns the knots table for the v parametric direction of the bspline surface whose data is computed in this framework.

        """
        return _GeomConvert.GeomConvert_CompBezierSurfacesToBSplineSurface_VKnots(self, *args)

    def VMultiplicities(self, *args):
        r"""
        Return
        -------
        opencascade::handle<TColStd_HArray1OfInteger>

        Description
        -----------
        -- returns the multiplicities table for the v parametric direction of the knots of the bspline surface whose data is computed in this framework.

        """
        return _GeomConvert.GeomConvert_CompBezierSurfacesToBSplineSurface_VMultiplicities(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomConvert.delete_GeomConvert_CompBezierSurfacesToBSplineSurface

# Register GeomConvert_CompBezierSurfacesToBSplineSurface in _GeomConvert:
_GeomConvert.GeomConvert_CompBezierSurfacesToBSplineSurface_swigregister(GeomConvert_CompBezierSurfacesToBSplineSurface)
class GeomConvert_CompCurveToBSplineCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""

        Parameters
        ----------
        Parameterisation: Convert_ParameterisationType (optional, default to Convert_TgtThetaOver2)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithme - parameterisation is used to convert.

        Parameters
        ----------
        BasisCurve: Geom_BoundedCurve
        Parameterisation: Convert_ParameterisationType (optional, default to Convert_TgtThetaOver2)

        Return
        -------
        None

        Description
        -----------
        Initialize the algorithme with one curve - parameterisation is used to convert.

        """
        _GeomConvert.GeomConvert_CompCurveToBSplineCurve_swiginit(self, _GeomConvert.new_GeomConvert_CompCurveToBSplineCurve(*args))

    def Add(self, *args):
        r"""

        Parameters
        ----------
        NewCurve: Geom_BoundedCurve
        Tolerance: float
        After: bool (optional, default to Standard_False)
        WithRatio: bool (optional, default to Standard_True)
        MinM: int (optional, default to 0)

        Return
        -------
        bool

        Description
        -----------
        Append a curve in the bspline return false if the curve is not g0 with the bsplinecurve. tolerance is used to check continuity and decrease multiplicity at the common knot until minm if minm = 0, the common knot can be removed //! withratio defines whether the resulting curve should have a uniform parameterization. setting withratio to standard_false may greatly decrease the speed of algorithms like cpnts_abscissapoint::advperform when applied to the resulting curve.

        """
        return _GeomConvert.GeomConvert_CompCurveToBSplineCurve_Add(self, *args)

    def BSplineCurve(self, *args):
        r"""
        Return
        -------
        opencascade::handle<Geom_BSplineCurve>

        Description
        -----------
        No available documentation.

        """
        return _GeomConvert.GeomConvert_CompCurveToBSplineCurve_BSplineCurve(self, *args)

    __repr__ = _dumps_object

    @methodnotwrapped
    def Clear(self):
    	pass

    __swig_destroy__ = _GeomConvert.delete_GeomConvert_CompCurveToBSplineCurve

# Register GeomConvert_CompCurveToBSplineCurve in _GeomConvert:
_GeomConvert.GeomConvert_CompCurveToBSplineCurve_swigregister(GeomConvert_CompCurveToBSplineCurve)
class GeomConvert_CurveToAnaCurve(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        C: Geom_Curve

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _GeomConvert.GeomConvert_CurveToAnaCurve_swiginit(self, _GeomConvert.new_GeomConvert_CurveToAnaCurve(*args))

    @staticmethod
    def ComputeCircle(*args):
        r"""

        Parameters
        ----------
        curve: Geom_Curve
        tolerance: float
        c1: float
        c2: float

        Return
        -------
        cf: float
        cl: float
        Deviation: float

        Description
        -----------
        Tries to convert the given curve to circle with given tolerance. returns null curve if conversion is not possible.

        """
        return _GeomConvert.GeomConvert_CurveToAnaCurve_ComputeCircle(*args)

    @staticmethod
    def ComputeCurve(*args):
        r"""

        Parameters
        ----------
        curve: Geom_Curve
        tolerance: float
        c1: float
        c2: float
        theCurvType: GeomConvert_ConvType (optional, default to GeomConvert_MinGap)
        theTarget: GeomAbs_CurveType (optional, default to GeomAbs_Line)

        Return
        -------
        cf: float
        cl: float
        theGap: float

        Description
        -----------
        No available documentation.

        """
        return _GeomConvert.GeomConvert_CurveToAnaCurve_ComputeCurve(*args)

    @staticmethod
    def ComputeEllipse(*args):
        r"""

        Parameters
        ----------
        curve: Geom_Curve
        tolerance: float
        c1: float
        c2: float

        Return
        -------
        cf: float
        cl: float
        Deviation: float

        Description
        -----------
        Tries to convert the given curve to ellipse with given tolerance. returns null curve if conversion is not possible.

        """
        return _GeomConvert.GeomConvert_CurveToAnaCurve_ComputeEllipse(*args)

    @staticmethod
    def ComputeLine(*args):
        r"""

        Parameters
        ----------
        curve: Geom_Curve
        tolerance: float
        c1: float
        c2: float

        Return
        -------
        cf: float
        cl: float
        Deviation: float

        Description
        -----------
        Tries to convert the given curve to line with given tolerance. returns null curve if conversion is not possible.

        """
        return _GeomConvert.GeomConvert_CurveToAnaCurve_ComputeLine(*args)

    def ConvertToAnalytical(self, *args):
        r"""

        Parameters
        ----------
        theTol: float
        theResultCurve: Geom_Curve
        F: float
        L: float

        Return
        -------
        newF: float
        newL: float

        Description
        -----------
        Converts me to analytical if possible with given tolerance. the new first and last parameters are returned to newf, newl.

        """
        return _GeomConvert.GeomConvert_CurveToAnaCurve_ConvertToAnalytical(self, *args)

    def Gap(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns maximal deviation of converted surface from the original one computed by last call to converttoanalytical.

        """
        return _GeomConvert.GeomConvert_CurveToAnaCurve_Gap(self, *args)

    @staticmethod
    def GetCircle(*args):
        r"""

        Parameters
        ----------
        Circ: gp_Circ
        P0: gp_Pnt
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        bool

        Description
        -----------
        Creates circle on points. returns true if ok.

        """
        return _GeomConvert.GeomConvert_CurveToAnaCurve_GetCircle(*args)

    def GetConvType(self, *args):
        r"""
        Return
        -------
        GeomConvert_ConvType

        Description
        -----------
        Returns conversion type .

        """
        return _GeomConvert.GeomConvert_CurveToAnaCurve_GetConvType(self, *args)

    @staticmethod
    def GetLine(*args):
        r"""

        Parameters
        ----------
        P1: gp_Pnt
        P2: gp_Pnt

        Return
        -------
        cf: float
        cl: float

        Description
        -----------
        Creates line on two points. resulting parameters returned.

        """
        return _GeomConvert.GeomConvert_CurveToAnaCurve_GetLine(*args)

    def GetTarget(self, *args):
        r"""
        Return
        -------
        GeomAbs_CurveType

        Description
        -----------
        Returns target curve type .

        """
        return _GeomConvert.GeomConvert_CurveToAnaCurve_GetTarget(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        C: Geom_Curve

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _GeomConvert.GeomConvert_CurveToAnaCurve_Init(self, *args)

    @staticmethod
    def IsLinear(*args):
        r"""

        Parameters
        ----------
        aPoints: TColgp_Array1OfPnt
        tolerance: float

        Return
        -------
        Deviation: float

        Description
        -----------
        Returns true if the set of points is linear with given tolerance.

        """
        return _GeomConvert.GeomConvert_CurveToAnaCurve_IsLinear(*args)

    def SetConvType(self, *args):
        r"""

        Parameters
        ----------
        theConvType: GeomConvert_ConvType

        Return
        -------
        None

        Description
        -----------
        Sets type of convertion.

        """
        return _GeomConvert.GeomConvert_CurveToAnaCurve_SetConvType(self, *args)

    def SetTarget(self, *args):
        r"""

        Parameters
        ----------
        theTarget: GeomAbs_CurveType

        Return
        -------
        None

        Description
        -----------
        Sets target curve type.

        """
        return _GeomConvert.GeomConvert_CurveToAnaCurve_SetTarget(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomConvert.delete_GeomConvert_CurveToAnaCurve

# Register GeomConvert_CurveToAnaCurve in _GeomConvert:
_GeomConvert.GeomConvert_CurveToAnaCurve_swigregister(GeomConvert_CurveToAnaCurve)
class GeomConvert_FuncConeLSDist(OCC.Core.math.math_MultipleVarFunction):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructor.

        Parameters
        ----------
        thePoints: TColgp_HArray1OfXYZ
        theDir: gp_Dir

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _GeomConvert.GeomConvert_FuncConeLSDist_swiginit(self, _GeomConvert.new_GeomConvert_FuncConeLSDist(*args))

    def SetDir(self, *args):
        r"""

        Parameters
        ----------
        theDir: gp_Dir

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _GeomConvert.GeomConvert_FuncConeLSDist_SetDir(self, *args)

    def SetPoints(self, *args):
        r"""

        Parameters
        ----------
        thePoints: TColgp_HArray1OfXYZ

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _GeomConvert.GeomConvert_FuncConeLSDist_SetPoints(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomConvert.delete_GeomConvert_FuncConeLSDist

# Register GeomConvert_FuncConeLSDist in _GeomConvert:
_GeomConvert.GeomConvert_FuncConeLSDist_swigregister(GeomConvert_FuncConeLSDist)
class GeomConvert_FuncCylinderLSDist(OCC.Core.math.math_MultipleVarFunctionWithGradient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructor.

        Parameters
        ----------
        thePoints: TColgp_HArray1OfXYZ
        theDir: gp_Dir

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _GeomConvert.GeomConvert_FuncCylinderLSDist_swiginit(self, _GeomConvert.new_GeomConvert_FuncCylinderLSDist(*args))

    def SetDir(self, *args):
        r"""

        Parameters
        ----------
        theDir: gp_Dir

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _GeomConvert.GeomConvert_FuncCylinderLSDist_SetDir(self, *args)

    def SetPoints(self, *args):
        r"""

        Parameters
        ----------
        thePoints: TColgp_HArray1OfXYZ

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _GeomConvert.GeomConvert_FuncCylinderLSDist_SetPoints(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomConvert.delete_GeomConvert_FuncCylinderLSDist

# Register GeomConvert_FuncCylinderLSDist in _GeomConvert:
_GeomConvert.GeomConvert_FuncCylinderLSDist_swigregister(GeomConvert_FuncCylinderLSDist)
class GeomConvert_FuncSphereLSDist(OCC.Core.math.math_MultipleVarFunctionWithGradient):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        Constructor.

        Parameters
        ----------
        thePoints: TColgp_HArray1OfXYZ

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _GeomConvert.GeomConvert_FuncSphereLSDist_swiginit(self, _GeomConvert.new_GeomConvert_FuncSphereLSDist(*args))

    def SetPoints(self, *args):
        r"""

        Parameters
        ----------
        thePoints: TColgp_HArray1OfXYZ

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _GeomConvert.GeomConvert_FuncSphereLSDist_SetPoints(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomConvert.delete_GeomConvert_FuncSphereLSDist

# Register GeomConvert_FuncSphereLSDist in _GeomConvert:
_GeomConvert.GeomConvert_FuncSphereLSDist_swigregister(GeomConvert_FuncSphereLSDist)
class GeomConvert_SurfToAnaSurf(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        Return
        -------
        None

        Description
        -----------
        No available documentation.

        Parameters
        ----------
        S: Geom_Surface

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        _GeomConvert.GeomConvert_SurfToAnaSurf_swiginit(self, _GeomConvert.new_GeomConvert_SurfToAnaSurf(*args))

    def ConvertToAnalytical(self, *args):
        r"""

        Parameters
        ----------
        InitialToler: float

        Return
        -------
        opencascade::handle<Geom_Surface>

        Description
        -----------
        Tries to convert the surface to an analytic form returns the result in case of failure, returns a null handle //!.

        Parameters
        ----------
        InitialToler: float
        Umin: float
        Umax: float
        Vmin: float
        Vmax: float

        Return
        -------
        opencascade::handle<Geom_Surface>

        Description
        -----------
        No available documentation.

        """
        return _GeomConvert.GeomConvert_SurfToAnaSurf_ConvertToAnalytical(self, *args)

    def Gap(self, *args):
        r"""
        Return
        -------
        float

        Description
        -----------
        Returns maximal deviation of converted surface from the original one computed by last call to converttoanalytical.

        """
        return _GeomConvert.GeomConvert_SurfToAnaSurf_Gap(self, *args)

    def Init(self, *args):
        r"""

        Parameters
        ----------
        S: Geom_Surface

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _GeomConvert.GeomConvert_SurfToAnaSurf_Init(self, *args)

    @staticmethod
    def IsCanonical(*args):
        r"""

        Parameters
        ----------
        S: Geom_Surface

        Return
        -------
        bool

        Description
        -----------
        Returns true, if surface is canonical.

        """
        return _GeomConvert.GeomConvert_SurfToAnaSurf_IsCanonical(*args)

    @staticmethod
    def IsSame(*args):
        r"""

        Parameters
        ----------
        S1: Geom_Surface
        S2: Geom_Surface
        tol: float

        Return
        -------
        bool

        Description
        -----------
        Returns true if surfaces is same with the given tolerance.

        """
        return _GeomConvert.GeomConvert_SurfToAnaSurf_IsSame(*args)

    def SetConvType(self, *args):
        r"""

        Parameters
        ----------
        theConvType: GeomConvert_ConvType (optional, default to GeomConvert_Simplest)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _GeomConvert.GeomConvert_SurfToAnaSurf_SetConvType(self, *args)

    def SetTarget(self, *args):
        r"""

        Parameters
        ----------
        theSurfType: GeomAbs_SurfaceType (optional, default to GeomAbs_Plane)

        Return
        -------
        None

        Description
        -----------
        No available documentation.

        """
        return _GeomConvert.GeomConvert_SurfToAnaSurf_SetTarget(self, *args)

    __repr__ = _dumps_object

    __swig_destroy__ = _GeomConvert.delete_GeomConvert_SurfToAnaSurf

# Register GeomConvert_SurfToAnaSurf in _GeomConvert:
_GeomConvert.GeomConvert_SurfToAnaSurf_swigregister(GeomConvert_SurfToAnaSurf)
class GeomConvert_Units(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def DegreeToRadian(*args):
        r"""

        Parameters
        ----------
        theCurve: Geom2d_Curve
        theSurface: Geom_Surface
        theLengthFactor: float
        theFactorRadianDegree: float

        Return
        -------
        opencascade::handle<Geom2d_Curve>

        Description
        -----------
        Convert 2d curve for change angle unit from degree to radian.

        """
        return _GeomConvert.GeomConvert_Units_DegreeToRadian(*args)

    @staticmethod
    def MirrorPCurve(*args):
        r"""

        Parameters
        ----------
        theCurve: Geom2d_Curve

        Return
        -------
        opencascade::handle<Geom2d_Curve>

        Description
        -----------
        Return 2d curve as 'mirror' for given.

        """
        return _GeomConvert.GeomConvert_Units_MirrorPCurve(*args)

    @staticmethod
    def RadianToDegree(*args):
        r"""

        Parameters
        ----------
        theCurve: Geom2d_Curve
        theSurface: Geom_Surface
        theLengthFactor: float
        theFactorRadianDegree: float

        Return
        -------
        opencascade::handle<Geom2d_Curve>

        Description
        -----------
        Convert 2d curve for change angle unit from radian to degree .

        """
        return _GeomConvert.GeomConvert_Units_RadianToDegree(*args)

    __repr__ = _dumps_object


    def __init__(self):
        _GeomConvert.GeomConvert_Units_swiginit(self, _GeomConvert.new_GeomConvert_Units())
    __swig_destroy__ = _GeomConvert.delete_GeomConvert_Units

# Register GeomConvert_Units in _GeomConvert:
_GeomConvert.GeomConvert_Units_swigregister(GeomConvert_Units)



@deprecated
def geomconvert_C0BSplineToArrayOfC1BSplineCurve(*args):
	return geomconvert.C0BSplineToArrayOfC1BSplineCurve(*args)

@deprecated
def geomconvert_C0BSplineToArrayOfC1BSplineCurve(*args):
	return geomconvert.C0BSplineToArrayOfC1BSplineCurve(*args)

@deprecated
def geomconvert_C0BSplineToC1BSplineCurve(*args):
	return geomconvert.C0BSplineToC1BSplineCurve(*args)

@deprecated
def geomconvert_ConcatC1(*args):
	return geomconvert.ConcatC1(*args)

@deprecated
def geomconvert_ConcatC1(*args):
	return geomconvert.ConcatC1(*args)

@deprecated
def geomconvert_ConcatG1(*args):
	return geomconvert.ConcatG1(*args)

@deprecated
def geomconvert_CurveToBSplineCurve(*args):
	return geomconvert.CurveToBSplineCurve(*args)

@deprecated
def geomconvert_SplitBSplineCurve(*args):
	return geomconvert.SplitBSplineCurve(*args)

@deprecated
def geomconvert_SplitBSplineCurve(*args):
	return geomconvert.SplitBSplineCurve(*args)

@deprecated
def geomconvert_SplitBSplineSurface(*args):
	return geomconvert.SplitBSplineSurface(*args)

@deprecated
def geomconvert_SplitBSplineSurface(*args):
	return geomconvert.SplitBSplineSurface(*args)

@deprecated
def geomconvert_SplitBSplineSurface(*args):
	return geomconvert.SplitBSplineSurface(*args)

@deprecated
def geomconvert_SplitBSplineSurface(*args):
	return geomconvert.SplitBSplineSurface(*args)

@deprecated
def geomconvert_SurfaceToBSplineSurface(*args):
	return geomconvert.SurfaceToBSplineSurface(*args)

@deprecated
def GeomConvert_CurveToAnaCurve_ComputeCircle(*args):
	return GeomConvert_CurveToAnaCurve.ComputeCircle(*args)

@deprecated
def GeomConvert_CurveToAnaCurve_ComputeCurve(*args):
	return GeomConvert_CurveToAnaCurve.ComputeCurve(*args)

@deprecated
def GeomConvert_CurveToAnaCurve_ComputeEllipse(*args):
	return GeomConvert_CurveToAnaCurve.ComputeEllipse(*args)

@deprecated
def GeomConvert_CurveToAnaCurve_ComputeLine(*args):
	return GeomConvert_CurveToAnaCurve.ComputeLine(*args)

@deprecated
def GeomConvert_CurveToAnaCurve_GetCircle(*args):
	return GeomConvert_CurveToAnaCurve.GetCircle(*args)

@deprecated
def GeomConvert_CurveToAnaCurve_GetLine(*args):
	return GeomConvert_CurveToAnaCurve.GetLine(*args)

@deprecated
def GeomConvert_CurveToAnaCurve_IsLinear(*args):
	return GeomConvert_CurveToAnaCurve.IsLinear(*args)

@deprecated
def GeomConvert_SurfToAnaSurf_IsCanonical(*args):
	return GeomConvert_SurfToAnaSurf.IsCanonical(*args)

@deprecated
def GeomConvert_SurfToAnaSurf_IsSame(*args):
	return GeomConvert_SurfToAnaSurf.IsSame(*args)

@deprecated
def GeomConvert_Units_DegreeToRadian(*args):
	return GeomConvert_Units.DegreeToRadian(*args)

@deprecated
def GeomConvert_Units_MirrorPCurve(*args):
	return GeomConvert_Units.MirrorPCurve(*args)

@deprecated
def GeomConvert_Units_RadianToDegree(*args):
	return GeomConvert_Units.RadianToDegree(*args)



