/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn;

import com.nulabinc.zxcvbn.AttackTimes;
import java.math.BigDecimal;

public class TimeEstimates {
    public static AttackTimes estimateAttackTimes(double guesses) {
        AttackTimes.CrackTimeSeconds crackTimeSeconds = new AttackTimes.CrackTimeSeconds(TimeEstimates.divide(guesses, 0.027777777777777776), guesses / 10.0, guesses / 10000.0, guesses / 1.0E10);
        AttackTimes.CrackTimesDisplay crackTimesDisplay = new AttackTimes.CrackTimesDisplay(TimeEstimates.displayTime(crackTimeSeconds.getOnlineThrottling100perHour()), TimeEstimates.displayTime(crackTimeSeconds.getOnlineNoThrottling10perSecond()), TimeEstimates.displayTime(crackTimeSeconds.getOfflineSlowHashing1e4perSecond()), TimeEstimates.displayTime(crackTimeSeconds.getOfflineFastHashing1e10PerSecond()));
        return new AttackTimes(crackTimeSeconds, crackTimesDisplay, TimeEstimates.guessesToScore(guesses));
    }

    public static int guessesToScore(double guesses) {
        int DELTA = 5;
        if (guesses < 1000.0 + (double)DELTA) {
            return 0;
        }
        if (guesses < 1000000.0 + (double)DELTA) {
            return 1;
        }
        if (guesses < 1.0E8 + (double)DELTA) {
            return 2;
        }
        if (guesses < 1.0E10 + (double)DELTA) {
            return 3;
        }
        return 4;
    }

    public static String displayTime(double seconds) {
        Double minute = 60.0;
        Double hour = minute * 60.0;
        Double day = hour * 24.0;
        Double month = day * 31.0;
        Double year = month * 12.0;
        Double century = year * 100.0;
        if (seconds < 1.0) {
            return TimeEstimates.format(null, "less than a second");
        }
        if (seconds < minute) {
            return TimeEstimates.format(seconds, "%s second");
        }
        if (seconds < hour) {
            return TimeEstimates.format(TimeEstimates.divide(seconds, minute), "%s minute");
        }
        if (seconds < day) {
            return TimeEstimates.format(TimeEstimates.divide(seconds, hour), "%s hour");
        }
        if (seconds < month) {
            return TimeEstimates.format(TimeEstimates.divide(seconds, day), "%s day");
        }
        if (seconds < year) {
            return TimeEstimates.format(TimeEstimates.divide(seconds, month), "%s month");
        }
        if (seconds < century) {
            return TimeEstimates.format(TimeEstimates.divide(seconds, year), "%s year");
        }
        return TimeEstimates.format(null, "centuries");
    }

    private static String format(Double number, String text) {
        if (number != null) {
            text = String.format(text, Math.round(number)) + (number != 1.0 ? "s" : "");
        }
        return text;
    }

    private static double divide(double dividend, double divisor) {
        BigDecimal dividendDecimal = new BigDecimal(dividend);
        BigDecimal divisorDecimal = new BigDecimal(divisor);
        return dividendDecimal.divide(divisorDecimal, 5).doubleValue();
    }
}

