/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.TransitGatewayAttachmentResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayPrefixListAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayPrefixListAttachment> {
    private static final SdkField<String> TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayAttachmentId").getter(TransitGatewayPrefixListAttachment.getter(TransitGatewayPrefixListAttachment::transitGatewayAttachmentId)).setter(TransitGatewayPrefixListAttachment.setter(Builder::transitGatewayAttachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayAttachmentId").unmarshallLocationName("transitGatewayAttachmentId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(TransitGatewayPrefixListAttachment.getter(TransitGatewayPrefixListAttachment::resourceTypeAsString)).setter(TransitGatewayPrefixListAttachment.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(TransitGatewayPrefixListAttachment.getter(TransitGatewayPrefixListAttachment::resourceId)).setter(TransitGatewayPrefixListAttachment.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("resourceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ATTACHMENT_ID_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transitGatewayAttachmentId;
    private final String resourceType;
    private final String resourceId;

    private TransitGatewayPrefixListAttachment(BuilderImpl builder) {
        this.transitGatewayAttachmentId = builder.transitGatewayAttachmentId;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
    }

    public final String transitGatewayAttachmentId() {
        return this.transitGatewayAttachmentId;
    }

    public final TransitGatewayAttachmentResourceType resourceType() {
        return TransitGatewayAttachmentResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayAttachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayPrefixListAttachment)) {
            return false;
        }
        TransitGatewayPrefixListAttachment other = (TransitGatewayPrefixListAttachment)obj;
        return Objects.equals(this.transitGatewayAttachmentId(), other.transitGatewayAttachmentId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.resourceId(), other.resourceId());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayPrefixListAttachment").add("TransitGatewayAttachmentId", (Object)this.transitGatewayAttachmentId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceId", (Object)this.resourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayAttachmentId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayAttachmentId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayPrefixListAttachment, T> g) {
        return obj -> g.apply((TransitGatewayPrefixListAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayAttachmentId;
        private String resourceType;
        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayPrefixListAttachment model) {
            this.transitGatewayAttachmentId(model.transitGatewayAttachmentId);
            this.resourceType(model.resourceType);
            this.resourceId(model.resourceId);
        }

        public final String getTransitGatewayAttachmentId() {
            return this.transitGatewayAttachmentId;
        }

        public final void setTransitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
        }

        @Override
        public final Builder transitGatewayAttachmentId(String transitGatewayAttachmentId) {
            this.transitGatewayAttachmentId = transitGatewayAttachmentId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(TransitGatewayAttachmentResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public TransitGatewayPrefixListAttachment build() {
            return new TransitGatewayPrefixListAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayPrefixListAttachment> {
        public Builder transitGatewayAttachmentId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(TransitGatewayAttachmentResourceType var1);

        public Builder resourceId(String var1);
    }
}

