"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupBy = void 0;

var _lodash = require("lodash");

var _node = require("../node");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class GroupBy extends _node.PPLNode {
  constructor(name, children, fields, span) {
    super(name, children);
    this.fields = fields;
    this.span = span;
  }

  getTokens() {
    var _this$span;

    return {
      group_fields: this.fields.map(field => field.getTokens()),
      span: (_this$span = this.span) === null || _this$span === void 0 ? void 0 : _this$span.getTokens()
    };
  }

  toString() {
    return `${!(0, _lodash.isEmpty)(this.fields) || !(0, _lodash.isEmpty)(this.span) ? 'by ' : ''}` + `${!(0, _lodash.isEmpty)(this.span) ? `${this.span.toString()}${this.fields.length > 0 ? ', ' : ''}` : ''}${this.fields.map(field => field.toString()).join(', ')}`;
  }

}

exports.GroupBy = GroupBy;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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