/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class ValidateAnomalyDetectorRequest
extends ActionRequest {
    private final AnomalyDetector detector;
    private final String validationType;
    private final Integer maxSingleEntityAnomalyDetectors;
    private final Integer maxMultiEntityAnomalyDetectors;
    private final Integer maxAnomalyFeatures;
    private final TimeValue requestTimeout;

    public ValidateAnomalyDetectorRequest(StreamInput in) throws IOException {
        super(in);
        this.detector = new AnomalyDetector(in);
        this.validationType = in.readString();
        this.maxSingleEntityAnomalyDetectors = in.readInt();
        this.maxMultiEntityAnomalyDetectors = in.readInt();
        this.maxAnomalyFeatures = in.readInt();
        this.requestTimeout = in.readTimeValue();
    }

    public ValidateAnomalyDetectorRequest(AnomalyDetector detector, String validationType, Integer maxSingleEntityAnomalyDetectors, Integer maxMultiEntityAnomalyDetectors, Integer maxAnomalyFeatures, TimeValue requestTimeout) {
        this.detector = detector;
        this.validationType = validationType;
        this.maxSingleEntityAnomalyDetectors = maxSingleEntityAnomalyDetectors;
        this.maxMultiEntityAnomalyDetectors = maxMultiEntityAnomalyDetectors;
        this.maxAnomalyFeatures = maxAnomalyFeatures;
        this.requestTimeout = requestTimeout;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.detector.writeTo(out);
        out.writeString(this.validationType);
        out.writeInt(this.maxSingleEntityAnomalyDetectors.intValue());
        out.writeInt(this.maxMultiEntityAnomalyDetectors.intValue());
        out.writeInt(this.maxAnomalyFeatures.intValue());
        out.writeTimeValue(this.requestTimeout);
    }

    public ActionRequestValidationException validate() {
        return null;
    }

    public AnomalyDetector getDetector() {
        return this.detector;
    }

    public String getValidationType() {
        return this.validationType;
    }

    public Integer getMaxSingleEntityAnomalyDetectors() {
        return this.maxSingleEntityAnomalyDetectors;
    }

    public Integer getMaxMultiEntityAnomalyDetectors() {
        return this.maxMultiEntityAnomalyDetectors;
    }

    public Integer getMaxAnomalyFeatures() {
        return this.maxAnomalyFeatures;
    }

    public TimeValue getRequestTimeout() {
        return this.requestTimeout;
    }
}

