/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.admin.indices.rollover.RolloverInfo;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.Diffable;
import org.opensearch.cluster.DiffableUtils;
import org.opensearch.cluster.block.ClusterBlock;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.AutoExpandReplicas;
import org.opensearch.cluster.metadata.DiffableStringMap;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNodeFilters;
import org.opensearch.common.Nullable;
import org.opensearch.common.collect.MapBuilder;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.Assertions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.gateway.MetadataStateFormat;
import org.opensearch.indices.replication.common.ReplicationType;

public class IndexMetadata
implements Diffable<IndexMetadata>,
ToXContentFragment {
    public static final ClusterBlock INDEX_READ_ONLY_BLOCK = new ClusterBlock(5, "index read-only (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final ClusterBlock INDEX_READ_BLOCK = new ClusterBlock(7, "index read (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.READ));
    public static final ClusterBlock INDEX_WRITE_BLOCK = new ClusterBlock(8, "index write (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE));
    public static final ClusterBlock INDEX_METADATA_BLOCK = new ClusterBlock(9, "index metadata (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.METADATA_WRITE, ClusterBlockLevel.METADATA_READ));
    public static final ClusterBlock INDEX_READ_ONLY_ALLOW_DELETE_BLOCK = new ClusterBlock(12, "disk usage exceeded flood-stage watermark, index has read-only-allow-delete block", false, false, true, RestStatus.TOO_MANY_REQUESTS, EnumSet.of(ClusterBlockLevel.METADATA_WRITE, ClusterBlockLevel.WRITE));
    public static final ClusterBlock REMOTE_READ_ONLY_ALLOW_DELETE = new ClusterBlock(13, "remote index is read-only", false, false, true, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.METADATA_WRITE, ClusterBlockLevel.WRITE));
    public static final String INDEX_SETTING_PREFIX = "index.";
    public static final String SETTING_NUMBER_OF_SHARDS = "index.number_of_shards";
    static final String DEFAULT_NUMBER_OF_SHARDS = "opensearch.index.default_number_of_shards";
    static final String MAX_NUMBER_OF_SHARDS = "opensearch.index.max_number_of_shards";
    public static final Setting<Integer> INDEX_NUMBER_OF_SHARDS_SETTING = IndexMetadata.buildNumberOfShardsSetting();
    public static final String SETTING_NUMBER_OF_REPLICAS = "index.number_of_replicas";
    public static final Setting<Integer> INDEX_NUMBER_OF_REPLICAS_SETTING = Setting.intSetting("index.number_of_replicas", 1, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_ROUTING_PARTITION_SIZE = "index.routing_partition_size";
    public static final Setting<Integer> INDEX_ROUTING_PARTITION_SIZE_SETTING = Setting.intSetting("index.routing_partition_size", 1, 1, Setting.Property.IndexScope);
    public static final Setting<Integer> INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING = Setting.intSetting("index.number_of_routing_shards", INDEX_NUMBER_OF_SHARDS_SETTING, 1, new Setting.Validator<Integer>(){

        @Override
        public void validate(Integer value) {
        }

        @Override
        public void validate(Integer numRoutingShards, Map<Setting<?>, Object> settings) {
            int numShards = (Integer)settings.get(INDEX_NUMBER_OF_SHARDS_SETTING);
            if (numRoutingShards < numShards) {
                throw new IllegalArgumentException("index.number_of_routing_shards [" + numRoutingShards + "] must be >= index.number_of_shards [" + numShards + "]");
            }
            IndexMetadata.getRoutingFactor(numShards, numRoutingShards);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<Integer>> settings = Collections.singletonList(INDEX_NUMBER_OF_SHARDS_SETTING);
            return settings.iterator();
        }
    }, Setting.Property.IndexScope);
    public static final String SETTING_REPLICATION_TYPE = "index.replication.type";
    public static final Setting<ReplicationType> INDEX_REPLICATION_TYPE_SETTING = new Setting<ReplicationType>("index.replication.type", ReplicationType.DOCUMENT.toString(), ReplicationType::parseString, new Setting.Validator<ReplicationType>(){

        @Override
        public void validate(ReplicationType value) {
        }

        @Override
        public void validate(ReplicationType value, Map<Setting<?>, Object> settings) {
            Object remoteStoreEnabled = settings.get(INDEX_REMOTE_STORE_ENABLED_SETTING);
            if (!ReplicationType.SEGMENT.equals((Object)value) && Objects.equals(remoteStoreEnabled, true)) {
                throw new IllegalArgumentException("To enable " + INDEX_REMOTE_STORE_ENABLED_SETTING.getKey() + ", " + INDEX_REPLICATION_TYPE_SETTING.getKey() + " should be set to " + ReplicationType.SEGMENT);
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<Boolean>> settings = List.of(INDEX_REMOTE_STORE_ENABLED_SETTING);
            return settings.iterator();
        }
    }, Setting.Property.IndexScope, Setting.Property.Final);
    public static final String SETTING_REMOTE_STORE_ENABLED = "index.remote_store.enabled";
    public static final String SETTING_REMOTE_SEGMENT_STORE_REPOSITORY = "index.remote_store.segment.repository";
    public static final String SETTING_REMOTE_TRANSLOG_STORE_REPOSITORY = "index.remote_store.translog.repository";
    public static final Setting<Boolean> INDEX_REMOTE_STORE_ENABLED_SETTING = Setting.boolSetting("index.remote_store.enabled", false, new Setting.Validator<Boolean>(){

        @Override
        public void validate(Boolean value) {
        }

        @Override
        public void validate(Boolean value, Map<Setting<?>, Object> settings) {
            Object replicationType = settings.get(INDEX_REPLICATION_TYPE_SETTING);
            if (!ReplicationType.SEGMENT.equals(replicationType) && value.booleanValue()) {
                throw new IllegalArgumentException("To enable " + INDEX_REMOTE_STORE_ENABLED_SETTING.getKey() + ", " + INDEX_REPLICATION_TYPE_SETTING.getKey() + " should be set to " + ReplicationType.SEGMENT);
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<ReplicationType>> settings = List.of(INDEX_REPLICATION_TYPE_SETTING);
            return settings.iterator();
        }
    }, Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.Dynamic);
    public static final Setting<String> INDEX_REMOTE_SEGMENT_STORE_REPOSITORY_SETTING = Setting.simpleString("index.remote_store.segment.repository", new Setting.Validator<String>(){

        @Override
        public void validate(String value) {
        }

        @Override
        public void validate(String value, Map<Setting<?>, Object> settings) {
            if (value == null || value.isEmpty()) {
                throw new IllegalArgumentException("Setting " + INDEX_REMOTE_SEGMENT_STORE_REPOSITORY_SETTING.getKey() + " should be provided with non-empty repository ID");
            }
            IndexMetadata.validateRemoteStoreSettingEnabled(settings, INDEX_REMOTE_SEGMENT_STORE_REPOSITORY_SETTING);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<Boolean>> settings = Collections.singletonList(INDEX_REMOTE_STORE_ENABLED_SETTING);
            return settings.iterator();
        }
    }, Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.Dynamic);
    public static final Setting<String> INDEX_REMOTE_TRANSLOG_REPOSITORY_SETTING = Setting.simpleString("index.remote_store.translog.repository", new Setting.Validator<String>(){

        @Override
        public void validate(String value) {
        }

        @Override
        public void validate(String value, Map<Setting<?>, Object> settings) {
            if (value == null || value.isEmpty()) {
                throw new IllegalArgumentException("Setting " + INDEX_REMOTE_TRANSLOG_REPOSITORY_SETTING.getKey() + " should be provided with non-empty repository ID");
            }
            Boolean isRemoteTranslogStoreEnabled = (Boolean)settings.get(INDEX_REMOTE_STORE_ENABLED_SETTING);
            if (isRemoteTranslogStoreEnabled == null || !isRemoteTranslogStoreEnabled.booleanValue()) {
                throw new IllegalArgumentException("Settings " + INDEX_REMOTE_TRANSLOG_REPOSITORY_SETTING.getKey() + " can only be set/enabled when " + INDEX_REMOTE_STORE_ENABLED_SETTING.getKey() + " is set to true");
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<Boolean>> settings = Collections.singletonList(INDEX_REMOTE_STORE_ENABLED_SETTING);
            return settings.iterator();
        }
    }, Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.Dynamic);
    public static final String SETTING_AUTO_EXPAND_REPLICAS = "index.auto_expand_replicas";
    public static final Setting<AutoExpandReplicas> INDEX_AUTO_EXPAND_REPLICAS_SETTING = AutoExpandReplicas.SETTING;
    public static final String SETTING_READ_ONLY = APIBlock.READ_ONLY.settingName();
    public static final Setting<Boolean> INDEX_READ_ONLY_SETTING = APIBlock.READ_ONLY.setting();
    public static final String SETTING_BLOCKS_READ = APIBlock.READ.settingName();
    public static final Setting<Boolean> INDEX_BLOCKS_READ_SETTING = APIBlock.READ.setting();
    public static final String SETTING_BLOCKS_WRITE = APIBlock.WRITE.settingName();
    public static final Setting<Boolean> INDEX_BLOCKS_WRITE_SETTING = APIBlock.WRITE.setting();
    public static final String SETTING_BLOCKS_METADATA = APIBlock.METADATA.settingName();
    public static final Setting<Boolean> INDEX_BLOCKS_METADATA_SETTING = APIBlock.METADATA.setting();
    public static final String SETTING_READ_ONLY_ALLOW_DELETE = APIBlock.READ_ONLY_ALLOW_DELETE.settingName();
    public static final Setting<Boolean> INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING = APIBlock.READ_ONLY_ALLOW_DELETE.setting();
    public static final String SETTING_VERSION_CREATED = "index.version.created";
    public static final Setting<Version> SETTING_INDEX_VERSION_CREATED = Setting.versionSetting("index.version.created", Version.V_EMPTY, Setting.Property.IndexScope, Setting.Property.PrivateIndex);
    public static final String SETTING_VERSION_CREATED_STRING = "index.version.created_string";
    public static final String SETTING_VERSION_UPGRADED = "index.version.upgraded";
    public static final String SETTING_VERSION_UPGRADED_STRING = "index.version.upgraded_string";
    public static final String SETTING_CREATION_DATE = "index.creation_date";
    public static final String SETTING_INDEX_PROVIDED_NAME = "index.provided_name";
    public static final String SETTING_PRIORITY = "index.priority";
    public static final Setting<Integer> INDEX_PRIORITY_SETTING = Setting.intSetting("index.priority", 1, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_CREATION_DATE_STRING = "index.creation_date_string";
    public static final String SETTING_INDEX_UUID = "index.uuid";
    public static final String SETTING_HISTORY_UUID = "index.history.uuid";
    public static final String SETTING_DATA_PATH = "index.data_path";
    public static final Setting<String> INDEX_DATA_PATH_SETTING = new Setting("index.data_path", "", Function.identity(), Setting.Property.IndexScope);
    public static final String INDEX_UUID_NA_VALUE = "_na_";
    public static final String INDEX_ROUTING_REQUIRE_GROUP_PREFIX = "index.routing.allocation.require";
    public static final String INDEX_ROUTING_INCLUDE_GROUP_PREFIX = "index.routing.allocation.include";
    public static final String INDEX_ROUTING_EXCLUDE_GROUP_PREFIX = "index.routing.allocation.exclude";
    public static final Setting.AffixSetting<String> INDEX_ROUTING_REQUIRE_GROUP_SETTING = Setting.prefixKeySetting("index.routing.allocation.require.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.IndexScope));
    public static final Setting.AffixSetting<String> INDEX_ROUTING_INCLUDE_GROUP_SETTING = Setting.prefixKeySetting("index.routing.allocation.include.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.IndexScope));
    public static final Setting.AffixSetting<String> INDEX_ROUTING_EXCLUDE_GROUP_SETTING = Setting.prefixKeySetting("index.routing.allocation.exclude.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.IndexScope));
    public static final Setting.AffixSetting<String> INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING = Setting.prefixKeySetting("index.routing.allocation.initial_recovery.", key -> Setting.simpleString(key, new Setting.Property[0]));
    public static final Setting<ActiveShardCount> SETTING_WAIT_FOR_ACTIVE_SHARDS = new Setting<ActiveShardCount>("index.write.wait_for_active_shards", "1", ActiveShardCount::parseString, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final String SETTING_INDEX_HIDDEN = "index.hidden";
    public static final Setting<Boolean> INDEX_HIDDEN_SETTING = Setting.boolSetting("index.hidden", false, Setting.Property.Dynamic, Setting.Property.IndexScope);
    private static final String INDEX_FORMAT = "index.format";
    public static final Setting<Integer> INDEX_FORMAT_SETTING = Setting.intSetting("index.format", 0, Setting.Property.IndexScope, Setting.Property.Final);
    public static final String KEY_IN_SYNC_ALLOCATIONS = "in_sync_allocations";
    static final String KEY_VERSION = "version";
    static final String KEY_MAPPING_VERSION = "mapping_version";
    static final String KEY_SETTINGS_VERSION = "settings_version";
    static final String KEY_ALIASES_VERSION = "aliases_version";
    static final String KEY_ROUTING_NUM_SHARDS = "routing_num_shards";
    static final String KEY_SETTINGS = "settings";
    static final String KEY_STATE = "state";
    static final String KEY_MAPPINGS = "mappings";
    static final String KEY_ALIASES = "aliases";
    static final String KEY_ROLLOVER_INFOS = "rollover_info";
    static final String KEY_SYSTEM = "system";
    public static final String KEY_PRIMARY_TERMS = "primary_terms";
    public static final String INDEX_STATE_FILE_PREFIX = "state-";
    static final Version SYSTEM_INDEX_FLAG_ADDED = LegacyESVersion.V_7_10_0;
    private final int routingNumShards;
    private final int routingFactor;
    private final int routingPartitionSize;
    private final int numberOfShards;
    private final int numberOfReplicas;
    private final Index index;
    private final long version;
    private final long mappingVersion;
    private final long settingsVersion;
    private final long aliasesVersion;
    private final long[] primaryTerms;
    private final State state;
    private final Map<String, AliasMetadata> aliases;
    private final Settings settings;
    private final Map<String, MappingMetadata> mappings;
    private final Map<String, DiffableStringMap> customData;
    private final Map<Integer, Set<String>> inSyncAllocationIds;
    private final transient int totalNumberOfShards;
    private final DiscoveryNodeFilters requireFilters;
    private final DiscoveryNodeFilters includeFilters;
    private final DiscoveryNodeFilters excludeFilters;
    private final DiscoveryNodeFilters initialRecoveryFilters;
    private final Version indexCreatedVersion;
    private final Version indexUpgradedVersion;
    private final ActiveShardCount waitForActiveShards;
    private final Map<String, RolloverInfo> rolloverInfos;
    private final boolean isSystem;
    public static final String INDEX_RESIZE_SOURCE_UUID_KEY = "index.resize.source.uuid";
    public static final String INDEX_RESIZE_SOURCE_NAME_KEY = "index.resize.source.name";
    public static final Setting<String> INDEX_RESIZE_SOURCE_UUID = Setting.simpleString("index.resize.source.uuid", new Setting.Property[0]);
    public static final Setting<String> INDEX_RESIZE_SOURCE_NAME = Setting.simpleString("index.resize.source.name", new Setting.Property[0]);
    private static final ToXContent.Params FORMAT_PARAMS;
    public static final MetadataStateFormat<IndexMetadata> FORMAT;

    static Setting<Integer> buildNumberOfShardsSetting() {
        int maxNumShards = Integer.parseInt(System.getProperty(MAX_NUMBER_OF_SHARDS, "1024"));
        if (maxNumShards < 1) {
            throw new IllegalArgumentException("opensearch.index.max_number_of_shards must be > 0");
        }
        int defaultNumShards = Integer.parseInt(System.getProperty(DEFAULT_NUMBER_OF_SHARDS, "1"));
        if (defaultNumShards < 1 || defaultNumShards > maxNumShards) {
            throw new IllegalArgumentException("opensearch.index.default_number_of_shards value [" + defaultNumShards + "] must between 1 and opensearch.index.max_number_of_shards [" + maxNumShards + "]");
        }
        return Setting.intSetting(SETTING_NUMBER_OF_SHARDS, defaultNumShards, 1, maxNumShards, Setting.Property.IndexScope, Setting.Property.Final);
    }

    private static void validateRemoteStoreSettingEnabled(Map<Setting<?>, Object> settings, Setting<?> setting) {
        Boolean isRemoteSegmentStoreEnabled = (Boolean)settings.get(INDEX_REMOTE_STORE_ENABLED_SETTING);
        if (!isRemoteSegmentStoreEnabled.booleanValue()) {
            throw new IllegalArgumentException("Settings " + setting.getKey() + " can only be set/enabled when " + INDEX_REMOTE_STORE_ENABLED_SETTING.getKey() + " is set to true");
        }
    }

    private IndexMetadata(Index index, long version, long mappingVersion, long settingsVersion, long aliasesVersion, long[] primaryTerms, State state, int numberOfShards, int numberOfReplicas, Settings settings, Map<String, MappingMetadata> mappings, Map<String, AliasMetadata> aliases, Map<String, DiffableStringMap> customData, Map<Integer, Set<String>> inSyncAllocationIds, DiscoveryNodeFilters requireFilters, DiscoveryNodeFilters initialRecoveryFilters, DiscoveryNodeFilters includeFilters, DiscoveryNodeFilters excludeFilters, Version indexCreatedVersion, Version indexUpgradedVersion, int routingNumShards, int routingPartitionSize, ActiveShardCount waitForActiveShards, Map<String, RolloverInfo> rolloverInfos, boolean isSystem) {
        this.index = index;
        this.version = version;
        assert (mappingVersion >= 0L) : mappingVersion;
        this.mappingVersion = mappingVersion;
        assert (settingsVersion >= 0L) : settingsVersion;
        this.settingsVersion = settingsVersion;
        assert (aliasesVersion >= 0L) : aliasesVersion;
        this.aliasesVersion = aliasesVersion;
        this.primaryTerms = primaryTerms;
        assert (primaryTerms.length == numberOfShards);
        this.state = state;
        this.numberOfShards = numberOfShards;
        this.numberOfReplicas = numberOfReplicas;
        this.totalNumberOfShards = numberOfShards * (numberOfReplicas + 1);
        this.settings = settings;
        this.mappings = Collections.unmodifiableMap(mappings);
        this.customData = Collections.unmodifiableMap(customData);
        this.aliases = Collections.unmodifiableMap(aliases);
        this.inSyncAllocationIds = Collections.unmodifiableMap(inSyncAllocationIds);
        this.requireFilters = requireFilters;
        this.includeFilters = includeFilters;
        this.excludeFilters = excludeFilters;
        this.initialRecoveryFilters = initialRecoveryFilters;
        this.indexCreatedVersion = indexCreatedVersion;
        this.indexUpgradedVersion = indexUpgradedVersion;
        this.routingNumShards = routingNumShards;
        this.routingFactor = routingNumShards / numberOfShards;
        this.routingPartitionSize = routingPartitionSize;
        this.waitForActiveShards = waitForActiveShards;
        this.rolloverInfos = Collections.unmodifiableMap(rolloverInfos);
        this.isSystem = isSystem;
        assert (numberOfShards * this.routingFactor == routingNumShards) : routingNumShards + " must be a multiple of " + numberOfShards;
    }

    public Index getIndex() {
        return this.index;
    }

    public String getIndexUUID() {
        return this.index.getUUID();
    }

    public boolean isSameUUID(String otherUUID) {
        assert (otherUUID != null);
        assert (this.getIndexUUID() != null);
        if (INDEX_UUID_NA_VALUE.equals(otherUUID) || INDEX_UUID_NA_VALUE.equals(this.getIndexUUID())) {
            return true;
        }
        return otherUUID.equals(this.getIndexUUID());
    }

    public long getVersion() {
        return this.version;
    }

    public long getMappingVersion() {
        return this.mappingVersion;
    }

    public long getSettingsVersion() {
        return this.settingsVersion;
    }

    public long getAliasesVersion() {
        return this.aliasesVersion;
    }

    public long primaryTerm(int shardId) {
        return this.primaryTerms[shardId];
    }

    public Version getCreationVersion() {
        return this.indexCreatedVersion;
    }

    public Version getUpgradedVersion() {
        return this.indexUpgradedVersion;
    }

    public long getCreationDate() {
        return this.settings.getAsLong(SETTING_CREATION_DATE, -1L);
    }

    public State getState() {
        return this.state;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public int getRoutingPartitionSize() {
        return this.routingPartitionSize;
    }

    public boolean isRoutingPartitionedIndex() {
        return this.routingPartitionSize != 1;
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public ActiveShardCount getWaitForActiveShards() {
        return this.waitForActiveShards;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Map<String, AliasMetadata> getAliases() {
        return this.aliases;
    }

    @Nullable
    public MappingMetadata mapping() {
        Iterator<MappingMetadata> iterator = this.mappings.values().iterator();
        if (iterator.hasNext()) {
            MappingMetadata cursor = iterator.next();
            return cursor;
        }
        return null;
    }

    public Index getResizeSourceIndex() {
        return INDEX_RESIZE_SOURCE_UUID.exists(this.settings) ? new Index(INDEX_RESIZE_SOURCE_NAME.get(this.settings), INDEX_RESIZE_SOURCE_UUID.get(this.settings)) : null;
    }

    Map<String, DiffableStringMap> getCustomData() {
        return this.customData;
    }

    public Map<String, String> getCustomData(String key) {
        return this.customData.get(key);
    }

    public Map<Integer, Set<String>> getInSyncAllocationIds() {
        return this.inSyncAllocationIds;
    }

    public Map<String, RolloverInfo> getRolloverInfos() {
        return this.rolloverInfos;
    }

    public Set<String> inSyncAllocationIds(int shardId) {
        assert (shardId >= 0 && shardId < this.numberOfShards);
        return this.inSyncAllocationIds.get(shardId);
    }

    @Nullable
    public DiscoveryNodeFilters requireFilters() {
        return this.requireFilters;
    }

    @Nullable
    public DiscoveryNodeFilters getInitialRecoveryFilters() {
        return this.initialRecoveryFilters;
    }

    @Nullable
    public DiscoveryNodeFilters includeFilters() {
        return this.includeFilters;
    }

    @Nullable
    public DiscoveryNodeFilters excludeFilters() {
        return this.excludeFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexMetadata that = (IndexMetadata)o;
        if (this.version != that.version) {
            return false;
        }
        if (!this.aliases.equals(that.aliases)) {
            return false;
        }
        if (!this.index.equals((Object)that.index)) {
            return false;
        }
        if (!this.mappings.equals(that.mappings)) {
            return false;
        }
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (!this.customData.equals(that.customData)) {
            return false;
        }
        if (this.routingNumShards != that.routingNumShards) {
            return false;
        }
        if (this.routingFactor != that.routingFactor) {
            return false;
        }
        if (!Arrays.equals(this.primaryTerms, that.primaryTerms)) {
            return false;
        }
        if (!this.inSyncAllocationIds.equals(that.inSyncAllocationIds)) {
            return false;
        }
        if (!this.rolloverInfos.equals(that.rolloverInfos)) {
            return false;
        }
        return this.isSystem == that.isSystem;
    }

    public int hashCode() {
        int result = this.index.hashCode();
        result = 31 * result + Long.hashCode(this.version);
        result = 31 * result + this.state.hashCode();
        result = 31 * result + this.aliases.hashCode();
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + this.mappings.hashCode();
        result = 31 * result + this.customData.hashCode();
        result = 31 * result + Long.hashCode(this.routingFactor);
        result = 31 * result + Long.hashCode(this.routingNumShards);
        result = 31 * result + Arrays.hashCode(this.primaryTerms);
        result = 31 * result + this.inSyncAllocationIds.hashCode();
        result = 31 * result + this.rolloverInfos.hashCode();
        result = 31 * result + Boolean.hashCode(this.isSystem);
        return result;
    }

    @Override
    public Diff<IndexMetadata> diff(IndexMetadata previousState) {
        return new IndexMetadataDiff(previousState, this);
    }

    public static Diff<IndexMetadata> readDiffFrom(StreamInput in) throws IOException {
        return new IndexMetadataDiff(in);
    }

    public static IndexMetadata fromXContent(XContentParser parser) throws IOException {
        return Builder.fromXContent(parser);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder.toXContent(this, builder, params);
        return builder;
    }

    public static IndexMetadata readFrom(StreamInput in) throws IOException {
        Builder builder = new Builder(in.readString());
        builder.version(in.readLong());
        builder.mappingVersion(in.readVLong());
        builder.settingsVersion(in.readVLong());
        if (in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_2_0)) {
            builder.aliasesVersion(in.readVLong());
        } else {
            builder.aliasesVersion(1L);
        }
        builder.setRoutingNumShards(in.readInt());
        builder.state(State.fromId(in.readByte()));
        builder.settings(Settings.readSettingsFromStream(in));
        builder.primaryTerms(in.readVLongArray());
        int mappingsSize = in.readVInt();
        for (int i = 0; i < mappingsSize; ++i) {
            MappingMetadata mappingMd = new MappingMetadata(in);
            builder.putMapping(mappingMd);
        }
        int aliasesSize = in.readVInt();
        for (int i = 0; i < aliasesSize; ++i) {
            AliasMetadata aliasMd = new AliasMetadata(in);
            builder.putAlias(aliasMd);
        }
        int customSize = in.readVInt();
        for (int i = 0; i < customSize; ++i) {
            String key = in.readString();
            DiffableStringMap custom = DiffableStringMap.readFrom(in);
            builder.putCustom(key, custom);
        }
        int inSyncAllocationIdsSize = in.readVInt();
        for (int i = 0; i < inSyncAllocationIdsSize; ++i) {
            int key = in.readVInt();
            Object allocationIds = DiffableUtils.StringSetValueSerializer.getInstance().read(in, (Object)key);
            builder.putInSyncAllocationIds(key, (Set<String>)allocationIds);
        }
        int rolloverAliasesSize = in.readVInt();
        for (int i = 0; i < rolloverAliasesSize; ++i) {
            builder.putRolloverInfo(new RolloverInfo(in));
        }
        if (in.getVersion().onOrAfter(SYSTEM_INDEX_FLAG_ADDED)) {
            builder.system(in.readBoolean());
        }
        return builder.build();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.index.getName());
        out.writeLong(this.version);
        out.writeVLong(this.mappingVersion);
        out.writeVLong(this.settingsVersion);
        if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_2_0)) {
            out.writeVLong(this.aliasesVersion);
        }
        out.writeInt(this.routingNumShards);
        out.writeByte(this.state.id());
        Settings.writeSettingsToStream(this.settings, out);
        out.writeVLongArray(this.primaryTerms);
        out.writeVInt(this.mappings.size());
        for (MappingMetadata mappingMetadata : this.mappings.values()) {
            mappingMetadata.writeTo(out);
        }
        out.writeVInt(this.aliases.size());
        for (AliasMetadata aliasMetadata : this.aliases.values()) {
            aliasMetadata.writeTo(out);
        }
        out.writeVInt(this.customData.size());
        for (Map.Entry entry : this.customData.entrySet()) {
            out.writeString((String)entry.getKey());
            ((DiffableStringMap)entry.getValue()).writeTo(out);
        }
        out.writeVInt(this.inSyncAllocationIds.size());
        for (Map.Entry entry : this.inSyncAllocationIds.entrySet()) {
            out.writeVInt(((Integer)entry.getKey()).intValue());
            DiffableUtils.StringSetValueSerializer.getInstance().write((Set)entry.getValue(), out);
        }
        out.writeVInt(this.rolloverInfos.size());
        for (RolloverInfo rolloverInfo : this.rolloverInfos.values()) {
            rolloverInfo.writeTo(out);
        }
        if (out.getVersion().onOrAfter(SYSTEM_INDEX_FLAG_ADDED)) {
            out.writeBoolean(this.isSystem);
        }
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public static Builder builder(String index) {
        return new Builder(index);
    }

    public static Builder builder(IndexMetadata indexMetadata) {
        return new Builder(indexMetadata);
    }

    public static Settings addHumanReadableSettings(Settings settings) {
        Long creationDate;
        Version versionUpgraded;
        Settings.Builder builder = Settings.builder().put(settings);
        Version version = SETTING_INDEX_VERSION_CREATED.get(settings);
        if (version != Version.V_EMPTY) {
            builder.put(SETTING_VERSION_CREATED_STRING, version.toString());
        }
        if ((versionUpgraded = settings.getAsVersion(SETTING_VERSION_UPGRADED, null)) != null) {
            builder.put(SETTING_VERSION_UPGRADED_STRING, versionUpgraded.toString());
        }
        if ((creationDate = settings.getAsLong(SETTING_CREATION_DATE, null)) != null) {
            ZonedDateTime creationDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(creationDate), ZoneOffset.UTC);
            builder.put(SETTING_CREATION_DATE_STRING, creationDateTime.toString());
        }
        return builder.build();
    }

    public static Version indexCreated(Settings indexSettings) {
        Version indexVersion = SETTING_INDEX_VERSION_CREATED.get(indexSettings);
        if (indexVersion.equals((Object)Version.V_EMPTY)) {
            String message = String.format(Locale.ROOT, "[%s] is not present in the index settings for index with UUID [%s]", SETTING_INDEX_VERSION_CREATED.getKey(), indexSettings.get(SETTING_INDEX_UUID));
            throw new IllegalStateException(message);
        }
        return indexVersion;
    }

    public int getRoutingNumShards() {
        return this.routingNumShards;
    }

    public int getRoutingFactor() {
        return this.routingFactor;
    }

    public static ShardId selectSplitShard(int shardId, IndexMetadata sourceIndexMetadata, int numTargetShards) {
        int numSourceShards = sourceIndexMetadata.getNumberOfShards();
        if (shardId >= numTargetShards) {
            throw new IllegalArgumentException("the number of target shards (" + numTargetShards + ") must be greater than the shard id: " + shardId);
        }
        int routingFactor = IndexMetadata.getRoutingFactor(numSourceShards, numTargetShards);
        IndexMetadata.assertSplitMetadata(numSourceShards, numTargetShards, sourceIndexMetadata);
        return new ShardId(sourceIndexMetadata.getIndex(), shardId / routingFactor);
    }

    public static ShardId selectCloneShard(int shardId, IndexMetadata sourceIndexMetadata, int numTargetShards) {
        int numSourceShards = sourceIndexMetadata.getNumberOfShards();
        if (numSourceShards != numTargetShards) {
            throw new IllegalArgumentException("the number of target shards (" + numTargetShards + ") must be the same as the number of source shards (" + numSourceShards + ")");
        }
        return new ShardId(sourceIndexMetadata.getIndex(), shardId);
    }

    private static void assertSplitMetadata(int numSourceShards, int numTargetShards, IndexMetadata sourceIndexMetadata) {
        int routingNumShards;
        if (numSourceShards > numTargetShards) {
            throw new IllegalArgumentException("the number of source shards [" + numSourceShards + "] must be less that the number of target shards [" + numTargetShards + "]");
        }
        int n = routingNumShards = numSourceShards == 1 ? numTargetShards : sourceIndexMetadata.getRoutingNumShards();
        if (routingNumShards % numTargetShards != 0) {
            throw new IllegalStateException("the number of routing shards [" + routingNumShards + "] must be a multiple of the target shards [" + numTargetShards + "]");
        }
        assert (sourceIndexMetadata.getNumberOfShards() == 1 || IndexMetadata.getRoutingFactor(numTargetShards, routingNumShards) >= 0);
    }

    public static Set<ShardId> selectRecoverFromShards(int shardId, IndexMetadata sourceIndexMetadata, int numTargetShards) {
        if (sourceIndexMetadata.getNumberOfShards() > numTargetShards) {
            return IndexMetadata.selectShrinkShards(shardId, sourceIndexMetadata, numTargetShards);
        }
        if (sourceIndexMetadata.getNumberOfShards() < numTargetShards) {
            return Collections.singleton(IndexMetadata.selectSplitShard(shardId, sourceIndexMetadata, numTargetShards));
        }
        return Collections.singleton(IndexMetadata.selectCloneShard(shardId, sourceIndexMetadata, numTargetShards));
    }

    public static Set<ShardId> selectShrinkShards(int shardId, IndexMetadata sourceIndexMetadata, int numTargetShards) {
        if (shardId >= numTargetShards) {
            throw new IllegalArgumentException("the number of target shards (" + numTargetShards + ") must be greater than the shard id: " + shardId);
        }
        if (sourceIndexMetadata.getNumberOfShards() < numTargetShards) {
            throw new IllegalArgumentException("the number of target shards [" + numTargetShards + "] must be less that the number of source shards [" + sourceIndexMetadata.getNumberOfShards() + "]");
        }
        int routingFactor = IndexMetadata.getRoutingFactor(sourceIndexMetadata.getNumberOfShards(), numTargetShards);
        HashSet<ShardId> shards = new HashSet<ShardId>(routingFactor);
        for (int i = shardId * routingFactor; i < routingFactor * shardId + routingFactor; ++i) {
            shards.add(new ShardId(sourceIndexMetadata.getIndex(), i));
        }
        return shards;
    }

    public static int getRoutingFactor(int sourceNumberOfShards, int targetNumberOfShards) {
        int factor;
        if (sourceNumberOfShards < targetNumberOfShards) {
            factor = targetNumberOfShards / sourceNumberOfShards;
            if (factor * sourceNumberOfShards != targetNumberOfShards || factor <= 1) {
                throw new IllegalArgumentException("the number of source shards [" + sourceNumberOfShards + "] must be a factor of [" + targetNumberOfShards + "]");
            }
        } else if (sourceNumberOfShards > targetNumberOfShards) {
            factor = sourceNumberOfShards / targetNumberOfShards;
            if (factor * targetNumberOfShards != sourceNumberOfShards || factor <= 1) {
                throw new IllegalArgumentException("the number of source shards [" + sourceNumberOfShards + "] must be a multiple of [" + targetNumberOfShards + "]");
            }
        } else {
            factor = 1;
        }
        return factor;
    }

    public static int parseIndexNameCounter(String indexName) {
        int numberIndex = indexName.lastIndexOf("-");
        if (numberIndex == -1) {
            throw new IllegalArgumentException("no - separator found in index name [" + indexName + "]");
        }
        try {
            return Integer.parseInt(indexName.substring(numberIndex + 1, indexName.endsWith(">") ? indexName.length() - 1 : indexName.length()));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse the index name [" + indexName + "] to extract the counter", e);
        }
    }

    static {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("binary", "true");
        params.put("context_mode", Metadata.CONTEXT_MODE_GATEWAY);
        FORMAT_PARAMS = new ToXContent.MapParams(params);
        FORMAT = new MetadataStateFormat<IndexMetadata>(INDEX_STATE_FILE_PREFIX){

            @Override
            public void toXContent(XContentBuilder builder, IndexMetadata state) throws IOException {
                Builder.toXContent(state, builder, FORMAT_PARAMS);
            }

            @Override
            public IndexMetadata fromXContent(XContentParser parser) throws IOException {
                return Builder.fromXContent(parser);
            }
        };
    }

    public static class Builder {
        private String index;
        private State state = State.OPEN;
        private long version = 1L;
        private long mappingVersion = 1L;
        private long settingsVersion = 1L;
        private long aliasesVersion = 1L;
        private long[] primaryTerms = null;
        private Settings settings = Settings.Builder.EMPTY_SETTINGS;
        private final Map<String, MappingMetadata> mappings;
        private final Map<String, AliasMetadata> aliases;
        private final Map<String, DiffableStringMap> customMetadata;
        private final Map<Integer, Set<String>> inSyncAllocationIds;
        private final Map<String, RolloverInfo> rolloverInfos;
        private Integer routingNumShards;
        private boolean isSystem;

        public Builder(String index) {
            this.index = index;
            this.mappings = new HashMap<String, MappingMetadata>();
            this.aliases = new HashMap<String, AliasMetadata>();
            this.customMetadata = new HashMap<String, DiffableStringMap>();
            this.inSyncAllocationIds = new HashMap<Integer, Set<String>>();
            this.rolloverInfos = new HashMap<String, RolloverInfo>();
            this.isSystem = false;
        }

        public Builder(IndexMetadata indexMetadata) {
            this.index = indexMetadata.getIndex().getName();
            this.state = indexMetadata.state;
            this.version = indexMetadata.version;
            this.mappingVersion = indexMetadata.mappingVersion;
            this.settingsVersion = indexMetadata.settingsVersion;
            this.aliasesVersion = indexMetadata.aliasesVersion;
            this.settings = indexMetadata.getSettings();
            this.primaryTerms = (long[])indexMetadata.primaryTerms.clone();
            this.mappings = new HashMap<String, MappingMetadata>(indexMetadata.mappings);
            this.aliases = new HashMap<String, AliasMetadata>(indexMetadata.aliases);
            this.customMetadata = new HashMap<String, DiffableStringMap>(indexMetadata.customData);
            this.routingNumShards = indexMetadata.routingNumShards;
            this.inSyncAllocationIds = new HashMap<Integer, Set<String>>(indexMetadata.inSyncAllocationIds);
            this.rolloverInfos = new HashMap<String, RolloverInfo>(indexMetadata.rolloverInfos);
            this.isSystem = indexMetadata.isSystem;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder numberOfShards(int numberOfShards) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetadata.SETTING_NUMBER_OF_SHARDS, numberOfShards).build();
            return this;
        }

        public Builder setRoutingNumShards(int routingNumShards) {
            this.routingNumShards = routingNumShards;
            return this;
        }

        public int getRoutingNumShards() {
            return this.routingNumShards == null ? this.numberOfShards() : this.routingNumShards.intValue();
        }

        public int numberOfShards() {
            return this.settings.getAsInt(IndexMetadata.SETTING_NUMBER_OF_SHARDS, -1);
        }

        public Builder numberOfReplicas(int numberOfReplicas) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetadata.SETTING_NUMBER_OF_REPLICAS, numberOfReplicas).build();
            return this;
        }

        public Builder routingPartitionSize(int routingPartitionSize) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetadata.SETTING_ROUTING_PARTITION_SIZE, routingPartitionSize).build();
            return this;
        }

        public Builder creationDate(long creationDate) {
            this.settings = Settings.builder().put(this.settings).put(IndexMetadata.SETTING_CREATION_DATE, creationDate).build();
            return this;
        }

        public Builder settings(Settings.Builder settings) {
            return this.settings(settings.build());
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public MappingMetadata mapping() {
            return this.mappings.get("_doc");
        }

        public Builder putMapping(String source) throws IOException {
            this.putMapping(new MappingMetadata("_doc", XContentHelper.convertToMap(MediaTypeRegistry.xContent((CharSequence)source).xContent(), source, true)));
            return this;
        }

        public Builder putMapping(MappingMetadata mappingMd) {
            this.mappings.clear();
            if (mappingMd != null) {
                this.mappings.put(mappingMd.type(), mappingMd);
            }
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder putAlias(AliasMetadata aliasMetadata) {
            this.aliases.put(aliasMetadata.alias(), aliasMetadata);
            return this;
        }

        public Builder putAlias(AliasMetadata.Builder aliasMetadata) {
            this.aliases.put(aliasMetadata.alias(), aliasMetadata.build());
            return this;
        }

        public Builder removeAlias(String alias) {
            this.aliases.remove(alias);
            return this;
        }

        public Builder removeAllAliases() {
            this.aliases.clear();
            return this;
        }

        public Builder putCustom(String type, Map<String, String> customIndexMetadata) {
            this.customMetadata.put(type, new DiffableStringMap(customIndexMetadata));
            return this;
        }

        public Map<String, String> removeCustom(String type) {
            return this.customMetadata.remove(type);
        }

        public Set<String> getInSyncAllocationIds(int shardId) {
            return this.inSyncAllocationIds.get(shardId);
        }

        public Builder putInSyncAllocationIds(int shardId, Set<String> allocationIds) {
            this.inSyncAllocationIds.put(shardId, new HashSet<String>(allocationIds));
            return this;
        }

        public Builder putRolloverInfo(RolloverInfo rolloverInfo) {
            this.rolloverInfos.put(rolloverInfo.getAlias(), rolloverInfo);
            return this;
        }

        public long version() {
            return this.version;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public long mappingVersion() {
            return this.mappingVersion;
        }

        public Builder mappingVersion(long mappingVersion) {
            this.mappingVersion = mappingVersion;
            return this;
        }

        public long settingsVersion() {
            return this.settingsVersion;
        }

        public Builder settingsVersion(long settingsVersion) {
            this.settingsVersion = settingsVersion;
            return this;
        }

        public long aliasesVersion() {
            return this.aliasesVersion;
        }

        public Builder aliasesVersion(long aliasesVersion) {
            this.aliasesVersion = aliasesVersion;
            return this;
        }

        public long primaryTerm(int shardId) {
            if (this.primaryTerms == null) {
                this.initializePrimaryTerms();
            }
            return this.primaryTerms[shardId];
        }

        public Builder primaryTerm(int shardId, long primaryTerm) {
            if (this.primaryTerms == null) {
                this.initializePrimaryTerms();
            }
            this.primaryTerms[shardId] = primaryTerm;
            return this;
        }

        private void primaryTerms(long[] primaryTerms) {
            this.primaryTerms = (long[])primaryTerms.clone();
        }

        private void initializePrimaryTerms() {
            assert (this.primaryTerms == null);
            if (this.numberOfShards() < 0) {
                throw new IllegalStateException("you must set the number of shards before setting/reading primary terms");
            }
            this.primaryTerms = new long[this.numberOfShards()];
            Arrays.fill(this.primaryTerms, 0L);
        }

        public Builder system(boolean system) {
            this.isSystem = system;
            return this;
        }

        public boolean isSystem() {
            return this.isSystem;
        }

        public IndexMetadata build() {
            Map<String, AliasMetadata> tmpAliases = this.aliases;
            Settings tmpSettings = this.settings;
            if (!INDEX_NUMBER_OF_SHARDS_SETTING.exists(this.settings)) {
                throw new IllegalArgumentException("must specify number of shards for index [" + this.index + "]");
            }
            int numberOfShards = INDEX_NUMBER_OF_SHARDS_SETTING.get(this.settings);
            if (!INDEX_NUMBER_OF_REPLICAS_SETTING.exists(this.settings)) {
                throw new IllegalArgumentException("must specify number of replicas for index [" + this.index + "]");
            }
            int numberOfReplicas = INDEX_NUMBER_OF_REPLICAS_SETTING.get(this.settings);
            int routingPartitionSize = INDEX_ROUTING_PARTITION_SIZE_SETTING.get(this.settings);
            if (routingPartitionSize != 1 && routingPartitionSize >= this.getRoutingNumShards()) {
                throw new IllegalArgumentException("routing partition size [" + routingPartitionSize + "] should be a positive number less than the number of shards [" + this.getRoutingNumShards() + "] for [" + this.index + "]");
            }
            HashMap<Integer, Set<String>> filledInSyncAllocationIds = new HashMap<Integer, Set<String>>();
            for (int i = 0; i < numberOfShards; ++i) {
                if (this.inSyncAllocationIds.containsKey(i)) {
                    filledInSyncAllocationIds.put(i, Collections.unmodifiableSet(new HashSet(this.inSyncAllocationIds.get(i))));
                    continue;
                }
                filledInSyncAllocationIds.put(i, Collections.emptySet());
            }
            Map<String, String> requireMap = INDEX_ROUTING_REQUIRE_GROUP_SETTING.getAsMap(this.settings);
            DiscoveryNodeFilters requireFilters = requireMap.isEmpty() ? null : DiscoveryNodeFilters.buildOrUpdateFromKeyValue(null, DiscoveryNodeFilters.OpType.AND, requireMap);
            Map<String, String> includeMap = INDEX_ROUTING_INCLUDE_GROUP_SETTING.getAsMap(this.settings);
            DiscoveryNodeFilters includeFilters = includeMap.isEmpty() ? null : DiscoveryNodeFilters.buildOrUpdateFromKeyValue(null, DiscoveryNodeFilters.OpType.OR, includeMap);
            Map<String, String> excludeMap = INDEX_ROUTING_EXCLUDE_GROUP_SETTING.getAsMap(this.settings);
            DiscoveryNodeFilters excludeFilters = excludeMap.isEmpty() ? null : DiscoveryNodeFilters.buildOrUpdateFromKeyValue(null, DiscoveryNodeFilters.OpType.OR, excludeMap);
            Map<String, String> initialRecoveryMap = INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING.getAsMap(this.settings);
            DiscoveryNodeFilters initialRecoveryFilters = initialRecoveryMap.isEmpty() ? null : DiscoveryNodeFilters.buildOrUpdateFromKeyValue(null, DiscoveryNodeFilters.OpType.OR, initialRecoveryMap);
            Version indexCreatedVersion = IndexMetadata.indexCreated(this.settings);
            Version indexUpgradedVersion = this.settings.getAsVersion(IndexMetadata.SETTING_VERSION_UPGRADED, indexCreatedVersion);
            if (this.primaryTerms == null) {
                this.initializePrimaryTerms();
            } else if (this.primaryTerms.length != numberOfShards) {
                throw new IllegalStateException("primaryTerms length is [" + this.primaryTerms.length + "] but should be equal to number of shards [" + this.numberOfShards() + "]");
            }
            ActiveShardCount waitForActiveShards = SETTING_WAIT_FOR_ACTIVE_SHARDS.get(this.settings);
            if (!waitForActiveShards.validate(numberOfReplicas)) {
                throw new IllegalArgumentException("invalid " + SETTING_WAIT_FOR_ACTIVE_SHARDS.getKey() + "[" + waitForActiveShards + "]: cannot be greater than number of shard copies [" + (numberOfReplicas + 1) + "]");
            }
            String uuid = this.settings.get(IndexMetadata.SETTING_INDEX_UUID, IndexMetadata.INDEX_UUID_NA_VALUE);
            return new IndexMetadata(new Index(this.index, uuid), this.version, this.mappingVersion, this.settingsVersion, this.aliasesVersion, this.primaryTerms, this.state, numberOfShards, numberOfReplicas, tmpSettings, this.mappings, tmpAliases, this.customMetadata, filledInSyncAllocationIds, requireFilters, initialRecoveryFilters, includeFilters, excludeFilters, indexCreatedVersion, indexUpgradedVersion, this.getRoutingNumShards(), routingPartitionSize, waitForActiveShards, this.rolloverInfos, this.isSystem);
        }

        /*
         * WARNING - void declaration
         */
        public static void toXContent(IndexMetadata indexMetadata, XContentBuilder builder, ToXContent.Params params) throws IOException {
            Iterator<AliasMetadata> mmd;
            Metadata.XContentContext context = Metadata.XContentContext.valueOf(params.param("context_mode", Metadata.CONTEXT_MODE_API));
            builder.startObject(indexMetadata.getIndex().getName());
            builder.field(IndexMetadata.KEY_VERSION, indexMetadata.getVersion());
            builder.field(IndexMetadata.KEY_MAPPING_VERSION, indexMetadata.getMappingVersion());
            builder.field(IndexMetadata.KEY_SETTINGS_VERSION, indexMetadata.getSettingsVersion());
            builder.field(IndexMetadata.KEY_ALIASES_VERSION, indexMetadata.getAliasesVersion());
            builder.field(IndexMetadata.KEY_ROUTING_NUM_SHARDS, indexMetadata.getRoutingNumShards());
            builder.field(IndexMetadata.KEY_STATE, indexMetadata.getState().toString().toLowerCase(Locale.ENGLISH));
            boolean binary = params.paramAsBoolean("binary", false);
            builder.startObject(IndexMetadata.KEY_SETTINGS);
            if (context != Metadata.XContentContext.API) {
                indexMetadata.getSettings().toXContent(builder, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
            } else {
                indexMetadata.getSettings().toXContent(builder, params);
            }
            builder.endObject();
            if (context != Metadata.XContentContext.API) {
                builder.startArray(IndexMetadata.KEY_MAPPINGS);
                mmd = indexMetadata.mapping();
                if (mmd != null) {
                    if (binary) {
                        builder.value(((MappingMetadata)((Object)mmd)).source().compressed());
                    } else {
                        builder.map((Map)XContentHelper.convertToMap(((MappingMetadata)((Object)mmd)).source().uncompressed(), true).v2());
                    }
                }
                builder.endArray();
            } else {
                builder.startObject(IndexMetadata.KEY_MAPPINGS);
                mmd = indexMetadata.mapping();
                if (mmd != null) {
                    void var6_10;
                    Map map = (Map)XContentHelper.convertToMap(((MappingMetadata)((Object)mmd)).source().uncompressed(), false).v2();
                    if (map.size() == 1 && map.containsKey(((MappingMetadata)((Object)mmd)).type())) {
                        Map map2 = (Map)map.get(((MappingMetadata)((Object)mmd)).type());
                    }
                    builder.field(((MappingMetadata)((Object)mmd)).type());
                    builder.map((Map)var6_10);
                }
                builder.endObject();
            }
            for (Map.Entry entry : indexMetadata.customData.entrySet()) {
                builder.field((String)entry.getKey());
                builder.map((Map)entry.getValue());
            }
            if (context != Metadata.XContentContext.API) {
                builder.startObject(IndexMetadata.KEY_ALIASES);
                for (AliasMetadata aliasMetadata : indexMetadata.getAliases().values()) {
                    AliasMetadata.Builder.toXContent(aliasMetadata, builder, params);
                }
                builder.endObject();
                builder.startArray(IndexMetadata.KEY_PRIMARY_TERMS);
                for (int i = 0; i < indexMetadata.getNumberOfShards(); ++i) {
                    builder.value(indexMetadata.primaryTerm(i));
                }
                builder.endArray();
            } else {
                builder.startArray(IndexMetadata.KEY_ALIASES);
                for (String string : indexMetadata.getAliases().keySet()) {
                    builder.value(string);
                }
                builder.endArray();
                builder.startObject(IndexMetadata.KEY_PRIMARY_TERMS);
                for (int shard = 0; shard < indexMetadata.getNumberOfShards(); ++shard) {
                    builder.field(Integer.toString(shard), indexMetadata.primaryTerm(shard));
                }
                builder.endObject();
            }
            builder.startObject(IndexMetadata.KEY_IN_SYNC_ALLOCATIONS);
            for (Map.Entry<Integer, Set<String>> entry : indexMetadata.inSyncAllocationIds.entrySet()) {
                builder.startArray(String.valueOf(entry.getKey()));
                for (String allocationId : entry.getValue()) {
                    builder.value(allocationId);
                }
                builder.endArray();
            }
            builder.endObject();
            builder.startObject(IndexMetadata.KEY_ROLLOVER_INFOS);
            for (RolloverInfo rolloverInfo : indexMetadata.getRolloverInfos().values()) {
                rolloverInfo.toXContent(builder, params);
            }
            builder.endObject();
            builder.field(IndexMetadata.KEY_SYSTEM, indexMetadata.isSystem);
            builder.endObject();
        }

        public static IndexMetadata fromXContent(XContentParser parser) throws IOException {
            if (parser.currentToken() == null) {
                parser.nextToken();
            }
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
            }
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
                throw new IllegalArgumentException("expected field name but got a " + parser.currentToken());
            }
            Builder builder = new Builder(parser.currentName());
            String currentFieldName = null;
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("expected object but got a " + token);
            }
            boolean mappingVersion = false;
            boolean settingsVersion = false;
            boolean aliasesVersion = false;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (IndexMetadata.KEY_SETTINGS.equals(currentFieldName)) {
                        builder.settings(Settings.fromXContent(parser));
                        continue;
                    }
                    if (IndexMetadata.KEY_MAPPINGS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.START_OBJECT) {
                                String mappingType = currentFieldName;
                                Map mappingSource = MapBuilder.newMapBuilder().put((Object)mappingType, (Object)parser.mapOrdered()).map();
                                builder.putMapping(new MappingMetadata(mappingType, mappingSource));
                                continue;
                            }
                            throw new IllegalArgumentException("Unexpected token: " + token);
                        }
                        continue;
                    }
                    if (IndexMetadata.KEY_ALIASES.equals(currentFieldName)) {
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            builder.putAlias(AliasMetadata.Builder.fromXContent(parser));
                        }
                        continue;
                    }
                    if (IndexMetadata.KEY_IN_SYNC_ALLOCATIONS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.START_ARRAY) {
                                String shardId = currentFieldName;
                                HashSet<String> allocationIds = new HashSet<String>();
                                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                                    if (token != XContentParser.Token.VALUE_STRING) continue;
                                    allocationIds.add(parser.text());
                                }
                                builder.putInSyncAllocationIds(Integer.valueOf(shardId), allocationIds);
                                continue;
                            }
                            throw new IllegalArgumentException("Unexpected token: " + token);
                        }
                        continue;
                    }
                    if (IndexMetadata.KEY_ROLLOVER_INFOS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token == XContentParser.Token.START_OBJECT) {
                                builder.putRolloverInfo(RolloverInfo.parse(parser, currentFieldName));
                                continue;
                            }
                            throw new IllegalArgumentException("Unexpected token: " + token);
                        }
                        continue;
                    }
                    if ("warmers".equals(currentFieldName)) {
                        assert (Version.CURRENT.major <= 5);
                        parser.skipChildren();
                        continue;
                    }
                    builder.putCustom(currentFieldName, parser.mapStrings());
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (IndexMetadata.KEY_MAPPINGS.equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                                builder.putMapping(new MappingMetadata(new CompressedXContent(parser.binaryValue())));
                                continue;
                            }
                            Map mapping = parser.mapOrdered();
                            if (mapping.size() != 1) continue;
                            String mappingType = (String)mapping.keySet().iterator().next();
                            builder.putMapping(new MappingMetadata(mappingType, mapping));
                        }
                        continue;
                    }
                    if (IndexMetadata.KEY_PRIMARY_TERMS.equals(currentFieldName)) {
                        ArrayList<Long> list = new ArrayList<Long>();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.VALUE_NUMBER) {
                                list.add(parser.longValue());
                                continue;
                            }
                            throw new IllegalStateException("found a non-numeric value under [primary_terms]");
                        }
                        builder.primaryTerms(list.stream().mapToLong(i -> i).toArray());
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field for an array " + currentFieldName);
                }
                if (token.isValue()) {
                    if (IndexMetadata.KEY_STATE.equals(currentFieldName)) {
                        builder.state(State.fromString(parser.text()));
                        continue;
                    }
                    if (IndexMetadata.KEY_VERSION.equals(currentFieldName)) {
                        builder.version(parser.longValue());
                        continue;
                    }
                    if (IndexMetadata.KEY_MAPPING_VERSION.equals(currentFieldName)) {
                        mappingVersion = true;
                        builder.mappingVersion(parser.longValue());
                        continue;
                    }
                    if (IndexMetadata.KEY_SETTINGS_VERSION.equals(currentFieldName)) {
                        settingsVersion = true;
                        builder.settingsVersion(parser.longValue());
                        continue;
                    }
                    if (IndexMetadata.KEY_ALIASES_VERSION.equals(currentFieldName)) {
                        aliasesVersion = true;
                        builder.aliasesVersion(parser.longValue());
                        continue;
                    }
                    if (IndexMetadata.KEY_ROUTING_NUM_SHARDS.equals(currentFieldName)) {
                        builder.setRoutingNumShards(parser.intValue());
                        continue;
                    }
                    if (IndexMetadata.KEY_SYSTEM.equals(currentFieldName)) {
                        builder.system(parser.booleanValue());
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field [" + currentFieldName + "]");
                }
                throw new IllegalArgumentException("Unexpected token " + token);
            }
            Version legacyVersion = LegacyESVersion.fromId((int)6050099);
            if (Assertions.ENABLED && IndexMetadata.indexCreated(builder.settings).onOrAfter(legacyVersion)) {
                assert (mappingVersion) : "mapping version should be present for indices";
                assert (settingsVersion) : "settings version should be present for indices";
            }
            if (Assertions.ENABLED && IndexMetadata.indexCreated(builder.settings).onOrAfter((Version)LegacyESVersion.V_7_2_0)) assert (aliasesVersion) : "aliases version should be present for indices created on or after 7.2.0";
            return builder.build();
        }
    }

    private static class IndexMetadataDiff
    implements Diff<IndexMetadata> {
        private final String index;
        private final int routingNumShards;
        private final long version;
        private final long mappingVersion;
        private final long settingsVersion;
        private final long aliasesVersion;
        private final long[] primaryTerms;
        private final State state;
        private final Settings settings;
        private final Diff<Map<String, MappingMetadata>> mappings;
        private final Diff<Map<String, AliasMetadata>> aliases;
        private final Diff<Map<String, DiffableStringMap>> customData;
        private final Diff<Map<Integer, Set<String>>> inSyncAllocationIds;
        private final Diff<Map<String, RolloverInfo>> rolloverInfos;
        private final boolean isSystem;
        private static final DiffableUtils.DiffableValueReader<String, AliasMetadata> ALIAS_METADATA_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(AliasMetadata::new, AliasMetadata::readDiffFrom);
        private static final DiffableUtils.DiffableValueReader<String, MappingMetadata> MAPPING_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(MappingMetadata::new, MappingMetadata::readDiffFrom);
        private static final DiffableUtils.DiffableValueReader<String, DiffableStringMap> CUSTOM_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(DiffableStringMap::readFrom, DiffableStringMap::readDiffFrom);
        private static final DiffableUtils.DiffableValueReader<String, RolloverInfo> ROLLOVER_INFO_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(RolloverInfo::new, RolloverInfo::readDiffFrom);

        IndexMetadataDiff(IndexMetadata before, IndexMetadata after) {
            this.index = after.index.getName();
            this.version = after.version;
            this.mappingVersion = after.mappingVersion;
            this.settingsVersion = after.settingsVersion;
            this.aliasesVersion = after.aliasesVersion;
            this.routingNumShards = after.routingNumShards;
            this.state = after.state;
            this.settings = after.settings;
            this.primaryTerms = after.primaryTerms;
            this.mappings = DiffableUtils.diff(before.mappings, after.mappings, DiffableUtils.getStringKeySerializer());
            this.aliases = DiffableUtils.diff(before.aliases, after.aliases, DiffableUtils.getStringKeySerializer());
            this.customData = DiffableUtils.diff(before.customData, after.customData, DiffableUtils.getStringKeySerializer());
            this.inSyncAllocationIds = DiffableUtils.diff(before.inSyncAllocationIds, after.inSyncAllocationIds, DiffableUtils.getVIntKeySerializer(), DiffableUtils.StringSetValueSerializer.getInstance());
            this.rolloverInfos = DiffableUtils.diff(before.rolloverInfos, after.rolloverInfos, DiffableUtils.getStringKeySerializer());
            this.isSystem = after.isSystem;
        }

        IndexMetadataDiff(StreamInput in) throws IOException {
            this.index = in.readString();
            this.routingNumShards = in.readInt();
            this.version = in.readLong();
            this.mappingVersion = in.readVLong();
            this.settingsVersion = in.readVLong();
            this.aliasesVersion = in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_2_0) ? in.readVLong() : 1L;
            this.state = State.fromId(in.readByte());
            this.settings = Settings.readSettingsFromStream(in);
            this.primaryTerms = in.readVLongArray();
            this.mappings = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), MAPPING_DIFF_VALUE_READER);
            this.aliases = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), ALIAS_METADATA_DIFF_VALUE_READER);
            this.customData = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), CUSTOM_DIFF_VALUE_READER);
            this.inSyncAllocationIds = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getVIntKeySerializer(), DiffableUtils.StringSetValueSerializer.getInstance());
            this.rolloverInfos = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), ROLLOVER_INFO_DIFF_VALUE_READER);
            this.isSystem = in.getVersion().onOrAfter(SYSTEM_INDEX_FLAG_ADDED) ? in.readBoolean() : false;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeInt(this.routingNumShards);
            out.writeLong(this.version);
            out.writeVLong(this.mappingVersion);
            out.writeVLong(this.settingsVersion);
            if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_2_0)) {
                out.writeVLong(this.aliasesVersion);
            }
            out.writeByte(this.state.id);
            Settings.writeSettingsToStream(this.settings, out);
            out.writeVLongArray(this.primaryTerms);
            this.mappings.writeTo(out);
            this.aliases.writeTo(out);
            this.customData.writeTo(out);
            this.inSyncAllocationIds.writeTo(out);
            this.rolloverInfos.writeTo(out);
            if (out.getVersion().onOrAfter(SYSTEM_INDEX_FLAG_ADDED)) {
                out.writeBoolean(this.isSystem);
            }
        }

        @Override
        public IndexMetadata apply(IndexMetadata part) {
            Builder builder = IndexMetadata.builder(this.index);
            builder.version(this.version);
            builder.mappingVersion(this.mappingVersion);
            builder.settingsVersion(this.settingsVersion);
            builder.aliasesVersion(this.aliasesVersion);
            builder.setRoutingNumShards(this.routingNumShards);
            builder.state(this.state);
            builder.settings(this.settings);
            builder.primaryTerms(this.primaryTerms);
            builder.mappings.putAll(this.mappings.apply(part.mappings));
            builder.aliases.putAll(this.aliases.apply(part.aliases));
            builder.customMetadata.putAll(this.customData.apply(part.customData));
            builder.inSyncAllocationIds.putAll(this.inSyncAllocationIds.apply(part.inSyncAllocationIds));
            builder.rolloverInfos.putAll(this.rolloverInfos.apply(part.rolloverInfos));
            builder.system(part.isSystem);
            return builder.build();
        }
    }

    public static enum APIBlock implements Writeable
    {
        READ_ONLY("read_only", INDEX_READ_ONLY_BLOCK),
        READ("read", INDEX_READ_BLOCK),
        WRITE("write", INDEX_WRITE_BLOCK),
        METADATA("metadata", INDEX_METADATA_BLOCK),
        READ_ONLY_ALLOW_DELETE("read_only_allow_delete", INDEX_READ_ONLY_ALLOW_DELETE_BLOCK);

        final String name;
        final String settingName;
        final Setting<Boolean> setting;
        final ClusterBlock block;

        private APIBlock(String name, ClusterBlock block) {
            this.name = name;
            this.settingName = "index.blocks." + name;
            this.setting = Setting.boolSetting(this.settingName, false, Setting.Property.Dynamic, Setting.Property.IndexScope);
            this.block = block;
        }

        public String settingName() {
            return this.settingName;
        }

        public Setting<Boolean> setting() {
            return this.setting;
        }

        public ClusterBlock getBlock() {
            return this.block;
        }

        public static APIBlock fromName(String name) {
            for (APIBlock block : APIBlock.values()) {
                if (!block.name.equals(name)) continue;
                return block;
            }
            throw new IllegalArgumentException("No block found with name " + name);
        }

        public static APIBlock fromSetting(String settingName) {
            for (APIBlock block : APIBlock.values()) {
                if (!block.settingName.equals(settingName)) continue;
                return block;
            }
            throw new IllegalArgumentException("No block found with setting name " + settingName);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal());
        }

        public static APIBlock readFrom(StreamInput input) throws IOException {
            return APIBlock.values()[input.readVInt()];
        }
    }

    public static enum State {
        OPEN(0),
        CLOSE(1);

        private final byte id;

        private State(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static State fromId(byte id) {
            if (id == 0) {
                return OPEN;
            }
            if (id == 1) {
                return CLOSE;
            }
            throw new IllegalStateException("No state match for id [" + id + "]");
        }

        public static State fromString(String state) {
            if ("open".equals(state)) {
                return OPEN;
            }
            if ("close".equals(state)) {
                return CLOSE;
            }
            throw new IllegalStateException("No state match for [" + state + "]");
        }
    }
}

