/*! For license information please see bookmarks-node_modules_vue-material-design-icons_FolderOpen_vue-node_modules_vue-material-design-icons_-066f70.js.LICENSE.txt */
"use strict";(self.webpackChunkbookmarks=self.webpackChunkbookmarks||[]).push([["node_modules_vue-material-design-icons_FolderOpen_vue-node_modules_vue-material-design-icons_-066f70"],{71938:(t,e,n)=>{n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.folderpicker-dialog {\n\tmin-width: 300px;\n\theight: 300px;\n\toverflow-y: scroll;\n\tpadding: 10px;\n}\n","",{version:3,sources:["webpack://./src/components/FolderPickerDialog.vue"],names:[],mappings:";AAqDA;CACA,gBAAA;CACA,aAAA;CACA,kBAAA;CACA,aAAA;AACA",sourcesContent:["\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcModal v-if=\"show\" :title=\"t('bookmarks', 'Select folder')\" @close=\"onClose\">\n\t\t<div class=\"folderpicker-dialog\">\n\t\t\t<FolderPicker :title=\"t('bookmarks', 'Select folder')\" @submit=\"onSelect\" />\n\t\t</div>\n\t</NcModal>\n</template>\n<script>\nimport { NcModal } from '@nextcloud/vue'\nimport FolderPicker from './FolderPicker.vue'\n\nexport default {\n\tname: 'FolderPickerDialog',\n\tcomponents: {\n\t\tFolderPicker,\n\t\tNcModal,\n\t},\n\tprops: {\n\t\tvalue: {\n\t\t\ttype: Number,\n\t\t\tdefault: -1,\n\t\t},\n\t\tshow: {\n\t\t\ttype: Boolean,\n\t\t\tdefault: true,\n\t\t},\n\t},\n\tcomputed: {\n\t\tallFolders() {\n\t\t\treturn this.$store.state.folders\n\t\t},\n\t},\n\tcreated() {},\n\tmethods: {\n\t\tonSelect(folderId) {\n\t\t\tthis.$root.$emit('select', folderId)\n\t\t\tthis.$emit('input', folderId)\n\t\t\tthis.$emit('close')\n\t\t},\n\t\tonClose() {\n\t\t\tthis.$root.$emit('close')\n\t\t\tthis.$emit('close')\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.folderpicker-dialog {\n\tmin-width: 300px;\n\theight: 300px;\n\toverflow-y: scroll;\n\tpadding: 10px;\n}\n</style>\n"],sourceRoot:""}]);const s=a},78931:(t,e,n)=>{n.d(e,{Z:()=>s});var o=n(87537),r=n.n(o),i=n(23645),a=n.n(i)()(r());a.push([t.id,"\n.bookmarklet {\n\tmargin: 30px auto;\n\twidth: 70%;\n}\n.bookmarklet__exists {\n\tbackground: var(--color-background-dark);\n\tborder-radius: var(--border-radius-pill);\n\tfont-weight: bold;\n\tpadding: 10px 20px;\n}\nfigure[class^=icon-] {\n\tdisplay: inline-block;\n}\n.bookmarklet label {\n\tmargin-top: 10px;\n\tdisplay: flex;\n\talign-items: center;\n\talign-content: space-evenly;\n}\n.bookmarklet label :last-child {\n\tmargin-left: 10px;\n}\n.bookmarklet input {\n\twidth: 100%;\n\tdisplay: block;\n}\n.bookmarklet__notes {\n\tmin-height: 100px !important;\n\twidth: auto !important;\n}\n","",{version:3,sources:["webpack://./src/components/ViewBookmarklet.vue"],names:[],mappings:";AAwKA;CACA,iBAAA;CACA,UAAA;AACA;AAEA;CACA,wCAAA;CACA,wCAAA;CACA,iBAAA;CACA,kBAAA;AACA;AAEA;CACA,qBAAA;AACA;AAEA;CACA,gBAAA;CACA,aAAA;CACA,mBAAA;CACA,2BAAA;AACA;AAEA;CACA,iBAAA;AACA;AAEA;CACA,WAAA;CACA,cAAA;AACA;AAEA;CACA,4BAAA;CACA,sBAAA;AACA",sourcesContent:['\x3c!--\n  - Copyright (c) 2020. The Nextcloud Bookmarks contributors.\n  -\n  - This file is licensed under the Affero General Public License version 3 or later. See the COPYING file.\n  --\x3e\n\n<template>\n\t<NcContent app-name="bookmarks">\n\t\t<NcAppContent>\n\t\t\t<div class="bookmarklet">\n\t\t\t\t<h2><figure :class="loading? \'icon-loading-small\' : \'icon-link\'" /> {{ t(\'bookmarks\', \'Add a bookmark\') }}</h2>\n\t\t\t\t<div v-if="exists" class="bookmarklet__exists">\n\t\t\t\t\t{{ t(\'bookmarks\', \'This URL is already bookmarked! Overwrite?\') }}\n\t\t\t\t</div>\n\t\t\t\t<label>{{ t(\'bookmarks\', \'Title\') }}\n\t\t\t\t\t<input v-model="bookmark.title" type="text" :placeholder="t(\'bookmarks\', \'Enter bookmark title\')">\n\t\t\t\t</label>\n\t\t\t\t<label>{{ t(\'bookmarks\', \'Link\') }}\n\t\t\t\t\t<input v-model="bookmark.url" type="text" :placeholder="t(\'bookmarks\', \'Enter bookmark URL\')">\n\t\t\t\t</label>\n\t\t\t\t<label><figure class="icon-tag" /> {{ t(\'bookmarks\', \'Tags\') }}\n\t\t\t\t\t<NcMultiselect class="sidebar__tags"\n\t\t\t\t\t\t:value="bookmark.tags"\n\t\t\t\t\t\t:auto-limit="false"\n\t\t\t\t\t\t:limit="7"\n\t\t\t\t\t\t:options="allTags"\n\t\t\t\t\t\t:multiple="true"\n\t\t\t\t\t\t:taggable="true"\n\t\t\t\t\t\t@input="onTagsChange"\n\t\t\t\t\t\t@tag="onAddTag" />\n\t\t\t\t</label>\n\t\t\t\t<label><figure class="icon-folder" /> {{ t(\'bookmarks\', \'Folder\') }}\n\t\t\t\t\t<input :value="folderTitle"\n\t\t\t\t\t\ttype="text"\n\t\t\t\t\t\treadonly\n\t\t\t\t\t\t:placeholder="t(\'bookmarks\', \'Root Folder\')"\n\t\t\t\t\t\t@click="showPicker = true">\n\t\t\t\t\t<FolderPickerDialog v-model="folder" :show="showPicker" @close="showPicker = false" />\n\t\t\t\t</label>\n\t\t\t\t<label>{{ t(\'bookmarks\', \'Notes\') }}</label>\n\t\t\t\t<div class="bookmarklet__notes"\n\t\t\t\t\tcontenteditable\n\t\t\t\t\t@input="onNotesChange">\n\t\t\t\t\t{{ description }}\n\t\t\t\t</div>\n\t\t\t\t<button class="primary" @click="submit">\n\t\t\t\t\t<span class="icon-confirm-white" />{{ t(\'bookmarks\', \'Save\') }}\n\t\t\t\t</button>\n\t\t\t</div>\n\t\t</NcAppContent>\n\t</NcContent>\n</template>\n\n<script>\nimport { NcContent, NcAppContent, NcMultiselect } from \'@nextcloud/vue\'\nimport { actions } from \'../store/index.js\'\nimport FolderPickerDialog from \'./FolderPickerDialog.vue\'\n\nexport default {\n\tname: \'ViewBookmarklet\',\n\tcomponents: {\n\t\tFolderPickerDialog,\n\t\tNcContent,\n\t\tNcMultiselect,\n\t\tNcAppContent,\n\t},\n\tprops: {\n\t\ttitle: {\n\t\t\ttype: String,\n\t\t\tdefault: \'\',\n\t\t},\n\t\turl: {\n\t\t\ttype: String,\n\t\t\tdefault: \'\',\n\t\t},\n\t\tfolderId: {\n\t\t\ttype: String,\n\t\t\tdefault: \'\',\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tbookmark: {\n\t\t\t\ttitle: this.title,\n\t\t\t\turl: this.url,\n\t\t\t\ttags: [],\n\t\t\t\tdescription: \'\',\n\t\t\t},\n\t\t\tdescription: \'\',\n\t\t\texists: false,\n\t\t\tloading: true,\n\t\t\tshowPicker: false,\n\t\t\tfolder: parseInt(this.folderId || -1),\n\t\t}\n\t},\n\tcomputed: {\n\t\tallTags() {\n\t\t\treturn this.$store.state.tags.map(tag => tag.name)\n\t\t},\n\t\tfolders() {\n\t\t\treturn this.$store.state.folders\n\t\t},\n\t\tfolderTitle() {\n\t\t\treturn this.$store.getters.getFolder(this.folder)[0].title\n\t\t},\n\t},\n\twatch: {\n\t  bookmark() {\n\t\t  this.description = this.bookmark.description\n\t  },\n\t},\n\n\tasync created() {\n\t\tthis.loading = true\n\t\tawait Promise.all([\n\t\t\tthis.reloadTags(),\n\t\t\tthis.reloadFolders(),\n\t\t])\n\t\tawait this.findBookmark(this.bookmark.url)\n\t\tthis.loading = false\n\t},\n\n\tmethods: {\n\t\tasync reloadTags() {\n\t\t\treturn this.$store.dispatch(actions.LOAD_TAGS)\n\t\t},\n\t\tasync reloadFolders() {\n\t\t\treturn this.$store.dispatch(actions.LOAD_FOLDERS)\n\t\t},\n\t\treloadSettings() {\n\t\t\tthis.$store.dispatch(actions.LOAD_SETTINGS)\n\t\t},\n\t\tonNotesChange(e) {\n\t\t\tthis.bookmark.description = e.target.textContent\n\t\t},\n\t\tonTagsChange(tags) {\n\t\t\tthis.bookmark.tags = tags\n\t\t},\n\t\tonAddTag(tag) {\n\t\t\tthis.bookmark.tags.push(tag)\n\t\t},\n\t\tasync findBookmark(url) {\n\t\t\tconst bookmark = await this.$store.dispatch(actions.FIND_BOOKMARK, url)\n\t\t\tif (bookmark) {\n\t\t\t\tthis.exists = true\n\t\t\t\tthis.bookmark = bookmark\n\t\t\t\tif (this.bookmark.folders.length) {\n\t\t\t\t\tthis.folder = this.bookmark.folders[0]\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\tasync submit() {\n\t\t\tthis.loading = true\n\t\t\tif (this.folder !== -1) {\n\t\t\t\tthis.bookmark.folders = [this.folder]\n\t\t\t}\n\t\t\tif (this.exists) {\n\t\t\t\tawait this.$store.dispatch(actions.SAVE_BOOKMARK, this.bookmark.id)\n\t\t\t} else {\n\t\t\t\tawait this.$store.dispatch(actions.CREATE_BOOKMARK, this.bookmark)\n\t\t\t}\n\t\t\twindow.close()\n\t\t},\n\t},\n}\n<\/script>\n<style>\n.bookmarklet {\n\tmargin: 30px auto;\n\twidth: 70%;\n}\n\n.bookmarklet__exists {\n\tbackground: var(--color-background-dark);\n\tborder-radius: var(--border-radius-pill);\n\tfont-weight: bold;\n\tpadding: 10px 20px;\n}\n\nfigure[class^=icon-] {\n\tdisplay: inline-block;\n}\n\n.bookmarklet label {\n\tmargin-top: 10px;\n\tdisplay: flex;\n\talign-items: center;\n\talign-content: space-evenly;\n}\n\n.bookmarklet label :last-child {\n\tmargin-left: 10px;\n}\n\n.bookmarklet input {\n\twidth: 100%;\n\tdisplay: block;\n}\n\n.bookmarklet__notes {\n\tmin-height: 100px !important;\n\twidth: auto !important;\n}\n</style>\n'],sourceRoot:""}]);const s=a},74275:(t,e,n)=>{n.d(e,{Z:()=>r});const o={name:"FolderOpenIcon",emits:["click"],props:{title:{type:String},fillColor:{type:String,default:"currentColor"},size:{type:Number,default:24}}};const r=(0,n(51900).Z)(o,(function(){var t=this,e=t._self._c;return e("span",t._b({staticClass:"material-design-icon folder-open-icon",attrs:{"aria-hidden":!t.title,"aria-label":t.title,role:"img"},on:{click:function(e){return t.$emit("click",e)}}},"span",t.$attrs,!1),[e("svg",{staticClass:"material-design-icon__svg",attrs:{fill:t.fillColor,width:t.size,height:t.size,viewBox:"0 0 24 24"}},[e("path",{attrs:{d:"M19,20H4C2.89,20 2,19.1 2,18V6C2,4.89 2.89,4 4,4H10L12,6H19A2,2 0 0,1 21,8H21L4,8V18L6.14,10H23.21L20.93,18.5C20.7,19.37 19.92,20 19,20Z"}},[t.title?e("title",[t._v(t._s(t.title))]):t._e()])])])}),[],!1,null,null,null).exports},15764:(t,e,n)=>{n.d(e,{Z:()=>r});const o={name:"HomeIcon",emits:["click"],props:{title:{type:String},fillColor:{type:String,default:"currentColor"},size:{type:Number,default:24}}};const r=(0,n(51900).Z)(o,(function(){var t=this,e=t._self._c;return e("span",t._b({staticClass:"material-design-icon home-icon",attrs:{"aria-hidden":!t.title,"aria-label":t.title,role:"img"},on:{click:function(e){return t.$emit("click",e)}}},"span",t.$attrs,!1),[e("svg",{staticClass:"material-design-icon__svg",attrs:{fill:t.fillColor,width:t.size,height:t.size,viewBox:"0 0 24 24"}},[e("path",{attrs:{d:"M10,20V14H14V20H19V12H22L12,3L2,12H5V20H10Z"}},[t.title?e("title",[t._v(t._s(t.title))]):t._e()])])])}),[],!1,null,null,null).exports},13368:(t,e,n)=>{n.r(e),n.d(e,{default:()=>S});var o=n(15961),r=n(81283);const i={name:"FolderPickerDialog",components:{FolderPicker:n(75145).Z,NcModal:o.Jc},props:{value:{type:Number,default:-1},show:{type:Boolean,default:!0}},computed:{allFolders:function(){return this.$store.state.folders}},created:function(){},methods:{onSelect:function(t){this.$root.$emit("select",t),this.$emit("input",t),this.$emit("close")},onClose:function(){this.$root.$emit("close"),this.$emit("close")}}};var a=n(93379),s=n.n(a),l=n(7795),c=n.n(l),u=n(90569),d=n.n(u),p=n(3565),f=n.n(p),h=n(19216),m=n.n(h),k=n(44589),g=n.n(k),b=n(71938),v={};v.styleTagTransform=g(),v.setAttributes=f(),v.insert=d().bind(null,"head"),v.domAPI=c(),v.insertStyleElement=m();s()(b.Z,v);b.Z&&b.Z.locals&&b.Z.locals;var A=n(51900);function y(t){return y="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t},y(t)}function w(){w=function(){return t};var t={},e=Object.prototype,n=e.hasOwnProperty,o=Object.defineProperty||function(t,e,n){t[e]=n.value},r="function"==typeof Symbol?Symbol:{},i=r.iterator||"@@iterator",a=r.asyncIterator||"@@asyncIterator",s=r.toStringTag||"@@toStringTag";function l(t,e,n){return Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{l({},"")}catch(t){l=function(t,e,n){return t[e]=n}}function c(t,e,n,r){var i=e&&e.prototype instanceof p?e:p,a=Object.create(i.prototype),s=new L(r||[]);return o(a,"_invoke",{value:C(t,n,s)}),a}function u(t,e,n){try{return{type:"normal",arg:t.call(e,n)}}catch(t){return{type:"throw",arg:t}}}t.wrap=c;var d={};function p(){}function f(){}function h(){}var m={};l(m,i,(function(){return this}));var k=Object.getPrototypeOf,g=k&&k(k(S([])));g&&g!==e&&n.call(g,i)&&(m=g);var b=h.prototype=p.prototype=Object.create(m);function v(t){["next","throw","return"].forEach((function(e){l(t,e,(function(t){return this._invoke(e,t)}))}))}function A(t,e){function r(o,i,a,s){var l=u(t[o],t,i);if("throw"!==l.type){var c=l.arg,d=c.value;return d&&"object"==y(d)&&n.call(d,"__await")?e.resolve(d.__await).then((function(t){r("next",t,a,s)}),(function(t){r("throw",t,a,s)})):e.resolve(d).then((function(t){c.value=t,a(c)}),(function(t){return r("throw",t,a,s)}))}s(l.arg)}var i;o(this,"_invoke",{value:function(t,n){function o(){return new e((function(e,o){r(t,n,e,o)}))}return i=i?i.then(o,o):o()}})}function C(t,e,n){var o="suspendedStart";return function(r,i){if("executing"===o)throw new Error("Generator is already running");if("completed"===o){if("throw"===r)throw i;return T()}for(n.method=r,n.arg=i;;){var a=n.delegate;if(a){var s=_(a,n);if(s){if(s===d)continue;return s}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if("suspendedStart"===o)throw o="completed",n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);o="executing";var l=u(t,e,n);if("normal"===l.type){if(o=n.done?"completed":"suspendedYield",l.arg===d)continue;return{value:l.arg,done:n.done}}"throw"===l.type&&(o="completed",n.method="throw",n.arg=l.arg)}}}function _(t,e){var n=e.method,o=t.iterator[n];if(void 0===o)return e.delegate=null,"throw"===n&&t.iterator.return&&(e.method="return",e.arg=void 0,_(t,e),"throw"===e.method)||"return"!==n&&(e.method="throw",e.arg=new TypeError("The iterator does not provide a '"+n+"' method")),d;var r=u(o,t.iterator,e.arg);if("throw"===r.type)return e.method="throw",e.arg=r.arg,e.delegate=null,d;var i=r.arg;return i?i.done?(e[t.resultName]=i.value,e.next=t.nextLoc,"return"!==e.method&&(e.method="next",e.arg=void 0),e.delegate=null,d):i:(e.method="throw",e.arg=new TypeError("iterator result is not an object"),e.delegate=null,d)}function x(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function N(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function L(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(x,this),this.reset(!0)}function S(t){if(t){var e=t[i];if(e)return e.call(t);if("function"==typeof t.next)return t;if(!isNaN(t.length)){var o=-1,r=function e(){for(;++o<t.length;)if(n.call(t,o))return e.value=t[o],e.done=!1,e;return e.value=void 0,e.done=!0,e};return r.next=r}}return{next:T}}function T(){return{value:void 0,done:!0}}return f.prototype=h,o(b,"constructor",{value:h,configurable:!0}),o(h,"constructor",{value:f,configurable:!0}),f.displayName=l(h,s,"GeneratorFunction"),t.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===f||"GeneratorFunction"===(e.displayName||e.name))},t.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,h):(t.__proto__=h,l(t,s,"GeneratorFunction")),t.prototype=Object.create(b),t},t.awrap=function(t){return{__await:t}},v(A.prototype),l(A.prototype,a,(function(){return this})),t.AsyncIterator=A,t.async=function(e,n,o,r,i){void 0===i&&(i=Promise);var a=new A(c(e,n,o,r),i);return t.isGeneratorFunction(n)?a:a.next().then((function(t){return t.done?t.value:a.next()}))},v(b),l(b,s,"Generator"),l(b,i,(function(){return this})),l(b,"toString",(function(){return"[object Generator]"})),t.keys=function(t){var e=Object(t),n=[];for(var o in e)n.push(o);return n.reverse(),function t(){for(;n.length;){var o=n.pop();if(o in e)return t.value=o,t.done=!1,t}return t.done=!0,t}},t.values=S,L.prototype={constructor:L,reset:function(t){if(this.prev=0,this.next=0,this.sent=this._sent=void 0,this.done=!1,this.delegate=null,this.method="next",this.arg=void 0,this.tryEntries.forEach(N),!t)for(var e in this)"t"===e.charAt(0)&&n.call(this,e)&&!isNaN(+e.slice(1))&&(this[e]=void 0)},stop:function(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function(t){if(this.done)throw t;var e=this;function o(n,o){return a.type="throw",a.arg=t,e.next=n,o&&(e.method="next",e.arg=void 0),!!o}for(var r=this.tryEntries.length-1;r>=0;--r){var i=this.tryEntries[r],a=i.completion;if("root"===i.tryLoc)return o("end");if(i.tryLoc<=this.prev){var s=n.call(i,"catchLoc"),l=n.call(i,"finallyLoc");if(s&&l){if(this.prev<i.catchLoc)return o(i.catchLoc,!0);if(this.prev<i.finallyLoc)return o(i.finallyLoc)}else if(s){if(this.prev<i.catchLoc)return o(i.catchLoc,!0)}else{if(!l)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return o(i.finallyLoc)}}}},abrupt:function(t,e){for(var o=this.tryEntries.length-1;o>=0;--o){var r=this.tryEntries[o];if(r.tryLoc<=this.prev&&n.call(r,"finallyLoc")&&this.prev<r.finallyLoc){var i=r;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,d):this.complete(a)},complete:function(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),d},finish:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.finallyLoc===t)return this.complete(n.completion,n.afterLoc),N(n),d}},catch:function(t){for(var e=this.tryEntries.length-1;e>=0;--e){var n=this.tryEntries[e];if(n.tryLoc===t){var o=n.completion;if("throw"===o.type){var r=o.arg;N(n)}return r}}throw new Error("illegal catch attempt")},delegateYield:function(t,e,n){return this.delegate={iterator:S(t),resultName:e,nextLoc:n},"next"===this.method&&(this.arg=void 0),d}},t}function C(t,e,n,o,r,i,a){try{var s=t[i](a),l=s.value}catch(t){return void n(t)}s.done?e(l):Promise.resolve(l).then(o,r)}function _(t){return function(){var e=this,n=arguments;return new Promise((function(o,r){var i=t.apply(e,n);function a(t){C(i,o,r,a,s,"next",t)}function s(t){C(i,o,r,a,s,"throw",t)}a(void 0)}))}}const x={name:"ViewBookmarklet",components:{FolderPickerDialog:(0,A.Z)(i,(function(){var t=this,e=t._self._c;return t.show?e("NcModal",{attrs:{title:t.t("bookmarks","Select folder")},on:{close:t.onClose}},[e("div",{staticClass:"folderpicker-dialog"},[e("FolderPicker",{attrs:{title:t.t("bookmarks","Select folder")},on:{submit:t.onSelect}})],1)]):t._e()}),[],!1,null,null,null).exports,NcContent:o.qF,NcMultiselect:o.Z2,NcAppContent:o.Mb},props:{title:{type:String,default:""},url:{type:String,default:""},folderId:{type:String,default:""}},data:function(){return{bookmark:{title:this.title,url:this.url,tags:[],description:""},description:"",exists:!1,loading:!0,showPicker:!1,folder:parseInt(this.folderId||-1)}},computed:{allTags:function(){return this.$store.state.tags.map((function(t){return t.name}))},folders:function(){return this.$store.state.folders},folderTitle:function(){return this.$store.getters.getFolder(this.folder)[0].title}},watch:{bookmark:function(){this.description=this.bookmark.description}},created:function(){var t=this;return _(w().mark((function e(){return w().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return t.loading=!0,e.next=3,Promise.all([t.reloadTags(),t.reloadFolders()]);case 3:return e.next=5,t.findBookmark(t.bookmark.url);case 5:t.loading=!1;case 6:case"end":return e.stop()}}),e)})))()},methods:{reloadTags:function(){var t=this;return _(w().mark((function e(){return w().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.abrupt("return",t.$store.dispatch(r.Nw.LOAD_TAGS));case 1:case"end":return e.stop()}}),e)})))()},reloadFolders:function(){var t=this;return _(w().mark((function e(){return w().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:return e.abrupt("return",t.$store.dispatch(r.Nw.LOAD_FOLDERS));case 1:case"end":return e.stop()}}),e)})))()},reloadSettings:function(){this.$store.dispatch(r.Nw.LOAD_SETTINGS)},onNotesChange:function(t){this.bookmark.description=t.target.textContent},onTagsChange:function(t){this.bookmark.tags=t},onAddTag:function(t){this.bookmark.tags.push(t)},findBookmark:function(t){var e=this;return _(w().mark((function n(){var o;return w().wrap((function(n){for(;;)switch(n.prev=n.next){case 0:return n.next=2,e.$store.dispatch(r.Nw.FIND_BOOKMARK,t);case 2:(o=n.sent)&&(e.exists=!0,e.bookmark=o,e.bookmark.folders.length&&(e.folder=e.bookmark.folders[0]));case 4:case"end":return n.stop()}}),n)})))()},submit:function(){var t=this;return _(w().mark((function e(){return w().wrap((function(e){for(;;)switch(e.prev=e.next){case 0:if(t.loading=!0,-1!==t.folder&&(t.bookmark.folders=[t.folder]),!t.exists){e.next=7;break}return e.next=5,t.$store.dispatch(r.Nw.SAVE_BOOKMARK,t.bookmark.id);case 5:e.next=9;break;case 7:return e.next=9,t.$store.dispatch(r.Nw.CREATE_BOOKMARK,t.bookmark);case 9:window.close();case 10:case"end":return e.stop()}}),e)})))()}}};var N=n(78931),L={};L.styleTagTransform=g(),L.setAttributes=f(),L.insert=d().bind(null,"head"),L.domAPI=c(),L.insertStyleElement=m();s()(N.Z,L);N.Z&&N.Z.locals&&N.Z.locals;const S=(0,A.Z)(x,(function(){var t=this,e=t._self._c;return e("NcContent",{attrs:{"app-name":"bookmarks"}},[e("NcAppContent",[e("div",{staticClass:"bookmarklet"},[e("h2",[e("figure",{class:t.loading?"icon-loading-small":"icon-link"}),t._v(" "+t._s(t.t("bookmarks","Add a bookmark")))]),t._v(" "),t.exists?e("div",{staticClass:"bookmarklet__exists"},[t._v("\n\t\t\t\t"+t._s(t.t("bookmarks","This URL is already bookmarked! Overwrite?"))+"\n\t\t\t")]):t._e(),t._v(" "),e("label",[t._v(t._s(t.t("bookmarks","Title"))+"\n\t\t\t\t"),e("input",{directives:[{name:"model",rawName:"v-model",value:t.bookmark.title,expression:"bookmark.title"}],attrs:{type:"text",placeholder:t.t("bookmarks","Enter bookmark title")},domProps:{value:t.bookmark.title},on:{input:function(e){e.target.composing||t.$set(t.bookmark,"title",e.target.value)}}})]),t._v(" "),e("label",[t._v(t._s(t.t("bookmarks","Link"))+"\n\t\t\t\t"),e("input",{directives:[{name:"model",rawName:"v-model",value:t.bookmark.url,expression:"bookmark.url"}],attrs:{type:"text",placeholder:t.t("bookmarks","Enter bookmark URL")},domProps:{value:t.bookmark.url},on:{input:function(e){e.target.composing||t.$set(t.bookmark,"url",e.target.value)}}})]),t._v(" "),e("label",[e("figure",{staticClass:"icon-tag"}),t._v(" "+t._s(t.t("bookmarks","Tags"))+"\n\t\t\t\t"),e("NcMultiselect",{staticClass:"sidebar__tags",attrs:{value:t.bookmark.tags,"auto-limit":!1,limit:7,options:t.allTags,multiple:!0,taggable:!0},on:{input:t.onTagsChange,tag:t.onAddTag}})],1),t._v(" "),e("label",[e("figure",{staticClass:"icon-folder"}),t._v(" "+t._s(t.t("bookmarks","Folder"))+"\n\t\t\t\t"),e("input",{attrs:{type:"text",readonly:"",placeholder:t.t("bookmarks","Root Folder")},domProps:{value:t.folderTitle},on:{click:function(e){t.showPicker=!0}}}),t._v(" "),e("FolderPickerDialog",{attrs:{show:t.showPicker},on:{close:function(e){t.showPicker=!1}},model:{value:t.folder,callback:function(e){t.folder=e},expression:"folder"}})],1),t._v(" "),e("label",[t._v(t._s(t.t("bookmarks","Notes")))]),t._v(" "),e("div",{staticClass:"bookmarklet__notes",attrs:{contenteditable:""},on:{input:t.onNotesChange}},[t._v("\n\t\t\t\t"+t._s(t.description)+"\n\t\t\t")]),t._v(" "),e("button",{staticClass:"primary",on:{click:t.submit}},[e("span",{staticClass:"icon-confirm-white"}),t._v(t._s(t.t("bookmarks","Save"))+"\n\t\t\t")])])])],1)}),[],!1,null,null,null).exports}}]);
//# sourceMappingURL=bookmarks-node_modules_vue-material-design-icons_FolderOpen_vue-node_modules_vue-material-design-icons_-066f70.js.map?v=27000404a305c63d0cc0