# `MD038` - Spaces inside code span elements

Tags: `code`, `whitespace`

Aliases: `no-space-in-code`

Fixable: Some violations can be fixed by tooling

This rule is triggered for code span elements that have spaces adjacent to the
backticks:

```markdown
`some text `

` some text`
```

To fix this, remove any spaces adjacent to the backticks:

```markdown
`some text`
```

Note: A single leading and trailing space is allowed by the specification and
automatically trimmed (in order to allow for code spans that embed backticks):

```markdown
`` `backticks` ``
```

Note: A single leading or trailing space is allowed if used to separate code
span markers from an embedded backtick (though the space is not trimmed):

```markdown
`` ` embedded backtick``
```

Rationale: Violations of this rule are usually unintentional and may lead to
improperly-rendered content. If spaces beside backticks are intentional, this
rule can be disabled for that line or file.
