/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ClientModule;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.AbstractExternalModuleDependency;

public class DefaultClientModule
extends AbstractExternalModuleDependency
implements ClientModule {
    private final Set<ModuleDependency> dependencies = new LinkedHashSet<ModuleDependency>();

    public DefaultClientModule(String group, String name, String version) {
        this(group, name, version, null);
    }

    public DefaultClientModule(String group, String name, String version, @Nullable String configuration) {
        super(DefaultClientModule.assertModuleId(group, name), version, configuration);
    }

    public String getId() {
        return this.emptyStringIfNull(this.getGroup()) + ":" + this.getName() + ":" + this.emptyStringIfNull(this.getVersion());
    }

    private String emptyStringIfNull(@Nullable String value) {
        return value == null ? "" : value;
    }

    public Set<ModuleDependency> getDependencies() {
        return this.dependencies;
    }

    public void addDependency(ModuleDependency dependency) {
        this.dependencies.add(dependency);
    }

    public ClientModule copy() {
        DefaultClientModule copiedClientModule = new DefaultClientModule(this.getGroup(), this.getName(), this.getVersion(), this.getTargetConfiguration());
        this.copyTo(copiedClientModule);
        for (ModuleDependency dependency : this.dependencies) {
            copiedClientModule.addDependency(dependency.copy());
        }
        return copiedClientModule;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Dependency)) {
            return false;
        }
        return this.contentEquals((Dependency)o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean contentEquals(Dependency dependency) {
        if (this == dependency) {
            return true;
        }
        if (dependency == null || ((Object)((Object)this)).getClass() != dependency.getClass()) {
            return false;
        }
        ClientModule that = (ClientModule)dependency;
        return this.isContentEqualsFor((ExternalModuleDependency)that) && this.dependencies.equals(that.getDependencies());
    }
}

