/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideBuilder;
import org.jetbrains.kotlin.backend.common.overrides.FileLocalAwareLinker;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.CurrentModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.DeserializationStrategy;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerKind;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDeserializerWithBuiltIns;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.KotlinIrLinker;
import org.jetbrains.kotlin.backend.common.serialization.LegacyDescriptorUtilsKt;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.IrSymbolTypeMismatchException;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.NoDeserializerForModule;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.SignatureIdNotFoundInModuleWithDependencies;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.SymbolTypeMismatch;
import org.jetbrains.kotlin.backend.common.serialization.linkerissues.UserVisibleIrModulesSupport;
import org.jetbrains.kotlin.backend.common.serialization.unlinked.UnlinkedDeclarationsProcessor;
import org.jetbrains.kotlin.backend.common.serialization.unlinked.UnlinkedDeclarationsSupport;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.TranslationPluginContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.linkage.IrDeserializer;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingClassSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingEnumEntrySymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingPropertySymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingSymbol;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingSymbolKt;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbolKt;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinAbiVersion;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009c\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\\\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u0012%\b\u0002\u0010\r\u001a\u001f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020EH\u0002J\u0010\u0010G\u001a\u00020C2\u0006\u0010H\u001a\u00020IH\u0002J\u001e\u0010J\u001a\u00020\u001c2\u0006\u0010K\u001a\u00020L2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020\u001c0'H\u0014J.\u0010N\u001a\u00020\u001c2\u0006\u0010O\u001a\u00020\u00042\b\u0010P\u001a\u0004\u0018\u00010Q2\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020T0SH$J\b\u0010U\u001a\u00020CH\u0002J$\u0010V\u001a\u00020L2\u0006\u0010O\u001a\u00020\u00042\u0006\u0010W\u001a\u00020Q2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020\u001b0'J\u0016\u0010Y\u001a\u00020L2\u0006\u0010O\u001a\u00020\u00042\u0006\u0010W\u001a\u00020QJ\u0016\u0010Z\u001a\u00020L2\u0006\u0010O\u001a\u00020\u00042\u0006\u0010W\u001a\u00020QJ:\u0010[\u001a\u00020L2\u0006\u0010O\u001a\u00020\u00042\b\u0010W\u001a\u0004\u0018\u00010Q2\u0014\b\u0002\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020T0S2\n\b\u0002\u0010]\u001a\u0004\u0018\u00010\u001bJ \u0010[\u001a\u00020L2\u0006\u0010O\u001a\u00020\u00042\b\u0010W\u001a\u0004\u0018\u00010Q2\u0006\u0010^\u001a\u00020\u001bJ\u0018\u0010_\u001a\u00020L2\u0006\u0010O\u001a\u00020\u00042\b\u0010W\u001a\u0004\u0018\u00010QJ\u001a\u0010`\u001a\u0004\u0018\u00010a2\u0006\u0010b\u001a\u00020\u00102\u0006\u0010c\u001a\u00020dH\u0004J\u0096\u0001\u0010e\u001a\u00020C\"\n\b\u0000\u0010f\u0018\u0001*\u00020a\"\u001a\b\u0001\u0010g\u0018\u0001*\u0012\u0012\u0004\u0012\u0002Hi\u0012\u0004\u0012\u0002Hf\u0012\u0002\b\u00030h\"\u0014\b\u0002\u0010i\u0018\u0001*\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002Hf0j2\u0006\u0010k\u001a\u0002Hg2\u0006\u0010l\u001a\u00020\u001028\b\b\u0010m\u001a2\u0012\u0013\u0012\u0011Hf\u00a2\u0006\f\bo\u0012\b\bp\u0012\u0004\b\b(D\u0012\u0013\u0012\u0011Hf\u00a2\u0006\f\bo\u0012\b\bp\u0012\u0004\b\b(F\u0012\u0004\u0012\u00020C0nH\u0082\b\u00a2\u0006\u0002\u0010qJ\b\u0010r\u001a\u00020CH\u0002J\u0012\u0010s\u001a\u0004\u0018\u00010t2\u0006\u0010b\u001a\u00020\u0010H\u0002J\u0012\u0010u\u001a\u0004\u0018\u00010a2\u0006\u0010b\u001a\u00020\u0010H\u0016J\u0016\u0010v\u001a\u00020\u00102\u0006\u0010w\u001a\u00020\u00112\u0006\u0010x\u001a\u00020\u0010J\u0016\u0010y\u001a\u00020\u001c2\u0006\u0010z\u001a\u00020\u00112\u0006\u0010{\u001a\u00020\u001cJ \u0010|\u001a\u00020C2\b\u0010K\u001a\u0004\u0018\u00010L2\f\u0010}\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\u0010\u0010~\u001a\u00020d2\u0006\u0010O\u001a\u00020\u0004H$J\u0010\u0010\u007f\u001a\n\u0012\u0005\u0012\u00030\u0081\u00010\u0080\u0001H\u0002J\u0019\u0010\u0082\u0001\u001a\u00020\u001c2\u0006\u0010O\u001a\u00020\u00042\u0006\u0010{\u001a\u00020\u001cH\u0014J\u0011\u0010\u0083\u0001\u001a\u00020d2\u0006\u0010b\u001a\u00020\u0010H\u0014J\t\u0010\u0084\u0001\u001a\u00020CH\u0016J%\u0010\u0085\u0001\u001a\u00020\u00102\u0007\u0010\u0086\u0001\u001a\u00020\u00112\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u0007\u0010^\u001a\u00030\u0089\u0001H\u0016J\u001a\u0010\u008a\u0001\u001a\u00020\u001c2\u0007\u0010\u008b\u0001\u001a\u00020\u00042\b\u0010z\u001a\u0004\u0018\u00010\u0011J\u0014\u0010\u008c\u0001\u001a\u00030\u008d\u00012\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0002J\u001d\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008f\u00012\u0007\u0010\u0090\u0001\u001a\u00020a2\u0006\u0010z\u001a\u00020\u0011H\u0016J\u001d\u0010\u0091\u0001\u001a\u0005\u0018\u00010\u0092\u00012\u0007\u0010\u0090\u0001\u001a\u00020a2\u0006\u0010z\u001a\u00020\u0011H\u0016J\u0013\u0010\u0093\u0001\u001a\u0004\u0018\u00010a2\u0006\u0010b\u001a\u00020\u0010H\u0002R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00100\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00100\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u001d\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\"\u001a\u00020#X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001c0,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R.\u0010\r\u001a\u001f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u001d\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001c0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0017R\u0014\u00105\u001a\u0004\u0018\u000106X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020\u00100,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\u00020;X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0014\u0010>\u001a\u00020?X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010A\u00a8\u0006\u0094\u0001"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/KotlinIrLinker;", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer;", "Lorg/jetbrains/kotlin/backend/common/overrides/FileLocalAwareLinker;", "currentModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "messageLogger", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "exportedDependencies", "", "symbolProcessor", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Ljava/util/List;Lkotlin/jvm/functions/Function3;)V", "actualSymbols", "", "getActualSymbols$ir_serialization_common", "()Ljava/util/Map;", "getBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "deserializersForModules", "", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDeserializer;", "getDeserializersForModules", "expectSymbols", "getExpectSymbols$ir_serialization_common", "expectUniqIdToActualUniqId", "getExpectUniqIdToActualUniqId", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "getFakeOverrideBuilder", "()Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "linkerExtensions", "", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer$IrLinkerExtension;", "getMessageLogger", "()Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "modulesWithReachableTopLevels", "", "getModulesWithReachableTopLevels", "()Ljava/util/Set;", "getSymbolProcessor", "()Lkotlin/jvm/functions/Function3;", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "topLevelActualUniqItToDeserializer", "getTopLevelActualUniqItToDeserializer", "translationPluginContext", "Lorg/jetbrains/kotlin/ir/builders/TranslationPluginContext;", "getTranslationPluginContext", "()Lorg/jetbrains/kotlin/ir/builders/TranslationPluginContext;", "triedToDeserializeDeclarationForSymbol", "unlinkedDeclarationsSupport", "Lorg/jetbrains/kotlin/backend/common/serialization/unlinked/UnlinkedDeclarationsSupport;", "getUnlinkedDeclarationsSupport", "()Lorg/jetbrains/kotlin/backend/common/serialization/unlinked/UnlinkedDeclarationsSupport;", "userVisibleIrModulesSupport", "Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport;", "getUserVisibleIrModulesSupport", "()Lorg/jetbrains/kotlin/backend/common/serialization/linkerissues/UserVisibleIrModulesSupport;", "actualizeIrFunction", "", "e", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "a", "applyToModules", "transformer", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "createCurrentModuleDeserializer", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "dependencies", "createModuleDeserializer", "moduleDescriptor", "klib", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "strategyResolver", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/backend/common/serialization/DeserializationStrategy;", "deserializeAllReachableTopLevels", "deserializeDirtyFiles", "kotlinLibrary", "dirtyFiles", "deserializeFullModule", "deserializeHeadersWithInlineBodies", "deserializeIrModuleHeader", "deserializationStrategy", "_moduleName", "moduleName", "deserializeOnlyHeaderModule", "deserializeOrResolveDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "symbol", "allowSymbolsWithoutSignaturesFromOtherModule", "", "finalizeExpectActual", "D", "ES", "Lorg/jetbrains/kotlin/ir/symbols/IrDelegatingSymbol;", "AS", "Lorg/jetbrains/kotlin/ir/symbols/IrBindableSymbol;", "expectSymbol", "actualSymbol", "actualizer", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "(Lorg/jetbrains/kotlin/ir/symbols/IrDelegatingSymbol;Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;Lkotlin/jvm/functions/Function2;)V", "finalizeExpectActualLinker", "findDeserializedDeclarationForSymbol", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getDeclaration", "handleExpectActualMapping", "idSig", "rawSymbol", "handleSignatureIdNotFoundInModuleWithDependencies", "idSignature", "moduleDeserializer", "init", "extensions", "isBuiltInModule", "markUnlinkedClassifiers", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "maybeWrapWithBuiltInAndInit", "platformSpecificSymbol", "postProcess", "resolveBySignatureInModule", "signature", "kind", "Lorg/jetbrains/kotlin/ir/linkage/IrDeserializer$TopLevelSymbolKind;", "Lorg/jetbrains/kotlin/name/Name;", "resolveModuleDeserializer", "module", "topLevelKindToSymbolKind", "Lorg/jetbrains/kotlin/backend/common/serialization/encodings/BinarySymbolData$SymbolKind;", "tryReferencingPropertyByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "parent", "tryReferencingSimpleFunctionByLocalSignature", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "tryResolveCustomDeclaration", "ir.serialization.common"})
public abstract class KotlinIrLinker
implements FileLocalAwareLinker,
IrDeserializer {
    @Nullable
    private final ModuleDescriptor currentModule;
    @NotNull
    private final IrMessageLogger messageLogger;
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final List<ModuleDescriptor> exportedDependencies;
    @NotNull
    private final Function3<IrSymbolDeserializer, IrSymbol, IdSignature, IrSymbol> symbolProcessor;
    @NotNull
    private final Map<IdSignature, IdSignature> expectUniqIdToActualUniqId;
    @NotNull
    private final Map<IdSignature, IrModuleDeserializer> topLevelActualUniqItToDeserializer;
    @NotNull
    private final Map<IdSignature, IrSymbol> expectSymbols;
    @NotNull
    private final Map<IdSignature, IrSymbol> actualSymbols;
    @NotNull
    private final Set<IrModuleDeserializer> modulesWithReachableTopLevels;
    @NotNull
    private final Map<String, IrModuleDeserializer> deserializersForModules;
    @NotNull
    private final Set<IrSymbol> triedToDeserializeDeclarationForSymbol;
    private Collection<? extends IrDeserializer.IrLinkerExtension> linkerExtensions;
    @NotNull
    private final UnlinkedDeclarationsSupport unlinkedDeclarationsSupport;
    @NotNull
    private final UserVisibleIrModulesSupport userVisibleIrModulesSupport;

    public KotlinIrLinker(@Nullable ModuleDescriptor currentModule, @NotNull IrMessageLogger messageLogger, @NotNull IrBuiltIns builtIns, @NotNull SymbolTable symbolTable, @NotNull List<? extends ModuleDescriptor> exportedDependencies, @NotNull Function3<? super IrSymbolDeserializer, ? super IrSymbol, ? super IdSignature, ? extends IrSymbol> symbolProcessor) {
        Intrinsics.checkNotNullParameter((Object)messageLogger, (String)"messageLogger");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter(exportedDependencies, (String)"exportedDependencies");
        Intrinsics.checkNotNullParameter(symbolProcessor, (String)"symbolProcessor");
        this.currentModule = currentModule;
        this.messageLogger = messageLogger;
        this.builtIns = builtIns;
        this.symbolTable = symbolTable;
        this.exportedDependencies = exportedDependencies;
        this.symbolProcessor = symbolProcessor;
        this.expectUniqIdToActualUniqId = new LinkedHashMap();
        this.topLevelActualUniqItToDeserializer = new LinkedHashMap();
        this.expectSymbols = new LinkedHashMap();
        this.actualSymbols = new LinkedHashMap();
        this.modulesWithReachableTopLevels = new LinkedHashSet();
        this.deserializersForModules = new LinkedHashMap();
        this.triedToDeserializeDeclarationForSymbol = new LinkedHashSet();
        this.unlinkedDeclarationsSupport = UnlinkedDeclarationsSupport.Companion.getDISABLED();
        this.userVisibleIrModulesSupport = UserVisibleIrModulesSupport.Companion.getDEFAULT();
    }

    public /* synthetic */ KotlinIrLinker(ModuleDescriptor moduleDescriptor, IrMessageLogger irMessageLogger, IrBuiltIns irBuiltIns, SymbolTable symbolTable, List list2, Function3 function3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function3 = 1.INSTANCE;
        }
        this(moduleDescriptor, irMessageLogger, irBuiltIns, symbolTable, list2, (Function3<? super IrSymbolDeserializer, ? super IrSymbol, ? super IdSignature, ? extends IrSymbol>)function3);
    }

    @NotNull
    public final IrMessageLogger getMessageLogger() {
        return this.messageLogger;
    }

    @NotNull
    public final IrBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    @NotNull
    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    @NotNull
    public final Function3<IrSymbolDeserializer, IrSymbol, IdSignature, IrSymbol> getSymbolProcessor() {
        return this.symbolProcessor;
    }

    @NotNull
    public final Map<IdSignature, IdSignature> getExpectUniqIdToActualUniqId() {
        return this.expectUniqIdToActualUniqId;
    }

    @NotNull
    public final Map<IdSignature, IrModuleDeserializer> getTopLevelActualUniqItToDeserializer() {
        return this.topLevelActualUniqItToDeserializer;
    }

    @NotNull
    public final Map<IdSignature, IrSymbol> getExpectSymbols$ir_serialization_common() {
        return this.expectSymbols;
    }

    @NotNull
    public final Map<IdSignature, IrSymbol> getActualSymbols$ir_serialization_common() {
        return this.actualSymbols;
    }

    @NotNull
    public final Set<IrModuleDeserializer> getModulesWithReachableTopLevels() {
        return this.modulesWithReachableTopLevels;
    }

    @NotNull
    protected final Map<String, IrModuleDeserializer> getDeserializersForModules() {
        return this.deserializersForModules;
    }

    @NotNull
    public abstract FakeOverrideBuilder getFakeOverrideBuilder();

    @Nullable
    public abstract TranslationPluginContext getTranslationPluginContext();

    @NotNull
    protected UnlinkedDeclarationsSupport getUnlinkedDeclarationsSupport() {
        return this.unlinkedDeclarationsSupport;
    }

    @NotNull
    protected UserVisibleIrModulesSupport getUserVisibleIrModulesSupport() {
        return this.userVisibleIrModulesSupport;
    }

    @NotNull
    public final IrModuleDeserializer handleSignatureIdNotFoundInModuleWithDependencies(@NotNull IdSignature idSignature, @NotNull IrModuleDeserializer moduleDeserializer) {
        Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
        Intrinsics.checkNotNullParameter((Object)moduleDeserializer, (String)"moduleDeserializer");
        if (this.getUnlinkedDeclarationsSupport().getAllowUnboundSymbols()) {
            KotlinAbiVersion kotlinAbiVersion = KotlinAbiVersion.Companion.getCURRENT();
            return new IrModuleDeserializer(this, kotlinAbiVersion){
                final /* synthetic */ KotlinIrLinker this$0;
                {
                    this.this$0 = $receiver;
                    super(null, $super_call_param$1);
                }

                public boolean contains(@NotNull IdSignature idSig) {
                    Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
                    return false;
                }

                @NotNull
                public IrSymbol deserializeIrSymbol(@NotNull IdSignature idSig, @NotNull BinarySymbolData.SymbolKind symbolKind) {
                    Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
                    Intrinsics.checkNotNullParameter((Object)((Object)symbolKind), (String)"symbolKind");
                    return IrSymbolDeserializerKt.referenceDeserializedSymbol(this.this$0.getSymbolTable(), null, symbolKind, idSig);
                }

                @NotNull
                public IrModuleFragment getModuleFragment() {
                    String string2 = "Not yet implemented";
                    throw new NotImplementedError("An operation is not implemented: " + string2);
                }

                @NotNull
                public Collection<IrModuleDeserializer> getModuleDependencies() {
                    return CollectionsKt.emptyList();
                }

                @NotNull
                public IrModuleDeserializerKind getKind() {
                    String string2 = "Not yet implemented";
                    throw new NotImplementedError("An operation is not implemented: " + string2);
                }
            };
        }
        throw new SignatureIdNotFoundInModuleWithDependencies(idSignature, moduleDeserializer, this.deserializersForModules.values(), this.getUserVisibleIrModulesSupport()).raiseIssue(this.messageLogger);
    }

    @NotNull
    public final IrModuleDeserializer resolveModuleDeserializer(@NotNull ModuleDescriptor module2, @Nullable IdSignature idSignature) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        IrModuleDeserializer irModuleDeserializer = this.deserializersForModules.get(module2.getName().asString());
        if (irModuleDeserializer == null) {
            Name name = module2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"module.name");
            throw new NoDeserializerForModule(name, idSignature).raiseIssue(this.messageLogger);
        }
        return irModuleDeserializer;
    }

    @NotNull
    protected abstract IrModuleDeserializer createModuleDeserializer(@NotNull ModuleDescriptor var1, @Nullable KotlinLibrary var2, @NotNull Function1<? super String, ? extends DeserializationStrategy> var3);

    protected abstract boolean isBuiltInModule(@NotNull ModuleDescriptor var1);

    private final void deserializeAllReachableTopLevels() {
        while (!((Collection)this.modulesWithReachableTopLevels).isEmpty()) {
            IrModuleDeserializer moduleDeserializer = (IrModuleDeserializer)CollectionsKt.first((Iterable)this.modulesWithReachableTopLevels);
            this.modulesWithReachableTopLevels.remove(moduleDeserializer);
            moduleDeserializer.deserializeReachableDeclarations();
        }
    }

    private final DeclarationDescriptor findDeserializedDeclarationForSymbol(IrSymbol symbol2) {
        if (this.triedToDeserializeDeclarationForSymbol.contains(symbol2)) {
            return null;
        }
        this.triedToDeserializeDeclarationForSymbol.add(symbol2);
        if (!symbol2.getHasDescriptor()) {
            return null;
        }
        DeclarationDescriptor descriptor2 = symbol2.getDescriptor();
        IrModuleDeserializer moduleDeserializer = this.resolveModuleDeserializer(DescriptorUtilsKt.getModule(descriptor2), symbol2.getSignature());
        moduleDeserializer.declareIrSymbol(symbol2);
        this.deserializeAllReachableTopLevels();
        if (!symbol2.isBound()) {
            return null;
        }
        return descriptor2;
    }

    protected boolean platformSpecificSymbol(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return false;
    }

    private final IrDeclaration tryResolveCustomDeclaration(IrSymbol symbol2) {
        Object object;
        if (!symbol2.getHasDescriptor()) {
            return null;
        }
        DeclarationDescriptor descriptor2 = symbol2.getDescriptor();
        if (descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            return null;
        }
        TranslationPluginContext translationPluginContext = this.getTranslationPluginContext();
        if (translationPluginContext != null) {
            Object object2;
            block9: {
                Object object3;
                TranslationPluginContext ctx = translationPluginContext;
                boolean bl = false;
                Collection<? extends IrDeserializer.IrLinkerExtension> collection = this.linkerExtensions;
                if (collection == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"linkerExtensions");
                    collection = null;
                }
                for (Object it : (Iterable)collection) {
                    boolean bl2 = false;
                    if ((it = it.resolveSymbol(symbol2, ctx)) == null) continue;
                    object3 = it;
                    break block9;
                }
                object3 = object2 = null;
            }
            if (object2 != null) {
                Object object4;
                Object it = object4 = object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)symbol2.getOwner(), (Object)it)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                object = object4;
            } else {
                object = null;
            }
        } else {
            object = null;
        }
        return object;
    }

    @Override
    @Nullable
    public IrDeclaration getDeclaration(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return this.deserializeOrResolveDeclaration(symbol2, false);
    }

    @Nullable
    protected final IrDeclaration deserializeOrResolveDeclaration(@NotNull IrSymbol symbol2, boolean allowSymbolsWithoutSignaturesFromOtherModule) {
        block12: {
            block13: {
                block11: {
                    Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                    if (!allowSymbolsWithoutSignaturesFromOtherModule && !IrSymbolKt.isPublicApi(symbol2) && symbol2.getHasDescriptor() && !this.platformSpecificSymbol(symbol2) && DescriptorUtilsKt.getModule(symbol2.getDescriptor()) != this.currentModule) {
                        return null;
                    }
                    if (!symbol2.isBound()) {
                        try {
                            Object object = this.findDeserializedDeclarationForSymbol(symbol2);
                            if (object == null && (object = this.tryResolveCustomDeclaration(symbol2)) == null) {
                                return null;
                            }
                        }
                        catch (IrSymbolTypeMismatchException e) {
                            if (this.getUnlinkedDeclarationsSupport().getAllowUnboundSymbols()) break block11;
                            throw new SymbolTypeMismatch(e, this.deserializersForModules.values(), this.getUserVisibleIrModulesSupport()).raiseIssue(this.messageLogger);
                        }
                    }
                }
                if (symbol2.isBound()) break block12;
                if (LegacyDescriptorUtilsKt.isExpectMember(symbol2.getDescriptor())) break block13;
                DeclarationDescriptor declarationDescriptor = symbol2.getDescriptor().getContainingDeclaration();
                boolean bl = declarationDescriptor != null ? LegacyDescriptorUtilsKt.isExpectMember(declarationDescriptor) : false;
                if (!bl) break block12;
            }
            return null;
        }
        if (!symbol2.isBound()) {
            return null;
        }
        IrSymbolOwner irSymbolOwner = symbol2.getOwner();
        Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        return (IrDeclaration)irSymbolOwner;
    }

    @Override
    @Nullable
    public IrSimpleFunctionSymbol tryReferencingSimpleFunctionByLocalSignature(@NotNull IrDeclaration parent2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
        if (idSignature.isPubliclyVisible()) {
            return null;
        }
        IrFile file2 = IrUtilsKt.getFile(parent2);
        ModuleDescriptor moduleDescriptor = file2.getPackageFragmentDescriptor().getContainingDeclaration();
        return this.resolveModuleDeserializer(moduleDescriptor, null).referenceSimpleFunctionByLocalSignature(file2, idSignature);
    }

    @Override
    @Nullable
    public IrPropertySymbol tryReferencingPropertyByLocalSignature(@NotNull IrDeclaration parent2, @NotNull IdSignature idSignature) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)idSignature, (String)"idSignature");
        if (idSignature.isPubliclyVisible()) {
            return null;
        }
        IrFile file2 = IrUtilsKt.getFile(parent2);
        ModuleDescriptor moduleDescriptor = file2.getPackageFragmentDescriptor().getContainingDeclaration();
        return this.resolveModuleDeserializer(moduleDescriptor, null).referencePropertyByLocalSignature(file2, idSignature);
    }

    @NotNull
    protected IrModuleDeserializer createCurrentModuleDeserializer(@NotNull IrModuleFragment moduleFragment2, @NotNull Collection<? extends IrModuleDeserializer> dependencies2) {
        Intrinsics.checkNotNullParameter((Object)moduleFragment2, (String)"moduleFragment");
        Intrinsics.checkNotNullParameter(dependencies2, (String)"dependencies");
        return new CurrentModuleDeserializer(moduleFragment2, dependencies2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void init(@Nullable IrModuleFragment moduleFragment2, @NotNull Collection<? extends IrDeserializer.IrLinkerExtension> extensions) {
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        this.linkerExtensions = extensions;
        if (moduleFragment2 != null) {
            String $this$mapTo$iv$iv;
            Iterable $this$map$iv = moduleFragment2.getDescriptor().getAllDependencyModules();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                ModuleDescriptor moduleDescriptor = (ModuleDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.resolveModuleDeserializer((ModuleDescriptor)it, null));
            }
            List currentModuleDependencies = (List)destination$iv$iv;
            IrModuleDeserializer currentModuleDeserializer = this.createCurrentModuleDeserializer(moduleFragment2, currentModuleDependencies);
            Map<String, IrModuleDeserializer> map = this.deserializersForModules;
            String string2 = moduleFragment2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"moduleFragment.name.asString()");
            $this$mapTo$iv$iv = string2;
            destination$iv$iv = this.maybeWrapWithBuiltInAndInit(moduleFragment2.getDescriptor(), currentModuleDeserializer);
            map.put($this$mapTo$iv$iv, (IrModuleDeserializer)destination$iv$iv);
        }
        Iterable $this$forEach$iv = this.deserializersForModules.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleDeserializer it = (IrModuleDeserializer)element$iv;
            boolean bl = false;
            it.init();
        }
    }

    private final Set<IrClassifierSymbol> markUnlinkedClassifiers() {
        if (!this.getUnlinkedDeclarationsSupport().getAllowUnboundSymbols()) {
            return SetsKt.emptySet();
        }
        Map<IrClass, CompatibilityMode> entries = this.getFakeOverrideBuilder().getFakeOverrideCandidates();
        Set result2 = new LinkedHashSet();
        List toRemove = new ArrayList();
        for (Map.Entry<IrClass, CompatibilityMode> e : entries.entrySet()) {
            IrClass klass = e.getKey();
            if (!KotlinIrLinker.markUnlinkedClassifiers$isUnlinked-6(klass, result2, new LinkedHashSet())) continue;
            toRemove.add(klass);
        }
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrClass it = (IrClass)element$iv;
            boolean bl = false;
            entries.remove(it);
        }
        return result2;
    }

    private final void applyToModules(IrElementTransformerVoid transformer2) {
        Iterable $this$forEach$iv = this.deserializersForModules.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleDeserializer it = (IrModuleDeserializer)element$iv;
            boolean bl = false;
            IrElementTransformerVoidKt.transformChildrenVoid(it.getModuleFragment(), transformer2);
        }
    }

    @Override
    public void postProcess() {
        this.finalizeExpectActualLinker();
        Set<IrClassifierSymbol> unlinkedClassifiers = this.markUnlinkedClassifiers();
        this.getFakeOverrideBuilder().provideFakeOverrides();
        this.triedToDeserializeDeclarationForSymbol.clear();
        this.getUnlinkedDeclarationsSupport().whenUnboundSymbolsAllowed((Function1)new Function1<UnlinkedDeclarationsSupport.UnlinkedMarkerTypeHandler, Unit>(this, unlinkedClassifiers){
            final /* synthetic */ KotlinIrLinker this$0;
            final /* synthetic */ Set<IrClassifierSymbol> $unlinkedClassifiers;
            {
                this.this$0 = $receiver;
                this.$unlinkedClassifiers = $unlinkedClassifiers;
                super(1);
            }

            public final void invoke(@NotNull UnlinkedDeclarationsSupport.UnlinkedMarkerTypeHandler unlinkedMarkerTypeHandler) {
                Intrinsics.checkNotNullParameter((Object)unlinkedMarkerTypeHandler, (String)"unlinkedMarkerTypeHandler");
                UnlinkedDeclarationsProcessor t = new UnlinkedDeclarationsProcessor(this.this$0.getBuiltIns(), this.$unlinkedClassifiers, unlinkedMarkerTypeHandler, this.this$0.getMessageLogger());
                t.addLinkageErrorIntoUnlinkedClasses();
                KotlinIrLinker.access$applyToModules(this.this$0, t.signatureTransformer());
                KotlinIrLinker.access$applyToModules(this.this$0, t.usageTransformer());
            }
        });
    }

    @NotNull
    public final IrSymbol handleExpectActualMapping(@NotNull IdSignature idSig, @NotNull IrSymbol rawSymbol) {
        IdSignature idSignature;
        Intrinsics.checkNotNullParameter((Object)idSig, (String)"idSig");
        Intrinsics.checkNotNullParameter((Object)rawSymbol, (String)"rawSymbol");
        if (this.expectUniqIdToActualUniqId.values().contains(idSig)) {
            this.actualSymbols.put(idSig, rawSymbol);
        }
        if ((idSignature = this.expectUniqIdToActualUniqId.get(idSig)) != null) {
            IdSignature actualSig = idSignature;
            boolean bl = false;
            IdSignature $this$handleExpectActualMapping_u24lambda_u2d11_u24lambda_u2d9 = idSig;
            boolean bl2 = false;
            boolean bl3 = $this$handleExpectActualMapping_u24lambda_u2d11_u24lambda_u2d9.test(IdSignature.Flags.IS_EXPECT);
            if (_Assertions.ENABLED && !bl3) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            IrDelegatingSymbol<? extends IrBindableSymbol<?, ? extends IrDeclaration>, ? extends IrDeclaration, ?> referencingSymbol = IrDelegatingSymbolKt.wrapInDelegatedSymbol(rawSymbol);
            this.expectSymbols.put(idSig, referencingSymbol);
            IrModuleDeserializer irModuleDeserializer = this.topLevelActualUniqItToDeserializer.get(actualSig);
            if (irModuleDeserializer != null) {
                IrModuleDeserializer moduleDeserializer = irModuleDeserializer;
                boolean bl4 = false;
                IrSymbol actualSymbol = this.actualSymbols.get(actualSig);
                if (actualSymbol == null || !actualSymbol.isBound()) {
                    moduleDeserializer.addModuleReachableTopLevel(actualSig);
                }
            }
            return referencingSymbol;
        }
        return rawSymbol;
    }

    private final BinarySymbolData.SymbolKind topLevelKindToSymbolKind(IrDeserializer.TopLevelSymbolKind kind) {
        BinarySymbolData.SymbolKind symbolKind;
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                symbolKind = BinarySymbolData.SymbolKind.CLASS_SYMBOL;
                break;
            }
            case 2: {
                symbolKind = BinarySymbolData.SymbolKind.PROPERTY_SYMBOL;
                break;
            }
            case 3: {
                symbolKind = BinarySymbolData.SymbolKind.FUNCTION_SYMBOL;
                break;
            }
            case 4: {
                symbolKind = BinarySymbolData.SymbolKind.TYPEALIAS_SYMBOL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return symbolKind;
    }

    @Override
    @NotNull
    public IrSymbol resolveBySignatureInModule(@NotNull IdSignature signature2, @NotNull IrDeserializer.TopLevelSymbolKind kind, @NotNull Name moduleName) {
        IrSymbol irSymbol2;
        Object object;
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter((Object)signature2, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
            Iterable iterable = this.deserializersForModules.entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getKey(), (Object)moduleName.asString())) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        if ((object = (Map.Entry)v0) == null || (object = (IrModuleDeserializer)object.getValue()) == null) {
            throw new IllegalStateException(("No module for name '" + moduleName + "' found").toString());
        }
        Object moduleDeserializer = object;
        boolean bl = Intrinsics.areEqual((Object)signature2, (Object)signature2.topLevelSignature());
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-KotlinIrLinker$resolveBySignatureInModule$22 = false;
            String $i$a$-assert-KotlinIrLinker$resolveBySignatureInModule$22 = "Signature '" + signature2 + "' has to be top level";
            throw new AssertionError((Object)$i$a$-assert-KotlinIrLinker$resolveBySignatureInModule$22);
        }
        if (!((IrModuleDeserializer)moduleDeserializer).contains(signature2)) {
            throw new IllegalStateException(("No signature " + signature2 + " in module " + moduleName).toString());
        }
        IrSymbol it = irSymbol2 = ((IrModuleDeserializer)moduleDeserializer).deserializeIrSymbol(signature2, this.topLevelKindToSymbolKind(kind));
        boolean bl2 = false;
        this.deserializeAllReachableTopLevels();
        return irSymbol2;
    }

    private final void actualizeIrFunction(IrFunction e, IrFunction a) {
        int n = e.getValueParameters().size();
        for (int i = 0; i < n; ++i) {
            IrValueParameter evp = e.getValueParameters().get(i);
            IrValueParameter avp = a.getValueParameters().get(i);
            IrExpressionBody defaultValue = evp.getDefaultValue();
            if (avp.getDefaultValue() != null || defaultValue == null) continue;
            avp.setDefaultValue((IrExpressionBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)defaultValue, a));
            evp.setDefaultValue(null);
        }
    }

    private final void finalizeExpectActualLinker() {
        Map<IdSignature, IdSignature> $this$forEach$iv = this.expectUniqIdToActualUniqId;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<IdSignature, IdSignature>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            KotlinIrLinker this_$iv;
            Object actualDeclaration$iv;
            IrDeclaration expectDeclaration$iv;
            IrDelegatingSymbol expectSymbol$iv;
            boolean $i$f$finalizeExpectActual;
            Function2 actualizer$iv;
            Map.Entry<IdSignature, IdSignature> element$iv;
            Map.Entry<IdSignature, IdSignature> it = element$iv = iterator2.next();
            boolean bl = false;
            IrSymbol expectSymbol = this.expectSymbols.get(it.getKey());
            IrSymbol actualSymbol = this.actualSymbols.get(it.getValue());
            if (expectSymbol == null || actualSymbol == null) continue;
            IrSymbol irSymbol2 = expectSymbol;
            if (irSymbol2 instanceof IrDelegatingClassSymbolImpl) {
                KotlinIrLinker kotlinIrLinker = this;
                IrDelegatingSymbol irDelegatingSymbol = (IrDelegatingSymbol)expectSymbol;
                actualizer$iv = finalizeExpectActualLinker.1.1.INSTANCE;
                $i$f$finalizeExpectActual = false;
                if (!(actualSymbol instanceof IrClassSymbol)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                expectDeclaration$iv = (IrDeclaration)expectSymbol$iv.getOwner();
                actualDeclaration$iv = (IrDeclaration)((IrBindableSymbol)actualSymbol).getOwner();
                actualizer$iv.invoke((Object)expectDeclaration$iv, actualDeclaration$iv);
                expectSymbol$iv.setDelegate((IrBindableSymbol)actualSymbol);
                continue;
            }
            if (irSymbol2 instanceof IrDelegatingEnumEntrySymbolImpl) {
                this_$iv = this;
                expectSymbol$iv = (IrDelegatingSymbol)expectSymbol;
                actualizer$iv = finalizeExpectActualLinker.1.2.INSTANCE;
                $i$f$finalizeExpectActual = false;
                if (!(actualSymbol instanceof IrEnumEntrySymbol)) {
                    actualDeclaration$iv = "Failed requirement.";
                    throw new IllegalArgumentException(actualDeclaration$iv.toString());
                }
                expectDeclaration$iv = (IrDeclaration)expectSymbol$iv.getOwner();
                actualDeclaration$iv = (IrDeclaration)((IrBindableSymbol)actualSymbol).getOwner();
                actualizer$iv.invoke((Object)expectDeclaration$iv, actualDeclaration$iv);
                expectSymbol$iv.setDelegate((IrBindableSymbol)actualSymbol);
                continue;
            }
            if (irSymbol2 instanceof IrDelegatingSimpleFunctionSymbolImpl) {
                this_$iv = this;
                expectSymbol$iv = (IrDelegatingSymbol)expectSymbol;
                actualizer$iv = (Function2)new Function2<IrSimpleFunction, IrSimpleFunction, Unit>(this){
                    final /* synthetic */ KotlinIrLinker this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull IrSimpleFunction e, @NotNull IrSimpleFunction a) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                        KotlinIrLinker.access$actualizeIrFunction(this.this$0, e, a);
                    }
                };
                $i$f$finalizeExpectActual = false;
                if (!(actualSymbol instanceof IrSimpleFunctionSymbol)) {
                    actualDeclaration$iv = "Failed requirement.";
                    throw new IllegalArgumentException(actualDeclaration$iv.toString());
                }
                expectDeclaration$iv = (IrDeclaration)expectSymbol$iv.getOwner();
                actualDeclaration$iv = (IrDeclaration)((IrBindableSymbol)actualSymbol).getOwner();
                actualizer$iv.invoke((Object)expectDeclaration$iv, actualDeclaration$iv);
                expectSymbol$iv.setDelegate((IrBindableSymbol)actualSymbol);
                continue;
            }
            if (irSymbol2 instanceof IrDelegatingConstructorSymbolImpl) {
                this_$iv = this;
                expectSymbol$iv = (IrDelegatingSymbol)expectSymbol;
                actualizer$iv = (Function2)new Function2<IrConstructor, IrConstructor, Unit>(this){
                    final /* synthetic */ KotlinIrLinker this$0;
                    {
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull IrConstructor e, @NotNull IrConstructor a) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                        KotlinIrLinker.access$actualizeIrFunction(this.this$0, e, a);
                    }
                };
                $i$f$finalizeExpectActual = false;
                if (!(actualSymbol instanceof IrConstructorSymbol)) {
                    actualDeclaration$iv = "Failed requirement.";
                    throw new IllegalArgumentException(actualDeclaration$iv.toString());
                }
                expectDeclaration$iv = (IrDeclaration)expectSymbol$iv.getOwner();
                actualDeclaration$iv = (IrDeclaration)((IrBindableSymbol)actualSymbol).getOwner();
                actualizer$iv.invoke((Object)expectDeclaration$iv, actualDeclaration$iv);
                expectSymbol$iv.setDelegate((IrBindableSymbol)actualSymbol);
                continue;
            }
            if (irSymbol2 instanceof IrDelegatingPropertySymbolImpl) {
                this_$iv = this;
                expectSymbol$iv = (IrDelegatingSymbol)expectSymbol;
                actualizer$iv = finalizeExpectActualLinker.1.5.INSTANCE;
                $i$f$finalizeExpectActual = false;
                if (!(actualSymbol instanceof IrPropertySymbol)) {
                    actualDeclaration$iv = "Failed requirement.";
                    throw new IllegalArgumentException(actualDeclaration$iv.toString());
                }
                expectDeclaration$iv = (IrDeclaration)expectSymbol$iv.getOwner();
                actualDeclaration$iv = (IrDeclaration)((IrBindableSymbol)actualSymbol).getOwner();
                actualizer$iv.invoke((Object)expectDeclaration$iv, actualDeclaration$iv);
                expectSymbol$iv.setDelegate((IrBindableSymbol)actualSymbol);
                continue;
            }
            throw new IllegalStateException(("Unexpected expect symbol kind during actualization: " + expectSymbol).toString());
        }
    }

    @NotNull
    public final IrModuleFragment deserializeIrModuleHeader(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary, @NotNull Function1<? super String, ? extends DeserializationStrategy> deserializationStrategy2, @Nullable String _moduleName) {
        IrModuleDeserializer irModuleDeserializer;
        Object object;
        block8: {
            block7: {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
                Intrinsics.checkNotNullParameter(deserializationStrategy2, (String)"deserializationStrategy");
                boolean bl2 = bl = kotlinLibrary != null || _moduleName != null;
                if (_Assertions.ENABLED && !bl) {
                    boolean $i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$42 = false;
                    String $i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$42 = "Either library or explicit name have to be provided " + moduleDescriptor;
                    throw new AssertionError((Object)$i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$42);
                }
                object = kotlinLibrary;
                if (object == null || (object = KotlinLibraryKt.getUniqueName((BaseKotlinLibrary)object)) == null) break block7;
                Object it = object;
                boolean bl3 = false;
                String string2 = '<' + (String)it + '>';
                object = string2;
                if (string2 != null) break block8;
            }
            String string3 = _moduleName;
            object = string3;
            Intrinsics.checkNotNull((Object)string3);
        }
        Object moduleName = object;
        boolean $i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$42 = Intrinsics.areEqual((Object)moduleDescriptor.getName().asString(), (Object)moduleName);
        if (_Assertions.ENABLED && !$i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$42) {
            boolean $i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$52 = false;
            String $i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$52 = moduleDescriptor.getName().asString() + " != " + (String)moduleName;
            throw new AssertionError((Object)$i$a$-assert-KotlinIrLinker$deserializeIrModuleHeader$52);
        }
        Map<String, IrModuleDeserializer> $this$getOrPut$iv = this.deserializersForModules;
        boolean $i$f$getOrPut = false;
        IrModuleDeserializer value$iv = $this$getOrPut$iv.get(moduleName);
        if (value$iv == null) {
            boolean bl = false;
            IrModuleDeserializer answer$iv = this.maybeWrapWithBuiltInAndInit(moduleDescriptor, this.createModuleDeserializer(moduleDescriptor, kotlinLibrary, deserializationStrategy2));
            $this$getOrPut$iv.put((String)moduleName, answer$iv);
            irModuleDeserializer = answer$iv;
        } else {
            irModuleDeserializer = value$iv;
        }
        IrModuleDeserializer deserializerForModule = irModuleDeserializer;
        return deserializerForModule.getModuleFragment();
    }

    public static /* synthetic */ IrModuleFragment deserializeIrModuleHeader$default(KotlinIrLinker kotlinIrLinker, ModuleDescriptor moduleDescriptor, KotlinLibrary kotlinLibrary, Function1 function1, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deserializeIrModuleHeader");
        }
        if ((n & 4) != 0) {
            function1 = deserializeIrModuleHeader.1.INSTANCE;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return kotlinIrLinker.deserializeIrModuleHeader(moduleDescriptor, kotlinLibrary, (Function1<? super String, ? extends DeserializationStrategy>)function1, string2);
    }

    @NotNull
    protected IrModuleDeserializer maybeWrapWithBuiltInAndInit(@NotNull ModuleDescriptor moduleDescriptor, @NotNull IrModuleDeserializer moduleDeserializer) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)moduleDeserializer, (String)"moduleDeserializer");
        return this.isBuiltInModule(moduleDescriptor) ? (IrModuleDeserializer)new IrModuleDeserializerWithBuiltIns(this.builtIns, moduleDeserializer) : moduleDeserializer;
    }

    @NotNull
    public final IrModuleFragment deserializeIrModuleHeader(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Function1 deserializationStrategy2 = this.exportedDependencies.contains(moduleDescriptor) ? (Function1)deserializeIrModuleHeader.deserializationStrategy.1.INSTANCE : (Function1)deserializeIrModuleHeader.deserializationStrategy.2.INSTANCE;
        return this.deserializeIrModuleHeader(moduleDescriptor, kotlinLibrary, (Function1<? super String, ? extends DeserializationStrategy>)deserializationStrategy2, moduleName);
    }

    @NotNull
    public final IrModuleFragment deserializeFullModule(@NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)kotlinLibrary, (String)"kotlinLibrary");
        return KotlinIrLinker.deserializeIrModuleHeader$default(this, moduleDescriptor, kotlinLibrary, deserializeFullModule.1.INSTANCE, null, 8, null);
    }

    @NotNull
    public final IrModuleFragment deserializeOnlyHeaderModule(@NotNull ModuleDescriptor moduleDescriptor, @Nullable KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        return KotlinIrLinker.deserializeIrModuleHeader$default(this, moduleDescriptor, kotlinLibrary, deserializeOnlyHeaderModule.1.INSTANCE, null, 8, null);
    }

    @NotNull
    public final IrModuleFragment deserializeHeadersWithInlineBodies(@NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinLibrary kotlinLibrary) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)kotlinLibrary, (String)"kotlinLibrary");
        return KotlinIrLinker.deserializeIrModuleHeader$default(this, moduleDescriptor, kotlinLibrary, deserializeHeadersWithInlineBodies.1.INSTANCE, null, 8, null);
    }

    @NotNull
    public final IrModuleFragment deserializeDirtyFiles(@NotNull ModuleDescriptor moduleDescriptor, @NotNull KotlinLibrary kotlinLibrary, @NotNull Collection<String> dirtyFiles) {
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Intrinsics.checkNotNullParameter((Object)kotlinLibrary, (String)"kotlinLibrary");
        Intrinsics.checkNotNullParameter(dirtyFiles, (String)"dirtyFiles");
        return KotlinIrLinker.deserializeIrModuleHeader$default(this, moduleDescriptor, kotlinLibrary, (Function1)new Function1<String, DeserializationStrategy>(dirtyFiles){
            final /* synthetic */ Collection<String> $dirtyFiles;
            {
                this.$dirtyFiles = $dirtyFiles;
                super(1);
            }

            @NotNull
            public final DeserializationStrategy invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$dirtyFiles.contains(it) ? DeserializationStrategy.ALL : DeserializationStrategy.WITH_INLINE_BODIES;
            }
        }, null, 8, null);
    }

    private static final boolean markUnlinkedClassifiers$isUnlinked(IrType $this$markUnlinkedClassifiers_u24isUnlinked, Set<IrClassifierSymbol> result2, Set<IrClassifierSymbol> visited2) {
        boolean bl;
        IrClassifierSymbol classifier2;
        IrSimpleType simpleType2;
        block9: {
            IrSimpleType irSimpleType = $this$markUnlinkedClassifiers_u24isUnlinked instanceof IrSimpleType ? (IrSimpleType)$this$markUnlinkedClassifiers_u24isUnlinked : null;
            if (irSimpleType == null) {
                return !($this$markUnlinkedClassifiers_u24isUnlinked instanceof IrErrorType);
            }
            simpleType2 = irSimpleType;
            classifier2 = simpleType2.getClassifier();
            if (!classifier2.isBound()) {
                return true;
            }
            if (result2.contains(classifier2)) {
                return true;
            }
            if (!visited2.add(classifier2)) {
                return false;
            }
            IrSymbolOwner decl = classifier2.getOwner();
            List<IrType> superTypes2 = decl instanceof IrClass ? ((IrClass)decl).getSuperTypes() : (decl instanceof IrTypeParameter ? ((IrTypeParameter)decl).getSuperTypes() : CollectionsKt.emptyList());
            Iterable $this$any$iv = superTypes2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrType it = (IrType)element$iv;
                    boolean bl2 = false;
                    if (!KotlinIrLinker.markUnlinkedClassifiers$isUnlinked(it, result2, visited2)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            result2.add(classifier2);
            return true;
        }
        for (IrTypeArgument ta : simpleType2.getArguments()) {
            IrType projected;
            if (!(ta instanceof IrTypeProjection) || !KotlinIrLinker.markUnlinkedClassifiers$isUnlinked(projected = ((IrTypeProjection)ta).getType(), result2, visited2)) continue;
            return true;
        }
        return false;
    }

    private static final boolean markUnlinkedClassifiers$isUnlinked-6(IrClass $this$markUnlinkedClassifiers_u24isUnlinked_u2d6, Set<IrClassifierSymbol> result2, Set<IrClassifierSymbol> visited2) {
        if (result2.contains($this$markUnlinkedClassifiers_u24isUnlinked_u2d6.getSymbol())) {
            return true;
        }
        for (IrType s : $this$markUnlinkedClassifiers_u24isUnlinked_u2d6.getSuperTypes()) {
            if (!KotlinIrLinker.markUnlinkedClassifiers$isUnlinked(s, result2, visited2)) continue;
            result2.add($this$markUnlinkedClassifiers_u24isUnlinked_u2d6.getSymbol());
            return true;
        }
        return false;
    }

    public static final /* synthetic */ void access$applyToModules(KotlinIrLinker $this, IrElementTransformerVoid transformer2) {
        $this.applyToModules(transformer2);
    }

    public static final /* synthetic */ void access$actualizeIrFunction(KotlinIrLinker $this, IrFunction e, IrFunction a) {
        $this.actualizeIrFunction(e, a);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrDeserializer.TopLevelSymbolKind.values().length];
            nArray[IrDeserializer.TopLevelSymbolKind.CLASS_SYMBOL.ordinal()] = 1;
            nArray[IrDeserializer.TopLevelSymbolKind.PROPERTY_SYMBOL.ordinal()] = 2;
            nArray[IrDeserializer.TopLevelSymbolKind.FUNCTION_SYMBOL.ordinal()] = 3;
            nArray[IrDeserializer.TopLevelSymbolKind.TYPEALIAS_SYMBOL.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

