/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.Script;
import java.io.File;
import java.io.PrintStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.CompileTimeStrategy;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.FreeplaneScriptBaseClass;
import org.freeplane.plugin.script.GroovyShell;
import org.freeplane.plugin.script.GroovyStaticImports;
import org.freeplane.plugin.script.IFreeplaneScriptErrorHandler;
import org.freeplane.plugin.script.IScript;
import org.freeplane.plugin.script.ScriptClassLoader;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.ScriptResources;
import org.freeplane.plugin.script.ScriptSecurity;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.ScriptingSecurityManager;
import org.freeplane.plugin.script.proxy.ScriptUtils;

public class GroovyScript
implements IScript {
    private final Object script;
    private final ScriptingPermissions specificPermissions;
    private FreeplaneScriptBaseClass compiledScript;
    private Throwable errorsInScript;
    private CompileTimeStrategy compileTimeStrategy;
    private ScriptClassLoader scriptClassLoader;
    private static boolean accessPermissionCheckerChecked = false;

    public GroovyScript(String script) {
        this((Object)script);
    }

    public GroovyScript(File script) {
        this((Object)script);
        this.compileTimeStrategy = new CompileTimeStrategy(script);
    }

    public GroovyScript(String script, ScriptingPermissions permissions) {
        this((Object)script, permissions);
    }

    public GroovyScript(File script, ScriptingPermissions permissions) {
        this((Object)script, permissions);
        this.compileTimeStrategy = new CompileTimeStrategy(script);
    }

    private GroovyScript(Object script, ScriptingPermissions permissions) {
        this.script = script;
        this.specificPermissions = permissions;
        this.compiledScript = null;
        this.errorsInScript = null;
        this.compileTimeStrategy = new CompileTimeStrategy(null);
    }

    private GroovyScript(Object script) {
        this(script, null);
    }

    public Script getCompiledScript() {
        return this.compiledScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(final NodeModel node, PrintStream outStream, IFreeplaneScriptErrorHandler errorHandler, final ScriptContext scriptContext) {
        Object object;
        ClassLoader contextClassLoader;
        block9: {
            if (this.errorsInScript != null && this.compileTimeStrategy.canUseOldCompiledScript()) {
                throw new ExecuteScriptException(this.errorsInScript.getMessage(), this.errorsInScript);
            }
            PrintStream oldOut = System.out;
            contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Object result;
                this.trustedCompileAndCache(outStream);
                Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this.scriptClassLoader));
                FreeplaneScriptBaseClass scriptWithBinding = AccessController.doPrivileged(new PrivilegedAction<FreeplaneScriptBaseClass>(){

                    @Override
                    public FreeplaneScriptBaseClass run() {
                        return GroovyScript.this.compiledScript.withBinding(node, scriptContext);
                    }
                });
                if (oldOut != outStream) {
                    System.setOut(outStream);
                }
                object = result = scriptWithBinding.run();
                if (oldOut == outStream) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (oldOut != outStream) {
                        System.setOut(oldOut);
                    }
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                    throw throwable;
                }
                catch (GroovyRuntimeException e) {
                    this.handleScriptRuntimeException(e, outStream, errorHandler);
                    throw new RuntimeException(e);
                }
                catch (Throwable e) {
                    throw new ExecuteScriptException(e.getMessage(), e);
                }
            }
            System.setOut(oldOut);
        }
        Thread.currentThread().setContextClassLoader(contextClassLoader);
        return object;
    }

    private ScriptingSecurityManager createScriptingSecurityManager(PrintStream outStream) {
        return new ScriptSecurity(this.script, this.specificPermissions, outStream).getScriptingSecurityManager();
    }

    private void trustedCompileAndCache(final PrintStream outStream) throws Throwable {
        AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws PrivilegedActionException {
                try {
                    ScriptingSecurityManager scriptingSecurityManager = GroovyScript.this.createScriptingSecurityManager(outStream);
                    GroovyScript.this.compileAndCache(scriptingSecurityManager);
                }
                catch (Exception e) {
                    throw new PrivilegedActionException(e);
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
    }

    private Script compileAndCache(ScriptingSecurityManager scriptingSecurityManager) throws Throwable {
        GroovyScript.checkAccessPermissionCheckerExists();
        if (this.compileTimeStrategy.canUseOldCompiledScript()) {
            this.scriptClassLoader.setSecurityManager(scriptingSecurityManager);
            return this.compiledScript;
        }
        this.removeOldScript();
        this.errorsInScript = null;
        if (this.script instanceof Script) {
            return (Script)this.script;
        }
        try {
            Binding binding = this.createBindingForCompilation();
            this.scriptClassLoader = ScriptClassLoader.createClassLoader();
            this.scriptClassLoader.setSecurityManager(scriptingSecurityManager);
            GroovyShell shell = new GroovyShell((ClassLoader)((Object)this.scriptClassLoader), binding, GroovyScript.createCompilerConfiguration());
            this.compileTimeStrategy.scriptCompileStart();
            if (this.script instanceof String) {
                this.compiledScript = (FreeplaneScriptBaseClass)shell.parse((String)this.script);
            } else if (this.script instanceof File) {
                this.compiledScript = (FreeplaneScriptBaseClass)shell.parse((File)this.script);
            } else {
                throw new IllegalArgumentException();
            }
            this.compiledScript.setScript(this.script);
            this.compileTimeStrategy.scriptCompiled();
            return this.compiledScript;
        }
        catch (Throwable e) {
            this.errorsInScript = e;
            throw e;
        }
    }

    static void checkAccessPermissionCheckerExists() {
        if (!accessPermissionCheckerChecked) {
            if (System.getSecurityManager() != null) {
                try {
                    GroovyScript.class.getClassLoader().loadClass("org.codehaus.groovy.reflection.AccessPermissionChecker");
                }
                catch (ClassNotFoundException e) {
                    throw new AccessControlException("class org.codehaus.groovy.reflection.AccessPermissionChecker not found");
                }
            }
            accessPermissionCheckerChecked = true;
        }
    }

    private void removeOldScript() {
        if (this.compiledScript != null) {
            InvokerHelper.removeClass(((Object)((Object)this.compiledScript)).getClass());
            this.compiledScript = null;
        }
    }

    private Binding createBindingForCompilation() {
        Binding binding = new Binding();
        binding.setVariable("script", this.script);
        return binding;
    }

    private void handleScriptRuntimeException(GroovyRuntimeException e, PrintStream outStream, IFreeplaneScriptErrorHandler errorHandler) {
        outStream.print("message: " + e.getMessage());
        ModuleNode module = e.getModule();
        ASTNode astNode = e.getNode();
        int lineNumber = -1;
        lineNumber = module != null ? module.getLineNumber() : (astNode != null ? astNode.getLineNumber() : this.findLineNumberInString(e.getMessage(), lineNumber));
        outStream.print("Line number: " + lineNumber);
        errorHandler.gotoLine(lineNumber);
        throw new ExecuteScriptException(e.getMessage() + " at line " + lineNumber, e);
    }

    static CompilerConfiguration createCompilerConfiguration() {
        CompilerConfiguration config = new CompilerConfiguration();
        config.setScriptBaseClass(FreeplaneScriptBaseClass.class.getName());
        if (ScriptResources.getClasspath() != null && !ScriptResources.getClasspath().isEmpty()) {
            config.setClasspathList(ScriptResources.getClasspath());
        }
        ImportCustomizer importCustomizer = new ImportCustomizer();
        importCustomizer.addStaticImport(ScriptUtils.class.getName(), "ignoreCycles");
        importCustomizer.addStaticStars(new String[]{GroovyStaticImports.class.getName()});
        config.addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
        return config;
    }

    private int findLineNumberInString(String resultString, int lineNumber) {
        Pattern pattern = Pattern.compile(".*@ line ([0-9]+).*", 32);
        Matcher matcher = pattern.matcher(resultString);
        if (matcher.matches()) {
            lineNumber = Integer.parseInt(matcher.group(1));
        }
        return lineNumber;
    }

    protected void finalize() throws Throwable {
        this.removeOldScript();
        super.finalize();
    }

    @Override
    public boolean hasPermissions(ScriptingPermissions permissions) {
        if (this.specificPermissions == null) {
            return this.specificPermissions == permissions;
        }
        return this.specificPermissions.equals(permissions);
    }
}

