/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.link.HyperLinkCondition;

public class HyperLinkContainsCondition
extends HyperLinkCondition {
    public static final String NAME = "hyper_link_contains";
    private final StringMatchingStrategy stringMatchingStrategy;

    public HyperLinkContainsCondition(String hyperlink, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        super(hyperlink, matchCase, matchApproximately, ignoreDiacritics);
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    @Override
    protected boolean checkLink(Hyperlink nodeLink) {
        return this.stringMatchingStrategy.matches(this.normalizedValue(), this.normalize(nodeLink), true);
    }

    @Override
    protected String createDescription() {
        String condition = TextUtils.getText("filter_link");
        String simpleCondition = TextUtils.getText("filter_contains");
        return this.createDescription(condition, simpleCondition, this.getHyperlink());
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

