/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.action;

import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.menubuilders.action.EntriesForAction;
import org.freeplane.core.ui.menubuilders.action.IAcceleratorMap;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;

public class AcceleratorBuilder
implements EntryVisitor {
    private final IAcceleratorMap map;
    private final EntriesForAction entries;

    public AcceleratorBuilder(IAcceleratorMap map, EntriesForAction entries) {
        this.map = map;
        this.entries = entries;
    }

    @Override
    public void visit(Entry entry) {
        AFreeplaneAction action = new EntryAccessor().getAction(entry);
        if (action != null) {
            EntryAccessor entryAccessor = new EntryAccessor();
            String accelerator = entryAccessor.getAccelerator(entry);
            if (accelerator != null) {
                this.map.setDefaultAccelerator(action, accelerator);
            } else {
                this.map.setUserDefinedAccelerator(action);
            }
            this.entries.registerEntry(action, entry);
        }
    }

    @Override
    public boolean shouldSkipChildren(Entry entry) {
        return false;
    }
}

