/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.net.URI;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.ObjectAndIcon;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.icon.factory.IconFactory;

public class TypedListCellRenderer
extends DefaultListCellRenderer {
    private static final TypedListCellRenderer instance = new TypedListCellRenderer();
    private static final long serialVersionUID = 1L;
    private static Icon textIcon;
    private static Icon numberIcon;
    private static Icon dateIcon;
    private static Icon dateTimeIcon;
    private static Icon linkIcon;

    static TypedListCellRenderer getInstance() {
        return instance;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        FormattedDate fd;
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        Icon icon = value instanceof String ? textIcon : (value instanceof FormattedDate ? ((fd = (FormattedDate)value).containsTime() ? dateTimeIcon : dateIcon) : (value instanceof Hyperlink || value instanceof URI ? linkIcon : (value instanceof Number ? numberIcon : (value instanceof ObjectAndIcon ? ((ObjectAndIcon)value).getIcon() : null))));
        IconFactory iconFactory = IconFactory.getInstance();
        if (icon != null && iconFactory.canScaleIcon(icon)) {
            int fontSize = this.getFont().getSize();
            this.setIcon(iconFactory.getScaledIcon(icon, (Quantity<LengthUnit>)new Quantity((double)fontSize, (Enum)LengthUnit.px)));
        } else {
            this.setIcon(icon);
        }
        return this;
    }

    static {
        ResourceController resourceController = ResourceController.getResourceController();
        textIcon = resourceController.getIcon("text_icon");
        numberIcon = resourceController.getIcon("number_icon");
        dateIcon = resourceController.getIcon("date_icon");
        dateTimeIcon = resourceController.getIcon("date_time_icon");
        linkIcon = resourceController.getIcon("link_icon");
    }
}

