/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.ShowSelectionAsRectangleAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.generic.ChildActionEntryRemover;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.MenuUtils;
import org.freeplane.core.util.logging.internal.LogInitializer;
import org.freeplane.features.attribute.ModelessAttributeController;
import org.freeplane.features.explorer.MapExplorerConditionController;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.FreeSelectNodeAction;
import org.freeplane.features.filter.NextNodeAction;
import org.freeplane.features.filter.NextPresentationItemAction;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.format.FormatController;
import org.freeplane.features.format.ScannerController;
import org.freeplane.features.help.HelpController;
import org.freeplane.features.highlight.HighlightController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.FreeplaneActions;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.QuitAction;
import org.freeplane.features.print.PrintController;
import org.freeplane.features.styles.LogicalStyleFilterController;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.text.TextController;
import org.freeplane.features.time.TimeController;
import org.freeplane.features.ui.FrameController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.url.mindmapmode.ExternalMapChangeMonitor;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.main.application.ApplicationLifecycleListener;
import org.freeplane.main.application.ApplicationResourceController;
import org.freeplane.main.application.ApplicationViewController;
import org.freeplane.main.application.CloseAllMapsAction;
import org.freeplane.main.application.CloseAllOtherMapsAction;
import org.freeplane.main.application.CommandLineOptions;
import org.freeplane.main.application.FreeplaneSplashModern;
import org.freeplane.main.application.FreeplaneStarter;
import org.freeplane.main.application.LastOpenedList;
import org.freeplane.main.application.MacOptions;
import org.freeplane.main.application.MenuKeyProcessor;
import org.freeplane.main.application.UserPropertiesUpdater;
import org.freeplane.main.application.survey.FreeplaneSurveyProperties;
import org.freeplane.main.application.survey.SurveyRunner;
import org.freeplane.main.application.survey.SurveyStarter;
import org.freeplane.main.filemode.FModeControllerFactory;
import org.freeplane.main.mindmapmode.MModeControllerFactory;
import org.freeplane.view.swing.features.nodehistory.NodeHistory;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.ViewLayoutTypeAction;
import org.freeplane.view.swing.map.mindmapmode.MMapViewController;

public class FreeplaneGUIStarter
implements FreeplaneStarter {
    private static boolean ARE_SURVEYS_ENABLED = false;
    private final ApplicationResourceController applicationResourceController;
    private FreeplaneSplashModern splash = null;
    private boolean startupFinished = false;
    private ApplicationViewController viewController;
    private boolean dontLoadLastMaps;
    private static final String LOAD_LAST_MAPS = "load_last_maps";
    private static final String LOAD_LAST_MAP = "load_last_map";
    private static final String CREATE_NEW_MAP_IF_NO_MAPS_ARE_LOADED = "create_new_map_if_no_maps_are_loaded";
    private final CommandLineOptions options;
    private final UserPropertiesStatus userPropertiesStatus;

    private static void fixX11AppName() {
        if (!System.getProperty("java.version").startsWith("1.")) {
            return;
        }
        try {
            Toolkit xToolkit = Toolkit.getDefaultToolkit();
            if (xToolkit.getClass().getName().equals("sun.awt.X11.XToolkit")) {
                Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
                awtAppClassNameField.setAccessible(true);
                awtAppClassNameField.set(xToolkit, "Freeplane");
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            System.err.format("Couldn't set awtAppClassName: %s%n", e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    private static void fixMousePointerForLinux() {
        if (FreeplaneGUIStarter.isX11WindowManager()) {
            try {
                Class<?> xwm = Class.forName("sun.awt.X11.XWM");
                Field awt_wmgr = xwm.getDeclaredField("awt_wmgr");
                awt_wmgr.setAccessible(true);
                Field other_wm = xwm.getDeclaredField("OTHER_WM");
                other_wm.setAccessible(true);
                if (awt_wmgr.get(null).equals(other_wm.get(null))) {
                    Field metacity_wm = xwm.getDeclaredField("METACITY_WM");
                    metacity_wm.setAccessible(true);
                    awt_wmgr.set(null, metacity_wm.get(null));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean isX11WindowManager() {
        return Arrays.asList("gnome-shell", "mate", "other...").contains(System.getenv("DESKTOP_SESSION"));
    }

    public FreeplaneGUIStarter(CommandLineOptions options) {
        this.options = options;
        this.userPropertiesStatus = new UserPropertiesUpdater().importOldProperties();
        this.applicationResourceController = new ApplicationResourceController();
        FreeplaneGUIStarter.fixMousePointerForLinux();
        FreeplaneGUIStarter.fixX11AppName();
    }

    @Override
    public void setDontLoadLastMaps() {
        this.dontLoadLastMaps = true;
    }

    @Override
    public Controller createController() {
        try {
            String lookandfeel;
            final Controller controller = new Controller((ResourceController)this.applicationResourceController);
            Controller.setCurrentController((Controller)controller);
            Compat.macAppChanges();
            controller.addAction((AFreeplaneAction)new QuitAction());
            this.applicationResourceController.init();
            LogInitializer.createLogger();
            ApplicationResourceController.showSysInfo();
            String systemPropertyLookandfeel = System.getProperty("lookandfeel");
            if (systemPropertyLookandfeel == null) {
                this.applicationResourceController.addPropertyChangeListener((propertyName, newValue, oldValue) -> {
                    if ("lookandfeel".equals(propertyName)) {
                        FrameController.setLookAndFeel((String)newValue);
                        if ("org.violetlib.aqua.AquaLookAndFeel".equals(newValue)) {
                            Component currentRootComponent = UITools.getMenuComponent();
                            Stream.of(SwingUtilities.getRootPane(currentRootComponent).getComponents()).forEach(SwingUtilities::updateComponentTreeUI);
                        }
                        SwingUtilities.updateComponentTreeUI(UITools.getFrame());
                    }
                });
                lookandfeel = this.applicationResourceController.getProperty("lookandfeel");
            } else {
                lookandfeel = systemPropertyLookandfeel;
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    FrameController.setLookAndFeel((String)lookandfeel);
                    JFrame frame = new JFrame("Freeplane");
                    frame.setContentPane(new JPanel(){

                        @Override
                        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                            return super.processKeyBinding(ks, e, condition, pressed) || MenuKeyProcessor.INSTANCE.processKeyBinding(ks, e, condition, pressed);
                        }
                    });
                    frame.setName("mainFreeplaneFrame");
                    MMapViewController mapViewController = new MMapViewController(controller);
                    controller.addAction((AFreeplaneAction)new CloseAllMapsAction(mapViewController));
                    controller.addAction((AFreeplaneAction)new CloseAllOtherMapsAction(mapViewController));
                    FreeplaneGUIStarter.this.viewController = new ApplicationViewController(controller, (IMapViewManager)mapViewController, frame);
                    FreeplaneGUIStarter.this.splash = new FreeplaneSplashModern(frame);
                    mapViewController.addMapViewChangeListener(FreeplaneGUIStarter.this.applicationResourceController.getLastOpenedList());
                }
            });
            if (!System.getProperty("org.freeplane.nosplash", "false").equals("true")) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        FreeplaneGUIStarter.this.splash.setVisible(true);
                    }
                });
            }
            this.viewController.invokeAndWait(() -> {
                controller.addExtension(HighlightController.class, (IExtension)new HighlightController());
                FilterController.install();
                PrintController.install();
                FormatController.install((FormatController)new FormatController());
                ScannerController scannerController = new ScannerController();
                ScannerController.install((ScannerController)scannerController);
                scannerController.addParsersForStandardFormats();
                ModelessAttributeController.install();
                TextController.install();
                TimeController.install();
                LinkController.install();
                IconController.installConditionControllers();
                HelpController.install();
                Stream.of(MapController.Direction.values()).filter(direction -> !direction.removesFilter()).forEach(direction -> controller.addAction((AFreeplaneAction)new NextNodeAction(direction)));
                Arrays.stream(FreeSelectNodeAction.Direction.values()).forEach(d -> controller.addAction((AFreeplaneAction)new FreeSelectNodeAction(d)));
                controller.addAction((AFreeplaneAction)NextPresentationItemAction.createFoldingAction());
                controller.addAction((AFreeplaneAction)NextPresentationItemAction.createNotFoldingAction());
                controller.addAction((AFreeplaneAction)new ShowSelectionAsRectangleAction());
                controller.addAction((AFreeplaneAction)new ViewLayoutTypeAction(MapViewLayout.OUTLINE));
                FilterController.getCurrentFilterController().getConditionFactory().addConditionController(70, (IElementaryConditionController)new LogicalStyleFilterController());
                MapController.install();
                NodeHistory.install((Controller)controller);
                MapExplorerConditionController.installFilterConditions();
                FreeplaneSurveyProperties freeplaneSurveyProperties = new FreeplaneSurveyProperties();
                if (ARE_SURVEYS_ENABLED && freeplaneSurveyProperties.mayAskUserToFillSurveys()) {
                    controller.addApplicationLifecycleListener((ApplicationLifecycleListener)new SurveyStarter(freeplaneSurveyProperties, new SurveyRunner(freeplaneSurveyProperties), Math.random()));
                }
            });
            return controller;
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void createModeControllers(Controller controller) {
        MModeControllerFactory.createModeController();
        ModeController mindMapModeController = controller.getModeController("MindMap");
        LastOpenedList lastOpenedList = this.applicationResourceController.getLastOpenedList();
        mindMapModeController.getMapController().addUIMapChangeListener((IMapChangeListener)lastOpenedList);
        lastOpenedList.registerMenuContributor(mindMapModeController);
        mindMapModeController.addUiBuilder(PhaseProcessor.Phase.ACTIONS, "filterConditions", FilterController.getController((Controller)controller).getMenuBuilder(), (EntryVisitor)new ChildActionEntryRemover((FreeplaneActions)controller));
        FModeControllerFactory.createModeController();
    }

    @Override
    public void buildMenus(Controller controller, Set<String> plugins) {
        this.buildMenus(controller, plugins, "MindMap", "/xml/mindmapmodemenu.xml");
        this.buildMenus(controller, plugins, "File", "/xml/filemodemenu.xml");
    }

    private void buildMenus(Controller controller, Set<String> plugins, String mode, String xml) {
        ModeController modeController = controller.getModeController(mode);
        controller.selectModeForBuild(modeController);
        modeController.updateMenus(xml, plugins);
        controller.selectModeForBuild(null);
    }

    @Override
    public void createFrame() {
        final Controller controller = Controller.getCurrentController();
        ModeController modeController = controller.getModeController("MindMap");
        controller.selectModeForBuild(modeController);
        EventQueue.invokeLater(new Runnable(){
            private JFrame frame;
            private Container contentPane;

            @Override
            public void run() {
                FreeplaneGUIStarter.this.viewController.init(Controller.getCurrentController());
                controller.selectMode("MindMap");
                this.showFrame();
                FreeplaneGUIStarter.this.loadMaps();
                this.finishStartup();
            }

            private void showFrame() {
                FreeplaneGUIStarter.this.splash.toBack();
                this.frame = (JFrame)FreeplaneGUIStarter.this.viewController.getMenuComponent();
                int extendedState = this.frame.getExtendedState();
                this.contentPane = this.frame.getContentPane();
                this.contentPane.setVisible(false);
                FreeplaneGUIStarter.this.splash.dispose();
                FreeplaneGUIStarter.this.splash = null;
                ToolTipManager.sharedInstance().setDismissDelay(12000);
                this.frame.setVisible(true);
                if (extendedState != this.frame.getExtendedState()) {
                    this.frame.setExtendedState(extendedState);
                }
            }

            private void finishStartup() {
                ExternalMapChangeMonitor.install(controller.getMapViewManager());
                this.focusCurrentView();
                this.contentPane.setVisible(true);
                this.frame.toFront();
                FreeplaneGUIStarter.this.startupFinished = true;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                UITools.executeWhenNodeHasFocus((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FreeplaneGUIStarter.this.fireStartupFinished();
                        MenuUtils.executeMenuItems(FreeplaneGUIStarter.this.options.getMenuItemsToExecute());
                        if (FreeplaneGUIStarter.this.options.shouldStopAfterLaunch()) {
                            System.exit(0);
                        }
                    }
                });
            }

            private void focusCurrentView() {
                MapView currentMapView = (MapView)Controller.getCurrentController().getMapViewManager().getMapViewComponent();
                if (currentMapView != null) {
                    FreeplaneGUIStarter.this.viewController.focusTo(currentMapView);
                }
            }
        });
    }

    private void fireStartupFinished() {
        Controller.getCurrentController().fireStartupFinished();
    }

    private void loadMaps() {
        Controller controller = Controller.getCurrentController();
        boolean alwaysLoadLastMaps = ResourceController.getResourceController().getBooleanProperty("always_load_last_maps");
        if (alwaysLoadLastMaps && !this.dontLoadLastMaps) {
            this.loadLastMaps();
        }
        this.loadMaps(controller, this.options.getFilesToOpenAsArray());
        if (controller.getMap() == null && !alwaysLoadLastMaps && !this.dontLoadLastMaps) {
            AddOnsController addonsController = AddOnsController.getController();
            addonsController.setAutoInstallEnabled(false);
            this.loadLastMaps();
            addonsController.setAutoInstallEnabled(true);
        }
        ModeController modeController = Controller.getCurrentModeController();
        if (this.userPropertiesStatus != UserPropertiesStatus.CURRENT_VERSION_FOUND && !this.dontLoadLastMaps) {
            final String mapSource = ResourceController.getResourceController().getProperty(this.userPropertiesStatus == UserPropertiesStatus.NOT_FOUND ? "tutorial_map" : "latest_features_map");
            final MMapController mapController = (MMapController)modeController.getMapController();
            mapController.newDocumentationMap(mapSource);
            MapModel map = controller.getMap();
            if (null != map) {
                Timer docuMapTimer = new Timer(300, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        mapController.newDocumentationMap(mapSource);
                    }
                });
                docuMapTimer.setRepeats(false);
                docuMapTimer.start();
            }
        }
        if (null != controller.getMap()) {
            return;
        }
        controller.selectMode("MindMap");
        if (ResourceController.getResourceController().getBooleanProperty(CREATE_NEW_MAP_IF_NO_MAPS_ARE_LOADED)) {
            MFileManager.getController(modeController).newMapFromDefaultTemplate();
        }
    }

    private void loadLastMaps() {
        boolean loadLastMap = ResourceController.getResourceController().getBooleanProperty(LOAD_LAST_MAP);
        boolean loadLastMaps = ResourceController.getResourceController().getBooleanProperty(LOAD_LAST_MAPS);
        if (loadLastMaps) {
            this.viewController.openMapsOnStart();
        }
        if (this.userPropertiesStatus == UserPropertiesStatus.CURRENT_VERSION_FOUND && (loadLastMaps || loadLastMap)) {
            this.applicationResourceController.getLastOpenedList().openLastMapOnStart();
        }
    }

    @Override
    public void loadMapsLater(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FreeplaneGUIStarter.this.startupFinished && EventQueue.isDispatchThread()) {
                    FreeplaneGUIStarter.this.loadMaps(Controller.getCurrentController(), args);
                    FreeplaneGUIStarter.this.toFront();
                    return;
                }
                EventQueue.invokeLater(this);
            }
        });
    }

    private void toFront() {
        Frame frame;
        int state;
        Component menuComponent = UITools.getMenuComponent();
        if (menuComponent instanceof Frame && ((state = (frame = (Frame)menuComponent).getExtendedState()) & 1) != 0) {
            frame.setExtendedState(state & 0xFFFFFFFE);
        }
        if (menuComponent instanceof Window) {
            Window window = (Window)menuComponent;
            if (!window.isVisible()) {
                window.setVisible(true);
            }
            window.toFront();
            window.requestFocus();
        }
    }

    private void loadMaps(Controller controller, String[] args) {
        controller.selectMode("MindMap");
        for (int i = 0; i < args.length; ++i) {
            this.loadMap(args[i]);
        }
        MacOptions.macFilesToOpen.forEach(this::loadMap);
    }

    private void loadMap(String fileArgument) {
        try {
            LinkController linkController = LinkController.getController();
            linkController.loadMap(fileArgument);
        }
        catch (Exception ex) {
            System.err.println("File " + fileArgument + " not loaded");
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public ResourceController getResourceController() {
        return this.applicationResourceController;
    }

    static enum UserPropertiesStatus {
        CURRENT_VERSION_FOUND,
        OLD_VERSION_FOUND,
        NOT_FOUND;

    }
}

