/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.CaseSensitiveFileNameExtensionFilter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.export.mindmapmode.XmlImporter;
import org.freeplane.features.mode.Controller;

public class ImportMindmanagerFiles
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public ImportMindmanagerFiles() {
        super("ImportMindmanagerFiles");
    }

    public void actionPerformed(ActionEvent e) {
        int returnVal;
        String type = "mmap";
        Component component = Controller.getCurrentController().getViewController().getCurrentRootComponent();
        JFileChooser chooser = UITools.newFileChooser();
        CaseSensitiveFileNameExtensionFilter filter = new CaseSensitiveFileNameExtensionFilter("mmap", null);
        chooser.setFileFilter((FileFilter)filter);
        chooser.setAcceptAllFileFilterUsed(true);
        File mmFile = Controller.getCurrentController().getMap().getFile();
        if (mmFile != null && mmFile.getParentFile() != null) {
            chooser.setSelectedFile(mmFile.getParentFile());
        }
        if ((returnVal = chooser.showOpenDialog(component)) != 0) {
            return;
        }
        File chosenFile = chooser.getSelectedFile();
        this.importMindmanagerFile(chosenFile);
    }

    private void importMindmanagerFile(File file) {
        try (ZipInputStream in = new ZipInputStream(new FileInputStream(file));){
            while (in.available() != 0) {
                ZipEntry entry = in.getNextEntry();
                if (entry == null) {
                } else {
                    if (!entry.getName().equals("Document.xml")) continue;
                    String xsltFileName = "/xslt/mindmanager2mm.xsl";
                    File outputFile = new File(file.getParent(), file.getName() + ".mm");
                    new XmlImporter("/xslt/mindmanager2mm.xsl").importXml(in, outputFile);
                }
                break;
            }
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
        }
    }
}

